/*!
 * jodit - Jodit is an awesome and useful wysiwyg editor with filebrowser
 * Author: Chupurnov <chupurnov@gmail.com> (https://xdsoft.net/jodit/)
 * Version: v4.2.24
 * Url: https://xdsoft.net/jodit/
 * License(s): MIT
 */
	
(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory(require("{}"));
	else if(typeof define === 'function' && define.amd)
		define(["{}"], factory);
	else {
		var a = typeof exports === 'object' ? factory(require("{}")) : factory(root["{}"]);
		for(var i in a) (typeof exports === 'object' ? exports : root)[i] = a[i];
	}
})(self, function(__WEBPACK_EXTERNAL_MODULE__41324__) {
return /******/ (function() { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ 26318:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Ay: function() { return /* binding */ autobind; }
/* harmony export */ });
/* unused harmony exports boundMethod, boundClass */
function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof = function _typeof(obj) { return typeof obj; };
}
else {
    _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };
} return _typeof(obj); }
/**
 * Return a descriptor removing the value and returning a getter
 * The getter will return a .bind version of the function
 * and memoize the result against a symbol on the instance
 */
function boundMethod(target, key, descriptor) {
    var fn = descriptor.value;
    if (typeof fn !== 'function') {
        throw new TypeError("@boundMethod decorator can only be applied to methods not: ".concat(_typeof(fn)));
    } // In IE11 calling Object.defineProperty has a side-effect of evaluating the
    // getter for the property which is being replaced. This causes infinite
    // recursion and an "Out of stack space" error.
    var definingProperty = false;
    return {
        configurable: true,
        get: function get() {
            // eslint-disable-next-line no-prototype-builtins
            if (definingProperty || this === target.prototype || this.hasOwnProperty(key) || typeof fn !== 'function') {
                return fn;
            }
            var boundFn = fn.bind(this);
            definingProperty = true;
            Object.defineProperty(this, key, {
                configurable: true,
                get: function get() {
                    return boundFn;
                },
                set: function set(value) {
                    fn = value;
                    delete this[key];
                }
            });
            definingProperty = false;
            return boundFn;
        },
        set: function set(value) {
            fn = value;
        }
    };
}
/**
 * Use boundMethod to bind all methods on the target.prototype
 */
function boundClass(target) {
    // (Using reflect to get all keys including symbols)
    var keys; // Use Reflect if exists
    if (typeof Reflect !== 'undefined' && typeof Reflect.ownKeys === 'function') {
        keys = Reflect.ownKeys(target.prototype);
    }
    else {
        keys = Object.getOwnPropertyNames(target.prototype); // Use symbols if support is provided
        if (typeof Object.getOwnPropertySymbols === 'function') {
            keys = keys.concat(Object.getOwnPropertySymbols(target.prototype));
        }
    }
    keys.forEach(function (key) {
        // Ignore special case target method
        if (key === 'constructor') {
            return;
        }
        var descriptor = Object.getOwnPropertyDescriptor(target.prototype, key); // Only methods need binding
        if (typeof descriptor.value === 'function') {
            Object.defineProperty(target.prototype, key, boundMethod(target, key, descriptor));
        }
    });
    return target;
}
function autobind() {
    if (arguments.length === 1) {
        return boundClass.apply(void 0, arguments);
    }
    return boundMethod.apply(void 0, arguments);
}


/***/ }),

/***/ 36115:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   T: function() { return /* binding */ Config; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * Editor options. These can be configured upon the creation of the editor.
 * ```javascript
 * const editor = Jodit.make('#editor', {
 * 	 toolbar: true,
 * 	 buttons: ['bold', 'italic', 'underline']
 * 	 // other options
 * 	 // ...
 * });
 * ```
 * @packageDocumentation
 * @module config
 */


/**
 * Default Editor's Configuration
 */
class Config {
    constructor() {
        /**
         * Use cache for heavy methods
         */
        this.cache = true;
        /**
         * Timeout of all asynchronous methods
         */
        this.defaultTimeout = 100;
        this.namespace = '';
        /**
         * Editor loads completely without plugins. Useful when debugging your own plugin.
         */
        this.safeMode = false;
        /**
         * Editor's width
         *
         * @example
         * ```javascript
         * Jodit.make('.editor', {
         *    width: '100%',
         * })
         * ```
         * @example
         * ```javascript
         * Jodit.make('.editor', {
         *    width: 600, // equivalent for '600px'
         * })
         * ```
         * @example
         * ```javascript
         * Jodit.make('.editor', {
         *    width: 'auto', // autosize
         * })
         * ```
         */
        this.width = 'auto';
        /**
         * Editor's height
         *
         * @example
         * ```javascript
         * Jodit.make('.editor', {
         *    height: '100%',
         * })
         * ```
         * @example
         * ```javascript
         * Jodit.make('.editor', {
         *    height: 600, // equivalent for '600px'
         * })
         * ```
         * @example
         * ```javascript
         * Jodit.make('.editor', {
         *    height: 'auto', // default - autosize
         * })
         * ```
         */
        this.height = 'auto';
        /**
         * List of plugins that will be initialized in safe mode.
         *
         * ```js
         * Jodit.make('#editor', {
         * 	safeMode: true,
         * 	safePluginsList: ['about'],
         * 	extraPlugins: ['yourPluginDev']
         * });
         * ```
         */
        this.safePluginsList = [
            'about',
            'enter',
            'backspace',
            'size',
            'bold',
            'hotkeys'
        ];
        /**
         * Reserved for the paid version of the editor
         */
        this.license = '';
        /**
         * The name of the preset that will be used to initialize the editor.
         * The list of available presets can be found here Jodit.defaultOptions.presets
         * ```javascript
         * Jodit.make('.editor', {
         * 	preset: 'inline'
         * });
         * ```
         */
        this.preset = 'custom';
        this.presets = {
            inline: {
                inline: true,
                toolbar: false,
                toolbarInline: true,
                toolbarInlineForSelection: true,
                showXPathInStatusbar: false,
                showCharsCounter: false,
                showWordsCounter: false,
                showPlaceholder: false
            }
        };
        this.ownerDocument = (typeof document !== 'undefined'
            ? document
            : null);
        /**
         * Allows you to specify the window in which the editor will be created. Default - window
         * This is necessary if you are creating the editor inside an iframe but the code is running in the parent window
         */
        this.ownerWindow = (typeof window !== 'undefined'
            ? window
            : null);
        /**
         * Shadow root if Jodit was created in it
         *
         * ```html
         * <div id="editor"></div>
         * ```
         *
         * ```js
         * const app = document.getElementById('editor');
         * app.attachShadow({ mode: 'open' });
         * const root = app.shadowRoot;
         *
         * root.innerHTML = `
         * <link rel="stylesheet" href="./build/jodit.css"/>
         * <h1>Jodit example in Shadow DOM</h1>
         * <div id="edit"></div>
         * `;
         *
         * const editor = Jodit.make(root.getElementById('edit'), {
         * 	globalFullSize: false,
         * 	shadowRoot: root
         * });
         * editor.value = '<p>start</p>';
         * ```
         */
        this.shadowRoot = null;
        /**
         * z-index For editor
         */
        this.zIndex = 0;
        /**
         * Change the read-only state of the editor
         */
        this.readonly = false;
        /**
         * Change the disabled state of the editor
         */
        this.disabled = false;
        /**
         * In readOnly mode, some buttons can still be useful, for example, the button to view source code or print
         */
        this.activeButtonsInReadOnly = [
            'source',
            'fullsize',
            'print',
            'about',
            'dots',
            'selectall'
        ];
        /**
         * When the editor is in read-only mode, some commands can still be executed:
         * ```javascript
         * const editor = Jodit.make('.editor', {
         * 	 allowCommandsInReadOnly: ['selectall', 'preview', 'print']
         * 	 readonly: true
         * });
         * editor.execCommand('selectall');// will be selected all content
         * editor.execCommand('delete');// but content will not be deleted
         * ```
         */
        this.allowCommandsInReadOnly = ['selectall', 'preview', 'print'];
        /**
         * Size of icons in the toolbar (can be "small", "middle", "large")
         *
         * @example
         * ```javascript
         * const editor = Jodit.make(".dark_editor", {
         *      toolbarButtonSize: "small"
         * });
         * ```
         */
        this.toolbarButtonSize = 'middle';
        /**
         * Allow navigation in the toolbar of the editor by Tab key
         */
        this.allowTabNavigation = false;
        /**
         * Inline editing mode
         */
        this.inline = false;
        /**
         * Theme (can be "dark")
         * @example
         * ```javascript
         * const editor = Jodit.make(".dark_editor", {
         *      theme: "dark"
         * });
         * ```
         */
        this.theme = 'default';
        /**
         * if set true, then the current mode is saved in a cookie, and is restored after a reload of the page
         */
        this.saveModeInStorage = false;
        /**
         * Class name that can be appended to the editable area
         *
         * @see [[Config.iframeCSSLinks]]
         * @see [[Config.iframeStyle]]
         *
         * @example
         * ```javascript
         * Jodit.make('#editor', {
         *    editorClassName: 'some_my_class'
         * });
         * ```
         * ```html
         * <style>
         * .some_my_class p{
         *    line-height: 16px;
         * }
         * </style>
         * ```
         */
        this.editorClassName = false;
        /**
         * Class name that can be appended to the main editor container
         * @example
         * ```javascript
         * const jodit = Jodit.make('#editor', {
         *    className: 'some_my_class'
         * });
         *
         * console.log(jodit.container.classList.contains('some_my_class')); // true
         * ```
         * ```html
         * <style>
         * .some_my_class {
         *    max-width: 600px;
         *    margin: 0 auto;
         * }
         * </style>
         * ```
         */
        this.className = false;
        /**
         * The internal styles of the editable area. They are intended to change
         * not the appearance of the editor, but to change the appearance of the content.
         * @example
         * ```javascript
         * Jodit.make('#editor', {
         * 		style: {
         * 		 font: '12px Arial',
         * 		 color: '#0c0c0c'
         * 		}
         * });
         * ```
         */
        this.style = false;
        /**
         *
         * @example
         * ```javascript
         * Jodit.make('#editor', {
         * 		editorStyle: {
         * 		 font: '12px Arial',
         * 		 color: '#0c0c0c'
         * 		}
         * });
         * ```
         */
        this.containerStyle = false;
        /**
         * Dictionary of variable values in css, a complete list can be found here
         * https://github.com/xdan/jodit/blob/main/src/styles/variables.less#L25
         *
         * @example
         * ```js
         * const editor = Jodit.make('#editor', {
         *   styleValues: {
         *		'color-text': 'red',
         *		colorBorder: 'black',
         *		'color-panel': 'blue'
         *   }
         * });
         * ```
         */
        this.styleValues = {};
        /**
         * After all, changes in editors for textarea will call change trigger
         *
         * @example
         * ```javascript
         * const editor = Jodit.make('#editor');
         * document.getElementById('editor').addEventListener('change', function () {
         *      console.log(this.value);
         * })
         * ```
         */
        this.triggerChangeEvent = true;
        /**
         * The writing direction of the language which is used to create editor content. Allowed values are: ''
         * (an empty string) – Indicates that content direction will be the same as either the editor UI direction or
         * the page element direction. 'ltr' – Indicates a Left-To-Right text direction (like in English).
         * 'rtl' – Indicates a Right-To-Left text direction (like in Arabic).
         *
         * @example
         * ```javascript
         * Jodit.make('.editor', {
         *    direction: 'rtl'
         * })
         * ```
         */
        this.direction = '';
        /**
         * Language by default. if `auto` language set by document.documentElement.lang ||
         * (navigator.language && navigator.language.substr(0, 2)) ||
         * (navigator.browserLanguage && navigator.browserLanguage.substr(0, 2)) || 'en'
         *
         * @example
         * ```html
         * <!-- include in you page lang file -->
         * <script src="jodit/lang/de.js"></script>
         * <script>
         * var editor = Jodit.make('.editor', {
         *    language: 'de'
         * });
         * </script>
         * ```
         */
        this.language = 'auto';
        /**
         * if true all Lang.i18n(key) return `{key}`
         *
         * @example
         * ```html
         * <script>
         * var editor = Jodit.make('.editor', {
         *    debugLanguage: true
         * });
         *
         * console.log(editor.i18n("Test")); // {Test}
         * </script>
         * ```
         */
        this.debugLanguage = false;
        /**
         * Collection of language pack data `{en: {'Type something': 'Type something', ...}}`
         *
         * @example
         * ```javascript
         * const editor = Jodit.make('#editor', {
         *     language: 'ru',
         *     i18n: {
         *         ru: {
         *            'Type something': 'Начните что-либо вводить'
         *         }
         *     }
         * });
         * console.log(editor.i18n('Type something')) //Начните что-либо вводить
         * ```
         */
        this.i18n = false;
        /**
         * The tabindex global attribute is an integer indicating if the element can take
         * input focus (is focusable), if it should participate to sequential keyboard navigation,
         * and if so, at what position. It can take several values
         */
        this.tabIndex = -1;
        /**
         * Boolean, whether the toolbar should be shown.
         * Alternatively, a valid css-selector-string to use an element as toolbar container.
         */
        this.toolbar = true;
        /**
         * Boolean, whether the statusbar should be shown.
         */
        this.statusbar = true;
        /**
         * Show tooltip after mouse enter on the button
         */
        this.showTooltip = true;
        /**
         * Delay before show tooltip
         */
        this.showTooltipDelay = 200;
        /**
         * Instead of create custop tooltip - use native title tooltips
         */
        this.useNativeTooltip = false;
        /**
         * Default insert method
         * @default insert_as_html
         */
        this.defaultActionOnPaste = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INSERT_AS_HTML;
        // TODO
        // autosave: false, // false or url
        // autosaveCallback: false, // function
        // interval: 60, // seconds
        // TODO
        /**
         * Element that will be created when you press Enter
         */
        this.enter = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.PARAGRAPH;
        /**
         * When this option is enabled, the editor's content will be placed in an iframe and isolated from the rest of the page.
         *
         * @example
         * ```javascript
         * Jodit.make('#editor', {
         *    iframe: true,
         *    iframeStyle: 'html{margin: 0px;}body{padding:10px;background:transparent;color:#000;position:relative;z-index:2;\
         *    user-select:auto;margin:0px;overflow:hidden;}body:after{content:"";clear:both;display:block}';
         * });
         * ```
         */
        this.iframe = false;
        /**
         * Allow editing the entire HTML document(html, head)
         * \> Works together with the iframe option.
         * @example
         * ```js
         * const editor = Jodit.make('#editor', {
         *   iframe: true,
         *   editHTMLDocumentMode: true
         * });
         * editor.value = '<!DOCTYPE html><html lang="en" style="overflow-y:hidden">' +
         * 	'<head><title>Jodit Editor</title></head>' +
         * 	'<body spellcheck="false"><p>Some text</p><p> a </p></body>' +
         * 	'</html>';
         * ```
         */
        this.editHTMLDocumentMode = false;
        /**
         * Use when you need to insert new block element
         * use enter option if not set
         */
        this.enterBlock = this.enter !== 'br' ? this.enter : jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.PARAGRAPH;
        /**
         * Jodit.MODE_WYSIWYG The HTML editor allows you to write like MSWord,
         * Jodit.MODE_SOURCE syntax highlighting source editor
         * @example
         * ```javascript
         * var editor = Jodit.make('#editor', {
         *     defaultMode: Jodit.MODE_SPLIT
         * });
         * console.log(editor.getRealMode())
         * ```
         */
        this.defaultMode = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_WYSIWYG;
        /**
         * Use split mode
         */
        this.useSplitMode = false;
        /**
         * The colors in HEX representation to select a color for the background and for the text in colorpicker
         * @example
         * ```javascript
         *  Jodit.make('#editor', {
         *     colors: ['#ff0000', '#00ff00', '#0000ff']
         * })
         * ```
         */
        this.colors = {
            greyscale: [
                '#000000',
                '#434343',
                '#666666',
                '#999999',
                '#B7B7B7',
                '#CCCCCC',
                '#D9D9D9',
                '#EFEFEF',
                '#F3F3F3',
                '#FFFFFF'
            ],
            palette: [
                '#980000',
                '#FF0000',
                '#FF9900',
                '#FFFF00',
                '#00F0F0',
                '#00FFFF',
                '#4A86E8',
                '#0000FF',
                '#9900FF',
                '#FF00FF'
            ],
            full: [
                '#E6B8AF',
                '#F4CCCC',
                '#FCE5CD',
                '#FFF2CC',
                '#D9EAD3',
                '#D0E0E3',
                '#C9DAF8',
                '#CFE2F3',
                '#D9D2E9',
                '#EAD1DC',
                '#DD7E6B',
                '#EA9999',
                '#F9CB9C',
                '#FFE599',
                '#B6D7A8',
                '#A2C4C9',
                '#A4C2F4',
                '#9FC5E8',
                '#B4A7D6',
                '#D5A6BD',
                '#CC4125',
                '#E06666',
                '#F6B26B',
                '#FFD966',
                '#93C47D',
                '#76A5AF',
                '#6D9EEB',
                '#6FA8DC',
                '#8E7CC3',
                '#C27BA0',
                '#A61C00',
                '#CC0000',
                '#E69138',
                '#F1C232',
                '#6AA84F',
                '#45818E',
                '#3C78D8',
                '#3D85C6',
                '#674EA7',
                '#A64D79',
                '#85200C',
                '#990000',
                '#B45F06',
                '#BF9000',
                '#38761D',
                '#134F5C',
                '#1155CC',
                '#0B5394',
                '#351C75',
                '#733554',
                '#5B0F00',
                '#660000',
                '#783F04',
                '#7F6000',
                '#274E13',
                '#0C343D',
                '#1C4587',
                '#073763',
                '#20124D',
                '#4C1130'
            ]
        };
        /**
         * The default tab color picker
         * @example
         * ```javascript
         * Jodit.make('#editor2', {
         *     colorPickerDefaultTab: 'color'
         * })
         * ```
         */
        this.colorPickerDefaultTab = 'background';
        /**
         * Image size defaults to a larger image
         */
        this.imageDefaultWidth = 300;
        /**
         * Do not display these buttons that are on the list
         * @example
         * ```javascript
         * Jodit.make('#editor2', {
         *     removeButtons: ['hr', 'source']
         * });
         * ```
         */
        this.removeButtons = [];
        /**
         * Do not init these plugins
         * @example
         * ```typescript
         * var editor = Jodit.make('.editor', {
         *    disablePlugins: 'table,iframe'
         * });
         * //or
         * var editor = Jodit.make('.editor', {
         *    disablePlugins: ['table', 'iframe']
         * });
         * ```
         */
        this.disablePlugins = [];
        /**
         * Init and download extra plugins
         * @example
         * ```typescript
         * var editor = Jodit.make('.editor', {
         *    extraPlugins: ['emoji']
         * });
         * ```
         * It will try load %SCRIPT_PATH%/plugins/emoji/emoji.js and after load will try init it
         */
        this.extraPlugins = [];
        /**
         * These buttons list will be added to the option. Buttons
         */
        this.extraButtons = [];
        /**
         * By default, you can only install an icon from the Jodit suite.
         * You can add your icon to the set using the `Jodit.modules.Icon.set (name, svg Code)` method.
         * But for a declarative declaration, you can use this option.
         *
         * @example
         * ```js
         * Jodit.modules.Icon.set('someIcon', '<svg><path.../></svg>');
         * const editor = Jodit.make({
         *   extraButtons: [{
         *     name: 'someButton',
         *     icon: 'someIcon'
         *   }]
         * });
         *
         * @example
         * const editor = Jodit.make({
         *   extraIcons: {
         *     someIcon: '<svg><path.../></svg>'
         *   },
         *   extraButtons: [{
         *     name: 'someButton',
         *     icon: 'someIcon'
         *   }]
         * });
         * ```
         * @example
         * ```js
         * const editor = Jodit.make({
         *   extraButtons: [{
         *     name: 'someButton',
         *     icon: '<svg><path.../></svg>'
         *   }]
         * });
         * ```
         */
        this.extraIcons = {};
        /**
         * Default attributes for created inside editor elements
         * @example
         * ```js
         * const editor2 = Jodit.make('#editor', {
         * 	createAttributes: {
         * 		div: {
         * 			class: 'test'
         * 		},
         * 		ul: function (ul) {
         * 			ul.classList.add('ui-test');
         * 		}
         * 	}
         * });
         *
         * const div2 = editor2.createInside.div();
         * expect(div2.className).equals('test');
         *
         * const ul = editor2.createInside.element('ul');
         * expect(ul.className).equals('ui-test');
         * ```
         * Or JSX in React
         * @example
         * ```jsx
         * import React, {useState, useRef} from 'react';
         * import JoditEditor from "jodit-react";
         *
         * const config = {
         * 	createAttributes: {
         * 		div: {
         * 			class: 'align-center'
         * 		}
         * 	}
         * };
         *
         * <JoditEditor config={config}/>
         * ```
         */
        this.createAttributes = {
            table: {
                style: 'border-collapse:collapse;width: 100%;'
            }
        };
        /**
         * The width of the editor, accepted as the biggest. Used to the responsive version of the editor
         */
        this.sizeLG = 900;
        /**
         * The width of the editor, accepted as the medium. Used to the responsive version of the editor
         */
        this.sizeMD = 700;
        /**
         * The width of the editor, accepted as the small. Used to the responsive version of the editor
         */
        this.sizeSM = 400;
        /**
         * The list of buttons that appear in the editor's toolbar on large places (≥ options.sizeLG).
         * Note - this is not the width of the device, the width of the editor
         * @example
         * ```javascript
         * Jodit.make('#editor', {
         *     buttons: ['bold', 'italic', 'source'],
         *     buttonsMD: ['bold', 'italic'],
         *     buttonsXS: ['bold', 'fullsize'],
         * });
         * ```
         * @example
         * ```javascript
         * Jodit.make('#editor2', {
         *     buttons: [{
         *         name: 'empty',
         *         icon: 'source',
         *         exec: function (editor) {
         *             const dialog = new Jodit.modules.Dialog({}),
         *                 text = editor.c.element('textarea');
         *
         *             dialog.setHeader('Source code');
         *             dialog.setContent(text);
         *             dialog.setSize(400, 300);
         *
         *             Jodit.modules.Helpers.css(elm, {
         *                 width: '100%',
         *                 height: '100%'
         *             })
    
         *             dialog.open();
         *         }
         *     }]
         * });
         * ```
         * @example
         * ```javascript
         * Jodit.make('#editor2', {
         *     buttons: Jodit.defaultOptions.buttons.concat([{
         *        name: 'listsss',
         *        iconURL: 'stuf/dummy.png',
         *        list: {
         *            h1: 'insert Header 1',
         *            h2: 'insert Header 2',
         *            clear: 'Empty editor',
         *        },
         *        exec: ({originalEvent, control, btn}) => {
         *             var key = control.args[0],
         *                value = control.args[1];
         *             if (key === 'clear') {
         *                 this.val('');
         *                 return;
         *             }
         *             this.s.insertNode(this.c.element(key, ''));
         *             this.message.info('Was inserted ' + value);
         *        },
         *        template: function (key, value) {
         *            return '<div>' + value + '</div>';
         *        }
         *  });
         * ```
         */
        this.buttons = [
            {
                group: 'font-style',
                buttons: []
            },
            {
                group: 'list',
                buttons: []
            },
            {
                group: 'font',
                buttons: []
            },
            '---',
            {
                group: 'script',
                buttons: []
            },
            {
                group: 'media',
                buttons: []
            },
            '\n',
            {
                group: 'state',
                buttons: []
            },
            {
                group: 'clipboard',
                buttons: []
            },
            {
                group: 'insert',
                buttons: []
            },
            {
                group: 'indent',
                buttons: []
            },
            {
                group: 'color',
                buttons: []
            },
            {
                group: 'form',
                buttons: []
            },
            '---',
            {
                group: 'history',
                buttons: []
            },
            {
                group: 'search',
                buttons: []
            },
            {
                group: 'source',
                buttons: []
            },
            {
                group: 'other',
                buttons: []
            },
            {
                group: 'info',
                buttons: []
            }
        ];
        /**
         * Some events are called when the editor is initialized, for example, the `afterInit` event.
         * So this code won't work:
         * ```javascript
         * const editor = Jodit.make('#editor');
         * editor.events.on('afterInit', () => console.log('afterInit'));
         * ```
         * You need to do this:
         * ```javascript
         * Jodit.make('#editor', {
         * 		events: {
         * 	  	afterInit: () => console.log('afterInit')
         * 		}
         * });
         * ```
         * The option can use any Jodit events, for example:
         * ```javascript
         * const editor = Jodit.make('#editor', {
         * 		events: {
         * 			hello: (name) => console.log('Hello', name)
         * 		}
         * });
         * editor.e.fire('hello', 'Mike');
         * ```
         */
        this.events = {};
        /**
         * Buttons in toolbat without SVG - only texts
         */
        this.textIcons = false;
        /**
         * shows a INPUT[type=color] to open the browser color picker, on the right bottom of widget color picker
         */
        this.showBrowserColorPicker = true;
    }
    static get defaultOptions() {
        if (!Config.__defaultOptions) {
            Config.__defaultOptions = new Config();
        }
        return Config.__defaultOptions;
    }
}
Config.prototype.controls = {};



/***/ }),

/***/ 86302:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   j: function() { return /* binding */ Async; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_helpers_async__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(59146);
/* harmony import */ var jodit_core_helpers_checker_is_abort_error__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(99951);
/* harmony import */ var jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(69052);
/* harmony import */ var jodit_core_helpers_checker_is_number__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(2461);
/* harmony import */ var jodit_core_helpers_checker_is_plain_object__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(25376);
/* harmony import */ var jodit_core_helpers_checker_is_promise__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(92039);
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(98253);
/* harmony import */ var jodit_core_helpers_checker_is_void__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(35642);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(28712);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var jodit_core_helpers_utils_error_errors_abort_error__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(21567);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */











class Async {
    constructor() {
        var _a, _b, _c, _d, _e;
        this.timers = new Map();
        this.__callbacks = new Map();
        this.__queueMicrotaskNative = (_a = queueMicrotask === null || queueMicrotask === void 0 ? void 0 : queueMicrotask.bind(window)) !== null && _a !== void 0 ? _a : Promise.resolve().then.bind(Promise.resolve());
        this.promisesRejections = new Set();
        this.requestsIdle = new Set();
        this.requestsRaf = new Set();
        this.requestIdleCallbackNative = (_c = (_b = window['requestIdleCallback']) === null || _b === void 0 ? void 0 : _b.bind(window)) !== null && _c !== void 0 ? _c : ((callback, options) => {
            var _a;
            const start = Date.now();
            return this.setTimeout(() => {
                callback({
                    didTimeout: false,
                    timeRemaining: () => Math.max(0, 50 - (Date.now() - start))
                });
            }, (_a = options === null || options === void 0 ? void 0 : options.timeout) !== null && _a !== void 0 ? _a : 1);
        });
        this.__cancelIdleCallbackNative = (_e = (_d = window['cancelIdleCallback']) === null || _d === void 0 ? void 0 : _d.bind(window)) !== null && _e !== void 0 ? _e : ((request) => {
            this.clearTimeout(request);
        });
        this.isDestructed = false;
    }
    delay(timeout) {
        return this.promise(resolve => this.setTimeout(resolve, timeout));
    }
    setTimeout(callback, timeout, ...args) {
        if (this.isDestructed) {
            return 0;
        }
        let options = {};
        if ((0,jodit_core_helpers_checker_is_void__WEBPACK_IMPORTED_MODULE_2__/* .isVoid */ .R)(timeout)) {
            timeout = 0;
        }
        if (!(0,jodit_core_helpers_checker_is_number__WEBPACK_IMPORTED_MODULE_3__/* .isNumber */ .E)(timeout)) {
            options = timeout;
            timeout = options.timeout || 0;
        }
        if (options.label) {
            this.clearLabel(options.label);
        }
        const timer = (0,jodit_core_helpers_async__WEBPACK_IMPORTED_MODULE_4__/* .setTimeout */ .w)(callback, timeout, ...args), key = options.label || timer;
        this.timers.set(key, timer);
        this.__callbacks.set(key, callback);
        return timer;
    }
    updateTimeout(label, timeout) {
        void 0;
        if (!label || !this.timers.has(label)) {
            return null;
        }
        const callback = this.__callbacks.get(label);
        void 0;
        return this.setTimeout(callback, { label, timeout });
    }
    clearLabel(label) {
        if (label && this.timers.has(label)) {
            (0,jodit_core_helpers_async__WEBPACK_IMPORTED_MODULE_4__/* .clearTimeout */ .D)(this.timers.get(label));
            this.timers.delete(label);
            this.__callbacks.delete(label);
        }
    }
    clearTimeout(timerOrLabel) {
        if ((0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_5__/* .isString */ .K)(timerOrLabel)) {
            return this.clearLabel(timerOrLabel);
        }
        (0,jodit_core_helpers_async__WEBPACK_IMPORTED_MODULE_4__/* .clearTimeout */ .D)(timerOrLabel);
        this.timers.delete(timerOrLabel);
        this.__callbacks.delete(timerOrLabel);
    }
    /**
     * Debouncing enforces that a function not be called again until a certain amount of time has passed without
     * it being called. As in "execute this function only if 100 milliseconds have passed without it being called."
     *
     * @example
     * ```javascript
     * var jodit = Jodit.make('.editor');
     * jodit.e.on('mousemove', jodit.async.debounce(() => {
     * 	// Do expensive things
     * }, 100));
     * ```
     */
    debounce(fn, timeout, firstCallImmediately = false) {
        let timer = 0, fired = false;
        const promises = [];
        const callFn = (...args) => {
            if (!fired) {
                timer = 0;
                const res = fn(...args);
                fired = true;
                if (promises.length) {
                    const runPromises = () => {
                        promises.forEach(res => res());
                        promises.length = 0;
                    };
                    (0,jodit_core_helpers_checker_is_promise__WEBPACK_IMPORTED_MODULE_6__/* .isPromise */ .y)(res) ? res.finally(runPromises) : runPromises();
                }
            }
        };
        const onFire = (...args) => {
            fired = false;
            if (!timeout) {
                callFn(...args);
            }
            else {
                if (!timer && firstCallImmediately) {
                    callFn(...args);
                }
                (0,jodit_core_helpers_async__WEBPACK_IMPORTED_MODULE_4__/* .clearTimeout */ .D)(timer);
                timer = this.setTimeout(() => callFn(...args), (0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_7__/* .isFunction */ .T)(timeout) ? timeout() : timeout);
                this.timers.set(fn, timer);
            }
        };
        return (0,jodit_core_helpers_checker_is_plain_object__WEBPACK_IMPORTED_MODULE_8__/* .isPlainObject */ .Q)(timeout) && timeout.promisify
            ? (...args) => {
                const promise = this.promise(res => {
                    promises.push(res);
                }).catch((e) => {
                    if ((0,jodit_core_helpers_checker_is_abort_error__WEBPACK_IMPORTED_MODULE_9__/* .isAbortError */ .z)(e)) {
                        return null;
                    }
                    throw e;
                });
                onFire(...args);
                return promise;
            }
            : onFire;
    }
    microDebounce(fn, firstCallImmediately = false) {
        let scheduled = false;
        let needCall = true;
        let savedArgs;
        return ((...args) => {
            savedArgs = args;
            if (scheduled) {
                needCall = true;
                return;
            }
            needCall = true;
            if (firstCallImmediately) {
                needCall = false;
                fn(...savedArgs);
            }
            scheduled = true;
            this.__queueMicrotaskNative(() => {
                scheduled = false;
                if (this.isDestructed) {
                    return;
                }
                needCall && fn(...savedArgs);
            });
        });
    }
    /**
     * Throttling enforces a maximum number of times a function can be called over time.
     * As in "execute this function at most once every 100 milliseconds."
     *
     * @example
     * ```javascript
     * var jodit = Jodit.make('.editor');
     * jodit.e.on(document.body, 'scroll', jodit.async.throttle(function() {
     * 	// Do expensive things
     * }, 100));
     * ```
     */
    throttle(fn, timeout, ignore = false) {
        let timer = null, needInvoke, callee, lastArgs;
        return (...args) => {
            needInvoke = true;
            lastArgs = args;
            if (!timeout) {
                fn(...lastArgs);
                return;
            }
            if (!timer) {
                callee = () => {
                    if (needInvoke) {
                        fn(...lastArgs);
                        needInvoke = false;
                        timer = this.setTimeout(callee, (0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_7__/* .isFunction */ .T)(timeout) ? timeout() : timeout);
                        this.timers.set(callee, timer);
                    }
                    else {
                        timer = null;
                    }
                };
                callee();
            }
        };
    }
    promise(executor) {
        let rejectCallback = () => { };
        const promise = new Promise((resolve, reject) => {
            rejectCallback = () => reject((0,jodit_core_helpers_utils_error_errors_abort_error__WEBPACK_IMPORTED_MODULE_10__/* .abort */ .h)('Abort async'));
            this.promisesRejections.add(rejectCallback);
            executor(resolve, reject);
        });
        if (!promise.finally && typeof process !== 'undefined' && !jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_ES_NEXT) {
            promise.finally = (onfinally) => {
                promise.then(onfinally).catch(onfinally);
                return promise;
            };
        }
        promise
            .finally(() => {
            this.promisesRejections.delete(rejectCallback);
        })
            .catch(() => null);
        promise.rejectCallback = rejectCallback;
        return promise;
    }
    /**
     * Get Promise status
     */
    promiseState(p) {
        if (p.status) {
            return p.status;
        }
        // Hi IE11
        if (!Promise.race) {
            return new Promise(resolve => {
                p.then(v => {
                    resolve('fulfilled');
                    return v;
                }, e => {
                    resolve('rejected');
                    throw e;
                });
                this.setTimeout(() => {
                    resolve('pending');
                }, 100);
            });
        }
        const t = {};
        return Promise.race([p, t]).then(v => (v === t ? 'pending' : 'fulfilled'), () => 'rejected');
    }
    requestIdleCallback(callback, options) {
        const request = this.requestIdleCallbackNative(callback, options);
        this.requestsIdle.add(request);
        return request;
    }
    requestIdlePromise(options) {
        return this.promise(res => {
            const request = this.requestIdleCallback(() => res(request), options);
        });
    }
    cancelIdleCallback(request) {
        this.requestsIdle.delete(request);
        return this.__cancelIdleCallbackNative(request);
    }
    requestAnimationFrame(callback) {
        const request = requestAnimationFrame(callback);
        this.requestsRaf.add(request);
        return request;
    }
    cancelAnimationFrame(request) {
        this.requestsRaf.delete(request);
        cancelAnimationFrame(request);
    }
    clear() {
        this.requestsIdle.forEach(key => this.cancelIdleCallback(key));
        this.requestsRaf.forEach(key => this.cancelAnimationFrame(key));
        this.timers.forEach(key => (0,jodit_core_helpers_async__WEBPACK_IMPORTED_MODULE_4__/* .clearTimeout */ .D)(this.timers.get(key)));
        this.timers.clear();
        this.promisesRejections.forEach(reject => reject());
        this.promisesRejections.clear();
    }
    destruct() {
        this.clear();
        this.isDestructed = true;
    }
}


/***/ }),

/***/ 64890:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   j: function() { return /* reexport safe */ _async__WEBPACK_IMPORTED_MODULE_0__.j; }
/* harmony export */ });
/* harmony import */ var _async__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(86302);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module async
 */



/***/ }),

/***/ 37474:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   u: function() { return /* binding */ Component; }
/* harmony export */ });
/* harmony import */ var jodit_core_async__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(64890);
/* harmony import */ var jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(64567);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(65147);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */




const StatusListHandlers = new Map();
/**
 * The base class of all Jodit UI components. Provides work with a life cycle.
 */
class Component {
    get componentName() {
        if (!this.__componentName) {
            this.__componentName =
                'jodit-' +
                    (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.kebabCase)(((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isFunction)(this.className) ? this.className() : '') ||
                        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.getClassName)(this));
        }
        return this.__componentName;
    }
    getFullElName(elementName, mod, modValue) {
        const result = [this.componentName];
        if (elementName) {
            elementName = elementName.replace(/[^a-z0-9-]/gi, '-');
            result.push(`__${elementName}`);
        }
        if (mod) {
            result.push('_', mod);
            result.push('_', (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isVoid)(modValue) ? 'true' : modValue.toString());
        }
        return result.join('');
    }
    /**
     * The document in which jodit was created
     */
    get ownerDocument() {
        return this.ow.document;
    }
    /**
     * Shortcut for `this.ownerDocument`
     */
    get od() {
        return this.ownerDocument;
    }
    get ow() {
        return this.ownerWindow;
    }
    /**
     * Safe get any field
     * @example
     * ```js
     * private a = {
     * 	b: {
     * 		c: {
     * 			e: {
     * 				g: {
     * 					color: 'red'
     * 				}
     * 			}
     * 		}
     * 	}
     * }
     *
     * this.get('a.b.c.e.g.color'); // Safe access to color
     * // instead using optionsl chaining
     * this?.a?.b?.c?.e?.g?.color
     * ```
     *
     * @param chain - the path to be traversed in the obj object
     * @param obj - the object in which the value is searched
     */
    get(chain, obj) {
        return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.get)(chain, obj || this);
    }
    /**
     * Component is ready for work
     */
    get isReady() {
        return this.componentStatus === jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_1__/* .STATUSES */ .f.ready;
    }
    /**
     * Component was destructed
     */
    get isDestructed() {
        return this.componentStatus === jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_1__/* .STATUSES */ .f.destructed;
    }
    /**
     * The component is currently undergoing destructuring or has already been destroyed.
     * Those. you should not the app froze new events on him now or do anything else with him.
     */
    get isInDestruct() {
        return (jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_1__/* .STATUSES */ .f.beforeDestruct === this.componentStatus ||
            jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_1__/* .STATUSES */ .f.destructed === this.componentStatus);
    }
    /**
     * Bind destructor to some View
     */
    bindDestruct(component) {
        component.hookStatus(jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_1__/* .STATUSES */ .f.beforeDestruct, () => !this.isInDestruct && this.destruct());
        return this;
    }
    constructor() {
        this.async = new jodit_core_async__WEBPACK_IMPORTED_MODULE_0__/* .Async */ .j();
        /**
         * The window in which jodit was created
         */
        this.ownerWindow = window;
        this.__componentStatus = jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_1__/* .STATUSES */ .f.beforeInit;
        this.uid = 'jodit-uid-' + (0,jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .uniqueUid */ .w9)();
    }
    /**
     * Destruct component method
     */
    destruct() {
        this.setStatus(jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_1__/* .STATUSES */ .f.destructed);
        if (this.async) {
            this.async.destruct();
            // @ts-ignore
            this.async = undefined;
        }
        if (StatusListHandlers.get(this)) {
            StatusListHandlers.delete(this);
        }
        // @ts-ignore
        this.ownerWindow = undefined;
    }
    /**
     * Current component status
     */
    get componentStatus() {
        return this.__componentStatus;
    }
    /**
     * Setter for current component status
     */
    set componentStatus(componentStatus) {
        this.setStatus(componentStatus);
    }
    /**
     * Set component status
     * @param componentStatus - component status
     * @see ComponentStatus
     */
    setStatus(componentStatus) {
        return this.setStatusComponent(componentStatus, this);
    }
    /**
     * Set status recursively on all parents
     */
    setStatusComponent(componentStatus, component) {
        if (componentStatus === this.__componentStatus) {
            return;
        }
        if (component === this) {
            this.__componentStatus = componentStatus;
        }
        const proto = Object.getPrototypeOf(this);
        if (proto && (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isFunction)(proto.setStatusComponent)) {
            proto.setStatusComponent(componentStatus, component);
        }
        const statuses = StatusListHandlers.get(this), list = statuses === null || statuses === void 0 ? void 0 : statuses[componentStatus];
        if (list && list.length) {
            list.forEach(cb => cb(component));
        }
    }
    /**
     * Adds a handler for changing the component's status
     *
     * @param status - the status at which the callback is triggered
     * @param callback - a function that will be called when the status is `status`
     */
    hookStatus(status, callback) {
        let list = StatusListHandlers.get(this);
        if (!list) {
            list = {};
            StatusListHandlers.set(this, list);
        }
        if (!list[status]) {
            list[status] = [];
        }
        list[status].push(callback);
    }
    static isInstanceOf(c, constructorFunc) {
        return c instanceof constructorFunc;
    }
}
Component.STATUSES = jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_1__/* .STATUSES */ .f;


/***/ }),

/***/ 77753:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   f: function() { return /* reexport safe */ _statuses__WEBPACK_IMPORTED_MODULE_1__.f; },
/* harmony export */   uA: function() { return /* reexport safe */ _component__WEBPACK_IMPORTED_MODULE_0__.u; },
/* harmony export */   vG: function() { return /* reexport safe */ _view_component__WEBPACK_IMPORTED_MODULE_2__.v; }
/* harmony export */ });
/* harmony import */ var _component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(37474);
/* harmony import */ var _statuses__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(64567);
/* harmony import */ var _view_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(7982);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module component
 */





/***/ }),

/***/ 64567:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   f: function() { return /* binding */ STATUSES; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module component
 */
const STATUSES = {
    beforeInit: 'beforeInit',
    ready: 'ready',
    beforeDestruct: 'beforeDestruct',
    destructed: 'destructed'
};


/***/ }),

/***/ 7982:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   v: function() { return /* binding */ ViewComponent; }
/* harmony export */ });
/* harmony import */ var _component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(37474);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

class ViewComponent extends _component__WEBPACK_IMPORTED_MODULE_0__/* .Component */ .u {
    /**
     * Shortcut for `this.jodit`
     */
    get j() {
        return this.jodit;
    }
    get defaultTimeout() {
        return this.j.defaultTimeout;
    }
    i18n(text, ...params) {
        return this.j.i18n(text, ...params);
    }
    /**
     * Attach component to View
     */
    setParentView(jodit) {
        this.jodit = jodit;
        jodit.components.add(this);
        return this;
    }
    constructor(jodit) {
        super();
        this.setParentView(jodit);
    }
    /** @override */
    destruct() {
        this.j.components.delete(this);
        return super.destruct();
    }
}


/***/ }),

/***/ 17352:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ACCURACY: function() { return /* binding */ ACCURACY; },
/* harmony export */   APP_VERSION: function() { return /* binding */ APP_VERSION; },
/* harmony export */   BASE_PATH: function() { return /* binding */ BASE_PATH; },
/* harmony export */   BR: function() { return /* binding */ BR; },
/* harmony export */   CLIPBOARD_ID: function() { return /* binding */ CLIPBOARD_ID; },
/* harmony export */   COMMAND_KEYS: function() { return /* binding */ COMMAND_KEYS; },
/* harmony export */   EMULATE_DBLCLICK_TIMEOUT: function() { return /* binding */ EMULATE_DBLCLICK_TIMEOUT; },
/* harmony export */   ES: function() { return /* binding */ ES; },
/* harmony export */   FAT_MODE: function() { return /* binding */ FAT_MODE; },
/* harmony export */   HOMEPAGE: function() { return /* binding */ HOMEPAGE; },
/* harmony export */   INSEPARABLE_TAGS: function() { return /* binding */ INSEPARABLE_TAGS; },
/* harmony export */   INSERT_AS_HTML: function() { return /* binding */ INSERT_AS_HTML; },
/* harmony export */   INSERT_AS_TEXT: function() { return /* binding */ INSERT_AS_TEXT; },
/* harmony export */   INSERT_CLEAR_HTML: function() { return /* binding */ INSERT_CLEAR_HTML; },
/* harmony export */   INSERT_ONLY_TEXT: function() { return /* binding */ INSERT_ONLY_TEXT; },
/* harmony export */   INVISIBLE_SPACE: function() { return /* binding */ INVISIBLE_SPACE; },
/* harmony export */   INVISIBLE_SPACE_REG_EXP: function() { return /* binding */ INVISIBLE_SPACE_REG_EXP; },
/* harmony export */   INVISIBLE_SPACE_REG_EXP_END: function() { return /* binding */ INVISIBLE_SPACE_REG_EXP_END; },
/* harmony export */   INVISIBLE_SPACE_REG_EXP_START: function() { return /* binding */ INVISIBLE_SPACE_REG_EXP_START; },
/* harmony export */   IS_BLOCK: function() { return /* binding */ IS_BLOCK; },
/* harmony export */   IS_ES_MODERN: function() { return /* binding */ IS_ES_MODERN; },
/* harmony export */   IS_ES_NEXT: function() { return /* binding */ IS_ES_NEXT; },
/* harmony export */   IS_IE: function() { return /* binding */ IS_IE; },
/* harmony export */   IS_INLINE: function() { return /* binding */ IS_INLINE; },
/* harmony export */   IS_MAC: function() { return /* binding */ IS_MAC; },
/* harmony export */   IS_PROD: function() { return /* binding */ IS_PROD; },
/* harmony export */   IS_TEST: function() { return /* binding */ IS_TEST; },
/* harmony export */   KEY_ALIASES: function() { return /* binding */ KEY_ALIASES; },
/* harmony export */   KEY_ALT: function() { return /* binding */ KEY_ALT; },
/* harmony export */   KEY_BACKSPACE: function() { return /* binding */ KEY_BACKSPACE; },
/* harmony export */   KEY_DELETE: function() { return /* binding */ KEY_DELETE; },
/* harmony export */   KEY_DOWN: function() { return /* binding */ KEY_DOWN; },
/* harmony export */   KEY_ENTER: function() { return /* binding */ KEY_ENTER; },
/* harmony export */   KEY_ESC: function() { return /* binding */ KEY_ESC; },
/* harmony export */   KEY_F3: function() { return /* binding */ KEY_F3; },
/* harmony export */   KEY_LEFT: function() { return /* binding */ KEY_LEFT; },
/* harmony export */   KEY_META: function() { return /* binding */ KEY_META; },
/* harmony export */   KEY_RIGHT: function() { return /* binding */ KEY_RIGHT; },
/* harmony export */   KEY_SPACE: function() { return /* binding */ KEY_SPACE; },
/* harmony export */   KEY_TAB: function() { return /* binding */ KEY_TAB; },
/* harmony export */   KEY_UP: function() { return /* binding */ KEY_UP; },
/* harmony export */   LIST_TAGS: function() { return /* binding */ LIST_TAGS; },
/* harmony export */   MARKER_CLASS: function() { return /* binding */ MARKER_CLASS; },
/* harmony export */   MODE_SOURCE: function() { return /* binding */ MODE_SOURCE; },
/* harmony export */   MODE_SPLIT: function() { return /* binding */ MODE_SPLIT; },
/* harmony export */   MODE_WYSIWYG: function() { return /* binding */ MODE_WYSIWYG; },
/* harmony export */   NBSP_SPACE: function() { return /* binding */ NBSP_SPACE; },
/* harmony export */   NEARBY: function() { return /* binding */ NEARBY; },
/* harmony export */   NO_EMPTY_TAGS: function() { return /* binding */ NO_EMPTY_TAGS; },
/* harmony export */   PARAGRAPH: function() { return /* binding */ PARAGRAPH; },
/* harmony export */   PASSIVE_EVENTS: function() { return /* binding */ PASSIVE_EVENTS; },
/* harmony export */   SAFE_COUNT_CHANGE_CALL: function() { return /* binding */ SAFE_COUNT_CHANGE_CALL; },
/* harmony export */   SET_TEST: function() { return /* binding */ SET_TEST; },
/* harmony export */   SOURCE_CONSUMER: function() { return /* binding */ SOURCE_CONSUMER; },
/* harmony export */   SPACE_REG_EXP: function() { return /* binding */ SPACE_REG_EXP; },
/* harmony export */   SPACE_REG_EXP_END: function() { return /* binding */ SPACE_REG_EXP_END; },
/* harmony export */   SPACE_REG_EXP_START: function() { return /* binding */ SPACE_REG_EXP_START; },
/* harmony export */   TEMP_ATTR: function() { return /* binding */ TEMP_ATTR; },
/* harmony export */   TEXT_HTML: function() { return /* binding */ TEXT_HTML; },
/* harmony export */   TEXT_PLAIN: function() { return /* binding */ TEXT_PLAIN; },
/* harmony export */   TEXT_RTF: function() { return /* binding */ TEXT_RTF; },
/* harmony export */   TOKENS: function() { return /* binding */ TOKENS; },
/* harmony export */   lang: function() { return /* binding */ lang; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
const APP_VERSION = "4.2.24";
// prettier-ignore
const ES = "es2015";
const IS_ES_MODERN = true;
const IS_ES_NEXT = false;
const IS_PROD = true;
let IS_TEST = false;
const FAT_MODE = false;
const HOMEPAGE = "https://xdsoft.net/jodit/";
const SET_TEST = () => (IS_TEST = true);
const TOKENS = {};
const INVISIBLE_SPACE = '\uFEFF';
const NBSP_SPACE = '\u00A0';
const INVISIBLE_SPACE_REG_EXP = () => /[\uFEFF]/g;
const INVISIBLE_SPACE_REG_EXP_END = () => /[\uFEFF]+$/g;
const INVISIBLE_SPACE_REG_EXP_START = () => /^[\uFEFF]+/g;
const SPACE_REG_EXP = () => /[\s\n\t\r\uFEFF\u200b]+/g;
const SPACE_REG_EXP_START = () => /^[\s\n\t\r\uFEFF\u200b]+/g;
const SPACE_REG_EXP_END = () => /[\s\n\t\r\uFEFF\u200b]+$/g;
const IS_BLOCK = /^(ADDRESS|ARTICLE|ASIDE|BLOCKQUOTE|CANVAS|DD|DFN|DIV|DL|DT|FIELDSET|FIGCAPTION|FIGURE|FOOTER|FORM|H[1-6]|HEADER|HGROUP|HR|LI|MAIN|NAV|NOSCRIPT|OUTPUT|P|PRE|RUBY|SCRIPT|STYLE|OBJECT|OL|SECTION|IFRAME|JODIT|JODIT-MEDIA|UL|TR|TD|TH|TBODY|THEAD|TFOOT|TABLE|BODY|HTML|VIDEO)$/i;
const IS_INLINE = /^(STRONG|SPAN|I|EM|B|SUP|SUB|A|U)$/i;
const LIST_TAGS = new Set(['ul', 'ol']);
const __UNSEPARABLE_TAGS = [
    'img',
    'video',
    'svg',
    'iframe',
    'script',
    'input',
    'textarea',
    'link',
    'jodit',
    'jodit-media'
];
const INSEPARABLE_TAGS = new Set([
    ...__UNSEPARABLE_TAGS,
    'br',
    'hr'
]);
const NO_EMPTY_TAGS = new Set(__UNSEPARABLE_TAGS);
const KEY_META = 'Meta';
const KEY_BACKSPACE = 'Backspace';
const KEY_TAB = 'Tab';
const KEY_ENTER = 'Enter';
const KEY_ESC = 'Escape';
const KEY_ALT = 'Alt';
const KEY_LEFT = 'ArrowLeft';
const KEY_UP = 'ArrowUp';
const KEY_RIGHT = 'ArrowRight';
const KEY_DOWN = 'ArrowDown';
const KEY_SPACE = 'Space';
const KEY_DELETE = 'Delete';
const KEY_F3 = 'F3';
const NEARBY = 5;
const ACCURACY = 10;
const COMMAND_KEYS = [
    KEY_META,
    KEY_BACKSPACE,
    KEY_DELETE,
    KEY_UP,
    KEY_DOWN,
    KEY_RIGHT,
    KEY_LEFT,
    KEY_ENTER,
    KEY_ESC,
    KEY_F3,
    KEY_TAB
];
const BR = 'br';
const PARAGRAPH = 'p';
/**
 * WYSIWYG editor mode
 */
const MODE_WYSIWYG = 1;
/**
 * html editor mode
 */
const MODE_SOURCE = 2;
/**
 * Source code editor and HTML editor both like
 * @see http://getuikit.com/docs/htmleditor.html|this
 */
const MODE_SPLIT = 3;
/**
 * Is Internet Explorer
 */
const IS_IE = typeof navigator !== 'undefined' &&
    (navigator.userAgent.indexOf('MSIE') !== -1 ||
        /rv:11.0/i.test(navigator.userAgent));
/**
 * For IE11 it will be 'text'. Need for dataTransfer.setData
 */
const TEXT_PLAIN = IS_IE ? 'text' : 'text/plain';
const TEXT_HTML = IS_IE ? 'html' : 'text/html';
const TEXT_RTF = IS_IE ? 'rtf' : 'text/rtf';
const MARKER_CLASS = 'jodit-selection_marker';
const EMULATE_DBLCLICK_TIMEOUT = 300;
/**
 * Paste the copied text as HTML, all content will be pasted exactly as it was on the clipboard.
 * So how would you copy its code directly into the source document.
 * ```
 * <h1 style="color:red">test</h1>
 * ```
 * Will be inserted into the document as
 * ```
 * <h1 style="color:red">test</h1>
 * ```
 */
const INSERT_AS_HTML = 'insert_as_html';
/**
 * Same as [[INSERT_AS_HTML]], but content will be stripped of extra styles and empty tags
 * ```html
 * <h1 style="color:red">test</h1>
 * ```
 * Will be inserted into the document as
 * ```html
 * <h1>test</h1>
 * ```
 */
const INSERT_CLEAR_HTML = 'insert_clear_html';
/**
 * The contents of the clipboard will be pasted into the document as plain text, i.e. all tags will be displayed as text.
 * ```html
 * <h1>test</h1>
 * ```
 * Will be inserted into the document as
 * ```html
 * &gt;&lt;h1&gt;test&lt;/h1&gt;
 * ```
 */
const INSERT_AS_TEXT = 'insert_as_text';
/**
 * All tags will be stripped:
 * ```html
 * <h1>test</h1>
 * ```
 * Will be inserted into the document as
 * ```html
 * test
 * ```
 */
const INSERT_ONLY_TEXT = 'insert_only_text';
const SAFE_COUNT_CHANGE_CALL = 10;
const IS_MAC = typeof window !== 'undefined' &&
    /Mac|iPod|iPhone|iPad/.test(window.navigator.platform);
const KEY_ALIASES = {
    add: '+',
    break: 'pause',
    cmd: 'meta',
    command: 'meta',
    ctl: 'control',
    ctrl: 'control',
    del: 'delete',
    down: 'arrowdown',
    esc: 'escape',
    ins: 'insert',
    left: 'arrowleft',
    mod: IS_MAC ? 'meta' : 'control',
    opt: 'alt',
    option: 'alt',
    return: 'enter',
    right: 'arrowright',
    space: ' ',
    spacebar: ' ',
    up: 'arrowup',
    win: 'meta',
    windows: 'meta'
};
const BASE_PATH = (() => {
    if (typeof document === 'undefined') {
        return '';
    }
    const script = document.currentScript, removeScriptName = (s) => {
        const parts = s.split('/');
        if (/\.js/.test(parts[parts.length - 1])) {
            return parts.slice(0, parts.length - 1).join('/') + '/';
        }
        return s;
    };
    if (script) {
        return removeScriptName(script.src);
    }
    const scripts = document.querySelectorAll('script[src]');
    if (scripts && scripts.length) {
        return removeScriptName(scripts[scripts.length - 1].src);
    }
    return window.location.href;
})();
const TEMP_ATTR = 'data-jodit-temp';
const lang = {};
const CLIPBOARD_ID = 'clipboard';
const SOURCE_CONSUMER = 'source-consumer';
const PASSIVE_EVENTS = new Set([
    'touchstart',
    'touchend',
    'scroll',
    'mousewheel',
    'mousemove',
    'touchmove'
]);


/***/ }),

/***/ 92852:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   X: function() { return /* binding */ Create; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(28712);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_3__);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */




class Create {
    get doc() {
        // @ts-ignore - TODO it's a function
        return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.isFunction)(this.document) ? this.document() : this.document;
    }
    constructor(document, createAttributes) {
        this.document = document;
        this.createAttributes = createAttributes;
    }
    element(tagName, childrenOrAttributes, children) {
        const elm = this.doc.createElement(tagName.toLowerCase());
        this.applyCreateAttributes(elm);
        if (childrenOrAttributes) {
            if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.isPlainObject)(childrenOrAttributes)) {
                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.attr)(elm, childrenOrAttributes);
            }
            else {
                children = childrenOrAttributes;
            }
        }
        if (children) {
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.asArray)(children).forEach((child) => elm.appendChild((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.isString)(child) ? this.fromHTML(child) : child));
        }
        return elm;
    }
    div(className, childrenOrAttributes, children) {
        const div = this.element('div', childrenOrAttributes, children);
        if (className) {
            div.className = className;
        }
        return div;
    }
    sandbox() {
        var _a;
        const iframe = this.element('iframe', { sandbox: 'allow-same-origin' });
        this.doc.body.appendChild(iframe);
        const doc = (_a = iframe.contentWindow) === null || _a === void 0 ? void 0 : _a.document;
        void 0;
        if (!doc) {
            throw Error('Iframe error');
        }
        doc.open();
        doc.write('<!DOCTYPE html><html><head></head><body></body></html>');
        doc.close();
        return [doc.body, iframe];
    }
    span(className, childrenOrAttributes, children) {
        const span = this.element('span', childrenOrAttributes, children);
        if (className) {
            span.className = className;
        }
        return span;
    }
    a(className, childrenOrAttributes, children) {
        const a = this.element('a', childrenOrAttributes, children);
        if (className) {
            a.className = className;
        }
        return a;
    }
    /**
     * Create text node
     */
    text(value) {
        return this.doc.createTextNode(value);
    }
    /**
     * Create invisible text node
     */
    fake() {
        return this.text(jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INVISIBLE_SPACE);
    }
    /**
     * Create HTML Document fragment element
     */
    fragment() {
        return this.doc.createDocumentFragment();
    }
    /**
     * Create a DOM element from HTML text
     *
     // eslint-disable-next-line tsdoc/syntax
     * @param refsToggleElement - State dictionary in which you can set the visibility of some of the elements
     * ```js
     * const editor = Jodit.make('#editor');
     * editor.createInside.fromHTML(`<div>
     *   <input name="name" ref="name"/>
     *   <input name="email" ref="email"/>
     * </div>`, {
     *   name: true,
     *   email: false
     * });
     * ```
     */
    fromHTML(html, refsToggleElement) {
        const div = this.div();
        div.innerHTML = html.toString();
        const child = div.firstChild !== div.lastChild || !div.firstChild
            ? div
            : div.firstChild;
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.safeRemove(child);
        if (refsToggleElement) {
            const refElements = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.refs)(child);
            Object.keys(refsToggleElement).forEach(key => {
                const elm = refElements[key];
                if (elm && refsToggleElement[key] === false) {
                    jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.hide(elm);
                }
            });
        }
        return child;
    }
    /**
     * Apply to element `createAttributes` options
     */
    applyCreateAttributes(elm) {
        if (this.createAttributes) {
            const ca = this.createAttributes;
            if (ca && ca[elm.tagName.toLowerCase()]) {
                const attrsOpt = ca[elm.tagName.toLowerCase()];
                if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.isFunction)(attrsOpt)) {
                    attrsOpt(elm);
                }
                else if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.isPlainObject)(attrsOpt)) {
                    (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.attr)(elm, attrsOpt);
                }
            }
        }
    }
}


/***/ }),

/***/ 40594:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   X: function() { return /* reexport safe */ _create__WEBPACK_IMPORTED_MODULE_0__.X; }
/* harmony export */ });
/* harmony import */ var _create__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(92852);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module create
 */



/***/ }),

/***/ 11961:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   d: function() { return /* reexport safe */ autobind_decorator__WEBPACK_IMPORTED_MODULE_0__.Ay; }
/* harmony export */ });
/* harmony import */ var autobind_decorator__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(26318);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * [[include:core/decorators/autobind/README.md]]
 * @packageDocumentation
 * @module decorators/autobind
 */



/***/ }),

/***/ 87875:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   OK: function() { return /* binding */ cacheHTML; },
/* harmony export */   PO: function() { return /* binding */ cached; },
/* harmony export */   PP: function() { return /* binding */ cache; }
/* harmony export */ });
/* harmony import */ var jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(64567);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9823);
/* harmony import */ var jodit_core_helpers_utils_error_error__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(76166);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */




function cached(object, property) {
    const descriptor = Object.getOwnPropertyDescriptor(object, property);
    if (!descriptor || (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__/* .isFunction */ .Tn)(descriptor.get)) {
        return null;
    }
    return descriptor.value;
}
function cache(_, name, descriptor) {
    const getter = descriptor.get;
    if (!getter) {
        throw (0,jodit_core_helpers_utils_error_error__WEBPACK_IMPORTED_MODULE_3__/* .error */ .z3)('Getter property descriptor expected');
    }
    descriptor.get = function () {
        const value = getter.call(this);
        if (value && value.noCache === true) {
            return value;
        }
        Object.defineProperty(this, name, {
            configurable: descriptor.configurable,
            enumerable: descriptor.enumerable,
            writable: false,
            value
        });
        return value;
    };
}
function cacheHTML(target, _, descriptor) {
    const fn = descriptor.value;
    if (!(0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__/* .isFunction */ .Tn)(fn)) {
        throw (0,jodit_core_helpers_utils_error_error__WEBPACK_IMPORTED_MODULE_3__/* .error */ .z3)('Handler must be a Function');
    }
    let useCache = true;
    const cached = new WeakMap();
    descriptor.value = function (...attrs) {
        var _a;
        if (useCache && cached.has(this.constructor)) {
            return (_a = cached.get(this.constructor)) === null || _a === void 0 ? void 0 : _a.cloneNode(true);
        }
        const value = fn.apply(this, attrs);
        if (useCache && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isElement(value)) {
            cached.set(this.constructor, value);
        }
        return useCache ? value.cloneNode(true) : value;
    };
    target.hookStatus(jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_0__/* .STATUSES */ .f.ready, (component) => {
        const view = (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__/* .isViewObject */ .hH)(component)
            ? component
            : component.jodit;
        useCache = Boolean(view.options.cache);
    });
}


/***/ }),

/***/ 24767:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   s: function() { return /* binding */ component; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * Decorate components and set status isReady after constructor
 * @param constructorFunction - Component constructor class
 */
function component(constructorFunction) {
    class newConstructorFunction extends constructorFunction {
        constructor(...args) {
            super(...args);
            const isRootConstructor = this.constructor === newConstructorFunction;
            // We can add a decorator to multiple classes in a chain.
            // Status should be set only as root
            if (isRootConstructor) {
                // In some es/minimizer builds, JS instantiates the original class rather than the new constructor
                if (!(this instanceof newConstructorFunction)) {
                    Object.setPrototypeOf(this, newConstructorFunction.prototype);
                }
                this.setStatus('ready');
            }
        }
    }
    return newConstructorFunction;
}


/***/ }),

/***/ 37075:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   n: function() { return /* binding */ throttle; },
/* harmony export */   s: function() { return /* binding */ debounce; }
/* harmony export */ });
/* harmony import */ var jodit_core_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(77753);
/* harmony import */ var jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(9823);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(28712);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var jodit_core_helpers_utils_error__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(50156);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */




function debounce(timeout, firstCallImmediately = false, method = 'debounce') {
    return (target, propertyKey) => {
        const fn = target[propertyKey];
        if (!(0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_1__/* .isFunction */ .Tn)(fn)) {
            throw (0,jodit_core_helpers_utils_error__WEBPACK_IMPORTED_MODULE_3__/* .error */ .z3)('Handler must be a Function');
        }
        target.hookStatus(jodit_core_component__WEBPACK_IMPORTED_MODULE_0__/* .STATUSES */ .f.ready, (component) => {
            const { async } = component;
            void 0;
            const propTimeout = (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_1__/* .isFunction */ .Tn)(timeout)
                ? timeout(component)
                : timeout;
            const realTimout = (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_1__/* .isNumber */ .Et)(propTimeout) || (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_1__/* .isPlainObject */ .Qd)(propTimeout)
                ? propTimeout
                : component.defaultTimeout;
            Object.defineProperty(component, propertyKey, {
                configurable: true,
                value: async[method](component[propertyKey].bind(component), realTimout, firstCallImmediately)
            });
        });
        return {
            configurable: true,
            get() {
                return fn.bind(this);
            }
        };
    };
}
/**
 * Wrap function in throttle wrapper
 */
function throttle(timeout, firstCallImmediately = false) {
    return debounce(timeout, firstCallImmediately, 'throttle');
}


/***/ }),

/***/ 1963:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   C: function() { return /* binding */ derive; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(69052);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * [[include:core/decorators/derive/README.md]]
 * @packageDocumentation
 * @module decorators/derive
 */

function derive(...traits) {
    return (target) => {
        const origin = target.prototype;
        for (let i = 0; i < traits.length; i++) {
            const trait = traits[i];
            const keys = Object.getOwnPropertyNames(trait.prototype);
            for (let j = 0; j < keys.length; j++) {
                const key = keys[j], method = Object.getOwnPropertyDescriptor(trait.prototype, key);
                const canDerive = method != null &&
                    (0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_0__/* .isFunction */ .T)(method.value) &&
                    !(0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_0__/* .isFunction */ .T)(origin[key]);
                if (canDerive) {
                    Object.defineProperty(origin, key, {
                        enumerable: true,
                        configurable: true,
                        writable: true,
                        value: function (...args) {
                            return method.value.call(this, ...args);
                        }
                    });
                }
            }
        }
    };
}


/***/ }),

/***/ 71151:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: function() { return /* binding */ hook; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(69052);
/* harmony import */ var jodit_core_helpers_utils_error__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(50156);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


/**
 * Call on some component status
 */
function hook(status) {
    return (target, propertyKey) => {
        if (!(0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_1__/* .isFunction */ .T)(target[propertyKey])) {
            throw (0,jodit_core_helpers_utils_error__WEBPACK_IMPORTED_MODULE_0__/* .error */ .z3)('Handler must be a Function');
        }
        target.hookStatus(status, (component) => {
            component[propertyKey].call(component);
        });
    };
}


/***/ }),

/***/ 86285:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   N: function() { return /* binding */ idle; }
/* harmony export */ });
/* harmony import */ var jodit_core_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(77753);
/* harmony import */ var jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(69052);
/* harmony import */ var jodit_core_helpers_utils_error__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(50156);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



function idle() {
    return (target, propertyKey) => {
        if (!(0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_2__/* .isFunction */ .T)(target[propertyKey])) {
            throw (0,jodit_core_helpers_utils_error__WEBPACK_IMPORTED_MODULE_1__/* .error */ .z3)('Handler must be a Function');
        }
        target.hookStatus(jodit_core_component__WEBPACK_IMPORTED_MODULE_0__/* .STATUSES */ .f.ready, (component) => {
            const { async } = component;
            const originalMethod = component[propertyKey];
            component[propertyKey] = (...args) => async.requestIdleCallback(originalMethod.bind(component, ...args));
        });
    };
}


/***/ }),

/***/ 22664:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   autobind: function() { return /* reexport safe */ _autobind_autobind__WEBPACK_IMPORTED_MODULE_0__.d; },
/* harmony export */   cache: function() { return /* reexport safe */ _cache_cache__WEBPACK_IMPORTED_MODULE_1__.PP; },
/* harmony export */   cacheHTML: function() { return /* reexport safe */ _cache_cache__WEBPACK_IMPORTED_MODULE_1__.OK; },
/* harmony export */   cached: function() { return /* reexport safe */ _cache_cache__WEBPACK_IMPORTED_MODULE_1__.PO; },
/* harmony export */   component: function() { return /* reexport safe */ _component_component__WEBPACK_IMPORTED_MODULE_2__.s; },
/* harmony export */   debounce: function() { return /* reexport safe */ _debounce_debounce__WEBPACK_IMPORTED_MODULE_3__.s; },
/* harmony export */   derive: function() { return /* reexport safe */ _derive_derive__WEBPACK_IMPORTED_MODULE_4__.C; },
/* harmony export */   getPropertyDescriptor: function() { return /* reexport safe */ _watch_watch__WEBPACK_IMPORTED_MODULE_10__.N; },
/* harmony export */   hook: function() { return /* reexport safe */ _hook_hook__WEBPACK_IMPORTED_MODULE_5__.A; },
/* harmony export */   idle: function() { return /* reexport safe */ _idle_idle__WEBPACK_IMPORTED_MODULE_6__.N; },
/* harmony export */   nonenumerable: function() { return /* reexport safe */ _nonenumerable_nonenumerable__WEBPACK_IMPORTED_MODULE_7__.m; },
/* harmony export */   persistent: function() { return /* reexport safe */ _persistent_persistent__WEBPACK_IMPORTED_MODULE_8__.y; },
/* harmony export */   throttle: function() { return /* reexport safe */ _debounce_debounce__WEBPACK_IMPORTED_MODULE_3__.n; },
/* harmony export */   wait: function() { return /* reexport safe */ _wait_wait__WEBPACK_IMPORTED_MODULE_9__.u; },
/* harmony export */   watch: function() { return /* reexport safe */ _watch_watch__WEBPACK_IMPORTED_MODULE_10__.w; }
/* harmony export */ });
/* harmony import */ var _autobind_autobind__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(11961);
/* harmony import */ var _cache_cache__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(87875);
/* harmony import */ var _component_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(24767);
/* harmony import */ var _debounce_debounce__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(37075);
/* harmony import */ var _derive_derive__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(1963);
/* harmony import */ var _hook_hook__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(71151);
/* harmony import */ var _idle_idle__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(86285);
/* harmony import */ var _nonenumerable_nonenumerable__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(48791);
/* harmony import */ var _persistent_persistent__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(33087);
/* harmony import */ var _wait_wait__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(48647);
/* harmony import */ var _watch_watch__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(66927);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * [[include:core/decorators/README.md]]
 * @packageDocumentation
 * @module decorators
 */













/***/ }),

/***/ 48791:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   m: function() { return /* binding */ nonenumerable; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * [[include:core/decorators/nonenumerable/README.md]]
 * @packageDocumentation
 * @module decorators/nonenumerable
 */
const nonenumerable = (target, propertyKey) => {
    const descriptor = Object.getOwnPropertyDescriptor(target, propertyKey) || {};
    if (descriptor.enumerable !== false) {
        Object.defineProperty(target, propertyKey, {
            enumerable: false,
            set(value) {
                Object.defineProperty(this, propertyKey, {
                    enumerable: false,
                    writable: true,
                    value
                });
            }
        });
    }
};


/***/ }),

/***/ 33087:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   y: function() { return /* binding */ persistent; }
/* harmony export */ });
/* harmony import */ var jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(64567);
/* harmony import */ var jodit_core_helpers_checker_is_view_object__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(12041);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


function persistent(target, propertyKey) {
    target.hookStatus(jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_0__/* .STATUSES */ .f.ready, (component) => {
        const jodit = (0,jodit_core_helpers_checker_is_view_object__WEBPACK_IMPORTED_MODULE_1__/* .isViewObject */ .h)(component)
            ? component
            : component.jodit, storageKey = `${jodit.options.namespace}${component.componentName}_prop_${propertyKey}`, initialValue = component[propertyKey];
        Object.defineProperty(component, propertyKey, {
            get() {
                var _a;
                return (_a = jodit.storage.get(storageKey)) !== null && _a !== void 0 ? _a : initialValue;
            },
            set(value) {
                jodit.storage.set(storageKey, value);
            }
        });
    });
}


/***/ }),

/***/ 48647:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   u: function() { return /* binding */ wait; }
/* harmony export */ });
/* harmony import */ var jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(64567);
/* harmony import */ var jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(69052);
/* harmony import */ var jodit_core_helpers_utils_error__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(50156);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



function wait(condition) {
    return (target, propertyKey) => {
        const fn = target[propertyKey];
        if (!(0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_2__/* .isFunction */ .T)(fn)) {
            throw (0,jodit_core_helpers_utils_error__WEBPACK_IMPORTED_MODULE_1__/* .error */ .z3)('Handler must be a Function');
        }
        target.hookStatus(jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_0__/* .STATUSES */ .f.ready, (component) => {
            const { async } = component;
            const realMethod = component[propertyKey];
            let timeout = 0;
            Object.defineProperty(component, propertyKey, {
                configurable: true,
                value: function callProxy(...args) {
                    async.clearTimeout(timeout);
                    if (condition(component)) {
                        realMethod.apply(component, args);
                    }
                    else {
                        timeout = async.setTimeout(() => callProxy(...args), 10);
                    }
                }
            });
        });
    };
}


/***/ }),

/***/ 66927:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   N: function() { return /* binding */ getPropertyDescriptor; },
/* harmony export */   w: function() { return /* binding */ watch; }
/* harmony export */ });
/* harmony import */ var jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(64567);
/* harmony import */ var jodit_core_event_emitter_observable__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(32332);
/* harmony import */ var jodit_core_helpers_array_split_array__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(42589);
/* harmony import */ var jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(69052);
/* harmony import */ var jodit_core_helpers_checker_is_plain_object__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(25376);
/* harmony import */ var jodit_core_helpers_checker_is_view_object__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(12041);
/* harmony import */ var jodit_core_helpers_utils_error__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(50156);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */







function getPropertyDescriptor(obj, prop) {
    let desc;
    do {
        desc = Object.getOwnPropertyDescriptor(obj, prop);
        obj = Object.getPrototypeOf(obj);
    } while (!desc && obj);
    return desc;
}
/**
 * Watch decorator. Added observer for some change in field value
 */
function watch(observeFields, opts) {
    return (target, propertyKey) => {
        var _a;
        if (!(0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_3__/* .isFunction */ .T)(target[propertyKey])) {
            throw (0,jodit_core_helpers_utils_error__WEBPACK_IMPORTED_MODULE_2__/* .error */ .z3)('Handler must be a Function');
        }
        const immediately = (_a = opts === null || opts === void 0 ? void 0 : opts.immediately) !== null && _a !== void 0 ? _a : true;
        const context = opts === null || opts === void 0 ? void 0 : opts.context;
        const process = (component) => {
            const view = (0,jodit_core_helpers_checker_is_view_object__WEBPACK_IMPORTED_MODULE_4__/* .isViewObject */ .h)(component)
                ? component
                : component.jodit;
            let callback = (key, ...args) => {
                if (component.isInDestruct) {
                    return;
                }
                return component[propertyKey](key, ...args);
            };
            if (!immediately) {
                callback = component.async.microDebounce(callback, true);
            }
            (0,jodit_core_helpers_array_split_array__WEBPACK_IMPORTED_MODULE_5__/* .splitArray */ .u)(observeFields).forEach(field => {
                if (/:/.test(field)) {
                    const [objectPath, eventName] = field.split(':');
                    let ctx = context;
                    if (objectPath.length) {
                        // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
                        ctx = component.get(objectPath);
                    }
                    if ((0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_3__/* .isFunction */ .T)(ctx)) {
                        ctx = ctx(component);
                    }
                    view.events.on(ctx || component, eventName, callback);
                    if (!ctx) {
                        view.events.on(eventName, callback);
                    }
                    component.hookStatus('beforeDestruct', () => {
                        view.events
                            .off(ctx || component, eventName, callback)
                            .off(eventName, callback);
                    });
                    return;
                }
                const parts = field.split('.'), [key] = parts, teil = parts.slice(1);
                let value = component[key];
                if ((0,jodit_core_helpers_checker_is_plain_object__WEBPACK_IMPORTED_MODULE_6__/* .isPlainObject */ .Q)(value)) {
                    const observableValue = (0,jodit_core_event_emitter_observable__WEBPACK_IMPORTED_MODULE_1__/* .observable */ .s)(value);
                    observableValue.on(`change.${teil.join('.')}`, callback);
                }
                const descriptor = getPropertyDescriptor(target, key);
                Object.defineProperty(component, key, {
                    configurable: true,
                    set(v) {
                        const oldValue = value;
                        if (oldValue === v) {
                            return;
                        }
                        value = v;
                        if (descriptor && descriptor.set) {
                            descriptor.set.call(component, v);
                        }
                        if ((0,jodit_core_helpers_checker_is_plain_object__WEBPACK_IMPORTED_MODULE_6__/* .isPlainObject */ .Q)(value)) {
                            value = (0,jodit_core_event_emitter_observable__WEBPACK_IMPORTED_MODULE_1__/* .observable */ .s)(value);
                            value.on(`change.${teil.join('.')}`, callback);
                        }
                        callback(key, oldValue, value);
                    },
                    get() {
                        if (descriptor && descriptor.get) {
                            return descriptor.get.call(component);
                        }
                        return value;
                    }
                });
            });
        };
        if ((0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_3__/* .isFunction */ .T)(target.hookStatus)) {
            target.hookStatus(jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_0__/* .STATUSES */ .f.ready, process);
        }
        else {
            process(target);
        }
    };
}


/***/ }),

/***/ 55186:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   J: function() { return /* binding */ Dom; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_helpers_array_to_array__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(42448);
/* harmony import */ var jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9823);
/* harmony import */ var jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(59101);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(97369);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */






/**
 * Module for working with DOM
 */
class Dom {
    constructor() {
        throw new Error('Dom is static module');
    }
    /**
     * Remove all content from element
     */
    static detach(node) {
        while (node && node.firstChild) {
            node.removeChild(node.firstChild);
        }
    }
    /**
     * Wrap all inline siblings
     */
    static wrapInline(current, tag, editor) {
        let tmp, first = current, last = current;
        editor.s.save();
        let needFindNext = false;
        do {
            needFindNext = false;
            tmp = first.previousSibling;
            if (tmp && !Dom.isBlock(tmp)) {
                needFindNext = true;
                first = tmp;
            }
        } while (needFindNext);
        do {
            needFindNext = false;
            tmp = last.nextSibling;
            if (tmp && !Dom.isBlock(tmp)) {
                needFindNext = true;
                last = tmp;
            }
        } while (needFindNext);
        const wrapper = (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__/* .isString */ .Kg)(tag) ? editor.createInside.element(tag) : tag;
        if (first.parentNode) {
            first.parentNode.insertBefore(wrapper, first);
        }
        let next = first;
        while (next) {
            next = first.nextSibling;
            wrapper.appendChild(first);
            if (first === last || !next) {
                break;
            }
            first = next;
        }
        editor.s.restore();
        return wrapper;
    }
    /**
     * Wrap node inside another node
     */
    static wrap(current, tag, create) {
        const wrapper = (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__/* .isString */ .Kg)(tag) ? create.element(tag) : tag;
        if (Dom.isNode(current)) {
            if (!current.parentNode) {
                throw (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__.error)('Element should be in DOM');
            }
            current.parentNode.insertBefore(wrapper, current);
            wrapper.appendChild(current);
        }
        else {
            const fragment = current.extractContents();
            current.insertNode(wrapper);
            wrapper.appendChild(fragment);
        }
        return wrapper;
    }
    /**
     * Remove parent of node and insert this node instead that parent
     */
    static unwrap(node) {
        const parent = node.parentNode;
        if (parent) {
            while (node.firstChild) {
                parent.insertBefore(node.firstChild, node);
            }
            Dom.safeRemove(node);
        }
    }
    /**
     * Call functions for all nodes between `start` and `end`
     */
    static between(start, end, callback) {
        let next = start;
        while (next && next !== end) {
            if (start !== next && callback(next)) {
                break;
            }
            let step = next.firstChild || next.nextSibling;
            if (!step) {
                while (next && !next.nextSibling) {
                    next = next.parentNode;
                }
                step = next === null || next === void 0 ? void 0 : next.nextSibling;
            }
            next = step;
        }
    }
    static replace(elm, newTagName, create, withAttributes = false, notMoveContent = false) {
        if ((0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__/* .isHTML */ .AH)(newTagName)) {
            newTagName = create.fromHTML(newTagName);
        }
        const tag = (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__/* .isString */ .Kg)(newTagName)
            ? create.element(newTagName)
            : newTagName;
        if (!notMoveContent) {
            while (elm.firstChild) {
                tag.appendChild(elm.firstChild);
            }
        }
        if (withAttributes && Dom.isElement(elm) && Dom.isElement(tag)) {
            (0,jodit_core_helpers_array_to_array__WEBPACK_IMPORTED_MODULE_1__/* .toArray */ .$)(elm.attributes).forEach(attr => {
                tag.setAttribute(attr.name, attr.value);
            });
        }
        if (elm.parentNode) {
            elm.parentNode.replaceChild(tag, elm);
        }
        return tag;
    }
    /**
     * Checks whether the Node text and blank (in this case it may contain invisible auxiliary characters ,
     * it is also empty )
     *
     * @param node - The element of wood to be checked
     */
    static isEmptyTextNode(node) {
        return (Dom.isText(node) &&
            (!node.nodeValue ||
                node.nodeValue
                    .replace(jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INVISIBLE_SPACE_REG_EXP(), '')
                    .trim().length === 0));
    }
    static isEmptyContent(node) {
        return Dom.each(node, (elm) => Dom.isEmptyTextNode(elm));
    }
    /**
     * The node is editable
     */
    static isContentEditable(node, root) {
        return (Dom.isNode(node) &&
            !Dom.closest(node, elm => Dom.isElement(elm) &&
                elm.getAttribute('contenteditable') === 'false', root));
    }
    static isEmpty(node, condNoEmptyElement = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.NO_EMPTY_TAGS) {
        if (!node) {
            return true;
        }
        let cond;
        if (!(0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__/* .isFunction */ .Tn)(condNoEmptyElement)) {
            cond = (elm) => condNoEmptyElement.has(elm.nodeName.toLowerCase());
        }
        else {
            cond = condNoEmptyElement;
        }
        const emptyText = (node) => node.nodeValue == null || (0,jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_3__/* .trim */ .Bq)(node.nodeValue).length === 0;
        if (Dom.isText(node)) {
            return emptyText(node);
        }
        return (!(Dom.isElement(node) && cond(node)) &&
            Dom.each(node, (elm) => {
                if ((Dom.isText(elm) && !emptyText(elm)) ||
                    (Dom.isElement(elm) && cond(elm))) {
                    return false;
                }
            }));
    }
    /**
     * Returns true if it is a DOM node
     */
    static isNode(object) {
        // Duck-typing
        return Boolean(object &&
            (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__/* .isString */ .Kg)(object.nodeName) &&
            typeof object.nodeType === 'number' &&
            object.childNodes &&
            (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__/* .isFunction */ .Tn)(object.appendChild));
    }
    /**
     *  Check if element is table cell
     */
    static isCell(elm) {
        return (Dom.isNode(elm) && (elm.nodeName === 'TD' || elm.nodeName === 'TH'));
    }
    /**
     * Check if element is a list	element UL or OL
     */
    static isList(elm) {
        return Dom.isTag(elm, jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.LIST_TAGS);
    }
    /**
     * Check if element is a part of list	element LI
     */
    static isLeaf(elm) {
        return Dom.isTag(elm, 'li');
    }
    /**
     * Check is element is Image element
     */
    static isImage(elm) {
        return (Dom.isNode(elm) && /^(img|svg|picture|canvas)$/i.test(elm.nodeName));
    }
    /**
     * Check the `node` is a block element
     * @param node - Object to check
     */
    static isBlock(node) {
        return (!(0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__/* .isVoid */ .Rd)(node) &&
            typeof node === 'object' &&
            Dom.isNode(node) &&
            jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_BLOCK.test(node.nodeName));
    }
    /**
     * Check if element is text node
     */
    static isText(node) {
        return Boolean(node && node.nodeType === Node.TEXT_NODE);
    }
    /**
     * Check if element is comment node
     */
    static isComment(node) {
        return Boolean(node && node.nodeType === Node.COMMENT_NODE);
    }
    /**
     * Check if element is element node
     */
    static isElement(node) {
        var _a;
        if (!Dom.isNode(node)) {
            return false;
        }
        const win = (_a = node.ownerDocument) === null || _a === void 0 ? void 0 : _a.defaultView;
        return Boolean(win && node.nodeType === Node.ELEMENT_NODE);
    }
    /**
     * Check if element is document fragment
     */
    static isFragment(node) {
        var _a;
        if (!Dom.isNode(node)) {
            return false;
        }
        const win = (_a = node.ownerDocument) === null || _a === void 0 ? void 0 : _a.defaultView;
        return Boolean(win && node.nodeType === Node.DOCUMENT_FRAGMENT_NODE);
    }
    /**
     * Check if element is HTMLElement node
     */
    static isHTMLElement(node) {
        var _a;
        if (!Dom.isNode(node)) {
            return false;
        }
        const win = (_a = node.ownerDocument) === null || _a === void 0 ? void 0 : _a.defaultView;
        return Boolean(win && node instanceof win.HTMLElement);
    }
    /**
     * Check element is inline block
     */
    static isInlineBlock(node) {
        return (Dom.isElement(node) &&
            !/^(BR|HR)$/i.test(node.tagName) &&
            ['inline', 'inline-block'].indexOf((0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__.css)(node, 'display').toString()) !== -1);
    }
    /**
     * It's block and it can be split
     */
    static canSplitBlock(node) {
        return (!(0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__/* .isVoid */ .Rd)(node) &&
            Dom.isHTMLElement(node) &&
            Dom.isBlock(node) &&
            !/^(TD|TH|CAPTION|FORM)$/.test(node.nodeName) &&
            node.style !== undefined &&
            !/^(fixed|absolute)/i.test(node.style.position));
    }
    /**
     * Get last matched node inside root
     */
    static last(root, condition) {
        let last = root === null || root === void 0 ? void 0 : root.lastChild;
        if (!last) {
            return null;
        }
        do {
            if (condition(last)) {
                return last;
            }
            let next = last.lastChild;
            if (!next) {
                next = last.previousSibling;
            }
            if (!next && last.parentNode !== root) {
                do {
                    last = last.parentNode;
                } while (last &&
                    !(last === null || last === void 0 ? void 0 : last.previousSibling) &&
                    last.parentNode !== root);
                next = last === null || last === void 0 ? void 0 : last.previousSibling;
            }
            last = next;
        } while (last);
        return null;
    }
    /**
     * Find previous node
     */
    static prev(node, condition, root, withChild = true) {
        return Dom.find(node, condition, root, false, withChild);
    }
    /**
     * Find next node what `condition(next) === true`
     */
    static next(node, condition, root, withChild = true) {
        return Dom.find(node, condition, root, true, withChild);
    }
    static prevWithClass(node, className) {
        return Dom.prev(node, node => {
            return (Dom.isElement(node) && node.classList.contains(className));
        }, node.parentNode);
    }
    static nextWithClass(node, className) {
        return Dom.next(node, elm => Dom.isElement(elm) && elm.classList.contains(className), node.parentNode);
    }
    /**
     * Find next/prev node what `condition(next) === true`
     */
    static find(node, condition, root, leftToRight = true, withChild = true) {
        const gen = this.nextGen(node, root, leftToRight, withChild);
        let item = gen.next();
        while (!item.done) {
            if (condition(item.value)) {
                return item.value;
            }
            item = gen.next();
        }
        return null;
    }
    /**
     * Find next/prev node what `condition(next) === true`
     */
    static *nextGen(start, root, leftToRight = true, withChild = true) {
        const stack = [];
        let currentNode = start;
        do {
            let next = leftToRight
                ? currentNode.nextSibling
                : currentNode.previousSibling;
            while (next) {
                stack.unshift(next);
                next = leftToRight ? next.nextSibling : next.previousSibling;
            }
            yield* this.runInStack(start, stack, leftToRight, withChild);
            currentNode = currentNode.parentNode;
        } while (currentNode && currentNode !== root);
        return null;
    }
    /**
     * It goes through all the internal elements of the node, causing a callback function
     *
     * @param elm - the element whose children and descendants you want to iterate over
     * @param callback - It called for each item found
     * @example
     * ```javascript
     * Jodit.modules.Dom.each(editor.s.current(), function (node) {
     *  if (node.nodeType === Node.TEXT_NODE) {
     *      node.nodeValue = node.nodeValue.replace(Jodit.INVISIBLE_SPACE_REG_EX, '') // remove all of the text element codes invisible character
     *  }
     * });
     * ```
     */
    static each(elm, callback, leftToRight = true) {
        const gen = this.eachGen(elm, leftToRight);
        let item = gen.next();
        while (!item.done) {
            if (callback(item.value) === false) {
                return false;
            }
            item = gen.next();
        }
        return true;
    }
    static eachGen(root, leftToRight = true) {
        return this.runInStack(root, [root], leftToRight);
    }
    static *runInStack(start, stack, leftToRight, withChild = true) {
        while (stack.length) {
            const item = stack.pop();
            if (withChild) {
                let child = leftToRight ? item.lastChild : item.firstChild;
                while (child) {
                    stack.push(child);
                    child = leftToRight
                        ? child.previousSibling
                        : child.nextSibling;
                }
            }
            if (start !== item) {
                yield item;
            }
        }
    }
    /**
     * Find next/prev node what `condition(next) === true`
     */
    static findWithCurrent(node, condition, root, sibling = 'nextSibling', child = 'firstChild') {
        let next = node;
        do {
            if (condition(next)) {
                return next || null;
            }
            if (child && next && next[child]) {
                const nextOne = Dom.findWithCurrent(next[child], condition, next, sibling, child);
                if (nextOne) {
                    return nextOne;
                }
            }
            while (next && !next[sibling] && next !== root) {
                next = next.parentNode;
            }
            if (next && next[sibling] && next !== root) {
                next = next[sibling];
            }
        } while (next && next !== root);
        return null;
    }
    /**
     * Get not empty sibling
     */
    static findSibling(node, left = true, cond = (n) => !Dom.isEmptyTextNode(n)) {
        let sibling = Dom.sibling(node, left);
        while (sibling && !cond(sibling)) {
            sibling = Dom.sibling(sibling, left);
        }
        return sibling && cond(sibling) ? sibling : null;
    }
    /**
     * Returns the nearest non-empty sibling
     */
    static findNotEmptySibling(node, left) {
        return Dom.findSibling(node, left, n => {
            var _a;
            return (!Dom.isEmptyTextNode(n) &&
                Boolean(!Dom.isText(n) || (((_a = n.nodeValue) === null || _a === void 0 ? void 0 : _a.length) && (0,jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_3__/* .trim */ .Bq)(n.nodeValue))));
        });
    }
    /**
     * Returns the nearest non-empty neighbor
     */
    static findNotEmptyNeighbor(node, left, root) {
        return (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__.call)(left ? Dom.prev : Dom.next, node, n => Boolean(n &&
            (!(Dom.isText(n) || Dom.isComment(n)) ||
                (0,jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_3__/* .trim */ .Bq)((n === null || n === void 0 ? void 0 : n.nodeValue) || '').length)), root);
    }
    static sibling(node, left) {
        return left ? node.previousSibling : node.nextSibling;
    }
    /**
     * It goes through all the elements in ascending order, and checks to see if they meet the predetermined condition
     */
    static up(node, condition, root, checkRoot = false) {
        let start = node;
        if (!start) {
            return null;
        }
        do {
            if (condition(start)) {
                return start;
            }
            if (start === root || !start.parentNode) {
                break;
            }
            start = start.parentNode;
        } while (start && start !== root);
        if (start === root && checkRoot && condition(start)) {
            return start;
        }
        return null;
    }
    static closest(node, tagsOrCondition, root) {
        let condition;
        const lc = (s) => s.toLowerCase();
        if ((0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__/* .isFunction */ .Tn)(tagsOrCondition)) {
            condition = tagsOrCondition;
        }
        else if ((0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__/* .isArray */ .cy)(tagsOrCondition) || (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__/* .isSet */ .vM)(tagsOrCondition)) {
            const set = (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__/* .isSet */ .vM)(tagsOrCondition)
                ? tagsOrCondition
                : new Set(tagsOrCondition.map(lc));
            condition = (tag) => Boolean(tag && set.has(lc(tag.nodeName)));
        }
        else {
            condition = (tag) => Boolean(tag && lc(tagsOrCondition) === lc(tag.nodeName));
        }
        return Dom.up(node, condition, root);
    }
    /**
     * Furthest parent node matching condition
     */
    static furthest(node, condition, root) {
        let matchedParent = null, current = node === null || node === void 0 ? void 0 : node.parentElement;
        while (current && current !== root) {
            if (condition(current)) {
                matchedParent = current;
            }
            current = current === null || current === void 0 ? void 0 : current.parentElement;
        }
        return matchedParent;
    }
    /**
     * Append new element in the start of root
     */
    static appendChildFirst(root, newElement) {
        const child = root.firstChild;
        if (child) {
            if (child !== newElement) {
                root.insertBefore(newElement, child);
            }
        }
        else {
            root.appendChild(newElement);
        }
    }
    /**
     * Insert newElement after element
     */
    static after(elm, newElement) {
        const { parentNode } = elm;
        if (!parentNode) {
            return;
        }
        if (parentNode.lastChild === elm) {
            parentNode.appendChild(newElement);
        }
        else {
            parentNode.insertBefore(newElement, elm.nextSibling);
        }
    }
    /**
     * Insert newElement before element
     */
    static before(elm, newElement) {
        const { parentNode } = elm;
        if (!parentNode) {
            return;
        }
        parentNode.insertBefore(newElement, elm);
    }
    /**
     * Insert newElement as first child inside element
     */
    static prepend(root, newElement) {
        root.insertBefore(newElement, root.firstChild);
    }
    static append(root, newElement) {
        if ((0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__/* .isArray */ .cy)(newElement)) {
            newElement.forEach(node => {
                this.append(root, node);
            });
        }
        else {
            root.appendChild(newElement);
        }
    }
    /**
     * Move all content to another element
     */
    static moveContent(from, to, inStart = false, filter = () => true) {
        const fragment = (from.ownerDocument || document).createDocumentFragment();
        (0,jodit_core_helpers_array_to_array__WEBPACK_IMPORTED_MODULE_1__/* .toArray */ .$)(from.childNodes)
            .filter(elm => {
            if (filter(elm)) {
                return true;
            }
            Dom.safeRemove(elm);
            return false;
        })
            .forEach((node) => {
            fragment.appendChild(node);
        });
        if (!inStart || !to.firstChild) {
            to.appendChild(fragment);
        }
        else {
            to.insertBefore(fragment, to.firstChild);
        }
    }
    /**
     * Check root contains child or equal child
     */
    static isOrContains(root, child, onlyContains = false) {
        if (root === child) {
            return !onlyContains;
        }
        return Boolean(child && root && this.up(child, nd => nd === root, root, true));
    }
    /**
     * Safe remove element from DOM
     */
    static safeRemove(...nodes) {
        nodes.forEach(node => Dom.isNode(node) &&
            node.parentNode &&
            node.parentNode.removeChild(node));
    }
    static safeInsertNode(range, node) {
        range.collapsed || range.deleteContents();
        const child = Dom.isFragment(node) ? node.lastChild : node;
        if (range.startContainer === range.endContainer &&
            range.collapsed &&
            Dom.isTag(range.startContainer, jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INSEPARABLE_TAGS)) {
            Dom.after(range.startContainer, node);
        }
        else {
            range.insertNode(node);
            child && range.setStartBefore(child);
        }
        range.collapse(true);
        // https://developer.mozilla.org/en-US/docs/Web/API/Range/insertNode
        // if the new node is to be added to a text Node, that Node is split at the
        // insertion point, and the insertion occurs between the two text nodes.
        [node.nextSibling, node.previousSibling].forEach(n => Dom.isText(n) && !n.nodeValue && Dom.safeRemove(n));
    }
    /**
     * Hide element
     */
    static hide(node) {
        if (!node) {
            return;
        }
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__.dataBind)(node, '__old_display', node.style.display);
        node.style.display = 'none';
    }
    /**
     * Show element
     */
    static show(node) {
        if (!node) {
            return;
        }
        const display = (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__.dataBind)(node, '__old_display');
        if (node.style.display === 'none') {
            node.style.display = display || '';
        }
    }
    static isTag(node, tagNames) {
        if (!this.isElement(node)) {
            return false;
        }
        const nameL = node.tagName.toLowerCase();
        const nameU = node.tagName.toUpperCase();
        if (tagNames instanceof Set) {
            return tagNames.has(nameL) || tagNames.has(nameU);
        }
        if (Array.isArray(tagNames)) {
            throw new TypeError('Dom.isTag does not support array');
        }
        const tags = tagNames;
        if (nameL === tags || nameU === tags) {
            return true;
        }
        return false;
    }
    /**
     * Marks an item as temporary
     */
    static markTemporary(element, attributes) {
        attributes && (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__.attr)(element, attributes);
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__.attr)(element, jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.TEMP_ATTR, true);
        return element;
    }
    /**
     * Check if element is temporary
     */
    static isTemporary(element) {
        if (!Dom.isElement(element)) {
            return false;
        }
        return (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__/* .isMarker */ .rg)(element) || (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__.attr)(element, jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.TEMP_ATTR) === 'true';
    }
    /**
     * Replace temporary elements from string
     */
    static replaceTemporaryFromString(value) {
        return value.replace(/<([a-z]+)[^>]+data-jodit-temp[^>]+>(.+?)<\/\1>/gi, '$2');
    }
    /**
     * Get temporary list
     */
    static temporaryList(root) {
        return (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__.$$)(`[${jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.TEMP_ATTR}]`, root);
    }
}


/***/ }),

/***/ 71842:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   J: function() { return /* reexport safe */ _dom__WEBPACK_IMPORTED_MODULE_0__.J; },
/* harmony export */   p: function() { return /* reexport safe */ _lazy_walker__WEBPACK_IMPORTED_MODULE_1__.p; }
/* harmony export */ });
/* harmony import */ var _dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/* harmony import */ var _lazy_walker__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8453);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module dom
 */




/***/ }),

/***/ 8453:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   p: function() { return /* binding */ LazyWalker; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_event_emitter_eventify__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(43431);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */




class LazyWalker extends jodit_core_event_emitter_eventify__WEBPACK_IMPORTED_MODULE_2__/* .Eventify */ .h {
    setWork(root) {
        if (this.isWorked) {
            this.break();
        }
        this.workNodes = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.eachGen(root, !this.options.reverse);
        this.isFinished = false;
        this.startIdleRequest();
        return this;
    }
    constructor(async, options = {}) {
        super();
        this.async = async;
        this.options = options;
        this.workNodes = null;
        this.hadAffect = false;
        this.isWorked = false;
        this.isFinished = false;
        this.idleId = 0;
    }
    startIdleRequest() {
        var _a;
        this.idleId = this.async.requestIdleCallback(this.workPerform, {
            timeout: (_a = this.options.timeout) !== null && _a !== void 0 ? _a : 10
        });
    }
    break(reason) {
        if (this.isWorked) {
            this.stop();
            this.emit('break', reason);
        }
    }
    end() {
        if (this.isWorked) {
            this.stop();
            this.emit('end', this.hadAffect);
            this.hadAffect = false;
        }
    }
    stop() {
        this.isWorked = false;
        this.isFinished = true;
        this.workNodes = null;
        this.async.cancelIdleCallback(this.idleId);
    }
    destruct() {
        super.destruct();
        this.stop();
    }
    workPerform(deadline) {
        var _a;
        if (this.workNodes) {
            this.isWorked = true;
            let count = 0;
            const chunkSize = (_a = this.options.timeoutChunkSize) !== null && _a !== void 0 ? _a : 50;
            while (!this.isFinished &&
                (deadline.timeRemaining() > 0 ||
                    (deadline.didTimeout && count <= chunkSize))) {
                const item = this.workNodes.next();
                count += 1;
                if (this.visitNode(item.value)) {
                    this.hadAffect = true;
                }
                if (item.done) {
                    this.end();
                    return;
                }
            }
        }
        else {
            this.end();
        }
        if (!this.isFinished) {
            this.startIdleRequest();
        }
    }
    visitNode(nodeElm) {
        var _a;
        if (!nodeElm ||
            (this.options.whatToShow !== undefined &&
                nodeElm.nodeType !== this.options.whatToShow)) {
            return false;
        }
        return (_a = this.emit('visit', nodeElm)) !== null && _a !== void 0 ? _a : false;
    }
}
(0,tslib__WEBPACK_IMPORTED_MODULE_3__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.autobind
], LazyWalker.prototype, "workPerform", null);


/***/ }),

/***/ 50658:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   b: function() { return /* binding */ EventEmitter; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_helpers_array_split_array__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(42589);
/* harmony import */ var jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(37923);
/* harmony import */ var jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(69052);
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(98253);
/* harmony import */ var jodit_core_helpers_utils_error__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(50156);
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(10004);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */







/**
 * The module editor's event manager
 */
class EventEmitter {
    mute(event) {
        this.__mutedEvents.add(event !== null && event !== void 0 ? event : '*');
        return this;
    }
    isMuted(event) {
        if (event && this.__mutedEvents.has(event)) {
            return true;
        }
        return this.__mutedEvents.has('*');
    }
    unmute(event) {
        this.__mutedEvents.delete(event !== null && event !== void 0 ? event : '*');
        return this;
    }
    __eachEvent(events, callback) {
        const eventParts = (0,jodit_core_helpers_array_split_array__WEBPACK_IMPORTED_MODULE_3__/* .splitArray */ .u)(events).map(e => e.trim());
        eventParts.forEach(eventNameSpace => {
            const eventAndNameSpace = eventNameSpace.split('.');
            const namespace = eventAndNameSpace[1] || _store__WEBPACK_IMPORTED_MODULE_2__/* .defaultNameSpace */ .X;
            callback.call(this, eventAndNameSpace[0], namespace);
        });
    }
    __getStore(subject) {
        if (!subject) {
            throw (0,jodit_core_helpers_utils_error__WEBPACK_IMPORTED_MODULE_1__/* .error */ .z3)('Need subject');
        }
        if (subject[this.__key] === undefined) {
            const store = new _store__WEBPACK_IMPORTED_MODULE_2__/* .EventHandlersStore */ .d();
            Object.defineProperty(subject, this.__key, {
                enumerable: false,
                configurable: true,
                writable: true,
                value: store
            });
        }
        return subject[this.__key];
    }
    __removeStoreFromSubject(subject) {
        if (subject[this.__key] !== undefined) {
            Object.defineProperty(subject, this.__key, {
                enumerable: false,
                configurable: true,
                writable: true,
                value: undefined
            });
        }
    }
    __triggerNativeEvent(element, event) {
        const evt = this.__doc.createEvent('HTMLEvents');
        if ((0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_4__/* .isString */ .K)(event)) {
            evt.initEvent(event, true, true);
        }
        else {
            evt.initEvent(event.type, event.bubbles, event.cancelable);
            [
                'screenX',
                'screenY',
                'clientX',
                'clientY',
                'target',
                'srcElement',
                'currentTarget',
                'timeStamp',
                'which',
                'keyCode'
            ].forEach(property => {
                Object.defineProperty(evt, property, {
                    value: event[property],
                    enumerable: true
                });
            });
            Object.defineProperty(evt, 'originalEvent', {
                value: event,
                enumerable: true
            });
        }
        element.dispatchEvent(evt);
    }
    /**
     * Get current event name
     *
     * @example
     * ```javascript
     * parent.e.on('openDialog closeDialog', function () {
     *     if (parent.e.current === 'closeDialog') {
     *         alert('Dialog was closed');
     *     } else {
     *         alert('Dialog was opened');
     *     }
     * });
     * ```
     */
    get current() {
        return this.currents[this.currents.length - 1];
    }
    on(eventsOrSubjects, callbackOrEvents, optionsOrCallback, opts) {
        let subjects;
        let events;
        let callback;
        let options;
        if ((0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_4__/* .isString */ .K)(eventsOrSubjects) || (0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_4__/* .isStringArray */ .B)(eventsOrSubjects)) {
            subjects = this;
            events = eventsOrSubjects;
            callback = callbackOrEvents;
            options = optionsOrCallback;
        }
        else {
            subjects = eventsOrSubjects;
            events = callbackOrEvents;
            callback = optionsOrCallback;
            options = opts;
        }
        if (!((0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_4__/* .isString */ .K)(events) || (0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_4__/* .isStringArray */ .B)(events)) ||
            events.length === 0) {
            throw (0,jodit_core_helpers_utils_error__WEBPACK_IMPORTED_MODULE_1__/* .error */ .z3)('Need events names');
        }
        if (!(0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_5__/* .isFunction */ .T)(callback)) {
            throw (0,jodit_core_helpers_utils_error__WEBPACK_IMPORTED_MODULE_1__/* .error */ .z3)('Need event handler');
        }
        if ((0,jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_6__/* .isArray */ .c)(subjects)) {
            subjects.forEach(subj => {
                this.on(subj, events, callback, options);
            });
            return this;
        }
        const subject = subjects;
        const store = this.__getStore(subject);
        const self = this;
        let syntheticCallback = function (event, ...args) {
            if (self.isMuted(event)) {
                return;
            }
            return callback && callback.call(this, ...args);
        };
        if (isDOMElement(subject)) {
            syntheticCallback = function (event) {
                if (self.isMuted(event.type)) {
                    return;
                }
                self.__prepareEvent(event);
                if (callback && callback.call(this, event) === false) {
                    event.preventDefault();
                    event.stopImmediatePropagation();
                    return false;
                }
                return;
            };
        }
        this.__eachEvent(events, (event, namespace) => {
            var _a, _b;
            if (event.length === 0) {
                throw (0,jodit_core_helpers_utils_error__WEBPACK_IMPORTED_MODULE_1__/* .error */ .z3)('Need event name');
            }
            if (store.indexOf(event, namespace, callback) === false) {
                const block = {
                    event,
                    originalCallback: callback,
                    syntheticCallback
                };
                store.set(event, namespace, block, options === null || options === void 0 ? void 0 : options.top);
                if (isDOMElement(subject)) {
                    const eOpts = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.PASSIVE_EVENTS.has(event)
                        ? {
                            passive: true,
                            capture: (_a = options === null || options === void 0 ? void 0 : options.capture) !== null && _a !== void 0 ? _a : false
                        }
                        : (_b = options === null || options === void 0 ? void 0 : options.capture) !== null && _b !== void 0 ? _b : false;
                    syntheticCallback.options = eOpts;
                    subject.addEventListener(event, syntheticCallback, eOpts);
                    this.__memoryDOMSubjectToHandler(subject, syntheticCallback);
                }
            }
        });
        return this;
    }
    __memoryDOMSubjectToHandler(subject, syntheticCallback) {
        const callbackStore = this.__domEventsMap.get(subject) || new Set();
        callbackStore.add(syntheticCallback);
        this.__domEventsMap.set(subject, callbackStore);
    }
    __unmemoryDOMSubjectToHandler(subject, syntheticCallback) {
        const m = this.__domEventsMap;
        const callbackStore = m.get(subject) || new Set();
        callbackStore.delete(syntheticCallback);
        if (callbackStore.size) {
            m.set(subject, callbackStore);
        }
        else {
            m.delete(subject);
        }
    }
    one(eventsOrSubjects, callbackOrEvents, optionsOrCallback, opts) {
        let subjects;
        let events;
        let callback;
        let options;
        if ((0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_4__/* .isString */ .K)(eventsOrSubjects) || (0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_4__/* .isStringArray */ .B)(eventsOrSubjects)) {
            subjects = this;
            events = eventsOrSubjects;
            callback = callbackOrEvents;
            options = optionsOrCallback;
        }
        else {
            subjects = eventsOrSubjects;
            events = callbackOrEvents;
            callback = optionsOrCallback;
            options = opts;
        }
        const newCallback = (...args) => {
            this.off(subjects, events, newCallback);
            return callback(...args);
        };
        this.on(subjects, events, newCallback, options);
        return this;
    }
    off(eventsOrSubjects, callbackOrEvents, handler) {
        let subjects;
        let events;
        let callback;
        if ((0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_4__/* .isString */ .K)(eventsOrSubjects) || (0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_4__/* .isStringArray */ .B)(eventsOrSubjects)) {
            subjects = this;
            events = eventsOrSubjects;
            callback = callbackOrEvents;
        }
        else {
            subjects = eventsOrSubjects;
            events = callbackOrEvents;
            callback = handler;
        }
        if ((0,jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_6__/* .isArray */ .c)(subjects)) {
            subjects.forEach(subj => {
                this.off(subj, events, callback);
            });
            return this;
        }
        const subject = subjects;
        const store = this.__getStore(subject);
        if (!((0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_4__/* .isString */ .K)(events) || (0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_4__/* .isStringArray */ .B)(events)) ||
            events.length === 0) {
            store.namespaces().forEach((namespace) => {
                this.off(subject, '.' + namespace);
            });
            this.__removeStoreFromSubject(subject);
            return this;
        }
        const removeEventListener = (block) => {
            var _a;
            if (isDOMElement(subject)) {
                subject.removeEventListener(block.event, block.syntheticCallback, (_a = block.syntheticCallback.options) !== null && _a !== void 0 ? _a : false);
                this.__unmemoryDOMSubjectToHandler(subject, block.syntheticCallback);
            }
        }, removeCallbackFromNameSpace = (event, namespace) => {
            if (event === '') {
                store.events(namespace).forEach((eventName) => {
                    if (eventName !== '') {
                        removeCallbackFromNameSpace(eventName, namespace);
                    }
                });
                return;
            }
            const blocks = store.get(event, namespace);
            if (!blocks || !blocks.length) {
                return;
            }
            if (!(0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_5__/* .isFunction */ .T)(callback)) {
                blocks.forEach(removeEventListener);
                blocks.length = 0;
                store.clearEvents(namespace, event);
            }
            else {
                const index = store.indexOf(event, namespace, callback);
                if (index !== false) {
                    removeEventListener(blocks[index]);
                    blocks.splice(index, 1);
                    if (!blocks.length) {
                        store.clearEvents(namespace, event);
                    }
                }
            }
        };
        this.__eachEvent(events, (event, namespace) => {
            if (namespace === _store__WEBPACK_IMPORTED_MODULE_2__/* .defaultNameSpace */ .X) {
                store.namespaces().forEach(namespace => {
                    removeCallbackFromNameSpace(event, namespace);
                });
            }
            else {
                removeCallbackFromNameSpace(event, namespace);
            }
        });
        if (store.isEmpty()) {
            this.__removeStoreFromSubject(subject);
        }
        return this;
    }
    stopPropagation(subjectOrEvents, eventsList) {
        const subject = (0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_4__/* .isString */ .K)(subjectOrEvents)
            ? this
            : subjectOrEvents;
        const events = (0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_4__/* .isString */ .K)(subjectOrEvents)
            ? subjectOrEvents
            : eventsList;
        if (typeof events !== 'string') {
            throw (0,jodit_core_helpers_utils_error__WEBPACK_IMPORTED_MODULE_1__/* .error */ .z3)('Need event names');
        }
        const store = this.__getStore(subject);
        this.__eachEvent(events, (event, namespace) => {
            const blocks = store.get(event, namespace);
            if (blocks) {
                this.__stopped.push(blocks);
            }
            if (namespace === _store__WEBPACK_IMPORTED_MODULE_2__/* .defaultNameSpace */ .X) {
                store
                    .namespaces(true)
                    .forEach(ns => this.stopPropagation(subject, event + '.' + ns));
            }
        });
    }
    __removeStop(currentBlocks) {
        if (currentBlocks) {
            const index = this.__stopped.indexOf(currentBlocks);
            index !== -1 && this.__stopped.splice(0, index + 1);
        }
    }
    __isStopped(currentBlocks) {
        return (currentBlocks !== undefined &&
            this.__stopped.indexOf(currentBlocks) !== -1);
    }
    fire(subjectOrEvents, eventsList, ...args) {
        let result, result_value;
        const subject = (0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_4__/* .isString */ .K)(subjectOrEvents)
            ? this
            : subjectOrEvents;
        const events = (0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_4__/* .isString */ .K)(subjectOrEvents)
            ? subjectOrEvents
            : eventsList;
        const argumentsList = (0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_4__/* .isString */ .K)(subjectOrEvents)
            ? [eventsList, ...args]
            : args;
        if (!isDOMElement(subject) && !(0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_4__/* .isString */ .K)(events)) {
            throw (0,jodit_core_helpers_utils_error__WEBPACK_IMPORTED_MODULE_1__/* .error */ .z3)('Need events names');
        }
        const store = this.__getStore(subject);
        if (!(0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_4__/* .isString */ .K)(events) && isDOMElement(subject)) {
            this.__triggerNativeEvent(subject, eventsList);
        }
        else {
            this.__eachEvent(events, (event, namespace) => {
                if (isDOMElement(subject)) {
                    this.__triggerNativeEvent(subject, event);
                }
                else {
                    const blocks = store.get(event, namespace);
                    if (blocks) {
                        try {
                            [...blocks].every((block) => {
                                if (this.__isStopped(blocks)) {
                                    return false;
                                }
                                this.currents.push(event);
                                result_value =
                                    block.syntheticCallback.call(subject, event, ...argumentsList);
                                this.currents.pop();
                                if (result_value !== undefined) {
                                    result = result_value;
                                }
                                return true;
                            });
                        }
                        finally {
                            this.__removeStop(blocks);
                        }
                    }
                    if (namespace === _store__WEBPACK_IMPORTED_MODULE_2__/* .defaultNameSpace */ .X &&
                        !isDOMElement(subject)) {
                        store
                            .namespaces()
                            .filter(ns => ns !== namespace)
                            .forEach((ns) => {
                            const result_second = this.fire.apply(this, [
                                subject,
                                event + '.' + ns,
                                ...argumentsList
                            ]);
                            if (result_second !== undefined) {
                                result = result_second;
                            }
                        });
                    }
                }
            });
        }
        return result;
    }
    constructor(doc) {
        this.__domEventsMap = new Map();
        this.__mutedEvents = new Set();
        this.__key = '__JoditEventEmitterNamespaces';
        this.__doc = document;
        this.__prepareEvent = (e) => {
            if (e.cancelBubble) {
                return;
            }
            // for Shadow Dom
            if (e.composed && (0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_5__/* .isFunction */ .T)(e.composedPath) && e.composedPath()[0]) {
                Object.defineProperty(e, 'target', {
                    value: e.composedPath()[0],
                    configurable: true,
                    enumerable: true
                });
            }
            if (e.type.match(/^touch/) &&
                e.changedTouches &&
                e.changedTouches.length) {
                ['clientX', 'clientY', 'pageX', 'pageY'].forEach((key) => {
                    Object.defineProperty(e, key, {
                        value: e.changedTouches[0][key],
                        configurable: true,
                        enumerable: true
                    });
                });
            }
            if (!e.originalEvent) {
                e.originalEvent = e;
            }
            if (e.type === 'paste' &&
                e.clipboardData === undefined &&
                this.__doc.defaultView.clipboardData) {
                Object.defineProperty(e, 'clipboardData', {
                    get: () => {
                        return this.__doc.defaultView.clipboardData;
                    },
                    configurable: true,
                    enumerable: true
                });
            }
        };
        this.currents = [];
        this.__stopped = [];
        this.__isDestructed = false;
        if (doc) {
            this.__doc = doc;
        }
        this.__key += new Date().getTime();
    }
    destruct() {
        if (this.__isDestructed) {
            return;
        }
        this.__isDestructed = true;
        this.__domEventsMap.forEach((set, elm) => {
            this.off(elm);
        });
        this.__domEventsMap.clear();
        this.__mutedEvents.clear();
        this.currents.length = 0;
        this.__stopped.length = 0;
        this.off(this);
        this.__getStore(this).clear();
        this.__removeStoreFromSubject(this);
    }
}
function isDOMElement(subject) {
    return (0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_5__/* .isFunction */ .T)(subject.addEventListener);
}


/***/ }),

/***/ 43431:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   h: function() { return /* binding */ Eventify; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * Class for adding event handling capability
 *
 * ```ts
 * class SomeClass extends Eventify<{ start: (node: Node) => boolean; }> {
 * 	constructor() {
 * 		super();
 * 		setTimeout(() => {
 * 			if (this.emit('start', document.body)) {
 * 				console.log('yes');
 * 			};
 * 		}, 100);
 * 	}
 * }
 *
 * const sm = new SomeClass();
 * sm.on('start', (node) => {
 * 	console.log(node);
 * 	return true;
 * })
 * ```
 */
class Eventify {
    constructor() {
        this.__map = new Map();
    }
    on(name, func) {
        var _a;
        if (!this.__map.has(name)) {
            this.__map.set(name, new Set());
        }
        (_a = this.__map.get(name)) === null || _a === void 0 ? void 0 : _a.add(func);
        return this;
    }
    off(name, func) {
        var _a;
        if (this.__map.has(name)) {
            (_a = this.__map.get(name)) === null || _a === void 0 ? void 0 : _a.delete(func);
        }
        return this;
    }
    destruct() {
        this.__map.clear();
    }
    emit(name, ...args) {
        var _a;
        let result;
        if (this.__map.has(name)) {
            (_a = this.__map.get(name)) === null || _a === void 0 ? void 0 : _a.forEach(cb => {
                result = cb(...args);
            });
        }
        return result;
    }
}


/***/ }),

/***/ 50025:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Xr: function() { return /* reexport safe */ _store__WEBPACK_IMPORTED_MODULE_3__.X; },
/* harmony export */   bk: function() { return /* reexport safe */ _event_emitter__WEBPACK_IMPORTED_MODULE_0__.b; },
/* harmony export */   d$: function() { return /* reexport safe */ _store__WEBPACK_IMPORTED_MODULE_3__.d; },
/* harmony export */   h5: function() { return /* reexport safe */ _eventify__WEBPACK_IMPORTED_MODULE_1__.h; },
/* harmony export */   sH: function() { return /* reexport safe */ _observable__WEBPACK_IMPORTED_MODULE_2__.s; }
/* harmony export */ });
/* harmony import */ var _event_emitter__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(50658);
/* harmony import */ var _eventify__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(43431);
/* harmony import */ var _observable__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(32332);
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(10004);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module event-emitter
 */






/***/ }),

/***/ 32332:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   s: function() { return /* binding */ observable; }
/* harmony export */ });
/* harmony import */ var jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(66927);
/* harmony import */ var jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(37923);
/* harmony import */ var jodit_core_helpers_checker_is_equal__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(69810);
/* harmony import */ var jodit_core_helpers_checker_is_plain_object__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(25376);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */




const OBSERVABLE_OBJECT = Symbol('observable-object');
function isObservableObject(obj) {
    return obj[OBSERVABLE_OBJECT] !== undefined;
}
/**
 * Makes any object an observable object
 * @example
 * ```js
 * const obj = {
 *   a: 1,
 *   b: {
 *     c: 5
 *   }
 * }
 *
 * const obsObj = Jodit.modules.observable(obj);
 * console.log(obj === obsObj); // true
 * obsObj.on('change', () => {
 *   console.log('Object changed');
 * });
 * obsObj.on('change.a', () => {
 *   console.log('Key a changed');
 * });
 * obsObj.on('change.b.c', () => {
 *   console.log('Key b.c changed');
 * });
 *
 * obj.a = 6;
 * // Object changed
 * // Key a changed
 *
 * obj.b = {c: 6}
 * // Object changed
 *
 * obj.b.c = 8
 * // Object changed
 * // Key b.c changed
 * ```
 */
function observable(obj) {
    if (isObservableObject(obj)) {
        return obj;
    }
    const __lockEvent = {};
    const __onEvents = {};
    const on = (event, callback) => {
        if ((0,jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_1__/* .isArray */ .c)(event)) {
            event.map(e => on(e, callback));
            return obj;
        }
        if (!__onEvents[event]) {
            __onEvents[event] = [];
        }
        __onEvents[event].push(callback);
        return obj;
    };
    const fire = (event, ...attr) => {
        if ((0,jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_1__/* .isArray */ .c)(event)) {
            event.map(e => fire(e, ...attr));
            return;
        }
        try {
            if (!__lockEvent[event] && __onEvents[event]) {
                __lockEvent[event] = true;
                __onEvents[event].forEach(clb => clb.call(obj, ...attr));
            }
        }
        finally {
            __lockEvent[event] = false;
        }
    };
    const initAccessors = (dict, prefixes = []) => {
        const store = {};
        if (isObservableObject(dict)) {
            return;
        }
        Object.defineProperty(dict, OBSERVABLE_OBJECT, {
            enumerable: false,
            value: true
        });
        Object.keys(dict).forEach(_key => {
            const key = _key;
            const prefix = prefixes.concat(key).filter(a => a.length);
            store[key] = dict[key];
            const descriptor = (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_0__/* .getPropertyDescriptor */ .N)(dict, key);
            Object.defineProperty(dict, key, {
                set: (value) => {
                    const oldValue = store[key];
                    if (!(0,jodit_core_helpers_checker_is_equal__WEBPACK_IMPORTED_MODULE_2__/* .isFastEqual */ .P)(store[key], value)) {
                        fire([
                            'beforeChange',
                            `beforeChange.${prefix.join('.')}`
                        ], key, value);
                        if ((0,jodit_core_helpers_checker_is_plain_object__WEBPACK_IMPORTED_MODULE_3__/* .isPlainObject */ .Q)(value)) {
                            initAccessors(value, prefix);
                        }
                        if (descriptor && descriptor.set) {
                            descriptor.set.call(obj, value);
                        }
                        else {
                            store[key] = value;
                        }
                        const sum = [];
                        fire([
                            'change',
                            ...prefix.reduce((rs, p) => {
                                sum.push(p);
                                rs.push(`change.${sum.join('.')}`);
                                return rs;
                            }, [])
                        ], prefix.join('.'), oldValue, (value === null || value === void 0 ? void 0 : value.valueOf)
                            ? value.valueOf()
                            : value);
                    }
                },
                get: () => {
                    if (descriptor && descriptor.get) {
                        return descriptor.get.call(obj);
                    }
                    return store[key];
                },
                enumerable: true,
                configurable: true
            });
            if ((0,jodit_core_helpers_checker_is_plain_object__WEBPACK_IMPORTED_MODULE_3__/* .isPlainObject */ .Q)(store[key])) {
                initAccessors(store[key], prefix);
            }
        });
        Object.defineProperty(obj, 'on', {
            value: on
        });
    };
    initAccessors(obj);
    return obj;
}


/***/ }),

/***/ 10004:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   X: function() { return /* binding */ defaultNameSpace; },
/* harmony export */   d: function() { return /* binding */ EventHandlersStore; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_array_to_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(42448);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(28712);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_1__);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


const defaultNameSpace = 'JoditEventDefaultNamespace';
class EventHandlersStore {
    constructor() {
        this.__store = new Map();
    }
    get(event, namespace) {
        if (this.__store.has(namespace)) {
            const ns = this.__store.get(namespace);
            void 0;
            return ns[event];
        }
    }
    indexOf(event, namespace, originalCallback) {
        const blocks = this.get(event, namespace);
        if (blocks) {
            for (let i = 0; i < blocks.length; i += 1) {
                if (blocks[i].originalCallback === originalCallback) {
                    return i;
                }
            }
        }
        return false;
    }
    namespaces(withoutDefault = false) {
        const nss = (0,jodit_core_helpers_array_to_array__WEBPACK_IMPORTED_MODULE_0__/* .toArray */ .$)(this.__store.keys());
        return withoutDefault ? nss.filter(ns => ns !== defaultNameSpace) : nss;
    }
    events(namespace) {
        const ns = this.__store.get(namespace);
        return ns ? Object.keys(ns) : [];
    }
    set(event, namespace, data, onTop = false) {
        let ns = this.__store.get(namespace);
        if (!ns) {
            ns = {};
            this.__store.set(namespace, ns);
        }
        if (ns[event] === undefined) {
            ns[event] = [];
        }
        if (!onTop) {
            ns[event].push(data);
        }
        else {
            ns[event].unshift(data);
        }
    }
    clear() {
        this.__store.clear();
    }
    clearEvents(namespace, event) {
        const ns = this.__store.get(namespace);
        if (ns && ns[event]) {
            delete ns[event];
            if (!Object.keys(ns).length) {
                this.__store.delete(namespace);
            }
        }
    }
    isEmpty() {
        return this.__store.size === 0;
    }
}


/***/ }),

/***/ 56298:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   JW: function() { return /* binding */ extendLang; },
/* harmony export */   My: function() { return /* binding */ getContainer; },
/* harmony export */   RR: function() { return /* binding */ eventEmitter; },
/* harmony export */   VF: function() { return /* binding */ instances; },
/* harmony export */   av: function() { return /* binding */ modules; },
/* harmony export */   fg: function() { return /* binding */ pluginSystem; },
/* harmony export */   w9: function() { return /* binding */ uniqueUid; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_jodit_object__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(83044);
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(98253);
/* harmony import */ var jodit_core_helpers_checker_is_view_object__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(12041);
/* harmony import */ var jodit_core_helpers_string_kebab_case__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(449);
/* harmony import */ var jodit_core_helpers_utils_get_class_name__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(75766);
/* harmony import */ var jodit_core_plugin_plugin_system__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(77402);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(17352);
/* harmony import */ var _dom__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(71842);
/* harmony import */ var _event_emitter__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(50025);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */









const instances = {};
let counter = 1;
const uuids = new Set();
/**
 * Generate global unique uid
 */
function uniqueUid() {
    function gen() {
        counter += 10 * (Math.random() + 1);
        return Math.round(counter).toString(16);
    }
    let uid = gen();
    while (uuids.has(uid)) {
        uid = gen();
    }
    uuids.add(uid);
    return uid;
}
const pluginSystem = new jodit_core_plugin_plugin_system__WEBPACK_IMPORTED_MODULE_1__/* .PluginSystem */ .$();
const modules = {};
const extendLang = (langs) => {
    Object.keys(langs).forEach(key => {
        if (_constants__WEBPACK_IMPORTED_MODULE_2__.lang[key]) {
            Object.assign(_constants__WEBPACK_IMPORTED_MODULE_2__.lang[key], langs[key]);
        }
        else {
            _constants__WEBPACK_IMPORTED_MODULE_2__.lang[key] = langs[key];
        }
    });
};
const boxes = new WeakMap();
/**
 * Create unique box(HTMLCotainer) and remove it after destroy
 */
function getContainer(jodit, classFunc, tag = 'div', createInsideEditor = false) {
    const name = (0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_5__/* .isString */ .K)(classFunc)
        ? classFunc
        : classFunc
            ? (0,jodit_core_helpers_utils_get_class_name__WEBPACK_IMPORTED_MODULE_0__/* .getClassName */ .u)(classFunc.prototype)
            : 'jodit-utils';
    const data = boxes.get(jodit) || {}, key = name + tag;
    const view = (0,jodit_core_helpers_checker_is_view_object__WEBPACK_IMPORTED_MODULE_6__/* .isViewObject */ .h)(jodit) ? jodit : jodit.j;
    if (!data[key]) {
        let c = view.c, body = (0,jodit_core_helpers_checker_is_jodit_object__WEBPACK_IMPORTED_MODULE_7__/* .isJoditObject */ .y)(jodit) && jodit.o.shadowRoot
            ? jodit.o.shadowRoot
            : jodit.od.body;
        if (createInsideEditor &&
            (0,jodit_core_helpers_checker_is_jodit_object__WEBPACK_IMPORTED_MODULE_7__/* .isJoditObject */ .y)(jodit) &&
            jodit.od !== jodit.ed) {
            c = jodit.createInside;
            const place = tag === 'style' ? jodit.ed.head : jodit.ed.body;
            body =
                (0,jodit_core_helpers_checker_is_jodit_object__WEBPACK_IMPORTED_MODULE_7__/* .isJoditObject */ .y)(jodit) && jodit.o.shadowRoot
                    ? jodit.o.shadowRoot
                    : place;
        }
        const box = c.element(tag, {
            className: `jodit jodit-${(0,jodit_core_helpers_string_kebab_case__WEBPACK_IMPORTED_MODULE_8__/* .kebabCase */ .k)(name)}-container jodit-box`
        });
        box.classList.add(`jodit_theme_${view.o.theme || 'default'}`);
        body.appendChild(box);
        data[key] = box;
        jodit.hookStatus('beforeDestruct', () => {
            _dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.safeRemove(box);
            delete data[key];
            if (Object.keys(data).length) {
                boxes.delete(jodit);
            }
        });
        boxes.set(jodit, data);
    }
    data[key].classList.remove('jodit_theme_default', 'jodit_theme_dark');
    data[key].classList.add(`jodit_theme_${view.o.theme || 'default'}`);
    return data[key];
}
/**
 * Global event emitter
 */
const eventEmitter = new _event_emitter__WEBPACK_IMPORTED_MODULE_4__/* .EventEmitter */ .bk();


/***/ }),

/***/ 82317:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   _: function() { return /* binding */ asArray; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(37923);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/array
 */

/**
 * Always return Array
 * ```javascript
 * Jodit.modules.Helpers.asArray('test') // ['test']
 * Jodit.modules.Helpers.asArray(['test']) // ['test']
 * Jodit.modules.Helpers.asArray(1) // [1]
 * ```
 */
const asArray = (a) => ((0,jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_0__/* .isArray */ .c)(a) ? a : [a]);


/***/ }),

/***/ 32709:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   $r: function() { return /* reexport safe */ _to_array__WEBPACK_IMPORTED_MODULE_2__.$; },
/* harmony export */   _j: function() { return /* reexport safe */ _as_array__WEBPACK_IMPORTED_MODULE_0__._; },
/* harmony export */   uM: function() { return /* reexport safe */ _split_array__WEBPACK_IMPORTED_MODULE_1__.u; }
/* harmony export */ });
/* harmony import */ var _as_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82317);
/* harmony import */ var _split_array__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(42589);
/* harmony import */ var _to_array__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(42448);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/array
 */





/***/ }),

/***/ 42589:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   u: function() { return /* binding */ splitArray; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * Return an array from string or array
 * ```javascript
 * Jodit.modules.Helpers.splitArray('1,2,3') // ['1', '2', '3']
 * Jodit.modules.Helpers.splitArray(['1', '2', '3']) // ['1', '2', '3']
 * ```
 */
function splitArray(a) {
    return Array.isArray(a) ? a : a.split(/[,\s]+/);
}


/***/ }),

/***/ 42448:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   $: function() { return /* binding */ toArray; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_native_function__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(34796);
/* harmony import */ var jodit_core_helpers_utils_reset__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44210);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/array
 */


/**
 * Always return Array. It's a safe polyfill for [Array.from](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/from) method
 * In certain scenarios (such as with Joomla Mootools), Array.from may be substituted with a less optimal implementation
 * ```javascript
 * Jodit.modules.Helpers.toArray('123') // ['1', '2', '3']
 * Jodit.modules.Helpers.toArray(['test']) // ['test']
 * Jodit.modules.Helpers.toArray(1) // []
 * ```
 */
const toArray = function toArray(...args) {
    var _a;
    const func = (0,jodit_core_helpers_checker_is_native_function__WEBPACK_IMPORTED_MODULE_1__/* .isNativeFunction */ .a)(Array.from)
        ? Array.from
        : (_a = (0,jodit_core_helpers_utils_reset__WEBPACK_IMPORTED_MODULE_0__/* .reset */ .c)('Array.from')) !== null && _a !== void 0 ? _a : Array.from;
    return func.apply(Array, args);
};


/***/ }),

/***/ 89044:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   D: function() { return /* reexport safe */ _set_timeout__WEBPACK_IMPORTED_MODULE_0__.D; },
/* harmony export */   w: function() { return /* reexport safe */ _set_timeout__WEBPACK_IMPORTED_MODULE_0__.w; }
/* harmony export */ });
/* harmony import */ var _set_timeout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(59146);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/async
 */



/***/ }),

/***/ 59146:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   D: function() { return /* binding */ clearTimeout; },
/* harmony export */   w: function() { return /* binding */ setTimeout; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/async
 */
/**
 * Create async callback if set timeout value - else call function immediately
 */
function setTimeout(callback, timeout, ...args) {
    if (!timeout) {
        callback.call(null, ...args);
    }
    else {
        return window.setTimeout(callback, timeout, ...args);
    }
    return 0;
}
/**
 * Clear timeout
 */
function clearTimeout(timer) {
    window.clearTimeout(timer);
}


/***/ }),

/***/ 78479:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   k: function() { return /* binding */ hasBrowserColorPicker; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/checker
 */
/**
 * Check if browser has a color picker (a new HTML5 attribute for input tag)
 */
function hasBrowserColorPicker() {
    let supportsColor = true;
    try {
        const a = document.createElement('input');
        a.type = 'color';
        a.value = '!';
        supportsColor = a.type === 'color' && a.value !== '!';
    }
    catch (e) {
        supportsColor = false;
    }
    return supportsColor;
}


/***/ }),

/***/ 9823:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AH: function() { return /* reexport safe */ _is_html__WEBPACK_IMPORTED_MODULE_6__.A; },
/* harmony export */   Bo: function() { return /* reexport safe */ _is_string__WEBPACK_IMPORTED_MODULE_19__.B; },
/* harmony export */   CE: function() { return /* reexport safe */ _is_html_from_word__WEBPACK_IMPORTED_MODULE_7__.C; },
/* harmony export */   E6: function() { return /* reexport safe */ _is_int__WEBPACK_IMPORTED_MODULE_9__.E; },
/* harmony export */   Et: function() { return /* reexport safe */ _is_number__WEBPACK_IMPORTED_MODULE_14__.E; },
/* harmony export */   Gp: function() { return /* reexport safe */ _is_imp_interface__WEBPACK_IMPORTED_MODULE_8__.n4; },
/* harmony export */   Kg: function() { return /* reexport safe */ _is_string__WEBPACK_IMPORTED_MODULE_19__.K; },
/* harmony export */   Lm: function() { return /* reexport safe */ _is_boolean__WEBPACK_IMPORTED_MODULE_3__.L; },
/* harmony export */   Mj: function() { return /* reexport safe */ _is_license__WEBPACK_IMPORTED_MODULE_11__.M; },
/* harmony export */   P5: function() { return /* reexport safe */ _is_equal__WEBPACK_IMPORTED_MODULE_4__.P; },
/* harmony export */   Qd: function() { return /* reexport safe */ _is_plain_object__WEBPACK_IMPORTED_MODULE_16__.Q; },
/* harmony export */   Rd: function() { return /* reexport safe */ _is_void__WEBPACK_IMPORTED_MODULE_23__.R; },
/* harmony export */   Tn: function() { return /* reexport safe */ _is_function__WEBPACK_IMPORTED_MODULE_5__.T; },
/* harmony export */   a3: function() { return /* reexport safe */ _is_native_function__WEBPACK_IMPORTED_MODULE_13__.a; },
/* harmony export */   cy: function() { return /* reexport safe */ _is_array__WEBPACK_IMPORTED_MODULE_2__.c; },
/* harmony export */   hH: function() { return /* reexport safe */ _is_view_object__WEBPACK_IMPORTED_MODULE_22__.h; },
/* harmony export */   kC: function() { return /* reexport safe */ _has_browser_color_picker__WEBPACK_IMPORTED_MODULE_0__.k; },
/* harmony export */   kO: function() { return /* reexport safe */ _is_imp_interface__WEBPACK_IMPORTED_MODULE_8__.kO; },
/* harmony export */   kf: function() { return /* reexport safe */ _is_numeric__WEBPACK_IMPORTED_MODULE_15__.k; },
/* harmony export */   l6: function() { return /* reexport safe */ _is_window__WEBPACK_IMPORTED_MODULE_24__.l; },
/* harmony export */   mv: function() { return /* reexport safe */ _is_url__WEBPACK_IMPORTED_MODULE_20__.m; },
/* harmony export */   n4: function() { return /* reexport safe */ _is_equal__WEBPACK_IMPORTED_MODULE_4__.n; },
/* harmony export */   pV: function() { return /* reexport safe */ _is_imp_interface__WEBPACK_IMPORTED_MODULE_8__.pV; },
/* harmony export */   rg: function() { return /* reexport safe */ _is_marker__WEBPACK_IMPORTED_MODULE_12__.r; },
/* harmony export */   uV: function() { return /* reexport safe */ _is_valid_name__WEBPACK_IMPORTED_MODULE_21__.u; },
/* harmony export */   vM: function() { return /* reexport safe */ _is_set__WEBPACK_IMPORTED_MODULE_18__.v; },
/* harmony export */   y0: function() { return /* reexport safe */ _is_jodit_object__WEBPACK_IMPORTED_MODULE_10__.y; },
/* harmony export */   yL: function() { return /* reexport safe */ _is_promise__WEBPACK_IMPORTED_MODULE_17__.y; },
/* harmony export */   zf: function() { return /* reexport safe */ _is_abort_error__WEBPACK_IMPORTED_MODULE_1__.z; }
/* harmony export */ });
/* harmony import */ var _has_browser_color_picker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(78479);
/* harmony import */ var _is_abort_error__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(99951);
/* harmony import */ var _is_array__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(37923);
/* harmony import */ var _is_boolean__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(9810);
/* harmony import */ var _is_equal__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(69810);
/* harmony import */ var _is_function__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(69052);
/* harmony import */ var _is_html__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(53701);
/* harmony import */ var _is_html_from_word__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(21811);
/* harmony import */ var _is_imp_interface__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(10058);
/* harmony import */ var _is_int__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(3947);
/* harmony import */ var _is_jodit_object__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(83044);
/* harmony import */ var _is_license__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(82201);
/* harmony import */ var _is_marker__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(71274);
/* harmony import */ var _is_native_function__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(34796);
/* harmony import */ var _is_number__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(2461);
/* harmony import */ var _is_numeric__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(12461);
/* harmony import */ var _is_plain_object__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(25376);
/* harmony import */ var _is_promise__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(92039);
/* harmony import */ var _is_set__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(53470);
/* harmony import */ var _is_string__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(98253);
/* harmony import */ var _is_url__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(6939);
/* harmony import */ var _is_valid_name__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(59082);
/* harmony import */ var _is_view_object__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(12041);
/* harmony import */ var _is_void__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(35642);
/* harmony import */ var _is_window__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(76776);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/checker
 */



























/***/ }),

/***/ 99951:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   z: function() { return /* binding */ isAbortError; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
function isAbortError(error) {
    return (Boolean(error) &&
        error instanceof DOMException &&
        error.name === 'AbortError');
}


/***/ }),

/***/ 37923:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   c: function() { return /* binding */ isArray; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/checker
 */
/**
 * Check if element is array
 */
function isArray(elm) {
    return Array.isArray(elm);
}


/***/ }),

/***/ 9810:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   L: function() { return /* binding */ isBoolean; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/checker
 */
function isBoolean(elm) {
    return typeof elm === 'boolean';
}


/***/ }),

/***/ 69810:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   P: function() { return /* binding */ isFastEqual; },
/* harmony export */   n: function() { return /* binding */ isEqual; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_string_stringify__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(28616);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/checker
 */

/**
 * Check two element are equal
 */
function isEqual(a, b) {
    return a === b || (0,jodit_core_helpers_string_stringify__WEBPACK_IMPORTED_MODULE_0__/* .stringify */ .A)(a) === (0,jodit_core_helpers_string_stringify__WEBPACK_IMPORTED_MODULE_0__/* .stringify */ .A)(b);
}
function isFastEqual(a, b) {
    return a === b;
}


/***/ }),

/***/ 69052:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   T: function() { return /* binding */ isFunction; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/checker
 */
/**
 * Check value is Function
 */
function isFunction(value) {
    return typeof value === 'function';
}


/***/ }),

/***/ 21811:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   C: function() { return /* binding */ isHtmlFromWord; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/checker
 */
/**
 * Detect if string is HTML from MS Word or Excel
 */
function isHtmlFromWord(data) {
    return (data.search(/<meta.*?Microsoft Excel\s[\d].*?>/) !== -1 ||
        data.search(/<meta.*?Microsoft Word\s[\d].*?>/) !== -1 ||
        (data.search(/style="[^"]*mso-/) !== -1 && data.search(/<font/) !== -1));
}


/***/ }),

/***/ 53701:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: function() { return /* binding */ isHTML; }
/* harmony export */ });
/* harmony import */ var _is_string__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(98253);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/checker
 */

/**
 * Check if a string is html or not
 */
const isHTML = (str) => (0,_is_string__WEBPACK_IMPORTED_MODULE_0__/* .isString */ .K)(str) &&
    /<([A-Za-z][A-Za-z0-9]*)\b[^>]*>(.*?)<\/\1>/m.test(str.replace(/[\r\n]/g, ''));


/***/ }),

/***/ 10058:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   kO: function() { return /* binding */ hasContainer; },
/* harmony export */   n4: function() { return /* binding */ isInitable; },
/* harmony export */   pV: function() { return /* binding */ isDestructable; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/* harmony import */ var _is_function__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(69052);
/* harmony import */ var _is_void__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(35642);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



/**
 * Check value has method init
 */
function isInitable(value) {
    return !(0,_is_void__WEBPACK_IMPORTED_MODULE_1__/* .isVoid */ .R)(value) && (0,_is_function__WEBPACK_IMPORTED_MODULE_2__/* .isFunction */ .T)(value.init);
}
/**
 * Check value has method destruct
 */
function isDestructable(value) {
    return !(0,_is_void__WEBPACK_IMPORTED_MODULE_1__/* .isVoid */ .R)(value) && (0,_is_function__WEBPACK_IMPORTED_MODULE_2__/* .isFunction */ .T)(value.destruct);
}
/**
 * Check value is instant that implements IContainer
 */
function hasContainer(value) {
    return !(0,_is_void__WEBPACK_IMPORTED_MODULE_1__/* .isVoid */ .R)(value) && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isElement(value.container);
}


/***/ }),

/***/ 3947:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   E: function() { return /* binding */ isInt; }
/* harmony export */ });
/* harmony import */ var _is_numeric__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(12461);
/* harmony import */ var _is_string__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(98253);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/checker
 */


/**
 * Check value is Int
 */
function isInt(value) {
    if ((0,_is_string__WEBPACK_IMPORTED_MODULE_0__/* .isString */ .K)(value) && (0,_is_numeric__WEBPACK_IMPORTED_MODULE_1__/* .isNumeric */ .k)(value)) {
        value = parseFloat(value);
    }
    return typeof value === 'number' && Number.isFinite(value) && !(value % 1);
}


/***/ }),

/***/ 83044:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   y: function() { return /* binding */ isJoditObject; }
/* harmony export */ });
/* harmony import */ var _is_function__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(69052);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

/**
 * Check if element is instance of Jodit
 */
function isJoditObject(jodit) {
    return Boolean(jodit &&
        jodit instanceof Object &&
        (0,_is_function__WEBPACK_IMPORTED_MODULE_0__/* .isFunction */ .T)(jodit.constructor) &&
        // @ts-ignore
        ((typeof Jodit !== 'undefined' && jodit instanceof Jodit) ||
            jodit.isJodit));
}


/***/ }),

/***/ 82201:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   M: function() { return /* binding */ isLicense; }
/* harmony export */ });
/* harmony import */ var _is_string__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(98253);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/checker
 */

const isLicense = (license) => (0,_is_string__WEBPACK_IMPORTED_MODULE_0__/* .isString */ .K)(license) &&
    license.length === 23 &&
    /^[a-z0-9]{5}-[a-z0-9]{5}-[a-z0-9]{5}-[a-z0-9]{5}$/i.test(license);


/***/ }),

/***/ 71274:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   r: function() { return /* binding */ isMarker; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


/**
 * Define element is selection helper
 */
function isMarker(elm) {
    return (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isNode(elm) &&
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isTag(elm, 'span') &&
        elm.hasAttribute('data-' + jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MARKER_CLASS));
}


/***/ }),

/***/ 34796:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   a: function() { return /* binding */ isNativeFunction; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/checker
 */
/**
 * Check if function or method was not replaced on some custom implementation
 */
function isNativeFunction(f) {
    return (Boolean(f) &&
        (typeof f).toLowerCase() === 'function' &&
        (f === Function.prototype ||
            /^\s*function\s*(\b[a-z$_][a-z0-9$_]*\b)*\s*\((|([a-z$_][a-z0-9$_]*)(\s*,[a-z$_][a-z0-9$_]*)*)\)\s*{\s*\[native code]\s*}\s*$/i.test(String(f))));
}


/***/ }),

/***/ 2461:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   E: function() { return /* binding */ isNumber; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/checker
 */
/**
 * Check value is a number
 */
function isNumber(value) {
    return typeof value === 'number' && !isNaN(value) && isFinite(value);
}


/***/ }),

/***/ 12461:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   k: function() { return /* binding */ isNumeric; }
/* harmony export */ });
/* harmony import */ var _is_string__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(98253);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/checker
 */

/**
 * Check value has numeric format
 */
function isNumeric(value) {
    if ((0,_is_string__WEBPACK_IMPORTED_MODULE_0__/* .isString */ .K)(value)) {
        if (!value.match(/^([+-])?[0-9]+(\.?)([0-9]+)?(e[0-9]+)?$/)) {
            return false;
        }
        value = parseFloat(value);
    }
    return typeof value === 'number' && !isNaN(value) && isFinite(value);
}


/***/ }),

/***/ 25376:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Q: function() { return /* binding */ isPlainObject; }
/* harmony export */ });
/* harmony import */ var _is_window__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(76776);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

/**
 * Check if element is simple plaint object
 */
function isPlainObject(obj) {
    if (!obj || typeof obj !== 'object' || obj.nodeType || (0,_is_window__WEBPACK_IMPORTED_MODULE_0__/* .isWindow */ .l)(obj)) {
        return false;
    }
    return !(obj.constructor &&
        !{}.hasOwnProperty.call(obj.constructor.prototype, 'isPrototypeOf'));
}


/***/ }),

/***/ 92039:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   y: function() { return /* binding */ isPromise; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/checker
 */
function isPromise(val) {
    return val && typeof val.then === 'function';
}


/***/ }),

/***/ 53470:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   v: function() { return /* binding */ isSet; }
/* harmony export */ });
/* harmony import */ var _is_function__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(69052);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/checker
 */

/**
 * Check if element is set
 */
function isSet(elm) {
    return (Boolean(elm) &&
        (0,_is_function__WEBPACK_IMPORTED_MODULE_0__/* .isFunction */ .T)(elm.has) &&
        (0,_is_function__WEBPACK_IMPORTED_MODULE_0__/* .isFunction */ .T)(elm.add) &&
        (0,_is_function__WEBPACK_IMPORTED_MODULE_0__/* .isFunction */ .T)(elm.delete));
}


/***/ }),

/***/ 98253:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   B: function() { return /* binding */ isStringArray; },
/* harmony export */   K: function() { return /* binding */ isString; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(37923);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/checker
 */

/**
 * Check value is String
 */
function isString(value) {
    return typeof value === 'string';
}
/**
 * Check value is Array of String
 */
function isStringArray(value) {
    return (0,jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_0__/* .isArray */ .c)(value) && isString(value[0]);
}


/***/ }),

/***/ 6939:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   m: function() { return /* binding */ isURL; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/checker
 */
/**
 * Check if a string is an url
 */
function isURL(str) {
    if (str.includes(' ')) {
        return false;
    }
    if (typeof URL !== 'undefined') {
        try {
            const url = new URL(str);
            return ['https:', 'http:', 'ftp:', 'file:', 'rtmp:'].includes(url.protocol);
        }
        catch (e) {
            return false;
        }
    }
    const a = document.createElement('a');
    a.href = str;
    return Boolean(a.hostname);
}


/***/ }),

/***/ 59082:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   u: function() { return /* binding */ isValidName; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/checker
 */
/**
 * Check if name has a normal format
 */
function isValidName(name) {
    if (!name.length) {
        return false;
    }
    return !/[^0-9A-Za-zа-яА-ЯЁё\w\-_. ]/.test(name) && name.trim().length > 0;
}


/***/ }),

/***/ 12041:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   h: function() { return /* binding */ isViewObject; }
/* harmony export */ });
/* harmony import */ var _is_function__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(69052);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

/**
 * Check if an element is instance of View
 */
function isViewObject(jodit) {
    return Boolean(jodit &&
        jodit instanceof Object &&
        (0,_is_function__WEBPACK_IMPORTED_MODULE_0__/* .isFunction */ .T)(jodit.constructor) &&
        jodit.isView);
}


/***/ }),

/***/ 35642:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   R: function() { return /* binding */ isVoid; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/checker
 */
/**
 * Check value is undefined or null
 */
function isVoid(value) {
    // eslint-disable-next-line eqeqeq
    return value === undefined || value === null;
}


/***/ }),

/***/ 76776:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   l: function() { return /* binding */ isWindow; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/checker
 */
function isWindow(obj) {
    return obj != null && obj === obj.window;
}


/***/ }),

/***/ 96768:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   s: function() { return /* binding */ colorToHex; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/color
 */
/**
 * Converts rgba text representation of color in hex
 *
 * @param color - string like rgba(red, green, blue, alpha) or rgb(red, green, blue)
 * @returns hex color view, NaN - for transparent color
 * @example
 * ```javascript
 * var p = document.createElement('p');
 * p.style.color = '#ffffff';
 * console.log(p.getAttribute('style')); // color: rgb(255, 255, 255);
 * console.log(colorTohex(p.style.color)); // #ffffff
 * ```
 */
const colorToHex = (color) => {
    if (color === 'rgba(0, 0, 0, 0)' || color === '') {
        return false;
    }
    if (!color) {
        return '#000000';
    }
    if (color.substr(0, 1) === '#') {
        return color;
    }
    const digits = /([\s\n\t\r]*?)rgb\((\d+), (\d+), (\d+)\)/.exec(color) ||
        /([\s\n\t\r]*?)rgba\((\d+), (\d+), (\d+), ([\d.]+)\)/.exec(color);
    if (!digits) {
        return '#000000';
    }
    const red = parseInt(digits[2], 10), green = parseInt(digits[3], 10), blue = parseInt(digits[4], 10), rgb = blue | (green << 8) | (red << 16);
    let hex = rgb.toString(16).toUpperCase();
    while (hex.length < 6) {
        hex = '0' + hex;
    }
    return digits[1] + '#' + hex;
};


/***/ }),

/***/ 93495:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   s: function() { return /* reexport safe */ _color_to_hex__WEBPACK_IMPORTED_MODULE_0__.s; }
/* harmony export */ });
/* harmony import */ var _color_to_hex__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(96768);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/color
 */



/***/ }),

/***/ 56176:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: function() { return /* binding */ applyStyles; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(59101);
/* harmony import */ var jodit_core_helpers_utils_selector__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(58720);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/html
 */




function normalizeCSS(s) {
    return s
        .replace(/mso-[a-z-]+:[\s]*[^;]+;/gi, '')
        .replace(/mso-[a-z-]+:[\s]*[^";']+$/gi, '')
        .replace(/border[a-z-]*:[\s]*[^;]+;/gi, '')
        .replace(/([0-9.]+)(pt|cm)/gi, (match, units, metrics) => {
        switch (metrics.toLowerCase()) {
            case 'pt':
                return (parseFloat(units) * 1.328).toFixed(0) + 'px';
            case 'cm':
                return (parseFloat(units) * 0.02645833).toFixed(0) + 'px';
        }
        return match;
    });
}
/**
 * If the HTML has CSS rules with selectors,
 * it applies them to the selectors in the HTML itself
 * and then removes the selector styles, leaving only the inline ones.
 */
function applyStyles(html) {
    if (html.indexOf('<html ') === -1) {
        return html;
    }
    html = html.substring(html.indexOf('<html '), html.length);
    html = html.substring(0, html.lastIndexOf('</html>') + '</html>'.length);
    const iframe = document.createElement('iframe');
    iframe.style.display = 'none';
    document.body.appendChild(iframe);
    let convertedString = '', collection = [];
    try {
        const iframeDoc = iframe.contentDocument ||
            (iframe.contentWindow ? iframe.contentWindow.document : null);
        if (iframeDoc) {
            iframeDoc.open();
            iframeDoc.write(html);
            iframeDoc.close();
            try {
                for (let i = 0; i < iframeDoc.styleSheets.length; i += 1) {
                    const rules = iframeDoc.styleSheets[i].cssRules;
                    for (let idx = 0; idx < rules.length; idx += 1) {
                        if (rules[idx].selectorText === '') {
                            continue;
                        }
                        collection = (0,jodit_core_helpers_utils_selector__WEBPACK_IMPORTED_MODULE_3__.$$)(rules[idx].selectorText, iframeDoc.body);
                        collection.forEach((elm) => {
                            elm.style.cssText = normalizeCSS(rules[idx].style.cssText +
                                ';' +
                                elm.style.cssText);
                        });
                    }
                }
            }
            catch (e) {
                if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD) {
                    throw e;
                }
            }
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.each(iframeDoc.body, node => {
                if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isElement(node)) {
                    const elm = node;
                    const css = elm.getAttribute('style');
                    if (css) {
                        elm.style.cssText = normalizeCSS(css);
                    }
                    if (elm.hasAttribute('style') &&
                        !elm.getAttribute('style')) {
                        elm.removeAttribute('style');
                    }
                }
            });
            convertedString = iframeDoc.firstChild
                ? (0,jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_2__/* .trim */ .Bq)(iframeDoc.body.innerHTML)
                : '';
        }
    }
    catch (_a) {
    }
    finally {
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.safeRemove(iframe);
    }
    if (convertedString) {
        html = convertedString;
    }
    return (0,jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_2__/* .trim */ .Bq)(html
        .replace(/<(\/)?(html|colgroup|col|o:p)[^>]*>/g, '')
        .replace(/<!--[^>]*>/g, ''));
}


/***/ }),

/***/ 94450:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   w: function() { return /* binding */ cleanFromWord; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_array_to_array__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(42448);
/* harmony import */ var jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(59101);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/html
 */



/**
 * The method automatically cleans up content from Microsoft Word and other HTML sources to ensure clean, compliant
 * content that matches the look and feel of the site.
 */
function cleanFromWord(html) {
    if (html.indexOf('<html ') !== -1) {
        html = html.substring(html.indexOf('<html '), html.length);
        html = html.substring(0, html.lastIndexOf('</html>') + '</html>'.length);
    }
    let convertedString = '';
    try {
        const div = document.createElement('div');
        div.innerHTML = html;
        const marks = [];
        if (div.firstChild) {
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.each(div, node => {
                if (!node) {
                    return;
                }
                switch (node.nodeType) {
                    case Node.ELEMENT_NODE:
                        switch (node.nodeName) {
                            case 'STYLE':
                            case 'LINK':
                            case 'META':
                                marks.push(node);
                                break;
                            case 'W:SDT':
                            case 'W:SDTPR':
                            case 'FONT':
                                jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.unwrap(node);
                                break;
                            default:
                                (0,jodit_core_helpers_array_to_array__WEBPACK_IMPORTED_MODULE_1__/* .toArray */ .$)(node.attributes).forEach((attr) => {
                                    if ([
                                        'src',
                                        'href',
                                        'rel',
                                        'content'
                                    ].indexOf(attr.name.toLowerCase()) === -1) {
                                        node.removeAttribute(attr.name);
                                    }
                                });
                        }
                        break;
                    case Node.TEXT_NODE:
                        break;
                    default:
                        marks.push(node);
                }
            });
        }
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.safeRemove.apply(null, marks);
        convertedString = div.innerHTML;
    }
    catch (e) { }
    if (convertedString) {
        html = convertedString;
    }
    html = html.split(/(\n)/).filter(jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_2__/* .trim */ .Bq).join('\n');
    return html
        .replace(/<(\/)?(html|colgroup|col|o:p)[^>]*>/g, '')
        .replace(/<!--[^>]*>/g, '');
}


/***/ }),

/***/ 4960:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   G: function() { return /* binding */ htmlspecialchars; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/html
 */
/**
 * Convert special characters to HTML entities
 */
function htmlspecialchars(html) {
    const tmp = document.createElement('div');
    tmp.textContent = html;
    return tmp.innerHTML;
}


/***/ }),

/***/ 16113:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Gq: function() { return /* reexport safe */ _htmlspecialchars__WEBPACK_IMPORTED_MODULE_2__.G; },
/* harmony export */   HA: function() { return /* reexport safe */ _nl2br__WEBPACK_IMPORTED_MODULE_3__.H; },
/* harmony export */   Kq: function() { return /* reexport safe */ _strip_tags__WEBPACK_IMPORTED_MODULE_5__.K; },
/* harmony export */   ZM: function() { return /* reexport safe */ _apply_styles__WEBPACK_IMPORTED_MODULE_0__.Z; },
/* harmony export */   t_: function() { return /* reexport safe */ _safe_html__WEBPACK_IMPORTED_MODULE_4__.t; },
/* harmony export */   vn: function() { return /* reexport safe */ _safe_html__WEBPACK_IMPORTED_MODULE_4__.v; },
/* harmony export */   wE: function() { return /* reexport safe */ _clean_from_word__WEBPACK_IMPORTED_MODULE_1__.w; }
/* harmony export */ });
/* harmony import */ var _apply_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(56176);
/* harmony import */ var _clean_from_word__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(94450);
/* harmony import */ var _htmlspecialchars__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4960);
/* harmony import */ var _nl2br__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(10025);
/* harmony import */ var _safe_html__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26328);
/* harmony import */ var _strip_tags__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(61793);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/html
 */








/***/ }),

/***/ 10025:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   H: function() { return /* binding */ nl2br; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/html
 */
/**
 *  Inserts HTML line breaks before all newlines in a string
 */
function nl2br(html) {
    return html.replace(/\r\n|\r|\n/g, '<br/>');
}


/***/ }),

/***/ 26328:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   t: function() { return /* binding */ safeHTML; },
/* harmony export */   v: function() { return /* binding */ sanitizeHTMLElement; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(97369);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/html
 */


/**
 * Removes dangerous constructs from HTML
 */
function safeHTML(box, options) {
    if (!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isElement(box) && !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isFragment(box)) {
        return;
    }
    if (options.removeOnError) {
        sanitizeHTMLElement(box);
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.$$)('[onerror]', box).forEach(elm => sanitizeHTMLElement(elm, options));
    }
    if (options.safeJavaScriptLink) {
        sanitizeHTMLElement(box);
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.$$)('a[href^="javascript"]', box).forEach(elm => sanitizeHTMLElement(elm, options));
    }
}
function sanitizeHTMLElement(elm, { safeJavaScriptLink, removeOnError } = {
    safeJavaScriptLink: true,
    removeOnError: true
}) {
    if (!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isElement(elm)) {
        return false;
    }
    let effected = false;
    if (removeOnError && elm.hasAttribute('onerror')) {
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.attr)(elm, 'onerror', null);
        effected = true;
    }
    const href = elm.getAttribute('href');
    if (safeJavaScriptLink && href && href.trim().indexOf('javascript') === 0) {
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.attr)(elm, 'href', location.protocol + '//' + href);
        effected = true;
    }
    return effected;
}


/***/ }),

/***/ 61793:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   K: function() { return /* binding */ stripTags; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(98253);
/* harmony import */ var jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(59101);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(97369);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */




const NEW_LINE_TAGS = new Set([
    'div',
    'p',
    'br',
    'h1',
    'h2',
    'h3',
    'h4',
    'h5',
    'h6',
    'hr'
]);
const INVISIBLE_TAGS = new Set(['script', 'style']);
const ALONE_TAGS = new Set(['br', 'hr', 'input']);
/**
 * Extract plain text from HTML text
 */
function stripTags(html, doc = document, exclude = null) {
    const tmp = doc.createElement('div');
    if ((0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_3__/* .isString */ .K)(html)) {
        tmp.innerHTML = html;
    }
    else {
        tmp.appendChild(html);
    }
    (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_2__.$$)('*', tmp).forEach(p => {
        const pr = p.parentNode;
        if (!pr) {
            return;
        }
        if (exclude && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(p, exclude)) {
            const tag = p.nodeName.toLowerCase();
            const text = !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(p, ALONE_TAGS)
                ? `%%%jodit-${tag}%%%${stripTags(p.innerHTML, doc, exclude)}%%%/jodit-${tag}%%%`
                : `%%%jodit-single-${tag}%%%`;
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.before(p, doc.createTextNode(text));
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.safeRemove(p);
            return;
        }
        if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(p, INVISIBLE_TAGS)) {
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.safeRemove(p);
            return;
        }
        if (!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(p, NEW_LINE_TAGS)) {
            return;
        }
        const nx = p.nextSibling;
        if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isText(nx) && /^\s/.test(nx.nodeValue || '')) {
            return;
        }
        if (nx) {
            pr.insertBefore(doc.createTextNode(' '), nx);
        }
    });
    return restoreTags((0,jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_1__/* .trim */ .Bq)(tmp.innerText));
}
function restoreTags(content) {
    return content.replace(/%%%(\/)?jodit(-single)?-([\w\n]+)%%%/g, (_, isClosed, isSingle, tag) => `<${isClosed ? '/' : ''}${tag}>`);
}


/***/ }),

/***/ 65147:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CamelCaseToKebabCase: function() { return /* reexport safe */ _string__WEBPACK_IMPORTED_MODULE_7__.N; },
/* harmony export */   NUMBER_FIELDS_REG: function() { return /* reexport safe */ _normalize__WEBPACK_IMPORTED_MODULE_5__.b$; },
/* harmony export */   applyStyles: function() { return /* reexport safe */ _html__WEBPACK_IMPORTED_MODULE_4__.ZM; },
/* harmony export */   asArray: function() { return /* reexport safe */ _array__WEBPACK_IMPORTED_MODULE_0__._j; },
/* harmony export */   camelCase: function() { return /* reexport safe */ _string__WEBPACK_IMPORTED_MODULE_7__.xQ; },
/* harmony export */   cleanFromWord: function() { return /* reexport safe */ _html__WEBPACK_IMPORTED_MODULE_4__.wE; },
/* harmony export */   clearTimeout: function() { return /* reexport safe */ _async__WEBPACK_IMPORTED_MODULE_1__.D; },
/* harmony export */   colorToHex: function() { return /* reexport safe */ _color__WEBPACK_IMPORTED_MODULE_3__.s; },
/* harmony export */   fuzzySearchIndex: function() { return /* reexport safe */ _string__WEBPACK_IMPORTED_MODULE_7__.Hp; },
/* harmony export */   getContentWidth: function() { return /* reexport safe */ _size__WEBPACK_IMPORTED_MODULE_6__.y6; },
/* harmony export */   getScrollParent: function() { return /* reexport safe */ _size__WEBPACK_IMPORTED_MODULE_6__.mH; },
/* harmony export */   hasBrowserColorPicker: function() { return /* reexport safe */ _checker__WEBPACK_IMPORTED_MODULE_2__.kC; },
/* harmony export */   hasContainer: function() { return /* reexport safe */ _checker__WEBPACK_IMPORTED_MODULE_2__.kO; },
/* harmony export */   htmlspecialchars: function() { return /* reexport safe */ _html__WEBPACK_IMPORTED_MODULE_4__.Gq; },
/* harmony export */   i18n: function() { return /* reexport safe */ _string__WEBPACK_IMPORTED_MODULE_7__.Ru; },
/* harmony export */   innerWidth: function() { return /* reexport safe */ _size__WEBPACK_IMPORTED_MODULE_6__.xM; },
/* harmony export */   isAbortError: function() { return /* reexport safe */ _checker__WEBPACK_IMPORTED_MODULE_2__.zf; },
/* harmony export */   isArray: function() { return /* reexport safe */ _checker__WEBPACK_IMPORTED_MODULE_2__.cy; },
/* harmony export */   isBoolean: function() { return /* reexport safe */ _checker__WEBPACK_IMPORTED_MODULE_2__.Lm; },
/* harmony export */   isDestructable: function() { return /* reexport safe */ _checker__WEBPACK_IMPORTED_MODULE_2__.pV; },
/* harmony export */   isEqual: function() { return /* reexport safe */ _checker__WEBPACK_IMPORTED_MODULE_2__.n4; },
/* harmony export */   isFastEqual: function() { return /* reexport safe */ _checker__WEBPACK_IMPORTED_MODULE_2__.P5; },
/* harmony export */   isFunction: function() { return /* reexport safe */ _checker__WEBPACK_IMPORTED_MODULE_2__.Tn; },
/* harmony export */   isHTML: function() { return /* reexport safe */ _checker__WEBPACK_IMPORTED_MODULE_2__.AH; },
/* harmony export */   isHtmlFromWord: function() { return /* reexport safe */ _checker__WEBPACK_IMPORTED_MODULE_2__.CE; },
/* harmony export */   isInitable: function() { return /* reexport safe */ _checker__WEBPACK_IMPORTED_MODULE_2__.Gp; },
/* harmony export */   isInt: function() { return /* reexport safe */ _checker__WEBPACK_IMPORTED_MODULE_2__.E6; },
/* harmony export */   isJoditObject: function() { return /* reexport safe */ _checker__WEBPACK_IMPORTED_MODULE_2__.y0; },
/* harmony export */   isLicense: function() { return /* reexport safe */ _checker__WEBPACK_IMPORTED_MODULE_2__.Mj; },
/* harmony export */   isMarker: function() { return /* reexport safe */ _checker__WEBPACK_IMPORTED_MODULE_2__.rg; },
/* harmony export */   isNativeFunction: function() { return /* reexport safe */ _checker__WEBPACK_IMPORTED_MODULE_2__.a3; },
/* harmony export */   isNumber: function() { return /* reexport safe */ _checker__WEBPACK_IMPORTED_MODULE_2__.Et; },
/* harmony export */   isNumeric: function() { return /* reexport safe */ _checker__WEBPACK_IMPORTED_MODULE_2__.kf; },
/* harmony export */   isPlainObject: function() { return /* reexport safe */ _checker__WEBPACK_IMPORTED_MODULE_2__.Qd; },
/* harmony export */   isPromise: function() { return /* reexport safe */ _checker__WEBPACK_IMPORTED_MODULE_2__.yL; },
/* harmony export */   isSet: function() { return /* reexport safe */ _checker__WEBPACK_IMPORTED_MODULE_2__.vM; },
/* harmony export */   isString: function() { return /* reexport safe */ _checker__WEBPACK_IMPORTED_MODULE_2__.Kg; },
/* harmony export */   isStringArray: function() { return /* reexport safe */ _checker__WEBPACK_IMPORTED_MODULE_2__.Bo; },
/* harmony export */   isURL: function() { return /* reexport safe */ _checker__WEBPACK_IMPORTED_MODULE_2__.mv; },
/* harmony export */   isValidName: function() { return /* reexport safe */ _checker__WEBPACK_IMPORTED_MODULE_2__.uV; },
/* harmony export */   isViewObject: function() { return /* reexport safe */ _checker__WEBPACK_IMPORTED_MODULE_2__.hH; },
/* harmony export */   isVoid: function() { return /* reexport safe */ _checker__WEBPACK_IMPORTED_MODULE_2__.Rd; },
/* harmony export */   isWindow: function() { return /* reexport safe */ _checker__WEBPACK_IMPORTED_MODULE_2__.l6; },
/* harmony export */   kebabCase: function() { return /* reexport safe */ _string__WEBPACK_IMPORTED_MODULE_7__.kW; },
/* harmony export */   nl2br: function() { return /* reexport safe */ _html__WEBPACK_IMPORTED_MODULE_4__.HA; },
/* harmony export */   normalizeColor: function() { return /* reexport safe */ _normalize__WEBPACK_IMPORTED_MODULE_5__.$2; },
/* harmony export */   normalizeCssNumericValue: function() { return /* reexport safe */ _normalize__WEBPACK_IMPORTED_MODULE_5__.n8; },
/* harmony export */   normalizeCssValue: function() { return /* reexport safe */ _normalize__WEBPACK_IMPORTED_MODULE_5__.iy; },
/* harmony export */   normalizeKeyAliases: function() { return /* reexport safe */ _normalize__WEBPACK_IMPORTED_MODULE_5__.jB; },
/* harmony export */   normalizeLicense: function() { return /* reexport safe */ _normalize__WEBPACK_IMPORTED_MODULE_5__.f; },
/* harmony export */   normalizePath: function() { return /* reexport safe */ _normalize__WEBPACK_IMPORTED_MODULE_5__.Fd; },
/* harmony export */   normalizeRelativePath: function() { return /* reexport safe */ _normalize__WEBPACK_IMPORTED_MODULE_5__.Vd; },
/* harmony export */   normalizeSize: function() { return /* reexport safe */ _normalize__WEBPACK_IMPORTED_MODULE_5__.rn; },
/* harmony export */   normalizeUrl: function() { return /* reexport safe */ _normalize__WEBPACK_IMPORTED_MODULE_5__.l2; },
/* harmony export */   offset: function() { return /* reexport safe */ _size__WEBPACK_IMPORTED_MODULE_6__.cY; },
/* harmony export */   position: function() { return /* reexport safe */ _size__WEBPACK_IMPORTED_MODULE_6__.G1; },
/* harmony export */   safeHTML: function() { return /* reexport safe */ _html__WEBPACK_IMPORTED_MODULE_4__.t_; },
/* harmony export */   sanitizeHTMLElement: function() { return /* reexport safe */ _html__WEBPACK_IMPORTED_MODULE_4__.vn; },
/* harmony export */   setTimeout: function() { return /* reexport safe */ _async__WEBPACK_IMPORTED_MODULE_1__.w; },
/* harmony export */   size: function() { return /* reexport safe */ _size__WEBPACK_IMPORTED_MODULE_6__.Ej; },
/* harmony export */   splitArray: function() { return /* reexport safe */ _array__WEBPACK_IMPORTED_MODULE_0__.uM; },
/* harmony export */   sprintf: function() { return /* reexport safe */ _string__WEBPACK_IMPORTED_MODULE_7__.nv; },
/* harmony export */   stringify: function() { return /* reexport safe */ _string__WEBPACK_IMPORTED_MODULE_7__.As; },
/* harmony export */   stripTags: function() { return /* reexport safe */ _html__WEBPACK_IMPORTED_MODULE_4__.Kq; },
/* harmony export */   toArray: function() { return /* reexport safe */ _array__WEBPACK_IMPORTED_MODULE_0__.$r; },
/* harmony export */   trim: function() { return /* reexport safe */ _string__WEBPACK_IMPORTED_MODULE_7__.Bq; },
/* harmony export */   trimChars: function() { return /* reexport safe */ _string__WEBPACK_IMPORTED_MODULE_7__.Gd; },
/* harmony export */   trimInv: function() { return /* reexport safe */ _string__WEBPACK_IMPORTED_MODULE_7__.gj; },
/* harmony export */   ucfirst: function() { return /* reexport safe */ _string__WEBPACK_IMPORTED_MODULE_7__.Z2; }
/* harmony export */ });
/* harmony import */ var _array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(32709);
/* harmony import */ var _async__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(89044);
/* harmony import */ var _checker__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9823);
/* harmony import */ var _color__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(93495);
/* harmony import */ var _html__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(16113);
/* harmony import */ var _normalize__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(65499);
/* harmony import */ var _size__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(34125);
/* harmony import */ var _string__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(6589);
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(97369);
/* harmony reexport (unknown) */ var __WEBPACK_REEXPORT_OBJECT__ = {};
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _utils__WEBPACK_IMPORTED_MODULE_8__) if(["default","asArray","splitArray","toArray","clearTimeout","setTimeout","hasBrowserColorPicker","hasContainer","isAbortError","isArray","isBoolean","isDestructable","isEqual","isFastEqual","isFunction","isHTML","isHtmlFromWord","isInitable","isInt","isJoditObject","isLicense","isMarker","isNativeFunction","isNumber","isNumeric","isPlainObject","isPromise","isSet","isString","isStringArray","isURL","isValidName","isViewObject","isVoid","isWindow","colorToHex","applyStyles","cleanFromWord","htmlspecialchars","nl2br","safeHTML","sanitizeHTMLElement","stripTags","NUMBER_FIELDS_REG","normalizeColor","normalizeCssNumericValue","normalizeCssValue","normalizeKeyAliases","normalizeLicense","normalizePath","normalizeRelativePath","normalizeSize","normalizeUrl","getContentWidth","getScrollParent","innerWidth","offset","position","size","CamelCaseToKebabCase","camelCase","fuzzySearchIndex","i18n","kebabCase","sprintf","stringify","trim","trimChars","trimInv","ucfirst"].indexOf(__WEBPACK_IMPORT_KEY__) < 0) __WEBPACK_REEXPORT_OBJECT__[__WEBPACK_IMPORT_KEY__] = function(key) { return _utils__WEBPACK_IMPORTED_MODULE_8__[key]; }.bind(0, __WEBPACK_IMPORT_KEY__)
/* harmony reexport (unknown) */ __webpack_require__.d(__webpack_exports__, __WEBPACK_REEXPORT_OBJECT__);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * [[include:core/helpers/README.md]]
 * @packageDocumentation
 * @module helpers
 */











/***/ }),

/***/ 65499:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   $2: function() { return /* reexport safe */ _normalize_color__WEBPACK_IMPORTED_MODULE_0__.$; },
/* harmony export */   Fd: function() { return /* reexport safe */ _normalize_path__WEBPACK_IMPORTED_MODULE_4__.F; },
/* harmony export */   Vd: function() { return /* reexport safe */ _normalize_relative_path__WEBPACK_IMPORTED_MODULE_5__.V; },
/* harmony export */   b$: function() { return /* reexport safe */ _normalize_css_value__WEBPACK_IMPORTED_MODULE_1__.b$; },
/* harmony export */   f: function() { return /* reexport safe */ _normalize_license__WEBPACK_IMPORTED_MODULE_3__.f; },
/* harmony export */   iy: function() { return /* reexport safe */ _normalize_css_value__WEBPACK_IMPORTED_MODULE_1__.iy; },
/* harmony export */   jB: function() { return /* reexport safe */ _normalize_key_aliases__WEBPACK_IMPORTED_MODULE_2__.j; },
/* harmony export */   l2: function() { return /* reexport safe */ _normalize_url__WEBPACK_IMPORTED_MODULE_7__.l; },
/* harmony export */   n8: function() { return /* reexport safe */ _normalize_css_value__WEBPACK_IMPORTED_MODULE_1__.n8; },
/* harmony export */   rn: function() { return /* reexport safe */ _normalize_size__WEBPACK_IMPORTED_MODULE_6__.r; }
/* harmony export */ });
/* harmony import */ var _normalize_color__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(73446);
/* harmony import */ var _normalize_css_value__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(59678);
/* harmony import */ var _normalize_key_aliases__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(74995);
/* harmony import */ var _normalize_license__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(31138);
/* harmony import */ var _normalize_path__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(92998);
/* harmony import */ var _normalize_relative_path__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(13265);
/* harmony import */ var _normalize_size__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(7920);
/* harmony import */ var _normalize_url__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(39344);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/normalize
 */










/***/ }),

/***/ 73446:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   $: function() { return /* binding */ normalizeColor; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_color_color_to_hex__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(96768);
/* harmony import */ var jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(59101);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/normalize
 */


/**
 * Convert rgba and short HEX color to Full text color. #fff to #FFFFFF
 *
 * @param colorInput - string like rgba(red, green, blue, alpha) or rgb(red, green, blue) or #fff or #ffffff
 * @returns HEX color, false - for transparent color
 */
const normalizeColor = (colorInput) => {
    const newcolor = ['#'];
    let color = (0,jodit_core_helpers_color_color_to_hex__WEBPACK_IMPORTED_MODULE_1__/* .colorToHex */ .s)(colorInput);
    if (!color) {
        return false;
    }
    color = (0,jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_0__/* .trim */ .Bq)(color.toUpperCase());
    color = color.substring(1);
    if (color.length === 3) {
        for (let i = 0; i < 3; i += 1) {
            newcolor.push(color[i]);
            newcolor.push(color[i]);
        }
        return newcolor.join('');
    }
    if (color.length > 6) {
        color = color.slice(0, 6);
    }
    return '#' + color;
};


/***/ }),

/***/ 59678:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   b$: function() { return /* binding */ NUMBER_FIELDS_REG; },
/* harmony export */   iy: function() { return /* binding */ normalizeCssValue; },
/* harmony export */   n8: function() { return /* binding */ normalizeCssNumericValue; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_numeric__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(12461);
/* harmony import */ var jodit_core_helpers_checker_is_void__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(35642);
/* harmony import */ var jodit_core_helpers_color_color_to_hex__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(96768);
/* harmony import */ var jodit_core_helpers_string_kebab_case__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(449);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/normalize
 */




const NUMBER_FIELDS_REG = /^(left|top|bottom|right|width|min|max|height|margin|padding|fontsize|font-size)/i;
function normalizeCssNumericValue(key, value) {
    if (!(0,jodit_core_helpers_checker_is_void__WEBPACK_IMPORTED_MODULE_0__/* .isVoid */ .R)(value) &&
        NUMBER_FIELDS_REG.test(key) &&
        (0,jodit_core_helpers_checker_is_numeric__WEBPACK_IMPORTED_MODULE_1__/* .isNumeric */ .k)(value.toString())) {
        return parseInt(value.toString(), 10) + 'px';
    }
    return value;
}
function normalizeCssValue(key, value) {
    switch ((0,jodit_core_helpers_string_kebab_case__WEBPACK_IMPORTED_MODULE_2__/* .kebabCase */ .k)(key)) {
        case 'font-weight':
            switch (value.toString().toLowerCase()) {
                case '700':
                case 'bold':
                    return 700;
                case '400':
                case 'normal':
                    return 400;
                case '900':
                case 'heavy':
                    return 900;
            }
            return (0,jodit_core_helpers_checker_is_numeric__WEBPACK_IMPORTED_MODULE_1__/* .isNumeric */ .k)(value) ? Number(value) : value;
    }
    if (/color/i.test(key) && /^rgb/i.test(value.toString())) {
        return (0,jodit_core_helpers_color_color_to_hex__WEBPACK_IMPORTED_MODULE_3__/* .colorToHex */ .s)(value.toString()) || value;
    }
    return value;
}


/***/ }),

/***/ 74995:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   j: function() { return /* binding */ normalizeKeyAliases; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(59101);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


/**
 * Normalize keys to some standard name
 */
function normalizeKeyAliases(keys) {
    const memory = {};
    const order = {
        meta: 1,
        ctrl: 2,
        control: 2,
        alt: 3,
        shift: 4
    };
    return keys
        .replace(/\+\+/g, '+add')
        .split(/[\s]*\+[\s]*/)
        .map(key => (0,jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_1__/* .trim */ .Bq)(key.toLowerCase()))
        .map(key => jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_ALIASES[key] || key)
        .sort((a, b) => {
        if (order[a] && !order[b]) {
            return -1;
        }
        if (!order[a] && order[b]) {
            return 1;
        }
        if (order[a] && order[b]) {
            return order[a] - order[b];
        }
        return a > b ? 1 : -1;
    })
        .filter(key => !memory[key] && key !== '' && (memory[key] = true))
        .join('+');
}


/***/ }),

/***/ 31138:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   f: function() { return /* binding */ normalizeLicense; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/normalize
 */
const normalizeLicense = (license, count = 8) => {
    const parts = [];
    while (license.length) {
        parts.push(license.substr(0, count));
        license = license.substr(count);
    }
    parts[1] = parts[1].replace(/./g, '*');
    parts[2] = parts[2].replace(/./g, '*');
    return parts.join('-');
};


/***/ }),

/***/ 92998:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   F: function() { return /* binding */ normalizePath; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(59101);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/normalize
 */

/**
 * Replaces back slashes and correctly concatenates several parts of the path.
 */
const normalizePath = (...path) => {
    return path
        .filter(part => (0,jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_0__/* .trim */ .Bq)(part).length)
        .map((part, index) => {
        part = part.replace(/([^:])[\\/]+/g, '$1/');
        if (index) {
            part = part.replace(/^\//, '');
        }
        if (index !== path.length - 1) {
            part = part.replace(/\/$/, '');
        }
        return part;
    })
        .join('/');
};


/***/ }),

/***/ 13265:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   V: function() { return /* binding */ normalizeRelativePath; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/normalize
 */
const normalizeRelativePath = (path) => {
    const sections = path.split('/'), builder = sections.reduce((builder, section) => {
        switch (section) {
            case '': {
                break;
            }
            case '.': {
                break;
            }
            case '..': {
                builder.pop();
                break;
            }
            default: {
                builder.push(section);
                break;
            }
        }
        return builder;
    }, []);
    return builder.join('/') + (path.endsWith('/') ? '/' : '');
};


/***/ }),

/***/ 7920:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   r: function() { return /* binding */ normalizeSize; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/normalize
 */
/**
 * Normalize value to CSS meters
 */
const normalizeSize = (value, units) => {
    if (/^[0-9]+$/.test(value.toString())) {
        return value + units;
    }
    return value.toString();
};


/***/ }),

/***/ 39344:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   l: function() { return /* binding */ normalizeUrl; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/normalize
 */
const normalizeUrl = (...urls) => {
    return urls
        .filter(url => url.length)
        .map(url => url.replace(/\/$/, ''))
        .join('/')
        .replace(/([^:])[\\/]+/g, '$1/');
};


/***/ }),

/***/ 73780:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   y: function() { return /* binding */ getContentWidth; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/size
 */
const getContentWidth = (element, win) => {
    const pi = (value) => parseInt(value, 10), style = win.getComputedStyle(element), width = element.offsetWidth, paddingLeft = pi(style.getPropertyValue('padding-left') || '0'), paddingRight = pi(style.getPropertyValue('padding-right') || '0');
    return width - paddingLeft - paddingRight;
};


/***/ }),

/***/ 98228:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   m: function() { return /* binding */ getScrollParent; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(97369);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


function getScrollParent(node) {
    if (!node) {
        return null;
    }
    const isElement = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isHTMLElement(node);
    const overflowY = isElement && (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.css)(node, 'overflowY');
    const isScrollable = isElement && overflowY !== 'visible' && overflowY !== 'hidden';
    if (isScrollable && node.scrollHeight >= node.clientHeight) {
        return node;
    }
    return (getScrollParent(node.parentNode) ||
        document.scrollingElement ||
        document.body);
}


/***/ }),

/***/ 34125:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Ej: function() { return /* reexport safe */ _object_size__WEBPACK_IMPORTED_MODULE_3__.E; },
/* harmony export */   G1: function() { return /* reexport safe */ _position__WEBPACK_IMPORTED_MODULE_5__.G; },
/* harmony export */   cY: function() { return /* reexport safe */ _offset__WEBPACK_IMPORTED_MODULE_4__.c; },
/* harmony export */   mH: function() { return /* reexport safe */ _get_scroll_parent__WEBPACK_IMPORTED_MODULE_1__.m; },
/* harmony export */   xM: function() { return /* reexport safe */ _inner_width__WEBPACK_IMPORTED_MODULE_2__.x; },
/* harmony export */   y6: function() { return /* reexport safe */ _get_content_width__WEBPACK_IMPORTED_MODULE_0__.y; }
/* harmony export */ });
/* harmony import */ var _get_content_width__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(73780);
/* harmony import */ var _get_scroll_parent__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(98228);
/* harmony import */ var _inner_width__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(49744);
/* harmony import */ var _object_size__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(95350);
/* harmony import */ var _offset__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(91594);
/* harmony import */ var _position__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(27594);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/size
 */








/***/ }),

/***/ 49744:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   x: function() { return /* binding */ innerWidth; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/size
 */
const innerWidth = (element, win) => {
    const computedStyle = win.getComputedStyle(element);
    let elementWidth = element.clientWidth; // width with padding
    elementWidth -=
        parseFloat(computedStyle.paddingLeft || '0') +
            parseFloat(computedStyle.paddingRight || '0');
    return elementWidth;
};


/***/ }),

/***/ 95350:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   E: function() { return /* binding */ size; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9823);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

function size(subject) {
    if ((0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_0__/* .isString */ .Kg)(subject) || (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_0__/* .isArray */ .cy)(subject)) {
        return subject.length;
    }
    if ((0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_0__/* .isPlainObject */ .Qd)(subject)) {
        return Object.keys(subject).length;
    }
    return 0;
}


/***/ }),

/***/ 91594:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   c: function() { return /* binding */ offset; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
const offset = (elm, jodit, doc, recurse = false) => {
    let rect;
    try {
        rect = elm.getBoundingClientRect();
    }
    catch (e) {
        rect = {
            top: 0,
            bottom: 0,
            left: 0,
            right: 0,
            width: 0,
            height: 0
        };
    }
    const body = doc.body, docElem = doc.documentElement || {
        clientTop: 0,
        clientLeft: 0,
        scrollTop: 0,
        scrollLeft: 0
    }, win = doc.defaultView || doc.parentWindow, scrollTop = win.pageYOffset || docElem.scrollTop || body.scrollTop, scrollLeft = win.pageXOffset || docElem.scrollLeft || body.scrollLeft, clientTop = docElem.clientTop || body.clientTop || 0, clientLeft = docElem.clientLeft || body.clientLeft || 0;
    let topValue, leftValue;
    const iframe = jodit.iframe;
    if (!recurse && jodit && jodit.options && jodit.o.iframe && iframe) {
        const { top, left } = offset(iframe, jodit, jodit.od, true);
        topValue = rect.top + top;
        leftValue = rect.left + left;
    }
    else {
        topValue = rect.top + scrollTop - clientTop;
        leftValue = rect.left + scrollLeft - clientLeft;
    }
    return {
        top: Math.round(topValue),
        left: Math.round(leftValue),
        width: rect.width,
        height: rect.height
    };
};


/***/ }),

/***/ 27594:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   G: function() { return /* binding */ position; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_jodit_object__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(83044);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

/**
 * Calculate screen element position
 */
function position(elm, jodit, recurse = false) {
    var _a, _b;
    const rect = elm.getBoundingClientRect();
    let xPos = rect.left, yPos = rect.top;
    if ((0,jodit_core_helpers_checker_is_jodit_object__WEBPACK_IMPORTED_MODULE_0__/* .isJoditObject */ .y)(jodit) &&
        jodit.iframe &&
        jodit.ed.body.contains(elm) &&
        !recurse) {
        const { left, top } = position(jodit.iframe, jodit, true);
        xPos += left;
        yPos += top;
    }
    return {
        left: Math.round(xPos),
        top: Math.round(yPos),
        width: Math.round((_a = elm.offsetWidth) !== null && _a !== void 0 ? _a : rect.width),
        height: Math.round((_b = elm.offsetHeight) !== null && _b !== void 0 ? _b : rect.height)
    };
}


/***/ }),

/***/ 83260:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   x: function() { return /* binding */ camelCase; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/string
 */
/**
 * Convert (kebab-case or snake_case) to camelCase
 */
const camelCase = (key) => {
    return key.replace(/([-_])(.)/g, (m, code, letter) => {
        return letter.toUpperCase();
    });
};


/***/ }),

/***/ 67975:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   H: function() { return /* binding */ fuzzySearchIndex; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/string
 */

/**
 * Finds the position of the substring in the string, if any, and returns the length of the found subsequence.
 * Unlike `indexOf` ignores INVISIBLE_SPACE and may fail at `maxDistance` characters
 */
function fuzzySearchIndex(needle, haystack, offset = 0, maxDistance = 1) {
    let i = 0, j = 0, startIndex = -1, len = 0, errorDistance = 0;
    for (j = offset; i < needle.length && j < haystack.length;) {
        if (needle[i].toLowerCase() === haystack[j].toLowerCase()) {
            i++;
            len++;
            errorDistance = 0;
            if (startIndex === -1) {
                startIndex = j;
            }
        }
        else if (i > 0) {
            if (errorDistance >= maxDistance &&
                haystack[j] !== jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INVISIBLE_SPACE) {
                i = 0;
                startIndex = -1;
                len = 0;
                errorDistance = 0;
                j--;
            }
            else {
                errorDistance++;
                len++;
            }
        }
        j++;
    }
    return i === needle.length ? [startIndex, len] : [-1, 0];
}


/***/ }),

/***/ 91093:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   R: function() { return /* binding */ i18n; },
/* harmony export */   n: function() { return /* binding */ sprintf; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(98253);
/* harmony import */ var jodit_core_helpers_string_ucfirst__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(10467);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(97369);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(36115);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */





/**
 * Simple variant sprintf function
 */
const sprintf = (str, args) => {
    if (!args || !args.length) {
        return str;
    }
    const reg = /%([sd])/g;
    let fnd = reg.exec(str);
    let res = str, i = 0;
    while (fnd && args[i] !== undefined) {
        res = res.replace(fnd[0], args[i].toString());
        i += 1;
        fnd = reg.exec(str);
    }
    return res;
};
/**
 * Internationalization method. Uses Jodit.lang object
 * @example
 * ```javascript
 * var editor = Jodit.make("#redactor", {
 *      language: 'ru'
 * });
 * console.log(editor.i18n('Cancel')) //Отмена;
 *
 * Jodit.defaultOptions.language = 'ru';
 * console.log(Jodit.prototype.i18n('Cancel')) //Отмена
 *
 * Jodit.lang.cs = {
 *    Cancel: 'Zrušit'
 * };
 * Jodit.defaultOptions.language = 'cs';
 * console.log(Jodit.prototype.i18n('Cancel')) //Zrušit
 *
 * Jodit.lang.cs = {
 *    'Hello world': 'Hello \s Good \s'
 * };
 * Jodit.defaultOptions.language = 'cs';
 * console.log(Jodit.prototype.i18n('Hello world', 'mr.Perkins', 'day')) //Hello mr.Perkins Good day
 * ```
 */
function i18n(key, params, options) {
    if (!(0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_3__/* .isString */ .K)(key)) {
        throw (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.error)('i18n: Need string in first argument');
    }
    if (!key.length) {
        return key;
    }
    const debug = Boolean(options === null || options === void 0 ? void 0 : options.debugLanguage);
    let store = {};
    const parse = (value) => params && params.length ? sprintf(value, params) : value, defaultLanguage = (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.defaultLanguage)(jodit_config__WEBPACK_IMPORTED_MODULE_2__/* .Config */ .T.defaultOptions.language, jodit_config__WEBPACK_IMPORTED_MODULE_2__/* .Config */ .T.defaultOptions.language), language = (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.defaultLanguage)(options === null || options === void 0 ? void 0 : options.language, defaultLanguage), tryGet = (store) => {
        if (!store) {
            return;
        }
        if ((0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_3__/* .isString */ .K)(store[key])) {
            return parse(store[key]);
        }
        const lcKey = key.toLowerCase();
        if ((0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_3__/* .isString */ .K)(store[lcKey])) {
            return parse(store[lcKey]);
        }
        const ucfKey = (0,jodit_core_helpers_string_ucfirst__WEBPACK_IMPORTED_MODULE_4__/* .ucfirst */ .Z)(key);
        if ((0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_3__/* .isString */ .K)(store[ucfKey])) {
            return parse(store[ucfKey]);
        }
        return;
    };
    if (jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.lang[language] !== undefined) {
        store = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.lang[language];
    }
    else if (!debug) {
        if (jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.lang[defaultLanguage] !== undefined) {
            store = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.lang[defaultLanguage];
        }
        else {
            store = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.lang.en;
        }
    }
    const i18nOvr = options === null || options === void 0 ? void 0 : options.i18n;
    if (i18nOvr && i18nOvr[language]) {
        const result = tryGet(i18nOvr[language]);
        if (result) {
            return result;
        }
    }
    const result = tryGet(store);
    if (result) {
        return result;
    }
    if (!debug && jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.lang.en && (0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_3__/* .isString */ .K)(jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.lang.en[key]) && jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.lang.en[key]) {
        return parse(jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.lang.en[key]);
    }
    if (debug) {
        return '{' + key + '}';
    }
    if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD && language !== 'en') {
        console.warn(`i18n need "${key}" in "${language}"`);
    }
    return parse(key);
}


/***/ }),

/***/ 6589:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   As: function() { return /* reexport safe */ _stringify__WEBPACK_IMPORTED_MODULE_4__.A; },
/* harmony export */   Bq: function() { return /* reexport safe */ _trim__WEBPACK_IMPORTED_MODULE_5__.Bq; },
/* harmony export */   Gd: function() { return /* reexport safe */ _trim__WEBPACK_IMPORTED_MODULE_5__.Gd; },
/* harmony export */   Hp: function() { return /* reexport safe */ _fuzzy_search_index__WEBPACK_IMPORTED_MODULE_1__.H; },
/* harmony export */   N: function() { return /* reexport safe */ _kebab_case__WEBPACK_IMPORTED_MODULE_3__.N; },
/* harmony export */   Ru: function() { return /* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_2__.R; },
/* harmony export */   Z2: function() { return /* reexport safe */ _ucfirst__WEBPACK_IMPORTED_MODULE_6__.Z; },
/* harmony export */   gj: function() { return /* reexport safe */ _trim__WEBPACK_IMPORTED_MODULE_5__.gj; },
/* harmony export */   kW: function() { return /* reexport safe */ _kebab_case__WEBPACK_IMPORTED_MODULE_3__.k; },
/* harmony export */   nv: function() { return /* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_2__.n; },
/* harmony export */   xQ: function() { return /* reexport safe */ _camel_case__WEBPACK_IMPORTED_MODULE_0__.x; }
/* harmony export */ });
/* harmony import */ var _camel_case__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(83260);
/* harmony import */ var _fuzzy_search_index__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(67975);
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(91093);
/* harmony import */ var _kebab_case__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(449);
/* harmony import */ var _stringify__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(28616);
/* harmony import */ var _trim__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(59101);
/* harmony import */ var _ucfirst__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(10467);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/string
 */









/***/ }),

/***/ 449:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   N: function() { return /* binding */ CamelCaseToKebabCase; },
/* harmony export */   k: function() { return /* binding */ kebabCase; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/string
 */
const kebabCase = (key) => {
    return key
        .replace(/([A-Z])([A-Z])([a-z])/g, '$1-$2$3')
        .replace(/([a-z])([A-Z])/g, '$1-$2')
        .replace(/[\s_]+/g, '-')
        .toLowerCase();
};
const CamelCaseToKebabCase = (key) => {
    return key
        .replace(/([A-Z])([A-Z])([a-z])/g, '$1-$2$3')
        .replace(/([a-z])([A-Z])/g, '$1-$2')
        .toLowerCase();
};


/***/ }),

/***/ 28616:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: function() { return /* binding */ stringify; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * Safe stringify circular object
 */
function stringify(value, options = {}) {
    if (typeof value !== 'object') {
        return String(value);
    }
    const excludeKeys = new Set(options.excludeKeys);
    const map = new WeakMap();
    const r = (k, v) => {
        if (excludeKeys.has(k)) {
            return;
        }
        if (typeof v === 'object' && v != null) {
            if (map.get(v)) {
                return '[refObject]';
            }
            map.set(v, true);
        }
        return v;
    };
    return JSON.stringify(value, r, options.prettify);
}


/***/ }),

/***/ 59101:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Bq: function() { return /* binding */ trim; },
/* harmony export */   Gd: function() { return /* binding */ trimChars; },
/* harmony export */   gj: function() { return /* binding */ trimInv; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/string
 */

/**
 * It clears the line of all auxiliary invisible characters , from the spaces and line breaks , tabs
 * from the beginning and end of the line
 */
function trim(value) {
    return value
        .replace((0,jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.SPACE_REG_EXP_END)(), '')
        .replace((0,jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.SPACE_REG_EXP_START)(), '');
}
function trimChars(value, chars) {
    return value
        .replace(RegExp(`[${chars}]+$`), '')
        .replace(RegExp(`^[${chars}]+`), '');
}
/**
 * Trim only invisible chars
 */
function trimInv(value) {
    return value
        .replace((0,jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INVISIBLE_SPACE_REG_EXP_END)(), '')
        .replace((0,jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INVISIBLE_SPACE_REG_EXP_START)(), '');
}


/***/ }),

/***/ 10467:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: function() { return /* binding */ ucfirst; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/string
 */
/**
 * Make a string's first character uppercase
 */
function ucfirst(value) {
    if (!value.length) {
        return '';
    }
    return value[0].toUpperCase() + value.substring(1);
}


/***/ }),

/***/ 40080:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Mr: function() { return /* binding */ hAlignElement; },
/* harmony export */   Op: function() { return /* binding */ alignElement; },
/* harmony export */   Xm: function() { return /* binding */ clearAlign; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38322);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


/**
 * Align image
 */
function hAlignElement(image, align) {
    if (align && align !== 'normal') {
        if (align !== 'center') {
            (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_1__/* .css */ .A)(image, 'float', align);
            (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_1__/* .clearCenterAlign */ .a)(image);
        }
        else {
            (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_1__/* .css */ .A)(image, {
                float: '',
                display: 'block',
                marginLeft: 'auto',
                marginRight: 'auto'
            });
        }
    }
    else {
        if ((0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_1__/* .css */ .A)(image, 'float') &&
            ['right', 'left'].indexOf((0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_1__/* .css */ .A)(image, 'float').toString().toLowerCase()) !== -1) {
            (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_1__/* .css */ .A)(image, 'float', '');
        }
        (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_1__/* .clearCenterAlign */ .a)(image);
    }
}
/**
 * Remove text-align style for all selected children
 */
function clearAlign(node) {
    jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.each(node, elm => {
        if (jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isHTMLElement(elm)) {
            if (elm.style.textAlign) {
                elm.style.textAlign = '';
                if (!elm.style.cssText.trim().length) {
                    elm.removeAttribute('style');
                }
            }
        }
    });
}
/**
 * Apply align for element
 */
function alignElement(command, box) {
    if (jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isNode(box) && jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isElement(box)) {
        clearAlign(box);
        switch (command.toLowerCase()) {
            case 'justifyfull':
                box.style.textAlign = 'justify';
                break;
            case 'justifyright':
                box.style.textAlign = 'right';
                break;
            case 'justifyleft':
                box.style.textAlign = 'left';
                break;
            case 'justifycenter':
                box.style.textAlign = 'center';
                break;
        }
    }
}


/***/ }),

/***/ 27301:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Qt: function() { return /* binding */ loadNext; },
/* harmony export */   S5: function() { return /* binding */ appendStyleAsync; },
/* harmony export */   w4: function() { return /* binding */ appendScriptAsync; },
/* harmony export */   x_: function() { return /* binding */ loadNextStyle; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(98253);
/* harmony import */ var _complete_url__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(60346);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



const alreadyLoadedList = new Map();
const cacheLoaders = (loader) => {
    return (jodit, url) => (0,tslib__WEBPACK_IMPORTED_MODULE_0__/* .__awaiter */ .sH)(void 0, void 0, void 0, function* () {
        if (alreadyLoadedList.has(url)) {
            return alreadyLoadedList.get(url);
        }
        const promise = loader(jodit, url);
        alreadyLoadedList.set(url, promise);
        return promise;
    });
};
/**
 * Load script and return promise
 */
const appendScriptAsync = cacheLoaders((jodit, url) => {
    return jodit.async.promise((resolve, reject) => {
        if (jodit.isInDestruct) {
            return reject();
        }
        const script = jodit.c.element('script', {
            type: 'text/javascript',
            crossorigin: 'anonymous',
            referrerpolicy: 'no-referrer',
            async: true,
            src: (0,_complete_url__WEBPACK_IMPORTED_MODULE_1__/* .completeUrl */ .X)(url)
        });
        jodit.od.body.appendChild(script);
        jodit.e.on(script, 'error', reject).on(script, 'load', resolve);
    });
});
/**
 * Download CSS style script
 */
const appendStyleAsync = cacheLoaders((jodit, url) => {
    return jodit.async.promise((resolve, reject) => {
        if (jodit.isInDestruct) {
            return reject();
        }
        const link = jodit.c.element('link');
        link.rel = 'stylesheet';
        link.media = 'all';
        link.crossOrigin = 'anonymous';
        const callback = () => resolve(link);
        !jodit.isInDestruct &&
            jodit.e.on(link, 'load', callback).on(link, 'error', reject);
        link.href = (0,_complete_url__WEBPACK_IMPORTED_MODULE_1__/* .completeUrl */ .X)(url);
        if (jodit.o.shadowRoot) {
            jodit.o.shadowRoot.appendChild(link);
        }
        else {
            jodit.od.body.appendChild(link);
        }
    });
});
function loadNext(jodit, urls, i = 0) {
    if (!(0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_2__/* .isString */ .K)(urls[i])) {
        return Promise.resolve();
    }
    return appendScriptAsync(jodit, urls[i]).then(() => loadNext(jodit, urls, i + 1));
}
function loadNextStyle(jodit, urls, i = 0) {
    if (!(0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_2__/* .isString */ .K)(urls[i])) {
        return Promise.resolve();
    }
    return appendStyleAsync(jodit, urls[i]).then(() => loadNextStyle(jodit, urls, i + 1));
}


/***/ }),

/***/ 26150:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   C: function() { return /* binding */ attr; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9823);
/* harmony import */ var jodit_core_helpers_string_kebab_case__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(449);
/* harmony import */ var _css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38322);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



/**
 * Alias for `elm.getAttribute` but if set second argument `-{key}`
 * it will also check `data-{key}` attribute
 * if set `value` it is alias for setAttribute with the same logic
 */
function attr(elm, keyOrAttributes, value) {
    if (!elm || !(0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_0__/* .isFunction */ .Tn)(elm.getAttribute)) {
        return null;
    }
    if (!(0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_0__/* .isString */ .Kg)(keyOrAttributes)) {
        Object.keys(keyOrAttributes).forEach(key => {
            const value = keyOrAttributes[key];
            if ((0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_0__/* .isPlainObject */ .Qd)(value) && key === 'style') {
                (0,_css__WEBPACK_IMPORTED_MODULE_1__/* .css */ .A)(elm, value);
            }
            else {
                if (key === 'className') {
                    key = 'class';
                }
                attr(elm, key, value);
            }
        });
        return null;
    }
    let key = (0,jodit_core_helpers_string_kebab_case__WEBPACK_IMPORTED_MODULE_2__/* .CamelCaseToKebabCase */ .N)(keyOrAttributes);
    if (/^-/.test(key)) {
        const res = attr(elm, `data${key}`);
        if (res) {
            return res;
        }
        key = key.substr(1);
    }
    if (value !== undefined) {
        if (value == null) {
            elm.hasAttribute(key) && elm.removeAttribute(key);
        }
        else {
            let replaceValue = value.toString();
            if (elm.nodeName === 'IMG' &&
                (key === 'width' || key === 'height')) {
                replaceValue = replaceValue.replace('px', '');
            }
            elm.setAttribute(key, replaceValue);
            return replaceValue;
        }
    }
    return elm.getAttribute(key);
}


/***/ }),

/***/ 65717:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   T: function() { return /* binding */ browser; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/utils
 */
/**
 * Module returns method that is used to determine the browser
 * @example
 * ```javascript
 * console.log(Jodit.modules.Helpers.browser('mse'));
 * console.log(Jodit.modules.Helpers.browser('chrome'));
 * console.log($Jodit.modules.Helpers.browser('opera'));
 * console.log(Jodit.modules.Helpers.browser('firefox'));
 * console.log(Jodit.modules.Helpers.browser('mse') && Jodit.modules.Helpers.browser('version') > 10);
 * ```
 */
const browser = (browser) => {
    const ua = navigator.userAgent.toLowerCase(), match = /(firefox)[\s/]([\w.]+)/.exec(ua) ||
        /(chrome)[\s/]([\w.]+)/.exec(ua) ||
        /(webkit)[\s/]([\w.]+)/.exec(ua) ||
        /(opera)(?:.*version)[\s/]([\w.]+)/.exec(ua) ||
        /(msie)[\s]([\w.]+)/.exec(ua) ||
        /(trident)\/([\w.]+)/.exec(ua) ||
        ua.indexOf('compatible') < 0 ||
        [];
    if (browser === 'version') {
        return match[2];
    }
    if (browser === 'webkit') {
        return match[1] === 'chrome' || match[1] === 'webkit';
    }
    if (browser === 'ff') {
        return match[1] === 'firefox';
    }
    if (browser === 'msie') {
        return match[1] === 'trident' || match[1] === 'msie';
    }
    return match[1] === browser;
};


/***/ }),

/***/ 76104:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: function() { return /* binding */ buildQuery; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_plain_object__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25376);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

/**
 * Build query string
 */
const buildQuery = (data, prefix) => {
    const str = [];
    const enc = encodeURIComponent;
    for (const dataKey in data) {
        if (Object.prototype.hasOwnProperty.call(data, dataKey)) {
            const k = prefix ? prefix + '[' + dataKey + ']' : dataKey;
            const v = data[dataKey];
            str.push((0,jodit_core_helpers_checker_is_plain_object__WEBPACK_IMPORTED_MODULE_0__/* .isPlainObject */ .Q)(v) ? buildQuery(v, k) : enc(k) + '=' + enc(v));
        }
    }
    return str.join('&');
};


/***/ }),

/***/ 60346:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   X: function() { return /* binding */ completeUrl; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/utils
 */
const completeUrl = (url) => {
    if (window.location.protocol === 'file:' && /^\/\//.test(url)) {
        url = 'https:' + url;
    }
    return url;
};


/***/ }),

/***/ 86248:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   V: function() { return /* binding */ ConfigFlatten; },
/* harmony export */   t: function() { return /* binding */ ConfigProto; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(37923);
/* harmony import */ var jodit_core_helpers_checker_is_plain_object__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(25376);
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(98253);
/* harmony import */ var jodit_core_helpers_checker_is_void__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(35642);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(36115);
/* harmony import */ var _extend__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(49429);
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(84976);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */







/**
 * @example
 * ```js
 * const defaultConfig = {
 *   a: {
 *     b: {
 *       c: 2
 *     },
 *     e: 5
 *   },
 *   d: {
 *     g: 7
 *   }
 * };
 *
 * const options = ConfigProto({a: {
 *   b: {
 *     c: 1
 *   }
 * }}, defaultConfig);
 *
 * console.log(options.a.b.c); // 1
 * console.log(options.a.e); // 5
 * console.log(options.d.g); // 7
 *
 * defaultConfig.d.g  = 8;
 * console.log(options.d.g); // 8
 *
 * ```
 */
function ConfigProto(options, proto, deep = 0) {
    // Already prototyped object should not be prototyped again
    if (Object.getPrototypeOf(options) !== Object.prototype) {
        return options;
    }
    const def = jodit_config__WEBPACK_IMPORTED_MODULE_0__/* .Config */ .T.defaultOptions;
    if ((0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_2__/* .isString */ .K)(options.preset)) {
        if (def.presets[options.preset] !== undefined) {
            const preset = def.presets[options.preset];
            Object.keys(preset).forEach(subKey => {
                if ((0,jodit_core_helpers_checker_is_void__WEBPACK_IMPORTED_MODULE_3__/* .isVoid */ .R)(options[subKey])) {
                    options[subKey] = preset[subKey];
                }
            });
        }
        delete options.preset;
    }
    const newOpt = {};
    Object.keys(options).forEach(key => {
        const opt = options[key], protoKey = proto ? proto[key] : null;
        if ((0,jodit_core_helpers_checker_is_plain_object__WEBPACK_IMPORTED_MODULE_4__/* .isPlainObject */ .Q)(opt) && (0,jodit_core_helpers_checker_is_plain_object__WEBPACK_IMPORTED_MODULE_4__/* .isPlainObject */ .Q)(protoKey) && !(0,_extend__WEBPACK_IMPORTED_MODULE_5__/* .isAtom */ .mA)(opt)) {
            newOpt[key] = ConfigProto(opt, protoKey, deep + 1);
            return;
        }
        // On the first level all arrays are atomic
        if (deep !== 0 && (0,jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_6__/* .isArray */ .c)(opt) && !(0,_extend__WEBPACK_IMPORTED_MODULE_5__/* .isAtom */ .mA)(opt) && (0,jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_6__/* .isArray */ .c)(protoKey)) {
            newOpt[key] = [...opt, ...protoKey.slice(opt.length)];
            return;
        }
        newOpt[key] = opt;
    });
    Object.setPrototypeOf(newOpt, proto);
    return newOpt;
}
function ConfigFlatten(obj) {
    return (0,_utils__WEBPACK_IMPORTED_MODULE_1__/* .keys */ .HP)(obj, false).reduce((app, key) => {
        app[key] = obj[key];
        return app;
    }, {});
}


/***/ }),

/***/ 82807:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   m: function() { return /* binding */ convertMediaUrlToVideoEmbed; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_url__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6939);
/* harmony import */ var _parse_query__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(70807);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/utils
 */


/**
 * Javascript url pattern converter replace youtube/vimeo url in embed code.
 */
const convertMediaUrlToVideoEmbed = (url, width = 400, height = 345) => {
    if (!(0,jodit_core_helpers_checker_is_url__WEBPACK_IMPORTED_MODULE_0__/* .isURL */ .m)(url)) {
        return url;
    }
    const parser = document.createElement('a'), pattern1 = /(?:http?s?:\/\/)?(?:www\.)?(?:vimeo\.com)\/?(.+)/g;
    parser.href = url;
    if (!width) {
        width = 400;
    }
    if (!height) {
        height = 345;
    }
    const protocol = parser.protocol || '';
    switch (parser.hostname) {
        case 'www.vimeo.com':
        case 'vimeo.com':
            return pattern1.test(url)
                ? url.replace(pattern1, '<iframe width="' +
                    width +
                    '" height="' +
                    height +
                    '" src="' +
                    protocol +
                    '//player.vimeo.com/video/$1" frameborder="0" allowfullscreen></iframe>')
                : url;
        case 'youtube.com':
        case 'www.youtube.com':
        case 'youtu.be':
        case 'www.youtu.be': {
            const query = parser.search
                ? (0,_parse_query__WEBPACK_IMPORTED_MODULE_1__/* .parseQuery */ .m)(parser.search)
                : { v: parser.pathname.substr(1) };
            return query.v
                ? '<iframe width="' +
                    width +
                    '" height="' +
                    height +
                    '" src="' +
                    protocol +
                    '//www.youtube.com/embed/' +
                    query.v +
                    '" frameborder="0" allowfullscreen></iframe>'
                : url;
        }
    }
    return url;
};


/***/ }),

/***/ 38322:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: function() { return /* binding */ css; },
/* harmony export */   a: function() { return /* binding */ clearCenterAlign; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_boolean__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9810);
/* harmony import */ var jodit_core_helpers_checker_is_plain_object__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(25376);
/* harmony import */ var jodit_core_helpers_normalize_normalize_css_value__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(59678);
/* harmony import */ var jodit_core_helpers_string_camel_case__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(83260);
/* harmony import */ var jodit_core_helpers_string_kebab_case__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(449);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */





/**
 * Get the value of a computed style property for the first element in the set of matched elements or set one or
 * more CSS properties for every matched element
 *
 * @param element - HTML element
 * @param key - An object of property-value pairs to set. A CSS property name.
 * @param value - A value to set for the property.
 * @param onlyStyleMode - Get value from style attribute, without calculating
 */
function css(element, key, value, onlyStyleMode = false) {
    if ((0,jodit_core_helpers_checker_is_boolean__WEBPACK_IMPORTED_MODULE_0__/* .isBoolean */ .L)(value)) {
        onlyStyleMode = value;
        value = undefined;
    }
    if ((0,jodit_core_helpers_checker_is_plain_object__WEBPACK_IMPORTED_MODULE_1__/* .isPlainObject */ .Q)(key) || value !== undefined) {
        const setValue = (elm, _key, _value) => {
            _value = (0,jodit_core_helpers_normalize_normalize_css_value__WEBPACK_IMPORTED_MODULE_2__/* .normalizeCssNumericValue */ .n8)(_key, _value);
            if (_value !== undefined &&
                (_value == null ||
                    css(elm, _key, true) !== (0,jodit_core_helpers_normalize_normalize_css_value__WEBPACK_IMPORTED_MODULE_2__/* .normalizeCssValue */ .iy)(_key, _value))) {
                elm.style[_key] = _value;
            }
        };
        if ((0,jodit_core_helpers_checker_is_plain_object__WEBPACK_IMPORTED_MODULE_1__/* .isPlainObject */ .Q)(key)) {
            const keys = Object.keys(key);
            for (let j = 0; j < keys.length; j += 1) {
                setValue(element, (0,jodit_core_helpers_string_camel_case__WEBPACK_IMPORTED_MODULE_3__/* .camelCase */ .x)(keys[j]), key[keys[j]]);
            }
        }
        else {
            setValue(element, (0,jodit_core_helpers_string_camel_case__WEBPACK_IMPORTED_MODULE_3__/* .camelCase */ .x)(key), value);
        }
        return '';
    }
    const key2 = (0,jodit_core_helpers_string_kebab_case__WEBPACK_IMPORTED_MODULE_4__/* .kebabCase */ .k)(key), doc = element.ownerDocument || document, win = doc ? doc.defaultView || doc.parentWindow : false;
    const currentValue = element.style[key];
    let result = '';
    if (currentValue !== undefined && currentValue !== '') {
        result = currentValue;
    }
    else if (win && !onlyStyleMode) {
        result = win.getComputedStyle(element).getPropertyValue(key2);
    }
    if (jodit_core_helpers_normalize_normalize_css_value__WEBPACK_IMPORTED_MODULE_2__/* .NUMBER_FIELDS_REG */ .b$.test(key) &&
        /^[-+]?[0-9.]+px$/.test(result.toString())) {
        result = parseInt(result.toString(), 10);
    }
    return (0,jodit_core_helpers_normalize_normalize_css_value__WEBPACK_IMPORTED_MODULE_2__/* .normalizeCssValue */ .iy)(key, result);
}
/**
 * Clear center align
 */
const clearCenterAlign = (image) => {
    if (css(image, 'display') === 'block') {
        css(image, 'display', '');
    }
    const { style } = image;
    if (style.marginLeft === 'auto' && style.marginRight === 'auto') {
        style.marginLeft = '';
        style.marginRight = '';
    }
};


/***/ }),

/***/ 34446:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   X: function() { return /* binding */ ctrlKey; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/utils
 */
/**
 * CTRL pressed
 * @returns true ctrl key was pressed
 */
const ctrlKey = (e) => {
    if (typeof navigator !== 'undefined' &&
        navigator.userAgent.indexOf('Mac OS X') !== -1) {
        if (e.metaKey && !e.altKey) {
            return true;
        }
    }
    else if (e.ctrlKey && !e.altKey) {
        return true;
    }
    return false;
};


/***/ }),

/***/ 72197:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   m: function() { return /* binding */ dataBind; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_view_object__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(12041);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

const store = new WeakMap();
const dataBind = (elm, key, value) => {
    let itemStore = store.get(elm);
    if (!itemStore) {
        itemStore = {};
        store.set(elm, itemStore);
        let e = null;
        if ((0,jodit_core_helpers_checker_is_view_object__WEBPACK_IMPORTED_MODULE_0__/* .isViewObject */ .h)(elm.j)) {
            e = elm.j.e;
        }
        if ((0,jodit_core_helpers_checker_is_view_object__WEBPACK_IMPORTED_MODULE_0__/* .isViewObject */ .h)(elm)) {
            e = elm.e;
        }
        e &&
            e.on('beforeDestruct', () => {
                store.delete(elm);
            });
    }
    if (value === undefined) {
        return itemStore[key];
    }
    itemStore[key] = value;
    return value;
};


/***/ }),

/***/ 17527:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   e: function() { return /* binding */ defaultLanguage; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(98253);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/utils
 */

/**
 * Try define user language
 */
const defaultLanguage = (language, defaultLanguage = 'en') => {
    if (language !== 'auto' && (0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_0__/* .isString */ .K)(language)) {
        return language;
    }
    if (document.documentElement && document.documentElement.lang) {
        return document.documentElement.lang;
    }
    if (navigator.language) {
        return navigator.language.substring(0, 2);
    }
    return defaultLanguage;
};


/***/ }),

/***/ 76166:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FI: function() { return /* binding */ connection; },
/* harmony export */   fF: function() { return /* binding */ options; },
/* harmony export */   z3: function() { return /* binding */ error; }
/* harmony export */ });
/* harmony import */ var _errors__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20222);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/utils
 */

/**
 * Helper for create Error object
 */
function error(message) {
    return new TypeError(message);
}
function connection(message) {
    return new _errors__WEBPACK_IMPORTED_MODULE_0__/* .ConnectionError */ .Rc(message);
}
function options(message) {
    return new _errors__WEBPACK_IMPORTED_MODULE_0__/* .OptionsError */ .ZW(message);
}


/***/ }),

/***/ 21567:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   h: function() { return /* binding */ abort; },
/* harmony export */   r: function() { return /* binding */ isAbort; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_abort_error__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(99951);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/utils
 */

function abort(message = 'Aborted') {
    return new DOMException(message, 'AbortError');
}
/**
 * @deprecated use `isAbortError` instead
 */
const isAbort = jodit_core_helpers_checker_is_abort_error__WEBPACK_IMPORTED_MODULE_0__/* .isAbortError */ .z;


/***/ }),

/***/ 30495:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   R: function() { return /* binding */ ConnectionError; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/utils
 */
class ConnectionError extends Error {
    constructor(m) {
        super(m);
        Object.setPrototypeOf(this, ConnectionError.prototype);
    }
}


/***/ }),

/***/ 20222:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Rc: function() { return /* reexport safe */ _connection_error__WEBPACK_IMPORTED_MODULE_1__.R; },
/* harmony export */   ZW: function() { return /* reexport safe */ _options_error__WEBPACK_IMPORTED_MODULE_2__.Z; },
/* harmony export */   h2: function() { return /* reexport safe */ _abort_error__WEBPACK_IMPORTED_MODULE_0__.h; },
/* harmony export */   rV: function() { return /* reexport safe */ _abort_error__WEBPACK_IMPORTED_MODULE_0__.r; }
/* harmony export */ });
/* harmony import */ var _abort_error__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(21567);
/* harmony import */ var _connection_error__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(30495);
/* harmony import */ var _options_error__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(34899);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/utils
 */





/***/ }),

/***/ 34899:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: function() { return /* binding */ OptionsError; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/utils
 */
class OptionsError extends TypeError {
    constructor(m) {
        super(m);
        Object.setPrototypeOf(this, OptionsError.prototype);
    }
}


/***/ }),

/***/ 50156:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FI: function() { return /* reexport safe */ _error__WEBPACK_IMPORTED_MODULE_0__.FI; },
/* harmony export */   Rc: function() { return /* reexport safe */ _errors___WEBPACK_IMPORTED_MODULE_1__.Rc; },
/* harmony export */   ZW: function() { return /* reexport safe */ _errors___WEBPACK_IMPORTED_MODULE_1__.ZW; },
/* harmony export */   fF: function() { return /* reexport safe */ _error__WEBPACK_IMPORTED_MODULE_0__.fF; },
/* harmony export */   h2: function() { return /* reexport safe */ _errors___WEBPACK_IMPORTED_MODULE_1__.h2; },
/* harmony export */   rV: function() { return /* reexport safe */ _errors___WEBPACK_IMPORTED_MODULE_1__.rV; },
/* harmony export */   z3: function() { return /* reexport safe */ _error__WEBPACK_IMPORTED_MODULE_0__.z3; }
/* harmony export */ });
/* harmony import */ var _error__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(76166);
/* harmony import */ var _errors___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(20222);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/utils
 */




/***/ }),

/***/ 49429:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Hp: function() { return /* binding */ markAsAtomic; },
/* harmony export */   mA: function() { return /* binding */ isAtom; },
/* harmony export */   y6: function() { return /* binding */ fastClone; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_string_stringify__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(28616);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/utils
 */

function isAtom(obj) {
    return obj && obj.isAtom;
}
function markAsAtomic(obj) {
    Object.defineProperty(obj, 'isAtom', {
        enumerable: false,
        value: true,
        configurable: false
    });
    return obj;
}
function fastClone(object) {
    return JSON.parse((0,jodit_core_helpers_string_stringify__WEBPACK_IMPORTED_MODULE_0__/* .stringify */ .A)(object));
}


/***/ }),

/***/ 75766:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   M: function() { return /* binding */ keepNames; },
/* harmony export */   u: function() { return /* binding */ getClassName; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(69052);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

const keepNames = new Map();
const getClassName = (obj) => {
    var _a;
    if ((0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_0__/* .isFunction */ .T)(obj.className)) {
        return obj.className();
    }
    const constructor = ((_a = obj.constructor) === null || _a === void 0 ? void 0 : _a.originalConstructor) || obj.constructor;
    if (keepNames.has(constructor)) {
        return keepNames.get(constructor);
    }
    if (constructor.name) {
        return constructor.name;
    }
    const regex = new RegExp(/^\s*function\s*(\S*)\s*\(/);
    const res = constructor.toString().match(regex);
    return res ? res[1] : '';
};


/***/ }),

/***/ 16841:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   J: function() { return /* binding */ get; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(98253);
/* harmony import */ var jodit_core_helpers_checker_is_void__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(35642);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


/**
 * Safe access in tree object
 *
 * @example
 * ```js
 * const obj = {
 *   a: {
 *     b: {
 *       c: {
 *         e: false
 *       }
 *     }
 *   }
 * };
 *
 * console.log(Jodit.modules.Helpers.get('a.b.c.d.e', obj) === false); // true
 * console.log(Jodit.modules.Helpers.get('a.b.a.d.e', obj) === null); // false
 * ```
 */
function get(chain, obj) {
    if (!(0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_0__/* .isString */ .K)(chain) || !chain.length) {
        return null;
    }
    const parts = chain.split('.');
    let result = obj;
    try {
        for (const part of parts) {
            if ((0,jodit_core_helpers_checker_is_void__WEBPACK_IMPORTED_MODULE_1__/* .isVoid */ .R)(result[part])) {
                return null;
            }
            result = result[part];
        }
    }
    catch (_a) {
        return null; // permission denied ore another access exception
    }
    if ((0,jodit_core_helpers_checker_is_void__WEBPACK_IMPORTED_MODULE_1__/* .isVoid */ .R)(result)) {
        return null;
    }
    return result;
}


/***/ }),

/***/ 99898:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   z: function() { return /* binding */ humanSizeToBytes; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/utils
 */
/**
 * Converts from human readable file size (kb,mb,gb,tb) to bytes
 * @param human - readable file size. Example 1gb or 11.2mb
 */
const humanSizeToBytes = (human) => {
    if (/^[0-9.]+$/.test(human.toString())) {
        return parseFloat(human);
    }
    const format = human.substr(-2, 2).toUpperCase(), formats = ['KB', 'MB', 'GB', 'TB'], number = parseFloat(human.substr(0, human.length - 2));
    return formats.indexOf(format) !== -1
        ? number * Math.pow(1024, formats.indexOf(format) + 1)
        : parseInt(human, 10);
};


/***/ }),

/***/ 97369:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   $$: function() { return /* reexport safe */ _selector__WEBPACK_IMPORTED_MODULE_23__.$$; },
/* harmony export */   ConfigFlatten: function() { return /* reexport safe */ _config_proto__WEBPACK_IMPORTED_MODULE_7__.V; },
/* harmony export */   ConfigProto: function() { return /* reexport safe */ _config_proto__WEBPACK_IMPORTED_MODULE_7__.t; },
/* harmony export */   ConnectionError: function() { return /* reexport safe */ _error__WEBPACK_IMPORTED_MODULE_13__.Rc; },
/* harmony export */   LimitedStack: function() { return /* reexport safe */ _stack__WEBPACK_IMPORTED_MODULE_25__.d; },
/* harmony export */   OptionsError: function() { return /* reexport safe */ _error__WEBPACK_IMPORTED_MODULE_13__.ZW; },
/* harmony export */   abort: function() { return /* reexport safe */ _error__WEBPACK_IMPORTED_MODULE_13__.h2; },
/* harmony export */   alignElement: function() { return /* reexport safe */ _align__WEBPACK_IMPORTED_MODULE_0__.Op; },
/* harmony export */   appendScriptAsync: function() { return /* reexport safe */ _append_script__WEBPACK_IMPORTED_MODULE_1__.w4; },
/* harmony export */   appendStyleAsync: function() { return /* reexport safe */ _append_script__WEBPACK_IMPORTED_MODULE_1__.S5; },
/* harmony export */   attr: function() { return /* reexport safe */ _attr__WEBPACK_IMPORTED_MODULE_3__.C; },
/* harmony export */   browser: function() { return /* reexport safe */ _browser__WEBPACK_IMPORTED_MODULE_4__.T; },
/* harmony export */   buildQuery: function() { return /* reexport safe */ _build_query__WEBPACK_IMPORTED_MODULE_5__.Z; },
/* harmony export */   call: function() { return /* reexport safe */ _utils__WEBPACK_IMPORTED_MODULE_26__.T1; },
/* harmony export */   callPromise: function() { return /* reexport safe */ _utils__WEBPACK_IMPORTED_MODULE_26__.o_; },
/* harmony export */   clearAlign: function() { return /* reexport safe */ _align__WEBPACK_IMPORTED_MODULE_0__.Xm; },
/* harmony export */   clearCenterAlign: function() { return /* reexport safe */ _css__WEBPACK_IMPORTED_MODULE_9__.a; },
/* harmony export */   cns: function() { return /* reexport safe */ _mark_deprecated__WEBPACK_IMPORTED_MODULE_18__.f; },
/* harmony export */   completeUrl: function() { return /* reexport safe */ _complete_url__WEBPACK_IMPORTED_MODULE_6__.X; },
/* harmony export */   connection: function() { return /* reexport safe */ _error__WEBPACK_IMPORTED_MODULE_13__.FI; },
/* harmony export */   convertMediaUrlToVideoEmbed: function() { return /* reexport safe */ _convert_media_url_to_video_embed__WEBPACK_IMPORTED_MODULE_8__.m; },
/* harmony export */   css: function() { return /* reexport safe */ _css__WEBPACK_IMPORTED_MODULE_9__.A; },
/* harmony export */   cssPath: function() { return /* reexport safe */ _selector__WEBPACK_IMPORTED_MODULE_23__.bE; },
/* harmony export */   ctrlKey: function() { return /* reexport safe */ _ctrl_key__WEBPACK_IMPORTED_MODULE_10__.X; },
/* harmony export */   dataBind: function() { return /* reexport safe */ _data_bind__WEBPACK_IMPORTED_MODULE_11__.m; },
/* harmony export */   defaultLanguage: function() { return /* reexport safe */ _default_language__WEBPACK_IMPORTED_MODULE_12__.e; },
/* harmony export */   error: function() { return /* reexport safe */ _error__WEBPACK_IMPORTED_MODULE_13__.z3; },
/* harmony export */   fastClone: function() { return /* reexport safe */ _extend__WEBPACK_IMPORTED_MODULE_14__.y6; },
/* harmony export */   get: function() { return /* reexport safe */ _get__WEBPACK_IMPORTED_MODULE_15__.J; },
/* harmony export */   getClassName: function() { return /* reexport safe */ _get_class_name__WEBPACK_IMPORTED_MODULE_16__.u; },
/* harmony export */   getDataTransfer: function() { return /* reexport safe */ _utils__WEBPACK_IMPORTED_MODULE_26__.my; },
/* harmony export */   getXPathByElement: function() { return /* reexport safe */ _selector__WEBPACK_IMPORTED_MODULE_23__.fz; },
/* harmony export */   hAlignElement: function() { return /* reexport safe */ _align__WEBPACK_IMPORTED_MODULE_0__.Mr; },
/* harmony export */   humanSizeToBytes: function() { return /* reexport safe */ _human_size_to_bytes__WEBPACK_IMPORTED_MODULE_17__.z; },
/* harmony export */   inView: function() { return /* reexport safe */ _scroll_into_view__WEBPACK_IMPORTED_MODULE_22__.l; },
/* harmony export */   isAbort: function() { return /* reexport safe */ _error__WEBPACK_IMPORTED_MODULE_13__.rV; },
/* harmony export */   isAtom: function() { return /* reexport safe */ _extend__WEBPACK_IMPORTED_MODULE_14__.mA; },
/* harmony export */   keepNames: function() { return /* reexport safe */ _get_class_name__WEBPACK_IMPORTED_MODULE_16__.M; },
/* harmony export */   keys: function() { return /* reexport safe */ _utils__WEBPACK_IMPORTED_MODULE_26__.HP; },
/* harmony export */   loadImage: function() { return /* reexport safe */ _utils__WEBPACK_IMPORTED_MODULE_26__.yt; },
/* harmony export */   loadNext: function() { return /* reexport safe */ _append_script__WEBPACK_IMPORTED_MODULE_1__.Qt; },
/* harmony export */   loadNextStyle: function() { return /* reexport safe */ _append_script__WEBPACK_IMPORTED_MODULE_1__.x_; },
/* harmony export */   markAsAtomic: function() { return /* reexport safe */ _extend__WEBPACK_IMPORTED_MODULE_14__.Hp; },
/* harmony export */   markDeprecated: function() { return /* reexport safe */ _mark_deprecated__WEBPACK_IMPORTED_MODULE_18__.B; },
/* harmony export */   markOwner: function() { return /* reexport safe */ _utils__WEBPACK_IMPORTED_MODULE_26__.b_; },
/* harmony export */   memorizeExec: function() { return /* reexport safe */ _utils__WEBPACK_IMPORTED_MODULE_26__.qN; },
/* harmony export */   options: function() { return /* reexport safe */ _error__WEBPACK_IMPORTED_MODULE_13__.fF; },
/* harmony export */   parseQuery: function() { return /* reexport safe */ _parse_query__WEBPACK_IMPORTED_MODULE_19__.m; },
/* harmony export */   previewBox: function() { return /* reexport safe */ _print__WEBPACK_IMPORTED_MODULE_20__.u; },
/* harmony export */   refs: function() { return /* reexport safe */ _selector__WEBPACK_IMPORTED_MODULE_23__.DY; },
/* harmony export */   reset: function() { return /* reexport safe */ _reset__WEBPACK_IMPORTED_MODULE_21__.c; },
/* harmony export */   resolveElement: function() { return /* reexport safe */ _selector__WEBPACK_IMPORTED_MODULE_23__.tI; },
/* harmony export */   scrollIntoViewIfNeeded: function() { return /* reexport safe */ _scroll_into_view__WEBPACK_IMPORTED_MODULE_22__.$; },
/* harmony export */   set: function() { return /* reexport safe */ _set__WEBPACK_IMPORTED_MODULE_24__.h; }
/* harmony export */ });
/* harmony import */ var _align__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(40080);
/* harmony import */ var _append_script__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(27301);
/* harmony import */ var _assert__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(28712);
/* harmony import */ var _assert__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_assert__WEBPACK_IMPORTED_MODULE_2__);
/* harmony reexport (unknown) */ var __WEBPACK_REEXPORT_OBJECT__ = {};
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _assert__WEBPACK_IMPORTED_MODULE_2__) if(["default","alignElement","clearAlign","hAlignElement","appendScriptAsync","appendStyleAsync","loadNext","loadNextStyle"].indexOf(__WEBPACK_IMPORT_KEY__) < 0) __WEBPACK_REEXPORT_OBJECT__[__WEBPACK_IMPORT_KEY__] = function(key) { return _assert__WEBPACK_IMPORTED_MODULE_2__[key]; }.bind(0, __WEBPACK_IMPORT_KEY__)
/* harmony reexport (unknown) */ __webpack_require__.d(__webpack_exports__, __WEBPACK_REEXPORT_OBJECT__);
/* harmony import */ var _attr__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(26150);
/* harmony import */ var _browser__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(65717);
/* harmony import */ var _build_query__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(76104);
/* harmony import */ var _complete_url__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(60346);
/* harmony import */ var _config_proto__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(86248);
/* harmony import */ var _convert_media_url_to_video_embed__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(82807);
/* harmony import */ var _css__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(38322);
/* harmony import */ var _ctrl_key__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(34446);
/* harmony import */ var _data_bind__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(72197);
/* harmony import */ var _default_language__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(17527);
/* harmony import */ var _error__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(50156);
/* harmony import */ var _extend__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(49429);
/* harmony import */ var _get__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(16841);
/* harmony import */ var _get_class_name__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(75766);
/* harmony import */ var _human_size_to_bytes__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(99898);
/* harmony import */ var _mark_deprecated__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(67400);
/* harmony import */ var _parse_query__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(70807);
/* harmony import */ var _print__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(98434);
/* harmony import */ var _reset__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(44210);
/* harmony import */ var _scroll_into_view__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(641);
/* harmony import */ var _selector__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(58720);
/* harmony import */ var _set__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(40677);
/* harmony import */ var _stack__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(70069);
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(84976);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/utils
 */





























/***/ }),

/***/ 67400:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   B: function() { return /* binding */ markDeprecated; },
/* harmony export */   f: function() { return /* binding */ cns; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/utils
 */
/**
 * By default, terser will remove all `console.*` but
 * if you use this object it will not be
 */
const cns = console;
/**
 * Mark function as deprecated
 */
function markDeprecated(method, names = [''], ctx = null) {
    return (...args) => {
        cns.warn(`Method "${names[0]}" deprecated.` +
            (names[1] ? ` Use "${names[1]}" instead` : ''));
        return method.call(ctx, ...args);
    };
}


/***/ }),

/***/ 70807:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   m: function() { return /* binding */ parseQuery; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * Parse query string
 */
const parseQuery = (queryString) => {
    const query = {}, a = queryString.substring(1).split('&');
    for (let i = 0; i < a.length; i += 1) {
        const keyValue = a[i].split('=');
        query[decodeURIComponent(keyValue[0])] = decodeURIComponent(keyValue[1] || '');
    }
    return query;
};


/***/ }),

/***/ 98434:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   u: function() { return /* binding */ previewBox; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(98253);
/* harmony import */ var _attr__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(26150);
/* harmony import */ var _css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(38322);
/* harmony import */ var _selector__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(58720);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */





/**
 * Fixes image sizes and sets absolute paths to images
 */
function fixedAssetsSizeAndAbsoluteLinks(editor, points) {
    const restoreAttributes = [];
    try {
        (0,_selector__WEBPACK_IMPORTED_MODULE_2__.$$)('img', editor.editor).forEach(item => {
            const previousAttrs = [
                (0,_attr__WEBPACK_IMPORTED_MODULE_1__/* .attr */ .C)(item, 'width'),
                (0,_attr__WEBPACK_IMPORTED_MODULE_1__/* .attr */ .C)(item, 'height'),
                item.src
            ];
            (0,_attr__WEBPACK_IMPORTED_MODULE_1__/* .attr */ .C)(item, {
                width: item.offsetWidth + points,
                height: item.offsetHeight + points
            });
            const a = editor.createInside.a();
            editor.ed.body.appendChild(a);
            a.href = item.src;
            item.src = a.href;
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.safeRemove(a);
            restoreAttributes.push(() => {
                var _a;
                item.src = (_a = previousAttrs[2]) !== null && _a !== void 0 ? _a : '';
                (0,_attr__WEBPACK_IMPORTED_MODULE_1__/* .attr */ .C)(item, {
                    width: previousAttrs[0] || null,
                    height: previousAttrs[1] || null
                });
            });
        });
    }
    catch (e) {
        restoreAttributes.forEach(c => c());
        restoreAttributes.length = 0;
        throw e;
    }
    return restoreAttributes;
}
/**
 * Generates a copy of an HTML document, resizes images, executes JS
 *
 * @event beforePreviewBox(string | undefined, 'pt' | 'px' | '')
 * @event afterPreviewBox(HTMLElement)
 */
function previewBox(editor, defaultValue, points = 'px', container = null) {
    const onDestruct = [];
    const restoreAttributes = fixedAssetsSizeAndAbsoluteLinks(editor, points);
    try {
        const res = editor.e.fire('beforePreviewBox', defaultValue, points);
        if (res != null) {
            return res;
        }
        let div = editor.c.div('jodit__preview-box jodit-context');
        if (container) {
            container.appendChild(div);
        }
        (0,_css__WEBPACK_IMPORTED_MODULE_3__/* .css */ .A)(div, {
            position: 'relative',
            padding: 16
        });
        const value = editor.value ||
            `<div style='position: absolute;left:50%;top:50%;transform: translateX(-50%) translateY(-50%);color:#ccc;'>${editor.i18n('Empty')}</div>`;
        if (editor.iframe) {
            const iframe = editor.create.element('iframe');
            (0,_css__WEBPACK_IMPORTED_MODULE_3__/* .css */ .A)(iframe, {
                minWidth: 800,
                minHeight: 600,
                border: 0
            });
            div.appendChild(iframe);
            const myWindow = iframe.contentWindow;
            if (myWindow) {
                editor.e.fire('generateDocumentStructure.iframe', myWindow.document, editor);
                div = myWindow.document.body;
                if (typeof ResizeObserver === 'function') {
                    let destructed = false;
                    const elm = myWindow.document.body;
                    const resizeObserver = new ResizeObserver(editor.async.debounce(() => {
                        resizeObserver.unobserve(elm);
                        iframe.style.height = `${elm.offsetHeight + 20}px`;
                        editor.async.requestAnimationFrame(() => {
                            !destructed && resizeObserver.observe(elm);
                        });
                    }, 100));
                    const beforeDestruct = () => {
                        destructed = true;
                        resizeObserver.unobserve(elm);
                        resizeObserver.disconnect();
                        editor.e.off('beforeDestruct', beforeDestruct);
                    };
                    onDestruct.push(beforeDestruct);
                    editor.e.on('beforeDestruct', beforeDestruct);
                }
            }
        }
        else {
            (0,_css__WEBPACK_IMPORTED_MODULE_3__/* .css */ .A)(div, {
                minWidth: 1024,
                minHeight: 600,
                border: 0
            });
        }
        const setHTML = (box, value) => {
            const dv = (0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_4__/* .isString */ .K)(value) ? editor.c.div() : value;
            if ((0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_4__/* .isString */ .K)(value)) {
                dv.innerHTML = value;
            }
            for (let i = 0; i < dv.childNodes.length; i += 1) {
                const c = dv.childNodes[i];
                if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isElement(c)) {
                    const newNode = box.ownerDocument.createElement(c.nodeName);
                    for (let j = 0; j < c.attributes.length; j += 1) {
                        (0,_attr__WEBPACK_IMPORTED_MODULE_1__/* .attr */ .C)(newNode, c.attributes[j].nodeName, c.attributes[j].nodeValue);
                    }
                    if (c.childNodes.length === 0 || jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(c, 'table')) {
                        switch (c.nodeName) {
                            case 'SCRIPT':
                                if (c.textContent) {
                                    newNode.textContent = c.textContent;
                                }
                                break;
                            default:
                                if (c.innerHTML) {
                                    newNode.innerHTML = c.innerHTML;
                                }
                                break;
                        }
                    }
                    else {
                        setHTML(newNode, c);
                    }
                    try {
                        box.appendChild(newNode);
                    }
                    catch (_a) { }
                }
                else {
                    try {
                        box.appendChild(c.cloneNode(true));
                    }
                    catch (_b) { }
                }
            }
        };
        setHTML(div, value);
        editor.e.fire('afterPreviewBox', div);
        return [
            div,
            () => {
                onDestruct.forEach(cb => cb());
            }
        ];
    }
    finally {
        restoreAttributes.forEach(clb => clb());
    }
}


/***/ }),

/***/ 44210:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   c: function() { return /* binding */ reset; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(69052);
/* harmony import */ var _get__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16841);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



const map = {};
/**
 * Reset Vanilla JS native function
 * @example
 * ```js
 * reset('Array.from')(Set([1,2,3])) // [1, 2, 3]
 * ```
 * You must use the function derived from the method immediately as its iframe is being removed
 */
function reset(key) {
    var _a, _b;
    if (!(key in map)) {
        const iframe = document.createElement('iframe');
        try {
            iframe.src = 'about:blank';
            document.body.appendChild(iframe);
            if (!iframe.contentWindow) {
                return null;
            }
            const func = (0,_get__WEBPACK_IMPORTED_MODULE_1__/* .get */ .J)(key, iframe.contentWindow), bind = (0,_get__WEBPACK_IMPORTED_MODULE_1__/* .get */ .J)(key.split('.').slice(0, -1).join('.'), iframe.contentWindow);
            if ((0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_2__/* .isFunction */ .T)(func)) {
                map[key] = func.bind(bind);
            }
        }
        catch (e) {
            if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD) {
                throw e;
            }
        }
        finally {
            (_a = iframe.parentNode) === null || _a === void 0 ? void 0 : _a.removeChild(iframe);
        }
    }
    return (_b = map[key]) !== null && _b !== void 0 ? _b : null;
}


/***/ }),

/***/ 641:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   $: function() { return /* binding */ scrollIntoViewIfNeeded; },
/* harmony export */   l: function() { return /* binding */ inView; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

/**
 * @module helpers/utils
 */
/**
 * Check if element is in view
 */
function inView(elm, root, doc) {
    let rect = elm.getBoundingClientRect(), el = elm;
    const top = rect.top, height = rect.height;
    while (el && el !== root && el.parentNode) {
        el = el.parentNode;
        rect = el.getBoundingClientRect();
        if (!(top <= rect.bottom)) {
            return false;
        }
        // Check if the element is out of view due to a container scrolling
        if (top + height <= rect.top) {
            return false;
        }
    }
    // Check it's within the document viewport
    return (top <= ((doc.documentElement && doc.documentElement.clientHeight) || 0));
}
/**
 * Scroll element into view if it is not in view
 */
function scrollIntoViewIfNeeded(elm, root, doc) {
    if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isHTMLElement(elm) && !inView(elm, root, doc)) {
        if (root.clientHeight !== root.scrollHeight) {
            root.scrollTop = elm.offsetTop;
        }
        if (!inView(elm, root, doc)) {
            elm.scrollIntoView();
        }
    }
}


/***/ }),

/***/ 58720:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   $$: function() { return /* binding */ $$; },
/* harmony export */   DY: function() { return /* binding */ refs; },
/* harmony export */   bE: function() { return /* binding */ cssPath; },
/* harmony export */   fz: function() { return /* binding */ getXPathByElement; },
/* harmony export */   tI: function() { return /* binding */ resolveElement; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_array_to_array__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(42448);
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(98253);
/* harmony import */ var jodit_core_helpers_string_camel_case__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(83260);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(97369);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */






let temp = 1;
const $$temp = () => {
    temp++;
    return temp;
};
function $$(selector, root) {
    let result;
    if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_ES_NEXT &&
        /:scope/.test(selector) &&
        jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_IE &&
        !(root && root.nodeType === Node.DOCUMENT_NODE)) {
        const id = root.id, temp_id = id ||
            '_selector_id_' + String(Math.random()).slice(2) + $$temp();
        selector = selector.replace(/:scope/g, '#' + temp_id);
        !id && root.setAttribute('id', temp_id);
        result = root.parentNode.querySelectorAll(selector);
        if (!id) {
            root.removeAttribute('id');
        }
    }
    else {
        result = root.querySelectorAll(selector);
    }
    return [].slice.call(result);
}
/**
 * Calculate XPath selector
 */
const getXPathByElement = (element, root) => {
    if (!element || element.nodeType !== Node.ELEMENT_NODE) {
        return '';
    }
    if (!element.parentNode || root === element) {
        return '';
    }
    if (element.id) {
        return "//*[@id='" + element.id + "']";
    }
    const sames = [].filter.call(element.parentNode.childNodes, (x) => x.nodeName === element.nodeName);
    return (getXPathByElement(element.parentNode, root) +
        '/' +
        element.nodeName.toLowerCase() +
        (sames.length > 1
            ? '[' + ((0,jodit_core_helpers_array_to_array__WEBPACK_IMPORTED_MODULE_2__/* .toArray */ .$)(sames).indexOf(element) + 1) + ']'
            : ''));
};
/**
 * Find all `ref` or `data-ref` elements inside HTMLElement
 */
const refs = (root) => {
    if ('container' in root) {
        root = root.container;
    }
    return $$('[ref],[data-ref]', root).reduce((def, child) => {
        const key = (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__.attr)(child, '-ref');
        if (key && (0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_4__/* .isString */ .K)(key)) {
            def[(0,jodit_core_helpers_string_camel_case__WEBPACK_IMPORTED_MODULE_5__/* .camelCase */ .x)(key)] = child;
            def[key] = child;
        }
        return def;
    }, {});
};
/**
 * Calculate full CSS selector
 */
const cssPath = (el) => {
    if (!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isElement(el)) {
        return null;
    }
    const path = [];
    let start = el;
    while (start && start.nodeType === Node.ELEMENT_NODE) {
        let selector = start.nodeName.toLowerCase();
        if (start.id) {
            selector += '#' + start.id;
            path.unshift(selector);
            break;
        }
        else {
            let sib = start, nth = 1;
            do {
                sib = sib.previousElementSibling;
                if (sib && sib.nodeName.toLowerCase() === selector) {
                    nth++;
                }
            } while (sib);
            selector += ':nth-of-type(' + nth + ')';
        }
        path.unshift(selector);
        start = start.parentNode;
    }
    return path.join(' > ');
};
/**
 * Try to find element by selector
 */
function resolveElement(element, od) {
    let resolved = element;
    if ((0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_4__/* .isString */ .K)(element)) {
        try {
            resolved = od.querySelector(element);
        }
        catch (_a) {
            throw (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__.error)('String "' + element + '" should be valid HTML selector');
        }
    }
    // Duck checking
    if (!resolved ||
        typeof resolved !== 'object' ||
        !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isElement(resolved) ||
        !resolved.cloneNode) {
        throw (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__.error)('Element "' + element + '" should be string or HTMLElement instance');
    }
    return resolved;
}


/***/ }),

/***/ 40677:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   h: function() { return /* binding */ set; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(37923);
/* harmony import */ var jodit_core_helpers_checker_is_numeric__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(12461);
/* harmony import */ var jodit_core_helpers_checker_is_plain_object__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(25376);
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(98253);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */




/**
 * Safe access in tree object
 *
 * @example
 * ```js
 * const a = {}, b = {};
 * Jodit.modules.Helpers.set('a.b.c.d.e', 1, a);
 * console.log(a);// {a: {b: {c: {d: {e: 1}}}}}
 *
 * Jodit.modules.Helpers.set('a.0.e', 1, b);
 * console.log(b);// {a: [{e: 1}]}
 * ```
 */
function set(chain, value, obj) {
    if (!(0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_0__/* .isString */ .K)(chain) || !chain.length) {
        return;
    }
    const parts = chain.split('.');
    let result = obj, key = parts[0];
    for (let i = 0; i < parts.length - 1; i += 1) {
        key = parts[i];
        if (!(0,jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_1__/* .isArray */ .c)(result[key]) && !(0,jodit_core_helpers_checker_is_plain_object__WEBPACK_IMPORTED_MODULE_2__/* .isPlainObject */ .Q)(result[key])) {
            result[key] = (0,jodit_core_helpers_checker_is_numeric__WEBPACK_IMPORTED_MODULE_3__/* .isNumeric */ .k)(parts[i + 1]) ? [] : {};
        }
        result = result[key];
    }
    if (result) {
        result[parts[parts.length - 1]] = value;
    }
}


/***/ }),

/***/ 70069:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   d: function() { return /* binding */ LimitedStack; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
class LimitedStack {
    constructor(limit) {
        this.limit = limit;
        this.stack = [];
    }
    push(item) {
        this.stack.push(item);
        if (this.stack.length > this.limit) {
            this.stack.shift();
        }
        return this;
    }
    pop() {
        return this.stack.pop();
    }
    find(clb) {
        return this.stack.find(clb);
    }
}


/***/ }),

/***/ 84976:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   HP: function() { return /* binding */ keys; },
/* harmony export */   T1: function() { return /* binding */ call; },
/* harmony export */   b_: function() { return /* binding */ markOwner; },
/* harmony export */   my: function() { return /* binding */ getDataTransfer; },
/* harmony export */   o_: function() { return /* binding */ callPromise; },
/* harmony export */   qN: function() { return /* binding */ memorizeExec; },
/* harmony export */   yt: function() { return /* binding */ loadImage; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_promise__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(92039);
/* harmony import */ var jodit_core_helpers_checker_is_void__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(35642);
/* harmony import */ var _attr__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(26150);
/* harmony import */ var _data_bind__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(72197);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */




/**
 * Call function with parameters
 *
 * @example
 * ```js
 * const f = Math.random();
 * Jodit.modules.Helpers.call(f > 0.5 ? Math.ceil : Math.floor, f);
 * ```
 */
function call(func, ...args) {
    return func(...args);
}
/**
 * Mark element for debugging
 */
function markOwner(jodit, elm) {
    (0,_attr__WEBPACK_IMPORTED_MODULE_0__/* .attr */ .C)(elm, 'data-editor_id', jodit.id);
    !elm.component &&
        Object.defineProperty(elm, 'jodit', {
            value: jodit
        });
}
function callPromise(condition, callback) {
    if ((0,jodit_core_helpers_checker_is_promise__WEBPACK_IMPORTED_MODULE_2__/* .isPromise */ .y)(condition)) {
        return condition
            .then(resp => resp, () => null)
            .finally(callback);
    }
    return callback === null || callback === void 0 ? void 0 : callback();
}
/**
 * Allow load image in promise
 */
const loadImage = (src, jodit) => jodit.async.promise((res, rej) => {
    const image = new Image(), onError = () => {
        jodit.e.off(image);
        rej === null || rej === void 0 ? void 0 : rej();
    }, onSuccess = () => {
        jodit.e.off(image);
        res(image);
    };
    jodit.e
        .one(image, 'load', onSuccess)
        .one(image, 'error', onError)
        .one(image, 'abort', onError);
    image.src = src;
    if (image.complete) {
        onSuccess();
    }
});
const keys = (obj, own = true) => {
    if (own) {
        return Object.keys(obj);
    }
    const props = [];
    for (const key in obj) {
        props.push(key);
    }
    return props;
};
/**
 * Memorize last user chose
 */
const memorizeExec = (editor, _, { control }, preProcessValue) => {
    var _a;
    const key = `button${control.command}`;
    let value = (_a = (control.args && control.args[0])) !== null && _a !== void 0 ? _a : (0,_data_bind__WEBPACK_IMPORTED_MODULE_1__/* .dataBind */ .m)(editor, key);
    if ((0,jodit_core_helpers_checker_is_void__WEBPACK_IMPORTED_MODULE_3__/* .isVoid */ .R)(value)) {
        return false;
    }
    (0,_data_bind__WEBPACK_IMPORTED_MODULE_1__/* .dataBind */ .m)(editor, key, value);
    if (preProcessValue) {
        value = preProcessValue(value);
    }
    editor.execCommand(control.command, false, value !== null && value !== void 0 ? value : undefined);
};
/**
 * Get DataTransfer from different event types
 */
const getDataTransfer = (event) => {
    if (event.clipboardData) {
        return event.clipboardData;
    }
    try {
        return event.dataTransfer || new DataTransfer();
    }
    catch (_a) {
        return null;
    }
};


/***/ }),

/***/ 58269:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   T: function() { return /* binding */ init; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9823);
/* harmony import */ var _load__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(32291);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */




/**
 * Init plugin if it has no dependencies, in another case wait requires plugins will be init
 * @private
 */
function init(jodit, pluginName, plugin, instance, doneList, waitingList) {
    if ((0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__/* .isInitable */ .Gp)(instance)) {
        try {
            instance.init(jodit);
        }
        catch (e) {
            console.error(e);
            if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD) {
                throw e;
            }
        }
    }
    doneList.set(pluginName, instance);
    waitingList.delete(pluginName);
    if (instance.hasStyle) {
        (0,_load__WEBPACK_IMPORTED_MODULE_3__/* .loadStyle */ .M)(jodit, pluginName).catch(e => {
            !jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD && console.error(e);
        });
    }
    if (instance.styles) {
        const style = (0,jodit_core_global__WEBPACK_IMPORTED_MODULE_1__/* .getContainer */ .My)(jodit, pluginName, 'style');
        style.innerHTML = instance.styles;
    }
}


/***/ }),

/***/ 32291:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   M: function() { return /* binding */ loadStyle; },
/* harmony export */   o: function() { return /* binding */ loadExtras; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_helpers_string_kebab_case__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(449);
/* harmony import */ var jodit_core_helpers_utils_append_script__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(27301);
/* harmony import */ var jodit_core_plugin_helpers_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(96134);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */





const styles = new Set();
/**
 * @private
 */
function loadStyle(jodit, pluginName) {
    return (0,tslib__WEBPACK_IMPORTED_MODULE_2__/* .__awaiter */ .sH)(this, void 0, void 0, function* () {
        const url = getFullUrl(jodit, pluginName, false);
        if (styles.has(url)) {
            return;
        }
        styles.add(url);
        return (0,jodit_core_helpers_utils_append_script__WEBPACK_IMPORTED_MODULE_1__/* .appendStyleAsync */ .S5)(jodit, url);
    });
}
/**
 * Call full url to the script or style file
 * @private
 */
function getFullUrl(jodit, name, js) {
    name = (0,jodit_core_helpers_string_kebab_case__WEBPACK_IMPORTED_MODULE_3__/* .kebabCase */ .k)(name);
    return (jodit.basePath +
        'plugins/' +
        name +
        '/' +
        name +
        '.' +
        (js ? 'js' : 'css'));
}
/**
 * @private
 */
function loadExtras(items, jodit, extraList, callback) {
    try {
        const needLoadExtras = extraList.filter(extra => !items.has((0,jodit_core_plugin_helpers_utils__WEBPACK_IMPORTED_MODULE_4__/* .normalizeName */ .P)(extra.name)));
        if (needLoadExtras.length) {
            load(jodit, needLoadExtras, callback);
        }
    }
    catch (e) {
        if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD) {
            throw e;
        }
    }
}
/**
 * Download plugins
 * @private
 */
function load(jodit, pluginList, callback) {
    pluginList.map(extra => {
        const url = extra.url || getFullUrl(jodit, extra.name, true);
        return (0,jodit_core_helpers_utils_append_script__WEBPACK_IMPORTED_MODULE_1__/* .appendScriptAsync */ .w4)(jodit, url)
            .then(callback)
            .catch(() => null);
    });
}


/***/ }),

/***/ 58157:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   k: function() { return /* binding */ makeInstance; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(69052);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


/**
 * Create instance of plugin
 * @private
 */
function makeInstance(jodit, plugin) {
    try {
        try {
            // @ts-ignore
            return (0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_1__/* .isFunction */ .T)(plugin) ? new plugin(jodit) : plugin;
        }
        catch (e) {
            if ((0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_1__/* .isFunction */ .T)(plugin) && !plugin.prototype) {
                return plugin(jodit);
            }
        }
    }
    catch (e) {
        console.error(e);
        if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD) {
            throw e;
        }
    }
    return null;
}


/***/ }),

/***/ 96134:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   P: function() { return /* binding */ normalizeName; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_string_kebab_case__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(449);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module plugin
 */

/**
 * @private
 */
function normalizeName(name) {
    return (0,jodit_core_helpers_string_kebab_case__WEBPACK_IMPORTED_MODULE_0__/* .kebabCase */ .k)(name).toLowerCase();
}


/***/ }),

/***/ 71005:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   k: function() { return /* reexport safe */ _plugin__WEBPACK_IMPORTED_MODULE_0__.k; }
/* harmony export */ });
/* harmony import */ var _plugin__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(29866);
/* harmony import */ var _plugin_system__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(77402);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module plugin
 */




/***/ }),

/***/ 77402:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   $: function() { return /* binding */ PluginSystem; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers_array__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(32709);
/* harmony import */ var jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(9823);
/* harmony import */ var jodit_core_plugin_helpers_init_instance__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(58269);
/* harmony import */ var jodit_core_plugin_helpers_load__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(32291);
/* harmony import */ var jodit_core_plugin_helpers_make_instance__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(58157);
/* harmony import */ var jodit_core_plugin_helpers_utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(96134);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */









/**
 * Jodit plugin system
 * @example
 * ```js
 * Jodit.plugins.add('emoji2', {
 * 	init() {
 *  	alert('emoji Inited2')
 * 	},
 *	destruct() {}
 * });
 * ```
 */
class PluginSystem {
    constructor() {
        this.__items = new Map();
    }
    /**
     * Add plugin in store
     */
    add(name, plugin) {
        this.__items.set((0,jodit_core_plugin_helpers_utils__WEBPACK_IMPORTED_MODULE_7__/* .normalizeName */ .P)(name), plugin);
        jodit_core_global__WEBPACK_IMPORTED_MODULE_1__/* .eventEmitter */ .RR.fire(`plugin:${name}:ready`);
    }
    /**
     * Get plugin from store
     */
    get(name) {
        return this.__items.get((0,jodit_core_plugin_helpers_utils__WEBPACK_IMPORTED_MODULE_7__/* .normalizeName */ .P)(name));
    }
    /**
     * Remove plugin from store
     */
    remove(name) {
        this.__items.delete((0,jodit_core_plugin_helpers_utils__WEBPACK_IMPORTED_MODULE_7__/* .normalizeName */ .P)(name));
    }
    __getFullPluginsList(filter) {
        const results = [];
        this.__items.forEach((plugin, name) => {
            if (!filter || filter.has(name)) {
                results.push([name, plugin]);
            }
        });
        return results;
    }
    /**
     * Public method for async init all plugins
     */
    __init(jodit) {
        const { extraList, disableList, filter } = getSpecialLists(jodit);
        const doneList = new Map();
        const pluginsMap = {};
        const waitingList = new Set();
        jodit.__plugins = pluginsMap;
        const initPlugins = () => {
            if (jodit.isInDestruct) {
                return;
            }
            let commit = false;
            this.__getFullPluginsList(filter).forEach(([name, plugin]) => {
                if (disableList.has(name) || doneList.has(name)) {
                    return;
                }
                const requires = plugin === null || plugin === void 0 ? void 0 : plugin.requires;
                if (requires && (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_3__/* .isArray */ .cy)(requires) && requires.length) {
                    if (requires.some(req => disableList.has(req))) {
                        return;
                    }
                    if (!requires.every(name => doneList.has(name))) {
                        waitingList.add(name);
                        return;
                    }
                }
                commit = true;
                const instance = (0,jodit_core_plugin_helpers_make_instance__WEBPACK_IMPORTED_MODULE_6__/* .makeInstance */ .k)(jodit, plugin);
                if (!instance) {
                    doneList.set(name, null);
                    waitingList.delete(name);
                    return;
                }
                (0,jodit_core_plugin_helpers_init_instance__WEBPACK_IMPORTED_MODULE_4__/* .init */ .T)(jodit, name, plugin, instance, doneList, waitingList);
                pluginsMap[name] = instance;
            });
            if (commit) {
                jodit.e.fire('updatePlugins');
                initPlugins();
            }
        };
        if (extraList && extraList.length) {
            (0,jodit_core_plugin_helpers_load__WEBPACK_IMPORTED_MODULE_5__/* .loadExtras */ .o)(this.__items, jodit, extraList, initPlugins);
        }
        initPlugins();
        bindOnBeforeDestruct(jodit, pluginsMap);
        if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD && waitingList.size) {
            console.warn('After init plugin waiting list is not clean:', waitingList);
        }
    }
    /**
     * Returns the promise to wait for the plugin to load.
     */
    wait(name) {
        return new Promise((resolve) => {
            if (this.get(name)) {
                return resolve();
            }
            const onReady = () => {
                resolve();
                jodit_core_global__WEBPACK_IMPORTED_MODULE_1__/* .eventEmitter */ .RR.off(`plugin:${name}:ready`, onReady);
            };
            jodit_core_global__WEBPACK_IMPORTED_MODULE_1__/* .eventEmitter */ .RR.on(`plugin:${name}:ready`, onReady);
        });
    }
}
/**
 * Destroy all plugins before - Jodit will be destroyed
 */
function bindOnBeforeDestruct(jodit, plugins) {
    jodit.e.on('beforeDestruct', () => {
        Object.keys(plugins).forEach(name => {
            const instance = plugins[name];
            if ((0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_3__/* .isDestructable */ .pV)(instance)) {
                instance.destruct(jodit);
            }
            delete plugins[name];
        });
        delete jodit.__plugins;
    });
}
function getSpecialLists(jodit) {
    const extraList = jodit.o.extraPlugins.map(s => (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_3__/* .isString */ .Kg)(s) ? { name: s } : s);
    const disableList = new Set((0,jodit_core_helpers_array__WEBPACK_IMPORTED_MODULE_2__/* .splitArray */ .uM)(jodit.o.disablePlugins).map(jodit_core_plugin_helpers_utils__WEBPACK_IMPORTED_MODULE_7__/* .normalizeName */ .P));
    const filter = jodit.o.safeMode ? new Set(jodit.o.safePluginsList) : null;
    return { extraList, disableList, filter };
}


/***/ }),

/***/ 29866:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   k: function() { return /* binding */ Plugin; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(77753);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_helpers_checker_is_jodit_object__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(83044);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */




class Plugin extends jodit_core_component__WEBPACK_IMPORTED_MODULE_0__/* .ViewComponent */ .vG {
    /** @override */
    className() {
        return 'Plugin';
    }
    constructor(jodit) {
        super(jodit);
        /** @override */
        this.buttons = [];
        /**
         * Plugin have CSS style and it should be loaded
         */
        this.hasStyle = false;
        this.__inited = false;
        jodit.e
            .on('afterPluginSystemInit', this.__afterPluginSystemInit)
            .on('afterInit', this.__afterInit)
            .on('beforeDestruct', this.__beforeDestruct);
    }
    __afterPluginSystemInit() {
        const { j, buttons } = this;
        if (buttons && (0,jodit_core_helpers_checker_is_jodit_object__WEBPACK_IMPORTED_MODULE_2__/* .isJoditObject */ .y)(j)) {
            buttons.forEach(btn => {
                j.registerButton(btn);
            });
        }
    }
    __afterInit() {
        this.__inited = true;
        this.setStatus(jodit_core_component__WEBPACK_IMPORTED_MODULE_0__/* .STATUSES */ .f.ready);
        this.afterInit(this.jodit);
    }
    init(jodit) {
        if (this.jodit.isReady) {
            this.afterInit(this.jodit);
            this.__afterPluginSystemInit();
            this.jodit.e.fire('rebuildToolbar');
        }
    }
    __beforeDestruct() {
        var _a;
        if (this.isInDestruct) {
            return;
        }
        const { j } = this;
        j.e
            .off('afterPluginSystemInit', this.__afterPluginSystemInit)
            .off('afterInit', this.__afterInit)
            .off('beforeDestruct', this.destruct);
        this.setStatus(jodit_core_component__WEBPACK_IMPORTED_MODULE_0__/* .STATUSES */ .f.beforeDestruct);
        if (!this.__inited) {
            return super.destruct();
        }
        if ((0,jodit_core_helpers_checker_is_jodit_object__WEBPACK_IMPORTED_MODULE_2__/* .isJoditObject */ .y)(j)) {
            (_a = this.buttons) === null || _a === void 0 ? void 0 : _a.forEach(btn => {
                j === null || j === void 0 ? void 0 : j.unregisterButton(btn);
            });
        }
        this.beforeDestruct(this.j);
        super.destruct();
    }
}
Plugin.requires = [];
(0,tslib__WEBPACK_IMPORTED_MODULE_3__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], Plugin.prototype, "__afterPluginSystemInit", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_3__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], Plugin.prototype, "__afterInit", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_3__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], Plugin.prototype, "__beforeDestruct", null);


/***/ }),

/***/ 49853:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   d: function() { return /* binding */ Ajax; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_async__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(64890);
/* harmony import */ var jodit_core_decorators_autobind_autobind__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(26318);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_helpers_utils_error__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(50156);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(36115);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(27337);
/* harmony import */ var _response__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(91672);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */








class Ajax {
    className() {
        return 'Ajax';
    }
    constructor(options, defaultAjaxOptions = jodit_config__WEBPACK_IMPORTED_MODULE_3__/* .Config */ .T.prototype.defaultAjaxOptions) {
        this.__async = new jodit_core_async__WEBPACK_IMPORTED_MODULE_0__/* .Async */ .j();
        this.__isFulfilled = false;
        this.__activated = false;
        this.__isDestructed = false;
        this.options = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.ConfigProto)(options || {}, defaultAjaxOptions);
        this.xhr = this.o.xhr ? this.o.xhr() : new XMLHttpRequest();
    }
    __buildParams(obj, prefix) {
        if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.isPlainObject)(obj) &&
            this.options.contentType &&
            this.options.contentType.includes('application/json')) {
            return JSON.stringify(obj);
        }
        if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.isFunction)(this.o.queryBuild)) {
            return this.o.queryBuild.call(this, obj, prefix);
        }
        if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.isString)(obj) ||
            obj instanceof window.FormData ||
            (typeof obj === 'object' && obj != null && (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.isFunction)(obj.append))) {
            return obj;
        }
        return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.buildQuery)(obj);
    }
    get o() {
        return this.options;
    }
    abort() {
        if (this.__isFulfilled) {
            return this;
        }
        try {
            this.__isFulfilled = true;
            this.xhr.abort();
        }
        catch (_a) { }
        return this;
    }
    send() {
        this.__activated = true;
        const { xhr, o } = this;
        const request = this.prepareRequest();
        return this.__async.promise((resolve, reject) => (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__awaiter */ .sH)(this, void 0, void 0, function* () {
            var _a;
            const onReject = () => {
                this.__isFulfilled = true;
                reject(jodit_core_helpers_utils_error__WEBPACK_IMPORTED_MODULE_2__/* .connection */ .FI('Connection error'));
            };
            const onResolve = () => {
                this.__isFulfilled = true;
                resolve(new _response__WEBPACK_IMPORTED_MODULE_6__/* .Response */ .Y(request, xhr.status, xhr.statusText, !xhr.responseType ? xhr.responseText : xhr.response));
            };
            xhr.onload = onResolve;
            xhr.onabort = () => {
                this.__isFulfilled = true;
                reject(jodit_core_helpers_utils_error__WEBPACK_IMPORTED_MODULE_2__/* .abort */ .h2('Abort connection'));
            };
            xhr.onerror = onReject;
            xhr.ontimeout = onReject;
            if (o.responseType) {
                xhr.responseType = o.responseType;
            }
            xhr.onprogress = (e) => {
                var _a, _b;
                let percentComplete = 0;
                if (e.lengthComputable) {
                    percentComplete = (e.loaded / e.total) * 100;
                }
                (_b = (_a = this.options).onProgress) === null || _b === void 0 ? void 0 : _b.call(_a, percentComplete);
            };
            xhr.onreadystatechange = () => {
                var _a, _b;
                (_b = (_a = this.options).onProgress) === null || _b === void 0 ? void 0 : _b.call(_a, 10);
                if (xhr.readyState === XMLHttpRequest.DONE) {
                    if (o.successStatuses.includes(xhr.status)) {
                        onResolve();
                    }
                    else if (xhr.statusText) {
                        this.__isFulfilled = true;
                        reject(jodit_core_helpers_utils_error__WEBPACK_IMPORTED_MODULE_2__/* .connection */ .FI(xhr.statusText));
                    }
                }
            };
            xhr.withCredentials = (_a = o.withCredentials) !== null && _a !== void 0 ? _a : false;
            const { url, data, method } = request;
            xhr.open(method, url, true);
            if (o.contentType && xhr.setRequestHeader) {
                xhr.setRequestHeader('Content-type', o.contentType);
            }
            let { headers } = o;
            if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.isFunction)(headers)) {
                headers = yield headers.call(this);
            }
            if (headers && xhr.setRequestHeader) {
                Object.keys(headers).forEach(key => {
                    xhr.setRequestHeader(key, headers[key]);
                });
            }
            // IE
            this.__async.setTimeout(() => {
                xhr.send(data ? this.__buildParams(data) : undefined);
            }, 0);
        }));
    }
    prepareRequest() {
        if (!this.o.url) {
            throw jodit_core_helpers_utils_error__WEBPACK_IMPORTED_MODULE_2__/* .error */ .z3('Need URL for AJAX request');
        }
        let url = this.o.url;
        const data = this.o.data;
        const method = (this.o.method || 'get').toLowerCase();
        if (method === 'get' && data && (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.isPlainObject)(data)) {
            const qIndex = url.indexOf('?');
            if (qIndex !== -1) {
                const urlData = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.parseQuery)(url);
                url =
                    url.substring(0, qIndex) +
                        '?' +
                        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.buildQuery)(Object.assign(Object.assign({}, urlData), data));
            }
            else {
                url += '?' + (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.buildQuery)(this.o.data);
            }
        }
        const request = {
            url,
            method,
            data
        };
        Ajax.log.splice(100);
        Ajax.log.push(request);
        return request;
    }
    destruct() {
        if (!this.__isDestructed) {
            this.__isDestructed = true;
            if (this.__activated && !this.__isFulfilled) {
                this.abort();
                this.__isFulfilled = true;
            }
            this.__async.destruct();
        }
    }
}
Ajax.log = [];
(0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__decorate */ .Cg)([
    jodit_core_decorators_autobind_autobind__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Ay
], Ajax.prototype, "destruct", null);


/***/ }),

/***/ 27337:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(36115);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

jodit_config__WEBPACK_IMPORTED_MODULE_0__/* .Config */ .T.prototype.defaultAjaxOptions = {
    successStatuses: [200, 201, 202],
    method: 'GET',
    url: '',
    data: null,
    contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
    headers: {
        'X-REQUESTED-WITH': 'XMLHttpRequest' // compatible with jQuery
    },
    withCredentials: false,
    xhr() {
        return new XMLHttpRequest();
    }
};


/***/ }),

/***/ 53883:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Y: function() { return /* reexport safe */ _response__WEBPACK_IMPORTED_MODULE_1__.Y; },
/* harmony export */   d: function() { return /* reexport safe */ _ajax__WEBPACK_IMPORTED_MODULE_0__.d; }
/* harmony export */ });
/* harmony import */ var _ajax__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(49853);
/* harmony import */ var _response__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(91672);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module request
 */




/***/ }),

/***/ 91672:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Y: function() { return /* binding */ Response; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(31635);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

class Response {
    get url() {
        return this.request.url;
    }
    constructor(request, status, statusText, body) {
        this.request = request;
        this.status = status;
        this.statusText = statusText;
        this.body = body;
    }
    json() {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_0__/* .__awaiter */ .sH)(this, void 0, void 0, function* () {
            return JSON.parse(this.body);
        });
    }
    text() {
        return Promise.resolve(this.body);
    }
    blob() {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_0__/* .__awaiter */ .sH)(this, void 0, void 0, function* () {
            return this.body;
        });
    }
}


/***/ }),

/***/ 46602:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Qe: function() { return /* binding */ cursorInTheEdgeOfString; },
/* harmony export */   W8: function() { return /* reexport safe */ _move_node_inside_start__WEBPACK_IMPORTED_MODULE_2__.W; },
/* harmony export */   dY: function() { return /* binding */ findCorrectCurrentNode; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/* harmony import */ var _move_node_inside_start__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5298);
/* harmony import */ var _move_the_node_along_the_edge_outward__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(83541);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module selection
 */




/**
 * Check if the cursor is at the edge of the string
 * @private
 */
function cursorInTheEdgeOfString(container, offset, start, end) {
    var _a;
    const text = ((_a = container.nodeValue) === null || _a === void 0 ? void 0 : _a.length) ? container.nodeValue : '';
    if (end && text.replace((0,jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INVISIBLE_SPACE_REG_EXP_END)(), '').length > offset) {
        return true;
    }
    const inv = (0,jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INVISIBLE_SPACE_REG_EXP_START)().exec(text);
    return start && ((inv && inv[0].length < offset) || (!inv && offset > 0));
}
function findCorrectCurrentNode(node, range, rightMode, isCollapsed, checkChild, child) {
    node = range.startContainer.childNodes[range.startOffset];
    if (!node) {
        node = range.startContainer.childNodes[range.startOffset - 1];
        rightMode = true;
    }
    if (node && isCollapsed && !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isText(node)) {
        // test Current method - Cursor in the left of some SPAN
        if (!rightMode && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isText(node.previousSibling)) {
            node = node.previousSibling;
        }
        else if (checkChild) {
            let current = child(node);
            while (current) {
                if (current && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isText(current)) {
                    node = current;
                    break;
                }
                current = child(current);
            }
        }
    }
    if (node && !isCollapsed && !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isText(node)) {
        let leftChild = node, rightChild = node;
        do {
            leftChild = leftChild.firstChild;
            rightChild = rightChild.lastChild;
        } while (leftChild && rightChild && !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isText(leftChild));
        if (leftChild === rightChild && leftChild && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isText(leftChild)) {
            node = leftChild;
        }
    }
    return { node, rightMode };
}


/***/ }),

/***/ 5298:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   W: function() { return /* binding */ moveNodeInsideStart; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


/**
 * Moves the fake node inside the adjacent element if it lies next to it but not inside.
 * When the cursor is positioned in its place, it must be inside the element and not outside its border.
 * @private
 */
function moveNodeInsideStart(j, node, start) {
    let sibling = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.findSibling(node, start), anotherSibling = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.findSibling(node, !start);
    while (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isElement(sibling) &&
        !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isTag(sibling, jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INSEPARABLE_TAGS) &&
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isContentEditable(sibling, j.editor) &&
        (!anotherSibling || !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.closest(node, jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isElement, j.editor))) {
        if (start || !sibling.firstChild) {
            sibling.appendChild(node);
        }
        else {
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.before(sibling.firstChild, node);
        }
        sibling = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.sibling(node, start);
        anotherSibling = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.sibling(node, !start);
    }
}


/***/ }),

/***/ 83541:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   G: function() { return /* binding */ moveTheNodeAlongTheEdgeOutward; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

/**
 * Moves the fake node up until it encounters a non-empty sibling on the left(right)
 * @private
 */
function moveTheNodeAlongTheEdgeOutward(node, start, root) {
    let item = node;
    while (item && item !== root) {
        const sibling = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.findSibling(item, start);
        if (sibling) {
            return;
        }
        if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isBlock(item.parentElement)) {
            break;
        }
        item = item.parentElement;
        if (item && item !== root) {
            start ? jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.before(item, node) : jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.after(item, node);
        }
    }
    return;
}


/***/ }),

/***/ 87332:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Ag: function() { return /* reexport safe */ _style_constants__WEBPACK_IMPORTED_MODULE_2__.Ag; },
/* harmony export */   DI: function() { return /* reexport safe */ _style_constants__WEBPACK_IMPORTED_MODULE_2__.DI; },
/* harmony export */   LN: function() { return /* reexport safe */ _selection__WEBPACK_IMPORTED_MODULE_0__.L; },
/* harmony export */   OJ: function() { return /* reexport safe */ _style_constants__WEBPACK_IMPORTED_MODULE_2__.OJ; },
/* harmony export */   Zk: function() { return /* reexport safe */ _style_constants__WEBPACK_IMPORTED_MODULE_2__.Zk; },
/* harmony export */   dj: function() { return /* reexport safe */ _style_constants__WEBPACK_IMPORTED_MODULE_2__.dj; },
/* harmony export */   xk: function() { return /* reexport safe */ _style_commit_style__WEBPACK_IMPORTED_MODULE_1__.x; }
/* harmony export */ });
/* harmony import */ var _selection__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(84602);
/* harmony import */ var _style_commit_style__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8757);
/* harmony import */ var _style_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(12043);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module selection
 */





/***/ }),

/***/ 84602:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   L: function() { return /* binding */ Selection; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(9823);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(28712);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var jodit_core_selection_helpers_move_the_node_along_the_edge_outward__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(83541);
/* harmony import */ var _style_commit_style__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(8757);
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(46602);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */












class Selection {
    constructor(jodit) {
        this.jodit = jodit;
        jodit.e.on('removeMarkers', () => {
            this.removeMarkers();
        });
    }
    /**
     * Short alias for this.jodit
     */
    get j() {
        return this.jodit;
    }
    /**
     * Throw Error exception if parameter is not Node
     */
    errorNode(node) {
        if (!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isNode(node)) {
            throw (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.error)('Parameter node must be instance of Node');
        }
    }
    /**
     * Return current work place - for Jodit is Editor
     */
    get area() {
        return this.j.editor;
    }
    /**
     * Editor Window - it can be different for iframe mode
     */
    get win() {
        return this.j.ew;
    }
    /**
     * Current jodit editor doc
     */
    get doc() {
        return this.j.ed;
    }
    /**
     * Return current selection object
     */
    get sel() {
        if (this.j.o.shadowRoot &&
            (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_4__/* .isFunction */ .Tn)(this.j.o.shadowRoot.getSelection)) {
            return this.j.o.shadowRoot.getSelection();
        }
        return this.win.getSelection();
    }
    /**
     * Return first selected range or create new
     */
    get range() {
        const sel = this.sel;
        return sel && sel.rangeCount ? sel.getRangeAt(0) : this.createRange();
    }
    /**
     * Checks if the selected text is currently inside the editor
     */
    get isInsideArea() {
        const { sel } = this;
        const range = (sel === null || sel === void 0 ? void 0 : sel.rangeCount) ? sel.getRangeAt(0) : null;
        return !(!range || !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isOrContains(this.area, range.startContainer));
    }
    /**
     * Return current selection object
     * @param select - Immediately add in selection
     */
    createRange(select = false) {
        const range = this.doc.createRange();
        if (select) {
            this.selectRange(range);
        }
        return range;
    }
    /**
     * Remove all selected content
     */
    remove() {
        const sel = this.sel, current = this.current();
        if (sel && current) {
            for (let i = 0; i < sel.rangeCount; i += 1) {
                sel.getRangeAt(i).deleteContents();
                sel.getRangeAt(i).collapse(true);
            }
        }
    }
    /**
     * Clear all selection
     */
    clear() {
        var _a, _b;
        if ((_a = this.sel) === null || _a === void 0 ? void 0 : _a.rangeCount) {
            (_b = this.sel) === null || _b === void 0 ? void 0 : _b.removeAllRanges();
        }
    }
    /**
     * Remove node element from editor
     */
    removeNode(node) {
        if (!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isOrContains(this.j.editor, node, true)) {
            throw (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.error)("Selection.removeNode can remove only editor's children");
        }
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.safeRemove(node);
        this.j.e.fire('afterRemoveNode', node);
    }
    /**
     * Insert the cursor to any point x, y
     *
     * @param x - Coordinate by horizontal
     * @param y - Coordinate by vertical
     * @returns false - Something went wrong
     */
    insertCursorAtPoint(x, y) {
        this.removeMarkers();
        try {
            const rng = this.createRange();
            (() => {
                if (this.doc.caretPositionFromPoint) {
                    const caret = this.doc.caretPositionFromPoint(x, y);
                    if (caret) {
                        rng.setStart(caret.offsetNode, caret.offset);
                        return;
                    }
                }
                if (this.doc.caretRangeFromPoint) {
                    const caret = this.doc.caretRangeFromPoint(x, y);
                    void 0;
                    rng.setStart(caret.startContainer, caret.startOffset);
                }
            })();
            rng.collapse(true);
            this.selectRange(rng);
            return true;
        }
        catch (_a) { }
        return false;
    }
    /**
     * Check if editor has selection markers
     */
    get hasMarkers() {
        return Boolean(this.markers.length);
    }
    /**
     * Check if editor has selection markers
     */
    get markers() {
        return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.$$)('span[data-' + jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MARKER_CLASS + ']', this.area);
    }
    /**
     * Remove all markers
     */
    removeMarkers() {
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.safeRemove.apply(null, this.markers);
    }
    /**
     * Create marker element
     */
    marker(atStart = false, range) {
        let newRange = null;
        if (range) {
            newRange = range.cloneRange();
            newRange.collapse(atStart);
        }
        const marker = this.j.createInside.span();
        marker.id =
            jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MARKER_CLASS +
                '_' +
                Number(new Date()) +
                '_' +
                String(Math.random()).slice(2);
        marker.style.lineHeight = '0';
        marker.style.display = 'none';
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.markTemporary(marker);
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(marker, 'data-' + jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MARKER_CLASS, atStart ? 'start' : 'end');
        marker.appendChild(this.j.createInside.text(jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INVISIBLE_SPACE));
        if (newRange) {
            if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isOrContains(this.area, atStart ? newRange.startContainer : newRange.endContainer)) {
                // Here need do unsafe inserting
                // Deny Dom.safeInsertNode(newRange, marker);
                // Apply style -> Test Style module -> Base apply -> For selection <p><strong>|test|</strong></p> apply style {"element":"em","style":{"fontStyle":"italic"}}
                newRange.insertNode(marker);
            }
        }
        return marker;
    }
    /**
     * Restores user selections using marker invisible elements in the DOM.
     */
    restore() {
        let range = false;
        const markAttr = (start) => `span[data-${jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MARKER_CLASS}=${start ? 'start' : 'end'}]`;
        const start = this.area.querySelector(markAttr(true)), end = this.area.querySelector(markAttr(false));
        if (!start) {
            return;
        }
        range = this.createRange();
        if (!end) {
            const previousNode = start.previousSibling;
            if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isText(previousNode)) {
                range.setStart(previousNode, previousNode.nodeValue ? previousNode.nodeValue.length : 0);
            }
            else {
                range.setStartBefore(start);
            }
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.safeRemove(start);
            range.collapse(true);
        }
        else {
            range.setStartAfter(start);
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.safeRemove(start);
            range.setEndBefore(end);
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.safeRemove(end);
        }
        if (range) {
            this.selectRange(range);
        }
    }
    fakes() {
        const sel = this.sel;
        if (!sel || !sel.rangeCount) {
            return [];
        }
        const range = sel.getRangeAt(0);
        void 0;
        const left = range.cloneRange();
        left.collapse(true);
        const fakeLeft = this.j.createInside.fake();
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.safeInsertNode(left, fakeLeft);
        range.setStartBefore(fakeLeft);
        const result = [fakeLeft];
        if (!range.collapsed) {
            const right = range.cloneRange();
            right.collapse(false);
            const fakeRight = this.j.createInside.fake();
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.safeInsertNode(right, fakeRight);
            range.setEndAfter(fakeRight);
            result.push(fakeRight);
        }
        this.selectRange(range);
        return result;
    }
    restoreFakes(fakes) {
        var _a, _b, _c, _d;
        const nodes = fakes.filter(n => n.isConnected);
        if (!nodes.length) {
            return;
        }
        const [fakeLeft, fakeRight] = nodes;
        const range = this.createRange();
        range.setStartAfter(fakeLeft);
        if (fakeRight) {
            range.setEndBefore(fakeRight);
        }
        this.selectRange(range);
        if (((_a = fakeLeft.parentNode) === null || _a === void 0 ? void 0 : _a.firstChild) !== ((_b = fakeLeft.parentNode) === null || _b === void 0 ? void 0 : _b.lastChild)) {
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.safeRemove(fakeLeft);
        }
        if (((_c = fakeRight === null || fakeRight === void 0 ? void 0 : fakeRight.parentNode) === null || _c === void 0 ? void 0 : _c.firstChild) !==
            ((_d = fakeRight === null || fakeRight === void 0 ? void 0 : fakeRight.parentNode) === null || _d === void 0 ? void 0 : _d.lastChild)) {
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.safeRemove(fakeRight);
        }
    }
    /**
     * Saves selections using marker invisible elements in the DOM.
     * @param silent - Do not change current range
     */
    save(silent = false) {
        if (this.hasMarkers) {
            return [];
        }
        const sel = this.sel;
        if (!sel || !sel.rangeCount) {
            return [];
        }
        const info = [], length = sel.rangeCount, ranges = [];
        for (let i = 0; i < length; i += 1) {
            ranges[i] = sel.getRangeAt(i);
            if (ranges[i].collapsed) {
                const start = this.marker(true, ranges[i]);
                info[i] = {
                    startId: start.id,
                    collapsed: true,
                    startMarker: start.outerHTML
                };
            }
            else {
                const start = this.marker(true, ranges[i]);
                const end = this.marker(false, ranges[i]);
                info[i] = {
                    startId: start.id,
                    endId: end.id,
                    collapsed: false,
                    startMarker: start.outerHTML,
                    endMarker: end.outerHTML
                };
            }
        }
        if (!silent) {
            sel.removeAllRanges();
            for (let i = length - 1; i >= 0; --i) {
                const startElm = this.doc.getElementById(info[i].startId);
                if (!startElm) {
                    continue;
                }
                if (info[i].collapsed) {
                    ranges[i].setStartAfter(startElm);
                    ranges[i].collapse(true);
                }
                else {
                    ranges[i].setStartBefore(startElm);
                    if (info[i].endId) {
                        const endElm = this.doc.getElementById(info[i].endId);
                        if (endElm) {
                            ranges[i].setEndAfter(endElm);
                        }
                    }
                }
                try {
                    sel.addRange(ranges[i].cloneRange());
                }
                catch (_a) { }
            }
        }
        return info;
    }
    /**
     * Set focus in editor
     */
    focus(options = {
        preventScroll: true
    }) {
        var _a, _b;
        if (!this.isFocused()) {
            const scrollParent = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.getScrollParent)(this.j.container), scrollTop = scrollParent === null || scrollParent === void 0 ? void 0 : scrollParent.scrollTop;
            if (this.j.iframe) {
                if (this.doc.readyState === 'complete') {
                    this.j.iframe.focus(options);
                }
            }
            this.win.focus();
            this.area.focus(options);
            if (scrollTop && (scrollParent === null || scrollParent === void 0 ? void 0 : scrollParent.scrollTo)) {
                scrollParent.scrollTo(0, scrollTop);
            }
            const sel = this.sel, range = (sel === null || sel === void 0 ? void 0 : sel.rangeCount) ? sel === null || sel === void 0 ? void 0 : sel.getRangeAt(0) : null;
            if (!range || !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isOrContains(this.area, range.startContainer)) {
                const range = this.createRange();
                range.setStart(this.area, 0);
                range.collapse(true);
                this.selectRange(range, false);
            }
            if (!this.j.editorIsActive) {
                (_b = (_a = this.j) === null || _a === void 0 ? void 0 : _a.events) === null || _b === void 0 ? void 0 : _b.fire('focus');
            }
            return true;
        }
        return false;
    }
    /**
     * Checks whether the current selection is something or just set the cursor is
     * @returns true Selection does't have content
     */
    isCollapsed() {
        const sel = this.sel;
        for (let r = 0; sel && r < sel.rangeCount; r += 1) {
            if (!sel.getRangeAt(r).collapsed) {
                return false;
            }
        }
        return true;
    }
    /**
     * Checks whether the editor currently in focus
     */
    isFocused() {
        return (this.doc.hasFocus &&
            this.doc.hasFocus() &&
            this.area === this.doc.activeElement);
    }
    /**
     * Returns the current element under the cursor inside editor
     */
    current(checkChild = true) {
        if (this.j.getRealMode() !== jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_WYSIWYG) {
            return null;
        }
        const sel = this.sel;
        if (!sel || sel.rangeCount === 0) {
            return null;
        }
        const range = sel.getRangeAt(0);
        let node = range.startContainer;
        let rightMode = false;
        const child = (nd) => rightMode ? nd.lastChild : nd.firstChild;
        if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isTag(node, 'br') && sel.isCollapsed) {
            return node;
        }
        if (!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isText(node)) {
            const ret = (0,_helpers__WEBPACK_IMPORTED_MODULE_8__/* .findCorrectCurrentNode */ .dY)(node, range, rightMode, sel.isCollapsed, checkChild, child);
            node = ret.node;
            rightMode = ret.rightMode;
        }
        // check - cursor inside editor
        if (node && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isOrContains(this.area, node)) {
            return node;
        }
        return null;
    }
    /**
     * Insert element in editor
     *
     * @param node - Node for insert
     * @param insertCursorAfter - After insert, cursor will move after element
     * @param fireChange - After insert, editor fire change event. You can prevent this behavior
     */
    insertNode(node, insertCursorAfter = true, fireChange = true) {
        this.errorNode(node);
        const child = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isFragment(node) ? node.lastChild : node;
        this.j.e.fire('safeHTML', node);
        if (!this.isFocused() && this.j.isEditorMode()) {
            this.focus();
            this.restore();
        }
        const sel = this.sel;
        this.j.history.snapshot.transaction(() => {
            if (!this.isCollapsed()) {
                this.j.execCommand('Delete');
            }
            this.j.e.fire('beforeInsertNode', node);
            if (sel && sel.rangeCount) {
                const range = sel.getRangeAt(0);
                if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isOrContains(this.area, range.commonAncestorContainer)) {
                    jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.safeInsertNode(range, node);
                }
                else {
                    this.area.appendChild(node);
                }
            }
            else {
                this.area.appendChild(node);
            }
            const setCursor = (node) => {
                if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isBlock(node)) {
                    const child = node.lastChild;
                    if (child) {
                        return setCursor(child);
                    }
                }
                this.setCursorAfter(node);
            };
            if (insertCursorAfter) {
                if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isFragment(node)) {
                    child && setCursor(child);
                }
                else {
                    setCursor(node);
                }
            }
            if (this.j.o.scrollToPastedContent) {
                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.scrollIntoViewIfNeeded)(child !== null && child !== void 0 ? child : node, this.j.editor, this.doc);
            }
        });
        if (fireChange && this.j.events) {
            this.j.__imdSynchronizeValues();
        }
        if (this.j.events) {
            this.j.e.fire('afterInsertNode', jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isFragment(node) ? child : node);
        }
    }
    /**
     * Inserts in the current cursor position some HTML snippet
     *
     * @param html - HTML The text to be inserted into the document
     * @param insertCursorAfter - After insert, cursor will move after element
     * @example
     * ```javascript
     * parent.s.insertHTML('<img src="image.png"/>');
     * ```
     */
    insertHTML(html, insertCursorAfter = true) {
        if (html === '') {
            return;
        }
        const node = this.j.createInside.div();
        const fragment = this.j.createInside.fragment();
        let lastChild;
        if (!this.isFocused() && this.j.isEditorMode()) {
            this.focus();
            this.restore();
        }
        if (!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isNode(html)) {
            node.innerHTML = html.toString();
        }
        else {
            node.appendChild(html);
        }
        if (!this.j.isEditorMode() &&
            this.j.e.fire('insertHTML', node.innerHTML) === false) {
            return;
        }
        lastChild = node.lastChild;
        if (!lastChild) {
            return;
        }
        while (node.firstChild) {
            lastChild = node.firstChild;
            fragment.appendChild(node.firstChild);
        }
        this.insertNode(fragment, insertCursorAfter, false);
        // There is no need to use synchronizeValues because you need to apply the changes immediately
        this.j.__imdSynchronizeValues();
    }
    /**
     * Insert image in editor
     *
     * @param url - URL for image, or HTMLImageElement
     * @param styles - If specified, it will be applied <code>$(image).css(styles)</code>
     * @param defaultWidth - If specified, it will be applied <code>css('width', defaultWidth)</code>
     */
    insertImage(url, styles = null, defaultWidth = null) {
        const image = (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_4__/* .isString */ .Kg)(url) ? this.j.createInside.element('img') : url;
        if ((0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_4__/* .isString */ .Kg)(url)) {
            image.setAttribute('src', url);
        }
        if (defaultWidth != null) {
            let dw = defaultWidth.toString();
            if (dw &&
                'auto' !== dw &&
                String(dw).indexOf('px') < 0 &&
                String(dw).indexOf('%') < 0) {
                dw += 'px';
            }
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.call)(
            // @ts-ignore
            this.j.o.resizer.forImageChangeAttributes ? jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr : jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.css, image, 'width', 
            // @ts-ignore
            dw);
        }
        if (styles && typeof styles === 'object') {
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.css)(image, styles);
        }
        const onload = () => {
            if (image.naturalHeight < image.offsetHeight ||
                image.naturalWidth < image.offsetWidth) {
                image.style.width = '';
                image.style.height = '';
            }
            image.removeEventListener('load', onload);
        };
        this.j.e.on(image, 'load', onload);
        if (image.complete) {
            onload();
        }
        this.insertNode(image);
        /**
         * Triggered after image was inserted [[Select.insertImage]]. This method can executed from
         * [[FileBrowser]] or [[Uploader]]
         * @example
         * ```javascript
         * var editor = Jodit.make("#redactor");
         * editor.e.on('afterInsertImage', function (image) {
         *     image.className = 'bloghead4';
         * });
         * ```
         */
        this.j.e.fire('afterInsertImage', image);
    }
    /**
     * Call callback for all selection node
     */
    eachSelection(callback) {
        var _a;
        const sel = this.sel;
        if (!sel || !sel.rangeCount) {
            return;
        }
        const range = sel.getRangeAt(0);
        let root = range.commonAncestorContainer;
        if (!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isHTMLElement(root)) {
            root = root.parentElement;
        }
        const nodes = [];
        const startOffset = range.startOffset;
        const length = root.childNodes.length;
        const elementOffset = startOffset < length ? startOffset : length - 1;
        let start = range.startContainer === this.area
            ? root.childNodes[elementOffset]
            : range.startContainer;
        let end = range.endContainer === this.area
            ? root.childNodes[range.endOffset - 1]
            : range.endContainer;
        if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isText(start) &&
            start === range.startContainer &&
            range.startOffset === ((_a = start.nodeValue) === null || _a === void 0 ? void 0 : _a.length) &&
            start.nextSibling) {
            start = start.nextSibling;
        }
        if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isText(end) &&
            end === range.endContainer &&
            range.endOffset === 0 &&
            end.previousSibling) {
            end = end.previousSibling;
        }
        const checkElm = (node) => {
            if (node &&
                node !== root &&
                !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isEmptyTextNode(node) &&
                !(0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_4__/* .isMarker */ .rg)(node)) {
                nodes.push(node);
            }
        };
        checkElm(start);
        if (start !== end && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isOrContains(root, start, true)) {
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.find(start, node => {
                checkElm(node);
                // checks parentElement as well because partial selections are not equal to entire element
                return (node === end ||
                    (node && node.contains && node.contains(end)));
            }, root, true, false);
        }
        const forEvery = (current) => {
            if (!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isOrContains(this.j.editor, current, true)) {
                return;
            }
            if (current.nodeName.match(/^(UL|OL)$/)) {
                return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.toArray)(current.childNodes).forEach(forEvery);
            }
            if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isTag(current, 'li')) {
                if (current.firstChild) {
                    current = current.firstChild;
                }
                else {
                    const currentB = this.j.createInside.text(jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INVISIBLE_SPACE);
                    current.appendChild(currentB);
                    current = currentB;
                }
            }
            callback(current);
        };
        if (nodes.length === 0) {
            if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isEmptyTextNode(start)) {
                nodes.push(start);
            }
            if (start.firstChild) {
                nodes.push(start.firstChild);
            }
        }
        nodes.forEach(forEvery);
    }
    /**
     * Checks if the cursor is at the end(start) block
     *
     * @param  start - true - check whether the cursor is at the start block
     * @param parentBlock - Find in this
     * @param fake - Node for cursor position
     *
     * @returns true - the cursor is at the end(start) block, null - cursor somewhere outside
     */
    cursorInTheEdge(start, parentBlock, fake = null) {
        var _a;
        const end = !start, range = (_a = this.sel) === null || _a === void 0 ? void 0 : _a.getRangeAt(0);
        fake !== null && fake !== void 0 ? fake : (fake = this.current(false));
        if (!range || !fake || !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isOrContains(parentBlock, fake, true)) {
            return null;
        }
        const container = start ? range.startContainer : range.endContainer;
        const offset = start ? range.startOffset : range.endOffset;
        const isSignificant = (elm) => Boolean(elm &&
            !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isTag(elm, 'br') &&
            !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isEmptyTextNode(elm) &&
            !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isTemporary(elm) &&
            !(jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isElement(elm) &&
                this.j.e.fire('isInvisibleForCursor', elm) === true));
        // check right offset
        if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isText(container)) {
            if ((0,_helpers__WEBPACK_IMPORTED_MODULE_8__/* .cursorInTheEdgeOfString */ .Qe)(container, offset, start, end)) {
                return false;
            }
        }
        else {
            const children = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.toArray)(container.childNodes);
            if (end) {
                if (children.slice(offset).some(isSignificant)) {
                    return false;
                }
            }
            else {
                if (children.slice(0, offset).some(isSignificant)) {
                    return false;
                }
            }
        }
        let next = fake;
        while (next && next !== parentBlock) {
            const nextOne = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.sibling(next, start);
            if (!nextOne) {
                next = next.parentNode;
                continue;
            }
            next = nextOne;
            if (next && isSignificant(next)) {
                return false;
            }
        }
        return true;
    }
    /**
     * Wrapper for cursorInTheEdge
     */
    cursorOnTheLeft(parentBlock, fake) {
        return this.cursorInTheEdge(true, parentBlock, fake);
    }
    /**
     * Wrapper for cursorInTheEdge
     */
    cursorOnTheRight(parentBlock, fake) {
        return this.cursorInTheEdge(false, parentBlock, fake);
    }
    /**
     * Set cursor after the node
     * @returns fake invisible textnode. After insert it can be removed
     */
    setCursorAfter(node) {
        return this.setCursorNearWith(node, false);
    }
    /**
     * Set cursor before the node
     * @returns fake invisible textnode. After insert it can be removed
     */
    setCursorBefore(node) {
        return this.setCursorNearWith(node, true);
    }
    /**
     * Add fake node for new cursor position
     */
    setCursorNearWith(node, inStart) {
        var _a, _b;
        this.errorNode(node);
        if (!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.up(node, (elm) => elm === this.area || (elm && elm.parentNode === this.area), this.area)) {
            throw (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.error)('Node element must be in editor');
        }
        const range = this.createRange();
        let fakeNode = null;
        if (!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isText(node)) {
            fakeNode = this.j.createInside.fake();
            inStart ? range.setStartBefore(node) : range.setEndAfter(node);
            range.collapse(inStart);
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.safeInsertNode(range, fakeNode);
            range.selectNode(fakeNode);
        }
        else {
            if (inStart) {
                range.setStart(node, 0);
            }
            else {
                range.setEnd(node, (_b = (_a = node.nodeValue) === null || _a === void 0 ? void 0 : _a.length) !== null && _b !== void 0 ? _b : 0);
            }
        }
        range.collapse(inStart);
        this.selectRange(range);
        return fakeNode;
    }
    /**
     * Set cursor in the node
     * @param node - Node element
     * @param inStart - set cursor in start of element
     */
    setCursorIn(node, inStart = false) {
        this.errorNode(node);
        if (!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.up(node, (elm) => elm === this.area || (elm && elm.parentNode === this.area), this.area)) {
            throw (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.error)('Node element must be in editor');
        }
        const range = this.createRange();
        let start = node, last = node;
        do {
            if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isText(start) || jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isTag(start, jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INSEPARABLE_TAGS)) {
                break;
            }
            last = start;
            start = inStart ? start.firstChild : start.lastChild;
        } while (start);
        if (!start) {
            const fakeNode = this.j.createInside.text(jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INVISIBLE_SPACE);
            if (!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isTag(last, jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INSEPARABLE_TAGS)) {
                last.appendChild(fakeNode);
                last = fakeNode;
            }
            else {
                start = last;
            }
        }
        const workElm = start || last;
        if (!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isTag(workElm, jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INSEPARABLE_TAGS)) {
            range.selectNodeContents(workElm);
            range.collapse(inStart);
        }
        else {
            inStart || jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isTag(workElm, 'br')
                ? range.setStartBefore(workElm)
                : range.setEndAfter(workElm);
            range.collapse(inStart);
        }
        this.selectRange(range);
        return last;
    }
    /**
     * Set range selection
     */
    selectRange(range, focus = true) {
        const sel = this.sel;
        if (focus && !this.isFocused()) {
            this.focus();
        }
        if (sel) {
            sel.removeAllRanges();
            sel.addRange(range);
        }
        /**
         * Fired after change selection
         */
        this.j.e.fire('changeSelection');
        return this;
    }
    /**
     * Select node
     * @param node - Node element
     * @param inward - select all inside
     */
    select(node, inward = false) {
        this.errorNode(node);
        if (!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.up(node, (elm) => elm === this.area || (elm && elm.parentNode === this.area), this.area)) {
            throw (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.error)('Node element must be in editor');
        }
        const range = this.createRange();
        range[inward ? 'selectNodeContents' : 'selectNode'](node);
        return this.selectRange(range);
    }
    /**
     * Return current selected HTML
     * @example
     * ```javascript
     * const editor = Jodit.make();
     * console.log(editor.s.html); // html
     * console.log(Jodit.modules.Helpers.stripTags(editor.s.html)); // plain text
     * ```
     */
    get html() {
        const sel = this.sel;
        if (sel && sel.rangeCount > 0) {
            const range = sel.getRangeAt(0);
            const clonedSelection = range.cloneContents();
            const div = this.j.createInside.div();
            div.appendChild(clonedSelection);
            return div.innerHTML;
        }
        return '';
    }
    /**
     * Wrap all selected fragments inside Tag or apply some callback
     */
    *wrapInTagGen(fakes) {
        if (this.isCollapsed()) {
            const font = this.jodit.createInside.element('font', jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INVISIBLE_SPACE);
            this.insertNode(font, false, false);
            if (fakes && fakes[0]) {
                font.appendChild(fakes[0]);
            }
            yield font;
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.unwrap(font);
            return;
        }
        // fix issue https://github.com/xdan/jodit/issues/65
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.$$)('*[style*=font-size]', this.area).forEach(elm => {
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(elm, 'data-font-size', elm.style.fontSize.toString());
            elm.style.removeProperty('font-size');
        });
        this.j.nativeExecCommand('fontsize', false, '7');
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.$$)('*[data-font-size]', this.area).forEach(elm => {
            const fontSize = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(elm, 'data-font-size');
            if (fontSize) {
                elm.style.fontSize = fontSize;
                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(elm, 'data-font-size', null);
            }
        });
        const elms = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.$$)('font[size="7"]', this.area);
        for (const font of elms) {
            const { firstChild, lastChild } = font;
            if (firstChild &&
                firstChild === lastChild &&
                (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_4__/* .isMarker */ .rg)(firstChild)) {
                jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.unwrap(font);
                continue;
            }
            if (firstChild && (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_4__/* .isMarker */ .rg)(firstChild)) {
                jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.before(font, firstChild);
            }
            if (lastChild && (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_4__/* .isMarker */ .rg)(lastChild)) {
                jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.after(font, lastChild);
            }
            yield font;
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.unwrap(font);
        }
        return;
    }
    /**
     * Wrap all selected fragments inside Tag or apply some callback
     */
    wrapInTag(tagOrCallback) {
        const result = [];
        for (const font of this.wrapInTagGen()) {
            try {
                if (font.firstChild &&
                    font.firstChild === font.lastChild &&
                    (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_4__/* .isMarker */ .rg)(font.firstChild)) {
                    continue;
                }
                if ((0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_4__/* .isFunction */ .Tn)(tagOrCallback)) {
                    tagOrCallback(font);
                }
                else {
                    result.push(jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.replace(font, tagOrCallback, this.j.createInside));
                }
            }
            finally {
                const pn = font.parentNode;
                if (pn) {
                    jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.unwrap(font);
                    if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isEmpty(pn)) {
                        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.unwrap(pn);
                    }
                }
            }
        }
        return result;
    }
    /**
     * Apply some css rules for all selections. It method wraps selections in nodeName tag.
     * @example
     * ```js
     * const editor = Jodit.make('#editor');
     * editor.value = 'test';
     * editor.execCommand('selectall');
     *
     * editor.s.commitStyle({
     * 	style: {color: 'red'}
     * }) // will wrap `text` in `span` and add style `color:red`
     * editor.s.commitStyle({
     * 	style: {color: 'red'}
     * }) // will remove `color:red` from `span`
     * ```
     */
    commitStyle(options) {
        void 0;
        const styleElm = new _style_commit_style__WEBPACK_IMPORTED_MODULE_7__/* .CommitStyle */ .x(options);
        styleElm.apply(this.j);
    }
    /**
     * Split selection on two parts: left and right
     */
    splitSelection(currentBox, edge) {
        if (!this.isCollapsed()) {
            return null;
        }
        const leftRange = this.createRange();
        const range = this.range;
        leftRange.setStartBefore(currentBox);
        const cursorOnTheRight = this.cursorOnTheRight(currentBox, edge);
        const cursorOnTheLeft = this.cursorOnTheLeft(currentBox, edge);
        const br = this.j.createInside.element('br'), prevFake = this.j.createInside.fake(), nextFake = prevFake.cloneNode();
        try {
            if (cursorOnTheRight || cursorOnTheLeft) {
                if (edge) {
                    jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.before(edge, br);
                }
                else {
                    jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.safeInsertNode(range, br);
                }
                const clearBR = (start, getNext) => {
                    let next = getNext(start);
                    while (next) {
                        const nextSib = getNext(next);
                        if (next &&
                            (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isTag(next, 'br') || jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isEmptyTextNode(next))) {
                            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.safeRemove(next);
                        }
                        else {
                            break;
                        }
                        next = nextSib;
                    }
                };
                clearBR(br, (n) => n.nextSibling);
                clearBR(br, (n) => n.previousSibling);
                jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.after(br, nextFake);
                jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.before(br, prevFake);
                if (cursorOnTheRight) {
                    leftRange.setEndBefore(br);
                    range.setEndBefore(br);
                }
                else {
                    leftRange.setEndAfter(br);
                    range.setEndAfter(br);
                }
            }
            else {
                leftRange.setEnd(range.startContainer, range.startOffset);
            }
            const fragment = leftRange.extractContents();
            const clearEmpties = (node) => jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.each(node, node => jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isEmptyTextNode(node) && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.safeRemove(node));
            void 0;
            try {
                clearEmpties(fragment);
                clearEmpties(currentBox);
                currentBox.parentNode.insertBefore(fragment, currentBox);
                if (!edge && cursorOnTheRight && (br === null || br === void 0 ? void 0 : br.parentNode)) {
                    const range = this.createRange();
                    range.setStartBefore(br);
                    this.selectRange(range);
                }
            }
            catch (e) {
                if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD) {
                    throw e;
                }
            }
            // After splitting some part can be empty
            const fillFakeParent = (fake) => {
                var _a, _b, _c;
                if (((_a = fake === null || fake === void 0 ? void 0 : fake.parentNode) === null || _a === void 0 ? void 0 : _a.firstChild) === ((_b = fake === null || fake === void 0 ? void 0 : fake.parentNode) === null || _b === void 0 ? void 0 : _b.lastChild)) {
                    (_c = fake === null || fake === void 0 ? void 0 : fake.parentNode) === null || _c === void 0 ? void 0 : _c.appendChild(br.cloneNode());
                }
            };
            fillFakeParent(prevFake);
            fillFakeParent(nextFake);
        }
        finally {
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.safeRemove(prevFake);
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.safeRemove(nextFake);
        }
        return currentBox.previousElementSibling;
    }
    expandSelection() {
        if (this.isCollapsed()) {
            return this;
        }
        const { range } = this;
        const c = range.cloneRange();
        if (!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isOrContains(this.j.editor, range.commonAncestorContainer, true)) {
            return this;
        }
        const moveMaxEdgeFake = (start) => {
            const fake = this.j.createInside.fake();
            const r = range.cloneRange();
            r.collapse(start);
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.safeInsertNode(r, fake);
            (0,jodit_core_selection_helpers_move_the_node_along_the_edge_outward__WEBPACK_IMPORTED_MODULE_6__/* .moveTheNodeAlongTheEdgeOutward */ .G)(fake, start, this.j.editor);
            return fake;
        };
        const leftFake = moveMaxEdgeFake(true);
        const rightFake = moveMaxEdgeFake(false);
        c.setStartAfter(leftFake);
        c.setEndBefore(rightFake);
        const leftBox = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.findSibling(leftFake, false);
        const rightBox = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.findSibling(rightFake, true);
        if (leftBox !== rightBox) {
            const rightInsideLeft = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isElement(leftBox) && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isOrContains(leftBox, rightFake);
            const leftInsideRight = !rightInsideLeft &&
                jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isElement(rightBox) &&
                jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isOrContains(rightBox, leftFake);
            if (rightInsideLeft || leftInsideRight) {
                let child = (rightInsideLeft ? leftBox : rightBox), container = child;
                while (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isElement(child)) {
                    child = rightInsideLeft
                        ? child.firstElementChild
                        : child.lastElementChild;
                    if (child) {
                        const isInside = rightInsideLeft
                            ? jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isOrContains(child, rightFake)
                            : jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isOrContains(child, leftFake);
                        if (isInside) {
                            container = child;
                        }
                    }
                }
                if (rightInsideLeft) {
                    c.setStart(container, 0);
                }
                else {
                    c.setEnd(container, container.childNodes.length);
                }
            }
        }
        this.selectRange(c);
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.safeRemove(leftFake, rightFake);
        if (this.isCollapsed()) {
            throw (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.error)('Selection is collapsed');
        }
        return this;
    }
}
(0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], Selection.prototype, "createRange", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], Selection.prototype, "focus", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], Selection.prototype, "setCursorAfter", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], Selection.prototype, "setCursorBefore", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], Selection.prototype, "setCursorIn", null);


/***/ }),

/***/ 20384:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   y: function() { return /* binding */ extractSelectedPart; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_checker_is_marker__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(71274);
/* harmony import */ var jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(59101);
/* harmony import */ var jodit_core_helpers_utils_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(84976);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */




/**
 * If the selection area is inside an element that matches the commit (suitable relative),
 * but does not completely fill it.
 * Then the method cuts the parent and leaves itself in a copy of the parent (suitable relative) in the middle.
 *
 * @example
 * Apply strong to
 * ```html
 * 	<strong><span>some<font>SELECTED</font>text</span></strong>
 * ```
 * Should extract selection from parent `strong`
 * ```html
 * `<strong><span>some</span></strong><strong><span><font>SELECTED</font></span></strong><strong><span>test</span></strong>
 * ```
 * @private
 */
function extractSelectedPart(wrapper, font, jodit) {
    const range = jodit.s.createRange();
    // Left part
    const leftEdge = (0,jodit_core_helpers_checker_is_marker__WEBPACK_IMPORTED_MODULE_1__/* .isMarker */ .r)(font.previousSibling)
        ? font.previousSibling
        : font;
    range.setStartBefore(wrapper);
    range.setEndBefore(leftEdge);
    extractAndMove(wrapper, range, true);
    // Right part
    const rightEdge = (0,jodit_core_helpers_checker_is_marker__WEBPACK_IMPORTED_MODULE_1__/* .isMarker */ .r)(font.nextSibling) ? font.nextSibling : font;
    range.setStartAfter(rightEdge);
    range.setEndAfter(wrapper);
    extractAndMove(wrapper, range, false);
}
/**
 * Retrieves content before after the selected area, clears it if it is empty, and inserts before after the framed selection
 */
function extractAndMove(wrapper, range, left) {
    const fragment = range.extractContents();
    if ((!fragment.textContent || !(0,jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_2__/* .trim */ .Bq)(fragment.textContent).length) &&
        fragment.firstChild) {
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.unwrap(fragment.firstChild);
    }
    if (wrapper.parentNode) {
        (0,jodit_core_helpers_utils_utils__WEBPACK_IMPORTED_MODULE_3__/* .call */ .T1)(left ? jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.before : jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.after, wrapper, fragment);
    }
}


/***/ }),

/***/ 10466:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   E: function() { return /* binding */ FiniteStateMachine; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(28712);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_1__);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



/**
 * A state machine implementation for applying styles.
 */
class FiniteStateMachine {
    setState(state) {
        void 0;
        this.__previewsStates.add(state);
        this.__state = state;
    }
    getState() {
        return this.__state;
    }
    disableSilent() {
        this.silent = false;
    }
    constructor(state, transitions) {
        this.transitions = transitions;
        this.silent = true;
        this.__previewsStates = new Set();
        this.setState(state);
    }
    dispatch(actionName, value) {
        const action = this.transitions[this.getState()][actionName];
        if (action) {
            const res = action.call(this, value);
            void 0;
            void 0;
            void 0;
            this.setState(res.next);
            if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD && !this.silent) {
                // eslint-disable-next-line no-console
                console.log(`State: ${this.getState()}`);
            }
            return res;
        }
        throw new Error(`invalid action: ${this.getState()}.${actionName.toString()}`);
    }
}


/***/ }),

/***/ 75220:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   G: function() { return /* binding */ getSuitChild; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/* harmony import */ var _is_normal_node__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38046);
/* harmony import */ var _is_suit_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(95274);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



/**
 * Checks if child elements are suitable for applying styles.
 * An element is suitable for us only if it is the only significant child.
 * If the child matches then returns it.
 * @example
 * `<font><strong>selected</strong></font>`
 * @private
 */
function getSuitChild(style, font) {
    let { firstChild: child } = font;
    while (child && !(0,_is_normal_node__WEBPACK_IMPORTED_MODULE_1__/* .isNormalNode */ ._)(child)) {
        child = child.nextSibling;
        if (!child) {
            return null;
        }
    }
    if (child &&
        !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.next(child, _is_normal_node__WEBPACK_IMPORTED_MODULE_1__/* .isNormalNode */ ._, font) &&
        (0,_is_suit_element__WEBPACK_IMPORTED_MODULE_2__/* .isSuitElement */ .sz)(style, child, false)) {
        return child;
    }
    return null;
}


/***/ }),

/***/ 52052:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: function() { return /* binding */ getSuitParent; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/* harmony import */ var _is_normal_node__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38046);
/* harmony import */ var _is_suit_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(95274);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



/**
 * Checks if the parent of an element is suitable for applying styles, if applicable, then returns the parent *
 *
 * @param style - styles to be applied
 * @param node - checked item
 * @param root - editor root
 * @private
 */
function getSuitParent(style, node, root) {
    const { parentNode } = node;
    if (parentNode === root ||
        !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isHTMLElement(parentNode) ||
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.next(node, _is_normal_node__WEBPACK_IMPORTED_MODULE_1__/* .isNormalNode */ ._, parentNode) ||
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.prev(node, _is_normal_node__WEBPACK_IMPORTED_MODULE_1__/* .isNormalNode */ ._, parentNode)) {
        return null;
    }
    // <h3><span style="color:red">|test|</span></h3> => apply <h2>
    if (style.isElementCommit &&
        style.elementIsBlock &&
        !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isBlock(parentNode)) {
        return getSuitParent(style, parentNode, root);
    }
    if ((0,_is_suit_element__WEBPACK_IMPORTED_MODULE_2__/* .isSuitElement */ .sz)(style, parentNode, false) &&
        (!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isBlock(parentNode) || style.elementIsBlock)) {
        return parentNode;
    }
    // <strong style="color:red"><em>|test|</em></strong> => apply <strong>
    if (style.isElementCommit && !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isBlock(parentNode)) {
        return getSuitParent(style, parentNode, root);
    }
    return null;
}


/***/ }),

/***/ 70592:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Y: function() { return /* binding */ hasSameStyleKeys; },
/* harmony export */   g: function() { return /* binding */ hasSameStyle; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_checker_is_void__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(35642);
/* harmony import */ var jodit_core_helpers_normalize_normalize_css_value__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(59678);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(28712);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(38322);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */





/**
 * Element has the same styles as in the commit
 * @private
 */
function hasSameStyle(elm, rules) {
    return Boolean(!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(elm, 'font') &&
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isHTMLElement(elm) &&
        Object.keys(rules).every(property => {
            const value = (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_2__/* .css */ .A)(elm, property, true);
            if (value === '' &&
                (rules[property] === '' || rules[property] == null)) {
                return true;
            }
            return (!(0,jodit_core_helpers_checker_is_void__WEBPACK_IMPORTED_MODULE_3__/* .isVoid */ .R)(value) &&
                value !== '' &&
                !(0,jodit_core_helpers_checker_is_void__WEBPACK_IMPORTED_MODULE_3__/* .isVoid */ .R)(rules[property]) &&
                (0,jodit_core_helpers_normalize_normalize_css_value__WEBPACK_IMPORTED_MODULE_4__/* .normalizeCssValue */ .iy)(property, rules[property])
                    .toString()
                    .toLowerCase() === value.toString().toLowerCase());
        }));
}
const elm = document.createElement('div');
elm.style.color = 'red';
void 0;
void 0;
void 0;
/**
 * Element has the similar styles keys
 */
function hasSameStyleKeys(elm, rules) {
    return Boolean(!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(elm, 'font') &&
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isHTMLElement(elm) &&
        Object.keys(rules).every(property => {
            const value = (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_2__/* .css */ .A)(elm, property, true);
            return value !== '';
        }));
}
const elm2 = document.createElement('div');
elm2.style.color = 'red';
void 0;
void 0;
void 0;


/***/ }),

/***/ 97621:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   $s: function() { return /* reexport safe */ _is_suit_element__WEBPACK_IMPORTED_MODULE_8__.$s; },
/* harmony export */   AS: function() { return /* reexport safe */ _get_suit_parent__WEBPACK_IMPORTED_MODULE_3__.A; },
/* harmony export */   Dd: function() { return /* reexport safe */ _is_same_attributes__WEBPACK_IMPORTED_MODULE_7__.D; },
/* harmony export */   EF: function() { return /* reexport safe */ _finite_state_machine__WEBPACK_IMPORTED_MODULE_1__.E; },
/* harmony export */   G6: function() { return /* reexport safe */ _get_suit_child__WEBPACK_IMPORTED_MODULE_2__.G; },
/* harmony export */   LV: function() { return /* reexport safe */ _wrap__WEBPACK_IMPORTED_MODULE_13__.L; },
/* harmony export */   M6: function() { return /* reexport safe */ _is_same_attributes__WEBPACK_IMPORTED_MODULE_7__.M; },
/* harmony export */   Yx: function() { return /* reexport safe */ _toggle_attributes__WEBPACK_IMPORTED_MODULE_11__.Y; },
/* harmony export */   iu: function() { return /* reexport safe */ _is_inside_invisible_element__WEBPACK_IMPORTED_MODULE_5__.i; },
/* harmony export */   ks: function() { return /* reexport safe */ _list_toggle_ordered_list__WEBPACK_IMPORTED_MODULE_9__.k; },
/* harmony export */   tm: function() { return /* reexport safe */ _unwrap_children__WEBPACK_IMPORTED_MODULE_12__.t; },
/* harmony export */   yP: function() { return /* reexport safe */ _extract__WEBPACK_IMPORTED_MODULE_0__.y; }
/* harmony export */ });
/* harmony import */ var _extract__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20384);
/* harmony import */ var _finite_state_machine__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(10466);
/* harmony import */ var _get_suit_child__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(75220);
/* harmony import */ var _get_suit_parent__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(52052);
/* harmony import */ var _has_same_style__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(70592);
/* harmony import */ var _is_inside_invisible_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(78777);
/* harmony import */ var _is_normal_node__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(38046);
/* harmony import */ var _is_same_attributes__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(13676);
/* harmony import */ var _is_suit_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(95274);
/* harmony import */ var _list_toggle_ordered_list__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(90325);
/* harmony import */ var _list_wrap_list__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(61001);
/* harmony import */ var _toggle_attributes__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(38271);
/* harmony import */ var _unwrap_children__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(86500);
/* harmony import */ var _wrap__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(3101);
/* harmony import */ var _wrap_unwrapped_text__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(80394);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

















/***/ }),

/***/ 78777:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   i: function() { return /* binding */ isInsideInvisibleElement; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

/**
 * Check if FONT inside STYLE or SCRIPT element
 * @private
 */
function isInsideInvisibleElement(font, root) {
    return Boolean(jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.closest(font, ['style', 'script'], root));
}


/***/ }),

/***/ 38046:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   _: function() { return /* binding */ isNormalNode; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_checker_is_marker__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(71274);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


/**
 * Is normal usual element
 * @private
 */
function isNormalNode(elm) {
    return Boolean(elm &&
        !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isEmptyTextNode(elm) &&
        !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTemporary(elm) &&
        !(0,jodit_core_helpers_checker_is_marker__WEBPACK_IMPORTED_MODULE_1__/* .isMarker */ .r)(elm));
}


/***/ }),

/***/ 13676:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   D: function() { return /* binding */ elementsEqualAttributes; },
/* harmony export */   M: function() { return /* binding */ isSameAttributes; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_size_object_size__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(95350);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(97369);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(28712);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _has_same_style__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(70592);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */




/**
 * Compares whether the given attributes match the element's own attributes
 * @private
 */
function isSameAttributes(elm, attrs) {
    if (!elm.attributes.length && !(0,jodit_core_helpers_size_object_size__WEBPACK_IMPORTED_MODULE_0__/* .size */ .E)(attrs)) {
        return true;
    }
    if (!(0,jodit_core_helpers_size_object_size__WEBPACK_IMPORTED_MODULE_0__/* .size */ .E)(attrs)) {
        return true;
    }
    void 0;
    return Object.keys(attrs).every(key => {
        if (key === 'class' || key === 'className') {
            return elm.classList.contains(attrs[key]);
        }
        if (key === 'style') {
            return (0,_has_same_style__WEBPACK_IMPORTED_MODULE_3__/* .hasSameStyle */ .g)(elm, attrs[key]);
        }
        return (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.attr)(elm, key) === attrs[key];
    });
}
function elementsEqualAttributes(elm1, elm2) {
    return (elm1.attributes.length === elm2.attributes.length &&
        Array.from(elm1.attributes).every(attr => elm2.hasAttribute(attr.name) &&
            elm2.getAttribute(attr.name) === attr.value));
}


/***/ }),

/***/ 95274:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   $s: function() { return /* binding */ suitableClosest; },
/* harmony export */   Wv: function() { return /* binding */ isSameStyleChild; },
/* harmony export */   sz: function() { return /* binding */ isSuitElement; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/* harmony import */ var _has_same_style__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(70592);
/* harmony import */ var _is_normal_node__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(38046);



/**
 * Checks if an item is suitable for applying a commit. The element suits us if it
 *  - has the same styles as in the commit (commitStyle.options.style)
 *  - has the same tag as in the commit (commitStyle.options.element)
 *
 * @param commitStyle - style commit
 * @param elm - checked item
 * @param strict - strict mode - false - the default tag is suitable for us if it is also in the commit
 * @param strictStyle - strict style mode - true - the element has the same style keys as in the commit, but not their values
 * @private
 */
function isSuitElement(commitStyle, elm, strict, strictStyle = true) {
    var _a;
    if (!elm || !(0,_is_normal_node__WEBPACK_IMPORTED_MODULE_2__/* .isNormalNode */ ._)(elm)) {
        return false;
    }
    const { element, elementIsDefault, options } = commitStyle;
    if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isList(elm) && commitStyle.elementIsList) {
        return true;
    }
    const elmIsSame = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(elm, element);
    if (elmIsSame && !(elementIsDefault && strict)) {
        return true;
    }
    const elmHasSameStyle = Boolean(((_a = options.attributes) === null || _a === void 0 ? void 0 : _a.style) &&
        (strictStyle
            ? (0,_has_same_style__WEBPACK_IMPORTED_MODULE_1__/* .hasSameStyle */ .g)(elm, options.attributes.style)
            : (0,_has_same_style__WEBPACK_IMPORTED_MODULE_1__/* .hasSameStyleKeys */ .Y)(elm, options.attributes.style)));
    if (elmHasSameStyle && !commitStyle.elementIsList) {
        return true;
    }
    return !elmIsSame && !strict && elementIsDefault && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isInlineBlock(elm);
}
/**
 * @private
 */
function suitableClosest(commitStyle, element, root) {
    return jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.closest(element, node => isSuitElement(commitStyle, node, true, false), root);
}
/**
 * Inside the parent element there is a block with the same styles
 * @example
 * For selection:
 * ```html
 * <p>|test<strong>test</strong>|</p>
 * ```
 * Apply `{element:'strong'}`
 * @private
 */
function isSameStyleChild(commitStyle, elm) {
    var _a, _b;
    const { element, options } = commitStyle;
    if (!elm || !(0,_is_normal_node__WEBPACK_IMPORTED_MODULE_2__/* .isNormalNode */ ._)(elm)) {
        return false;
    }
    const elmIsSame = elm.nodeName.toLowerCase() === element;
    const elmHasSameStyle = Boolean(((_a = options.attributes) === null || _a === void 0 ? void 0 : _a.style) &&
        (0,_has_same_style__WEBPACK_IMPORTED_MODULE_1__/* .hasSameStyleKeys */ .Y)(elm, (_b = options.attributes) === null || _b === void 0 ? void 0 : _b.style));
    return elmIsSame && elmHasSameStyle;
}


/***/ }),

/***/ 90325:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   k: function() { return /* binding */ toggleOrderedList; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(28712);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var jodit_core_selection_style_api_extract__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(20384);
/* harmony import */ var jodit_core_selection_style_api_toggle_attributes__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(38271);
/* harmony import */ var jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(12043);
/* harmony import */ var _wrap_list__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(61001);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */






/**
 * Replaces `ul->ol` or `ol->ul`, apply styles to the list, or remove a list item from it
 * @private
 */
function toggleOrderedList(commitStyle, li, jodit, mode) {
    if (!li) {
        return mode;
    }
    const list = li.parentElement;
    if (!list) {
        return mode;
    }
    const result = jodit.e.fire(`${jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_5__/* ._PREFIX */ .ar}BeforeToggleList`, mode, commitStyle, list);
    if (result !== undefined) {
        return result;
    }
    const hook = jodit.e.fire.bind(jodit.e, `${jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_5__/* ._PREFIX */ .ar}AfterToggleList`);
    if (mode !== jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_5__/* .UNWRAP */ .OJ) {
        const isChangeMode = (0,jodit_core_selection_style_api_toggle_attributes__WEBPACK_IMPORTED_MODULE_3__/* .toggleAttributes */ .Y)(commitStyle, li.parentElement, jodit, jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_5__/* .INITIAL */ .DI, true) === jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_5__/* .CHANGE */ .PL;
        // ul => ol, ol => ul or ul => ul.class1
        if (mode === jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_5__/* .REPLACE */ .dj ||
            isChangeMode ||
            list.tagName.toLowerCase() !== commitStyle.element) {
            const wrapper = unwrapList(jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_5__/* .REPLACE */ .dj, list, li, jodit, commitStyle);
            const newList = (0,_wrap_list__WEBPACK_IMPORTED_MODULE_4__/* .wrapList */ .z)(commitStyle, wrapper, jodit);
            hook(jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_5__/* .REPLACE */ .dj, newList, commitStyle);
            return jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_5__/* .REPLACE */ .dj;
        }
    }
    const wrapper = unwrapList(jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_5__/* .UNWRAP */ .OJ, list, li, jodit, commitStyle);
    hook(jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_5__/* .UNWRAP */ .OJ, wrapper, commitStyle);
    return jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_5__/* .UNWRAP */ .OJ;
}
function unwrapList(mode, list, li, jodit, cs) {
    const result = jodit.e.fire(`${jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_5__/* ._PREFIX */ .ar}BeforeUnwrapList`, mode, list, cs);
    if (result) {
        void 0;
        return result;
    }
    (0,jodit_core_selection_style_api_extract__WEBPACK_IMPORTED_MODULE_2__/* .extractSelectedPart */ .y)(list, li, jodit);
    void 0;
    jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.unwrap(li.parentElement);
    return jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.replace(li, jodit.o.enter, jodit.createInside);
}


/***/ }),

/***/ 61001:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   z: function() { return /* binding */ wrapList; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_selection_style_api__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(97621);
/* harmony import */ var jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(12043);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



/**
 * Replaces non-leaf items with leaf items and either creates a new list or
 * adds a new item to the nearest old list
 * @private
 */
function wrapList(commitStyle, wrapper, jodit) {
    const result = jodit.e.fire(`${jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_2__/* ._PREFIX */ .ar}BeforeWrapList`, jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_2__/* .REPLACE */ .dj, wrapper, commitStyle);
    const newWrapper = result !== null && result !== void 0 ? result : jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.replace(wrapper, 'li', jodit.createInside);
    const prev = newWrapper.previousElementSibling;
    const next = newWrapper.nextElementSibling;
    let list = jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(prev, commitStyle.element) ? prev : null;
    list !== null && list !== void 0 ? list : (list = jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(next, commitStyle.element) ? next : null);
    if (!jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isList(list) ||
        !(0,jodit_core_selection_style_api__WEBPACK_IMPORTED_MODULE_1__/* .isSameAttributes */ .M6)(list, commitStyle.options.attributes)) {
        list = jodit.createInside.element(commitStyle.element);
        (0,jodit_core_selection_style_api__WEBPACK_IMPORTED_MODULE_1__/* .toggleAttributes */ .Yx)(commitStyle, list, jodit, jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_2__/* .INITIAL */ .DI);
        jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.before(newWrapper, list);
    }
    if (prev === list) {
        jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.append(list, newWrapper);
    }
    else {
        jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.prepend(list, newWrapper);
    }
    if (jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(list.nextElementSibling, commitStyle.element) &&
        (0,jodit_core_selection_style_api__WEBPACK_IMPORTED_MODULE_1__/* .elementsEqualAttributes */ .Dd)(list, list.nextElementSibling)) {
        jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.append(list, Array.from(list.nextElementSibling.childNodes));
        jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.safeRemove(list.nextElementSibling);
    }
    jodit.e.fire(`${jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_2__/* ._PREFIX */ .ar}AfterWrapList`, jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_2__/* .WRAP */ .Zk, list, commitStyle);
    return list;
}


/***/ }),

/***/ 38271:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Y: function() { return /* binding */ toggleAttributes; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9823);
/* harmony import */ var jodit_core_helpers_normalize_normalize_css_value__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(59678);
/* harmony import */ var jodit_core_helpers_size_object_size__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(95350);
/* harmony import */ var jodit_core_helpers_string_kebab_case__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(449);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(97369);
/* harmony import */ var jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(38322);
/* harmony import */ var jodit_core_helpers_utils_data_bind__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(72197);
/* harmony import */ var jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(12043);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */










const tak = 'toggleAttributes';
/**
 * Toggles attributes
 * @private
 */
function toggleAttributes(commitStyle, elm, jodit, mode, dry = false) {
    if (!dry && commitStyle.isApplied(elm, tak)) {
        return mode;
    }
    !dry && commitStyle.setApplied(elm, tak);
    const { attributes } = commitStyle.options;
    if (attributes && (0,jodit_core_helpers_size_object_size__WEBPACK_IMPORTED_MODULE_3__/* .size */ .E)(attributes) > 0) {
        Object.keys(attributes).forEach((key) => {
            const value = attributes[key];
            switch (key) {
                case 'style': {
                    mode = toggleStyle(commitStyle, jodit, value, elm, dry, mode);
                    break;
                }
                case 'className':
                case 'class':
                    mode = toggleClass(jodit, value, elm, mode, dry);
                    break;
                default:
                    mode = toggleAttribute(jodit, value, elm, key, dry, mode);
            }
        });
    }
    return mode;
}
function toggleStyle(commitStyle, jodit, style, elm, dry, mode) {
    void 0;
    Object.keys(style).forEach((rule) => {
        const inlineValue = elm.style.getPropertyValue((0,jodit_core_helpers_string_kebab_case__WEBPACK_IMPORTED_MODULE_6__/* .kebabCase */ .k)(rule));
        const newValue = style[rule];
        if (inlineValue === '' && newValue == null) {
            return;
        }
        if (getNativeCSSValue(jodit, elm, rule) ===
            (0,jodit_core_helpers_normalize_normalize_css_value__WEBPACK_IMPORTED_MODULE_7__/* .normalizeCssValue */ .iy)(rule, newValue)) {
            if (!inlineValue) {
                return;
            }
            !dry && (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_8__/* .css */ .A)(elm, rule, null);
            mode = jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_9__/* .UNSET */ .Ag;
            mode = removeExtraStyleAttribute(commitStyle, elm, mode);
            return;
        }
        mode = jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_9__/* .CHANGE */ .PL;
        if (!dry) {
            (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_8__/* .css */ .A)(elm, rule, newValue);
            mode = removeExtraStyleAttribute(commitStyle, elm, mode);
        }
    });
    return mode;
}
function toggleClass(jodit, value, elm, mode, dry) {
    void 0;
    const hook = jodit.e.fire.bind(jodit.e, `${jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_9__/* ._PREFIX */ .ar}AfterToggleAttribute`);
    if (elm.classList.contains(value.toString())) {
        mode = jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_9__/* .UNSET */ .Ag;
        if (!dry) {
            elm.classList.remove(value);
            if (elm.classList.length === 0) {
                (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__.attr)(elm, 'class', null);
                hook(mode, elm, 'class', null);
            }
        }
    }
    else {
        mode = jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_9__/* .CHANGE */ .PL;
        if (!dry) {
            elm.classList.add(value);
            hook(mode, elm, 'class', value);
        }
    }
    return mode;
}
function toggleAttribute(jodit, value, elm, key, dry, mode) {
    void 0;
    const hook = jodit.e.fire.bind(jodit.e, `${jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_9__/* ._PREFIX */ .ar}AfterToggleAttribute`);
    if ((0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__.attr)(elm, key) === value) {
        !dry && (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__.attr)(elm, key, null);
        mode = jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_9__/* .UNSET */ .Ag;
        !dry && hook(mode, elm, key, value);
        return mode;
    }
    mode = jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_9__/* .CHANGE */ .PL;
    if (!dry) {
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__.attr)(elm, key, value);
        hook(mode, elm, key, value);
    }
    return mode;
}
/**
 * If the element has an empty style attribute, it removes the attribute,
 * and if it is default, it removes the element itself
 */
function removeExtraStyleAttribute(commitStyle, elm, mode) {
    if (!(0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__.attr)(elm, 'style')) {
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__.attr)(elm, 'style', null);
        if (elm.tagName.toLowerCase() === commitStyle.defaultTag) {
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.unwrap(elm);
            mode = jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_9__/* .UNWRAP */ .OJ;
        }
    }
    return mode;
}
/**
 * Creates an iframe into which elements will be inserted to test their default styles in the browser
 */
function getShadowRoot(jodit) {
    var _a;
    if ((0,jodit_core_helpers_utils_data_bind__WEBPACK_IMPORTED_MODULE_5__/* .dataBind */ .m)(jodit, 'shadowRoot') !== undefined) {
        return (0,jodit_core_helpers_utils_data_bind__WEBPACK_IMPORTED_MODULE_5__/* .dataBind */ .m)(jodit, 'shadowRoot');
    }
    const container = (0,jodit_core_global__WEBPACK_IMPORTED_MODULE_1__/* .getContainer */ .My)(jodit);
    const iframe = document.createElement('iframe');
    (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_8__/* .css */ .A)(iframe, {
        width: 0,
        height: 0,
        position: 'absolute',
        border: 0
    });
    iframe.src = 'about:blank';
    container.appendChild(iframe);
    const doc = (_a = iframe.contentWindow) === null || _a === void 0 ? void 0 : _a.document;
    const shadowRoot = !doc ? jodit.od.body : doc.body;
    (0,jodit_core_helpers_utils_data_bind__WEBPACK_IMPORTED_MODULE_5__/* .dataBind */ .m)(jodit, 'shadowRoot', shadowRoot);
    return shadowRoot;
}
/**
 * `strong -> fontWeight 700`
 */
function getNativeCSSValue(jodit, elm, key) {
    const newElm = jodit.create.element(elm.tagName.toLowerCase());
    newElm.style.cssText = elm.style.cssText;
    const root = getShadowRoot(jodit);
    root.appendChild(newElm);
    const result = (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_8__/* .css */ .A)(newElm, key);
    jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.safeRemove(newElm);
    return result;
}


/***/ }),

/***/ 86500:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   t: function() { return /* binding */ unwrapChildren; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(97369);
/* harmony import */ var jodit_core_selection_style_api_has_same_style__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(70592);
/* harmony import */ var _is_suit_element__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(95274);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */




/**
 * Unwrap all suit elements inside
 * @private
 */
function unwrapChildren(style, font) {
    var _a;
    const needUnwrap = [];
    const needChangeStyle = [];
    let firstElementSuit;
    const cssStyle = (_a = style.options.attributes) === null || _a === void 0 ? void 0 : _a.style;
    if (font.firstChild) {
        const gen = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.eachGen(font);
        let item = gen.next();
        while (!item.done) {
            const elm = item.value;
            if ((0,_is_suit_element__WEBPACK_IMPORTED_MODULE_3__/* .isSuitElement */ .sz)(style, elm, true) &&
                (!cssStyle || (0,jodit_core_selection_style_api_has_same_style__WEBPACK_IMPORTED_MODULE_2__/* .hasSameStyleKeys */ .Y)(elm, cssStyle))) {
                if (firstElementSuit === undefined) {
                    firstElementSuit = true;
                }
                needUnwrap.push(elm);
            }
            else if (cssStyle && (0,_is_suit_element__WEBPACK_IMPORTED_MODULE_3__/* .isSameStyleChild */ .Wv)(style, elm)) {
                if (firstElementSuit === undefined) {
                    firstElementSuit = false;
                }
                needChangeStyle.push(() => {
                    (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.css)(elm, Object.keys(cssStyle).reduce((acc, key) => {
                        acc[key] = null;
                        return acc;
                    }, {}));
                    if (!(0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.attr)(elm, 'style')) {
                        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.attr)(elm, 'style', null);
                    }
                    if (!(0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.attr)(elm, 'style') &&
                        elm.nodeName.toLowerCase() === style.element) {
                        needUnwrap.push(elm);
                    }
                });
            }
            else if (!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isEmptyTextNode(elm)) {
                if (firstElementSuit === undefined) {
                    firstElementSuit = false;
                }
            }
            item = gen.next();
        }
    }
    needChangeStyle.forEach(clb => clb());
    needUnwrap.forEach(jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.unwrap);
    return Boolean(firstElementSuit);
}


/***/ }),

/***/ 80394:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Y: function() { return /* binding */ wrapUnwrappedText; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_checker_is_marker__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(71274);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


/**
 * Wrap text or inline elements inside Block element
 * @private
 */
function wrapUnwrappedText(style, elm, jodit) {
    const root = jodit.editor, ci = jodit.createInside, edge = (n, key = 'previousSibling') => {
        let edgeNode = n, node = n;
        while (node && !(0,jodit_core_helpers_checker_is_marker__WEBPACK_IMPORTED_MODULE_1__/* .isMarker */ .r)(node)) {
            if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(node, jodit.o.enter)) {
                break;
            }
            edgeNode = node;
            if (node[key]) {
                node = node[key];
            }
            else {
                node =
                    node.parentNode &&
                        !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isBlock(node.parentNode) &&
                        node.parentNode !== root
                        ? node.parentNode
                        : null;
            }
            if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isBlock(node)) {
                break;
            }
        }
        return edgeNode;
    };
    const start = edge(elm), end = edge(elm, 'nextSibling');
    const range = jodit.s.createRange();
    range.setStartBefore(start);
    range.setEndAfter(end);
    const fragment = range.extractContents();
    const wrapper = ci.element(style.element);
    wrapper.appendChild(fragment);
    jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.safeInsertNode(range, wrapper);
    if (style.elementIsBlock) {
        if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isEmpty(wrapper) &&
            !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(wrapper.firstElementChild, 'br')) {
            wrapper.appendChild(ci.element('br'));
        }
    }
    return wrapper;
}


/***/ }),

/***/ 3101:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   L: function() { return /* binding */ wrap; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(26150);
/* harmony import */ var _list_wrap_list__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(61001);
/* harmony import */ var _wrap_unwrapped_text__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(80394);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */




/**
 * Replaces the parent tag with the applicable one, or wraps the text and also replaces the tag
 * @private
 */
function wrap(commitStyle, font, jodit) {
    const wrapper = findOrCreateWrapper(commitStyle, font, jodit);
    return commitStyle.elementIsList
        ? (0,_list_wrap_list__WEBPACK_IMPORTED_MODULE_2__/* .wrapList */ .z)(commitStyle, wrapper, jodit)
        : jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.replace(wrapper, commitStyle.element, jodit.createInside, true);
}
const WRAP_NODES = new Set([
    'td',
    'th',
    'tr',
    'tbody',
    'table',
    'li',
    'ul',
    'ol'
]);
/**
 * If we apply a block element, then it finds the closest block parent (exclude table cell etc.),
 * otherwise it wraps free text in an element.
 */
function findOrCreateWrapper(commitStyle, font, jodit) {
    if (commitStyle.elementIsBlock) {
        const box = jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.up(font, node => jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isBlock(node) && !jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(node, WRAP_NODES), jodit.editor);
        if (box) {
            return box;
        }
        return (0,_wrap_unwrapped_text__WEBPACK_IMPORTED_MODULE_3__/* .wrapUnwrappedText */ .Y)(commitStyle, font, jodit);
    }
    (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_1__/* .attr */ .C)(font, 'size', null);
    return font;
}


/***/ }),

/***/ 10494:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   O: function() { return /* binding */ ApplyStyle; }
/* harmony export */ });
/* harmony import */ var _api__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(97621);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(12043);
/* harmony import */ var _transactions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(37649);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



/** @internal */
function ApplyStyle(jodit, cs) {
    var _a;
    const { s: sel, editor } = jodit;
    // sel.save();
    (_a = editor.firstChild) === null || _a === void 0 ? void 0 : _a.normalize(); // FF fix for test "commandsTest - Exec command "bold"
    const fakes = sel.fakes();
    const gen = jodit.s.wrapInTagGen(fakes);
    let font = gen.next();
    if (font.done) {
        return;
    }
    let state = {
        collapsed: sel.isCollapsed(),
        mode: _constants__WEBPACK_IMPORTED_MODULE_2__/* .INITIAL */ .DI,
        element: font.value,
        next: _transactions__WEBPACK_IMPORTED_MODULE_1__/* .states */ .x.START,
        jodit,
        style: cs
    };
    while (font && !font.done) {
        const machine = new _api__WEBPACK_IMPORTED_MODULE_0__/* .FiniteStateMachine */ .EF(_transactions__WEBPACK_IMPORTED_MODULE_1__/* .states */ .x.START, _transactions__WEBPACK_IMPORTED_MODULE_1__/* .transactions */ .g);
        state.element = font.value;
        // machine.disableSilent();
        while (machine.getState() !== _transactions__WEBPACK_IMPORTED_MODULE_1__/* .states */ .x.END) {
            // console.log(machine.getState(), state);
            state = machine.dispatch('exec', state);
        }
        // console.log('-------------------');
        font = gen.next();
    }
    // sel.restore();
    sel.restoreFakes(fakes);
}


/***/ }),

/***/ 8757:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   x: function() { return /* binding */ CommitStyle; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_helpers_string_camel_case__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(83260);
/* harmony import */ var jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(12043);
/* harmony import */ var _apply_style__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(10494);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */




class CommitStyle {
    isApplied(elm, key) {
        const data = this.__applyMap.get(elm);
        if (!data) {
            return false;
        }
        return data[key];
    }
    setApplied(elm, key) {
        var _a;
        const data = (_a = this.__applyMap.get(elm)) !== null && _a !== void 0 ? _a : {};
        data[key] = true;
        this.__applyMap.set(elm, data);
    }
    get elementIsList() {
        return Boolean(this.options.element && jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.LIST_TAGS.has(this.options.element));
    }
    get element() {
        return this.options.element || this.defaultTag;
    }
    /**
     * New element is blocked
     */
    get elementIsBlock() {
        return Boolean(this.options.element && jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_BLOCK.test(this.options.element));
    }
    /**
     * The commit applies the tag change
     */
    get isElementCommit() {
        return Boolean(this.options.element &&
            this.options.element !== this.options.defaultTag);
    }
    get defaultTag() {
        if (this.options.defaultTag) {
            return this.options.defaultTag;
        }
        return this.elementIsBlock ? 'p' : 'span';
    }
    get elementIsDefault() {
        return this.element === this.defaultTag;
    }
    constructor(options) {
        this.options = options;
        this.__applyMap = new WeakMap();
    }
    apply(jodit) {
        const { hooks } = this.options;
        const keys = (hooks ? Object.keys(hooks) : []);
        try {
            keys.forEach(key => {
                jodit.e.on((0,jodit_core_helpers_string_camel_case__WEBPACK_IMPORTED_MODULE_2__/* .camelCase */ .x)(jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_3__/* ._PREFIX */ .ar + '_' + key), hooks[key]);
            });
            (0,_apply_style__WEBPACK_IMPORTED_MODULE_1__/* .ApplyStyle */ .O)(jodit, this);
        }
        finally {
            keys.forEach(key => {
                jodit.e.off((0,jodit_core_helpers_string_camel_case__WEBPACK_IMPORTED_MODULE_2__/* .camelCase */ .x)(jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_3__/* ._PREFIX */ .ar + '_' + key), hooks[key]);
            });
            this.__applyMap = new WeakMap();
        }
        jodit.synchronizeValues();
        jodit.e.fire('afterCommitStyle', this);
    }
}


/***/ }),

/***/ 12043:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Ag: function() { return /* binding */ UNSET; },
/* harmony export */   DI: function() { return /* binding */ INITIAL; },
/* harmony export */   OJ: function() { return /* binding */ UNWRAP; },
/* harmony export */   PL: function() { return /* binding */ CHANGE; },
/* harmony export */   Zk: function() { return /* binding */ WRAP; },
/* harmony export */   ar: function() { return /* binding */ _PREFIX; },
/* harmony export */   dj: function() { return /* binding */ REPLACE; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module selection
 */
/** @internal */
const WRAP = 'wrap';
/** @internal */
const UNWRAP = 'unwrap';
/** @internal */
const CHANGE = 'change';
/** @internal */
const UNSET = 'unset';
/** @internal */
const INITIAL = 'initial';
/** @internal */
const REPLACE = 'replace';
/** @internal */
const _PREFIX = 'commitStyle';


/***/ }),

/***/ 37649:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   g: function() { return /* binding */ transactions; },
/* harmony export */   x: function() { return /* binding */ states; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(28712);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var jodit_core_selection__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(87332);
/* harmony import */ var jodit_core_selection_style_api__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(97621);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */





const states = {
    START: 'START',
    ELEMENT: 'ELEMENT',
    UNWRAP: 'UNWRAP',
    UNWRAP_CHILDREN: 'UNWRAP_CHILDREN',
    CHANGE: 'CHANGE',
    REPLACE_DEFAULT: 'REPLACE_DEFAULT',
    LIST: 'LIST',
    TOGGLE_LIST: 'TOGGLE_LIST',
    WRAP: 'WRAP',
    EXTRACT: 'EXTRACT',
    END: 'END'
};
const transactions = {
    [states.START]: {
        exec(value) {
            const { element, jodit, style, mode, collapsed } = value;
            if ((0,jodit_core_selection_style_api__WEBPACK_IMPORTED_MODULE_4__/* .isInsideInvisibleElement */ .iu)(element, jodit.editor) ||
                (!collapsed && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isEmptyContent(element))) {
                return Object.assign(Object.assign({}, value), { next: states.END });
            }
            const elm = (0,jodit_core_selection_style_api__WEBPACK_IMPORTED_MODULE_4__/* .getSuitParent */ .AS)(style, element, jodit.editor) ||
                (0,jodit_core_selection_style_api__WEBPACK_IMPORTED_MODULE_4__/* .getSuitChild */ .G6)(style, element);
            if (elm) {
                return Object.assign(Object.assign({}, value), { next: states.ELEMENT, element: elm });
            }
            const suit = (0,jodit_core_selection_style_api__WEBPACK_IMPORTED_MODULE_4__/* .suitableClosest */ .$s)(style, element, jodit.editor);
            if (style.elementIsList && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isList(suit)) {
                return Object.assign(Object.assign({}, value), { next: states.LIST });
            }
            if (suit) {
                return Object.assign(Object.assign({}, value), { next: states.EXTRACT });
            }
            return Object.assign(Object.assign({}, value), { next: mode !== jodit_core_selection__WEBPACK_IMPORTED_MODULE_3__/* .UNWRAP */ .OJ ? states.UNWRAP_CHILDREN : states.END });
        }
    },
    [states.LIST]: {
        exec(value) {
            const { element, jodit, mode } = value;
            if (mode !== jodit_core_selection__WEBPACK_IMPORTED_MODULE_3__/* .INITIAL */ .DI && mode !== jodit_core_selection__WEBPACK_IMPORTED_MODULE_3__/* .UNWRAP */ .OJ && mode !== jodit_core_selection__WEBPACK_IMPORTED_MODULE_3__/* .REPLACE */ .dj) {
                return Object.assign(Object.assign({}, value), { next: states.END });
            }
            const li = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.closest(element, 'li', jodit.editor);
            if (!li) {
                return Object.assign(Object.assign({}, value), { next: states.END });
            }
            const list = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.closest(element, jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.LIST_TAGS, jodit.editor);
            if (list) {
                return Object.assign(Object.assign({}, value), { element: li, next: states.TOGGLE_LIST });
            }
            return Object.assign(Object.assign({}, value), { next: states.END });
        }
    },
    [states.TOGGLE_LIST]: {
        exec(value) {
            return Object.assign(Object.assign({}, value), { mode: (0,jodit_core_selection_style_api__WEBPACK_IMPORTED_MODULE_4__/* .toggleOrderedList */ .ks)(value.style, value.element, value.jodit, value.mode), next: states.END });
        }
    },
    [states.EXTRACT]: {
        exec(value) {
            const { element, jodit, style } = value;
            const suit = (0,jodit_core_selection_style_api__WEBPACK_IMPORTED_MODULE_4__/* .suitableClosest */ .$s)(style, element, jodit.editor);
            void 0;
            if (!style.elementIsBlock) {
                (0,jodit_core_selection_style_api__WEBPACK_IMPORTED_MODULE_4__/* .extractSelectedPart */ .yP)(suit, element, jodit);
            }
            return Object.assign(Object.assign({}, value), { element: suit, next: states.ELEMENT });
        }
    },
    [states.UNWRAP_CHILDREN]: {
        exec(value) {
            const { element, style } = value;
            if (!(0,jodit_core_selection_style_api__WEBPACK_IMPORTED_MODULE_4__/* .unwrapChildren */ .tm)(style, element)) {
                return Object.assign(Object.assign({}, value), { next: states.WRAP });
            }
            return Object.assign(Object.assign({}, value), { mode: jodit_core_selection__WEBPACK_IMPORTED_MODULE_3__/* .UNWRAP */ .OJ, next: states.END });
        }
    },
    [states.WRAP]: {
        exec(value) {
            const { element, jodit, style } = value;
            const wrapper = (0,jodit_core_selection_style_api__WEBPACK_IMPORTED_MODULE_4__/* .wrap */ .LV)(style, element, jodit);
            return Object.assign(Object.assign({}, value), { next: style.elementIsList ? states.END : states.CHANGE, mode: jodit_core_selection__WEBPACK_IMPORTED_MODULE_3__/* .WRAP */ .Zk, element: wrapper });
        }
    },
    [states.ELEMENT]: {
        exec(value) {
            const { style, element, jodit } = value;
            if ((0,jodit_core_selection_style_api__WEBPACK_IMPORTED_MODULE_4__/* .toggleAttributes */ .Yx)(style, element, jodit, jodit_core_selection__WEBPACK_IMPORTED_MODULE_3__/* .INITIAL */ .DI, true) !==
                jodit_core_selection__WEBPACK_IMPORTED_MODULE_3__/* .INITIAL */ .DI) {
                return Object.assign(Object.assign({}, value), { next: states.CHANGE });
            }
            // Apply same color for anchor https://github.com/xdan/jodit/issues/936
            if (!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isTag(element, style.element)) {
                return Object.assign(Object.assign({}, value), { next: states.END });
            }
            return Object.assign(Object.assign({}, value), { next: states.UNWRAP });
        }
    },
    [states.CHANGE]: {
        exec(value) {
            const { style, element, jodit, mode } = value;
            const newMode = (0,jodit_core_selection_style_api__WEBPACK_IMPORTED_MODULE_4__/* .toggleAttributes */ .Yx)(style, element, jodit, value.mode);
            if (mode !== jodit_core_selection__WEBPACK_IMPORTED_MODULE_3__/* .WRAP */ .Zk &&
                newMode === jodit_core_selection__WEBPACK_IMPORTED_MODULE_3__/* .UNSET */ .Ag &&
                !element.attributes.length &&
                jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isTag(element, style.element)) {
                return Object.assign(Object.assign({}, value), { next: states.UNWRAP });
            }
            return Object.assign(Object.assign({}, value), { mode: newMode, next: states.END });
        }
    },
    [states.UNWRAP]: {
        exec(value) {
            if (value.element.attributes.length &&
                jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isTag(value.element, value.style.element)) {
                return Object.assign(Object.assign({}, value), { next: states.REPLACE_DEFAULT });
            }
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.unwrap(value.element);
            return Object.assign(Object.assign({}, value), { mode: jodit_core_selection__WEBPACK_IMPORTED_MODULE_3__/* .UNWRAP */ .OJ, next: states.END });
        }
    },
    [states.REPLACE_DEFAULT]: {
        exec(value) {
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.replace(value.element, value.style.defaultTag, value.jodit.createInside, true);
            return Object.assign(Object.assign({}, value), { mode: jodit_core_selection__WEBPACK_IMPORTED_MODULE_3__/* .REPLACE */ .dj, next: states.END });
        }
    },
    [states.END]: {
        exec(value) {
            return value;
        }
    }
};


/***/ }),

/***/ 17800:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   I: function() { return /* binding */ canUsePersistentStorage; },
/* harmony export */   O: function() { return /* binding */ LocalStorageProvider; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * Check if user disable local storages/cookie etc.
 */
const canUsePersistentStorage = (() => {
    const canUse = () => {
        const tmpKey = '___Jodit___' + Math.random().toString();
        try {
            localStorage.setItem(tmpKey, '1');
            const result = localStorage.getItem(tmpKey) === '1';
            localStorage.removeItem(tmpKey);
            return result;
        }
        catch (_a) { }
        return false;
    };
    let result;
    return () => {
        if (result === undefined) {
            result = canUse();
        }
        return result;
    };
})();
/**
 * Persistent storage in localStorage
 */
class LocalStorageProvider {
    set(key, value) {
        try {
            const buffer = localStorage.getItem(this.rootKey);
            const json = buffer ? JSON.parse(buffer) : {};
            json[key] = value;
            localStorage.setItem(this.rootKey, JSON.stringify(json));
        }
        catch (_a) { }
        return this;
    }
    delete(key) {
        try {
            localStorage.removeItem(this.rootKey);
        }
        catch (_a) { }
        return this;
    }
    get(key) {
        try {
            const buffer = localStorage.getItem(this.rootKey);
            const json = buffer ? JSON.parse(buffer) : {};
            return json[key] !== undefined ? json[key] : null;
        }
        catch (_a) { }
    }
    exists(key) {
        return this.get(key) != null;
    }
    constructor(rootKey) {
        this.rootKey = rootKey;
    }
    clear() {
        try {
            localStorage.removeItem(this.rootKey);
        }
        catch (_a) { }
        return this;
    }
}


/***/ }),

/***/ 2788:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   M: function() { return /* binding */ MemoryStorageProvider; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
class MemoryStorageProvider {
    constructor() {
        this.data = new Map();
    }
    set(key, value) {
        this.data.set(key, value);
        return this;
    }
    delete(key) {
        this.data.delete(key);
        return this;
    }
    get(key) {
        return this.data.get(key);
    }
    exists(key) {
        return this.data.has(key);
    }
    clear() {
        this.data.clear();
        return this;
    }
}


/***/ }),

/***/ 63915:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   wc: function() { return /* reexport safe */ _storage__WEBPACK_IMPORTED_MODULE_1__.w; }
/* harmony export */ });
/* harmony import */ var _engines_local_storage_provider__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17800);
/* harmony import */ var _storage__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(24834);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module storage
 */





/***/ }),

/***/ 24834:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   w: function() { return /* binding */ Storage; }
/* harmony export */ });
/* unused harmony export StorageKey */
/* harmony import */ var jodit_core_helpers_string_camel_case__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(83260);
/* harmony import */ var _engines_local_storage_provider__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17800);
/* harmony import */ var _engines_memory_storage_provider__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(2788);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



const StorageKey = 'Jodit_';
class Storage {
    set(key, value) {
        this.provider.set((0,jodit_core_helpers_string_camel_case__WEBPACK_IMPORTED_MODULE_1__/* .camelCase */ .x)(this.prefix + key), value);
        return this;
    }
    delete(key) {
        this.provider.delete((0,jodit_core_helpers_string_camel_case__WEBPACK_IMPORTED_MODULE_1__/* .camelCase */ .x)(this.prefix + key));
        return this;
    }
    get(key) {
        return this.provider.get((0,jodit_core_helpers_string_camel_case__WEBPACK_IMPORTED_MODULE_1__/* .camelCase */ .x)(this.prefix + key));
    }
    exists(key) {
        return this.provider.exists((0,jodit_core_helpers_string_camel_case__WEBPACK_IMPORTED_MODULE_1__/* .camelCase */ .x)(this.prefix + key));
    }
    clear() {
        this.provider.clear();
        return this;
    }
    constructor(provider, suffix) {
        this.provider = provider;
        this.prefix = StorageKey;
        if (suffix) {
            this.prefix += suffix;
        }
    }
    static makeStorage(persistent = false, suffix) {
        let provider;
        if (persistent && (0,_engines_local_storage_provider__WEBPACK_IMPORTED_MODULE_0__/* .canUsePersistentStorage */ .I)()) {
            provider = new _engines_local_storage_provider__WEBPACK_IMPORTED_MODULE_0__/* .LocalStorageProvider */ .O(StorageKey + suffix);
        }
        if (!provider) {
            provider = new _engines_memory_storage_provider__WEBPACK_IMPORTED_MODULE_2__/* .MemoryStorageProvider */ .M();
        }
        return new Storage(provider, suffix);
    }
}


/***/ }),

/***/ 58597:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   z: function() { return /* binding */ Dlgs; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9823);
/* harmony import */ var jodit_core_helpers_utils_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(84976);
/* harmony import */ var jodit_modules_dialog__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(34256);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



class Dlgs {
    dlg(options) {
        const dialog = new jodit_modules_dialog__WEBPACK_IMPORTED_MODULE_2__/* .Dialog */ .lG(Object.assign({ language: this.o.language, shadowRoot: this.o.shadowRoot, ownerWindow: this.o.ownerWindow, defaultTimeout: this.o.defaultTimeout, theme: this.o.theme, globalFullSize: this.o.globalFullSize }, options));
        (0,jodit_core_helpers_utils_utils__WEBPACK_IMPORTED_MODULE_1__/* .markOwner */ .b_)(this, dialog.container);
        dialog.parent = this;
        return dialog.bindDestruct(this);
    }
    confirm(msg, title, callback) {
        msg = processTitle(msg, this);
        title = processTitle(title, this);
        return jodit_modules_dialog__WEBPACK_IMPORTED_MODULE_2__/* .Confirm */ .pT.call(this.dlg({ closeOnClickOverlay: true }), msg, title, callback);
    }
    prompt(msg, title, callback, placeholder, defaultValue) {
        msg = processTitle(msg, this);
        title = processTitle(title, this);
        placeholder = processTitle(placeholder, this);
        return jodit_modules_dialog__WEBPACK_IMPORTED_MODULE_2__/* .Prompt */ .XG.call(this.dlg({ closeOnClickOverlay: true }), msg, title, callback, placeholder, defaultValue);
    }
    alert(msg, title, callback, className) {
        msg = processTitle(msg, this);
        title = processTitle(title, this);
        return jodit_modules_dialog__WEBPACK_IMPORTED_MODULE_2__/* .Alert */ .Fc.call(this.dlg({ closeOnClickOverlay: true }), msg, title, callback, className);
    }
}
function processTitle(title, self) {
    if ((0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_0__/* .isString */ .Kg)(title) && !(0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_0__/* .isHTML */ .AH)(title)) {
        title = self.i18n(title);
    }
    return title;
}


/***/ }),

/***/ 87906:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   O: function() { return /* binding */ Elms; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_array_to_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(42448);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

class Elms {
    /**
     * Return element with BEM class name
     */
    getElm(elementName) {
        return this.container.querySelector(`.${this.getFullElName(elementName)}`);
    }
    /**
     * Return elements with BEM class name
     */
    getElms(elementName) {
        return (0,jodit_core_helpers_array_to_array__WEBPACK_IMPORTED_MODULE_0__/* .toArray */ .$)(this.container.querySelectorAll(`.${this.getFullElName(elementName)}`));
    }
}


/***/ }),

/***/ 75758:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   K: function() { return /* binding */ Mods; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_void__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(35642);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

class Mods {
    afterSetMod(name, value) { }
    /**
     * Set/remove BEM class modification
     *
     * @param value - if null, mod will be removed
     */
    setMod(name, value, container) {
        name = name.toLowerCase();
        const oldValue = this.mods[name];
        if (oldValue === value) {
            return this;
        }
        const mod = `${this.componentName}_${name}_`, cl = (container || this.container).classList;
        if (oldValue != null) {
            cl.remove(`${mod}${oldValue.toString().toLowerCase()}`);
        }
        !(0,jodit_core_helpers_checker_is_void__WEBPACK_IMPORTED_MODULE_0__/* .isVoid */ .R)(value) &&
            value !== '' &&
            cl.add(`${mod}${value.toString().toLowerCase()}`);
        this.mods[name] = value;
        this.afterSetMod(name, value);
        return this;
    }
    /**
     * Get BEM class modification value
     */
    getMod(name) {
        var _a;
        return (_a = this.mods[name]) !== null && _a !== void 0 ? _a : null;
    }
}


/***/ }),

/***/ 92032:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   $n: function() { return /* binding */ Button; },
/* harmony export */   lD: function() { return /* binding */ UIButton; },
/* harmony export */   ue: function() { return /* binding */ UIButtonState; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(64567);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(69052);
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(98253);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(97369);
/* harmony import */ var jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(29780);
/* harmony import */ var jodit_core_ui_group_list__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(94070);
/* harmony import */ var jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(931);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */











const UIButtonState = () => ({
    size: 'middle',
    type: 'button',
    role: 'button',
    name: '',
    value: '',
    variant: 'initial',
    disabled: false,
    activated: false,
    icon: {
        name: 'empty',
        fill: '',
        iconURL: ''
    },
    tooltip: '',
    text: '',
    tabIndex: undefined
});
let UIButton = class UIButton extends jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_4__/* .UIElement */ .D {
    /** @override */
    className() {
        return 'UIButton';
    }
    /**
     * Set state
     */
    setState(state) {
        Object.assign(this.state, state);
        return this;
    }
    /**
     * DOM container for text content
     */
    get text() {
        const text = this.getElm('text');
        void 0;
        return text;
    }
    /**
     * DOM container for icon
     */
    get icon() {
        const icon = this.getElm('icon');
        void 0;
        return icon;
    }
    onChangeSize() {
        this.setMod('size', this.state.size);
    }
    onChangeType() {
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__.attr)(this.container, 'type', this.state.type);
    }
    onChangeRole() {
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__.attr)(this.container, 'role', this.state.role);
    }
    /**
     * Set size from a parent list
     */
    updateSize() {
        const pe = this.closest(jodit_core_ui_group_list__WEBPACK_IMPORTED_MODULE_5__/* .UIList */ .z);
        if (pe) {
            this.state.size = pe.buttonSize;
            return;
        }
    }
    onChangeStatus() {
        this.setMod('variant', this.state.variant);
    }
    onChangeText() {
        this.text.textContent = this.jodit.i18n(this.state.text);
    }
    onChangeTextSetMode() {
        this.setMod('text-icons', Boolean(this.state.text.trim().length));
    }
    onChangeDisabled() {
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__.attr)(this.container, 'disabled', this.state.disabled || null);
    }
    onChangeActivated() {
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__.attr)(this.container, 'aria-pressed', this.state.activated);
    }
    onChangeName() {
        this.container.classList.add(`${this.componentName}_${this.clearName(this.state.name)}`);
        this.name = this.state.name;
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__.attr)(this.container, 'data-ref', this.state.name);
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__.attr)(this.container, 'ref', this.state.name);
    }
    onChangeTooltip() {
        if (this.get('j.o.useNativeTooltip')) {
            (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__.attr)(this.container, 'title', this.state.tooltip);
        }
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__.attr)(this.container, 'aria-label', this.state.tooltip);
    }
    onChangeTabIndex() {
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__.attr)(this.container, 'tabindex', this.state.tabIndex);
    }
    onChangeIcon() {
        const textIcons = this.get('j.o.textIcons');
        if (textIcons === true ||
            ((0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_7__/* .isFunction */ .T)(textIcons) && textIcons(this.state.name))) {
            return;
        }
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.detach(this.icon);
        const iconElement = jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_6__/* .Icon */ .I.makeIcon(this.j, this.state.icon);
        iconElement && this.icon.appendChild(iconElement);
    }
    /**
     * Set focus on an element
     */
    focus() {
        this.container.focus();
    }
    /**
     * Element has focus
     */
    isFocused() {
        const { activeElement } = this.od;
        return Boolean(activeElement && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isOrContains(this.container, activeElement));
    }
    /** @override */
    createContainer() {
        const cn = this.componentName;
        const button = this.j.c.element('button', {
            class: cn,
            type: 'button',
            role: 'button',
            ariaPressed: false
        });
        const icon = this.j.c.span(cn + '__icon');
        const text = this.j.c.span(cn + '__text');
        button.appendChild(icon);
        button.appendChild(text);
        return button;
    }
    constructor(jodit, state) {
        super(jodit);
        /**
         * Marker for buttons
         */
        this.isButton = true;
        this.state = UIButtonState();
        this.actionHandlers = [];
        this.button = this.container;
        this.updateSize();
        this.onChangeSize();
        this.onChangeStatus();
        if (state) {
            this.hookStatus(jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_0__/* .STATUSES */ .f.ready, () => {
                this.setState(state);
            });
        }
    }
    destruct() {
        this.j.e.off(this.container);
        return super.destruct();
    }
    /**
     * Add action handler
     */
    onAction(callback) {
        this.actionHandlers.push(callback);
        return this;
    }
    /**
     * Fire all click handlers
     */
    __onActionFire(e) {
        e.buffer = {
            actionTrigger: this
        };
        this.actionHandlers.forEach(callback => callback.call(this, e));
    }
};
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.cache
], UIButton.prototype, "text", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.cache
], UIButton.prototype, "icon", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.watch)('state.size', { immediately: false })
], UIButton.prototype, "onChangeSize", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.watch)('state.type', { immediately: false })
], UIButton.prototype, "onChangeType", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.watch)('state.role', { immediately: false })
], UIButton.prototype, "onChangeRole", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.watch)('parentElement')
], UIButton.prototype, "updateSize", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.watch)('state.variant', { immediately: false })
], UIButton.prototype, "onChangeStatus", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.watch)('state.text', { immediately: false })
], UIButton.prototype, "onChangeText", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.watch)('state.text', { immediately: false })
], UIButton.prototype, "onChangeTextSetMode", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.watch)('state.disabled')
], UIButton.prototype, "onChangeDisabled", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.watch)('state.activated')
], UIButton.prototype, "onChangeActivated", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.watch)('state.name', { immediately: false })
], UIButton.prototype, "onChangeName", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.watch)('state.tooltip', { immediately: false })
], UIButton.prototype, "onChangeTooltip", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.watch)('state.tabIndex', { immediately: false })
], UIButton.prototype, "onChangeTabIndex", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.watch)('state.icon', { immediately: false })
], UIButton.prototype, "onChangeIcon", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.cacheHTML
], UIButton.prototype, "createContainer", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.watch)('button:click')
], UIButton.prototype, "__onActionFire", null);
UIButton = (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.component
], UIButton);

function Button(jodit, stateOrText, text, variant) {
    const button = new UIButton(jodit);
    button.state.tabIndex = jodit.o.allowTabNavigation ? 0 : -1;
    if ((0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_9__/* .isString */ .K)(stateOrText)) {
        button.state.icon.name = stateOrText;
        button.state.name = stateOrText;
        if (variant) {
            button.state.variant = variant;
        }
        if (text) {
            button.state.text = text;
        }
    }
    else {
        button.setState(stateOrText);
    }
    return button;
}


/***/ }),

/***/ 31202:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   s: function() { return /* binding */ UIButtonGroup; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(24767);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(28712);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var jodit_core_ui_button_button_button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(92032);
/* harmony import */ var jodit_core_ui_group_group__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6455);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */






let UIButtonGroup = class UIButtonGroup extends jodit_core_ui_group_group__WEBPACK_IMPORTED_MODULE_2__/* .UIGroup */ .U {
    /** @override */
    className() {
        return 'UIButtonGroup';
    }
    /** @override */
    render(options) {
        return `<div>
			<div class="&__label">~${options.label}~</div>
			<div class="&__options"></div>
		</div>`;
    }
    /** @override */
    appendChildToContainer(childContainer) {
        const options = this.getElm('options');
        void 0;
        options.appendChild(childContainer);
    }
    constructor(jodit, options = {
        radio: true
    }) {
        var _a, _b;
        super(jodit, (_a = options.options) === null || _a === void 0 ? void 0 : _a.map(opt => {
            const btn = new jodit_core_ui_button_button_button__WEBPACK_IMPORTED_MODULE_1__/* .UIButton */ .lD(jodit, {
                text: opt.text,
                value: opt.value,
                variant: 'primary'
            });
            btn.onAction(() => {
                this.select(opt.value);
            });
            return btn;
        }), options);
        this.options = options;
        this.select((_b = options.value) !== null && _b !== void 0 ? _b : 0);
    }
    select(indexOrValue) {
        var _a, _b;
        this.elements.forEach((elm, index) => {
            if (index === indexOrValue || elm.state.value === indexOrValue) {
                elm.state.activated = true;
            }
            else if (this.options.radio) {
                elm.state.activated = false;
            }
        });
        const result = this.elements
            .filter(elm => elm.state.activated)
            .map(elm => ({
            text: elm.state.text,
            value: elm.state.value
        }));
        this.jodit.e.fire(this, 'select', result);
        (_b = (_a = this.options).onChange) === null || _b === void 0 ? void 0 : _b.call(_a, result);
    }
};
UIButtonGroup = (0,tslib__WEBPACK_IMPORTED_MODULE_3__/* .__decorate */ .Cg)([
    jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_4__/* .component */ .s
], UIButtonGroup);



/***/ }),

/***/ 35265:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   $n: function() { return /* reexport safe */ _button_button__WEBPACK_IMPORTED_MODULE_0__.$n; },
/* harmony export */   SB: function() { return /* reexport safe */ _tooltip_tooltip__WEBPACK_IMPORTED_MODULE_2__.S; },
/* harmony export */   lD: function() { return /* reexport safe */ _button_button__WEBPACK_IMPORTED_MODULE_0__.lD; },
/* harmony export */   ss: function() { return /* reexport safe */ _group_group__WEBPACK_IMPORTED_MODULE_1__.s; },
/* harmony export */   ue: function() { return /* reexport safe */ _button_button__WEBPACK_IMPORTED_MODULE_0__.ue; }
/* harmony export */ });
/* harmony import */ var _button_button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(92032);
/* harmony import */ var _group_group__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(31202);
/* harmony import */ var _tooltip_tooltip__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(36434);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * [[include:core/ui/button/README.md]]
 * @packageDocumentation
 * @module ui/button
 */





/***/ }),

/***/ 36434:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   S: function() { return /* binding */ UITooltip; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(77753);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers_size_position__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(27594);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(97369);
/* harmony import */ var jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(29780);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
var UITooltip_1;









const WINDOW_EVENTS_ON_HIDE = [
    'scroll.tooltip',
    'joditCloseDialog',
    'mouseleave.tooltip'
];
const JODIT_EVENTS_ON_HIDE = [
    'escape.tooltip',
    'change.tooltip',
    'changePlace.tooltip',
    'afterOpenPopup.tooltip',
    'hidePopup.tooltip',
    'closeAllPopups.tooltip'
];
let UITooltip = UITooltip_1 = class UITooltip extends jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_5__/* .UIElement */ .D {
    className() {
        return 'UITooltip';
    }
    render() {
        return '<div><div class="&__content"></div></div>';
    }
    constructor(view) {
        super(view);
        this.__isOpened = false;
        this.__listenClose = false;
        this.__currentTarget = null;
        this.__delayShowTimeout = 0;
        this.__hideTimeout = 0;
        if (!view.o.textIcons &&
            view.o.showTooltip &&
            !view.o.useNativeTooltip) {
            view.hookStatus(jodit_core_component__WEBPACK_IMPORTED_MODULE_0__/* .STATUSES */ .f.ready, () => {
                // TODO Move it inside __show method. Now it is here because testcase failed with capturing
                (0,jodit_core_global__WEBPACK_IMPORTED_MODULE_3__/* .getContainer */ .My)(this.j, UITooltip_1).appendChild(this.container);
                view.e.on(view.container, 'mouseenter.tooltip', this.__onMouseEnter, {
                    capture: true
                });
            });
        }
    }
    __addListenersOnEnter() {
        if (this.__listenClose) {
            return;
        }
        this.__listenClose = true;
        const view = this.j;
        view.e
            .on(view.ow, WINDOW_EVENTS_ON_HIDE, this.__hide)
            .on(JODIT_EVENTS_ON_HIDE, this.__hide)
            .on(view.container, 'mouseleave.tooltip', this.__onMouseLeave, {
            capture: true
        });
    }
    __removeListenersOnLeave() {
        if (!this.__listenClose) {
            return;
        }
        this.__listenClose = false;
        const view = this.j;
        view.e
            .off(view.ow, WINDOW_EVENTS_ON_HIDE, this.__hide)
            .off(JODIT_EVENTS_ON_HIDE, this.__hide)
            .off(view.container, 'mouseleave.tooltip', this.__onMouseLeave);
    }
    __onMouseLeave(e) {
        if (this.__currentTarget === e.target) {
            this.__hideDelay();
            this.__currentTarget = null;
        }
    }
    __onMouseEnter(e) {
        if (!jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isHTMLElement(e.target)) {
            return;
        }
        const tooltip = (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__.attr)(e.target, 'aria-label');
        if (!tooltip) {
            return;
        }
        const disabled = Boolean((0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__.attr)(e.target, 'disabled'));
        if (disabled) {
            return;
        }
        const isOwn = e.target.className.includes('jodit');
        if (!isOwn) {
            return;
        }
        this.__currentTarget = e.target;
        const target = e.target;
        this.__open(() => {
            const pos = (0,jodit_core_helpers_size_position__WEBPACK_IMPORTED_MODULE_6__/* .position */ .G)(target);
            return {
                x: pos.left + pos.width / 2,
                y: pos.top + pos.height
            };
        }, tooltip);
    }
    __open(getPoint, content) {
        this.__addListenersOnEnter();
        this.__isOpened = true;
        this.j.async.clearTimeout(this.__hideTimeout);
        this.j.async.clearTimeout(this.__delayShowTimeout);
        const to = this.j.o.showTooltipDelay || this.j.defaultTimeout;
        if (!to) {
            this.__show(getPoint, content);
            return;
        }
        this.__delayShowTimeout = this.j.async.setTimeout(() => this.__show(getPoint, content), to);
    }
    __show(getPoint, content) {
        this.setMod('visible', true);
        this.getElm('content').innerHTML = content;
        const point = getPoint();
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__.css)(this.container, {
            left: point.x,
            top: point.y
        });
    }
    __hide() {
        this.j.async.clearTimeout(this.__delayShowTimeout);
        this.j.async.clearTimeout(this.__hideTimeout);
        this.__removeListenersOnLeave();
        if (this.__isOpened) {
            this.__isOpened = false;
            this.setMod('visible', false);
            this.getElm('content').innerHTML = '';
            (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__.css)(this.container, {
                left: -5000
            });
        }
    }
    __hideDelay() {
        this.j.async.clearTimeout(this.__delayShowTimeout);
        this.j.async.clearTimeout(this.__hideTimeout);
        if (!this.__isOpened) {
            return;
        }
        this.__hideTimeout = this.async.setTimeout(this.__hide, this.j.defaultTimeout);
    }
    destruct() {
        this.j.e.off(this.j.container, 'mouseenter.tooltip', this.__onMouseEnter);
        this.__hide();
        super.destruct();
    }
};
(0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], UITooltip.prototype, "__onMouseLeave", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], UITooltip.prototype, "__onMouseEnter", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], UITooltip.prototype, "__hide", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], UITooltip.prototype, "__hideDelay", null);
UITooltip = UITooltip_1 = (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.component
], UITooltip);



/***/ }),

/***/ 29780:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   D: function() { return /* binding */ UIElement; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(77753);
/* harmony import */ var jodit_core_decorators_derive_derive__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(1963);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(98253);
/* harmony import */ var jodit_core_traits_elms__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(87906);
/* harmony import */ var jodit_core_traits_mods__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(75758);
/* harmony import */ var jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(931);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
var UIElement_1;








let UIElement = UIElement_1 = class UIElement extends jodit_core_component__WEBPACK_IMPORTED_MODULE_0__/* .ViewComponent */ .vG {
    get parentElement() {
        return this.__parentElement;
    }
    set parentElement(parentElement) {
        this.__parentElement = parentElement;
        if (parentElement) {
            parentElement.hookStatus('beforeDestruct', () => this.destruct());
        }
        this.updateParentElement(this);
    }
    bubble(callback) {
        let parent = this.parentElement;
        while (parent) {
            callback(parent);
            parent = parent.parentElement;
        }
        return this;
    }
    updateParentElement(target) {
        var _a;
        (_a = this.__parentElement) === null || _a === void 0 ? void 0 : _a.updateParentElement(target);
        return this;
    }
    /** @override */
    get(chain, obj) {
        return super.get(chain, obj) || this.getElm(chain);
    }
    /**
     * Find match parent
     */
    closest(type) {
        const c = typeof type === 'object'
            ? (pe) => pe === type
            : (pe) => jodit_core_component__WEBPACK_IMPORTED_MODULE_0__/* .Component */ .uA.isInstanceOf(pe, type);
        let pe = this.__parentElement;
        while (pe) {
            if (c(pe)) {
                return pe;
            }
            if (!pe.parentElement && pe.container.parentElement) {
                pe = UIElement_1.closestElement(pe.container.parentElement, UIElement_1);
            }
            else {
                pe = pe.parentElement;
            }
        }
        return null;
    }
    /**
     * Find closest UIElement in DOM
     */
    static closestElement(node, type) {
        const elm = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.up(node, elm => {
            if (elm) {
                const { component } = elm;
                return component && jodit_core_component__WEBPACK_IMPORTED_MODULE_0__/* .Component */ .uA.isInstanceOf(component, type);
            }
            return false;
        });
        return elm ? elm === null || elm === void 0 ? void 0 : elm.component : null;
    }
    /**
     * Update UI from state
     */
    update() {
        // empty
    }
    /**
     * Append container to element
     */
    appendTo(element) {
        element.appendChild(this.container);
        return this;
    }
    /**
     * Valid name only with valid chars
     */
    clearName(name) {
        return name.replace(/[^a-zA-Z0-9]/g, '_');
    }
    /**
     * Method create only box
     */
    render(options) {
        return this.j.c.div(this.componentName);
    }
    /**
     * Create main HTML container
     */
    createContainer(options) {
        const result = this.render(options);
        if ((0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_4__/* .isString */ .K)(result)) {
            const elm = this.parseTemplate(result);
            elm.classList.add(this.componentName);
            return elm;
        }
        return result;
    }
    parseTemplate(result) {
        return this.j.c.fromHTML(result
            .replace(/\*([^*]+?)\*/g, (_, name) => jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_3__/* .Icon */ .I.get(name) || '')
            .replace(/&_/g, this.componentName + '_')
            .replace(/~([^~]+?)~/g, (_, s) => this.i18n(s)));
    }
    /** @override */
    constructor(jodit, options) {
        super(jodit);
        this.name = '';
        this.__parentElement = null;
        this.mods = {};
        this.container = this.createContainer(options);
        Object.defineProperty(this.container, 'component', {
            value: this,
            configurable: true
        });
    }
    /** @override */
    destruct() {
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.safeRemove(this.container);
        this.parentElement = null;
        return super.destruct();
    }
};
UIElement = UIElement_1 = (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators_derive_derive__WEBPACK_IMPORTED_MODULE_6__/* .derive */ .C)(jodit_core_traits_mods__WEBPACK_IMPORTED_MODULE_7__/* .Mods */ .K, jodit_core_traits_elms__WEBPACK_IMPORTED_MODULE_2__/* .Elms */ .O)
], UIElement);



/***/ }),

/***/ 68752:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Y: function() { return /* binding */ UIBlock; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(24767);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(97369);
/* harmony import */ var jodit_core_ui_group_group__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6455);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */





let UIBlock = class UIBlock extends jodit_core_ui_group_group__WEBPACK_IMPORTED_MODULE_1__/* .UIGroup */ .U {
    /** @override */
    className() {
        return 'UIBlock';
    }
    constructor(jodit, elements, options = {
        align: 'left'
    }) {
        super(jodit, elements);
        this.options = options;
        this.setMod('align', this.options.align || 'left');
        this.setMod('width', this.options.width || '');
        this.options.mod && this.setMod(this.options.mod, true);
        this.options.className &&
            this.container.classList.add(this.options.className);
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_0__.attr)(this.container, 'data-ref', options.ref);
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_0__.attr)(this.container, 'ref', options.ref);
    }
};
UIBlock = (0,tslib__WEBPACK_IMPORTED_MODULE_2__/* .__decorate */ .Cg)([
    jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_3__/* .component */ .s
], UIBlock);



/***/ }),

/***/ 28709:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   X: function() { return /* binding */ UIForm; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_component_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(37474);
/* harmony import */ var jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(24767);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(97369);
/* harmony import */ var jodit_core_ui_form_inputs_input_input__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(69198);
/* harmony import */ var jodit_core_ui_form_inputs_select_select__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(1540);
/* harmony import */ var jodit_core_ui_group_group__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(6455);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */







let UIForm = class UIForm extends jodit_core_ui_group_group__WEBPACK_IMPORTED_MODULE_4__/* .UIGroup */ .U {
    /** @override */
    className() {
        return 'UIForm';
    }
    submit() {
        this.j.e.fire(this.container, 'submit');
    }
    validate() {
        const inputs = this.allChildren.filter(elm => jodit_core_component_component__WEBPACK_IMPORTED_MODULE_0__/* .Component */ .u.isInstanceOf(elm, jodit_core_ui_form_inputs_input_input__WEBPACK_IMPORTED_MODULE_2__/* .UIInput */ .t));
        for (const input of inputs) {
            if (!input.validate()) {
                return false;
            }
        }
        const selects = this.allChildren.filter(elm => jodit_core_component_component__WEBPACK_IMPORTED_MODULE_0__/* .Component */ .u.isInstanceOf(elm, jodit_core_ui_form_inputs_select_select__WEBPACK_IMPORTED_MODULE_3__/* .UISelect */ .$));
        for (const select of selects) {
            if (!select.validate()) {
                return false;
            }
        }
        return true;
    }
    onSubmit(handler) {
        this.j.e.on(this.container, 'submit', () => {
            const inputs = this.allChildren.filter(elm => jodit_core_component_component__WEBPACK_IMPORTED_MODULE_0__/* .Component */ .u.isInstanceOf(elm, jodit_core_ui_form_inputs_input_input__WEBPACK_IMPORTED_MODULE_2__/* .UIInput */ .t));
            if (!this.validate()) {
                return false;
            }
            handler(inputs.reduce((res, item) => {
                res[item.state.name] = item.value;
                return res;
            }, {}));
            return false;
        });
        return this;
    }
    /** @override */
    createContainer() {
        const form = this.j.c.element('form');
        form.classList.add(this.componentName);
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.attr)(form, 'dir', this.j.o.direction || 'auto');
        return form;
    }
    constructor(...args) {
        var _a, _b;
        super(...args);
        if ((_a = this.options) === null || _a === void 0 ? void 0 : _a.className) {
            this.container.classList.add((_b = this.options) === null || _b === void 0 ? void 0 : _b.className);
        }
    }
};
UIForm = (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__decorate */ .Cg)([
    jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_6__/* .component */ .s
], UIForm);



/***/ }),

/***/ 20703:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   $6: function() { return /* reexport safe */ _inputs__WEBPACK_IMPORTED_MODULE_2__.$6; },
/* harmony export */   F0: function() { return /* reexport safe */ _inputs__WEBPACK_IMPORTED_MODULE_2__.F0; },
/* harmony export */   XV: function() { return /* reexport safe */ _form__WEBPACK_IMPORTED_MODULE_1__.X; },
/* harmony export */   Yh: function() { return /* reexport safe */ _block_block__WEBPACK_IMPORTED_MODULE_0__.Y; },
/* harmony export */   cY: function() { return /* reexport safe */ _inputs__WEBPACK_IMPORTED_MODULE_2__.cY; },
/* harmony export */   nE: function() { return /* reexport safe */ _inputs__WEBPACK_IMPORTED_MODULE_2__.nE; },
/* harmony export */   tS: function() { return /* reexport safe */ _inputs__WEBPACK_IMPORTED_MODULE_2__.tS; }
/* harmony export */ });
/* harmony import */ var _block_block__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(68752);
/* harmony import */ var _form__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(28709);
/* harmony import */ var _inputs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(47165);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module ui/form
 */





/***/ }),

/***/ 5454:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   F: function() { return /* binding */ UITextArea; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(24767);
/* harmony import */ var jodit_core_ui_form_inputs_input_input__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(69198);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
var UITextArea_1;





let UITextArea = UITextArea_1 = class UITextArea extends jodit_core_ui_form_inputs_input_input__WEBPACK_IMPORTED_MODULE_1__/* .UIInput */ .t {
    /** @override */
    className() {
        return 'UITextArea';
    }
    createNativeInput(options) {
        return this.j.create.element('textarea');
    }
    constructor(jodit, state) {
        super(jodit, state);
        /** @override */
        this.state = Object.assign({}, UITextArea_1.defaultState);
        Object.assign(this.state, state);
        if (this.state.resizable === false) {
            this.nativeInput.style.resize = 'none';
        }
    }
    onChangeStateSize() {
        const { size, resizable } = this.state;
        this.nativeInput.style.resize = resizable ? 'auto' : 'none';
        this.nativeInput.rows = size !== null && size !== void 0 ? size : 5;
    }
};
/** @override */
UITextArea.defaultState = Object.assign(Object.assign({}, jodit_core_ui_form_inputs_input_input__WEBPACK_IMPORTED_MODULE_1__/* .UIInput */ .t.defaultState), { size: 5, resizable: true });
(0,tslib__WEBPACK_IMPORTED_MODULE_2__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)(['state.size', 'state.resizable'])
], UITextArea.prototype, "onChangeStateSize", null);
UITextArea = UITextArea_1 = (0,tslib__WEBPACK_IMPORTED_MODULE_2__/* .__decorate */ .Cg)([
    jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_3__/* .component */ .s
], UITextArea);



/***/ }),

/***/ 3006:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   c: function() { return /* binding */ UICheckbox; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_ui_form_inputs_input_input__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(69198);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
var UICheckbox_1;





let UICheckbox = UICheckbox_1 = class UICheckbox extends jodit_core_ui_form_inputs_input_input__WEBPACK_IMPORTED_MODULE_2__/* .UIInput */ .t {
    /** @override */
    className() {
        return 'UICheckbox';
    }
    /** @override */
    render() {
        return this.j.c.element('label', {
            className: this.componentName
        });
    }
    /** @override **/
    constructor(jodit, options) {
        super(jodit, Object.assign(Object.assign({}, options), { type: 'checkbox' }));
        /** @override */
        this.state = Object.assign({}, UICheckbox_1.defaultState);
        Object.assign(this.state, options);
    }
    onChangeChecked() {
        this.value = this.state.checked.toString();
        this.nativeInput.checked = this.state.checked;
        this.setMod('checked', this.state.checked);
    }
    onChangeNativeCheckBox() {
        this.state.checked = this.nativeInput.checked;
    }
    onChangeSwitch() {
        this.setMod('switch', this.state.switch);
        let slider = this.getElm('switch-slider');
        if (this.state.switch) {
            if (!slider) {
                slider = this.j.c.div(this.getFullElName('switch-slider'));
            }
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.after(this.nativeInput, slider);
        }
        else {
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.safeRemove(slider);
        }
    }
};
/** @override */
UICheckbox.defaultState = Object.assign(Object.assign({}, jodit_core_ui_form_inputs_input_input__WEBPACK_IMPORTED_MODULE_2__/* .UIInput */ .t.defaultState), { checked: false, switch: false });
(0,tslib__WEBPACK_IMPORTED_MODULE_3__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)('state.checked'),
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.hook)('ready')
], UICheckbox.prototype, "onChangeChecked", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_3__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)('nativeInput:change')
], UICheckbox.prototype, "onChangeNativeCheckBox", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_3__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)('state.switch'),
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.hook)('ready')
], UICheckbox.prototype, "onChangeSwitch", null);
UICheckbox = UICheckbox_1 = (0,tslib__WEBPACK_IMPORTED_MODULE_3__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.component
], UICheckbox);



/***/ }),

/***/ 47964:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   n: function() { return /* binding */ UIFileInput; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(24767);
/* harmony import */ var jodit_core_ui_button_button_button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(92032);
/* harmony import */ var jodit_core_ui_form_inputs_input_input__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(69198);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */





let UIFileInput = class UIFileInput extends jodit_core_ui_form_inputs_input_input__WEBPACK_IMPORTED_MODULE_1__/* .UIInput */ .t {
    /** @override */
    className() {
        return 'UIFileInput';
    }
    createContainer(options) {
        this.button = new jodit_core_ui_button_button_button__WEBPACK_IMPORTED_MODULE_0__/* .UIButton */ .lD(this.j, {
            icon: {
                name: 'plus'
            }
        });
        const { container } = this.button;
        if (!this.nativeInput) {
            this.nativeInput = this.createNativeInput(options);
        }
        const { nativeInput } = this;
        nativeInput.classList.add(this.getFullElName('input'));
        container.classList.add(this.componentName);
        container.appendChild(nativeInput);
        return container;
    }
    createNativeInput(options) {
        return this.j.create.fromHTML(`<input
			type="file"
			accept="${options.onlyImages ? 'image/*' : '*'}"
			tabindex="-1"
			dir="auto"
			multiple=""
		/>`);
    }
    constructor(jodit, options) {
        super(jodit, Object.assign({ type: 'file' }, options));
        this.state = Object.assign(Object.assign({}, jodit_core_ui_form_inputs_input_input__WEBPACK_IMPORTED_MODULE_1__/* .UIInput */ .t.defaultState), { type: 'file', onlyImages: true });
    }
};
UIFileInput = (0,tslib__WEBPACK_IMPORTED_MODULE_2__/* .__decorate */ .Cg)([
    jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_3__/* .component */ .s
], UIFileInput);



/***/ }),

/***/ 47165:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   $6: function() { return /* reexport safe */ _select_select__WEBPACK_IMPORTED_MODULE_4__.$; },
/* harmony export */   F0: function() { return /* reexport safe */ _area_area__WEBPACK_IMPORTED_MODULE_0__.F; },
/* harmony export */   cY: function() { return /* reexport safe */ _checkbox_checkbox__WEBPACK_IMPORTED_MODULE_1__.c; },
/* harmony export */   nE: function() { return /* reexport safe */ _file_file__WEBPACK_IMPORTED_MODULE_2__.n; },
/* harmony export */   tS: function() { return /* reexport safe */ _input_input__WEBPACK_IMPORTED_MODULE_3__.t; }
/* harmony export */ });
/* harmony import */ var _area_area__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5454);
/* harmony import */ var _checkbox_checkbox__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3006);
/* harmony import */ var _file_file__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(47964);
/* harmony import */ var _input_input__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(69198);
/* harmony import */ var _select_select__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(1540);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module ui/form
 */







/***/ }),

/***/ 69198:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   t: function() { return /* binding */ UIInput; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_array_to_array__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(42448);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(97369);
/* harmony import */ var jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(29780);
/* harmony import */ var jodit_core_ui_form_validators__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(84103);
/* harmony import */ var jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(931);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
var UIInput_1;









let UIInput = UIInput_1 = class UIInput extends jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_4__/* .UIElement */ .D {
    /** @override */
    className() {
        return 'UIInput';
    }
    onChangeClear() {
        if (this.state.clearButton) {
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.after(this.nativeInput, this.clearButton);
        }
        else {
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.safeRemove(this.clearButton);
        }
    }
    onChangeClassName(ignore, oldClassName) {
        oldClassName && this.container.classList.remove(oldClassName);
        this.state.className &&
            this.container.classList.add(this.state.className);
    }
    onChangeState() {
        this.name = this.state.name;
        const input = this.nativeInput, { name, icon, type, ref, required, placeholder, autocomplete, label } = this.state;
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__.attr)(input, 'name', name);
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__.attr)(input, 'type', type);
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__.attr)(input, 'data-ref', ref || name);
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__.attr)(input, 'ref', ref || name);
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__.attr)(input, 'required', required || null);
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__.attr)(input, 'autocomplete', !autocomplete ? 'off' : null);
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__.attr)(input, 'placeholder', placeholder ? this.j.i18n(placeholder) : '');
        if (icon && jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_6__/* .Icon */ .I.exists(icon)) {
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.before(input, this.icon);
            this.icon.innerHTML = jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_6__/* .Icon */ .I.get(icon);
        }
        else {
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.safeRemove(this.icon);
        }
        if (label) {
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.before(this.wrapper, this.label);
            this.label.innerText = this.j.i18n(label);
        }
        else {
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.safeRemove(this.label);
        }
        this.updateValidators();
    }
    updateValidators() {
        var _a;
        this.validators.clear();
        if (this.state.required) {
            this.validators.add(jodit_core_ui_form_validators__WEBPACK_IMPORTED_MODULE_5__/* .inputValidators.required */ .O.required);
        }
        (_a = this.state.validators) === null || _a === void 0 ? void 0 : _a.forEach(name => {
            const validator = jodit_core_ui_form_validators__WEBPACK_IMPORTED_MODULE_5__/* .inputValidators */ .O[name];
            validator && this.validators.add(validator);
        });
    }
    set error(value) {
        this.setMod('has-error', Boolean(value));
        if (!value) {
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.safeRemove(this.__errorBox);
        }
        else {
            this.__errorBox.innerText = this.j.i18n(value, this.j.i18n(this.state.label || ''));
            this.container.appendChild(this.__errorBox);
        }
    }
    get value() {
        return this.nativeInput.value;
    }
    set value(value) {
        if (this.value !== value) {
            this.nativeInput.value = value;
            this.onChangeValue();
        }
    }
    /**
     * Call on every state value changed
     */
    onChangeStateValue() {
        const value = this.state.value.toString();
        if (value !== this.value) {
            this.value = value;
        }
    }
    /**
     * Call on every native value changed
     */
    onChangeValue() {
        var _a, _b;
        const { value } = this;
        if (this.state.value !== value) {
            this.state.value = value;
            this.j.e.fire(this, 'change', value);
            (_b = (_a = this.state).onChange) === null || _b === void 0 ? void 0 : _b.call(_a, value);
        }
    }
    validate() {
        this.error = '';
        return (0,jodit_core_helpers_array_to_array__WEBPACK_IMPORTED_MODULE_2__/* .toArray */ .$)(this.validators).every(validator => validator(this));
    }
    /** @override **/
    createContainer(options) {
        const container = super.createContainer();
        this.wrapper = this.j.c.div(this.getFullElName('wrapper'));
        if (!this.nativeInput) {
            this.nativeInput = this.createNativeInput();
        }
        const { nativeInput } = this;
        nativeInput.classList.add(this.getFullElName('input'));
        this.wrapper.appendChild(nativeInput);
        container.appendChild(this.wrapper);
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__.attr)(nativeInput, 'dir', this.j.o.direction || 'auto');
        return container;
    }
    /**
     * Create native input element
     */
    createNativeInput(options) {
        return this.j.create.element('input');
    }
    /** @override **/
    constructor(jodit, options) {
        super(jodit, options);
        this.label = this.j.c.span(this.getFullElName('label'));
        this.icon = this.j.c.span(this.getFullElName('icon'));
        this.clearButton = this.j.c.span(this.getFullElName('clear'), jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_6__/* .Icon */ .I.get('cancel'));
        this.state = Object.assign({}, UIInput_1.defaultState);
        this.__errorBox = this.j.c.span(this.getFullElName('error'));
        this.validators = new Set([]);
        if ((options === null || options === void 0 ? void 0 : options.value) !== undefined) {
            options.value = options.value.toString();
        }
        Object.assign(this.state, options);
        if (this.state.clearButton !== undefined) {
            this.j.e
                .on(this.clearButton, 'click', (e) => {
                e.preventDefault();
                this.nativeInput.value = '';
                this.j.e.fire(this.nativeInput, 'input');
                this.focus();
            })
                .on(this.nativeInput, 'input', () => {
                this.state.clearButton = Boolean(this.value.length);
            });
            this.state.clearButton = Boolean(this.value.length);
        }
        this.j.e
            .on(this.nativeInput, 'focus blur', () => {
            this.onChangeFocus();
        })
            .on(this.nativeInput, 'input change', this.onChangeValue);
        this.onChangeState();
        this.onChangeClassName();
        this.onChangeStateValue();
    }
    focus() {
        this.nativeInput.focus();
    }
    get isFocused() {
        return this.nativeInput === this.j.od.activeElement;
    }
    /**
     * Set `focused` mod on change focus
     */
    onChangeFocus() {
        this.setMod('focused', this.isFocused);
    }
};
UIInput.defaultState = {
    className: '',
    autocomplete: true,
    name: '',
    value: '',
    icon: '',
    label: '',
    ref: '',
    type: 'text',
    placeholder: '',
    required: false,
    validators: []
};
(0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)('state.clearButton')
], UIInput.prototype, "onChangeClear", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)('state.className')
], UIInput.prototype, "onChangeClassName", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)([
        'state.name',
        'state.type',
        'state.label',
        'state.placeholder',
        'state.autocomplete',
        'state.icon'
    ], { immediately: false }),
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.debounce)()
], UIInput.prototype, "onChangeState", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)('state.value')
], UIInput.prototype, "onChangeStateValue", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.autobind
], UIInput.prototype, "onChangeValue", null);
UIInput = UIInput_1 = (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.component
], UIInput);



/***/ }),

/***/ 1540:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   $: function() { return /* binding */ UISelect; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(24767);
/* harmony import */ var jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(26150);
/* harmony import */ var jodit_core_ui_form_inputs_input_input__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(69198);
/* harmony import */ var jodit_core_ui_form_validators__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(84103);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
var UISelect_1;






let UISelect = UISelect_1 = class UISelect extends jodit_core_ui_form_inputs_input_input__WEBPACK_IMPORTED_MODULE_1__/* .UIInput */ .t {
    /** @override */
    className() {
        return 'UISelect';
    }
    /** @override **/
    createContainer(state) {
        var _a;
        const container = super.createContainer(state);
        const { j } = this, { nativeInput } = this;
        const opt = () => j.create.element('option');
        if (state.placeholder !== undefined) {
            const option = opt();
            option.value = '';
            option.text = j.i18n(state.placeholder);
            nativeInput.add(option);
        }
        (_a = state.options) === null || _a === void 0 ? void 0 : _a.forEach(element => {
            const option = opt();
            option.value = element.value.toString();
            option.text = j.i18n(element.text);
            nativeInput.add(option);
        });
        if (state.size && state.size > 0) {
            (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_0__/* .attr */ .C)(nativeInput, 'size', state.size);
        }
        if (state.multiple) {
            (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_0__/* .attr */ .C)(nativeInput, 'multiple', '');
        }
        return container;
    }
    /** @override **/
    createNativeInput() {
        return this.j.create.element('select');
    }
    /** @override **/
    updateValidators() {
        super.updateValidators();
        if (this.state.required) {
            this.validators.delete(jodit_core_ui_form_validators__WEBPACK_IMPORTED_MODULE_2__/* .inputValidators.required */ .O.required);
            this.validators.add(jodit_core_ui_form_validators__WEBPACK_IMPORTED_MODULE_2__/* .selectValidators.required */ .U.m);
        }
    }
    constructor(jodit, state) {
        super(jodit, state);
        /** @override */
        this.state = Object.assign({}, UISelect_1.defaultState);
        Object.assign(this.state, state);
    }
};
/** @override */
UISelect.defaultState = Object.assign(Object.assign({}, jodit_core_ui_form_inputs_input_input__WEBPACK_IMPORTED_MODULE_1__/* .UIInput */ .t.defaultState), { options: [], size: 1, multiple: false });
UISelect = UISelect_1 = (0,tslib__WEBPACK_IMPORTED_MODULE_3__/* .__decorate */ .Cg)([
    jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_4__/* .component */ .s
], UISelect);



/***/ }),

/***/ 84103:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   O: function() { return /* reexport module object */ _input__WEBPACK_IMPORTED_MODULE_0__; },
/* harmony export */   U: function() { return /* reexport module object */ _select__WEBPACK_IMPORTED_MODULE_1__; }
/* harmony export */ });
/* harmony import */ var _input__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(51271);
/* harmony import */ var _select__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(36795);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module ui/form
 */




/***/ }),

/***/ 51271:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   required: function() { return /* binding */ required; },
/* harmony export */   url: function() { return /* binding */ url; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_url__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6939);
/* harmony import */ var jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(59101);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


/**
 * Input is required
 */
const required = function (input) {
    if (!(0,jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_0__/* .trim */ .Bq)(input.value).length) {
        input.error = 'Please fill out this field';
        return false;
    }
    return true;
};
/**
 * Input value should be valid URL
 */
const url = function (input) {
    if (!(0,jodit_core_helpers_checker_is_url__WEBPACK_IMPORTED_MODULE_1__/* .isURL */ .m)((0,jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_0__/* .trim */ .Bq)(input.value))) {
        input.error = 'Please enter a web address';
        return false;
    }
    return true;
};


/***/ }),

/***/ 36795:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   m: function() { return /* binding */ required; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(59101);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

/**
 * Select is required
 */
const required = function (select) {
    if (!(0,jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_0__/* .trim */ .Bq)(select.value).length) {
        select.error = 'Please fill out this field';
        return false;
    }
    return true;
};


/***/ }),

/***/ 6455:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   U: function() { return /* binding */ UIGroup; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_component_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(37474);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(28712);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(29780);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
var UIGroup_1;








let UIGroup = UIGroup_1 = class UIGroup extends jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_5__/* .UIElement */ .D {
    className() {
        return 'UIGroup';
    }
    /**
     * All group children
     */
    get allChildren() {
        const result = [];
        const stack = [
            ...this.elements
        ];
        while (stack.length) {
            const elm = stack.shift();
            if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isArray)(elm)) {
                stack.push(...elm);
            }
            else if (jodit_core_component_component__WEBPACK_IMPORTED_MODULE_0__/* .Component */ .u.isInstanceOf(elm, UIGroup_1)) {
                stack.push(...elm.elements);
            }
            else {
                elm && result.push(elm);
            }
        }
        return result;
    }
    /**
     * Update all children
     */
    update() {
        this.elements.forEach(elm => elm.update());
        this.setMod('size', this.buttonSize);
    }
    /**
     * Append new element into group
     */
    append(elm, distElement) {
        if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isArray)(elm)) {
            elm.forEach(item => this.append(item, distElement));
            return this;
        }
        this.elements.push(elm);
        if (elm.name) {
            elm.container.classList.add(this.getFullElName(elm.name));
        }
        if (distElement) {
            const distElm = this.getElm(distElement);
            void 0;
            distElm.appendChild(elm.container);
        }
        else {
            this.appendChildToContainer(elm.container);
        }
        elm.parentElement = this;
        return this;
    }
    /** @override */
    afterSetMod(name, value) {
        if (this.syncMod) {
            this.elements.forEach(elm => elm.setMod(name, value));
        }
    }
    /**
     * Allow set another container for the box of all children
     */
    appendChildToContainer(childContainer) {
        this.container.appendChild(childContainer);
    }
    /**
     * Remove element from group
     */
    remove(elm) {
        const index = this.elements.indexOf(elm);
        if (index !== -1) {
            this.elements.splice(index, 1);
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.safeRemove(elm.container);
            elm.parentElement = null;
        }
        return this;
    }
    /**
     * Clear group
     */
    clear() {
        this.elements.forEach(elm => elm.destruct());
        this.elements.length = 0;
        return this;
    }
    /**
     * @param elements - Items of group
     */
    constructor(jodit, elements, options) {
        super(jodit, options);
        this.options = options;
        /**
         * Synchronize mods to all children
         */
        this.syncMod = false;
        this.elements = [];
        this.buttonSize = 'middle';
        elements === null || elements === void 0 ? void 0 : elements.forEach(elm => elm && this.append(elm));
        if (options === null || options === void 0 ? void 0 : options.name) {
            this.name = options.name;
        }
    }
    /** @override */
    destruct() {
        this.clear();
        return super.destruct();
    }
};
(0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.watch)('buttonSize')
], UIGroup.prototype, "update", null);
UIGroup = UIGroup_1 = (0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.component
], UIGroup);



/***/ }),

/***/ 29012:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CP: function() { return /* reexport safe */ _separator__WEBPACK_IMPORTED_MODULE_2__.C; },
/* harmony export */   Ue: function() { return /* reexport safe */ _group__WEBPACK_IMPORTED_MODULE_0__.U; },
/* harmony export */   bk: function() { return /* reexport safe */ _spacer__WEBPACK_IMPORTED_MODULE_3__.b; },
/* harmony export */   z4: function() { return /* reexport safe */ _list__WEBPACK_IMPORTED_MODULE_1__.z; }
/* harmony export */ });
/* harmony import */ var _group__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6455);
/* harmony import */ var _list__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(94070);
/* harmony import */ var _separator__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(86283);
/* harmony import */ var _spacer__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(13642);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module ui/group
 */






/***/ }),

/***/ 94070:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   z: function() { return /* binding */ UIList; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_component_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(37474);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_helpers_array_split_array__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(42589);
/* harmony import */ var jodit_core_ui_button_button_button__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(92032);
/* harmony import */ var jodit_core_ui_group_group__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(6455);
/* harmony import */ var jodit_core_ui_group_separator__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(86283);
/* harmony import */ var jodit_core_ui_group_spacer__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(13642);
/* harmony import */ var jodit_core_ui_helpers_buttons__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(39611);
/* harmony import */ var jodit_core_ui_helpers_get_control_type__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(57023);
/* harmony import */ var jodit_core_ui_helpers_get_strong_control_types__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(37424);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */












let UIList = class UIList extends jodit_core_ui_group_group__WEBPACK_IMPORTED_MODULE_3__/* .UIGroup */ .U {
    /** @override */
    className() {
        return 'UIList';
    }
    __onChangeMode() {
        this.setMod('mode', this.mode);
    }
    constructor(jodit) {
        super(jodit);
        this.mode = 'horizontal';
        this.removeButtons = [];
    }
    /**
     * Make new group and append it in list of elements
     */
    makeGroup() {
        return new jodit_core_ui_group_group__WEBPACK_IMPORTED_MODULE_3__/* .UIGroup */ .U(this.jodit);
    }
    /**
     * All buttons from list
     */
    get buttons() {
        return this.allChildren.filter(elm => jodit_core_component_component__WEBPACK_IMPORTED_MODULE_0__/* .Component */ .u.isInstanceOf(elm, jodit_core_ui_button_button_button__WEBPACK_IMPORTED_MODULE_2__/* .UIButton */ .lD));
    }
    /**
     * Helper for getting full plain button list
     */
    getButtonsNames() {
        return this.buttons
            .map(a => (a instanceof jodit_core_ui_button_button_button__WEBPACK_IMPORTED_MODULE_2__/* .UIButton */ .lD && a.state.name) || '')
            .filter(a => a !== '');
    }
    setRemoveButtons(removeButtons) {
        this.removeButtons = removeButtons || [];
        return this;
    }
    build(items, target = null) {
        items = (0,jodit_core_helpers_array_split_array__WEBPACK_IMPORTED_MODULE_8__/* .splitArray */ .u)(items);
        this.clear();
        let lastBtnSeparator = false;
        let line = this.makeGroup();
        this.append(line);
        line.setMod('line', true);
        let group;
        const addButton = (control) => {
            let elm = null;
            switch (control.name) {
                case '\n':
                    line = this.makeGroup();
                    line.setMod('line', true);
                    group = this.makeGroup();
                    line.append(group);
                    this.append(line);
                    break;
                case '|':
                    if (!lastBtnSeparator) {
                        lastBtnSeparator = true;
                        elm = new jodit_core_ui_group_separator__WEBPACK_IMPORTED_MODULE_4__/* .UISeparator */ .C(this.j);
                    }
                    break;
                case '---': {
                    group.setMod('before-spacer', true);
                    const space = new jodit_core_ui_group_spacer__WEBPACK_IMPORTED_MODULE_5__/* .UISpacer */ .b(this.j);
                    line.append(space);
                    group = this.makeGroup();
                    line.append(group);
                    lastBtnSeparator = false;
                    break;
                }
                default:
                    lastBtnSeparator = false;
                    switch (control.component) {
                        case 'select':
                            elm = this.makeSelect(control, target);
                            break;
                        case 'button':
                        default:
                            elm = this.makeButton(control, target);
                    }
            }
            if (elm) {
                if (!group) {
                    group = this.makeGroup();
                    line.append(group);
                }
                group.append(elm);
            }
        };
        const isNotRemoved = (b) => {
            var _a;
            return !this.removeButtons.includes(b.name) &&
                (!b.isVisible || ((_a = b.isVisible) === null || _a === void 0 ? void 0 : _a.call(b, this.j, b)));
        };
        items.forEach(item => {
            if ((0,jodit_core_ui_helpers_buttons__WEBPACK_IMPORTED_MODULE_9__/* .isButtonGroup */ .i)(item)) {
                const buttons = item.buttons.filter(b => b);
                if (buttons.length) {
                    group = this.makeGroup();
                    group.setMod('separated', true).setMod('group', item.group);
                    line.append(group);
                    (0,jodit_core_ui_helpers_get_strong_control_types__WEBPACK_IMPORTED_MODULE_7__/* .getStrongControlTypes */ .Q)(buttons, this.j.o.controls)
                        .filter(isNotRemoved)
                        .forEach(addButton);
                }
            }
            else {
                if (!group) {
                    group = this.makeGroup();
                    line.append(group);
                }
                const control = (0,jodit_core_ui_helpers_get_control_type__WEBPACK_IMPORTED_MODULE_6__/* .getControlType */ .U)(item, this.j.o.controls);
                isNotRemoved(control) && addButton(control);
            }
        });
        this.update();
        return this;
    }
    makeSelect(control, target) {
        throw new Error('Not implemented behaviour');
    }
    /**
     * Create button instance
     */
    makeButton(control, target) {
        return new jodit_core_ui_button_button_button__WEBPACK_IMPORTED_MODULE_2__/* .UIButton */ .lD(this.j, {
            name: control.name
        });
    }
};
(0,tslib__WEBPACK_IMPORTED_MODULE_10__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.watch)('mode'),
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.hook)('ready')
], UIList.prototype, "__onChangeMode", null);
UIList = (0,tslib__WEBPACK_IMPORTED_MODULE_10__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.component
], UIList);



/***/ }),

/***/ 86283:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   C: function() { return /* binding */ UISeparator; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(24767);
/* harmony import */ var jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(29780);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

/**
 * @module ui/group
 */


let UISeparator = class UISeparator extends jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_0__/* .UIElement */ .D {
    className() {
        return 'UISeparator';
    }
};
UISeparator = (0,tslib__WEBPACK_IMPORTED_MODULE_1__/* .__decorate */ .Cg)([
    jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_2__/* .component */ .s
], UISeparator);



/***/ }),

/***/ 13642:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   b: function() { return /* binding */ UISpacer; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(24767);
/* harmony import */ var jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(29780);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

/**
 * @module ui/group
 */


let UISpacer = class UISpacer extends jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_0__/* .UIElement */ .D {
    className() {
        return 'UISpacer';
    }
};
UISpacer = (0,tslib__WEBPACK_IMPORTED_MODULE_1__/* .__decorate */ .Cg)([
    jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_2__/* .component */ .s
], UISpacer);



/***/ }),

/***/ 39611:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   V: function() { return /* binding */ flatButtonsSet; },
/* harmony export */   i: function() { return /* binding */ isButtonGroup; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(37923);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

/**
 * @private
 */
const isButtonGroup = (item) => {
    return (0,jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_0__/* .isArray */ .c)(item.buttons);
};
/**
 * @private
 */
function flatButtonsSet(buttons, jodit) {
    const groups = jodit.getRegisteredButtonGroups();
    return new Set(buttons.reduce((acc, item) => {
        var _a;
        if (isButtonGroup(item)) {
            acc = acc.concat([
                ...item.buttons,
                ...((_a = groups[item.group]) !== null && _a !== void 0 ? _a : [])
            ]);
        }
        else {
            acc.push(item);
        }
        return acc;
    }, []));
}


/***/ }),

/***/ 57023:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   U: function() { return /* binding */ getControlType; },
/* harmony export */   x: function() { return /* binding */ findControlType; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(65147);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(36115);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


/**
 * Get control for button name
 * @private
 */
function getControlType(button, controls) {
    let buttonControl;
    if (!controls) {
        controls = jodit_config__WEBPACK_IMPORTED_MODULE_1__/* .Config */ .T.defaultOptions.controls;
    }
    if (!(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.isString)(button)) {
        buttonControl = Object.assign({ name: 'empty' }, (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.ConfigFlatten)(button));
        if (controls[buttonControl.name] !== undefined) {
            buttonControl = Object.assign(Object.assign({}, (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.ConfigFlatten)(controls[buttonControl.name])), (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.ConfigFlatten)(buttonControl));
        }
    }
    else {
        buttonControl = findControlType(button, controls) || {
            name: button,
            command: button,
            tooltip: button
        };
    }
    return buttonControl;
}
/**
 * @private
 */
function findControlType(path, controls) {
    // eslint-disable-next-line prefer-const
    let [namespaceOrKey, key] = path.split(/\./);
    let store = controls;
    if (key != null) {
        if (controls[namespaceOrKey] !== undefined) {
            store = controls[namespaceOrKey];
        }
    }
    else {
        key = namespaceOrKey;
    }
    // const list = store[key]?.list;
    return store[key]
        ? Object.assign({ name: key }, (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.ConfigFlatten)(store[key])
        // list: isArray(list)
        // 	? (<Array<string>>list).reduce(
        // 			(
        // 				acc: IDictionary<string | number>,
        // 				k: string | number
        // 			) => {
        // 				acc[String(k)] = k;
        // 				return acc;
        // 			},
        // 			{}
        // 		)
        // 	: list
        ) : undefined;
}


/***/ }),

/***/ 37424:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Q: function() { return /* binding */ getStrongControlTypes; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(37923);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(97369);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(36115);
/* harmony import */ var _get_control_type__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(57023);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */




/**
 * @private
 */
function getStrongControlTypes(items, controls) {
    const elements = (0,jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_3__/* .isArray */ .c)(items)
        ? items
        : (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_0__.keys)(items, false).map(key => {
            const value = items[key] || {};
            return (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_0__.ConfigProto)({ name: key }, value);
        });
    return elements.map(item => (0,_get_control_type__WEBPACK_IMPORTED_MODULE_2__/* .getControlType */ .U)(item, controls || jodit_config__WEBPACK_IMPORTED_MODULE_1__/* .Config */ .T.defaultOptions.controls));
}


/***/ }),

/***/ 931:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   I: function() { return /* binding */ Icon; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(38322);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



class Icon {
    static getIcon(name) {
        if (/<svg/i.test(name)) {
            return name;
        }
        const icon = Icon.icons[name] ||
            Icon.icons[name.replace(/-/g, '_')] ||
            Icon.icons[name.replace(/_/g, '-')] ||
            Icon.icons[(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.camelCase)(name)] ||
            Icon.icons[(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.kebabCase)(name)] ||
            Icon.icons[name.toLowerCase()];
        if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD && !icon) {
            console.warn(`Icon "${name}" not found`);
        }
        return icon;
    }
    /**
     * Check if icon exist in store
     */
    static exists(name) {
        return this.getIcon(name) !== undefined;
    }
    /**
     * Return SVG icon
     */
    static get(name, defaultValue = '<span></span>') {
        return this.getIcon(name) || defaultValue;
    }
    /**
     * Set SVG in store
     */
    static set(name, value) {
        this.icons[name.replace('_', '-')] = value;
        return this;
    }
    /**
     * Make icon html element
     */
    static makeIcon(jodit, icon) {
        var _a, _b, _c, _d;
        if (!icon) {
            return;
        }
        let iconElement;
        const { name, iconURL, fill } = icon;
        const clearName = name.replace(/[^a-zA-Z0-9]/g, '_');
        let iconFromEvent;
        if (!/<svg/.test(name)) {
            iconFromEvent = (_b = (_a = jodit.o).getIcon) === null || _b === void 0 ? void 0 : _b.call(_a, name, clearName);
        }
        const cacheKey = `${name}${iconURL}${fill}${iconFromEvent !== null && iconFromEvent !== void 0 ? iconFromEvent : ''}`;
        if (jodit.o.cache && this.__cache.has(cacheKey)) {
            return (_c = this.__cache.get(cacheKey)) === null || _c === void 0 ? void 0 : _c.cloneNode(true);
        }
        if (iconURL) {
            iconElement = jodit.c.span();
            (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_2__/* .css */ .A)(iconElement, 'backgroundImage', 'url(' +
                iconURL.replace('{basePath}', (jodit === null || jodit === void 0 ? void 0 : jodit.basePath) || '') +
                ')');
        }
        else {
            const svg = iconFromEvent ||
                Icon.get(name, '') ||
                ((_d = jodit.o.extraIcons) === null || _d === void 0 ? void 0 : _d[name]);
            if (svg) {
                iconElement = jodit.c.fromHTML(svg.trim());
                if (!/^<svg/i.test(name)) {
                    iconElement.classList.add('jodit-icon_' + clearName);
                }
            }
        }
        if (iconElement) {
            iconElement.classList.add('jodit-icon');
            iconElement.style.fill = fill;
            jodit.o.cache &&
                this.__cache.set(cacheKey, iconElement.cloneNode(true));
        }
        return iconElement;
    }
}
Icon.icons = {};
Icon.__cache = new Map();


/***/ }),

/***/ 53048:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   $6: function() { return /* reexport safe */ _form__WEBPACK_IMPORTED_MODULE_2__.$6; },
/* harmony export */   $n: function() { return /* reexport safe */ _button__WEBPACK_IMPORTED_MODULE_0__.$n; },
/* harmony export */   CP: function() { return /* reexport safe */ _group__WEBPACK_IMPORTED_MODULE_3__.CP; },
/* harmony export */   D$: function() { return /* reexport safe */ _element__WEBPACK_IMPORTED_MODULE_1__.D; },
/* harmony export */   F0: function() { return /* reexport safe */ _form__WEBPACK_IMPORTED_MODULE_2__.F0; },
/* harmony export */   In: function() { return /* reexport safe */ _icon__WEBPACK_IMPORTED_MODULE_4__.I; },
/* harmony export */   SB: function() { return /* reexport safe */ _button__WEBPACK_IMPORTED_MODULE_0__.SB; },
/* harmony export */   Ue: function() { return /* reexport safe */ _group__WEBPACK_IMPORTED_MODULE_3__.Ue; },
/* harmony export */   XV: function() { return /* reexport safe */ _form__WEBPACK_IMPORTED_MODULE_2__.XV; },
/* harmony export */   Yh: function() { return /* reexport safe */ _form__WEBPACK_IMPORTED_MODULE_2__.Yh; },
/* harmony export */   bk: function() { return /* reexport safe */ _group__WEBPACK_IMPORTED_MODULE_3__.bk; },
/* harmony export */   cY: function() { return /* reexport safe */ _form__WEBPACK_IMPORTED_MODULE_2__.cY; },
/* harmony export */   lD: function() { return /* reexport safe */ _button__WEBPACK_IMPORTED_MODULE_0__.lD; },
/* harmony export */   nE: function() { return /* reexport safe */ _form__WEBPACK_IMPORTED_MODULE_2__.nE; },
/* harmony export */   ss: function() { return /* reexport safe */ _button__WEBPACK_IMPORTED_MODULE_0__.ss; },
/* harmony export */   tS: function() { return /* reexport safe */ _form__WEBPACK_IMPORTED_MODULE_2__.tS; },
/* harmony export */   ue: function() { return /* reexport safe */ _button__WEBPACK_IMPORTED_MODULE_0__.ue; },
/* harmony export */   z2: function() { return /* reexport safe */ _progress_bar_progress_bar__WEBPACK_IMPORTED_MODULE_6__.z; },
/* harmony export */   z4: function() { return /* reexport safe */ _group__WEBPACK_IMPORTED_MODULE_3__.z4; },
/* harmony export */   zD: function() { return /* reexport safe */ _popup__WEBPACK_IMPORTED_MODULE_5__.z; }
/* harmony export */ });
/* harmony import */ var _button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(35265);
/* harmony import */ var _element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(29780);
/* harmony import */ var _form__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(20703);
/* harmony import */ var _group__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(29012);
/* harmony import */ var _icon__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(931);
/* harmony import */ var _popup__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(96369);
/* harmony import */ var _progress_bar_progress_bar__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(92227);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * [[include:core/ui/README.md]]
 * @packageDocumentation
 * @module ui
 */









/***/ }),

/***/ 96369:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   z: function() { return /* reexport safe */ _popup__WEBPACK_IMPORTED_MODULE_0__.z; }
/* harmony export */ });
/* harmony import */ var _popup__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(80071);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module ui/popup
 */



/***/ }),

/***/ 80071:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   z: function() { return /* binding */ Popup; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_component_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(37474);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(28712);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(29780);
/* harmony import */ var jodit_core_ui_group_group__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(6455);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */










const EVENTS_FOR_AUTOCLOSE = [
    'escape',
    'cut',
    'delete',
    'backSpaceAfterDelete',
    'beforeCommandDelete'
];
class Popup extends jodit_core_ui_group_group__WEBPACK_IMPORTED_MODULE_7__/* .UIGroup */ .U {
    className() {
        return 'Popup';
    }
    appendChildToContainer(childContainer) {
        const content = this.getElm('content');
        void 0;
        content.appendChild(childContainer);
    }
    updateParentElement(target) {
        if (target !== this && jodit_core_component_component__WEBPACK_IMPORTED_MODULE_0__/* .Component */ .u.isInstanceOf(target, Popup)) {
            this.__childrenPopups.forEach(popup => {
                if (!target.closest(popup) && popup.isOpened) {
                    popup.close();
                }
            });
            if (!this.__childrenPopups.has(target)) {
                this.j.e.on(target, 'beforeClose', () => {
                    this.__childrenPopups.delete(target);
                });
            }
            this.__childrenPopups.add(target);
        }
        return super.updateParentElement(target);
    }
    /**
     * Set popup content
     */
    setContent(content) {
        if (this.allChildren.length) {
            throw new Error('Remove children');
        }
        if (jodit_core_component_component__WEBPACK_IMPORTED_MODULE_0__/* .Component */ .u.isInstanceOf(content, jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_6__/* .UIElement */ .D)) {
            this.append(content);
        }
        else {
            const elm = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.isString)(content)
                ? this.j.c.fromHTML(content)
                : content;
            this.appendChildToContainer(elm);
        }
        this.updatePosition();
        return this;
    }
    /**
     * Open popup near with some bound
     */
    open(getBound, keepPosition = false, parentContainer) {
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.markOwner)(this.jodit, this.container);
        this.container.classList.add(`jodit_theme_${this.jodit.o.theme}`);
        this.__calculateZIndex();
        this.isOpened = true;
        this.__addGlobalListeners();
        this.__targetBound = !keepPosition
            ? getBound
            : this.getKeepBound(getBound);
        if (parentContainer) {
            parentContainer.appendChild(this.container);
        }
        else {
            const popupContainer = (0,jodit_core_global__WEBPACK_IMPORTED_MODULE_3__/* .getContainer */ .My)(this.jodit, Popup);
            if (parentContainer !== this.container.parentElement) {
                popupContainer.appendChild(this.container);
            }
        }
        this.updatePosition();
        this.j.e.fire(this, 'afterOpen');
        this.j.e.fire('afterOpenPopup', this);
        return this;
    }
    __calculateZIndex() {
        if (this.container.style.zIndex) {
            return;
        }
        const checkView = (view) => {
            const zIndex = view.container.style.zIndex || view.o.zIndex;
            if (zIndex) {
                this.setZIndex(1 + parseInt(zIndex.toString(), 10));
                return true;
            }
            return false;
        };
        const { j } = this;
        if (checkView(j)) {
            return;
        }
        let pe = this.parentElement;
        while (pe) {
            if (checkView(pe.j)) {
                return;
            }
            if (pe.container.style.zIndex) {
                this.setZIndex(1 + parseInt(pe.container.style.zIndex.toString(), 10));
                return;
            }
            if (!pe.parentElement && pe.container.parentElement) {
                const elm = jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_6__/* .UIElement */ .D.closestElement(pe.container.parentElement, jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_6__/* .UIElement */ .D);
                if (elm) {
                    pe = elm;
                    continue;
                }
            }
            pe = pe.parentElement;
        }
    }
    /**
     * Calculate static bound for point
     */
    getKeepBound(getBound) {
        const oldBound = getBound();
        const elmUnderCursor = this.od.elementFromPoint(oldBound.left, oldBound.top);
        if (!elmUnderCursor) {
            return getBound;
        }
        const element = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isHTMLElement(elmUnderCursor)
            ? elmUnderCursor
            : elmUnderCursor.parentElement;
        const oldPos = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.position)(element, this.j);
        return () => {
            const bound = getBound();
            const newPos = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.position)(element, this.j);
            return Object.assign(Object.assign({}, bound), { top: bound.top + (newPos.top - oldPos.top), left: bound.left + (newPos.left - oldPos.left) });
        };
    }
    /**
     * Update container position
     */
    updatePosition() {
        if (!this.isOpened) {
            return this;
        }
        const [pos, strategy] = this.__calculatePosition(this.__targetBound(), this.viewBound(), (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.position)(this.container, this.j));
        this.setMod('strategy', strategy);
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.css)(this.container, {
            left: pos.left,
            top: pos.top
        });
        this.__childrenPopups.forEach(popup => popup.updatePosition());
        return this;
    }
    __throttleUpdatePosition() {
        this.updatePosition();
    }
    /**
     * Calculate start point
     */
    __calculatePosition(target, view, container, defaultStrategy = this.strategy) {
        const x = {
            left: target.left,
            right: target.left - (container.width - target.width)
        }, y = {
            bottom: target.top + target.height,
            top: target.top - container.height
        };
        const list = Object.keys(x).reduce((keys, xKey) => keys.concat(Object.keys(y).map(yKey => `${xKey}${(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.ucfirst)(yKey)}`)), []);
        const getPointByStrategy = (strategy) => {
            const [xKey, yKey] = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.kebabCase)(strategy).split('-');
            return {
                left: x[xKey],
                top: y[yKey],
                width: container.width,
                height: container.height
            };
        };
        const getMatchStrategy = (inBox) => {
            let strategy = null;
            if (Popup.boxInView(getPointByStrategy(defaultStrategy), inBox)) {
                strategy = defaultStrategy;
            }
            else {
                strategy =
                    list.find((key) => {
                        if (Popup.boxInView(getPointByStrategy(key), inBox)) {
                            return key;
                        }
                        return;
                    }) || null;
            }
            return strategy;
        };
        // Try to find match position inside Jodit.container
        let strategy = getMatchStrategy((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.position)(this.j.container, this.j));
        // If not found or is not inside window view
        if (!strategy || !Popup.boxInView(getPointByStrategy(strategy), view)) {
            // Find match strategy inside window view
            strategy = getMatchStrategy(view) || strategy || defaultStrategy;
        }
        return [getPointByStrategy(strategy), strategy];
    }
    /**
     * Check if one box is inside second
     */
    static boxInView(box, view) {
        const accuracy = 2;
        return (box.top - view.top >= -accuracy &&
            box.left - view.left >= -accuracy &&
            view.top + view.height - (box.top + box.height) >= -accuracy &&
            view.left + view.width - (box.left + box.width) >= -accuracy);
    }
    /**
     * Close popup
     */
    close() {
        if (!this.isOpened) {
            return this;
        }
        this.isOpened = false;
        this.__childrenPopups.forEach(popup => popup.close());
        this.j.e.fire(this, 'beforeClose');
        this.j.e.fire('beforePopupClose', this);
        this.__removeGlobalListeners();
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.safeRemove(this.container);
        return this;
    }
    /**
     * Close popup if click was in outside
     */
    __closeOnOutsideClick(e) {
        if (!this.isOpened || this.isOwnClick(e)) {
            return;
        }
        this.close();
    }
    isOwnClick(e) {
        if (!e.target) {
            return false;
        }
        const box = jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_6__/* .UIElement */ .D.closestElement(e.target, Popup);
        return Boolean(box && (this === box || box.closest(this)));
    }
    __addGlobalListeners() {
        const up = this.__throttleUpdatePosition, ow = this.ow;
        jodit_core_global__WEBPACK_IMPORTED_MODULE_3__/* .eventEmitter */ .RR.on('closeAllPopups', this.close);
        if (this.smart) {
            this.j.e
                .on(EVENTS_FOR_AUTOCLOSE, this.close)
                .on('mousedown touchstart', this.__closeOnOutsideClick)
                .on(ow, 'mousedown touchstart', this.__closeOnOutsideClick);
        }
        this.j.e
            .on('closeAllPopups', this.close)
            .on('resize', up)
            .on(this.container, 'scroll mousewheel', up)
            .on(ow, 'scroll', up)
            .on(ow, 'resize', up);
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.up(this.j.container, box => {
            box && this.j.e.on(box, 'scroll mousewheel', up);
        });
    }
    __removeGlobalListeners() {
        const up = this.__throttleUpdatePosition, ow = this.ow;
        jodit_core_global__WEBPACK_IMPORTED_MODULE_3__/* .eventEmitter */ .RR.off('closeAllPopups', this.close);
        if (this.smart) {
            this.j.e
                .off(EVENTS_FOR_AUTOCLOSE, this.close)
                .off('mousedown touchstart', this.__closeOnOutsideClick)
                .off(ow, 'mousedown touchstart', this.__closeOnOutsideClick);
        }
        this.j.e
            .off('closeAllPopups', this.close)
            .off('resize', up)
            .off(this.container, 'scroll mousewheel', up)
            .off(ow, 'scroll', up)
            .off(ow, 'resize', up);
        if (this.j.container.isConnected) {
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.up(this.j.container, box => {
                box && this.j.e.off(box, 'scroll mousewheel', up);
            });
        }
    }
    /**
     * Set ZIndex
     */
    setZIndex(index) {
        this.container.style.zIndex = index.toString();
    }
    constructor(jodit, smart = true) {
        super(jodit);
        this.smart = smart;
        this.isOpened = false;
        this.strategy = 'leftBottom';
        this.viewBound = () => ({
            left: 0,
            top: 0,
            width: this.ow.innerWidth,
            height: this.ow.innerHeight
        });
        this.__childrenPopups = new Set();
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.attr)(this.container, 'role', 'popup');
    }
    render() {
        return `<div>
			<div class="&__content"></div>
		</div>`;
    }
    /** @override **/
    destruct() {
        this.close();
        return super.destruct();
    }
}
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], Popup.prototype, "updatePosition", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.throttle)(10),
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], Popup.prototype, "__throttleUpdatePosition", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], Popup.prototype, "close", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], Popup.prototype, "__closeOnOutsideClick", null);


/***/ }),

/***/ 92227:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   z: function() { return /* binding */ ProgressBar; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(29780);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



class ProgressBar extends jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_1__/* .UIElement */ .D {
    /** @override */
    className() {
        return 'ProgressBar';
    }
    /** @override */
    render() {
        return '<div><div></div></div>';
    }
    /**
     * Show progress bar
     */
    show() {
        const container = this.j.workplace || this.j.container;
        container.appendChild(this.container);
        return this;
    }
    hide() {
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.safeRemove(this.container);
        return this;
    }
    progress(percentage) {
        this.container.style.width = percentage.toFixed(2) + '%';
        return this;
    }
    destruct() {
        this.hide();
        return super.destruct();
    }
}


/***/ }),

/***/ 14961:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   T: function() { return /* binding */ ViewWithToolbar; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(64567);
/* harmony import */ var jodit_core_decorators_autobind_autobind__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(26318);
/* harmony import */ var jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(66927);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_array__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(32709);
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(98253);
/* harmony import */ var jodit_core_helpers_utils_selector__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(58720);
/* harmony import */ var jodit_core_ui_helpers_buttons__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(39611);
/* harmony import */ var jodit_core_view_view__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(77782);
/* harmony import */ var jodit_modules_toolbar_factory__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(8809);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */












class ViewWithToolbar extends jodit_core_view_view__WEBPACK_IMPORTED_MODULE_5__/* .View */ .S {
    /**
     * Container for toolbar
     */
    get toolbarContainer() {
        if (!this.o.fullsize &&
            ((0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_7__/* .isString */ .K)(this.o.toolbar) || jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isHTMLElement(this.o.toolbar))) {
            return (0,jodit_core_helpers_utils_selector__WEBPACK_IMPORTED_MODULE_4__/* .resolveElement */ .tI)(this.o.toolbar, this.o.shadowRoot || this.od);
        }
        this.o.toolbar &&
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.appendChildFirst(this.container, this.__defaultToolbarContainer);
        return this.__defaultToolbarContainer;
    }
    /**
     * Change panel container
     */
    setPanel(element) {
        this.o.toolbar = element;
        this.buildToolbar();
    }
    /**
     * Helper for appended toolbar in its place
     */
    buildToolbar() {
        var _a;
        if (!this.o.toolbar) {
            return;
        }
        const buttons = this.o.buttons
            ? (0,jodit_core_helpers_array__WEBPACK_IMPORTED_MODULE_3__/* .splitArray */ .uM)(this.o.buttons)
            : [];
        (_a = this.toolbar) === null || _a === void 0 ? void 0 : _a.setRemoveButtons(this.o.removeButtons).build(buttons.concat(this.o.extraButtons || [])).appendTo(this.toolbarContainer);
    }
    getRegisteredButtonGroups() {
        return this.groupToButtons;
    }
    /**
     * Register button for a group
     */
    registerButton(btn) {
        var _a;
        this.registeredButtons.add(btn);
        const group = (_a = btn.group) !== null && _a !== void 0 ? _a : 'other';
        if (!this.groupToButtons[group]) {
            this.groupToButtons[group] = [];
        }
        if (btn.position != null) {
            this.groupToButtons[group][btn.position] = btn.name;
        }
        else {
            this.groupToButtons[group].push(btn.name);
        }
        return this;
    }
    /**
     * Remove button from a group
     */
    unregisterButton(btn) {
        var _a;
        this.registeredButtons.delete(btn);
        const groupName = (_a = btn.group) !== null && _a !== void 0 ? _a : 'other', group = this.groupToButtons[groupName];
        if (group) {
            const index = group.indexOf(btn.name);
            if (index !== -1) {
                group.splice(index, 1);
            }
            if (group.length === 0) {
                delete this.groupToButtons[groupName];
            }
        }
        return this;
    }
    /**
     * Prepare toolbar items and append buttons in groups
     */
    beforeToolbarBuild(items) {
        if (Object.keys(this.groupToButtons).length) {
            return items.map(item => {
                if ((0,jodit_core_ui_helpers_buttons__WEBPACK_IMPORTED_MODULE_8__/* .isButtonGroup */ .i)(item) &&
                    item.group &&
                    this.groupToButtons[item.group]) {
                    return {
                        group: item.group,
                        buttons: [
                            ...item.buttons,
                            ...this.groupToButtons[item.group]
                        ]
                    };
                }
                return item;
            });
        }
    }
    /** @override **/
    constructor(options, isJodit = false) {
        super(options, isJodit);
        this.toolbar = (0,jodit_modules_toolbar_factory__WEBPACK_IMPORTED_MODULE_6__/* .makeCollection */ .$K)(this);
        this.__defaultToolbarContainer = this.c.div('jodit-toolbar__box');
        this.registeredButtons = new Set();
        this.groupToButtons = {};
        this.isJodit = false;
        this.isJodit = isJodit;
        this.e.on('beforeToolbarBuild', this.beforeToolbarBuild);
    }
    destruct() {
        if (this.isDestructed) {
            return;
        }
        this.setStatus(jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_0__/* .STATUSES */ .f.beforeDestruct);
        this.e.off('beforeToolbarBuild', this.beforeToolbarBuild);
        this.toolbar.destruct();
        // @ts-ignore After destruct, we are not responsible for anything
        this.toolbar = undefined;
        super.destruct();
    }
}
(0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)(':rebuildToolbar')
], ViewWithToolbar.prototype, "buildToolbar", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__decorate */ .Cg)([
    jodit_core_decorators_autobind_autobind__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .Ay
], ViewWithToolbar.prototype, "beforeToolbarBuild", null);


/***/ }),

/***/ 77782:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   S: function() { return /* binding */ View; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(77753);
/* harmony import */ var jodit_core_component_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(37474);
/* harmony import */ var jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(64567);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_create_create__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(92852);
/* harmony import */ var jodit_core_decorators_cache_cache__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(87875);
/* harmony import */ var jodit_core_decorators_derive_derive__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(1963);
/* harmony import */ var jodit_core_decorators_hook_hook__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(71151);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_event_emitter__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(50025);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_storage_storage__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(24834);
/* harmony import */ var jodit_core_traits_elms__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(87906);
/* harmony import */ var jodit_core_traits_mods__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(75758);
/* harmony import */ var jodit_core_ui_progress_bar_progress_bar__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(92227);
/* harmony import */ var jodit_modules_messages_messages__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(91902);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
var View_1;


















let View = View_1 = class View extends jodit_core_component_component__WEBPACK_IMPORTED_MODULE_1__/* .Component */ .u {
    /**
     * Get a path for loading extra staff
     */
    get basePath() {
        if (this.o.basePath) {
            return this.o.basePath;
        }
        return jodit_core_constants__WEBPACK_IMPORTED_MODULE_3__.BASE_PATH;
    }
    /**
     * Return a default timeout period in milliseconds for some debounce or throttle functions.
     * By default, `{history.timeout}` options
     */
    get defaultTimeout() {
        return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_10__.isVoid)(this.o.defaultTimeout) ? 100 : this.o.defaultTimeout;
    }
    /**
     * Some extra data inside editor
     * @see copyformat plugin
     */
    get buffer() {
        return jodit_core_storage_storage__WEBPACK_IMPORTED_MODULE_11__/* .Storage */ .w.makeStorage();
    }
    get message() {
        return this.getMessageModule(this.container);
    }
    getMessageModule(container) {
        return new jodit_modules_messages_messages__WEBPACK_IMPORTED_MODULE_14__/* .UIMessages */ .N(this, container);
    }
    /**
     * Container for persistent set/get value
     */
    get storage() {
        return jodit_core_storage_storage__WEBPACK_IMPORTED_MODULE_11__/* .Storage */ .w.makeStorage(true, this.id);
    }
    /**
     * Short alias for `create`
     */
    get c() {
        return this.create;
    }
    get container() {
        return this.__container;
    }
    set container(container) {
        this.__container = container;
    }
    /**
     * Short alias for `events`
     */
    get e() {
        return this.events;
    }
    /**
     * progress_bar Progress bar
     */
    get progressbar() {
        return new jodit_core_ui_progress_bar_progress_bar__WEBPACK_IMPORTED_MODULE_13__/* .ProgressBar */ .z(this);
    }
    get options() {
        return this.__options;
    }
    set options(options) {
        this.__options = options;
    }
    /**
     * Short alias for options
     */
    get o() {
        return this.options;
    }
    /**
     * Internationalization method. Uses Jodit.lang object
     */
    i18n(text, ...params) {
        return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_10__.i18n)(text, params, this.options);
    }
    toggleFullSize(isFullSize) {
        if (isFullSize === undefined) {
            isFullSize = !this.__isFullSize;
        }
        if (isFullSize === this.__isFullSize) {
            return;
        }
        this.__isFullSize = isFullSize;
        this.e.fire('toggleFullSize', isFullSize);
    }
    /**
     * View is locked
     */
    get isLocked() {
        return this.__whoLocked !== '';
    }
    /**
     * Disable selecting
     */
    lock(name = 'any') {
        if (!this.isLocked) {
            this.__whoLocked = name;
            return true;
        }
        return false;
    }
    /**
     * Enable selecting
     */
    unlock() {
        if (this.isLocked) {
            this.__whoLocked = '';
            return true;
        }
        return false;
    }
    /**
     * View is in fullSize
     */
    get isFullSize() {
        return this.__isFullSize;
    }
    /**
     * Return current version
     */
    getVersion() {
        return View_1.version;
    }
    static getVersion() {
        return View_1.version;
    }
    /** @override */
    initOptions(options) {
        this.options = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_10__.ConfigProto)(options || {}, (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_10__.ConfigProto)(this.options || {}, View_1.defaultOptions));
    }
    /**
     * Can change ownerWindow here
     */
    initOwners() {
        var _a;
        this.ownerWindow = (_a = this.o.ownerWindow) !== null && _a !== void 0 ? _a : window;
    }
    /**
     * Add option's event handlers in emitter
     */
    attachEvents(options) {
        if (!options) {
            return;
        }
        const e = options === null || options === void 0 ? void 0 : options.events;
        e && Object.keys(e).forEach((key) => this.e.on(key, e[key]));
    }
    constructor(options, isJodit = false) {
        super();
        this.isJodit = isJodit;
        this.isView = true;
        this.parent = null;
        this.mods = {};
        /**
         * All created ViewComponent inside this view
         */
        this.components = new Set();
        this.OPTIONS = View_1.defaultOptions;
        this.__isFullSize = false;
        this.__whoLocked = '';
        this.isLockedNotBy = (name) => this.isLocked && this.__whoLocked !== name;
        this.__modulesInstances = new Map();
        this.id = new Date().getTime().toString();
        this.initOptions(options);
        this.initOwners();
        this.events = new jodit_core_event_emitter__WEBPACK_IMPORTED_MODULE_8__/* .EventEmitter */ .bk(this.od);
        this.create = new jodit_core_create_create__WEBPACK_IMPORTED_MODULE_4__/* .Create */ .X(this.od);
        this.container = this.c.div(`jodit ${this.componentName}`);
    }
    getInstance(moduleNameOrConstructor, options) {
        const moduleName = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_10__.isFunction)(moduleNameOrConstructor)
            ? moduleNameOrConstructor.prototype.className()
            : moduleNameOrConstructor;
        const instance = this.e.fire((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_10__.camelCase)('getInstance_' + moduleName), options);
        if (instance) {
            return instance;
        }
        const module = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_10__.isFunction)(moduleNameOrConstructor)
            ? moduleNameOrConstructor
            : jodit_core_global__WEBPACK_IMPORTED_MODULE_9__/* .modules */ .av[moduleName], mi = this.__modulesInstances;
        if (!(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_10__.isFunction)(module)) {
            throw (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_10__.error)('Need real module name');
        }
        if (!mi.has(moduleName)) {
            const instance = module.prototype instanceof jodit_core_component__WEBPACK_IMPORTED_MODULE_0__/* .ViewComponent */ .vG
                ? new module(this, options)
                : new module(options);
            this.components.add(instance);
            mi.set(moduleName, instance);
        }
        return mi.get(moduleName);
    }
    /** Add some element to box */
    addDisclaimer(elm) {
        this.container.appendChild(elm);
    }
    /**
     * Call before destruct
     */
    beforeDestruct() {
        this.e.fire(jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_2__/* .STATUSES */ .f.beforeDestruct, this);
        this.components.forEach(component => {
            if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_10__.isDestructable)(component) && !component.isInDestruct) {
                component.destruct();
            }
        });
        this.components.clear();
    }
    /** @override */
    destruct() {
        if (this.isDestructed) {
            return;
        }
        this.progressbar.destruct();
        this.message.destruct();
        if (this.events) {
            this.events.destruct();
            // @ts-ignore
            this.events = undefined;
        }
        if (this.buffer) {
            this.buffer.clear();
        }
        jodit_core_dom__WEBPACK_IMPORTED_MODULE_7__/* .Dom */ .J.safeRemove(this.container);
        super.destruct();
    }
};
// from webpack.config.js
View.ES = jodit_core_constants__WEBPACK_IMPORTED_MODULE_3__.ES;
View.version = jodit_core_constants__WEBPACK_IMPORTED_MODULE_3__.APP_VERSION;
View.esNext = jodit_core_constants__WEBPACK_IMPORTED_MODULE_3__.IS_ES_NEXT; // from webpack.config.js
View.esModern = jodit_core_constants__WEBPACK_IMPORTED_MODULE_3__.IS_ES_MODERN; // from webpack.config.js
(0,tslib__WEBPACK_IMPORTED_MODULE_15__/* .__decorate */ .Cg)([
    jodit_core_decorators_cache_cache__WEBPACK_IMPORTED_MODULE_5__/* .cache */ .PP
], View.prototype, "buffer", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_15__/* .__decorate */ .Cg)([
    jodit_core_decorators_cache_cache__WEBPACK_IMPORTED_MODULE_5__/* .cache */ .PP
], View.prototype, "message", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_15__/* .__decorate */ .Cg)([
    jodit_core_decorators_cache_cache__WEBPACK_IMPORTED_MODULE_5__/* .cache */ .PP
], View.prototype, "storage", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_15__/* .__decorate */ .Cg)([
    jodit_core_decorators_cache_cache__WEBPACK_IMPORTED_MODULE_5__/* .cache */ .PP
], View.prototype, "c", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_15__/* .__decorate */ .Cg)([
    jodit_core_decorators_cache_cache__WEBPACK_IMPORTED_MODULE_5__/* .cache */ .PP
], View.prototype, "e", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_15__/* .__decorate */ .Cg)([
    jodit_core_decorators_cache_cache__WEBPACK_IMPORTED_MODULE_5__/* .cache */ .PP
], View.prototype, "progressbar", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_15__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators_hook_hook__WEBPACK_IMPORTED_MODULE_6__/* .hook */ .A)(jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_2__/* .STATUSES */ .f.beforeDestruct)
], View.prototype, "beforeDestruct", null);
View = View_1 = (0,tslib__WEBPACK_IMPORTED_MODULE_15__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators_derive_derive__WEBPACK_IMPORTED_MODULE_16__/* .derive */ .C)(jodit_core_traits_mods__WEBPACK_IMPORTED_MODULE_17__/* .Mods */ .K, jodit_core_traits_elms__WEBPACK_IMPORTED_MODULE_12__/* .Elms */ .O)
], View);

View.defaultOptions = {
    extraButtons: [],
    cache: true,
    textIcons: false,
    namespace: '',
    removeButtons: [],
    zIndex: 100002,
    defaultTimeout: 100,
    fullsize: false,
    showTooltip: true,
    useNativeTooltip: false,
    buttons: [],
    globalFullSize: true,
    language: 'auto'
};


/***/ }),

/***/ 46173:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   x: function() { return /* binding */ Jodit; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_request__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(53883);
/* harmony import */ var jodit_core_traits_dlgs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(58597);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(36115);
/* harmony import */ var jodit_modules__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(37435);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
var Jodit_1;










const __defaultStyleDisplayKey = 'data-jodit-default-style-display';
const __defaultClassesKey = 'data-jodit-default-classes';
let Jodit = Jodit_1 = class Jodit extends jodit_modules__WEBPACK_IMPORTED_MODULE_7__.ViewWithToolbar {
    /** @override */
    className() {
        return 'Jodit';
    }
    /**
     * Return promise for ready actions
     * @example
     * ```js
     * const jodit = Jodit.make('#editor');
     * await jodit.waitForReady();
     * jodit.e.fire('someAsyncLoadedPluginEvent', (test) => {
     *   alert(test);
     * });
     * ```
     */
    waitForReady() {
        if (this.isReady) {
            return Promise.resolve(this);
        }
        return this.async.promise(resolve => {
            this.hookStatus('ready', () => resolve(this));
        });
    }
    static get ready() {
        return new Promise(resolve => {
            jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .eventEmitter */ .RR.on('oditready', resolve);
        });
    }
    /**
     * Plain text editor's value
     */
    get text() {
        if (this.editor) {
            return this.editor.innerText || '';
        }
        const div = this.createInside.div();
        div.innerHTML = this.getElementValue();
        return div.innerText || '';
    }
    /**
     * Return a default timeout period in milliseconds for some debounce or throttle functions.
     * By default, `{history.timeout}` options
     */
    get defaultTimeout() {
        return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isNumber)(this.o.defaultTimeout)
            ? this.o.defaultTimeout
            : jodit_config__WEBPACK_IMPORTED_MODULE_6__/* .Config */ .T.defaultOptions.defaultTimeout;
    }
    /**
     * Method wrap usual Has Object in Object helper for prevent deep object merging in options*
     */
    static atom(object) {
        return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.markAsAtomic)(object);
    }
    /**
     * Factory for creating Jodit instance
     */
    static make(element, options) {
        return new this(element, options);
    }
    /**
     * Checks if the element has already been initialized when for Jodit
     */
    static isJoditAssigned(element) {
        return (element &&
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isJoditObject)(element.component) &&
            !element.component.isInDestruct);
    }
    /**
     * Default settings
     */
    static get defaultOptions() {
        return jodit_config__WEBPACK_IMPORTED_MODULE_6__/* .Config */ .T.defaultOptions;
    }
    get createInside() {
        return new jodit_modules__WEBPACK_IMPORTED_MODULE_7__.Create(() => this.ed, this.o.createAttributes);
    }
    __setPlaceField(field, value) {
        if (!this.currentPlace) {
            this.currentPlace = {};
            this.places = [this.currentPlace];
        }
        this.currentPlace[field] = value;
    }
    /**
     * element It contains source element
     */
    get element() {
        return this.currentPlace.element;
    }
    /**
     * editor It contains the root element editor
     */
    get editor() {
        return this.currentPlace.editor;
    }
    set editor(editor) {
        this.__setPlaceField('editor', editor);
    }
    /**
     * Container for all staff
     */
    get container() {
        return this.currentPlace.container;
    }
    set container(container) {
        this.__setPlaceField('container', container);
    }
    /**
     * workplace It contains source and wysiwyg editors
     */
    get workplace() {
        return this.currentPlace.workplace;
    }
    get message() {
        return this.getMessageModule(this.workplace);
    }
    /**
     * Statusbar module
     */
    get statusbar() {
        return this.currentPlace.statusbar;
    }
    /**
     * iframe Iframe for iframe mode
     */
    get iframe() {
        return this.currentPlace.iframe;
    }
    set iframe(iframe) {
        this.__setPlaceField('iframe', iframe);
    }
    get history() {
        return this.currentPlace.history;
    }
    /**
     * In iframe mode editor's window can be different by owner
     */
    get editorWindow() {
        return this.currentPlace.editorWindow;
    }
    set editorWindow(win) {
        this.__setPlaceField('editorWindow', win);
    }
    /**
     * Alias for this.ew
     */
    get ew() {
        return this.editorWindow;
    }
    /**
     * In iframe mode editor's window can be different by owner
     */
    get editorDocument() {
        return this.currentPlace.editorWindow.document;
    }
    /**
     * Alias for this.ew
     */
    get ed() {
        return this.editorDocument;
    }
    /**
     * options All Jodit settings default + second arguments of constructor
     */
    get options() {
        return this.currentPlace.options;
    }
    set options(opt) {
        this.__setPlaceField('options', opt);
    }
    /**
     * Alias for this.selection
     */
    get s() {
        return this.selection;
    }
    get uploader() {
        return this.getInstance('Uploader', this.o.uploader);
    }
    get filebrowser() {
        const jodit = this;
        const options = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.ConfigProto)({
            defaultTimeout: jodit.defaultTimeout,
            uploader: jodit.o.uploader,
            language: jodit.o.language,
            license: jodit.o.license,
            theme: jodit.o.theme,
            shadowRoot: jodit.o.shadowRoot,
            defaultCallback(data) {
                if (data.files && data.files.length) {
                    data.files.forEach((file, i) => {
                        const url = data.baseurl + file;
                        const isImage = data.isImages
                            ? data.isImages[i]
                            : false;
                        if (isImage) {
                            jodit.s.insertImage(url, null, jodit.o.imageDefaultWidth);
                        }
                        else {
                            jodit.s.insertNode(jodit.createInside.fromHTML(`<a href='${url}' title='${url}'>${url}</a>`));
                        }
                    });
                }
            }
        }, this.o.filebrowser);
        return jodit.getInstance('FileBrowser', options);
    }
    /**
     * Editor's mode
     */
    get mode() {
        return this.__mode;
    }
    set mode(mode) {
        this.setMode(mode);
    }
    /**
     * Return real HTML value from WYSIWYG editor.
     * @internal
     */
    getNativeEditorValue() {
        const value = this.e.fire('beforeGetNativeEditorValue');
        if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isString)(value)) {
            return value;
        }
        if (this.editor) {
            return this.editor.innerHTML;
        }
        return this.getElementValue();
    }
    /**
     * Set value to native editor
     */
    setNativeEditorValue(value) {
        const data = {
            value
        };
        if (this.e.fire('beforeSetNativeEditorValue', data)) {
            return;
        }
        if (this.editor) {
            this.editor.innerHTML = data.value;
        }
    }
    /**
     * HTML value
     */
    get value() {
        return this.getEditorValue();
    }
    set value(html) {
        this.setEditorValue(html);
        // @ts-ignore Internal method
        this.history.__processChanges();
    }
    synchronizeValues() {
        this.__imdSynchronizeValues();
    }
    /**
     * This is an internal method, do not use it in your applications.
     * @private
     * @internal
     */
    __imdSynchronizeValues() {
        this.setEditorValue();
    }
    /**
     * Return editor value
     */
    getEditorValue(removeSelectionMarkers = true, consumer) {
        /**
         * Triggered before getEditorValue executed.
         * If returned not undefined, getEditorValue will return this value
         * @example
         * ```javascript
         * var editor = Jodit.make("#redactor");
         * editor.e.on('beforeGetValueFromEditor', function () {
         *     return editor.editor.innerHTML.replace(/a/g, 'b');
         * });
         * ```
         */
        let value;
        value = this.e.fire('beforeGetValueFromEditor', consumer);
        if (value !== undefined) {
            return value;
        }
        value = this.getNativeEditorValue().replace(jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INVISIBLE_SPACE_REG_EXP(), '');
        if (removeSelectionMarkers) {
            value = value.replace(/<span[^>]+id="jodit-selection_marker_[^>]+><\/span>/g, '');
        }
        if (value === '<br>') {
            value = '';
        }
        /**
         * Triggered after getEditorValue got value from wysiwyg.
         * It can change new_value.value
         *
         * @example
         * ```javascript
         * var editor = Jodit.make("#redactor");
         * editor.e.on('afterGetValueFromEditor', function (new_value) {
         *     new_value.value = new_value.value.replace('a', 'b');
         * });
         * ```
         */
        const new_value = { value };
        this.e.fire('afterGetValueFromEditor', new_value, consumer);
        return new_value.value;
    }
    /**
     * Set editor html value and if set sync fill source element value
     * When method was called without arguments - it is a simple way to synchronize editor to element
     */
    setEditorValue(value) {
        /**
         * Triggered before getEditorValue set value to wysiwyg.
         * @example
         * ```javascript
         * var editor = Jodit.make("#redactor");
         * editor.e.on('beforeSetValueToEditor', function (old_value) {
         *     return old_value.value.replace('a', 'b');
         * });
         * editor.e.on('beforeSetValueToEditor', function () {
         *     return false; // disable setEditorValue method
         * });
         * ```
         */
        const newValue = this.e.fire('beforeSetValueToEditor', value);
        if (newValue === false) {
            return;
        }
        if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isString)(newValue)) {
            value = newValue;
        }
        if (!this.editor) {
            if (value !== undefined) {
                this.__setElementValue(value);
            }
            return; // try change value before init or after destruct
        }
        if (!(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isString)(value) && !(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isVoid)(value)) {
            throw (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.error)('value must be string');
        }
        if (!(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isVoid)(value) && this.getNativeEditorValue() !== value) {
            this.setNativeEditorValue(value);
        }
        this.e.fire('postProcessSetEditorValue');
        const old_value = this.getElementValue(), new_value = this.getEditorValue();
        if (!this.__isSilentChange &&
            old_value !== new_value &&
            this.__callChangeCount < jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.SAFE_COUNT_CHANGE_CALL) {
            this.__setElementValue(new_value);
            this.__callChangeCount += 1;
            if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD && this.__callChangeCount > 4) {
                console.warn('Too many recursive changes', new_value, old_value);
            }
            try {
                // @ts-ignore Internal method
                this.history.__upTick();
                this.e.fire('change', new_value, old_value);
                this.e.fire(this.history, 'change', new_value, old_value);
            }
            finally {
                this.__callChangeCount = 0;
            }
        }
    }
    /**
     * If some plugin changes the DOM directly, then you need to update the content of the original element
     */
    updateElementValue() {
        this.__setElementValue(this.getEditorValue());
    }
    /**
     * Return source element value
     */
    getElementValue() {
        return this.element.value !== undefined
            ? this.element.value
            : this.element.innerHTML;
    }
    __setElementValue(value) {
        if (!(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isString)(value)) {
            throw (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.error)('value must be string');
        }
        if (this.element !== this.container &&
            value !== this.getElementValue()) {
            const data = { value };
            const res = this.e.fire('beforeSetElementValue', data);
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.callPromise)(res, () => {
                if (this.element.value !== undefined) {
                    this.element.value = data.value;
                }
                else {
                    this.element.innerHTML = data.value;
                }
                this.e.fire('afterSetElementValue', data);
            });
        }
    }
    /**
     * Register custom handler for command
     *
     * @example
     * ```javascript
     * var jodit = Jodit.make('#editor);
     *
     * jodit.setEditorValue('test test test');
     *
     * jodit.registerCommand('replaceString', function (command, needle, replace) {
     *      var value = this.getEditorValue();
     *      this.setEditorValue(value.replace(needle, replace));
     *      return false; // stop execute native command
     * });
     *
     * jodit.execCommand('replaceString', 'test', 'stop');
     *
     * console.log(jodit.value); // stop test
     *
     * // and you can add hotkeys for command
     * jodit.registerCommand('replaceString', {
     *    hotkeys: 'ctrl+r',
     *    exec: function (command, needle, replace) {
     *     var value = this.getEditorValue();
     *     this.setEditorValue(value.replace(needle, replace));
     *    }
     * });
     *
     * ```
     */
    registerCommand(commandNameOriginal, command, options) {
        const commandName = commandNameOriginal.toLowerCase();
        let commands = this.commands.get(commandName);
        if (commands === undefined) {
            commands = [];
            this.commands.set(commandName, commands);
        }
        commands.push(command);
        if (!(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isFunction)(command)) {
            const hotkeys = this.o.commandToHotkeys[commandName] ||
                this.o.commandToHotkeys[commandNameOriginal] ||
                command.hotkeys;
            if (hotkeys) {
                this.registerHotkeyToCommand(hotkeys, commandName, options === null || options === void 0 ? void 0 : options.stopPropagation);
            }
        }
        return this;
    }
    /**
     * Register hotkey for command
     */
    registerHotkeyToCommand(hotkeys, commandName, shouldStop = true) {
        const shortcuts = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.asArray)(hotkeys)
            .map(jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.normalizeKeyAliases)
            .map(hotkey => hotkey + '.hotkey')
            .join(' ');
        this.e
            .off(shortcuts)
            .on(shortcuts, (type, stop) => {
            if (stop) {
                stop.shouldStop = shouldStop !== null && shouldStop !== void 0 ? shouldStop : true;
            }
            return this.execCommand(commandName); // because need `beforeCommand`
        });
    }
    /**
     * Execute command editor
     *
     * @param command - command. It supports all the
     * @see https://developer.mozilla.org/ru/docs/Web/API/Document/execCommand#commands and a number of its own
     * for example applyStyleProperty. Comand fontSize receives the second parameter px,
     * formatBlock and can take several options
     * @example
     * ```javascript
     * this.execCommand('fontSize', 12); // sets the size of 12 px
     * this.execCommand('underline');
     * this.execCommand('formatBlock', 'p'); // will be inserted paragraph
     * ```
     */
    execCommand(command, showUI, value, ...args) {
        if (!this.s.isFocused()) {
            this.s.focus();
        }
        if (this.o.readonly &&
            !this.o.allowCommandsInReadOnly.includes(command)) {
            return;
        }
        let result;
        command = command.toLowerCase();
        /**
         * Called before any command
         * @param command - Command name in lowercase
         * @param second - The second parameter for the command
         * @param third - The third option is for the team
         * @example
         * ```javascript
         * parent.e.on('beforeCommand', function (command) {
         *  if (command === 'justifyCenter') {
         *      var p = parent.c.element('p')
         *      parent.s.insertNode(p)
         *      parent.s.setCursorIn(p);
         *      p.style.textAlign = 'justyfy';
         *      return false; // break executes native command
         *  }
         * })
         * ```
         */
        result = this.e.fire(`beforeCommand${(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.ucfirst)(command)}`, showUI, value, ...args);
        if (result !== false) {
            result = this.e.fire('beforeCommand', command, showUI, value, ...args);
        }
        if (result !== false) {
            result = this.__execCustomCommands(command, showUI, value, ...args);
        }
        if (result !== false) {
            this.s.focus();
            try {
                result = this.nativeExecCommand(command, showUI, value);
            }
            catch (e) {
                if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD) {
                    throw e;
                }
            }
        }
        /**
         * It called after any command
         * @param command - name command
         * @param second - The second parameter for the command
         * @param third - The third option is for the team
         */
        this.e.fire('afterCommand', command, showUI, value);
        this.__imdSynchronizeValues(); // synchrony
        return result;
    }
    /**
     * Exec native command
     */
    nativeExecCommand(command, showUI, value) {
        this.__isSilentChange = true;
        try {
            return this.ed.execCommand(command, showUI, value);
        }
        finally {
            this.__isSilentChange = false;
        }
    }
    __execCustomCommands(commandName, second, third, ...args) {
        commandName = commandName.toLowerCase();
        const commands = this.commands.get(commandName);
        if (commands !== undefined) {
            let result;
            commands.forEach((command) => {
                let callback;
                if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isFunction)(command)) {
                    callback = command;
                }
                else {
                    callback = command.exec;
                }
                const resultCurrent = callback.call(this, commandName, second, third, ...args);
                if (resultCurrent !== undefined) {
                    result = resultCurrent;
                }
            });
            return result;
        }
    }
    /**
     * Disable selecting
     */
    lock(name = 'any') {
        if (super.lock(name)) {
            this.__selectionLocked = this.s.save();
            this.s.clear();
            this.editor.classList.add('jodit_lock');
            this.e.fire('lock', true);
            return true;
        }
        return false;
    }
    /**
     * Enable selecting
     */
    unlock() {
        if (super.unlock()) {
            this.editor.classList.remove('jodit_lock');
            if (this.__selectionLocked) {
                this.s.restore();
            }
            this.e.fire('lock', false);
            return true;
        }
        return false;
    }
    /**
     * Return current editor mode: Jodit.MODE_WYSIWYG, Jodit.MODE_SOURCE or Jodit.MODE_SPLIT
     */
    getMode() {
        return this.mode;
    }
    isEditorMode() {
        return this.getRealMode() === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_WYSIWYG;
    }
    /**
     * Return current real work mode. When editor in MODE_SOURCE or MODE_WYSIWYG it will
     * return them, but then editor in MODE_SPLIT it will return MODE_SOURCE if
     * Textarea(CodeMirror) focused or MODE_WYSIWYG otherwise
     *
     * @example
     * ```javascript
     * var editor = Jodit.make('#editor');
     * console.log(editor.getRealMode());
     * ```
     */
    getRealMode() {
        if (this.getMode() !== jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_SPLIT) {
            return this.getMode();
        }
        const active = this.od.activeElement;
        if (active &&
            (active === this.iframe ||
                jodit_modules__WEBPACK_IMPORTED_MODULE_7__.Dom.isOrContains(this.editor, active) ||
                jodit_modules__WEBPACK_IMPORTED_MODULE_7__.Dom.isOrContains(this.toolbar.container, active))) {
            return jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_WYSIWYG;
        }
        return jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_SOURCE;
    }
    /**
     * Set current mode
     */
    setMode(mode) {
        const oldMode = this.getMode();
        const data = {
            mode: parseInt(mode.toString(), 10)
        }, modeClasses = [
            'jodit-wysiwyg_mode',
            'jodit-source__mode',
            'jodit_split_mode'
        ];
        /**
         * Triggered before setMode executed. If returned false method stopped
         * @param data - PlainObject `{mode: {string}}` In handler you can change data.mode
         * @example
         * ```javascript
         * var editor = Jodit.make("#redactor");
         * editor.e.on('beforeSetMode', function (data) {
         *     data.mode = Jodit.MODE_SOURCE; // not respond to the mode change. Always make the source code mode
         * });
         * ```
         */
        if (this.e.fire('beforeSetMode', data) === false) {
            return;
        }
        this.__mode = [
            jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_SOURCE,
            jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_WYSIWYG,
            jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_SPLIT
        ].includes(data.mode)
            ? data.mode
            : jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_WYSIWYG;
        if (this.o.saveModeInStorage) {
            this.storage.set('jodit_default_mode', this.mode);
        }
        modeClasses.forEach(className => {
            this.container.classList.remove(className);
        });
        this.container.classList.add(modeClasses[this.mode - 1]);
        /**
         * Triggered after setMode executed
         * @example
         * ```javascript
         * var editor = Jodit.make("#redactor");
         * editor.e.on('afterSetMode', function () {
         *     editor.setEditorValue(''); // clear editor's value after change mode
         * });
         * ```
         */
        if (oldMode !== this.getMode()) {
            this.e.fire('afterSetMode');
        }
    }
    /**
     * Toggle editor mode WYSIWYG to TEXTAREA(CodeMirror) to SPLIT(WYSIWYG and TEXTAREA) to again WYSIWYG
     *
     * @example
     * ```javascript
     * var editor = Jodit.make('#editor');
     * editor.toggleMode();
     * ```
     */
    toggleMode() {
        let mode = this.getMode();
        if ([
            jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_SOURCE,
            jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_WYSIWYG,
            this.o.useSplitMode ? jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_SPLIT : 9
        ].includes(mode + 1)) {
            mode += 1;
        }
        else {
            mode = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_WYSIWYG;
        }
        this.setMode(mode);
    }
    /**
     * Switch on/off the editor into the disabled state.
     * When disabled, the user is not able to change the editor content
     * This function firing the `disabled` event.
     */
    setDisabled(isDisabled) {
        this.o.disabled = isDisabled;
        const readOnly = this.__wasReadOnly;
        this.setReadOnly(isDisabled || readOnly);
        this.__wasReadOnly = readOnly;
        if (this.editor) {
            this.editor.setAttribute('aria-disabled', isDisabled.toString());
            this.container.classList.toggle('jodit_disabled', isDisabled);
            this.e.fire('disabled', isDisabled);
        }
    }
    /**
     * Return true if editor in disabled mode
     */
    getDisabled() {
        return this.o.disabled;
    }
    /**
     * Switch on/off the editor into the read-only state.
     * When in readonly, the user is not able to change the editor content, but can still
     * use some editor functions (show source code, print content, or seach).
     * This function firing the `readonly` event.
     */
    setReadOnly(isReadOnly) {
        if (this.__wasReadOnly === isReadOnly) {
            return;
        }
        this.__wasReadOnly = isReadOnly;
        this.o.readonly = isReadOnly;
        if (isReadOnly) {
            this.editor && this.editor.removeAttribute('contenteditable');
        }
        else {
            this.editor && this.editor.setAttribute('contenteditable', 'true');
        }
        this.e && this.e.fire('readonly', isReadOnly);
    }
    /**
     * Return true if editor in read-only mode
     */
    getReadOnly() {
        return this.o.readonly;
    }
    focus() {
        if (this.getMode() !== jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_SOURCE) {
            this.s.focus();
        }
    }
    get isFocused() {
        return this.s.isFocused();
    }
    /**
     * Hook before init
     */
    beforeInitHook() {
        // do nothing
    }
    /**
     * Hook after init
     */
    afterInitHook() {
        // do nothing
    }
    /** @override **/
    initOptions(options) {
        this.options = ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.ConfigProto)(options || {}, jodit_config__WEBPACK_IMPORTED_MODULE_6__/* .Config */ .T.defaultOptions));
    }
    /** @override **/
    initOwners() {
        // in iframe, it can be changed
        this.editorWindow = this.o.ownerWindow;
        this.ownerWindow = this.o.ownerWindow;
    }
    /**
     * Create instance of Jodit
     *
     * @param element - Selector or HTMLElement
     * @param options - Editor's options
     */
    constructor(element, options) {
        super(options, true);
        /**
         * Define if object is Jodit
         */
        this.isJodit = true;
        this.commands = new Map();
        this.__selectionLocked = null;
        this.__wasReadOnly = false;
        /**
         * Editor has focus in this time
         */
        this.editorIsActive = false;
        this.__mode = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_WYSIWYG;
        this.__callChangeCount = 0;
        /**
         * Don't raise a change event
         */
        this.__isSilentChange = false;
        this.__elementToPlace = new Map();
        try {
            const elementSource = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.resolveElement)(element, this.o.shadowRoot || this.od);
            if (Jodit_1.isJoditAssigned(elementSource)) {
                // @ts-ignore
                return elementSource.component;
            }
        }
        catch (e) {
            this.destruct();
            throw e;
        }
        this.setStatus(jodit_modules__WEBPACK_IMPORTED_MODULE_7__.STATUSES.beforeInit);
        this.id =
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.resolveElement)(element, this.o.shadowRoot || this.od), 'id') ||
                new Date().getTime().toString();
        jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .instances */ .VF[this.id] = this;
        this.attachEvents(options);
        this.e.on(this.ow, 'resize', () => {
            if (this.e) {
                this.e.fire('resize');
            }
        });
        this.e.on('prepareWYSIWYGEditor', this.__prepareWYSIWYGEditor);
        this.selection = new jodit_modules__WEBPACK_IMPORTED_MODULE_7__.Selection(this);
        const beforeInitHookResult = this.beforeInitHook();
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.callPromise)(beforeInitHookResult, () => {
            if (this.isInDestruct) {
                return;
            }
            this.e.fire('beforeInit', this);
            jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .pluginSystem */ .fg.__init(this);
            this.e.fire('afterPluginSystemInit', this);
            this.e.on('changePlace', () => {
                this.setReadOnly(this.o.readonly);
                this.setDisabled(this.o.disabled);
            });
            this.places.length = 0;
            const addPlaceResult = this.addPlace(element, options);
            jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .instances */ .VF[this.id] = this;
            const init = () => {
                if (this.isInDestruct) {
                    return;
                }
                if (this.e) {
                    this.e.fire('afterInit', this);
                }
                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.callPromise)(this.afterInitHook());
                this.setStatus(jodit_modules__WEBPACK_IMPORTED_MODULE_7__.STATUSES.ready);
                this.e.fire('afterConstructor', this);
            };
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.callPromise)(addPlaceResult, init);
        });
    }
    /**
     * Create and init current editable place
     */
    addPlace(source, options) {
        const element = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.resolveElement)(source, this.o.shadowRoot || this.od);
        this.attachEvents(options);
        if (element.attributes) {
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.toArray)(element.attributes).forEach((attr) => {
                const name = attr.name;
                let value = attr.value;
                if (jodit_config__WEBPACK_IMPORTED_MODULE_6__/* .Config */ .T.defaultOptions[name] !== undefined &&
                    (!options || options[name] === undefined)) {
                    if (['readonly', 'disabled'].indexOf(name) !== -1) {
                        value = value === '' || value === 'true';
                    }
                    if (/^[0-9]+(\.)?([0-9]+)?$/.test(value.toString())) {
                        value = Number(value);
                    }
                    this.options[name] = value;
                }
            });
        }
        let container = this.c.div('jodit-container');
        container.classList.add('jodit');
        container.classList.add('jodit-container');
        container.classList.add(`jodit_theme_${this.o.theme || 'default'}`);
        addClassNames(this.o.className, container);
        if (this.o.containerStyle) {
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.css)(container, this.o.containerStyle);
        }
        const { styleValues } = this.o;
        Object.keys(styleValues).forEach(key => {
            const property = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.kebabCase)(key);
            container.style.setProperty(`--jd-${property}`, styleValues[key]);
        });
        container.setAttribute('contenteditable', 'false');
        let buffer = null;
        if (this.o.inline) {
            if (['TEXTAREA', 'INPUT'].indexOf(element.nodeName) === -1) {
                container = element;
                element.setAttribute(__defaultClassesKey, element.className.toString());
                buffer = container.innerHTML;
                container.innerHTML = '';
            }
            container.classList.add('jodit_inline');
            container.classList.add('jodit-container');
        }
        // actual for inline mode
        if (element !== container) {
            // hide source element
            if (element.style.display) {
                element.setAttribute(__defaultStyleDisplayKey, element.style.display);
            }
            element.style.display = 'none';
        }
        const workplace = this.c.div('jodit-workplace', {
            contenteditable: false
        });
        container.appendChild(workplace);
        if (element.parentNode && element !== container) {
            element.parentNode.insertBefore(container, element);
        }
        Object.defineProperty(element, 'component', {
            enumerable: false,
            configurable: true,
            value: this
        });
        const editor = this.c.div('jodit-wysiwyg', {
            contenteditable: true,
            'aria-disabled': false,
            tabindex: this.o.tabIndex
        });
        workplace.appendChild(editor);
        const currentPlace = {
            editor,
            element,
            container,
            workplace,
            statusbar: new jodit_modules__WEBPACK_IMPORTED_MODULE_7__.StatusBar(this, container),
            options: this.isReady
                ? (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.ConfigProto)(options || {}, jodit_config__WEBPACK_IMPORTED_MODULE_6__/* .Config */ .T.defaultOptions)
                : this.options,
            history: new jodit_modules__WEBPACK_IMPORTED_MODULE_7__.History(this),
            editorWindow: this.ow
        };
        this.__elementToPlace.set(editor, currentPlace);
        this.setCurrentPlace(currentPlace);
        this.places.push(currentPlace);
        this.setNativeEditorValue(this.getElementValue()); // Init value
        const initResult = this.__initEditor(buffer);
        const opt = this.options;
        const init = () => {
            if (opt.enableDragAndDropFileToEditor &&
                opt.uploader &&
                (opt.uploader.url || opt.uploader.insertImageAsBase64URI)) {
                this.uploader.bind(this.editor);
            }
            // in initEditor - the editor could change
            if (!this.__elementToPlace.get(this.editor)) {
                this.__elementToPlace.set(this.editor, currentPlace);
            }
            this.e.fire('afterAddPlace', currentPlace);
        };
        return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.callPromise)(initResult, init);
    }
    addDisclaimer(elm) {
        this.workplace.appendChild(elm);
    }
    /**
     * Set current place object
     */
    setCurrentPlace(place) {
        if (this.currentPlace === place) {
            return;
        }
        if (!this.isEditorMode()) {
            this.setMode(jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_WYSIWYG);
        }
        this.currentPlace = place;
        this.buildToolbar();
        if (this.isReady) {
            this.e.fire('changePlace', place);
        }
    }
    __initEditor(buffer) {
        const result = this.__createEditor();
        return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.callPromise)(result, () => {
            if (this.isInDestruct) {
                return;
            }
            // syncro
            if (this.element !== this.container) {
                const value = this.getElementValue();
                if (value !== this.getEditorValue()) {
                    this.setEditorValue(value);
                }
            }
            else {
                buffer != null && this.setEditorValue(buffer); // inline mode
            }
            let mode = this.o.defaultMode;
            if (this.o.saveModeInStorage) {
                const localMode = this.storage.get('jodit_default_mode');
                if (typeof localMode === 'string') {
                    mode = parseInt(localMode, 10);
                }
            }
            this.setMode(mode);
            if (this.o.readonly) {
                this.__wasReadOnly = false;
                this.setReadOnly(true);
            }
            if (this.o.disabled) {
                this.setDisabled(true);
            }
            // if enter plugin isn't installed
            try {
                this.ed.execCommand('defaultParagraphSeparator', false, this.o.enter.toLowerCase());
            }
            catch (_a) { }
        });
    }
    /**
     * Create main DIV element and replace source textarea
     */
    __createEditor() {
        const defaultEditorArea = this.editor;
        const stayDefault = this.e.fire('createEditor', this);
        return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.callPromise)(stayDefault, () => {
            if (this.isInDestruct) {
                return;
            }
            if (stayDefault === false || (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isPromise)(stayDefault)) {
                jodit_modules__WEBPACK_IMPORTED_MODULE_7__.Dom.safeRemove(defaultEditorArea);
            }
            addClassNames(this.o.editorClassName, this.editor);
            if (this.o.style) {
                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.css)(this.editor, this.o.style);
            }
            this.e
                .on('synchro', () => {
                this.setEditorValue();
            })
                .on('focus', () => {
                this.editorIsActive = true;
            })
                .on('blur', () => (this.editorIsActive = false));
            this.__prepareWYSIWYGEditor();
            // direction
            if (this.o.direction) {
                const direction = this.o.direction.toLowerCase() === 'rtl' ? 'rtl' : 'ltr';
                this.container.style.direction = direction;
                this.container.setAttribute('dir', direction);
                this.toolbar.setDirection(direction);
            }
            if (this.o.triggerChangeEvent) {
                this.e.on('change', this.async.debounce(() => {
                    this.e && this.e.fire(this.element, 'change');
                }, this.defaultTimeout));
            }
        });
    }
    /**
     * Attach some native event listeners
     */
    __prepareWYSIWYGEditor() {
        const { editor } = this;
        // direction
        if (this.o.direction) {
            const direction = this.o.direction.toLowerCase() === 'rtl' ? 'rtl' : 'ltr';
            this.editor.style.direction = direction;
            this.editor.setAttribute('dir', direction);
        }
        // proxy events
        this.e
            .on(editor, 'mousedown touchstart focus', () => {
            const place = this.__elementToPlace.get(editor);
            if (place) {
                this.setCurrentPlace(place);
            }
        })
            .on(editor, 'compositionend', this.synchronizeValues)
            .on(editor, 'selectionchange selectionstart keydown keyup input keypress dblclick mousedown mouseup ' +
            'click copy cut dragstart drop dragover paste resize touchstart touchend focus blur', (event) => {
            if (this.o.readonly || this.__isSilentChange) {
                return;
            }
            const w = this.ew;
            if (event instanceof w.KeyboardEvent &&
                event.isComposing) {
                return;
            }
            if (this.e && this.e.fire) {
                if (this.e.fire(event.type, event) === false) {
                    return false;
                }
                this.synchronizeValues();
            }
        });
    }
    fetch(url, options) {
        const ajax = new jodit_core_request__WEBPACK_IMPORTED_MODULE_4__/* .Ajax */ .d(Object.assign({ url }, options), this.o.defaultAjaxOptions);
        const destroy = () => {
            this.e.off('beforeDestruct', destroy);
            this.progressbar.progress(100).hide();
            ajax.destruct();
        };
        this.e.one('beforeDestruct', destroy);
        this.progressbar.show().progress(30);
        const promise = ajax.send();
        promise.finally(destroy).catch(() => null);
        return promise;
    }
    /**
     * Jodit's Destructor. Remove editor, and return source input
     */
    destruct() {
        if (this.isInDestruct) {
            return;
        }
        this.setStatus(jodit_modules__WEBPACK_IMPORTED_MODULE_7__.STATUSES.beforeDestruct);
        this.__elementToPlace.clear();
        this.storage.clear();
        this.buffer.clear();
        this.commands.clear();
        this.__selectionLocked = null;
        this.e.off(this.ow, 'resize');
        this.e.off(this.ow);
        this.e.off(this.od);
        this.e.off(this.od.body);
        const buffer = this.editor ? this.getEditorValue() : '';
        this.places.forEach(({ container, workplace, statusbar, element, iframe, editor, history }) => {
            if (!element) {
                return;
            }
            if (element !== container) {
                if (element.hasAttribute(__defaultStyleDisplayKey)) {
                    const display = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(element, __defaultStyleDisplayKey);
                    if (display) {
                        element.style.display = display;
                        element.removeAttribute(__defaultStyleDisplayKey);
                    }
                }
                else {
                    element.style.display = '';
                }
            }
            else {
                if (element.hasAttribute(__defaultClassesKey)) {
                    element.className =
                        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(element, __defaultClassesKey) || '';
                    element.removeAttribute(__defaultClassesKey);
                }
            }
            if (element.hasAttribute('style') && !(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(element, 'style')) {
                element.removeAttribute('style');
            }
            statusbar.destruct();
            this.e.off(container);
            this.e.off(element);
            this.e.off(editor);
            jodit_modules__WEBPACK_IMPORTED_MODULE_7__.Dom.safeRemove(workplace);
            jodit_modules__WEBPACK_IMPORTED_MODULE_7__.Dom.safeRemove(editor);
            if (container !== element) {
                jodit_modules__WEBPACK_IMPORTED_MODULE_7__.Dom.safeRemove(container);
            }
            Object.defineProperty(element, 'component', {
                enumerable: false,
                configurable: true,
                value: null
            });
            jodit_modules__WEBPACK_IMPORTED_MODULE_7__.Dom.safeRemove(iframe);
            // inline mode
            if (container === element) {
                element.innerHTML = buffer;
            }
            history.destruct();
        });
        this.places.length = 0;
        this.currentPlace = {};
        delete jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .instances */ .VF[this.id];
        super.destruct();
    }
};
Jodit.fatMode = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.FAT_MODE;
Jodit.plugins = jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .pluginSystem */ .fg;
Jodit.modules = jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .modules */ .av;
Jodit.ns = jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .modules */ .av;
Jodit.decorators = {};
Jodit.constants = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__;
Jodit.instances = jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .instances */ .VF;
Jodit.lang = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.lang;
Jodit.core = {
    Plugin: jodit_modules__WEBPACK_IMPORTED_MODULE_7__.Plugin
};
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.cache
], Jodit.prototype, "createInside", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.cache
], Jodit.prototype, "message", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.cache
], Jodit.prototype, "s", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.cache
], Jodit.prototype, "uploader", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.cache
], Jodit.prototype, "filebrowser", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.throttle)()
], Jodit.prototype, "synchronizeValues", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.watch)(':internalChange')
], Jodit.prototype, "updateElementValue", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], Jodit.prototype, "__prepareWYSIWYGEditor", null);
Jodit = Jodit_1 = (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.derive)(jodit_core_traits_dlgs__WEBPACK_IMPORTED_MODULE_5__/* .Dlgs */ .z)
], Jodit);

function addClassNames(className, elm) {
    if (className) {
        className.split(/\s+/).forEach(cn => elm.classList.add(cn));
    }
}


/***/ }),

/***/ 74470:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(37923);
/* harmony import */ var jodit_langs_ar__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(41324);
/* harmony import */ var jodit_langs_ar__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(jodit_langs_ar__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var jodit_langs_cs_cz__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(56014);
/* harmony import */ var jodit_langs_de__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(95461);
/* harmony import */ var jodit_langs_en__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(63837);
/* harmony import */ var jodit_langs_es__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(39386);
/* harmony import */ var jodit_langs_fr__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(25090);
/* harmony import */ var jodit_langs_hu__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(81321);
/* harmony import */ var jodit_langs_it__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(31927);
/* harmony import */ var jodit_langs_ja__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(21195);
/* harmony import */ var jodit_langs_keys__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(53414);
/* harmony import */ var jodit_langs_nl__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(3268);
/* harmony import */ var jodit_langs_pl__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(97834);
/* harmony import */ var jodit_langs_pt_br__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(86433);
/* harmony import */ var jodit_langs_tr__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(68368);
/* harmony import */ var jodit_langs_zh_cn__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(25182);
/* harmony import */ var jodit_langs_zh_tw__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(44906);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */























let exp = {};
exp = {
    ar: (jodit_langs_ar__WEBPACK_IMPORTED_MODULE_0___default()),
    cs_cz: jodit_langs_cs_cz__WEBPACK_IMPORTED_MODULE_1__,
    de: jodit_langs_de__WEBPACK_IMPORTED_MODULE_2__,
    en: jodit_langs_en__WEBPACK_IMPORTED_MODULE_3__,
    es: jodit_langs_es__WEBPACK_IMPORTED_MODULE_4__,
    fi: (jodit_langs_ar__WEBPACK_IMPORTED_MODULE_0___default()),
    fr: jodit_langs_fr__WEBPACK_IMPORTED_MODULE_5__,
    he: (jodit_langs_ar__WEBPACK_IMPORTED_MODULE_0___default()),
    hu: jodit_langs_hu__WEBPACK_IMPORTED_MODULE_6__,
    id: (jodit_langs_ar__WEBPACK_IMPORTED_MODULE_0___default()),
    it: jodit_langs_it__WEBPACK_IMPORTED_MODULE_7__,
    ja: jodit_langs_ja__WEBPACK_IMPORTED_MODULE_8__,
    ko: (jodit_langs_ar__WEBPACK_IMPORTED_MODULE_0___default()),
    mn: (jodit_langs_ar__WEBPACK_IMPORTED_MODULE_0___default()),
    nl: jodit_langs_nl__WEBPACK_IMPORTED_MODULE_10__,
    pl: jodit_langs_pl__WEBPACK_IMPORTED_MODULE_11__,
    pt_br: jodit_langs_pt_br__WEBPACK_IMPORTED_MODULE_12__,
    ru: (jodit_langs_ar__WEBPACK_IMPORTED_MODULE_0___default()),
    tr: jodit_langs_tr__WEBPACK_IMPORTED_MODULE_13__,
    zh_cn: jodit_langs_zh_cn__WEBPACK_IMPORTED_MODULE_14__,
    zh_tw: jodit_langs_zh_tw__WEBPACK_IMPORTED_MODULE_15__
};
/* Unpack array to hash */
const get = (value) => value ? value.default || value : {}, hashLang = {};
if ((0,jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_16__/* .isArray */ .c)(get(jodit_langs_keys__WEBPACK_IMPORTED_MODULE_9__))) {
    get(jodit_langs_keys__WEBPACK_IMPORTED_MODULE_9__).forEach((key, index) => {
        hashLang[index] = key;
    });
}
Object.keys(exp).forEach((lang) => {
    const list = get(exp[lang]);
    if ((0,jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_16__/* .isArray */ .c)(list)) {
        exp[lang] = {};
        list.forEach((value, index) => {
            exp[lang][hashLang[index]] = value;
        });
    }
    else {
        exp[lang] = list;
    }
});
/* harmony default export */ __webpack_exports__.A = (exp);


/***/ }),

/***/ 34248:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   t: function() { return /* binding */ ContextMenu; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(24767);
/* harmony import */ var jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(37923);
/* harmony import */ var jodit_core_ui_button_button_button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(92032);
/* harmony import */ var jodit_core_ui_popup_popup__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(80071);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */






/**
 * Module to generate context menu
 */
let ContextMenu = class ContextMenu extends jodit_core_ui_popup_popup__WEBPACK_IMPORTED_MODULE_1__/* .Popup */ .z {
    /** @override */
    className() {
        return 'ContextMenu';
    }
    /**
     * Generate and show context menu
     *
     * @param x - Global coordinate by X
     * @param y - Global coordinate by Y
     * @param actions - Array with plain objects `{icon: 'bin', title: 'Delete', exec: function () {}}`
     * @example
     * ```javascript
     * parent.show(e.clientX, e.clientY, [{icon: 'bin', title: 'Delete', exec: function () { alert(1) }}]);
     * ```
     */
    show(x, y, actions) {
        const self = this;
        self.clear();
        if (!(0,jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_2__/* .isArray */ .c)(actions)) {
            return;
        }
        actions.forEach(item => {
            if (!item) {
                return;
            }
            const action = (0,jodit_core_ui_button_button_button__WEBPACK_IMPORTED_MODULE_0__/* .Button */ .$n)(this.jodit, item.icon || 'empty', item.title);
            this.jodit && action.setParentView(this.jodit);
            action.setMod('context', 'menu');
            action.onAction((e) => {
                var _a;
                (_a = item.exec) === null || _a === void 0 ? void 0 : _a.call(self, e);
                self.clear();
                self.close();
                return false;
            });
            this.append(action);
        });
        this.open(() => ({ left: x, top: y, width: 0, height: 0 }), true);
    }
};
ContextMenu = (0,tslib__WEBPACK_IMPORTED_MODULE_3__/* .__decorate */ .Cg)([
    jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_4__/* .component */ .s
], ContextMenu);



/***/ }),

/***/ 5854:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   F: function() { return /* binding */ Alert; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_array_as_array__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(82317);
/* harmony import */ var jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(69052);
/* harmony import */ var jodit_core_ui_button_button_button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(92032);
/* harmony import */ var _dialog__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(58006);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */





/**
 * Show `alert` dialog. Work without Jodit object
 * @example
 * ```javascript
 * Jodit.Alert("File was uploaded");
 * Jodit.Alert("File was uploaded", "Message");
 * Jodit.Alert("File was uploaded", function() {
 *    $('form').hide();
 * });
 * Jodit.Alert("File wasn't uploaded", "Error", function() {
 *    $('form').hide();
 * });
 * ```
 */
function Alert(msg, title, callback, className = 'jodit-dialog_alert') {
    if ((0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_3__/* .isFunction */ .T)(title)) {
        callback = title;
        title = undefined;
    }
    const dialog = this instanceof _dialog__WEBPACK_IMPORTED_MODULE_2__/* .Dialog */ .l
        ? this
        : new _dialog__WEBPACK_IMPORTED_MODULE_2__/* .Dialog */ .l({ closeOnClickOverlay: true }), container = dialog.c.div(className), okButton = (0,jodit_core_ui_button_button_button__WEBPACK_IMPORTED_MODULE_1__/* .Button */ .$n)(dialog, 'ok', 'Ok');
    (0,jodit_core_helpers_array_as_array__WEBPACK_IMPORTED_MODULE_4__/* .asArray */ ._)(msg).forEach(oneMessage => {
        container.appendChild(jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isNode(oneMessage) ? oneMessage : dialog.c.fromHTML(oneMessage));
    });
    okButton.onAction(() => {
        if (!callback || !(0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_3__/* .isFunction */ .T)(callback) || callback(dialog) !== false) {
            dialog.close();
        }
    });
    dialog.setFooter([okButton]);
    dialog.open(container, title || '&nbsp;', true, true);
    okButton.focus();
    return dialog;
}


/***/ }),

/***/ 23132:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   p: function() { return /* binding */ Confirm; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(69052);
/* harmony import */ var jodit_core_ui_button_button_button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(92032);
/* harmony import */ var jodit_modules_dialog_dialog__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(58006);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



/**
 * Show `confirm` dialog. Work without Jodit object
 *
 * @param title - Title or callback
 * @param callback - callback. The first argument is the value entered
 * @example
 * ```javascript
 * Jodit.Confirm("Are you sure?", "Confirm Dialog", function (yes) {
 *     if (yes) {
 *         // do something
 *     }
 * });
 * ```
 */
function Confirm(msg, title, callback) {
    const dialog = this instanceof jodit_modules_dialog_dialog__WEBPACK_IMPORTED_MODULE_1__/* .Dialog */ .l
        ? this
        : new jodit_modules_dialog_dialog__WEBPACK_IMPORTED_MODULE_1__/* .Dialog */ .l({ closeOnClickOverlay: true }), $div = dialog.c.fromHTML('<form class="jodit-dialog_prompt"></form>'), $label = dialog.c.element('label');
    if ((0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_2__/* .isFunction */ .T)(title)) {
        callback = title;
        title = undefined;
    }
    $label.appendChild(dialog.c.fromHTML(msg));
    $div.appendChild($label);
    const action = (yes) => () => {
        if (!callback || callback(yes) !== false) {
            dialog.close();
        }
    };
    const $cancel = (0,jodit_core_ui_button_button_button__WEBPACK_IMPORTED_MODULE_0__/* .Button */ .$n)(dialog, 'cancel', 'Cancel');
    const $ok = (0,jodit_core_ui_button_button_button__WEBPACK_IMPORTED_MODULE_0__/* .Button */ .$n)(dialog, 'ok', 'Yes');
    $cancel.onAction(action(false));
    $ok.onAction(action(true));
    dialog.e.on($div, 'submit', () => {
        action(true)();
        return false;
    });
    dialog.setFooter([$ok, $cancel]);
    dialog.open($div, title || '&nbsp;', true, true);
    $ok.focus();
    return dialog;
}


/***/ }),

/***/ 58006:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   l: function() { return /* binding */ Dialog; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(77753);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers_array__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(32709);
/* harmony import */ var jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(9823);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(97369);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(28712);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var jodit_core_ui__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(53048);
/* harmony import */ var jodit_core_view_view__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(77782);
/* harmony import */ var jodit_core_view_view_with_toolbar__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(14961);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(36115);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
var Dialog_1;















jodit_config__WEBPACK_IMPORTED_MODULE_12__/* .Config */ .T.prototype.dialog = {
    namespace: '',
    extraButtons: [],
    /**
     * This dialog can resize by trigger
     */
    resizable: true,
    /**
     * This dialog can move by header
     */
    draggable: true,
    buttons: ['dialog.close'],
    removeButtons: [],
    toolbarButtonSize: 'middle',
    zIndex: 'inherit'
};
jodit_config__WEBPACK_IMPORTED_MODULE_12__/* .Config */ .T.prototype.controls.dialog = {
    close: {
        icon: 'cancel',
        exec: dialog => {
            dialog.close();
        }
    }
};
/**
 * Module to generate dialog windows
 */
let Dialog = Dialog_1 = class Dialog extends jodit_core_view_view_with_toolbar__WEBPACK_IMPORTED_MODULE_11__/* .ViewWithToolbar */ .T {
    /** @override */
    className() {
        return 'Dialog';
    }
    get destination() {
        var _a;
        return ((_a = this.o.shadowRoot) !== null && _a !== void 0 ? _a : this.od.body);
    }
    setElements(root, elements) {
        const elements_list = [];
        (0,jodit_core_helpers_array__WEBPACK_IMPORTED_MODULE_5__/* .asArray */ ._j)(elements).forEach((elm) => {
            if ((0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_6__/* .isArray */ .cy)(elm)) {
                const div = this.c.div(this.getFullElName('column'));
                elements_list.push(div);
                root.appendChild(div);
                return this.setElements(div, elm);
            }
            let element;
            if ((0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_6__/* .isString */ .Kg)(elm)) {
                element = this.c.fromHTML(elm);
            }
            else {
                element = (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_6__/* .hasContainer */ .kO)(elm) ? elm.container : elm;
            }
            elements_list.push(element);
            if (element.parentNode !== root) {
                root.appendChild(element);
            }
        });
        (0,jodit_core_helpers_array__WEBPACK_IMPORTED_MODULE_5__/* .toArray */ .$r)(root.childNodes).forEach((elm) => {
            if (elements_list.indexOf(elm) === -1) {
                root.removeChild(elm);
            }
        });
    }
    onMouseUp() {
        if (this.draggable || this.resizable) {
            this.removeGlobalResizeListeners();
            this.draggable = false;
            this.resizable = false;
            this.unlockSelect();
            if (this.e) {
                this.removeGlobalResizeListeners();
                /**
                 * Fired when the dialog box is finished to resizing
                 */
                this.e.fire(this, 'endResize endMove');
            }
        }
    }
    /**
     *
     */
    onHeaderMouseDown(e) {
        const target = e.target;
        if (!this.o.draggable ||
            (target && target.nodeName.match(/^(INPUT|SELECT)$/))) {
            return;
        }
        this.draggable = true;
        this.startX = e.clientX;
        this.startY = e.clientY;
        this.startPoint.x = (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_7__.css)(this.dialog, 'left');
        this.startPoint.y = (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_7__.css)(this.dialog, 'top');
        this.setMaxZIndex();
        if (e.cancelable) {
            e.preventDefault();
        }
        this.lockSelect();
        this.addGlobalResizeListeners();
        if (this.e) {
            /**
             * Fired when dialog box is started moving
             */
            this.e.fire(this, 'startMove');
            this.e.fire('closeAllPopups');
        }
    }
    onMouseMove(e) {
        if (this.draggable && this.o.draggable) {
            this.setPosition(this.startPoint.x + e.clientX - this.startX, this.startPoint.y + e.clientY - this.startY);
            if (this.e) {
                /**
                 * Fired when dialog box is moved
                 */
                this.e.fire(this, 'move', e.clientX - this.startX, e.clientY - this.startY);
            }
            e.stopImmediatePropagation();
        }
        if (this.resizable && this.o.resizable) {
            this.setSize(this.startPoint.w + e.clientX - this.startX, this.startPoint.h + e.clientY - this.startY);
            if (this.e) {
                /**
                 * Fired when dialog box is resized
                 */
                this.e.fire(this, 'resizeDialog', e.clientX - this.startX, e.clientY - this.startY);
            }
        }
    }
    onEsc(e) {
        if (!this.o.closeOnEsc) {
            return;
        }
        if (this.isOpened &&
            e.key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.KEY_ESC &&
            this.getMod('static') !== true) {
            const me = this.getMaxZIndexDialog();
            if (me) {
                me.close();
            }
            else {
                this.close();
            }
            e.stopImmediatePropagation();
        }
    }
    onResizerMouseDown(e) {
        this.resizable = true;
        this.startX = e.clientX;
        this.startY = e.clientY;
        this.startPoint.w = this.dialog.offsetWidth;
        this.startPoint.h = this.dialog.offsetHeight;
        this.lockSelect();
        this.addGlobalResizeListeners();
        if (this.e) {
            /**
             * Fired when dialog box is started resizing
             */
            this.e.fire(this, 'startResize');
        }
    }
    addGlobalResizeListeners() {
        const self = this;
        self.e
            .on(self.ow, 'pointermove touchmove', self.onMouseMove)
            .on(self.ow, 'pointerup touchend', self.onMouseUp);
    }
    removeGlobalResizeListeners() {
        const self = this;
        self.e
            .off(self.ow, 'mousemove pointermove', self.onMouseMove)
            .off(self.ow, 'mouseup pointerup', self.onMouseUp);
    }
    /**
     * Specifies the size of the window
     *
     * @param w - The width of the window
     * @param h - The height of the window
     */
    setSize(w, h) {
        if (w == null) {
            w = this.dialog.offsetWidth;
        }
        if (h == null) {
            h = this.dialog.offsetHeight;
        }
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_7__.css)(this.dialog, {
            width: w,
            height: h
        });
        return this;
    }
    /**
     * Recalculate auto sizes
     */
    calcAutoSize() {
        this.setSize('auto', 'auto');
        this.setSize();
        return this;
    }
    /**
     * Specifies the position of the upper left corner of the window . If x and y are specified,
     * the window is centered on the center of the screen
     *
     * @param x - Position px Horizontal
     * @param y - Position px Vertical
     */
    setPosition(x, y) {
        const w = this.ow.innerWidth, h = this.ow.innerHeight;
        let left = w / 2 - this.dialog.offsetWidth / 2, top = h / 2 - this.dialog.offsetHeight / 2;
        if (left < 0) {
            left = 0;
        }
        if (top < 0) {
            top = 0;
        }
        if (x !== undefined && y !== undefined) {
            this.offsetX = x;
            this.offsetY = y;
            this.moved = Math.abs(x - left) > 100 || Math.abs(y - top) > 100;
        }
        this.dialog.style.left = (x || left) + 'px';
        this.dialog.style.top = (y || top) + 'px';
        return this;
    }
    /**
     * Specifies the dialog box title . It can take a string and an array of objects
     *
     * @param content - A string or an HTML element ,
     * or an array of strings and elements
     * @example
     * ```javascript
     * var dialog = new Jodi.modules.Dialog(parent);
     * dialog.setHeader('Hello world');
     * dialog.setHeader(['Hello world', '<button>OK</button>', $('<div>some</div>')]);
     * dialog.open();
     * ```
     */
    setHeader(content) {
        this.setElements(this.dialogbox_header, content);
        return this;
    }
    /**
     * It specifies the contents of the dialog box. It can take a string and an array of objects
     *
     * @param content - A string or an HTML element ,
     * or an array of strings and elements
     * @example
     * ```javascript
     * var dialog = new Jodi.modules.Dialog(parent);
     * dialog.setHeader('Hello world');
     * dialog.setContent('<form onsubmit="alert(1);"><input type="text" /></form>');
     * dialog.open();
     * ```
     */
    setContent(content) {
        this.setElements(this.dialogbox_content, content);
        return this;
    }
    /**
     * Sets the bottom of the dialog. It can take a string and an array of objects
     *
     * @param content - A string or an HTML element ,
     * or an array of strings and elements
     * @example
     * ```javascript
     * var dialog = new Jodi.modules.Dialog(parent);
     * dialog.setHeader('Hello world');
     * dialog.setContent('<form><input id="someText" type="text" /></form>');
     * dialog.setFooter([
     *  $('<a class="jodit-button">OK</a>').click(function () {
     *      alert($('someText').val())
     *      dialog.close();
     *  })
     * ]);
     * dialog.open();
     * ```
     */
    setFooter(content) {
        this.setElements(this.dialogbox_footer, content);
        this.setMod('footer', Boolean(content));
        return this;
    }
    /**
     * Get zIndex from dialog
     */
    getZIndex() {
        return parseInt((0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_7__.css)(this.container, 'zIndex'), 10) || 0;
    }
    /**
     * Get dialog instance with maximum z-index displaying it on top of all the dialog boxes
     */
    getMaxZIndexDialog() {
        let maxZi = 0, dlg, zIndex, res = this;
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_7__.$$)('.jodit-dialog', this.destination).forEach((dialog) => {
            dlg = dialog.component;
            zIndex = parseInt((0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_7__.css)(dialog, 'zIndex'), 10);
            if (dlg.isOpened && !isNaN(zIndex) && zIndex > maxZi) {
                res = dlg;
                maxZi = zIndex;
            }
        });
        return res;
    }
    /**
     * Sets the maximum z-index dialog box, displaying it on top of all the dialog boxes
     */
    setMaxZIndex() {
        if (this.getMod('static'))
            return;
        let maxZIndex = 20000004, zIndex = 0;
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_7__.$$)('.jodit-dialog', this.destination).forEach(dialog => {
            zIndex = parseInt((0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_7__.css)(dialog, 'zIndex'), 10);
            maxZIndex = Math.max(isNaN(zIndex) ? 0 : zIndex, maxZIndex);
        });
        this.container.style.zIndex = (maxZIndex + 1).toString();
    }
    /**
     * Expands the dialog on full browser window
     */
    toggleFullSize(isFullSize) {
        if ((0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_6__/* .isVoid */ .Rd)(isFullSize)) {
            isFullSize = !this.getMod('fullsize');
        }
        this.setMod('fullsize', isFullSize);
        super.toggleFullSize(isFullSize);
    }
    /**
     * It opens a dialog box to center it, and causes the two event.
     *
     * @param contentOrClose - specifies the contents of the dialog box.
     * Can be false or undefined. see [[Dialog.setContent]]
     * @param title - specifies the title of the dialog box, @see setHeader
     * @param destroyAfterClose - true - After closing the window , the destructor will be called.
     * @param modal - true window will be opened in modal mode
     */
    open(contentOrClose, titleOrModal, destroyAfterClose, modal) {
        jodit_core_global__WEBPACK_IMPORTED_MODULE_4__/* .eventEmitter */ .RR.fire('closeAllPopups hideHelpers');
        /**
         * Called before the opening of the dialog box
         */
        if (this.e.fire(this, 'beforeOpen') === false) {
            return this;
        }
        if ((0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_6__/* .isBoolean */ .Lm)(contentOrClose)) {
            destroyAfterClose = contentOrClose;
        }
        if ((0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_6__/* .isBoolean */ .Lm)(titleOrModal)) {
            modal = titleOrModal;
        }
        this.destroyAfterClose = destroyAfterClose === true;
        const content = (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_6__/* .isBoolean */ .Lm)(contentOrClose) ? undefined : contentOrClose;
        const title = (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_6__/* .isBoolean */ .Lm)(titleOrModal) ? undefined : titleOrModal;
        if (title !== undefined) {
            this.setHeader(title);
        }
        if (content) {
            this.setContent(content);
        }
        this.setMod('active', true);
        this.isOpened = true;
        this.setModal(modal);
        this.destination.appendChild(this.container);
        if (this.getMod('static') !== true) {
            this.setPosition(this.offsetX, this.offsetY);
            this.setMaxZIndex();
        }
        else {
            this.container.style.removeProperty('z-index');
        }
        if (this.o.fullsize) {
            this.toggleFullSize(true);
        }
        /**
         * Called after the opening of the dialog box
         */
        this.e.fire('afterOpen', this);
        return this;
    }
    /**
     * Set modal mode
     */
    setModal(modal) {
        this.isModal = Boolean(modal);
        this.setMod('modal', this.isModal);
        return this;
    }
    /****
     * Closes the dialog box , if you want to call the method `destruct`
     *
     * @see destroy
     * @example
     * ```javascript
     * //You can close dialog two ways
     * var dialog = new Jodit.modules.Dialog();
     * dialog.open('Hello world!', 'Title');
     * var $close = dialog.create.fromHTML('<a href="#" style="float:left;" class="jodit-button">
     *     <i class="icon icon-check"></i>&nbsp;' + Jodit.prototype.i18n('Ok') + '</a>');
     * $close.addEventListener('click', function () {
     *     dialog.close();
     * });
     * dialog.setFooter($close);
     * // and second way, you can close dialog from content
     * dialog.open('<a onclick="var event = doc.createEvent('HTMLEvents'); event.initEvent('close_dialog', true, true);
     * this.dispatchEvent(event)">Close</a>', 'Title');
     * ```
     */
    close() {
        if (this.isDestructed ||
            !this.isOpened ||
            this.getMod('static') === true) {
            return this;
        }
        const { e } = this;
        /**
         * Called up to close the window
         */
        if (e.fire(this, 'beforeClose') === false ||
            e.fire('beforeClose', this) === false) {
            return this;
        }
        this.setMod('active', false);
        this.isOpened = false;
        if (this.isFullSize) {
            this.toggleFullSize(false);
        }
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.safeRemove(this.container);
        this.removeGlobalResizeListeners();
        /**
         * It called after the window is closed
         */
        e.fire(this, 'afterClose');
        e.fire(this.ow, 'joditCloseDialog');
        if (this.destroyAfterClose) {
            this.destruct();
        }
        return this;
    }
    constructor(options = {}) {
        super(options);
        this.destroyAfterClose = false;
        this.moved = false;
        this.resizable = false;
        this.draggable = false;
        this.startX = 0;
        this.startY = 0;
        this.startPoint = { x: 0, y: 0, w: 0, h: 0 };
        this.lockSelect = () => {
            this.setMod('moved', true);
        };
        this.unlockSelect = () => {
            this.setMod('moved', false);
        };
        this.onResize = () => {
            if (this.options &&
                this.o.resizable &&
                !this.moved &&
                this.isOpened &&
                !this.offsetX &&
                !this.offsetY) {
                this.setPosition();
            }
        };
        this.isModal = false;
        /**
         * True, if dialog was opened
         */
        this.isOpened = false;
        const self = this;
        self.options = (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_7__.ConfigProto)(options, (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_7__.ConfigProto)(jodit_config__WEBPACK_IMPORTED_MODULE_12__/* .Config */ .T.prototype.dialog, Dialog_1.defaultOptions));
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.safeRemove(self.container);
        const n = this.getFullElName.bind(this);
        self.container = this.c.fromHTML(`<div class="jodit jodit-dialog ${this.componentName}">
				<div class="${n('overlay')}"></div>
				<div class="${this.getFullElName('panel')}">
					<div class="${n('header')}">
						<div class="${n('header-title')}"></div>
						<div class="${n('header-toolbar')}"></div>
					</div>
					<div class="${n('content')}"></div>
					<div class="${n('footer')}"></div>
					<div class="${n('resizer')}">${jodit_core_ui__WEBPACK_IMPORTED_MODULE_9__/* .Icon */ .In.get('resize_handler')}</div>
				</div>
			</div>`);
        if (this.o.zIndex) {
            this.container.style.zIndex = this.o.zIndex.toString();
        }
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_7__.attr)(self.container, 'role', 'dialog');
        Object.defineProperty(self.container, 'component', {
            value: this
        });
        self.setMod('theme', self.o.theme || 'default').setMod('resizable', Boolean(self.o.resizable));
        const dialog = self.getElm('panel');
        void 0;
        const resizer = self.getElm('resizer');
        void 0;
        const dialogbox_header = self.getElm('header-title');
        void 0;
        const dialogbox_content = self.getElm('content');
        void 0;
        const dialogbox_footer = self.getElm('footer');
        void 0;
        const dialogbox_toolbar = self.getElm('header-toolbar');
        void 0;
        this.dialog = dialog;
        this.resizer = resizer;
        this.dialogbox_header = dialogbox_header;
        this.dialogbox_content = dialogbox_content;
        this.dialogbox_footer = dialogbox_footer;
        this.dialogbox_toolbar = dialogbox_toolbar;
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_7__.css)(self.dialog, {
            maxWidth: self.options.maxWidth,
            minHeight: self.options.minHeight,
            minWidth: self.options.minWidth
        });
        const headerBox = self.getElm('header');
        headerBox &&
            self.e.on(headerBox, 'pointerdown touchstart', self.onHeaderMouseDown);
        self.e.on(self.resizer, 'mousedown touchstart', self.onResizerMouseDown);
        const fullSize = jodit_core_global__WEBPACK_IMPORTED_MODULE_4__/* .pluginSystem */ .fg.get('fullsize');
        (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_6__/* .isFunction */ .Tn)(fullSize) && fullSize(self);
        this.e
            .on(self.container, 'close_dialog', self.close)
            .on(this.ow, 'keydown', this.onEsc)
            .on(this.ow, 'resize', this.onResize);
        if (this.o.closeOnClickOverlay) {
            const overlay = self.getElm('overlay');
            void 0;
            this.e.on(overlay, 'click', self.close);
        }
    }
    /**
     * Build toolbar after ready
     */
    buildToolbar() {
        this.o.buttons &&
            this.toolbar
                .build((0,jodit_core_helpers_array__WEBPACK_IMPORTED_MODULE_5__/* .splitArray */ .uM)(this.o.buttons))
                .setMod('mode', 'header')
                .appendTo(this.dialogbox_toolbar);
    }
    /**
     * It destroys all objects created for the windows and also includes all the handlers for the window object
     */
    destruct() {
        if (this.isInDestruct) {
            return;
        }
        this.setStatus(jodit_core_component__WEBPACK_IMPORTED_MODULE_0__/* .STATUSES */ .f.beforeDestruct);
        if (this.isOpened) {
            this.close();
        }
        if (this.events) {
            this.removeGlobalResizeListeners();
            this.events
                .off(this.container, 'close_dialog', self.close)
                .off(this.ow, 'keydown', this.onEsc)
                .off(this.ow, 'resize', this.onResize);
        }
        super.destruct();
    }
};
(0,tslib__WEBPACK_IMPORTED_MODULE_13__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.autobind
], Dialog.prototype, "onMouseUp", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_13__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.autobind
], Dialog.prototype, "onHeaderMouseDown", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_13__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.autobind
], Dialog.prototype, "onMouseMove", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_13__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.autobind
], Dialog.prototype, "onEsc", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_13__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.autobind
], Dialog.prototype, "onResizerMouseDown", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_13__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.autobind
], Dialog.prototype, "close", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_13__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.hook)('ready')
], Dialog.prototype, "buildToolbar", null);
Dialog = Dialog_1 = (0,tslib__WEBPACK_IMPORTED_MODULE_13__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.component
], Dialog);

Dialog.defaultOptions = Object.assign(Object.assign({}, jodit_core_view_view__WEBPACK_IMPORTED_MODULE_10__/* .View */ .S.defaultOptions), { closeOnClickOverlay: false, closeOnEsc: true });


/***/ }),

/***/ 34256:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Fc: function() { return /* reexport safe */ _alert__WEBPACK_IMPORTED_MODULE_0__.F; },
/* harmony export */   XG: function() { return /* reexport safe */ _prompt__WEBPACK_IMPORTED_MODULE_3__.X; },
/* harmony export */   lG: function() { return /* reexport safe */ _dialog__WEBPACK_IMPORTED_MODULE_2__.l; },
/* harmony export */   pT: function() { return /* reexport safe */ _confirm__WEBPACK_IMPORTED_MODULE_1__.p; }
/* harmony export */ });
/* harmony import */ var _alert__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5854);
/* harmony import */ var _confirm__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(23132);
/* harmony import */ var _dialog__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(58006);
/* harmony import */ var _prompt__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(91560);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * [[include:modules/dialog/README.md]]
 * @packageDocumentation
 * @module modules/dialog
 */






/***/ }),

/***/ 91560:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   X: function() { return /* binding */ Prompt; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(69052);
/* harmony import */ var jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(26150);
/* harmony import */ var jodit_core_ui_button_button_button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(92032);
/* harmony import */ var _dialog__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(58006);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */




/**
 * Show `Prompt` dialog. Work without Jodit object
 *
 * @param msg - Dialog content
 * @param title - Title or callback
 * @param callback - callback. The first argument is the value entered
 * @param placeholder - Placeholder for input
 * @example
 * ```javascript
 * Jodit.Prompt("Enter your name", "Prompt Dialog", function (name) {
 *     if (name.length < 3) {
 *         Jodit.Alert("The name must be at least 3 letters");
 *         return false;
 *     }
 *     // do something
 * });
 * ```
 */
function Prompt(msg, title, callback, placeholder, defaultValue) {
    const dialog = this instanceof _dialog__WEBPACK_IMPORTED_MODULE_2__/* .Dialog */ .l
        ? this
        : new _dialog__WEBPACK_IMPORTED_MODULE_2__/* .Dialog */ .l({ closeOnClickOverlay: true }), cancelButton = (0,jodit_core_ui_button_button_button__WEBPACK_IMPORTED_MODULE_1__/* .Button */ .$n)(dialog, 'cancel', 'Cancel'), okButton = (0,jodit_core_ui_button_button_button__WEBPACK_IMPORTED_MODULE_1__/* .Button */ .$n)(dialog, 'ok', 'Ok'), form = dialog.c.element('form', {
        class: 'jodit-dialog_prompt'
    }), inputElement = dialog.c.element('input', {
        autofocus: true,
        class: 'jodit-input'
    }), labelElement = dialog.c.element('label');
    if ((0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_3__/* .isFunction */ .T)(title)) {
        callback = title;
        title = undefined;
    }
    if (placeholder) {
        (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_0__/* .attr */ .C)(inputElement, 'placeholder', placeholder);
    }
    labelElement.appendChild(dialog.c.text(msg));
    form.appendChild(labelElement);
    form.appendChild(inputElement);
    cancelButton.onAction(dialog.close);
    const onclick = () => {
        if (!callback ||
            !(0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_3__/* .isFunction */ .T)(callback) ||
            callback(inputElement.value) !== false) {
            dialog.close();
        }
    };
    okButton.onAction(onclick);
    dialog.e.on(form, 'submit', () => {
        onclick();
        return false;
    });
    dialog.setFooter([okButton, cancelButton]);
    dialog.open(form, title || '&nbsp;', true, true);
    inputElement.focus();
    if (defaultValue !== undefined && defaultValue.length) {
        inputElement.value = defaultValue;
        inputElement.select();
    }
    return dialog;
}


/***/ }),

/***/ 49931:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(97369);
/* harmony import */ var jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(931);
/* harmony import */ var jodit_modules_file_browser_builders_elements_map__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(77112);
/* harmony import */ var jodit_modules_file_browser_factories__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(83797);
/* harmony import */ var jodit_modules_file_browser_fetch_delete_file__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(97324);
/* harmony import */ var jodit_modules_file_browser_fetch_load_tree__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(31859);
/* harmony import */ var jodit_modules_file_browser_listeners_native_listeners__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(62994);
/* harmony import */ var jodit_modules_image_editor_image_editor__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(53804);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */










const CLASS_PREVIEW = 'jodit-file-browser-preview', preview_tpl_next = (next = 'next', right = 'right') => `<div class="${CLASS_PREVIEW}__navigation ${CLASS_PREVIEW}__navigation_arrow_${next}">` +
    '' +
    jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_2__/* .Icon */ .I.get('angle-' + right) +
    '</a>';
/* harmony default export */ __webpack_exports__.A = ((self) => {
    if (!self.o.contextMenu) {
        return () => { };
    }
    const contextmenu = (0,jodit_modules_file_browser_factories__WEBPACK_IMPORTED_MODULE_4__/* .makeContextMenu */ .V)(self);
    return (e) => {
        const a = (0,jodit_modules_file_browser_listeners_native_listeners__WEBPACK_IMPORTED_MODULE_6__/* .getItem */ .Gq)(e.target, self.container);
        if (!a) {
            return;
        }
        let item = a;
        const opt = self.options, ga = (key) => (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.attr)(item, key) || '';
        self.async.setTimeout(() => {
            const selectedItem = (0,jodit_modules_file_browser_listeners_native_listeners__WEBPACK_IMPORTED_MODULE_6__/* .elementToItem */ .PZ)(a, (0,jodit_modules_file_browser_builders_elements_map__WEBPACK_IMPORTED_MODULE_3__/* .elementsMap */ .a)(self));
            if (!selectedItem) {
                return;
            }
            self.state.activeElements = [selectedItem];
            contextmenu.show(e.clientX, e.clientY, [
                ga('data-is-file') !== '1' &&
                    opt.editImage &&
                    (self.dataProvider.canI('ImageResize') ||
                        self.dataProvider.canI('ImageCrop'))
                    ? {
                        icon: 'pencil',
                        title: 'Edit',
                        exec: () => jodit_modules_image_editor_image_editor__WEBPACK_IMPORTED_MODULE_7__/* .openImageEditor */ .B.call(self, ga('href'), ga('data-name'), ga('data-path'), ga('data-source'))
                    }
                    : false,
                self.dataProvider.canI('FileRename')
                    ? {
                        icon: 'italic',
                        title: 'Rename',
                        exec: () => {
                            self.e.fire('fileRename.filebrowser', ga('data-name'), ga('data-path'), ga('data-source'));
                        }
                    }
                    : false,
                self.dataProvider.canI('FileRemove')
                    ? {
                        icon: 'bin',
                        title: 'Delete',
                        exec: () => (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__awaiter */ .sH)(void 0, void 0, void 0, function* () {
                            try {
                                yield (0,jodit_modules_file_browser_fetch_delete_file__WEBPACK_IMPORTED_MODULE_9__/* .deleteFile */ .W)(self, ga('data-name'), ga('data-source'));
                            }
                            catch (e) {
                                return self.status(e);
                            }
                            self.state.activeElements = [];
                            return (0,jodit_modules_file_browser_fetch_load_tree__WEBPACK_IMPORTED_MODULE_5__/* .loadTree */ .r)(self).catch(self.status);
                        })
                    }
                    : false,
                opt.preview
                    ? {
                        icon: 'eye',
                        title: 'Preview',
                        exec: () => {
                            const preview = self.dlg({
                                buttons: ['fullsize', 'dialog.close']
                            }), temp_content = self.c.div(CLASS_PREVIEW, '<div class="jodit-icon_loader"></div>'), preview_box = self.c.div(CLASS_PREVIEW + '__box'), next = self.c.fromHTML(preview_tpl_next()), prev = self.c.fromHTML(preview_tpl_next('prev', 'left')), addLoadHandler = (src) => {
                                const image = self.c.element('img');
                                image.setAttribute('src', src);
                                const onload = () => {
                                    var _a;
                                    if (self.isInDestruct) {
                                        return;
                                    }
                                    self.e.off(image, 'load');
                                    jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.detach(temp_content);
                                    if (opt.showPreviewNavigation) {
                                        if (jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.prevWithClass(item, self.files.getFullElName('item'))) {
                                            temp_content.appendChild(prev);
                                        }
                                        if (jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.nextWithClass(item, self.files.getFullElName('item'))) {
                                            temp_content.appendChild(next);
                                        }
                                    }
                                    temp_content.appendChild(preview_box);
                                    preview_box.appendChild(image);
                                    preview.setPosition();
                                    (_a = self === null || self === void 0 ? void 0 : self.events) === null || _a === void 0 ? void 0 : _a.fire('previewOpenedAndLoaded');
                                };
                                self.e.on(image, 'load', onload);
                                if (image.complete) {
                                    onload();
                                }
                            };
                            self.e.on([next, prev], 'click', function () {
                                if (this === next) {
                                    item = jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.nextWithClass(item, self.files.getFullElName('item'));
                                }
                                else {
                                    item = jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.prevWithClass(item, self.files.getFullElName('item'));
                                }
                                if (!item) {
                                    throw (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.error)('Need element');
                                }
                                jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.detach(temp_content);
                                jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.detach(preview_box);
                                temp_content.innerHTML =
                                    '<div class="jodit-icon_loader"></div>';
                                addLoadHandler(ga('href'));
                            });
                            self.e.on('beforeDestruct', () => {
                                preview.destruct();
                            });
                            preview.container.classList.add(CLASS_PREVIEW + '__dialog');
                            preview.setContent(temp_content);
                            preview.setPosition();
                            preview.open();
                            addLoadHandler(ga('href'));
                            self.events
                                .on('beforeDestruct', () => {
                                preview.destruct();
                            })
                                .fire('previewOpened');
                        }
                    }
                    : false,
                {
                    icon: 'upload',
                    title: 'Download',
                    exec: () => {
                        const url = ga('href');
                        if (url) {
                            self.ow.open(url);
                        }
                    }
                }
            ]);
        }, self.defaultTimeout);
        self.e
            .on('beforeClose', () => {
            contextmenu.close();
        })
            .on('beforeDestruct', () => contextmenu.destruct());
        e.stopPropagation();
        e.preventDefault();
        return false;
    };
});


/***/ }),

/***/ 77112:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   a: function() { return /* binding */ elementsMap; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
const map = new WeakMap();
/**
 * Returns a map of the file's key correspondence to its DOM element in the file browser
 * @private
 */
const elementsMap = (view) => {
    let result = map.get(view);
    if (!result) {
        result = {};
        map.set(view, result);
    }
    return result;
};


/***/ }),

/***/ 11133:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   u: function() { return /* binding */ FileBrowserItem; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(65147);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

class FileBrowserItem {
    constructor(data) {
        this.data = data;
        // TODO Check with Object.assign
        Object.keys(data).forEach(key => {
            this[key] = data[key];
        });
    }
    static create(data) {
        if (data instanceof FileBrowserItem) {
            return data;
        }
        return new FileBrowserItem(data);
    }
    get path() {
        return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.normalizePath)(this.data.source.path ? this.data.source.path + '/' : '/');
    }
    get imageURL() {
        const timestamp = this.time || new Date().getTime().toString(), { thumbIsAbsolute, source, thumb, file } = this.data, path = thumb || file;
        return thumbIsAbsolute && path
            ? path
            : (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.normalizeUrl)(source.baseurl, source.path, path || '') +
                '?_tmst=' +
                encodeURIComponent(timestamp);
    }
    get fileURL() {
        let { name } = this.data;
        const { file, fileIsAbsolute, source } = this.data;
        if (file !== undefined) {
            name = file;
        }
        return fileIsAbsolute && name
            ? name
            : (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.normalizeUrl)(source.baseurl, source.path, name || '');
    }
    get time() {
        const { changed } = this.data;
        return ((changed &&
            (typeof changed === 'number'
                ? new Date(changed).toLocaleString()
                : changed)) ||
            '');
    }
    get uniqueHashKey() {
        const data = this.data;
        let key = [
            data.sourceName,
            data.name,
            data.file,
            this.time,
            data.thumb
        ].join('_');
        key = key.toLowerCase().replace(/[^0-9a-z\-.]/g, '-');
        return key;
    }
    toJSON() {
        return this.data;
    }
}


/***/ }),

/***/ 70265:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_core_request_config__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(27337);
/* harmony import */ var jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(9823);
/* harmony import */ var jodit_core_helpers_utils_human_size_to_bytes__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(99898);
/* harmony import */ var jodit_core_ui_form_inputs_file_file__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(47964);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(36115);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */





jodit_config__WEBPACK_IMPORTED_MODULE_3__/* .Config */ .T.prototype.filebrowser = {
    namespace: '',
    cache: true,
    extraButtons: [],
    filter(item, search) {
        search = search.toLowerCase();
        if ((0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_1__/* .isString */ .Kg)(item)) {
            return item.toLowerCase().indexOf(search) !== -1;
        }
        if ((0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_1__/* .isString */ .Kg)(item.name)) {
            return item.name.toLowerCase().indexOf(search) !== -1;
        }
        if ((0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_1__/* .isString */ .Kg)(item.file)) {
            return item.file.toLowerCase().indexOf(search) !== -1;
        }
        return true;
    },
    sortBy: 'changed-desc',
    sort(a, b, sortBy) {
        const [sortAttr, arrow] = sortBy.toLowerCase().split('-'), asc = arrow === 'asc';
        const compareStr = (f, s) => {
            if (f < s) {
                return asc ? -1 : 1;
            }
            if (f > s) {
                return asc ? 1 : -1;
            }
            return 0;
        };
        if ((0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_1__/* .isString */ .Kg)(a)) {
            return compareStr(a.toLowerCase(), b.toLowerCase());
        }
        if (a[sortAttr] === undefined || sortAttr === 'name') {
            if ((0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_1__/* .isString */ .Kg)(a.name)) {
                return compareStr(a.name.toLowerCase(), b.name.toLowerCase());
            }
            if ((0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_1__/* .isString */ .Kg)(a.file)) {
                return compareStr(a.file.toLowerCase(), b.file.toLowerCase());
            }
            return 0;
        }
        switch (sortAttr) {
            case 'changed': {
                const f = new Date(a.changed).getTime(), s = new Date(b.changed).getTime();
                return asc ? f - s : s - f;
            }
            case 'size': {
                const f = (0,jodit_core_helpers_utils_human_size_to_bytes__WEBPACK_IMPORTED_MODULE_4__/* .humanSizeToBytes */ .z)(a.size), s = (0,jodit_core_helpers_utils_human_size_to_bytes__WEBPACK_IMPORTED_MODULE_4__/* .humanSizeToBytes */ .z)(b.size);
                return asc ? f - s : s - f;
            }
        }
        return 0;
    },
    editImage: true,
    preview: true,
    showPreviewNavigation: true,
    showSelectButtonInPreview: true,
    contextMenu: true,
    howLongShowMsg: 3000,
    createNewFolder: true,
    deleteFolder: true,
    renameFolder: true,
    moveFolder: true,
    moveFile: true,
    permissionsPresets: {
        allowFileDownload: undefined,
        allowFileMove: undefined,
        allowFileRemove: undefined,
        allowFileRename: undefined,
        allowFileUpload: undefined,
        allowFileUploadRemote: undefined,
        allowFiles: undefined,
        allowFolderCreate: undefined,
        allowFolderMove: undefined,
        allowFolderRemove: undefined,
        allowFolderRename: undefined,
        allowFolderTree: undefined,
        allowFolders: undefined,
        allowGeneratePdf: undefined,
        allowImageCrop: undefined,
        allowImageResize: undefined
    },
    showFoldersPanel: true,
    storeLastOpenedFolder: true,
    width: 859,
    height: 400,
    buttons: [
        'filebrowser.upload',
        'filebrowser.remove',
        'filebrowser.update',
        'filebrowser.select',
        'filebrowser.edit',
        '|',
        'filebrowser.tiles',
        'filebrowser.list',
        '|',
        'filebrowser.filter',
        '|',
        'filebrowser.sort'
    ],
    removeButtons: [],
    fullsize: false,
    showTooltip: true,
    view: null,
    isSuccess(resp) {
        return resp.success;
    },
    getMessage(resp) {
        return resp.data.messages !== undefined && (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_1__/* .isArray */ .cy)(resp.data.messages)
            ? resp.data.messages.join(' ')
            : '';
    },
    showFileName: true,
    showFileSize: true,
    showFileChangeTime: true,
    saveStateInStorage: {
        storeLastOpenedFolder: true,
        storeView: true,
        storeSortBy: true
    },
    pixelOffsetLoadNewChunk: 200,
    getThumbTemplate(item, source, source_name) {
        const opt = this.options, IC = this.files.getFullElName('item'), showName = opt.showFileName, showSize = opt.showFileSize && item.size, showTime = opt.showFileChangeTime && item.time;
        let name = '';
        if (item.file !== undefined) {
            name = item.file;
        }
        const info = `<div class="${IC}-info">${showName ? `<span class="${IC}-info-filename">${name}</span>` : ''}${showSize
            ? `<span class="${IC}-info-filesize">${item.size}</span>`
            : ''}${showTime
            ? `<span class="${IC}-info-filechanged">${showTime}</span>`
            : ''}</div>`;
        return `<a
			data-jodit-file-browser-item="true"
			data-is-file="${item.isImage ? 0 : 1}"
			draggable="true"
			class="${IC}"
			href="${item.fileURL}"
			data-source="${source_name}"
			data-path="${item.path}"
			data-name="${name}"
			title="${name}"
			data-url="${item.fileURL}">
				<img
					data-is-file="${item.isImage ? 0 : 1}"
					data-src="${item.fileURL}"
					src="${item.imageURL}"
					alt="${name}"
					loading="lazy"
				/>
				${showName || showSize || showTime ? info : ''}
			</a>`;
    },
    ajax: Object.assign(Object.assign({}, jodit_config__WEBPACK_IMPORTED_MODULE_3__/* .Config */ .T.prototype.defaultAjaxOptions), { url: '', data: {}, cache: true, contentType: 'application/x-www-form-urlencoded; charset=UTF-8', method: 'POST', processData: true, headers: {}, prepareData(data) {
            return data;
        },
        process(resp) {
            return resp;
        } }),
    create: {
        data: { action: 'folderCreate' }
    },
    getLocalFileByUrl: {
        data: { action: 'getLocalFileByUrl' }
    },
    resize: {
        data: { action: 'imageResize' }
    },
    crop: {
        data: { action: 'imageCrop' }
    },
    fileMove: {
        data: { action: 'fileMove' }
    },
    folderMove: {
        data: { action: 'folderMove' }
    },
    fileRename: {
        data: { action: 'fileRename' }
    },
    folderRename: {
        data: { action: 'folderRename' }
    },
    fileRemove: {
        data: { action: 'fileRemove' }
    },
    folderRemove: {
        data: { action: 'folderRemove' }
    },
    items: {
        data: { action: 'files' }
    },
    folder: {
        data: { action: 'folders' }
    },
    permissions: {
        data: { action: 'permissions' }
    }
};
jodit_config__WEBPACK_IMPORTED_MODULE_3__/* .Config */ .T.prototype.controls.filebrowser = {
    upload: {
        icon: 'plus',
        isInput: true,
        isDisabled: (browser) => !browser.dataProvider.canI('FileUpload'),
        getContent: (filebrowser) => {
            const btn = new jodit_core_ui_form_inputs_file_file__WEBPACK_IMPORTED_MODULE_2__/* .UIFileInput */ .n(filebrowser, {
                onlyImages: filebrowser.state.onlyImages
            });
            filebrowser.e.fire('bindUploader.filebrowser', btn.container);
            return btn.container;
        }
    },
    remove: {
        icon: 'bin',
        isDisabled: (browser) => {
            return (!browser.state.activeElements.length ||
                !browser.dataProvider.canI('FileRemove'));
        },
        exec: (editor) => {
            editor.e.fire('fileRemove.filebrowser');
        }
    },
    update: {
        exec: (editor) => {
            editor.e.fire('update.filebrowser');
        }
    },
    select: {
        icon: 'check',
        isDisabled: (browser) => !browser.state.activeElements.length,
        exec: (editor) => {
            editor.e.fire('select.filebrowser');
        }
    },
    edit: {
        icon: 'pencil',
        isDisabled: (browser) => {
            const selected = browser.state.activeElements;
            return (selected.length !== 1 ||
                !selected[0].isImage ||
                !(browser.dataProvider.canI('ImageCrop') ||
                    browser.dataProvider.canI('ImageResize')));
        },
        exec: editor => {
            editor.e.fire('edit.filebrowser');
        }
    },
    tiles: {
        icon: 'th',
        isActive: (filebrowser) => filebrowser.state.view === 'tiles',
        exec: (filebrowser) => {
            filebrowser.e.fire('view.filebrowser', 'tiles');
        }
    },
    list: {
        icon: 'th-list',
        isActive: (filebrowser) => filebrowser.state.view === 'list',
        exec: (filebrowser) => {
            filebrowser.e.fire('view.filebrowser', 'list');
        }
    },
    filter: {
        isInput: true,
        getContent: (filebrowser, b) => {
            const oldInput = b.container.querySelector('.jodit-input');
            if (oldInput) {
                return oldInput;
            }
            const input = filebrowser.c.element('input', {
                class: 'jodit-input',
                placeholder: filebrowser.i18n('Filter')
            });
            input.value = filebrowser.state.filterWord;
            filebrowser.e.on(input, 'keydown mousedown', filebrowser.async.debounce(() => {
                filebrowser.e.fire('filter.filebrowser', input.value);
            }, filebrowser.defaultTimeout));
            return input;
        }
    },
    sort: {
        isInput: true,
        getContent: (fb) => {
            const select = fb.c.fromHTML('<select class="jodit-input jodit-select">' +
                `<option value="changed-asc">${fb.i18n('Sort by changed')} (⬆)</option>` +
                `<option value="changed-desc">${fb.i18n('Sort by changed')} (⬇)</option>` +
                `<option value="name-asc">${fb.i18n('Sort by name')} (⬆)</option>` +
                `<option value="name-desc">${fb.i18n('Sort by name')} (⬇)</option>` +
                `<option value="size-asc">${fb.i18n('Sort by size')} (⬆)</option>` +
                `<option value="size-desc">${fb.i18n('Sort by size')} (⬇)</option>` +
                '</select>');
            select.value = fb.state.sortBy;
            fb.e
                .on('sort.filebrowser', (value) => {
                if (select.value !== value) {
                    select.value = value;
                }
            })
                .on(select, 'change', () => {
                fb.e.fire('sort.filebrowser', select.value);
            });
            return select;
        }
    }
};


/***/ }),

/***/ 75889:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   o: function() { return /* binding */ DEFAULT_SOURCE_NAME; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_request__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(53883);
/* harmony import */ var jodit_modules_file_browser_builders_item__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(11133);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */






const DEFAULT_SOURCE_NAME = 'default';
const possibleRules = new Set([
    'allowFiles',
    'allowFileMove',
    'allowFileUpload',
    'allowFileUploadRemote',
    'allowFileRemove',
    'allowFileRename',
    'allowFolders',
    'allowFolderMove',
    'allowFolderCreate',
    'allowFolderRemove',
    'allowFolderRename',
    'allowImageResize',
    'allowImageCrop'
]);
let DataProvider = class DataProvider {
    constructor(parent, options) {
        this.parent = parent;
        this.options = options;
        this.__currentPermissions = null;
        this.__ajaxInstances = new Map();
        this.progressHandler = (ignore) => { };
    }
    /**
     * Alias for options
     */
    get o() {
        return this.options;
    }
    get(name) {
        const instances = this.__ajaxInstances;
        if (instances.has(name)) {
            const ajax = instances.get(name);
            ajax === null || ajax === void 0 ? void 0 : ajax.abort();
            instances.delete(name);
        }
        const opts = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.ConfigProto)(this.options[name] !== undefined
            ? this.options[name]
            : {}, (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.ConfigProto)({
            onProgress: this.progressHandler
        }, this.o.ajax));
        if (opts.prepareData) {
            opts.data = opts.prepareData.call(this, opts.data);
        }
        const ajax = new jodit_core_request__WEBPACK_IMPORTED_MODULE_3__/* .Ajax */ .d(opts);
        instances.set(name, ajax);
        const promise = ajax.send();
        promise
            .finally(() => {
            ajax.destruct();
            instances.delete(name);
            this.progressHandler(100);
        })
            .catch(() => null);
        return promise
            .then(resp => resp.json())
            .then(resp => {
            if (resp && !this.isSuccess(resp)) {
                throw new Error(this.getMessage(resp));
            }
            return resp;
        });
    }
    onProgress(callback) {
        this.progressHandler = callback;
    }
    /**
     * Load permissions for path and source
     */
    permissions(path, source) {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__awaiter */ .sH)(this, void 0, void 0, function* () {
            if (!this.o.permissions) {
                return null;
            }
            this.o.permissions.data.path = path;
            this.o.permissions.data.source = source;
            if (this.o.permissions.url) {
                return this.get('permissions').then(resp => {
                    if (this.parent.isInDestruct) {
                        throw (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.abort)();
                    }
                    let process = this.o.permissions.process;
                    if (!process) {
                        process = this.o.ajax.process;
                    }
                    if (process) {
                        const respData = process.call(self, resp);
                        if (respData.data.permissions) {
                            this.parent.events.fire(this, 'changePermissions', this.__currentPermissions, respData.data.permissions);
                            this.__currentPermissions = respData.data.permissions;
                        }
                    }
                    return this.__currentPermissions;
                });
            }
            return null;
        });
    }
    canI(action) {
        const rule = 'allow' + action;
        if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD) {
            if (!possibleRules.has(rule)) {
                throw (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.error)('Wrong action ' + action);
            }
        }
        const presetValue = this.o.permissionsPresets[rule];
        if (presetValue !== undefined) {
            return presetValue;
        }
        return (this.__currentPermissions == null ||
            this.__currentPermissions[rule] === undefined ||
            this.__currentPermissions[rule]);
    }
    __items(path, source, mods, onResult) {
        const opt = this.options;
        if (!opt.items) {
            return Promise.reject(Error('Set Items api options'));
        }
        opt.items.data.path = path;
        opt.items.data.source = source;
        opt.items.data.mods = mods;
        return this.get('items').then(resp => {
            let process = this.o.items.process;
            if (!process) {
                process = this.o.ajax.process;
            }
            if (process) {
                resp = process.call(self, resp);
            }
            return onResult(resp);
        });
    }
    /**
     * Load items list by path and source
     */
    items(path, source, mods = {}) {
        return this.__items(path, source, mods, resp => this.generateItemsList(resp.data.sources, mods));
    }
    /**
     * Load items list by path and source
     */
    itemsEx(path, source, mods = {}) {
        const calcTotal = (sources) => sources.reduce((acc, source) => acc + source.files.length, 0);
        return this.__items(path, source, mods, resp => ({
            items: this.generateItemsList(resp.data.sources, mods),
            loadedTotal: calcTotal(resp.data.sources)
        }));
    }
    generateItemsList(sources, mods = {}) {
        const elements = [];
        const canBeFile = (item) => item.type === 'folder' ||
            !mods.onlyImages ||
            item.isImage === undefined ||
            item.isImage;
        const inFilter = (item) => {
            var _a;
            return !((_a = mods.filterWord) === null || _a === void 0 ? void 0 : _a.length) ||
                this.o.filter === undefined ||
                this.o.filter(item, mods.filterWord);
        };
        sources.forEach(source => {
            if (source.files && source.files.length) {
                const { sort } = this.o;
                if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.isFunction)(sort) && mods.sortBy) {
                    source.files.sort((a, b) => sort(a, b, mods.sortBy));
                }
                source.files.forEach((item) => {
                    if (inFilter(item) && canBeFile(item)) {
                        elements.push(jodit_modules_file_browser_builders_item__WEBPACK_IMPORTED_MODULE_4__/* .FileBrowserItem */ .u.create(Object.assign(Object.assign({}, item), { sourceName: source.name, source })));
                    }
                });
            }
        });
        return elements;
    }
    tree(path, source) {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__awaiter */ .sH)(this, void 0, void 0, function* () {
            path = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.normalizeRelativePath)(path);
            if (!this.o.folder) {
                return Promise.reject(Error('Set Folder Api options'));
            }
            yield this.permissions(path, source);
            this.o.folder.data.path = path;
            this.o.folder.data.source = source;
            return this.get('folder').then(resp => {
                let process = this.o.folder.process;
                if (!process) {
                    process = this.o.ajax.process;
                }
                if (process) {
                    resp = process.call(self, resp);
                }
                return resp.data.sources;
            });
        });
    }
    /**
     * Get path by url. You can use this method in another modules
     */
    getPathByUrl(url) {
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.set)('options.getLocalFileByUrl.data.url', url, this);
        return this.get('getLocalFileByUrl').then(resp => {
            if (this.isSuccess(resp)) {
                return resp.data;
            }
            throw (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.error)(this.getMessage(resp));
        });
    }
    /**
     * Create a directory on the server
     *
     * @param name - Name the new folder
     * @param path - Relative directory in which you want create a folder
     * @param source - Server source key
     */
    createFolder(name, path, source) {
        const { create } = this.o;
        if (!create) {
            throw (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.error)('Set Create api options');
        }
        create.data.source = source;
        create.data.path = path;
        create.data.name = name;
        return this.get('create').then(resp => {
            if (this.isSuccess(resp)) {
                return true;
            }
            throw (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.error)(this.getMessage(resp));
        });
    }
    /**
     * Move a file / directory on the server
     *
     * @param filepath - The relative path to the file / folder source
     * @param path - Relative to the directory where you want to move the file / folder
     */
    move(filepath, path, source, isFile) {
        const mode = isFile
            ? 'fileMove'
            : 'folderMove';
        const option = this.options[mode];
        if (!option) {
            throw (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.error)('Set Move api options');
        }
        option.data.from = filepath;
        option.data.path = path;
        option.data.source = source;
        return this.get(mode).then(resp => {
            if (this.isSuccess(resp)) {
                return true;
            }
            throw (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.error)(this.getMessage(resp));
        });
    }
    /**
     * Deleting item
     *
     * @param path - Relative path
     * @param file - The filename
     * @param source - Source
     */
    remove(action, path, file, source) {
        const fr = this.o[action];
        if (!fr) {
            throw (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.error)(`Set "${action}" api options`);
        }
        fr.data.path = path;
        fr.data.name = file;
        fr.data.source = source;
        return this.get(action).then(resp => {
            if (fr.process) {
                resp = fr.process.call(this, resp);
            }
            return this.getMessage(resp);
        });
    }
    /**
     * Deleting a file
     *
     * @param path - Relative path
     * @param file - The filename
     * @param source - Source
     */
    fileRemove(path, file, source) {
        return this.remove('fileRemove', path, file, source);
    }
    /**
     * Deleting a folder
     *
     * @param path - Relative path
     * @param file - The filename
     * @param source - Source
     */
    folderRemove(path, file, source) {
        return this.remove('folderRemove', path, file, source);
    }
    /**
     * Rename action
     *
     * @param path - Relative path
     * @param name - Old name
     * @param newname - New name
     * @param source - Source
     */
    rename(action, path, name, newname, source) {
        const fr = this.o[action];
        if (!fr) {
            throw (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.error)(`Set "${action}" api options`);
        }
        fr.data.path = path;
        fr.data.name = name;
        fr.data.newname = newname;
        fr.data.source = source;
        return this.get(action).then(resp => {
            if (fr.process) {
                resp = fr.process.call(self, resp);
            }
            return this.getMessage(resp);
        });
    }
    /**
     * Rename folder
     */
    folderRename(path, name, newname, source) {
        return this.rename('folderRename', path, name, newname, source);
    }
    /**
     * Rename file
     */
    fileRename(path, name, newname, source) {
        return this.rename('fileRename', path, name, newname, source);
    }
    changeImage(type, path, source, name, newname, box) {
        if (!this.o[type]) {
            this.o[type] = {
                data: {}
            };
        }
        // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
        const query = this.o[type];
        if (query.data === undefined) {
            query.data = {
                action: type
            };
        }
        query.data.newname = newname || name;
        if (box) {
            query.data.box = box;
        }
        query.data.path = path;
        query.data.name = name;
        query.data.source = source;
        return this.get(type).then(() => {
            return true;
        });
    }
    /**
     * Send command to server to crop image
     */
    crop(path, source, name, newname, box) {
        return this.changeImage('crop', path, source, name, newname, box);
    }
    /**
     * Send command to server to resize image
     */
    resize(path, source, name, newname, box) {
        return this.changeImage('resize', path, source, name, newname, box);
    }
    getMessage(resp) {
        return this.options.getMessage(resp);
    }
    isSuccess(resp) {
        return this.options.isSuccess(resp);
    }
    destruct() {
        this.__ajaxInstances.forEach(a => a.destruct());
        this.__ajaxInstances.clear();
    }
};
DataProvider = (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], DataProvider);
/* harmony default export */ __webpack_exports__.A = (DataProvider);


/***/ }),

/***/ 83797:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   S: function() { return /* binding */ makeDataProvider; },
/* harmony export */   V: function() { return /* binding */ makeContextMenu; }
/* harmony export */ });
/* harmony import */ var jodit_modules_context_menu_context_menu__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(34248);
/* harmony import */ var _data_provider__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(75889);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


function makeDataProvider(parent, options) {
    return new _data_provider__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A(parent, options);
}
function makeContextMenu(parent) {
    return new jodit_modules_context_menu_context_menu__WEBPACK_IMPORTED_MODULE_0__/* .ContextMenu */ .t(parent);
}


/***/ }),

/***/ 97324:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   W: function() { return /* binding */ deleteFile; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * Removes a file from the server
 * @private
 */
function deleteFile(fb, name, source) {
    return fb.dataProvider
        .fileRemove(fb.state.currentPath, name, source)
        .then(message => {
        fb.status(message || fb.i18n('File "%s" was deleted', name), true);
    })
        .catch(fb.status);
}


/***/ }),

/***/ 9979:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   f: function() { return /* binding */ loadItems; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * Loads a list of files and adds them to the state
 * @private
 */
function loadItems(fb) {
    fb.files.setMod('active', true);
    fb.files.setMod('loading', true);
    return fb.dataProvider
        .items(fb.state.currentPath, fb.state.currentSource, {
        sortBy: fb.state.sortBy,
        onlyImages: fb.state.onlyImages,
        filterWord: fb.state.filterWord
    })
        .then(resp => {
        if (resp) {
            fb.state.elements = resp;
            fb.state.activeElements = [];
        }
    })
        .catch(fb.status)
        .finally(() => fb.files.setMod('loading', false));
}


/***/ }),

/***/ 31859:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   r: function() { return /* binding */ loadTree; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71842);
/* harmony import */ var jodit_modules_file_browser_fetch_load_items__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9979);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



/**
 * Loads a list of directories
 * @private
 */
function loadTree(fb) {
    return (0,tslib__WEBPACK_IMPORTED_MODULE_1__/* .__awaiter */ .sH)(this, void 0, void 0, function* () {
        fb.tree.setMod('active', true);
        jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.detach(fb.tree.container);
        const items = (0,jodit_modules_file_browser_fetch_load_items__WEBPACK_IMPORTED_MODULE_2__/* .loadItems */ .f)(fb);
        if (fb.o.showFoldersPanel) {
            fb.tree.setMod('loading', true);
            const tree = fb.dataProvider
                .tree(fb.state.currentPath, fb.state.currentSource)
                .then(resp => {
                fb.state.sources = resp;
            })
                .catch(fb.status)
                .finally(() => fb.tree.setMod('loading', false));
            return Promise.all([tree, items]);
        }
        fb.tree.setMod('active', false);
        return items;
    });
}


/***/ }),

/***/ 140:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   V: function() { return /* binding */ FileBrowser; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(77753);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(66927);
/* harmony import */ var jodit_core_event_emitter__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(50025);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_storage__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(63915);
/* harmony import */ var jodit_core_traits_dlgs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(58597);
/* harmony import */ var jodit_core_view_view_with_toolbar__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(14961);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(36115);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(70265);
/* harmony import */ var _fetch_load_items__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(9979);
/* harmony import */ var _fetch_load_tree__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(31859);
/* harmony import */ var _listeners_native_listeners__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(62994);
/* harmony import */ var _listeners_self_listeners__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(18043);
/* harmony import */ var _listeners_state_listeners__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(80004);
/* harmony import */ var _data_provider__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(75889);
/* harmony import */ var _factories__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(83797);
/* harmony import */ var _ui__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(10274);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */






















let FileBrowser = class FileBrowser extends jodit_core_view_view_with_toolbar__WEBPACK_IMPORTED_MODULE_8__/* .ViewWithToolbar */ .T {
    /** @override */
    className() {
        return 'FileBrowser';
    }
    get dataProvider() {
        return (0,_factories__WEBPACK_IMPORTED_MODULE_16__/* .makeDataProvider */ .S)(this, this.options);
    }
    // eslint-disable-next-line no-unused-vars
    onSelect(callback) {
        return () => {
            if (this.state.activeElements.length) {
                const files = [];
                const isImages = [];
                this.state.activeElements.forEach(elm => {
                    const url = elm.fileURL;
                    if (url) {
                        files.push(url);
                        isImages.push(elm.isImage || false);
                    }
                });
                this.close();
                const data = {
                    baseurl: '',
                    files,
                    isImages
                };
                if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.isFunction)(callback)) {
                    callback(data);
                }
                this.close();
            }
            return false;
        };
    }
    get _dialog() {
        var _a;
        const dialog = this.dlg({
            minWidth: Math.min(700, screen.width),
            minHeight: 300,
            buttons: (_a = this.o.headerButtons) !== null && _a !== void 0 ? _a : ['fullsize', 'dialog.close']
        });
        ['beforeClose', 'afterClose', 'beforeOpen'].forEach(proxyEvent => dialog.events.on(dialog, proxyEvent, () => this.e.fire(proxyEvent)));
        dialog.setSize(this.o.width, this.o.height);
        return dialog;
    }
    /**
     * Container for set/get value
     */
    get storage() {
        return jodit_core_storage__WEBPACK_IMPORTED_MODULE_6__/* .Storage */ .wc.makeStorage(Boolean(this.o.saveStateInStorage), this.componentName);
    }
    get isOpened() {
        return this._dialog.isOpened && this.browser.style.display !== 'none';
    }
    /**
     * It displays a message in the status bar of filebrowser
     *
     * @param message - The message that will be displayed
     * @param success - true It will be shown a message light . If no option is specified ,
     * ßan error will be shown the red
     * @example
     * ```javascript
     * parent.filebrowser.status('There was an error uploading file', false);
     * ```
     */
    status(message, success) {
        if (!message || (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.isAbortError)(message)) {
            return;
        }
        if (!(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.isString)(message)) {
            message = message.message;
        }
        if (!(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.isString)(message) || !(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.trim)(message).length) {
            return;
        }
        this.message.message(message, success ? 'success' : 'error', this.o.howLongShowMsg);
    }
    /**
     * It opens a web browser window
     *
     * @param callback - The function that will be called after the file selection in the browser
     * @param onlyImages - Show only images
     * @example
     * ```javascript
     * var fb = new Jodit.modules.FileBrowser(parent);
     * fb.open(function (data) {
     *     var i;
     *     for (i = 0;i < data.files.length; i += 1) {
     *         parent.s.insertImage(data.baseurl + data.files[i]);
     *     }
     * });
     * ```
     */
    open(callback = this.o
        .defaultCallback, onlyImages = false) {
        this.state.onlyImages = onlyImages;
        return this.async
            .promise((resolve, reject) => {
            var _a;
            if (!this.o.items || !this.o.items.url) {
                throw (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.error)('Need set options.filebrowser.ajax.url');
            }
            let localTimeout = 0;
            this.e
                .off(this.files.container, 'dblclick')
                .on(this.files.container, 'dblclick', this.onSelect(callback))
                .on(this.files.container, 'touchstart', () => {
                const now = new Date().getTime();
                if (now - localTimeout <
                    jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.EMULATE_DBLCLICK_TIMEOUT) {
                    this.onSelect(callback)();
                }
                localTimeout = now;
            })
                .off('select.filebrowser')
                .on('select.filebrowser', this.onSelect(callback));
            const header = this.c.div();
            (_a = this.toolbar) === null || _a === void 0 ? void 0 : _a.appendTo(header);
            this.__updateToolbarButtons();
            this._dialog.open(this.browser, header);
            this.e.fire('sort.filebrowser', this.state.sortBy);
            (0,_fetch_load_tree__WEBPACK_IMPORTED_MODULE_11__/* .loadTree */ .r)(this)
                .then(resolve, reject)
                .finally(() => {
                var _a;
                if (this.isInDestruct) {
                    return;
                }
                (_a = this === null || this === void 0 ? void 0 : this.e) === null || _a === void 0 ? void 0 : _a.fire('fileBrowserReady.filebrowser');
            });
        })
            .catch((e) => {
            if (!(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.isAbortError)(e) && !jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.IS_PROD) {
                throw e;
            }
        });
    }
    __getButtons() {
        var _a;
        const options = ((_a = this.o.buttons) !== null && _a !== void 0 ? _a : []);
        return options.filter((btn) => {
            if (!(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.isString)(btn)) {
                return true;
            }
            switch (btn) {
                case 'filebrowser.upload':
                    return this.dataProvider.canI('FileUpload');
                case 'filebrowser.edit':
                    return (this.dataProvider.canI('ImageResize') ||
                        this.dataProvider.canI('ImageCrop'));
                case 'filebrowser.remove':
                    return this.dataProvider.canI('FileRemove');
            }
            return true;
        });
    }
    initUploader(editor) {
        var _a;
        const self = this, options = (_a = editor === null || editor === void 0 ? void 0 : editor.options) === null || _a === void 0 ? void 0 : _a.uploader, uploaderOptions = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.ConfigProto)(options || {}, jodit_config__WEBPACK_IMPORTED_MODULE_9__/* .Config */ .T.defaultOptions.uploader);
        const uploadHandler = () => (0,_fetch_load_items__WEBPACK_IMPORTED_MODULE_18__/* .loadItems */ .f)(this);
        self.uploader = self.getInstance('Uploader', uploaderOptions);
        self.uploader
            .setPath(self.state.currentPath)
            .setSource(self.state.currentSource)
            .bind(self.browser, uploadHandler, self.errorHandler);
        this.state.on(['change.currentPath', 'change.currentSource'], () => {
            this.uploader
                .setPath(this.state.currentPath)
                .setSource(this.state.currentSource);
        });
        self.e.on('bindUploader.filebrowser', (button) => {
            self.uploader.bind(button, uploadHandler, self.errorHandler);
        });
    }
    constructor(options) {
        super(options);
        this.browser = this.c.div(this.componentName);
        this.status_line = this.c.div(this.getFullElName('status'));
        this.tree = new _ui__WEBPACK_IMPORTED_MODULE_17__/* .FileBrowserTree */ .V(this);
        this.files = new _ui__WEBPACK_IMPORTED_MODULE_17__/* .FileBrowserFiles */ .Q(this);
        this.state = (0,jodit_core_event_emitter__WEBPACK_IMPORTED_MODULE_4__/* .observable */ .sH)({
            currentPath: '',
            currentSource: _data_provider__WEBPACK_IMPORTED_MODULE_15__/* .DEFAULT_SOURCE_NAME */ .o,
            currentBaseUrl: '',
            activeElements: [],
            elements: [],
            sources: [],
            view: 'tiles',
            sortBy: 'changed-desc',
            filterWord: '',
            onlyImages: false
        });
        this.errorHandler = (resp) => {
            if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.isAbortError)(resp)) {
                return;
            }
            if (resp instanceof Error) {
                this.status(this.i18n(resp.message));
            }
            else {
                this.status(this.dataProvider.getMessage(resp));
            }
        };
        /**
         * Close dialog
         */
        this.close = () => {
            this._dialog.close();
        };
        this.__prevButtons = [];
        this.attachEvents(options);
        const self = this;
        self.options = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.ConfigProto)(options || {}, jodit_config__WEBPACK_IMPORTED_MODULE_9__/* .Config */ .T.defaultOptions.filebrowser);
        self.browser.component = this;
        self.container = self.browser;
        if (self.o.showFoldersPanel) {
            self.browser.appendChild(self.tree.container);
        }
        self.browser.appendChild(self.files.container);
        self.browser.appendChild(self.status_line);
        _listeners_self_listeners__WEBPACK_IMPORTED_MODULE_13__/* .selfListeners */ .c.call(self);
        _listeners_native_listeners__WEBPACK_IMPORTED_MODULE_12__/* .nativeListeners */ .nW.call(self);
        _listeners_state_listeners__WEBPACK_IMPORTED_MODULE_14__/* .stateListeners */ .r.call(self);
        const keys = [
            'getLocalFileByUrl',
            'crop',
            'resize',
            'create',
            'fileMove',
            'folderMove',
            'fileRename',
            'folderRename',
            'fileRemove',
            'folderRemove',
            'folder',
            'items',
            'permissions'
        ];
        keys.forEach(key => {
            if (this.options[key] != null) {
                this.options[key] = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.ConfigProto)(this.options[key], this.o.ajax);
            }
        });
        const { storeView, storeSortBy, storeLastOpenedFolder } = this.o
            .saveStateInStorage || {
            storeLastOpenedFolder: false,
            storeView: false,
            storeSortBy: false
        };
        const view = storeView && this.storage.get('view');
        if (view && this.o.view == null) {
            self.state.view = view === 'list' ? 'list' : 'tiles';
        }
        else {
            self.state.view = self.o.view === 'list' ? 'list' : 'tiles';
        }
        self.files.setMod('view', self.state.view);
        const sortBy = storeSortBy && self.storage.get('sortBy');
        if (sortBy) {
            const parts = sortBy.split('-');
            self.state.sortBy = ['changed', 'name', 'size'].includes(parts[0])
                ? sortBy
                : 'changed-desc';
        }
        else {
            self.state.sortBy = self.o.sortBy || 'changed-desc';
        }
        if (storeLastOpenedFolder) {
            const currentPath = self.storage.get('currentPath'), currentSource = self.storage.get('currentSource');
            self.state.currentPath = currentPath !== null && currentPath !== void 0 ? currentPath : '';
            self.state.currentSource = currentSource !== null && currentSource !== void 0 ? currentSource : '';
        }
        self.initUploader(self);
        self.setStatus(jodit_core_component__WEBPACK_IMPORTED_MODULE_0__/* .STATUSES */ .f.ready);
    }
    destruct() {
        if (this.isInDestruct) {
            return;
        }
        super.destruct();
        this._dialog.destruct();
        this.events && this.e.off('.filebrowser');
        this.uploader && this.uploader.destruct();
    }
    __updateToolbarButtons() {
        var _a;
        const buttons = this.__getButtons();
        if (isEqualButtonList(this.__prevButtons, buttons)) {
            return;
        }
        this.__prevButtons = buttons;
        (_a = this.toolbar) === null || _a === void 0 ? void 0 : _a.build(buttons);
    }
};
(0,tslib__WEBPACK_IMPORTED_MODULE_19__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.cache
], FileBrowser.prototype, "dataProvider", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_19__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.cache
], FileBrowser.prototype, "_dialog", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_19__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.cache
], FileBrowser.prototype, "storage", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_19__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.autobind
], FileBrowser.prototype, "status", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_19__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.autobind
], FileBrowser.prototype, "open", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_19__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_3__/* .watch */ .w)('dataProvider:changePermissions')
], FileBrowser.prototype, "__updateToolbarButtons", null);
FileBrowser = (0,tslib__WEBPACK_IMPORTED_MODULE_19__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.derive)(jodit_core_traits_dlgs__WEBPACK_IMPORTED_MODULE_7__/* .Dlgs */ .z)
], FileBrowser);

function isEqualButtonList(prevButtons, buttons) {
    if (prevButtons.length !== buttons.length) {
        return false;
    }
    for (let i = 0; i < prevButtons.length; i++) {
        if (prevButtons[i] !== buttons[i]) {
            return false;
        }
    }
    return true;
}


/***/ }),

/***/ 19627:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   V: function() { return /* reexport safe */ _file_browser__WEBPACK_IMPORTED_MODULE_0__.V; }
/* harmony export */ });
/* harmony import */ var _file_browser__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(140);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * [[include:modules/file-browser/README.md]]
 * @packageDocumentation
 * @module modules/file-browser
 */



/***/ }),

/***/ 62994:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Gq: function() { return /* binding */ getItem; },
/* harmony export */   PZ: function() { return /* binding */ elementToItem; },
/* harmony export */   nW: function() { return /* binding */ nativeListeners; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(65147);
/* harmony import */ var jodit_modules_file_browser_builders_context_menu__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(49931);
/* harmony import */ var jodit_modules_file_browser_builders_elements_map__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(77112);
/* harmony import */ var jodit_modules_file_browser_fetch_load_tree__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(31859);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */





/**
 * @private
 */
const getItem = (node, root, tag = 'a') => jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.closest(node, elm => jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(elm, tag), root);
/**
 * @private
 */
const elementToItem = (elm, elementsMap) => {
    const { key } = elm.dataset, { item } = elementsMap[key || ''];
    return item;
};
/**
 * @private
 */
function nativeListeners() {
    let dragElement = false;
    const elmMap = (0,jodit_modules_file_browser_builders_elements_map__WEBPACK_IMPORTED_MODULE_3__/* .elementsMap */ .a)(this);
    const self = this;
    self.e
        .on(self.tree.container, 'dragstart', (e) => {
        const a = getItem(e.target, self.container);
        if (!a) {
            return;
        }
        if (self.o.moveFolder) {
            dragElement = a;
        }
    })
        .on(self.tree.container, 'drop', (e) => {
        if ((self.o.moveFile || self.o.moveFolder) && dragElement) {
            let path = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.attr)(dragElement, '-path') || '';
            // move folder
            if (!self.o.moveFolder &&
                dragElement.classList.contains(this.tree.getFullElName('item'))) {
                return false;
            }
            // move file
            if (dragElement.classList.contains(this.files.getFullElName('item'))) {
                path += (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.attr)(dragElement, '-name');
                if (!self.o.moveFile) {
                    return false;
                }
            }
            const a = getItem(e.target, self.container);
            if (!a) {
                return;
            }
            self.dataProvider
                .move(path, (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.attr)(a, '-path') || '', (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.attr)(a, '-source') || '', dragElement.classList.contains(this.files.getFullElName('item')))
                .then(() => (0,jodit_modules_file_browser_fetch_load_tree__WEBPACK_IMPORTED_MODULE_4__/* .loadTree */ .r)(this))
                .catch(self.status);
            dragElement = false;
        }
    })
        .on(self.files.container, 'contextmenu', (0,jodit_modules_file_browser_builders_context_menu__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A)(self))
        .on(self.files.container, 'click', (e) => {
        if (!(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.ctrlKey)(e)) {
            this.state.activeElements = [];
        }
    })
        .on(self.files.container, 'click', (e) => {
        const a = getItem(e.target, self.container);
        if (!a) {
            return;
        }
        const item = elementToItem(a, elmMap);
        if (!item) {
            return;
        }
        if (!(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.ctrlKey)(e)) {
            self.state.activeElements = [item];
        }
        else {
            self.state.activeElements = [
                ...self.state.activeElements,
                item
            ];
        }
        e.stopPropagation();
        return false;
    })
        .on(self.files.container, 'dragstart', (e) => {
        if (self.o.moveFile) {
            const a = getItem(e.target, self.container);
            if (!a) {
                return;
            }
            dragElement = a;
        }
    })
        .on(self.container, 'drop', (e) => e.preventDefault());
}


/***/ }),

/***/ 18043:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   c: function() { return /* binding */ selfListeners; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(9823);
/* harmony import */ var jodit_modules_file_browser_data_provider__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(75889);
/* harmony import */ var jodit_modules_file_browser_fetch_delete_file__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(97324);
/* harmony import */ var jodit_modules_file_browser_fetch_load_items__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(9979);
/* harmony import */ var jodit_modules_file_browser_fetch_load_tree__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(31859);
/* harmony import */ var jodit_modules_image_editor_image_editor__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(53804);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */







/**
 * @private
 */
function selfListeners() {
    const state = this.state, dp = this.dataProvider, self = this;
    self.e
        .on('view.filebrowser', (view) => {
        if (view !== state.view) {
            state.view = view;
        }
    })
        .on('sort.filebrowser', (value) => {
        if (value !== state.sortBy) {
            state.sortBy = value;
            (0,jodit_modules_file_browser_fetch_load_items__WEBPACK_IMPORTED_MODULE_5__/* .loadItems */ .f)(self);
        }
    })
        .on('filter.filebrowser', (value) => {
        if (value !== state.filterWord) {
            state.filterWord = value;
            (0,jodit_modules_file_browser_fetch_load_items__WEBPACK_IMPORTED_MODULE_5__/* .loadItems */ .f)(self);
        }
    })
        .on('openFolder.filebrowser', (data) => {
        let path;
        if (data.name === '..') {
            path = data.path
                .split('/')
                .filter((p) => p.length)
                .slice(0, -1)
                .join('/');
        }
        else {
            path = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.normalizePath)(data.path, data.name);
        }
        self.state.currentPath = path;
        self.state.currentSource =
            data.name === '.' ? jodit_modules_file_browser_data_provider__WEBPACK_IMPORTED_MODULE_2__/* .DEFAULT_SOURCE_NAME */ .o : data.source;
    })
        .on('removeFolder.filebrowser', (data) => {
        self.confirm('Are you sure?', 'Delete', (yes) => {
            if (yes) {
                dp.folderRemove(data.path, data.name, data.source)
                    .then(message => {
                    self.status(message, true);
                    return (0,jodit_modules_file_browser_fetch_load_tree__WEBPACK_IMPORTED_MODULE_3__/* .loadTree */ .r)(self);
                })
                    .catch(self.status);
            }
        });
    })
        .on('renameFolder.filebrowser', (data) => {
        self.prompt('Enter new name', 'Rename', (newName) => {
            if (!(0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_1__/* .isValidName */ .uV)(newName)) {
                self.status(self.i18n('Enter new name'));
                return false;
            }
            dp.folderRename(data.path, data.name, newName, data.source)
                .then(message => {
                self.state.activeElements = [];
                self.status(message, true);
                return (0,jodit_modules_file_browser_fetch_load_tree__WEBPACK_IMPORTED_MODULE_3__/* .loadTree */ .r)(self);
            })
                .catch(self.status);
            return;
        }, 'type name', data.name);
    })
        .on('addFolder.filebrowser', (data) => {
        self.prompt('Enter Directory name', 'Create directory', (name) => {
            dp.createFolder(name, data.path, data.source)
                .then(() => (0,jodit_modules_file_browser_fetch_load_tree__WEBPACK_IMPORTED_MODULE_3__/* .loadTree */ .r)(self))
                .catch(self.status);
        }, 'type name');
    })
        .on('fileRemove.filebrowser', () => {
        if (self.state.activeElements.length) {
            self.confirm('Are you sure?', '', (yes) => {
                if (yes) {
                    const promises = [];
                    self.state.activeElements.forEach(item => {
                        promises.push((0,jodit_modules_file_browser_fetch_delete_file__WEBPACK_IMPORTED_MODULE_6__/* .deleteFile */ .W)(self, item.file || item.name || '', item.sourceName));
                    });
                    self.state.activeElements = [];
                    Promise.all(promises).then(() => (0,jodit_modules_file_browser_fetch_load_tree__WEBPACK_IMPORTED_MODULE_3__/* .loadTree */ .r)(self).catch(self.status), self.status);
                }
            });
        }
    })
        .on('edit.filebrowser', () => {
        if (self.state.activeElements.length === 1) {
            const [file] = this.state.activeElements;
            jodit_modules_image_editor_image_editor__WEBPACK_IMPORTED_MODULE_4__/* .openImageEditor */ .B.call(self, file.fileURL, file.file || '', file.path, file.sourceName);
        }
    })
        .on('fileRename.filebrowser', (name, path, source) => {
        if (self.state.activeElements.length === 1) {
            self.prompt('Enter new name', 'Rename', (newName) => {
                if (!(0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_1__/* .isValidName */ .uV)(newName)) {
                    self.status(self.i18n('Enter new name'));
                    return false;
                }
                dp.fileRename(path, name, newName, source)
                    .then(message => {
                    self.state.activeElements = [];
                    self.status(message, true);
                    (0,jodit_modules_file_browser_fetch_load_items__WEBPACK_IMPORTED_MODULE_5__/* .loadItems */ .f)(self);
                })
                    .catch(self.status);
                return;
            }, 'type name', name);
        }
    })
        .on('update.filebrowser', () => {
        (0,jodit_modules_file_browser_fetch_load_tree__WEBPACK_IMPORTED_MODULE_3__/* .loadTree */ .r)(this).then(this.status, this.status);
    });
}


/***/ }),

/***/ 80004:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   r: function() { return /* binding */ stateListeners; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_helpers_normalize__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(65499);
/* harmony import */ var jodit_core_ui_button_button_button__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(92032);
/* harmony import */ var jodit_modules_file_browser_builders_elements_map__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(77112);
/* harmony import */ var jodit_modules_file_browser_fetch_load_tree__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(31859);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */





const DEFAULT_SOURCE_NAME = 'default';
/**
 * Convert state to view
 * @private
 */
function stateListeners() {
    const elmMap = (0,jodit_modules_file_browser_builders_elements_map__WEBPACK_IMPORTED_MODULE_3__/* .elementsMap */ .a)(this);
    const { state, files, create, options } = this, getDomElement = (item) => {
        const key = item.uniqueHashKey;
        if (elmMap[key]) {
            return elmMap[key].elm;
        }
        const elm = create.fromHTML(options.getThumbTemplate.call(this, item, item.source, item.sourceName.toString()));
        elm.dataset.key = key;
        elmMap[key] = {
            item,
            elm
        };
        return elmMap[key].elm;
    };
    state
        .on(['change.currentPath', 'change.currentSource'], this.async.debounce(() => {
        if (this.o.saveStateInStorage &&
            this.o.saveStateInStorage.storeLastOpenedFolder) {
            this.storage
                .set('currentPath', this.state.currentPath)
                .set('currentSource', this.state.currentSource);
        }
        (0,jodit_modules_file_browser_fetch_load_tree__WEBPACK_IMPORTED_MODULE_4__/* .loadTree */ .r)(this).catch(this.status);
    }, this.defaultTimeout))
        .on('beforeChange.activeElements', () => {
        state.activeElements.forEach(item => {
            const key = item.uniqueHashKey, { elm } = elmMap[key];
            elm &&
                elm.classList.remove(files.getFullElName('item', 'active', true));
        });
    })
        .on('change.activeElements', () => {
        this.e.fire('changeSelection');
        state.activeElements.forEach(item => {
            const key = item.uniqueHashKey, { elm } = elmMap[key];
            elm &&
                elm.classList.add(files.getFullElName('item', 'active', true));
        });
    })
        .on('change.view', () => {
        files.setMod('view', state.view);
        if (this.o.saveStateInStorage &&
            this.o.saveStateInStorage.storeView) {
            this.storage.set('view', state.view);
        }
    })
        .on('change.sortBy', () => {
        if (this.o.saveStateInStorage &&
            this.o.saveStateInStorage.storeSortBy) {
            this.storage.set('sortBy', state.sortBy);
        }
    })
        .on('change.elements', this.async.debounce(() => {
        jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.detach(files.container);
        if (state.elements.length) {
            state.elements.forEach(item => {
                this.files.container.appendChild(getDomElement(item));
            });
        }
        else {
            files.container.appendChild(create.div(this.componentName + '_no-files_true', this.i18n('There are no files')));
        }
    }, this.defaultTimeout))
        .on('change.sources', this.async.debounce(() => {
        jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.detach(this.tree.container);
        state.sources.forEach(source => {
            const sourceName = source.name;
            if (sourceName && sourceName !== DEFAULT_SOURCE_NAME) {
                this.tree.container.appendChild(create.div(this.tree.getFullElName('source-title'), sourceName));
            }
            source.folders.forEach((name) => {
                const folderElm = create.a(this.tree.getFullElName('item'), {
                    draggable: 'draggable',
                    href: '#',
                    'data-path': (0,jodit_core_helpers_normalize__WEBPACK_IMPORTED_MODULE_1__/* .normalizePath */ .Fd)(source.path, name + '/'),
                    'data-name': name,
                    'data-source': sourceName,
                    'data-source-path': source.path
                }, create.span(this.tree.getFullElName('item-title'), name));
                const action = (actionName) => (e) => {
                    this.e.fire(`${actionName}.filebrowser`, {
                        name,
                        path: (0,jodit_core_helpers_normalize__WEBPACK_IMPORTED_MODULE_1__/* .normalizePath */ .Fd)(source.path + '/'),
                        source: sourceName
                    });
                    e.stopPropagation();
                    e.preventDefault();
                };
                this.e.on(folderElm, 'click', action('openFolder'));
                this.tree.container.appendChild(folderElm);
                if (name === '..' || name === '.') {
                    return;
                }
                if (options.renameFolder &&
                    this.dataProvider.canI('FolderRename')) {
                    const btn = (0,jodit_core_ui_button_button_button__WEBPACK_IMPORTED_MODULE_2__/* .Button */ .$n)(this, {
                        icon: { name: 'pencil' },
                        name: 'rename',
                        tooltip: 'Rename',
                        size: 'tiny'
                    });
                    btn.onAction(action('renameFolder'));
                    folderElm.appendChild(btn.container);
                }
                if (options.deleteFolder &&
                    this.dataProvider.canI('FolderRemove')) {
                    const btn = (0,jodit_core_ui_button_button_button__WEBPACK_IMPORTED_MODULE_2__/* .Button */ .$n)(this, {
                        icon: { name: 'cancel' },
                        name: 'remove',
                        tooltip: 'Delete',
                        size: 'tiny'
                    });
                    btn.onAction(action('removeFolder'));
                    folderElm.appendChild(btn.container);
                }
            });
            if (options.createNewFolder &&
                this.dataProvider.canI('FolderCreate')) {
                const button = (0,jodit_core_ui_button_button_button__WEBPACK_IMPORTED_MODULE_2__/* .Button */ .$n)(this, 'plus', 'Add folder', 'secondary');
                button.onAction(() => {
                    this.e.fire('addFolder', {
                        path: (0,jodit_core_helpers_normalize__WEBPACK_IMPORTED_MODULE_1__/* .normalizePath */ .Fd)(source.path + '/'),
                        source: sourceName
                    });
                });
                this.tree.append(button);
            }
        });
    }, this.defaultTimeout));
}


/***/ }),

/***/ 96025:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Q: function() { return /* binding */ FileBrowserFiles; }
/* harmony export */ });
/* harmony import */ var jodit_core_ui__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(53048);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


class FileBrowserFiles extends jodit_core_ui__WEBPACK_IMPORTED_MODULE_0__/* .UIGroup */ .Ue {
    className() {
        return 'FileBrowserFiles';
    }
}


/***/ }),

/***/ 10274:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Q: function() { return /* reexport safe */ _files_files__WEBPACK_IMPORTED_MODULE_0__.Q; },
/* harmony export */   V: function() { return /* reexport safe */ _tree_tree__WEBPACK_IMPORTED_MODULE_1__.V; }
/* harmony export */ });
/* harmony import */ var _files_files__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(96025);
/* harmony import */ var _tree_tree__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(73307);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module modules/file-browser
 */




/***/ }),

/***/ 73307:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   V: function() { return /* binding */ FileBrowserTree; }
/* harmony export */ });
/* harmony import */ var jodit_core_ui__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(53048);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


class FileBrowserTree extends jodit_core_ui__WEBPACK_IMPORTED_MODULE_0__/* .UIGroup */ .Ue {
    className() {
        return 'FileBrowserTree';
    }
}


/***/ }),

/***/ 84345:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   u: function() { return /* binding */ Command; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
class Command {
    undo() {
        this.history.snapshot.restore(this.oldValue);
    }
    redo() {
        this.history.snapshot.restore(this.newValue);
    }
    constructor(oldValue, newValue, history, tick) {
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.history = history;
        this.tick = tick;
    }
}


/***/ }),

/***/ 69996:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   B: function() { return /* binding */ History; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(77753);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22664);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(36115);
/* harmony import */ var _command__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(84345);
/* harmony import */ var _snapshot__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(58770);
/* harmony import */ var _stack__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(66180);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */







jodit_config__WEBPACK_IMPORTED_MODULE_2__/* .Config */ .T.prototype.history = {
    enable: true,
    maxHistoryLength: Infinity,
    timeout: 1000
};
/**
 * The module monitors the status of the editor and creates / deletes the required number of Undo / Redo shots .
 */
class History extends jodit_core_component__WEBPACK_IMPORTED_MODULE_0__/* .ViewComponent */ .vG {
    /** @override */
    className() {
        return 'History';
    }
    /**
     * Return state of the WYSIWYG editor to step back
     */
    redo() {
        if (this.__stack.redo()) {
            this.startValue = this.snapshot.make();
            this.fireChangeStack();
        }
    }
    canRedo() {
        return this.__stack.canRedo();
    }
    /**
     * Return the state of the WYSIWYG editor to step forward
     */
    undo() {
        if (this.__stack.undo()) {
            this.startValue = this.snapshot.make();
            this.fireChangeStack();
        }
    }
    canUndo() {
        return this.__stack.canUndo();
    }
    clear() {
        this.startValue = this.snapshot.make();
        this.__stack.clear();
        this.fireChangeStack();
    }
    get length() {
        return this.__stack.length;
    }
    get startValue() {
        return this.__startValue;
    }
    set startValue(value) {
        this.__startValue = value;
    }
    constructor(editor, stack = new _stack__WEBPACK_IMPORTED_MODULE_4__/* .Stack */ .B(editor.o.history.maxHistoryLength), snapshot = new _snapshot__WEBPACK_IMPORTED_MODULE_3__/* .Snapshot */ .F(editor)) {
        super(editor);
        this.updateTick = 0;
        this.__stack = stack;
        this.snapshot = snapshot;
        if (editor.o.history.enable) {
            editor.e.on('afterAddPlace.history', () => {
                if (this.isInDestruct) {
                    return;
                }
                this.startValue = this.snapshot.make();
                editor.events
                    // save selection
                    .on('internalChange internalUpdate', () => {
                    this.startValue = this.snapshot.make();
                })
                    .on(editor.editor, [
                    'changeSelection',
                    'selectionstart',
                    'selectionchange',
                    'mousedown',
                    'mouseup',
                    'keydown',
                    'keyup'
                ]
                    .map(f => f + '.history')
                    .join(' '), () => {
                    if (this.startValue.html ===
                        this.j.getNativeEditorValue()) {
                        this.startValue = this.snapshot.make();
                    }
                })
                    .on(this, 'change.history', this.onChange);
            });
        }
    }
    /**
     * Update change counter
     * @internal
     */
    __upTick() {
        this.updateTick += 1;
    }
    /**
     * Push new command in stack on some changes
     */
    onChange() {
        this.__processChanges();
    }
    /**
     * @internal
     */
    __processChanges() {
        if (this.snapshot.isBlocked || !this.j.o.history.enable) {
            return;
        }
        this.updateStack();
    }
    /**
     * Update history stack
     */
    updateStack(replace = false) {
        const newValue = this.snapshot.make();
        if (!_snapshot__WEBPACK_IMPORTED_MODULE_3__/* .Snapshot */ .F.equal(newValue, this.startValue)) {
            const newCommand = new _command__WEBPACK_IMPORTED_MODULE_5__/* .Command */ .u(this.startValue, newValue, this, this.updateTick);
            if (replace) {
                const command = this.__stack.current();
                if (command && this.updateTick === command.tick) {
                    this.__stack.replace(newCommand);
                }
            }
            else {
                this.__stack.push(newCommand);
            }
            this.startValue = newValue;
            this.fireChangeStack();
        }
    }
    fireChangeStack() {
        var _a;
        this.j && !this.j.isInDestruct && ((_a = this.j.events) === null || _a === void 0 ? void 0 : _a.fire('changeStack'));
    }
    destruct() {
        if (this.isInDestruct) {
            return;
        }
        if (this.j.events) {
            this.j.e.off('.history');
        }
        this.snapshot.destruct();
        super.destruct();
    }
}
(0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.debounce)()
], History.prototype, "onChange", null);


/***/ }),

/***/ 58770:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   F: function() { return /* binding */ Snapshot; }
/* harmony export */ });
/* harmony import */ var jodit_core_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(77753);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(71842);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



/**
 * Module for creating snapshot of editor which includes html content and the current selection
 */
class Snapshot extends jodit_core_component__WEBPACK_IMPORTED_MODULE_0__/* .ViewComponent */ .vG {
    constructor() {
        super(...arguments);
        this.__isBlocked = false;
    }
    /** @override */
    className() {
        return 'Snapshot';
    }
    /**
     * Compare two snapshotes, if and htmls and selections match, then return true
     *
     * @param first - the first snapshote
     * @param second - second shot
     */
    static equal(first, second) {
        return (first.html === second.html &&
            JSON.stringify(first.range) === JSON.stringify(second.range));
    }
    /**
     * Calc count element before some node in parentNode. All text nodes are joined
     */
    static countNodesBeforeInParent(elm) {
        if (!elm.parentNode) {
            return 0;
        }
        const elms = elm.parentNode.childNodes;
        let count = 0, previous = null;
        for (let j = 0; j < elms.length; j += 1) {
            if (previous &&
                !this.isIgnoredNode(elms[j]) &&
                !(jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isText(previous) && jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isText(elms[j]))) {
                count += 1;
            }
            if (elms[j] === elm) {
                return count;
            }
            previous = elms[j];
        }
        return 0;
    }
    /**
     * Calc normal offset in joined text nodes
     */
    static strokeOffset(elm, offset) {
        while (jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isText(elm)) {
            elm = elm.previousSibling;
            if (jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isText(elm) && elm.nodeValue) {
                offset += elm.nodeValue.length;
            }
        }
        return offset;
    }
    /**
     * Calc whole hierarchy path before some element in editor's tree
     */
    calcHierarchyLadder(elm) {
        const counts = [];
        if (!elm || !elm.parentNode || !jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isOrContains(this.j.editor, elm)) {
            return [];
        }
        while (elm && elm !== this.j.editor) {
            if (elm && !Snapshot.isIgnoredNode(elm)) {
                counts.push(Snapshot.countNodesBeforeInParent(elm));
            }
            elm = elm.parentNode;
        }
        return counts.reverse();
    }
    getElementByLadder(ladder) {
        let n = this.j.editor, i;
        for (i = 0; n && i < ladder.length; i += 1) {
            n = n.childNodes[ladder[i]];
        }
        return n;
    }
    get isBlocked() {
        return this.__isBlocked;
    }
    __block(enable) {
        this.__isBlocked = enable;
    }
    transaction(changes) {
        this.__block(true);
        try {
            changes();
        }
        catch (e) {
            if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.IS_PROD) {
                throw e;
            }
        }
        this.__block(false);
    }
    /**
     * Creates object a snapshot of editor: html and the current selection. Current selection calculate by
     * offset by start document
     * \{html: string, range: \{startContainer: int, startOffset: int, endContainer: int, endOffset: int\}\} or
     * \{html: string\} without selection
     */
    make() {
        const snapshot = {
            html: '',
            range: {
                startContainer: [],
                startOffset: 0,
                endContainer: [],
                endOffset: 0
            }
        };
        snapshot.html = this.removeJoditSelection(this.j.editor);
        const sel = this.j.s.sel;
        if (sel && sel.rangeCount) {
            const range = sel.getRangeAt(0), startContainer = this.calcHierarchyLadder(range.startContainer), endContainer = this.calcHierarchyLadder(range.endContainer);
            let startOffset = Snapshot.strokeOffset(range.startContainer, range.startOffset), endOffset = Snapshot.strokeOffset(range.endContainer, range.endOffset);
            if (!startContainer.length &&
                range.startContainer !== this.j.editor) {
                startOffset = 0;
            }
            if (!endContainer.length && range.endContainer !== this.j.editor) {
                endOffset = 0;
            }
            snapshot.range = {
                startContainer,
                startOffset,
                endContainer,
                endOffset
            };
        }
        return snapshot;
    }
    /**
     * Restores the state of the editor of the snapshot. Rebounding is not only html but selected text
     *
     * @param snapshot - snapshot of editor resulting from the `[[Snapshot.make]]` method
     * @see make
     */
    restore(snapshot) {
        this.transaction(() => {
            const scroll = this.storeScrollState();
            const value = this.j.getNativeEditorValue();
            if (value !== snapshot.html) {
                this.j.value = snapshot.html;
            }
            this.restoreOnlySelection(snapshot);
            this.restoreScrollState(scroll);
        });
    }
    storeScrollState() {
        return [this.j.ow.scrollY, this.j.editor.scrollTop];
    }
    restoreScrollState(scrolls) {
        const { j } = this, { ow } = j;
        ow.scrollTo(ow.scrollX, scrolls[0]);
        j.editor.scrollTop = scrolls[1];
    }
    /**
     * Restore selection from snapshot
     *
     * @param snapshot - snapshot of editor resulting from the [[Snapshot.make]] method
     * @see make
     */
    restoreOnlySelection(snapshot) {
        try {
            if (snapshot.range) {
                const range = this.j.ed.createRange();
                range.setStart(this.getElementByLadder(snapshot.range.startContainer), snapshot.range.startOffset);
                range.setEnd(this.getElementByLadder(snapshot.range.endContainer), snapshot.range.endOffset);
                this.j.s.selectRange(range);
            }
        }
        catch (__ignore) {
            this.j.editor.lastChild &&
                this.j.s.setCursorAfter(this.j.editor.lastChild);
            if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.IS_PROD) {
                // tslint:disable-next-line:no-console
                console.warn('Broken snapshot', __ignore);
            }
        }
    }
    destruct() {
        this.__block(false);
        super.destruct();
    }
    static isIgnoredNode(node) {
        return (jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isText(node) && !node.nodeValue) || jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isTemporary(node);
    }
    removeJoditSelection(node) {
        const clone = node.cloneNode(true);
        clone.querySelectorAll(`[${jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.TEMP_ATTR}]`).forEach(jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.unwrap);
        return clone.innerHTML;
    }
}


/***/ }),

/***/ 66180:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   B: function() { return /* binding */ Stack; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
class Stack {
    constructor(size) {
        this.size = size;
        this.commands = [];
        this.stackPosition = -1;
    }
    get length() {
        return this.commands.length;
    }
    clearRedo() {
        this.commands.length = this.stackPosition + 1;
    }
    clear() {
        this.commands.length = 0;
        this.stackPosition = -1;
    }
    push(command) {
        this.clearRedo();
        this.commands.push(command);
        this.stackPosition += 1;
        if (this.commands.length > this.size) {
            this.commands.shift();
            this.stackPosition -= 1;
        }
    }
    replace(command) {
        this.commands[this.stackPosition] = command;
    }
    current() {
        return this.commands[this.stackPosition];
    }
    undo() {
        if (this.canUndo()) {
            if (this.commands[this.stackPosition]) {
                this.commands[this.stackPosition].undo();
            }
            this.stackPosition -= 1;
            return true;
        }
        return false;
    }
    redo() {
        if (this.canRedo()) {
            this.stackPosition += 1;
            if (this.commands[this.stackPosition]) {
                this.commands[this.stackPosition].redo();
            }
            return true;
        }
        return false;
    }
    canUndo() {
        return this.stackPosition >= 0;
    }
    canRedo() {
        return this.stackPosition < this.commands.length - 1;
    }
}


/***/ }),

/***/ 93027:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(931);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(36115);
/* harmony import */ var _icons_crop_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(928);
/* harmony import */ var _icons_crop_svg__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_icons_crop_svg__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _icons_resize_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(31230);
/* harmony import */ var _icons_resize_svg__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_icons_resize_svg__WEBPACK_IMPORTED_MODULE_3__);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */




jodit_config__WEBPACK_IMPORTED_MODULE_1__/* .Config */ .T.prototype.imageeditor = {
    min_width: 20,
    min_height: 20,
    closeAfterSave: false,
    width: '85%',
    height: '85%',
    crop: true,
    resize: true,
    resizeUseRatio: true,
    resizeMinWidth: 20,
    resizeMinHeight: 20,
    cropUseRatio: true,
    cropDefaultWidth: '70%',
    cropDefaultHeight: '70%'
};
jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_0__/* .Icon */ .I.set('crop', (_icons_crop_svg__WEBPACK_IMPORTED_MODULE_2___default())).set('resize', (_icons_resize_svg__WEBPACK_IMPORTED_MODULE_3___default()));


/***/ }),

/***/ 53804:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   B: function() { return /* binding */ openImageEditor; },
/* harmony export */   n: function() { return /* binding */ ImageEditor; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(77753);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(35265);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(36115);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(93027);
/* harmony import */ var _templates_form__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(24863);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
var ImageEditor_1;










const jie = 'jodit-image-editor';
const TABS = {
    resize: 'resize',
    crop: 'crop'
};
/**
 * The module allows you to edit the image: resize or cut any part of it
 *
 */
let ImageEditor = ImageEditor_1 = class ImageEditor extends jodit_core_component__WEBPACK_IMPORTED_MODULE_0__/* .ViewComponent */ .vG {
    /** @override */
    className() {
        return 'ImageEditor';
    }
    get o() {
        return this.options;
    }
    /**
     * Hide image editor
     */
    hide() {
        this._dialog.close();
    }
    /**
     * Open image editor
     * @example
     * ```javascript
     * const jodit = Jodit.make('.editor', {
     *		 imageeditor: {
     *				 crop: false,
     *				 closeAfterSave: true,
     *				 width: 500
     *		 }
     * });
     * jodit.imageeditor.open('https://xdsoft.net/jodit/images/test.png', function (name, data, success, failed) {
     *		 var img = jodit.node.c('img');
     *		 img.setAttribute('src', 'https://xdsoft.net/jodit/images/test.png');
     *		 if (box.action !== 'resize') {
     *					return failed('Sorry it is work only in resize mode. For croping use FileBrowser');
     *		 }
     *		 img.style.width = data.w;
     *		 img.style.height = data.h;
     *		 jodit.s.insertNode(img);
     *		 success();
     * });
     * ```
     */
    open(url, save) {
        return this.j.async.promise((resolve) => {
            const timestamp = new Date().getTime();
            this.image = this.j.c.element('img');
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.$$)('img,.jodit-icon_loader', this.resize_box).forEach(jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.safeRemove);
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.$$)('img,.jodit-icon_loader', this.crop_box).forEach(jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.safeRemove);
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.css)(this.cropHandler, 'background', 'transparent');
            this.onSave = save;
            this.resize_box.appendChild(this.j.c.element('i', { class: 'jodit-icon_loader' }));
            this.crop_box.appendChild(this.j.c.element('i', { class: 'jodit-icon_loader' }));
            if (/\?/.test(url)) {
                url += '&_tst=' + timestamp;
            }
            else {
                url += '?_tst=' + timestamp;
            }
            this.image.setAttribute('src', url);
            this._dialog.open();
            const { widthInput, heightInput } = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.refs)(this.editor);
            const onload = () => {
                if (this.isDestructed) {
                    return;
                }
                this.image.removeEventListener('load', onload);
                this.naturalWidth = this.image.naturalWidth;
                this.naturalHeight = this.image.naturalHeight;
                widthInput.value = this.naturalWidth.toString();
                heightInput.value = this.naturalHeight.toString();
                this.ratio = this.naturalWidth / this.naturalHeight;
                this.resize_box.appendChild(this.image);
                this.cropImage = this.image.cloneNode(true);
                this.crop_box.appendChild(this.cropImage);
                jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.safeRemove.apply(null, (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.$$)('.jodit-icon_loader', this.editor));
                if (this.activeTab === TABS.crop) {
                    this.showCrop();
                }
                this.j.e.fire(this.resizeHandler, 'updatesize');
                this.j.e.fire(this.cropHandler, 'updatesize');
                this._dialog.setPosition();
                this.j.e.fire('afterImageEditor');
                resolve(this._dialog);
            };
            this.image.addEventListener('load', onload);
            if (this.image.complete) {
                onload();
            }
        });
    }
    onTitleModeClick(e) {
        const self = this, title = e.target;
        const slide = title === null || title === void 0 ? void 0 : title.parentElement;
        if (!slide) {
            return;
        }
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.$$)(`.${jie}__slider,.${jie}__area`, self.editor).forEach(elm => elm.classList.remove(`${jie}_active`));
        slide.classList.add(`${jie}_active`);
        this.activeTab = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(slide, '-area') || TABS.resize;
        const tab = self.editor.querySelector(`.${jie}__area.${jie}__area_` + self.activeTab);
        if (tab) {
            tab.classList.add(`${jie}_active`);
        }
        if (self.activeTab === TABS.crop) {
            self.showCrop();
        }
    }
    onChangeSizeInput(e) {
        const self = this, input = e.target, { widthInput, heightInput } = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.refs)(this.editor), isWidth = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(input, 'data-ref') === 'widthInput', x = parseInt(input.value, 10), minX = isWidth ? self.o.min_width : self.o.min_height, minY = !isWidth ? self.o.min_width : self.o.min_height;
        let y;
        if (x > minX) {
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.css)(self.image, isWidth ? 'width' : 'height', x);
            if (self.resizeUseRatio) {
                y = isWidth
                    ? Math.round(x / self.ratio)
                    : Math.round(x * self.ratio);
                if (y > minY) {
                    (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.css)(self.image, !isWidth ? 'width' : 'height', y);
                    if (isWidth) {
                        heightInput.value = y.toString();
                    }
                    else {
                        widthInput.value = y.toString();
                    }
                }
            }
        }
        this.j.e.fire(self.resizeHandler, 'updatesize');
    }
    onResizeHandleMouseDown(e) {
        const self = this;
        self.target = e.target;
        e.preventDefault();
        e.stopImmediatePropagation();
        self.clicked = true;
        self.start_x = e.clientX;
        self.start_y = e.clientY;
        if (self.activeTab === TABS.crop) {
            self.top_x = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.css)(self.cropHandler, 'left');
            self.top_y = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.css)(self.cropHandler, 'top');
            self.width = self.cropHandler.offsetWidth;
            self.height = self.cropHandler.offsetHeight;
        }
        else {
            self.width = self.image.offsetWidth;
            self.height = self.image.offsetHeight;
        }
        self.j.e
            .on(this.j.ow, 'mousemove', this.onGlobalMouseMove)
            .one(this.j.ow, 'mouseup', this.onGlobalMouseUp);
    }
    onGlobalMouseUp(e) {
        if (this.clicked) {
            this.clicked = false;
            e.stopImmediatePropagation();
            this.j.e.off(this.j.ow, 'mousemove', this.onGlobalMouseMove);
        }
    }
    onGlobalMouseMove(e) {
        const self = this;
        if (!self.clicked) {
            return;
        }
        const { widthInput, heightInput } = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.refs)(this.editor);
        self.diff_x = e.clientX - self.start_x;
        self.diff_y = e.clientY - self.start_y;
        if ((self.activeTab === TABS.resize && self.resizeUseRatio) ||
            (self.activeTab === TABS.crop && self.cropUseRatio)) {
            if (self.diff_x) {
                self.new_w = self.width + self.diff_x;
                self.new_h = Math.round(self.new_w / self.ratio);
            }
            else {
                self.new_h = self.height + self.diff_y;
                self.new_w = Math.round(self.new_h * self.ratio);
            }
        }
        else {
            self.new_w = self.width + self.diff_x;
            self.new_h = self.height + self.diff_y;
        }
        if (self.activeTab === TABS.resize) {
            if (self.new_w > self.o.resizeMinWidth) {
                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.css)(self.image, 'width', self.new_w + 'px');
                widthInput.value = self.new_w.toString();
            }
            if (self.new_h > self.o.resizeMinHeight) {
                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.css)(self.image, 'height', self.new_h + 'px');
                heightInput.value = self.new_h.toString();
            }
            this.j.e.fire(self.resizeHandler, 'updatesize');
        }
        else {
            if (self.target !== self.cropHandler) {
                if (self.top_x + self.new_w > self.cropImage.offsetWidth) {
                    self.new_w = self.cropImage.offsetWidth - self.top_x;
                }
                if (self.top_y + self.new_h > self.cropImage.offsetHeight) {
                    self.new_h = self.cropImage.offsetHeight - self.top_y;
                }
                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.css)(self.cropHandler, {
                    width: self.new_w,
                    height: self.new_h
                });
            }
            else {
                if (self.top_x + self.diff_x + self.cropHandler.offsetWidth >
                    self.cropImage.offsetWidth) {
                    self.diff_x =
                        self.cropImage.offsetWidth -
                            self.top_x -
                            self.cropHandler.offsetWidth;
                }
                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.css)(self.cropHandler, 'left', self.top_x + self.diff_x);
                if (self.top_y + self.diff_y + self.cropHandler.offsetHeight >
                    self.cropImage.offsetHeight) {
                    self.diff_y =
                        self.cropImage.offsetHeight -
                            self.top_y -
                            self.cropHandler.offsetHeight;
                }
                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.css)(self.cropHandler, 'top', self.top_y + self.diff_y);
            }
            this.j.e.fire(self.cropHandler, 'updatesize');
        }
    }
    constructor(editor) {
        super(editor);
        this.resizeUseRatio = true;
        this.cropUseRatio = true;
        this.clicked = false;
        this.start_x = 0;
        this.start_y = 0;
        this.top_x = 0;
        this.top_y = 0;
        this.width = 0;
        this.height = 0;
        this.activeTab = TABS.resize;
        this.naturalWidth = 0;
        this.naturalHeight = 0;
        this.ratio = 0;
        this.new_h = 0;
        this.new_w = 0;
        this.diff_x = 0;
        this.diff_y = 0;
        this.cropBox = {
            x: 0,
            y: 0,
            w: 0,
            h: 0
        };
        this.resizeBox = {
            w: 0,
            h: 0
        };
        this.calcCropBox = () => {
            const node = this.crop_box.parentNode, w = node.offsetWidth * 0.8, h = node.offsetHeight * 0.8;
            let wn = w, hn = h;
            const { naturalWidth: nw, naturalHeight: nh } = this;
            if (w > nw && h > nh) {
                wn = nw;
                hn = nh;
            }
            else if (this.ratio > w / h) {
                wn = w;
                hn = nh * (w / nw);
            }
            else {
                wn = nw * (h / nh);
                hn = h;
            }
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.css)(this.crop_box, {
                width: wn,
                height: hn
            });
        };
        this.showCrop = () => {
            if (!this.cropImage) {
                return;
            }
            this.calcCropBox();
            const w = this.cropImage.offsetWidth ||
                this.image.offsetWidth ||
                this.image.naturalWidth;
            this.new_w = ImageEditor_1.calcValueByPercent(w, this.o.cropDefaultWidth);
            const h = this.cropImage.offsetHeight ||
                this.image.offsetHeight ||
                this.image.naturalHeight;
            if (this.cropUseRatio) {
                this.new_h = this.new_w / this.ratio;
            }
            else {
                this.new_h = ImageEditor_1.calcValueByPercent(h, this.o.cropDefaultHeight);
            }
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.css)(this.cropHandler, {
                backgroundImage: 'url(' + (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(this.cropImage, 'src') + ')',
                width: this.new_w,
                height: this.new_h,
                left: w / 2 - this.new_w / 2,
                top: h / 2 - this.new_h / 2
            });
            this.j.e.fire(this.cropHandler, 'updatesize');
        };
        this.updateCropBox = () => {
            if (!this.cropImage) {
                return;
            }
            const ratioX = this.cropImage.offsetWidth / this.naturalWidth, ratioY = this.cropImage.offsetHeight / this.naturalHeight;
            this.cropBox.x = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.css)(this.cropHandler, 'left') / ratioX;
            this.cropBox.y = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.css)(this.cropHandler, 'top') / ratioY;
            this.cropBox.w = this.cropHandler.offsetWidth / ratioX;
            this.cropBox.h = this.cropHandler.offsetHeight / ratioY;
            this.sizes.textContent =
                this.cropBox.w.toFixed(0) + 'x' + this.cropBox.h.toFixed(0);
        };
        this.updateResizeBox = () => {
            this.resizeBox.w = this.image.offsetWidth || this.naturalWidth;
            this.resizeBox.h = this.image.offsetHeight || this.naturalHeight;
        };
        this.setHandlers = () => {
            const self = this;
            const { widthInput, heightInput } = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.refs)(this.editor);
            self.j.e
                .on([
                self.editor.querySelector('.jodit_bottomright'),
                self.cropHandler
            ], `mousedown.${jie}`, this.onResizeHandleMouseDown)
                .on(this.j.ow, `resize.${jie}`, () => {
                this.j.e.fire(self.resizeHandler, 'updatesize');
                self.showCrop();
                this.j.e.fire(self.cropHandler, 'updatesize');
            });
            self.j.e
                .on((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.toArray)(this.editor.querySelectorAll(`.${jie}__slider-title`)), 'click', this.onTitleModeClick)
                .on([widthInput, heightInput], 'input', this.onChangeSizeInput);
            const { keepAspectRatioResize, keepAspectRatioCrop } = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.refs)(this.editor);
            if (keepAspectRatioResize) {
                keepAspectRatioResize.addEventListener('change', () => {
                    this.resizeUseRatio = keepAspectRatioResize.checked;
                });
            }
            if (keepAspectRatioCrop) {
                keepAspectRatioCrop.addEventListener('change', () => {
                    this.cropUseRatio = keepAspectRatioCrop.checked;
                });
            }
            self.j.e
                .on(self.resizeHandler, 'updatesize', () => {
                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.css)(self.resizeHandler, {
                    top: 0,
                    left: 0,
                    width: self.image.offsetWidth || self.naturalWidth,
                    height: self.image.offsetHeight || self.naturalHeight
                });
                this.updateResizeBox();
            })
                .on(self.cropHandler, 'updatesize', () => {
                if (!self.cropImage) {
                    return;
                }
                let new_x = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.css)(self.cropHandler, 'left'), new_y = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.css)(self.cropHandler, 'top'), new_width = self.cropHandler.offsetWidth, new_height = self.cropHandler.offsetHeight;
                if (new_x < 0) {
                    new_x = 0;
                }
                if (new_y < 0) {
                    new_y = 0;
                }
                if (new_x + new_width > self.cropImage.offsetWidth) {
                    new_width = self.cropImage.offsetWidth - new_x;
                    if (self.cropUseRatio) {
                        new_height = new_width / self.ratio;
                    }
                }
                if (new_y + new_height > self.cropImage.offsetHeight) {
                    new_height = self.cropImage.offsetHeight - new_y;
                    if (self.cropUseRatio) {
                        new_width = new_height * self.ratio;
                    }
                }
                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.css)(self.cropHandler, {
                    width: new_width,
                    height: new_height,
                    left: new_x,
                    top: new_y,
                    backgroundPosition: -new_x - 1 + 'px ' + (-new_y - 1) + 'px',
                    backgroundSize: self.cropImage.offsetWidth +
                        'px ' +
                        self.cropImage.offsetHeight +
                        'px'
                });
                self.updateCropBox();
            });
            Object.values(self.buttons).forEach(button => {
                button.onAction(() => {
                    const data = {
                        action: self.activeTab,
                        box: self.activeTab === TABS.resize
                            ? self.resizeBox
                            : self.cropBox
                    };
                    switch (button) {
                        case self.buttons.saveas:
                            self.j.prompt('Enter new name', 'Save in new file', (name) => {
                                if (!(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.trim)(name)) {
                                    self.j.alert('The name should not be empty');
                                    return false;
                                }
                                self.onSave(name, data, self.hide, (e) => {
                                    self.j.alert(e.message);
                                });
                            });
                            break;
                        case self.buttons.save:
                            self.onSave(undefined, data, self.hide, (e) => {
                                self.j.alert(e.message);
                            });
                            break;
                        case self.buttons.reset:
                            if (self.activeTab === TABS.resize) {
                                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.css)(self.image, {
                                    width: null,
                                    height: null
                                });
                                widthInput.value = self.naturalWidth.toString();
                                heightInput.value = self.naturalHeight.toString();
                                self.j.e.fire(self.resizeHandler, 'updatesize');
                            }
                            else {
                                self.showCrop();
                            }
                            break;
                    }
                });
            });
        };
        this.options =
            editor && editor.o && editor.o.imageeditor
                ? editor.o.imageeditor
                : jodit_config__WEBPACK_IMPORTED_MODULE_5__/* .Config */ .T.defaultOptions.imageeditor;
        const o = this.options;
        this.resizeUseRatio = o.resizeUseRatio;
        this.cropUseRatio = o.cropUseRatio;
        this.buttons = {
            reset: (0,jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_4__/* .Button */ .$n)(this.j, 'update', 'Reset'),
            save: (0,jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_4__/* .Button */ .$n)(this.j, 'save', 'Save'),
            saveas: (0,jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_4__/* .Button */ .$n)(this.j, 'save', 'Save as ...')
        };
        this.activeTab = o.resize ? TABS.resize : TABS.crop;
        this.editor = (0,_templates_form__WEBPACK_IMPORTED_MODULE_7__/* .form */ .Z)(this.j, this.options);
        const { resizeBox, cropBox } = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.refs)(this.editor);
        this.resize_box = resizeBox;
        this.crop_box = cropBox;
        this.sizes = this.editor.querySelector(`.${jie}__area.${jie}__area_crop .jodit-image-editor__sizes`);
        this.resizeHandler = this.editor.querySelector(`.${jie}__resizer`);
        this.cropHandler = this.editor.querySelector(`.${jie}__croper`);
        this._dialog = this.j.dlg({
            buttons: ['fullsize', 'dialog.close']
        });
        this._dialog.setContent(this.editor);
        this._dialog.setSize(this.o.width, this.o.height);
        this._dialog.setHeader([
            this.buttons.reset,
            this.buttons.save,
            this.buttons.saveas
        ]);
        this.setHandlers();
    }
    /** @override */
    destruct() {
        if (this.isDestructed) {
            return;
        }
        if (this._dialog && !this._dialog.isInDestruct) {
            this._dialog.destruct();
        }
        jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.safeRemove(this.editor);
        if (this.j.e) {
            this.j.e
                .off(this.j.ow, 'mousemove', this.onGlobalMouseMove)
                .off(this.j.ow, 'mouseup', this.onGlobalMouseUp)
                .off(this.ow, `.${jie}`)
                .off(`.${jie}`);
        }
        super.destruct();
    }
};
ImageEditor.calcValueByPercent = (value, percent) => {
    const percentStr = percent.toString();
    const valueNbr = parseFloat(value.toString());
    let match;
    match = /^[-+]?[0-9]+(px)?$/.exec(percentStr);
    if (match) {
        return parseInt(percentStr, 10);
    }
    match = /^([-+]?[0-9.]+)%$/.exec(percentStr);
    if (match) {
        return Math.round(valueNbr * (parseFloat(match[1]) / 100));
    }
    return valueNbr || 0;
};
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], ImageEditor.prototype, "hide", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], ImageEditor.prototype, "open", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], ImageEditor.prototype, "onTitleModeClick", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.debounce)(),
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], ImageEditor.prototype, "onChangeSizeInput", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], ImageEditor.prototype, "onResizeHandleMouseDown", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], ImageEditor.prototype, "onGlobalMouseUp", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.throttle)(10)
], ImageEditor.prototype, "onGlobalMouseMove", null);
ImageEditor = ImageEditor_1 = (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.component
], ImageEditor);

/**
 * Open Image Editor
 */
function openImageEditor(href, name, path, source, onSuccess, onFailed) {
    return this.getInstance('ImageEditor', this.o).open(href, (newname, box, success, failed) => (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.call)(box.action === 'resize'
        ? this.dataProvider.resize
        : this.dataProvider.crop, path, source, name, newname, box.box)
        .then(ok => {
        if (ok) {
            success();
            if (onSuccess) {
                onSuccess();
            }
        }
    })
        .catch(error => {
        failed(error);
        if (onFailed) {
            onFailed(error);
        }
    }));
}


/***/ }),

/***/ 24863:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: function() { return /* binding */ form; }
/* harmony export */ });
/* harmony import */ var jodit_core_ui__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(53048);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

const jie = 'jodit-image-editor';
const gi = jodit_core_ui__WEBPACK_IMPORTED_MODULE_0__/* .Icon */ .In.get.bind(jodit_core_ui__WEBPACK_IMPORTED_MODULE_0__/* .Icon */ .In);
const act = (el, className = 'jodti-image-editor_active') => el ? className : '';
const form = (editor, o) => {
    const i = editor.i18n.bind(editor);
    const switcher = (label, ref, active = true) => `<div class="jodit-form__group">
			<label class="jodit-switcher-wrapper">
				<span class='jodit-switcher'>
					<input ${act(active, 'checked')} data-ref="${ref}" type="checkbox"/>
					<span class="jodit-switcher__slider"></span>
				</span>
				<span>${i(label)}</span>
			</label>
	</div>`;
    return editor.create.fromHTML(`<form class="${jie} jodit-properties">
		<div class="jodit-grid jodit-grid_xs-column">
			<div class="jodit_col-lg-3-4 jodit_col-sm-5-5">
			${o.resize
        ? `<div class="${jie}__area ${jie}__area_resize ${jie}_active">
							<div data-ref="resizeBox" class="${jie}__box"></div>
							<div class="${jie}__resizer">
								<i class="jodit_bottomright"></i>
							</div>
						</div>`
        : ''}
			${o.crop
        ? `<div class="${jie}__area ${jie}__area_crop ${act(!o.resize)}">
							<div data-ref="cropBox" class="${jie}__box">
								<div class="${jie}__croper">
									<i class="jodit_bottomright"></i>
									<i class="${jie}__sizes"></i>
								</div>
							</div>
						</div>`
        : ''}
			</div>
			<div class="jodit_col-lg-1-4 jodit_col-sm-5-5">
			${o.resize
        ? `<div data-area="resize" class="${jie}__slider ${jie}_active">
							<div class="${jie}__slider-title">
								${gi('resize')}
								${i('Resize')}
							</div>
							<div class="${jie}__slider-content">
								<div class="jodit-form__group">
									<label>
										${i('Width')}
									</label>
									<input type="number" data-ref="widthInput" class="jodit-input"/>
								</div>
								<div class="jodit-form__group">
									<label>
										${i('Height')}
									</label>
									<input type="number" data-ref="heightInput" class="jodit-input"/>
								</div>
								${switcher('Keep Aspect Ratio', 'keepAspectRatioResize')}
							</div>
						</div>`
        : ''}
			${o.crop
        ? `<div data-area="crop" class="${jie}__slider ${act(!o.resize)}'">
							<div class="${jie}__slider-title">
								${gi('crop')}
								${i('Crop')}
							</div>
							<div class="${jie}__slider-content">
								${switcher('Keep Aspect Ratio', 'keepAspectRatioCrop')}
							</div>
						</div>`
        : ''}
			</div>
		</div>
	</form>`);
};


/***/ }),

/***/ 37435:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Ajax: function() { return /* reexport safe */ jodit_core_request__WEBPACK_IMPORTED_MODULE_10__.d; },
/* harmony export */   Alert: function() { return /* reexport safe */ _dialog___WEBPACK_IMPORTED_MODULE_3__.Fc; },
/* harmony export */   Async: function() { return /* reexport safe */ jodit_core_async__WEBPACK_IMPORTED_MODULE_5__.j; },
/* harmony export */   Button: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.$n; },
/* harmony export */   CommitStyle: function() { return /* reexport safe */ jodit_core_selection__WEBPACK_IMPORTED_MODULE_25__.xk; },
/* harmony export */   Component: function() { return /* reexport safe */ jodit_core_component__WEBPACK_IMPORTED_MODULE_0__.uA; },
/* harmony export */   Confirm: function() { return /* reexport safe */ _dialog___WEBPACK_IMPORTED_MODULE_3__.pT; },
/* harmony export */   ContextMenu: function() { return /* reexport safe */ _context_menu_context_menu__WEBPACK_IMPORTED_MODULE_2__.t; },
/* harmony export */   Create: function() { return /* reexport safe */ jodit_core_create__WEBPACK_IMPORTED_MODULE_6__.X; },
/* harmony export */   Dialog: function() { return /* reexport safe */ _dialog___WEBPACK_IMPORTED_MODULE_3__.lG; },
/* harmony export */   Dom: function() { return /* reexport safe */ jodit_core_dom__WEBPACK_IMPORTED_MODULE_7__.J; },
/* harmony export */   EventEmitter: function() { return /* reexport safe */ jodit_core_event_emitter__WEBPACK_IMPORTED_MODULE_8__.bk; },
/* harmony export */   EventHandlersStore: function() { return /* reexport safe */ jodit_core_event_emitter__WEBPACK_IMPORTED_MODULE_8__.d$; },
/* harmony export */   Eventify: function() { return /* reexport safe */ jodit_core_event_emitter__WEBPACK_IMPORTED_MODULE_8__.h5; },
/* harmony export */   FileBrowser: function() { return /* reexport safe */ _file_browser__WEBPACK_IMPORTED_MODULE_4__.V; },
/* harmony export */   Helpers: function() { return /* reexport module object */ jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__; },
/* harmony export */   History: function() { return /* reexport safe */ _history_history__WEBPACK_IMPORTED_MODULE_14__.B; },
/* harmony export */   Icon: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.In; },
/* harmony export */   ImageEditor: function() { return /* reexport safe */ _image_editor_image_editor__WEBPACK_IMPORTED_MODULE_16__.n; },
/* harmony export */   LazyWalker: function() { return /* reexport safe */ jodit_core_dom__WEBPACK_IMPORTED_MODULE_7__.p; },
/* harmony export */   Plugin: function() { return /* reexport safe */ jodit_core_plugin__WEBPACK_IMPORTED_MODULE_9__.k; },
/* harmony export */   PluginSystem: function() { return /* reexport safe */ jodit_core_plugin_plugin_system__WEBPACK_IMPORTED_MODULE_24__.$; },
/* harmony export */   Popup: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.zD; },
/* harmony export */   ProgressBar: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.z2; },
/* harmony export */   Prompt: function() { return /* reexport safe */ _dialog___WEBPACK_IMPORTED_MODULE_3__.XG; },
/* harmony export */   Response: function() { return /* reexport safe */ jodit_core_request__WEBPACK_IMPORTED_MODULE_10__.Y; },
/* harmony export */   STATUSES: function() { return /* reexport safe */ jodit_core_component__WEBPACK_IMPORTED_MODULE_0__.f; },
/* harmony export */   Selection: function() { return /* reexport safe */ jodit_core_selection__WEBPACK_IMPORTED_MODULE_25__.LN; },
/* harmony export */   Snapshot: function() { return /* reexport safe */ _history_snapshot__WEBPACK_IMPORTED_MODULE_15__.F; },
/* harmony export */   StatusBar: function() { return /* reexport safe */ _status_bar_status_bar__WEBPACK_IMPORTED_MODULE_18__.e; },
/* harmony export */   Table: function() { return /* reexport safe */ _table_table__WEBPACK_IMPORTED_MODULE_19__.X; },
/* harmony export */   ToolbarButton: function() { return /* reexport safe */ _toolbar_button__WEBPACK_IMPORTED_MODULE_20__.IB; },
/* harmony export */   ToolbarCollection: function() { return /* reexport safe */ _toolbar_collection_collection__WEBPACK_IMPORTED_MODULE_21__.Q; },
/* harmony export */   ToolbarContent: function() { return /* reexport safe */ _toolbar_button__WEBPACK_IMPORTED_MODULE_20__.P1; },
/* harmony export */   ToolbarEditorCollection: function() { return /* reexport safe */ _toolbar_collection_editor_collection__WEBPACK_IMPORTED_MODULE_22__.b; },
/* harmony export */   ToolbarSelect: function() { return /* reexport safe */ _toolbar_button__WEBPACK_IMPORTED_MODULE_20__.q4; },
/* harmony export */   UIBlock: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.Yh; },
/* harmony export */   UIButton: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.lD; },
/* harmony export */   UIButtonGroup: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.ss; },
/* harmony export */   UIButtonState: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.ue; },
/* harmony export */   UICheckbox: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.cY; },
/* harmony export */   UIElement: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.D$; },
/* harmony export */   UIFileInput: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.nE; },
/* harmony export */   UIForm: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.XV; },
/* harmony export */   UIGroup: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.Ue; },
/* harmony export */   UIInput: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.tS; },
/* harmony export */   UIList: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.z4; },
/* harmony export */   UIMessages: function() { return /* reexport safe */ _messages_messages__WEBPACK_IMPORTED_MODULE_17__.N; },
/* harmony export */   UISelect: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.$6; },
/* harmony export */   UISeparator: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.CP; },
/* harmony export */   UISpacer: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.bk; },
/* harmony export */   UITextArea: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.F0; },
/* harmony export */   UITooltip: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.SB; },
/* harmony export */   Uploader: function() { return /* reexport safe */ _uploader_uploader__WEBPACK_IMPORTED_MODULE_23__.d; },
/* harmony export */   View: function() { return /* reexport safe */ jodit_core_view_view__WEBPACK_IMPORTED_MODULE_12__.S; },
/* harmony export */   ViewComponent: function() { return /* reexport safe */ jodit_core_component__WEBPACK_IMPORTED_MODULE_0__.vG; },
/* harmony export */   ViewWithToolbar: function() { return /* reexport safe */ jodit_core_view_view_with_toolbar__WEBPACK_IMPORTED_MODULE_13__.T; },
/* harmony export */   defaultNameSpace: function() { return /* reexport safe */ jodit_core_event_emitter__WEBPACK_IMPORTED_MODULE_8__.Xr; },
/* harmony export */   observable: function() { return /* reexport safe */ jodit_core_event_emitter__WEBPACK_IMPORTED_MODULE_8__.sH; }
/* harmony export */ });
/* harmony import */ var jodit_core_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(77753);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(65147);
/* harmony import */ var _context_menu_context_menu__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(34248);
/* harmony import */ var _dialog___WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(34256);
/* harmony import */ var _file_browser__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(19627);
/* harmony import */ var jodit_core_async__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(64890);
/* harmony import */ var jodit_core_create__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(40594);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_event_emitter__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(50025);
/* harmony import */ var jodit_core_plugin__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(71005);
/* harmony import */ var jodit_core_request__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(53883);
/* harmony import */ var jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(53048);
/* harmony import */ var jodit_core_view_view__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(77782);
/* harmony import */ var jodit_core_view_view_with_toolbar__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(14961);
/* harmony import */ var _history_history__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(69996);
/* harmony import */ var _history_snapshot__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(58770);
/* harmony import */ var _image_editor_image_editor__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(53804);
/* harmony import */ var _messages_messages__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(91902);
/* harmony import */ var _status_bar_status_bar__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(62870);
/* harmony import */ var _table_table__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(11648);
/* harmony import */ var _toolbar_button__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(5832);
/* harmony import */ var _toolbar_collection_collection__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(97394);
/* harmony import */ var _toolbar_collection_editor_collection__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(90428);
/* harmony import */ var _uploader_uploader__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(26538);
/* harmony import */ var jodit_core_plugin_plugin_system__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(77402);
/* harmony import */ var jodit_core_selection__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(87332);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * [[include:modules/README.md]]
 * @packageDocumentation
 * @module modules
 */






























/***/ }),

/***/ 91479:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   C: function() { return /* binding */ UIMessage; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(24767);
/* harmony import */ var jodit_core_ui__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(53048);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



let UIMessage = class UIMessage extends jodit_core_ui__WEBPACK_IMPORTED_MODULE_0__/* .UIElement */ .D$ {
    className() {
        return 'UIMessage';
    }
    constructor(jodit, options) {
        super(jodit);
        this.setMod('active', true);
        this.setMod('variant', options.variant);
        this.container.textContent = options.text;
    }
};
UIMessage = (0,tslib__WEBPACK_IMPORTED_MODULE_1__/* .__decorate */ .Cg)([
    jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_2__/* .component */ .s
], UIMessage);



/***/ }),

/***/ 91902:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   N: function() { return /* binding */ UIMessages; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(24767);
/* harmony import */ var jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(38322);
/* harmony import */ var jodit_core_ui_group_group__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6455);
/* harmony import */ var jodit_modules_messages_message__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(91479);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */






/**
 * Plugin display pop-up messages in the lower right corner of the editor
 */
let UIMessages = class UIMessages extends jodit_core_ui_group_group__WEBPACK_IMPORTED_MODULE_0__/* .UIGroup */ .U {
    className() {
        return 'UIMessages';
    }
    constructor(jodit, __box, options = {
        defaultTimeout: 3000,
        defaultOffset: 5
    }) {
        super(jodit);
        this.__box = __box;
        this.options = options;
        this.__messages = new Set();
    }
    /**
     * Show popup info message in the lower right corner of the container
     * ```js
     * const jodit = Jodit.make('#editor');
     * jodit.info('Hello world', 3000);
     * ```
     */
    info(text, timeout) {
        this.__message(text, 'info', timeout);
    }
    /**
     * Show popup success message in the lower right corner of the container
     * ```js
     * const jodit = Jodit.make('#editor');
     * jodit.success('Hello world', 3000);
     * ```
     */
    success(text, timeout) {
        this.__message(text, 'success', timeout);
    }
    /**
     * Show popup error message in the lower right corner of the container
     * ```js
     * const jodit = Jodit.make('#editor');
     * jodit.error('Hello world', 3000);
     * ```
     */
    error(text, timeout) {
        this.__message(text, 'error', timeout);
    }
    /**
     * Show popup message in the lower right corner of the container
     * ```js
     * const jodit = Jodit.make('#editor');
     * jodit.message('Hello world', 'info', 3000);
     * ```
     */
    message(text, variant, timeout) {
        this.__message(text, variant, timeout);
    }
    __message(text, variant = 'info', timeout) {
        const key = text + ':' + variant;
        if (this.__messages.has(key)) {
            this.async.updateTimeout(key, timeout || this.options.defaultTimeout);
            return;
        }
        if (!this.__box) {
            throw new Error('Container is not defined: ' + key);
        }
        this.__box.appendChild(this.container);
        const msg = new jodit_modules_messages_message__WEBPACK_IMPORTED_MODULE_1__/* .UIMessage */ .C(this.j, { text, variant });
        this.append(msg);
        this.__calcOffsets();
        this.__messages.add(key);
        const remove = this.__getRemoveCallback(msg, key);
        this.j.e.on(msg.container, 'pointerdown', remove);
        this.async.setTimeout(remove, {
            label: key,
            timeout: timeout || this.options.defaultTimeout
        });
    }
    __getRemoveCallback(msg, key) {
        const remove = (e) => {
            e && e.preventDefault();
            if (msg.isInDestruct) {
                return;
            }
            this.async.clearTimeout(key);
            this.j.e.off(msg.container, 'pointerdown', remove);
            this.__messages.delete(key);
            msg.setMod('active', false);
            this.async.setTimeout(() => {
                this.remove(msg);
                msg.destruct();
                this.__calcOffsets();
            }, 300);
        };
        return remove;
    }
    __calcOffsets() {
        let height = 5;
        this.elements.forEach(elm => {
            (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_2__/* .css */ .A)(elm.container, 'bottom', height + 'px');
            height += elm.container.offsetHeight + this.options.defaultOffset;
        });
    }
};
UIMessages = (0,tslib__WEBPACK_IMPORTED_MODULE_3__/* .__decorate */ .Cg)([
    jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_4__/* .component */ .s
], UIMessages);



/***/ }),

/***/ 62870:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   e: function() { return /* binding */ StatusBar; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(77753);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_traits_elms__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(87906);
/* harmony import */ var jodit_core_traits_mods__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(75758);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */







let StatusBar = class StatusBar extends jodit_core_component__WEBPACK_IMPORTED_MODULE_0__/* .ViewComponent */ .vG {
    className() {
        return 'StatusBar';
    }
    /**
     * Hide statusbar
     */
    hide() {
        this.container.classList.add('jodit_hidden');
    }
    /**
     * Show statusbar
     */
    show() {
        this.container.classList.remove('jodit_hidden');
    }
    /**
     * Status bar is shown
     */
    get isShown() {
        return !this.container.classList.contains('jodit_hidden');
    }
    /**
     * Height of statusbar
     */
    getHeight() {
        var _a, _b;
        return (_b = (_a = this.container) === null || _a === void 0 ? void 0 : _a.offsetHeight) !== null && _b !== void 0 ? _b : 0;
    }
    findEmpty(inTheRight = false) {
        const items = this.getElms(inTheRight ? 'item-right' : 'item');
        for (let i = 0; i < items.length; i += 1) {
            if (!items[i].innerHTML.trim().length) {
                return items[i];
            }
        }
        return;
    }
    /**
     * Add element in statusbar
     */
    append(child, inTheRight = false) {
        var _a;
        const wrapper = this.findEmpty(inTheRight) ||
            this.j.c.div(this.getFullElName('item'));
        if (inTheRight) {
            wrapper.classList.add(this.getFullElName('item-right'));
        }
        wrapper.appendChild(child);
        (_a = this.container) === null || _a === void 0 ? void 0 : _a.appendChild(wrapper);
        if (this.j.o.statusbar) {
            this.show();
        }
        this.j.e.fire('resize');
    }
    constructor(jodit, target) {
        super(jodit);
        this.target = target;
        this.mods = {};
        this.container = jodit.c.div('jodit-status-bar');
        target.appendChild(this.container);
        this.hide();
    }
    destruct() {
        if (this.isInDestruct) {
            return;
        }
        this.setStatus(jodit_core_component__WEBPACK_IMPORTED_MODULE_0__/* .STATUSES */ .f.beforeDestruct);
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.safeRemove(this.container);
        super.destruct();
    }
};
StatusBar = (0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.component,
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.derive)(jodit_core_traits_mods__WEBPACK_IMPORTED_MODULE_5__/* .Mods */ .K, jodit_core_traits_elms__WEBPACK_IMPORTED_MODULE_3__/* .Elms */ .O)
], StatusBar);



/***/ }),

/***/ 11648:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   X: function() { return /* binding */ Table; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(77753);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(65147);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */







const markedValue = new WeakMap();
class Table extends jodit_core_component__WEBPACK_IMPORTED_MODULE_0__/* .ViewComponent */ .vG {
    constructor() {
        super(...arguments);
        this.selected = new Set();
    }
    /** @override */
    className() {
        return 'Table';
    }
    __recalculateStyles() {
        const style = (0,jodit_core_global__WEBPACK_IMPORTED_MODULE_4__/* .getContainer */ .My)(this.j, Table, 'style', true);
        const selectors = [];
        this.selected.forEach(td => {
            const selector = (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.cssPath)(td);
            selector && selectors.push(selector);
        });
        // eslint-disable-next-line no-prototype-builtins
        style.innerHTML = selectors.length
            ? selectors.join(',') +
                `{${this.jodit.options.table.selectionCellStyle}}`
            : '';
    }
    addSelection(td) {
        this.selected.add(td);
        this.__recalculateStyles();
        const table = jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.closest(td, 'table', this.j.editor);
        if (table) {
            const cells = Table.__selectedByTable.get(table) || new Set();
            cells.add(td);
            Table.__selectedByTable.set(table, cells);
        }
    }
    removeSelection(td) {
        this.selected.delete(td);
        this.__recalculateStyles();
        const table = jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.closest(td, 'table', this.j.editor);
        if (table) {
            const cells = Table.__selectedByTable.get(table);
            if (cells) {
                cells.delete(td);
                if (!cells.size) {
                    Table.__selectedByTable.delete(table);
                }
            }
        }
    }
    /**
     * Returns array of selected cells
     */
    getAllSelectedCells() {
        return (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.toArray)(this.selected);
    }
    static __getSelectedCellsByTable(table) {
        const cells = Table.__selectedByTable.get(table);
        return cells ? (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.toArray)(cells) : [];
    }
    /** @override **/
    destruct() {
        this.selected.clear();
        return super.destruct();
    }
    static __getRowsCount(table) {
        return table.rows.length;
    }
    /**
     * Returns rows count in the table
     */
    getRowsCount(table) {
        return Table.__getRowsCount(table);
    }
    static __getColumnsCount(table) {
        const matrix = Table.__formalMatrix(table);
        return matrix.reduce((max_count, cells) => Math.max(max_count, cells.length), 0);
    }
    /**
     * Returns columns count in the table
     */
    getColumnsCount(table) {
        return Table.__getColumnsCount(table);
    }
    static __formalMatrix(table, callback) {
        const matrix = [[]];
        const rows = (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.toArray)(table.rows);
        const setCell = (cell, i) => {
            if (matrix[i] === undefined) {
                matrix[i] = [];
            }
            const colSpan = cell.colSpan, rowSpan = cell.rowSpan;
            let column, row, currentColumn = 0;
            while (matrix[i][currentColumn]) {
                currentColumn += 1;
            }
            for (row = 0; row < rowSpan; row += 1) {
                for (column = 0; column < colSpan; column += 1) {
                    if (matrix[i + row] === undefined) {
                        matrix[i + row] = [];
                    }
                    if (callback &&
                        callback(cell, i + row, currentColumn + column, colSpan, rowSpan) === false) {
                        return false;
                    }
                    matrix[i + row][currentColumn + column] = cell;
                }
            }
        };
        for (let i = 0; i < rows.length; i += 1) {
            const cells = (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.toArray)(rows[i].cells);
            for (let j = 0; j < cells.length; j += 1) {
                if (setCell(cells[j], i) === false) {
                    return matrix;
                }
            }
        }
        return matrix;
    }
    /**
     * Generate formal table martix columns*rows
     * @param table - Working table
     * @param callback - if return false cycle break
     */
    formalMatrix(table, callback) {
        return Table.__formalMatrix(table, callback);
    }
    static __formalCoordinate(table, cell, max = false) {
        let i = 0, j = 0, width = 1, height = 1;
        Table.__formalMatrix(table, (td, ii, jj, colSpan, rowSpan) => {
            if (cell === td) {
                i = ii;
                j = jj;
                width = colSpan || 1;
                height = rowSpan || 1;
                if (max) {
                    j += (colSpan || 1) - 1;
                    i += (rowSpan || 1) - 1;
                }
                return false;
            }
        });
        return [i, j, width, height];
    }
    /**
     * Get cell coordinate in formal table (without colspan and rowspan)
     */
    formalCoordinate(table, cell, max = false) {
        return Table.__formalCoordinate(table, cell, max);
    }
    static __appendRow(table, line, after, create) {
        var _a;
        let row;
        if (!line) {
            const columnsCount = Table.__getColumnsCount(table);
            row = create.element('tr');
            for (let j = 0; j < columnsCount; j += 1) {
                row.appendChild(create.element('td'));
            }
        }
        else {
            row = line.cloneNode(true);
            (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.$$)('td,th', line).forEach(cell => {
                const rowspan = (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.attr)(cell, 'rowspan');
                if (rowspan && parseInt(rowspan, 10) > 1) {
                    const newRowSpan = parseInt(rowspan, 10) - 1;
                    (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.attr)(cell, 'rowspan', newRowSpan > 1 ? newRowSpan : null);
                }
            });
            (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.$$)('td,th', row).forEach(cell => {
                cell.innerHTML = '';
            });
        }
        if (after && line && line.nextSibling) {
            line.parentNode &&
                line.parentNode.insertBefore(row, line.nextSibling);
        }
        else if (!after && line) {
            line.parentNode && line.parentNode.insertBefore(row, line);
        }
        else {
            (((_a = table.getElementsByTagName('tbody')) === null || _a === void 0 ? void 0 : _a[0]) || table).appendChild(row);
        }
    }
    /**
     * Inserts a new line after row what contains the selected cell
     *
     * @param table - Working table
     * @param line - Insert a new line after/before this
     * line contains the selected cell
     * @param after - Insert a new line after line contains the selected cell
     */
    appendRow(table, line, after) {
        return Table.__appendRow(table, line, after, this.j.createInside);
    }
    static __removeRow(table, rowIndex) {
        const box = Table.__formalMatrix(table);
        let dec;
        const row = table.rows[rowIndex];
        box[rowIndex].forEach((cell, j) => {
            dec = false;
            if (rowIndex - 1 >= 0 && box[rowIndex - 1][j] === cell) {
                dec = true;
            }
            else if (box[rowIndex + 1] && box[rowIndex + 1][j] === cell) {
                if (cell.parentNode === row && cell.parentNode.nextSibling) {
                    dec = true;
                    let nextCell = j + 1;
                    while (box[rowIndex + 1][nextCell] === cell) {
                        nextCell += 1;
                    }
                    const nextRow = jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.next(cell.parentNode, elm => jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.isTag(elm, 'tr'), table);
                    if (nextRow) {
                        if (box[rowIndex + 1][nextCell]) {
                            nextRow.insertBefore(cell, box[rowIndex + 1][nextCell]);
                        }
                        else {
                            nextRow.appendChild(cell);
                        }
                    }
                }
            }
            else {
                jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.safeRemove(cell);
            }
            if (dec &&
                (cell.parentNode === row || cell !== box[rowIndex][j - 1])) {
                const rowSpan = cell.rowSpan;
                (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.attr)(cell, 'rowspan', rowSpan - 1 > 1 ? rowSpan - 1 : null);
            }
        });
        jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.safeRemove(row);
    }
    /**
     * Remove row
     */
    removeRow(table, rowIndex) {
        return Table.__removeRow(table, rowIndex);
    }
    static __appendColumn(table, j, after, create) {
        const box = Table.__formalMatrix(table);
        let i;
        if (j === undefined || j < 0) {
            j = Table.__getColumnsCount(table) - 1;
        }
        for (i = 0; i < box.length; i += 1) {
            const cell = create.element('td');
            const td = box[i][j];
            let added = false;
            if (after) {
                if ((box[i] && td && j + 1 >= box[i].length) ||
                    td !== box[i][j + 1]) {
                    if (td.nextSibling) {
                        jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.before(td.nextSibling, cell);
                    }
                    else {
                        td.parentNode && td.parentNode.appendChild(cell);
                    }
                    added = true;
                }
            }
            else {
                if (j - 1 < 0 ||
                    (box[i][j] !== box[i][j - 1] && box[i][j].parentNode)) {
                    jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.before(box[i][j], cell);
                    added = true;
                }
            }
            if (!added) {
                (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.attr)(box[i][j], 'colspan', parseInt((0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.attr)(box[i][j], 'colspan') || '1', 10) + 1);
            }
        }
    }
    /**
     * Insert column before / after all the columns containing the selected cells
     */
    appendColumn(table, j, after) {
        return Table.__appendColumn(table, j, after, this.j.createInside);
    }
    static __removeColumn(table, j) {
        const box = Table.__formalMatrix(table);
        let dec;
        box.forEach((cells, i) => {
            const td = cells[j];
            dec = false;
            if (j - 1 >= 0 && box[i][j - 1] === td) {
                dec = true;
            }
            else if (j + 1 < cells.length && box[i][j + 1] === td) {
                dec = true;
            }
            else {
                jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.safeRemove(td);
            }
            if (dec && (i - 1 < 0 || td !== box[i - 1][j])) {
                const colSpan = td.colSpan;
                (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.attr)(td, 'colspan', colSpan - 1 > 1 ? (colSpan - 1).toString() : null);
            }
        });
    }
    /**
     * Remove column by index
     */
    removeColumn(table, j) {
        return Table.__removeColumn(table, j);
    }
    static __getSelectedBound(table, selectedCells) {
        const bound = [
            [Infinity, Infinity],
            [0, 0]
        ];
        const box = Table.__formalMatrix(table);
        let i, j, k;
        for (i = 0; i < box.length; i += 1) {
            for (j = 0; box[i] && j < box[i].length; j += 1) {
                if (selectedCells.includes(box[i][j])) {
                    bound[0][0] = Math.min(i, bound[0][0]);
                    bound[0][1] = Math.min(j, bound[0][1]);
                    bound[1][0] = Math.max(i, bound[1][0]);
                    bound[1][1] = Math.max(j, bound[1][1]);
                }
            }
        }
        for (i = bound[0][0]; i <= bound[1][0]; i += 1) {
            for (k = 1, j = bound[0][1]; j <= bound[1][1]; j += 1) {
                while (box[i] && box[i][j - k] && box[i][j] === box[i][j - k]) {
                    bound[0][1] = Math.min(j - k, bound[0][1]);
                    bound[1][1] = Math.max(j - k, bound[1][1]);
                    k += 1;
                }
                k = 1;
                while (box[i] && box[i][j + k] && box[i][j] === box[i][j + k]) {
                    bound[0][1] = Math.min(j + k, bound[0][1]);
                    bound[1][1] = Math.max(j + k, bound[1][1]);
                    k += 1;
                }
                k = 1;
                while (box[i - k] && box[i][j] === box[i - k][j]) {
                    bound[0][0] = Math.min(i - k, bound[0][0]);
                    bound[1][0] = Math.max(i - k, bound[1][0]);
                    k += 1;
                }
                k = 1;
                while (box[i + k] && box[i][j] === box[i + k][j]) {
                    bound[0][0] = Math.min(i + k, bound[0][0]);
                    bound[1][0] = Math.max(i + k, bound[1][0]);
                    k += 1;
                }
            }
        }
        return bound;
    }
    /**
     * Define bound for selected cells
     */
    getSelectedBound(table, selectedCells) {
        return Table.__getSelectedBound(table, selectedCells);
    }
    static __normalizeTable(table) {
        const __marked = [], box = Table.__formalMatrix(table);
        Table.__removeExtraColspans(box, __marked);
        Table.__removeExtraRowspans(box, __marked);
        // remove rowspans and colspans equal 1 and empty class
        for (let i = 0; i < box.length; i += 1) {
            for (let j = 0; j < box[i].length; j += 1) {
                if (box[i][j] === undefined) {
                    continue; // broken table
                }
                if (box[i][j].hasAttribute('rowspan') &&
                    box[i][j].rowSpan === 1) {
                    (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.attr)(box[i][j], 'rowspan', null);
                }
                if (box[i][j].hasAttribute('colspan') &&
                    box[i][j].colSpan === 1) {
                    (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.attr)(box[i][j], 'colspan', null);
                }
                if (box[i][j].hasAttribute('class') &&
                    !(0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.attr)(box[i][j], 'class')) {
                    (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.attr)(box[i][j], 'class', null);
                }
            }
        }
        Table.__unmark(__marked);
    }
    static __removeExtraColspans(box, __marked) {
        for (let j = 0; j < box[0].length; j += 1) {
            let min = 1000000;
            let not = false;
            for (let i = 0; i < box.length; i += 1) {
                if (box[i][j] === undefined) {
                    continue; // broken table
                }
                if (box[i][j].colSpan < 2) {
                    not = true;
                    break;
                }
                min = Math.min(min, box[i][j].colSpan);
            }
            if (!not) {
                for (let i = 0; i < box.length; i += 1) {
                    if (box[i][j] === undefined) {
                        continue; // broken table
                    }
                    Table.__mark(box[i][j], 'colspan', box[i][j].colSpan - min + 1, __marked);
                }
            }
        }
    }
    static __removeExtraRowspans(box, marked) {
        let i = 0;
        let j = 0;
        for (i = 0; i < box.length; i += 1) {
            let min = 1000000;
            let not = false;
            for (j = 0; j < box[i].length; j += 1) {
                if (box[i][j] === undefined) {
                    continue; // broken table
                }
                if (box[i][j].rowSpan < 2) {
                    not = true;
                    break;
                }
                min = Math.min(min, box[i][j].rowSpan);
            }
            if (!not) {
                for (j = 0; j < box[i].length; j += 1) {
                    if (box[i][j] === undefined) {
                        continue; // broken table
                    }
                    Table.__mark(box[i][j], 'rowspan', box[i][j].rowSpan - min + 1, marked);
                }
            }
        }
    }
    /**
     * Try recalculate all coluns and rows after change
     */
    normalizeTable(table) {
        return Table.__normalizeTable(table);
    }
    static __mergeSelected(table, jodit) {
        const html = [], bound = Table.__getSelectedBound(table, Table.__getSelectedCellsByTable(table));
        let w = 0, first = null, first_j = 0, td, cols = 0, rows = 0;
        const alreadyMerged = new Set(), __marked = [];
        if (bound && (bound[0][0] - bound[1][0] || bound[0][1] - bound[1][1])) {
            Table.__formalMatrix(table, (cell, i, j, cs, rs) => {
                if (i >= bound[0][0] && i <= bound[1][0]) {
                    if (j >= bound[0][1] && j <= bound[1][1]) {
                        td = cell;
                        if (alreadyMerged.has(td)) {
                            return;
                        }
                        alreadyMerged.add(td);
                        if (i === bound[0][0] && td.style.width) {
                            w += td.offsetWidth;
                        }
                        if ((0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.trim)(cell.innerHTML.replace(/<br(\/)?>/g, '')) !== '') {
                            html.push(cell.innerHTML);
                        }
                        if (cs > 1) {
                            cols += cs - 1;
                        }
                        if (rs > 1) {
                            rows += rs - 1;
                        }
                        if (!first) {
                            first = cell;
                            first_j = j;
                        }
                        else {
                            Table.__mark(td, 'remove', 1, __marked);
                            instance(jodit).removeSelection(td);
                        }
                    }
                }
            });
            cols = bound[1][1] - bound[0][1] + 1;
            rows = bound[1][0] - bound[0][0] + 1;
            if (first) {
                if (cols > 1) {
                    Table.__mark(first, 'colspan', cols, __marked);
                }
                if (rows > 1) {
                    Table.__mark(first, 'rowspan', rows, __marked);
                }
                if (w) {
                    Table.__mark(first, 'width', ((w / table.offsetWidth) * 100).toFixed(jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.ACCURACY) + '%', __marked);
                    if (first_j) {
                        Table.__setColumnWidthByDelta(table, first_j, 0, true, __marked);
                    }
                }
                first.innerHTML = html.join('<br/>');
                instance(jodit).addSelection(first);
                alreadyMerged.delete(first);
                Table.__unmark(__marked);
                Table.__normalizeTable(table);
                (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.toArray)(table.rows).forEach((tr, index) => {
                    if (!tr.cells.length) {
                        jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.safeRemove(tr);
                    }
                });
            }
        }
    }
    /**
     * It combines all of the selected cells into one. The contents of the cells will also be combined
     */
    mergeSelected(table) {
        return Table.__mergeSelected(table, this.j);
    }
    static __splitHorizontal(table, jodit) {
        let coord, td, tr, parent, after;
        const __marked = [];
        Table.__getSelectedCellsByTable(table).forEach((cell) => {
            td = jodit.createInside.element('td');
            td.appendChild(jodit.createInside.element('br'));
            tr = jodit.createInside.element('tr');
            coord = Table.__formalCoordinate(table, cell);
            if (cell.rowSpan < 2) {
                Table.__formalMatrix(table, (tdElm, i, j) => {
                    if (coord[0] === i &&
                        coord[1] !== j &&
                        tdElm !== cell) {
                        Table.__mark(tdElm, 'rowspan', tdElm.rowSpan + 1, __marked);
                    }
                });
                jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.after(jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.closest(cell, 'tr', table), tr);
                tr.appendChild(td);
            }
            else {
                Table.__mark(cell, 'rowspan', cell.rowSpan - 1, __marked);
                Table.__formalMatrix(table, (tdElm, i, j) => {
                    if (i > coord[0] &&
                        i < coord[0] + cell.rowSpan &&
                        coord[1] > j &&
                        tdElm.parentNode
                            .rowIndex === i) {
                        after = tdElm;
                    }
                    if (coord[0] < i && tdElm === cell) {
                        parent = table.rows[i];
                    }
                });
                if (after) {
                    jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.after(after, td);
                }
                else {
                    parent.insertBefore(td, parent.firstChild);
                }
            }
            if (cell.colSpan > 1) {
                Table.__mark(td, 'colspan', cell.colSpan, __marked);
            }
            Table.__unmark(__marked);
            instance(jodit).removeSelection(cell);
        });
        this.__normalizeTable(table);
    }
    /**
     * Divides all selected by `jodit_focused_cell` class table cell in 2 parts vertical. Those division into 2 columns
     */
    splitHorizontal(table) {
        return Table.__splitHorizontal(table, this.j);
    }
    static __splitVertical(table, jodit) {
        let coord, td, percentage;
        const __marked = [];
        Table.__getSelectedCellsByTable(table).forEach(cell => {
            coord = Table.__formalCoordinate(table, cell);
            if (cell.colSpan < 2) {
                Table.__formalMatrix(table, (tdElm, i, j) => {
                    if (coord[1] === j && coord[0] !== i && tdElm !== cell) {
                        Table.__mark(tdElm, 'colspan', tdElm.colSpan + 1, __marked);
                    }
                });
            }
            else {
                Table.__mark(cell, 'colspan', cell.colSpan - 1, __marked);
            }
            td = jodit.createInside.element('td');
            td.appendChild(jodit.createInside.element('br'));
            if (cell.rowSpan > 1) {
                Table.__mark(td, 'rowspan', cell.rowSpan, __marked);
            }
            const oldWidth = cell.offsetWidth; // get old width
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.after(cell, td);
            percentage = oldWidth / table.offsetWidth / 2;
            Table.__mark(cell, 'width', (percentage * 100).toFixed(jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.ACCURACY) + '%', __marked);
            Table.__mark(td, 'width', (percentage * 100).toFixed(jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.ACCURACY) + '%', __marked);
            Table.__unmark(__marked);
            instance(jodit).removeSelection(cell);
        });
        Table.__normalizeTable(table);
    }
    /**
     * It splits all the selected cells into 2 parts horizontally. Those. are added new row
     */
    splitVertical(table) {
        return Table.__splitVertical(table, this.j);
    }
    static __setColumnWidthByDelta(table, column, delta, noUnmark, marked) {
        const box = Table.__formalMatrix(table);
        let clearWidthIndex = 0;
        for (let i = 0; i < box.length; i += 1) {
            const cell = box[i][column];
            if (cell.colSpan > 1 && box.length > 1) {
                continue;
            }
            const w = cell.offsetWidth;
            const percent = ((w + delta) / table.offsetWidth) * 100;
            Table.__mark(cell, 'width', percent.toFixed(jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.ACCURACY) + '%', marked);
            clearWidthIndex = i;
            break;
        }
        for (let i = clearWidthIndex + 1; i < box.length; i += 1) {
            const cell = box[i][column];
            Table.__mark(cell, 'width', null, marked);
        }
        if (!noUnmark) {
            Table.__unmark(marked);
        }
    }
    /**
     * Set column width used delta value
     */
    setColumnWidthByDelta(table, column, delta, noUnmark, marked) {
        return Table.__setColumnWidthByDelta(table, column, delta, noUnmark, marked);
    }
    static __mark(cell, key, value, marked) {
        var _a;
        marked.push(cell);
        const dict = (_a = markedValue.get(cell)) !== null && _a !== void 0 ? _a : {};
        dict[key] = value === undefined ? 1 : value;
        markedValue.set(cell, dict);
    }
    static __unmark(marked) {
        marked.forEach(cell => {
            const dict = markedValue.get(cell);
            if (dict) {
                Object.keys(dict).forEach((key) => {
                    const value = dict[key];
                    switch (key) {
                        case 'remove':
                            jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.safeRemove(cell);
                            break;
                        case 'rowspan':
                            (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.attr)(cell, 'rowspan', (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.isNumber)(value) && value > 1 ? value : null);
                            break;
                        case 'colspan':
                            (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.attr)(cell, 'colspan', (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.isNumber)(value) && value > 1 ? value : null);
                            break;
                        case 'width':
                            if (value == null) {
                                cell.style.removeProperty('width');
                                if (!(0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.attr)(cell, 'style')) {
                                    (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.attr)(cell, 'style', null);
                                }
                            }
                            else {
                                cell.style.width = value.toString();
                            }
                            break;
                    }
                    delete dict[key];
                });
                markedValue.delete(cell);
            }
        });
    }
}
Table.__selectedByTable = new WeakMap();
(0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.debounce)()
], Table.prototype, "__recalculateStyles", null);
const instance = (j) => j.getInstance('Table', j.o);


/***/ }),

/***/ 3258:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   I: function() { return /* binding */ ToolbarButton; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(64567);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(35265);
/* harmony import */ var jodit_core_ui_helpers_get_control_type__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(57023);
/* harmony import */ var jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(931);
/* harmony import */ var jodit_core_ui_popup_popup__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(80071);
/* harmony import */ var jodit_modules_toolbar_collection_collection__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(97394);
/* harmony import */ var jodit_modules_toolbar_factory__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(8809);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */












let ToolbarButton = class ToolbarButton extends jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_4__/* .UIButton */ .lD {
    /** @override */
    className() {
        return 'ToolbarButton';
    }
    /**
     * Get parent toolbar
     */
    get toolbar() {
        return this.closest(jodit_modules_toolbar_collection_collection__WEBPACK_IMPORTED_MODULE_8__/* .ToolbarCollection */ .Q);
    }
    /** @override **/
    update() {
        var _a, _b;
        const { control, state } = this, tc = this.closest(jodit_modules_toolbar_collection_collection__WEBPACK_IMPORTED_MODULE_8__/* .ToolbarCollection */ .Q);
        if (!tc) {
            return;
        }
        const value = (_a = control.value) === null || _a === void 0 ? void 0 : _a.call(control, tc.jodit, this);
        if (value !== undefined) {
            state.value = value;
        }
        state.disabled = this.__calculateDisabledStatus(tc);
        state.activated = this.__calculateActivatedStatus(tc);
        (_b = control.update) === null || _b === void 0 ? void 0 : _b.call(control, tc.jodit, this);
    }
    /**
     * Calculates whether the button is active
     */
    __calculateActivatedStatus(tc) {
        var _a, _b;
        if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isJoditObject)(this.j) && !this.j.editorIsActive) {
            return false;
        }
        if ((_b = (_a = this.control).isActive) === null || _b === void 0 ? void 0 : _b.call(_a, this.j, this)) {
            return true;
        }
        return Boolean(tc && tc.shouldBeActive(this));
    }
    /**
     * Calculates whether an element is blocked for the user
     */
    __calculateDisabledStatus(tc) {
        var _a, _b;
        if (this.j.o.disabled) {
            return true;
        }
        if (this.j.o.readonly &&
            (!this.j.o.activeButtonsInReadOnly ||
                !this.j.o.activeButtonsInReadOnly.includes(this.control.name))) {
            return true;
        }
        if ((_b = (_a = this.control).isDisabled) === null || _b === void 0 ? void 0 : _b.call(_a, this.j, this)) {
            return true;
        }
        return Boolean(tc && tc.shouldBeDisabled(this));
    }
    /** @override */
    onChangeActivated() {
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(this.button, 'aria-pressed', this.state.activated);
        super.onChangeActivated();
    }
    /** @override */
    onChangeText() {
        if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isFunction)(this.control.template)) {
            this.text.innerHTML = this.control.template(this.j, this.control.name, this.j.i18n(this.state.text));
        }
        else {
            super.onChangeText();
        }
        this.setMod('text-icons', Boolean(this.text.innerText.trim().length));
    }
    /** @override */
    onChangeTabIndex() {
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(this.button, 'tabindex', this.state.tabIndex);
    }
    createContainer() {
        const cn = this.componentName;
        const container = this.j.c.span(cn);
        const button = super.createContainer();
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(container, 'role', 'listitem');
        button.classList.remove(cn);
        button.classList.add(cn + '__button');
        Object.defineProperty(button, 'component', {
            value: this
        });
        container.appendChild(button);
        const trigger = this.j.c.fromHTML(`<span role="trigger" class="${cn}__trigger">${jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_6__/* .Icon */ .I.get('chevron')}</span>`);
        // For caching
        button.appendChild(trigger);
        return container;
    }
    /** @override */
    focus() {
        var _a;
        (_a = this.container.querySelector('button')) === null || _a === void 0 ? void 0 : _a.focus();
    }
    onChangeHasTrigger() {
        if (this.state.hasTrigger) {
            this.container.appendChild(this.trigger);
        }
        else {
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.safeRemove(this.trigger);
        }
        this.setMod('with-trigger', this.state.hasTrigger || null);
    }
    /** @override */
    onChangeDisabled() {
        const disabled = this.state.disabled ? 'disabled' : null;
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(this.trigger, 'disabled', disabled);
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(this.button, 'disabled', disabled);
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(this.container, 'disabled', disabled);
    }
    constructor(jodit, control, target = null) {
        super(jodit);
        this.control = control;
        this.target = target;
        this.state = Object.assign(Object.assign({}, (0,jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_4__/* .UIButtonState */ .ue)()), { theme: 'toolbar', currentValue: '', hasTrigger: false });
        this.openedPopup = null;
        const button = this.getElm('button');
        void 0;
        this.button = button;
        Object.defineProperty(button, 'component', {
            value: this,
            configurable: true
        });
        const trigger = this.getElm('trigger');
        void 0;
        this.trigger = trigger;
        trigger.remove();
        // Prevent lost focus
        jodit.e.on([this.button, this.trigger], 'mousedown', (e) => e.preventDefault());
        this.onAction(this.onClick);
        this.hookStatus(jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_0__/* .STATUSES */ .f.ready, () => {
            this.__initFromControl();
            this.update();
        });
        if (control.mods) {
            Object.keys(control.mods).forEach(mod => {
                control.mods && this.setMod(mod, control.mods[mod]);
            });
        }
    }
    /**
     * Init constant data from control
     */
    __initFromControl() {
        var _a;
        const { control: ctr, state } = this;
        this.updateSize();
        state.name = ctr.name;
        const { textIcons } = this.j.o;
        if (textIcons === true ||
            ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isFunction)(textIcons) && textIcons(ctr.name)) ||
            ctr.template) {
            state.icon = (0,jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_4__/* .UIButtonState */ .ue)().icon;
            state.text = ctr.text || ctr.name;
        }
        else {
            if (ctr.iconURL) {
                state.icon.iconURL = ctr.iconURL;
            }
            else {
                const name = ctr.icon || ctr.name;
                state.icon.name =
                    jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_6__/* .Icon */ .I.exists(name) || ((_a = this.j.o.extraIcons) === null || _a === void 0 ? void 0 : _a[name])
                        ? name
                        : '';
            }
            if (!ctr.iconURL && !state.icon.name) {
                state.text = ctr.text || ctr.name;
            }
        }
        if (ctr.tooltip) {
            state.tooltip = this.j.i18n((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isFunction)(ctr.tooltip)
                ? ctr.tooltip(this.j, ctr, this)
                : ctr.tooltip);
        }
        state.hasTrigger = Boolean(ctr.list || (ctr.popup && ctr.exec));
    }
    /**
     * Click on trigger button
     */
    onTriggerClick(e) {
        var _a, _b, _c;
        if (this.openedPopup) {
            this.__closePopup();
            return;
        }
        const { control: ctr } = this;
        e.buffer = {
            actionTrigger: this
        };
        if (ctr.list) {
            return this.__openControlList(ctr);
        }
        if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isFunction)(ctr.popup)) {
            const popup = this.openPopup();
            popup.parentElement = this;
            if (this.j.e.fire((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.camelCase)(`before-${ctr.name}-open-popup`), this.target, ctr, popup) !== false) {
                const target = (_c = (_b = (_a = this.toolbar) === null || _a === void 0 ? void 0 : _a.getTarget(this)) !== null && _b !== void 0 ? _b : this.target) !== null && _c !== void 0 ? _c : null;
                const elm = ctr.popup(this.j, target, this.__closePopup, this);
                if (elm) {
                    popup
                        .setContent((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isString)(elm) ? this.j.c.fromHTML(elm) : elm)
                        .open(() => (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.position)(this.container), false, this.j.o.allowTabNavigation
                        ? this.container
                        : undefined);
                }
            }
            /**
             * Fired after the popup was opened for some control button
             */
            /**
             * Close all opened popups
             */
            this.j.e.fire((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.camelCase)(`after-${ctr.name}-open-popup`), popup.container);
        }
    }
    /**
     * Create an open popup list
     */
    __openControlList(control) {
        var _a;
        const controls = (_a = this.jodit.options.controls) !== null && _a !== void 0 ? _a : {}, getControl = (key) => (0,jodit_core_ui_helpers_get_control_type__WEBPACK_IMPORTED_MODULE_5__/* .findControlType */ .x)(key, controls);
        const list = control.list, menu = this.openPopup(), toolbar = (0,jodit_modules_toolbar_factory__WEBPACK_IMPORTED_MODULE_9__/* .makeCollection */ .$K)(this.j);
        menu.parentElement = this;
        toolbar.parentElement = menu;
        toolbar.mode = 'vertical';
        const isListItem = (key) => (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isPlainObject)(key) && 'title' in key && 'value' in key;
        const getButton = (key, value) => {
            if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isString)(value) && getControl(value)) {
                return Object.assign({ name: value.toString() }, getControl(value));
            }
            if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isString)(key) && getControl(key)) {
                return Object.assign(Object.assign({ name: key.toString() }, getControl(key)), (typeof value === 'object' ? value : {}));
            }
            if (isListItem(key)) {
                value = key.value;
                key = key.title;
            }
            const { childTemplate } = control;
            const childControl = {
                name: key.toString(),
                template: childTemplate &&
                    ((j, k, v) => childTemplate(j, k, v, this)),
                exec: control.childExec
                    ? (view, current, options) => {
                        var _a;
                        return (_a = control.childExec) === null || _a === void 0 ? void 0 : _a.call(control, view, current, Object.assign(Object.assign({}, options), { parentControl: control }));
                    }
                    : control.exec,
                data: control.data,
                command: control.command,
                isActive: control.isChildActive,
                value: control.value,
                isDisabled: control.isChildDisabled,
                mode: control.mode,
                args: [...(control.args ? control.args : []), key, value]
            };
            if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isString)(value)) {
                childControl.text = value;
            }
            return childControl;
        };
        toolbar.build((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isArray)(list)
            ? list.map(getButton)
            : (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.keys)(list, false).map(key => getButton(key, list[key])), this.target);
        menu.setContent(toolbar).open(() => (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.position)(this.container), false, this.j.o.allowTabNavigation ? this.container : undefined);
        this.state.activated = true;
    }
    onOutsideClick(e) {
        if (!this.openedPopup) {
            return;
        }
        if (!e ||
            !jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isNode(e.target) ||
            (!jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isOrContains(this.container, e.target) &&
                !this.openedPopup.isOwnClick(e))) {
            this.__closePopup();
        }
    }
    openPopup() {
        this.__closePopup();
        this.openedPopup = new jodit_core_ui_popup_popup__WEBPACK_IMPORTED_MODULE_7__/* .Popup */ .z(this.j, false);
        this.j.e
            .on(this.ow, 'mousedown touchstart', this.onOutsideClick)
            .on('escape closeAllPopups', this.onOutsideClick);
        return this.openedPopup;
    }
    __closePopup() {
        if (this.openedPopup) {
            this.j.e
                .off(this.ow, 'mousedown touchstart', this.onOutsideClick)
                .off('escape closeAllPopups', this.onOutsideClick);
            this.state.activated = false;
            this.openedPopup.close();
            this.openedPopup.destruct();
            this.openedPopup = null;
        }
    }
    /**
     * Click handler
     */
    onClick(originalEvent) {
        var _a, _b, _c, _d, _e, _f, _g;
        const { control: ctr } = this;
        if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isFunction)(ctr.exec)) {
            const target = (_c = (_b = (_a = this.toolbar) === null || _a === void 0 ? void 0 : _a.getTarget(this)) !== null && _b !== void 0 ? _b : this.target) !== null && _c !== void 0 ? _c : null;
            const result = ctr.exec(this.j, target, {
                control: ctr,
                originalEvent,
                button: this
            });
            // For memorise exec
            if (result !== false && result !== true) {
                (_e = (_d = this.j) === null || _d === void 0 ? void 0 : _d.e) === null || _e === void 0 ? void 0 : _e.fire('synchro');
                if (this.parentElement) {
                    this.parentElement.update();
                }
                /**
                 * Fired after calling `button.exec` function
                 */
                (_g = (_f = this.j) === null || _f === void 0 ? void 0 : _f.e) === null || _g === void 0 ? void 0 : _g.fire('closeAllPopups afterExec');
            }
            if (result !== false) {
                return;
            }
        }
        if (ctr.list) {
            return this.__openControlList(ctr);
        }
        if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isFunction)(ctr.popup)) {
            return this.onTriggerClick(originalEvent);
        }
        if (ctr.command || ctr.name) {
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.call)((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isJoditObject)(this.j)
                ? this.j.execCommand.bind(this.j)
                : this.j.od.execCommand.bind(this.j.od), ctr.command || ctr.name, false, ctr.args && ctr.args[0]);
            this.j.e.fire('closeAllPopups');
        }
    }
    destruct() {
        this.__closePopup();
        return super.destruct();
    }
};
(0,tslib__WEBPACK_IMPORTED_MODULE_10__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.cacheHTML
], ToolbarButton.prototype, "createContainer", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_10__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.watch)('state.hasTrigger', { immediately: false })
], ToolbarButton.prototype, "onChangeHasTrigger", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_10__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.watch)('trigger:click')
], ToolbarButton.prototype, "onTriggerClick", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_10__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], ToolbarButton.prototype, "onOutsideClick", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_10__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], ToolbarButton.prototype, "__closePopup", null);
ToolbarButton = (0,tslib__WEBPACK_IMPORTED_MODULE_10__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.component
], ToolbarButton);



/***/ }),

/***/ 49405:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   P: function() { return /* binding */ ToolbarContent; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(35265);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */






let ToolbarContent = class ToolbarContent extends jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_3__/* .UIButton */ .lD {
    /** @override */
    className() {
        return 'ToolbarContent';
    }
    /** @override */
    update() {
        const content = this.control.getContent(this.j, this);
        if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.isString)(content) || content.parentNode !== this.container) {
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.detach(this.container);
            this.container.appendChild((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.isString)(content) ? this.j.create.fromHTML(content) : content);
        }
        super.update();
    }
    /** @override */
    createContainer() {
        return this.j.c.span(this.componentName);
    }
    constructor(jodit, control, target = null) {
        super(jodit);
        this.control = control;
        this.target = target;
        this.container.classList.add(`${this.componentName}_${this.clearName(control.name)}`);
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.attr)(this.container, 'role', 'content');
    }
};
ToolbarContent = (0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.component
], ToolbarContent);



/***/ }),

/***/ 5832:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   IB: function() { return /* reexport safe */ _button__WEBPACK_IMPORTED_MODULE_0__.I; },
/* harmony export */   P1: function() { return /* reexport safe */ _content__WEBPACK_IMPORTED_MODULE_1__.P; },
/* harmony export */   q4: function() { return /* reexport safe */ _select_select__WEBPACK_IMPORTED_MODULE_2__.q; }
/* harmony export */ });
/* harmony import */ var _button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3258);
/* harmony import */ var _content__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(49405);
/* harmony import */ var _select_select__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(48053);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module modules/toolbar/button
 */





/***/ }),

/***/ 48053:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   q: function() { return /* binding */ ToolbarSelect; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_helpers_checker_is_plain_object__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(25376);
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(98253);
/* harmony import */ var _button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3258);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */






let ToolbarSelect = class ToolbarSelect extends _button__WEBPACK_IMPORTED_MODULE_1__/* .ToolbarButton */ .I {
    className() {
        return 'ToolbarSelect';
    }
    update() {
        var _a, _b, _c;
        super.update();
        this.state.icon.name = '';
        const { list, data } = this.control;
        if (list) {
            let key = this.state.value ||
                (data && (0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_2__/* .isString */ .K)(data.currentValue)
                    ? data.currentValue
                    : undefined);
            if (!key) {
                const keys = Object.keys(list);
                key = keys[0];
            }
            const text = ((0,jodit_core_helpers_checker_is_plain_object__WEBPACK_IMPORTED_MODULE_3__/* .isPlainObject */ .Q)(list) ? list[key.toString()] || key : key).toString();
            this.state.text =
                (_c = (_b = (_a = this.control).textTemplate) === null || _b === void 0 ? void 0 : _b.call(_a, this.jodit, text)) !== null && _c !== void 0 ? _c : text;
        }
    }
};
ToolbarSelect = (0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.component
], ToolbarSelect);



/***/ }),

/***/ 97394:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Q: function() { return /* binding */ ToolbarCollection; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_helpers_utils_error_error__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(76166);
/* harmony import */ var jodit_core_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(53048);
/* harmony import */ var jodit_modules_toolbar_factory__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8809);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */






let ToolbarCollection = class ToolbarCollection extends jodit_core_ui__WEBPACK_IMPORTED_MODULE_2__/* .UIList */ .z4 {
    /** @override */
    className() {
        return 'ToolbarCollection';
    }
    /**
     * First button in a list
     */
    get firstButton() {
        const [button] = this.buttons;
        return button || null;
    }
    makeButton(control, target = null) {
        return (0,jodit_modules_toolbar_factory__WEBPACK_IMPORTED_MODULE_3__/* .makeButton */ .BJ)(this.j, control, target);
    }
    makeSelect(control, target = null) {
        return (0,jodit_modules_toolbar_factory__WEBPACK_IMPORTED_MODULE_3__/* .makeSelect */ .RR)(this.j, control, target);
    }
    /**
     * Button should be active
     */
    shouldBeActive(button) {
        return undefined;
    }
    /**
     * The Button should be disabled
     */
    shouldBeDisabled(button) {
        return undefined;
    }
    /**
     * Returns current target for button
     */
    getTarget(button) {
        return button.target || null;
    }
    __immediateUpdate() {
        if (this.isDestructed || this.j.isLocked) {
            return;
        }
        super.update();
        this.j.e.fire('afterUpdateToolbar', this);
    }
    update() {
        this.__immediateUpdate();
    }
    /**
     * Set direction
     */
    setDirection(direction) {
        this.container.style.direction = direction;
        this.container.setAttribute('dir', direction);
    }
    constructor(jodit) {
        super(jodit);
        this.__listenEvents = 'updatePlugins updateToolbar changeStack mousedown mouseup keydown change afterInit readonly afterResize ' +
            'selectionchange changeSelection focus afterSetMode touchstart focus blur';
        this.__tooltip = new jodit_core_ui__WEBPACK_IMPORTED_MODULE_2__/* .UITooltip */ .SB(this.jodit);
    }
    __initEvents() {
        this.j.e
            .on(this.__listenEvents, this.update)
            .on('afterSetMode focus', this.__immediateUpdate);
    }
    hide() {
        this.container.remove();
    }
    show() {
        this.appendTo(this.j.toolbarContainer);
    }
    showInline(bound) {
        throw (0,jodit_core_helpers_utils_error_error__WEBPACK_IMPORTED_MODULE_1__/* .error */ .z3)('The method is not implemented for this class.');
    }
    /** @override **/
    build(items, target = null) {
        const itemsWithGroupps = this.j.e.fire('beforeToolbarBuild', items);
        if (itemsWithGroupps) {
            items = itemsWithGroupps;
        }
        super.build(items, target);
        return this;
    }
    /** @override **/
    destruct() {
        var _a;
        if (this.isDestructed) {
            return;
        }
        (_a = this.__tooltip) === null || _a === void 0 ? void 0 : _a.destruct();
        this.__tooltip = null;
        this.j.e
            .off(this.__listenEvents, this.update)
            .off('afterSetMode focus', this.__immediateUpdate);
        super.destruct();
    }
};
(0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.autobind
], ToolbarCollection.prototype, "__immediateUpdate", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.debounce)(ctx => ctx.j.defaultTimeout, true)
], ToolbarCollection.prototype, "update", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.hook)('ready')
], ToolbarCollection.prototype, "__initEvents", null);
ToolbarCollection = (0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.component
], ToolbarCollection);



/***/ }),

/***/ 90428:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   b: function() { return /* binding */ ToolbarEditorCollection; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(65147);
/* harmony import */ var _collection__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(97394);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */






let ToolbarEditorCollection = class ToolbarEditorCollection extends _collection__WEBPACK_IMPORTED_MODULE_4__/* .ToolbarCollection */ .Q {
    /** @override */
    className() {
        return 'ToolbarEditorCollection';
    }
    /** @override */
    shouldBeDisabled(button) {
        const disabled = super.shouldBeDisabled(button);
        if (disabled !== undefined) {
            return disabled;
        }
        const mode = button.control.mode === undefined
            ? jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_WYSIWYG
            : button.control.mode;
        return !(mode === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_SPLIT || mode === this.j.getRealMode());
    }
    /** @override */
    shouldBeActive(button) {
        const active = super.shouldBeActive(button);
        if (active !== undefined) {
            return active;
        }
        const element = this.j.selection ? this.j.s.current() : null;
        if (!element) {
            return false;
        }
        let elm;
        if (button.control.tags) {
            const tags = button.control.tags;
            elm = element;
            if (jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.up(elm, (node) => {
                if (node &&
                    tags.indexOf(node.nodeName.toLowerCase()) !== -1) {
                    return true;
                }
            }, this.j.editor)) {
                return true;
            }
        }
        // activate by supposed css
        if (button.control.css) {
            const css = button.control.css;
            elm = element;
            if (jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.up(elm, (node) => {
                if (node && !jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isText(node) && !jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isComment(node)) {
                    return this.checkActiveStatus(css, node);
                }
            }, this.j.editor)) {
                return true;
            }
        }
        return false;
    }
    /** @override */
    getTarget(button) {
        return button.target || this.j.s.current() || null;
    }
    /** @override */
    constructor(jodit) {
        super(jodit);
        this.checkActiveStatus = (cssObject, node) => {
            let matches = 0, total = 0;
            Object.keys(cssObject).forEach((cssProperty) => {
                const cssValue = cssObject[cssProperty];
                if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isFunction)(cssValue)) {
                    if (cssValue(this.j, (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.css)(node, cssProperty).toString())) {
                        matches += 1;
                    }
                }
                else {
                    if (cssValue.indexOf((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.css)(node, cssProperty).toString()) !== -1) {
                        matches += 1;
                    }
                }
                total += 1;
            });
            return total === matches;
        };
        this.prependInvisibleInput(this.container);
    }
    /**
     * Adds an invisible element to the container that can handle the
     * situation when the editor is inside the <label>
     *
     * @see https://github.com/jodit/jodit-react/issues/138
     */
    prependInvisibleInput(container) {
        const input = this.j.create.element('input', {
            tabIndex: -1,
            disabled: true, // Because <label> can trigger click
            style: 'width: 0; height:0; position: absolute; visibility: hidden;'
        });
        jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.appendChildFirst(container, input);
    }
    /**
     * Show the inline toolbar inside WYSIWYG editor.
     * @param bound - you can set the place for displaying the toolbar,
     * or the place will be in the place of the cursor
     */
    showInline(bound) {
        this.jodit.e.fire('showInlineToolbar', bound);
    }
    hide() {
        this.jodit.e.fire('hidePopup');
        super.hide();
        this.jodit.e.fire('toggleToolbar');
    }
    show() {
        super.show();
        this.jodit.e.fire('toggleToolbar');
    }
};
ToolbarEditorCollection = (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.component
], ToolbarEditorCollection);



/***/ }),

/***/ 8809:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   $K: function() { return /* binding */ makeCollection; },
/* harmony export */   BJ: function() { return /* binding */ makeButton; },
/* harmony export */   RR: function() { return /* binding */ makeSelect; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(65147);
/* harmony import */ var _button_button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3258);
/* harmony import */ var _button_content__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(49405);
/* harmony import */ var _button_select_select__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(48053);
/* harmony import */ var _collection_collection__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(97394);
/* harmony import */ var _collection_editor_collection__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(90428);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */






/**
 * Collection factory
 */
function makeCollection(jodit, parentElement) {
    const collection = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.isJoditObject)(jodit)
        ? new _collection_editor_collection__WEBPACK_IMPORTED_MODULE_5__/* .ToolbarEditorCollection */ .b(jodit)
        : new _collection_collection__WEBPACK_IMPORTED_MODULE_4__/* .ToolbarCollection */ .Q(jodit);
    if (jodit.o.textIcons) {
        collection.container.classList.add('jodit_text_icons');
    }
    if (parentElement) {
        collection.parentElement = parentElement;
    }
    if (jodit.o.toolbarButtonSize) {
        collection.buttonSize = jodit.o.toolbarButtonSize;
    }
    return collection;
}
/**
 * Button factory
 */
function makeButton(jodit, control, target = null) {
    if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.isFunction)(control.getContent)) {
        return new _button_content__WEBPACK_IMPORTED_MODULE_2__/* .ToolbarContent */ .P(jodit, control, target);
    }
    const button = new _button_button__WEBPACK_IMPORTED_MODULE_1__/* .ToolbarButton */ .I(jodit, control, target);
    button.state.tabIndex = jodit.o.allowTabNavigation ? 0 : -1;
    return button;
}
function makeSelect(view, control, target = null) {
    return new _button_select_select__WEBPACK_IMPORTED_MODULE_3__/* .ToolbarSelect */ .q(view, control, target);
}


/***/ }),

/***/ 77334:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(37923);
/* harmony import */ var jodit_core_helpers_checker_is_jodit_object__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(83044);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(36115);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



/**
 * Module for processing download documents and images by Drag and Drop
 * Drag and Drop files
 */
jodit_config__WEBPACK_IMPORTED_MODULE_0__/* .Config */ .T.prototype.enableDragAndDropFileToEditor = true;
jodit_config__WEBPACK_IMPORTED_MODULE_0__/* .Config */ .T.prototype.uploader = {
    url: '',
    insertImageAsBase64URI: false,
    imagesExtensions: ['jpg', 'png', 'jpeg', 'gif'],
    headers: null,
    data: null,
    filesVariableName(i) {
        return `files[${i}]`;
    },
    withCredentials: false,
    pathVariableName: 'path',
    format: 'json',
    method: 'POST',
    prepareData(formData) {
        return formData;
    },
    isSuccess(resp) {
        return resp.success;
    },
    getMessage(resp) {
        return resp.data.messages !== undefined && (0,jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_1__/* .isArray */ .c)(resp.data.messages)
            ? resp.data.messages.join(' ')
            : '';
    },
    /**
     * @see [[IUploader.processFileName]]
     */
    processFileName(key, file, name) {
        return [key, file, name];
    },
    process(resp) {
        return resp.data;
    },
    error(e) {
        this.j.message.error(e.message, 4000);
    },
    getDisplayName(baseurl, filename) {
        return baseurl + filename;
    },
    defaultHandlerSuccess(resp) {
        const j = this.j || this;
        if (!(0,jodit_core_helpers_checker_is_jodit_object__WEBPACK_IMPORTED_MODULE_2__/* .isJoditObject */ .y)(j)) {
            return;
        }
        if (resp.files && resp.files.length) {
            resp.files.forEach((filename, index) => {
                const [tagName, attr] = resp.isImages && resp.isImages[index]
                    ? ['img', 'src']
                    : ['a', 'href'];
                const elm = j.createInside.element(tagName);
                elm.setAttribute(attr, resp.baseurl + filename);
                if (tagName === 'a') {
                    elm.textContent = j.o.uploader.getDisplayName.call(this, resp.baseurl, filename);
                }
                if (tagName === 'img') {
                    j.s.insertImage(elm, null, j.o.imageDefaultWidth);
                }
                else {
                    j.s.insertNode(elm);
                }
            });
        }
    },
    defaultHandlerError(e) {
        this.j.message.error(e.message);
    },
    contentType(requestData) {
        return this.ow.FormData !== undefined &&
            typeof requestData !== 'string'
            ? false
            : 'application/x-www-form-urlencoded; charset=UTF-8';
    }
};


/***/ }),

/***/ 89929:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   $: function() { return /* binding */ buildData; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(65147);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

function buildData(uploader, data) {
    if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.isFunction)(uploader.o.buildData)) {
        return uploader.o.buildData.call(uploader, data);
    }
    const FD = uploader.ow.FormData;
    if (FD !== undefined) {
        if (data instanceof FD) {
            return data;
        }
        if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.isString)(data)) {
            return data;
        }
        const newData = new FD();
        const dict = data;
        Object.keys(dict).forEach(key => {
            newData.append(key, dict[key]);
        });
        return newData;
    }
    return data;
}


/***/ }),

/***/ 51923:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   z: function() { return /* binding */ dataURItoBlob; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module modules/uploader
 */
/**
 * Convert dataURI to Blob
 */
function dataURItoBlob(dataURI) {
    // convert base64 to raw binary data held in a string
    // doesn't handle URLEncoded DataURIs - see SO answer #6850276 for code that does this
    const byteString = atob(dataURI.split(',')[1]), 
    // separate out the mime component
    mimeString = dataURI.split(',')[0].split(':')[1].split(';')[0], 
    // write the bytes of the string to an ArrayBuffer
    ab = new ArrayBuffer(byteString.length), ia = new Uint8Array(ab);
    for (let i = 0; i < byteString.length; i += 1) {
        ia[i] = byteString.charCodeAt(i);
    }
    return new Blob([ia], { type: mimeString });
}


/***/ }),

/***/ 74340:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   $j: function() { return /* reexport safe */ _send__WEBPACK_IMPORTED_MODULE_2__.$; },
/* harmony export */   Pb: function() { return /* binding */ hasItems; },
/* harmony export */   YQ: function() { return /* binding */ hasFiles; },
/* harmony export */   _9: function() { return /* reexport safe */ _send_files__WEBPACK_IMPORTED_MODULE_3__._; },
/* harmony export */   dT: function() { return /* reexport safe */ _process_old_browser_drag__WEBPACK_IMPORTED_MODULE_1__.d; },
/* harmony export */   tN: function() { return /* reexport safe */ _send__WEBPACK_IMPORTED_MODULE_2__.t; }
/* harmony export */ });
/* harmony import */ var _build_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(89929);
/* harmony import */ var _process_old_browser_drag__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(84759);
/* harmony import */ var _send__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(27912);
/* harmony import */ var _send_files__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(74714);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */





function hasFiles(data) {
    return Boolean(data && data.files && data.files.length > 0);
}
function hasItems(data) {
    return Boolean(data && data.items && data.items.length > 0);
}


/***/ }),

/***/ 84759:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   d: function() { return /* binding */ processOldBrowserDrag; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(65147);
/* harmony import */ var _data_uri_to_blob__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(51923);
/* harmony import */ var _send_files__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(74714);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */






function processOldBrowserDrag(self, cData, handlerSuccess, handlerError, onFinally) {
    if (cData && (!cData.types.length || cData.types[0] !== jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.TEXT_PLAIN)) {
        const div = self.j.c.div('', {
            tabindex: -1,
            style: 'left: -9999px; top: 0; width: 0; height: 100%;line-height: 140%; ' +
                'overflow: hidden; position: fixed; z-index: 2147483647; word-break: break-all;',
            contenteditable: true
        });
        (0,jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .getContainer */ .My)(self.j, self.constructor).appendChild(div);
        const selection = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isJoditObject)(self.j) ? self.j.s.save() : null, restore = () => selection && (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isJoditObject)(self.j) && self.j.s.restore();
        div.focus();
        self.j.async.setTimeout(() => {
            const child = div.firstChild;
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.safeRemove(div);
            if (child && child.hasAttribute('src')) {
                const src = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(child, 'src') || '';
                restore();
                (0,_send_files__WEBPACK_IMPORTED_MODULE_4__/* .sendFiles */ ._)(self, [(0,_data_uri_to_blob__WEBPACK_IMPORTED_MODULE_5__/* .dataURItoBlob */ .z)(src)], handlerSuccess, handlerError).finally(onFinally);
            }
        }, self.j.defaultTimeout);
    }
}


/***/ }),

/***/ 74714:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   _: function() { return /* binding */ sendFiles; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(65147);
/* harmony import */ var jodit_modules_uploader_helpers_send__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(27912);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


/**
 * Send files to server
 */
function sendFiles(uploader, files, handlerSuccess, handlerError, process) {
    if (!files) {
        return Promise.reject((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.error)('Need files'));
    }
    const { o } = uploader;
    let fileList = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.toArray)(files);
    if (!fileList.length) {
        return Promise.reject((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.error)('Need files'));
    }
    const promises = [];
    if (o.insertImageAsBase64URI) {
        readImagesWithReader(fileList, o.imagesExtensions, promises, uploader, handlerSuccess, o.defaultHandlerSuccess);
    }
    fileList = fileList.filter(a => a);
    if (fileList.length) {
        const form = new FormData();
        form.append(o.pathVariableName, uploader.path);
        form.append('source', uploader.source);
        let file;
        for (let i = 0; i < fileList.length; i += 1) {
            file = fileList[i];
            if (file) {
                const hasRealExtension = /\.\w+$/.test(file.name);
                const mime = file.type.match(/\/([a-z0-9]+)/i);
                const extension = mime && mime[1] ? mime[1].toLowerCase() : '';
                let newName = fileList[i].name ||
                    Math.random().toString().replace('.', '');
                if (!hasRealExtension && extension) {
                    let extForReg = extension;
                    if (['jpeg', 'jpg'].includes(extForReg)) {
                        extForReg = 'jpeg|jpg';
                    }
                    const reEnd = new RegExp('.(' + extForReg + ')$', 'i');
                    if (!reEnd.test(newName)) {
                        newName += '.' + extension;
                    }
                }
                const [key, iFile, name] = o.processFileName.call(uploader, o.filesVariableName(i), fileList[i], newName);
                form.append(key, iFile, name);
            }
        }
        if (process) {
            process(form);
        }
        if (o.data && (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.isPlainObject)(o.data)) {
            Object.keys(o.data).forEach((key) => {
                form.append(key, o.data[key]);
            });
        }
        o.prepareData.call(uploader, form);
        promises.push((0,jodit_modules_uploader_helpers_send__WEBPACK_IMPORTED_MODULE_1__/* .send */ .t)(uploader, form)
            .then(resp => {
            if (o.isSuccess.call(uploader, resp)) {
                const handler = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.isFunction)(handlerSuccess)
                    ? handlerSuccess
                    : o.defaultHandlerSuccess;
                handler.call(uploader, o.process.call(uploader, resp));
                return resp;
            }
            const handler = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.isFunction)(handlerError)
                ? handlerError
                : o.defaultHandlerError;
            handler.call(uploader, (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.error)(o.getMessage.call(uploader, resp)));
            return resp;
        })
            .then(() => {
            uploader.j.events && uploader.j.e.fire('filesWereUploaded');
        }));
    }
    return Promise.all(promises);
}
function readImagesWithReader(fileList, imagesExtensions, promises, uploader, handlerSuccess, defaultHandlerSuccess) {
    let file, i;
    for (i = 0; i < fileList.length; i += 1) {
        file = fileList[i];
        if (file && file.type) {
            const mime = file.type.match(/\/([a-z0-9]+)/i);
            const extension = mime[1] ? mime[1].toLowerCase() : '';
            if (!imagesExtensions.includes(extension)) {
                continue;
            }
            const reader = new FileReader();
            promises.push(uploader.j.async.promise((resolve, reject) => {
                reader.onerror = reject;
                reader.onloadend = () => {
                    const resp = {
                        baseurl: '',
                        files: [reader.result],
                        isImages: [true]
                    };
                    const handler = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.isFunction)(handlerSuccess)
                        ? handlerSuccess
                        : defaultHandlerSuccess;
                    handler.call(uploader, resp);
                    resolve(resp);
                };
                reader.readAsDataURL(file);
            }));
            fileList[i] = null;
        }
    }
}


/***/ }),

/***/ 27912:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   $: function() { return /* binding */ ajaxInstances; },
/* harmony export */   t: function() { return /* binding */ send; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_request__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(53883);
/* harmony import */ var jodit_modules_uploader_helpers_build_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(89929);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



const ajaxInstances = new WeakMap();
function send(uploader, data) {
    const requestData = (0,jodit_modules_uploader_helpers_build_data__WEBPACK_IMPORTED_MODULE_2__/* .buildData */ .$)(uploader, data);
    const sendData = (request) => {
        const ajax = new jodit_core_request__WEBPACK_IMPORTED_MODULE_1__/* .Ajax */ .d({
            xhr: () => {
                const xhr = new XMLHttpRequest();
                if (uploader.j.ow.FormData !== undefined &&
                    xhr.upload) {
                    uploader.j.progressbar.show().progress(10);
                    xhr.upload.addEventListener('progress', evt => {
                        if (evt.lengthComputable) {
                            let percentComplete = evt.loaded / evt.total;
                            percentComplete *= 100;
                            uploader.j.progressbar
                                .show()
                                .progress(percentComplete);
                            if (percentComplete >= 100) {
                                uploader.j.progressbar.hide();
                            }
                        }
                    }, false);
                }
                else {
                    uploader.j.progressbar.hide();
                }
                return xhr;
            },
            method: uploader.o.method || 'POST',
            data: request,
            url: (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.isFunction)(uploader.o.url)
                ? uploader.o.url(request)
                : uploader.o.url,
            headers: uploader.o.headers,
            queryBuild: uploader.o.queryBuild,
            contentType: uploader.o.contentType.call(uploader, request),
            withCredentials: uploader.o.withCredentials || false
        });
        let instances = ajaxInstances.get(uploader);
        if (!instances) {
            instances = new Set();
            ajaxInstances.set(uploader, instances);
        }
        instances.add(ajax);
        uploader.j.e.one('beforeDestruct', ajax.destruct);
        return ajax
            .send()
            .then(resp => resp.json())
            .catch(error => {
            return {
                success: false,
                data: {
                    messages: [error]
                }
            };
        })
            .finally(() => {
            ajax.destruct();
            instances === null || instances === void 0 ? void 0 : instances.delete(ajax);
        });
    };
    if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.isPromise)(requestData)) {
        return requestData.then(sendData).catch(error => {
            uploader.o.error.call(uploader, error);
        });
    }
    return sendData(requestData);
}


/***/ }),

/***/ 26538:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   d: function() { return /* binding */ Uploader; }
/* harmony export */ });
/* harmony import */ var jodit_core_component___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(77753);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(65147);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(36115);
/* harmony import */ var jodit_modules_uploader_helpers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(74340);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(77334);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */







class Uploader extends jodit_core_component___WEBPACK_IMPORTED_MODULE_0__/* .ViewComponent */ .vG {
    get j() {
        return this.jodit;
    }
    /** @override */
    className() {
        return 'Uploader';
    }
    get o() {
        return this.options;
    }
    /**
     * It sets the path for uploading files
     */
    setPath(path) {
        this.path = path;
        return this;
    }
    /**
     * It sets the source for connector
     */
    setSource(source) {
        this.source = source;
        return this;
    }
    /**
     * Set the handlers Drag and Drop to `$form`
     *
     * @param form - Form or any Node on which you can drag and drop the file. In addition will be processed
     * <code>&lt;input type="file" &gt;</code>
     * @param handlerSuccess - The function be called when a successful uploading files
     * to the server
     * @param handlerError - The function that will be called during a failed download files a server
     * @example
     * ```javascript
     * var $form = jQuery('<form><input type="text" typpe="file"></form>');
     * jQuery('body').append($form);
     * Jodit.editors.someidfoeditor.uploader.bind($form[0], function (files) {
     *     var i;
     *     for (i = 0; i < data.files.length; i += 1) {
     *         parent.s.insertImage(data.files[i])
     *     }
     * });
     * ```
     */
    bind(form, handlerSuccess, handlerError) {
        const onFinally = () => {
            form.classList.remove('jodit_drag_hover');
        };
        const self = this, onPaste = (e) => {
            let i, file, extension;
            const cData = e.clipboardData;
            const processData = (formdata) => {
                if (file) {
                    formdata.append('extension', extension);
                    formdata.append('mimetype', file.type);
                }
            };
            // send data on server
            if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.IS_IE && (0,jodit_modules_uploader_helpers__WEBPACK_IMPORTED_MODULE_4__/* .hasFiles */ .YQ)(cData)) {
                (0,jodit_modules_uploader_helpers__WEBPACK_IMPORTED_MODULE_4__/* .sendFiles */ ._9)(self, cData.files, handlerSuccess, handlerError).finally(onFinally);
                return false;
            }
            if (jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.IS_IE && !jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.IS_ES_NEXT) {
                return (0,jodit_modules_uploader_helpers__WEBPACK_IMPORTED_MODULE_4__/* .processOldBrowserDrag */ .dT)(self, cData, handlerSuccess, handlerError, onFinally);
            }
            if ((0,jodit_modules_uploader_helpers__WEBPACK_IMPORTED_MODULE_4__/* .hasItems */ .Pb)(cData)) {
                const { items } = cData;
                for (i = 0; i < items.length; i += 1) {
                    if (items[i].kind === 'file' &&
                        items[i].type === 'image/png') {
                        file = items[i].getAsFile();
                        if (file) {
                            const mime = file.type.match(/\/([a-z0-9]+)/i);
                            extension = mime[1]
                                ? mime[1].toLowerCase()
                                : '';
                            (0,jodit_modules_uploader_helpers__WEBPACK_IMPORTED_MODULE_4__/* .sendFiles */ ._9)(self, [file], handlerSuccess, handlerError, processData).finally(onFinally);
                        }
                        e.preventDefault();
                        break;
                    }
                }
            }
        };
        if (self.j && self.j.editor !== form) {
            self.j.e.on(form, 'paste', onPaste);
        }
        else {
            self.j.e.on('beforePaste', onPaste);
        }
        this.attachEvents(form, handlerSuccess, handlerError, onFinally);
    }
    attachEvents(form, handlerSuccess, handlerError, onFinally) {
        const self = this;
        self.j.e
            .on(form, 'dragend dragover dragenter dragleave drop', (e) => {
            e.preventDefault();
        })
            .on(form, 'dragover', (event) => {
            if ((0,jodit_modules_uploader_helpers__WEBPACK_IMPORTED_MODULE_4__/* .hasFiles */ .YQ)(event.dataTransfer) ||
                (0,jodit_modules_uploader_helpers__WEBPACK_IMPORTED_MODULE_4__/* .hasItems */ .Pb)(event.dataTransfer)) {
                form.classList.add('jodit_drag_hover');
                event.preventDefault();
            }
        })
            .on(form, 'dragend dragleave', (event) => {
            form.classList.remove('jodit_drag_hover');
            if ((0,jodit_modules_uploader_helpers__WEBPACK_IMPORTED_MODULE_4__/* .hasFiles */ .YQ)(event.dataTransfer)) {
                event.preventDefault();
            }
        })
            .on(form, 'drop', (event) => {
            form.classList.remove('jodit_drag_hover');
            if ((0,jodit_modules_uploader_helpers__WEBPACK_IMPORTED_MODULE_4__/* .hasFiles */ .YQ)(event.dataTransfer)) {
                event.preventDefault();
                event.stopImmediatePropagation();
                (0,jodit_modules_uploader_helpers__WEBPACK_IMPORTED_MODULE_4__/* .sendFiles */ ._9)(self, event.dataTransfer.files, handlerSuccess, handlerError).finally(onFinally);
            }
        });
        const inputFile = form.querySelector('input[type=file]');
        if (inputFile) {
            self.j.e.on(inputFile, 'change', () => {
                (0,jodit_modules_uploader_helpers__WEBPACK_IMPORTED_MODULE_4__/* .sendFiles */ ._9)(self, inputFile.files, handlerSuccess, handlerError)
                    .then(() => {
                    inputFile.value = '';
                    if (!/safari/i.test(navigator.userAgent)) {
                        inputFile.type = '';
                        inputFile.type = 'file';
                    }
                })
                    .finally(onFinally);
            });
        }
    }
    /**
     * Upload images to a server by its URL, making it through the connector server.
     */
    uploadRemoteImage(url, handlerSuccess, handlerError) {
        const uploader = this, { o } = uploader;
        const handlerE = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.isFunction)(handlerError)
            ? handlerError
            : o.defaultHandlerError;
        (0,jodit_modules_uploader_helpers__WEBPACK_IMPORTED_MODULE_4__/* .send */ .tN)(uploader, {
            action: 'fileUploadRemote',
            url
        })
            .then(resp => {
            if (o.isSuccess.call(uploader, resp)) {
                const handler = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.isFunction)(handlerSuccess)
                    ? handlerSuccess
                    : o.defaultHandlerSuccess;
                handler.call(uploader, o.process.call(uploader, resp));
                return;
            }
            handlerE.call(uploader, (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.error)(o.getMessage.call(uploader, resp)));
        })
            .catch(e => handlerE.call(uploader, e));
    }
    constructor(editor, options) {
        super(editor);
        this.path = '';
        this.source = 'default';
        this.options = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.ConfigProto)(options || {}, (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.ConfigProto)(jodit_config__WEBPACK_IMPORTED_MODULE_3__/* .Config */ .T.defaultOptions.uploader, (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.isJoditObject)(editor) ? editor.o.uploader : {}));
    }
    destruct() {
        this.setStatus(jodit_core_component___WEBPACK_IMPORTED_MODULE_0__/* .STATUSES */ .f.beforeDestruct);
        const instances = jodit_modules_uploader_helpers__WEBPACK_IMPORTED_MODULE_4__/* .ajaxInstances */ .$j.get(this);
        if (instances) {
            instances.forEach(ajax => {
                try {
                    ajax.destruct();
                }
                catch (_a) { }
            });
            instances.clear();
        }
        super.destruct();
    }
}


/***/ }),

/***/ 19633:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   K: function() { return /* binding */ ColorPickerWidget; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(53048);
/* harmony import */ var _palette_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(54522);
/* harmony import */ var _palette_svg__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_palette_svg__WEBPACK_IMPORTED_MODULE_3__);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */





jodit_core_ui__WEBPACK_IMPORTED_MODULE_2__/* .Icon */ .In.set('palette', (_palette_svg__WEBPACK_IMPORTED_MODULE_3___default()));
/**
 * Build color picker
 *
 * @param callback - Callback 'function (color) \{\}'
 * @param coldColor - Color value ex. #fff or rgb(123, 123, 123) or rgba(123, 123, 123, 1)
 * @example
 * ```javascript
 * const tabs = TabsWidget(editor, {
 *    'Text': ColorPickerWidget(editor, function (color) {
 *         box.style.color = color;
 *     }, box.style.color),
 *     'Background': ColorPickerWidget(editor, function (color) {
 *         box.style.backgroundColor = color;
 *     }, box.style.backgroundColor),
 * });
 * ```
 */
const ColorPickerWidget = (editor, callback, coldColor) => {
    const cn = 'jodit-color-picker', valueHex = (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.normalizeColor)(coldColor), form = editor.c.div(cn), iconPalette = editor.o.textIcons
        ? `<span>${editor.i18n('palette')}</span>`
        : jodit_core_ui__WEBPACK_IMPORTED_MODULE_2__/* .Icon */ .In.get('palette'), eachColor = (colors) => {
        const stack = [];
        if ((0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.isPlainObject)(colors)) {
            Object.keys(colors).forEach(key => {
                stack.push(`<div class="${cn}__group ${cn}__group-${key}">`);
                stack.push(eachColor(colors[key]));
                stack.push('</div>');
            });
        }
        else if ((0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.isArray)(colors)) {
            colors.forEach(color => {
                stack.push(`<span class='${cn}__color-item ${valueHex === color
                    ? cn + '__color-item_active_true'
                    : ''}' title="${color}" style="background-color:${color}" data-color="${color}"></span>`);
            });
        }
        return stack.join('');
    };
    form.appendChild(editor.c.fromHTML(`<div class="${cn}__groups">${eachColor(editor.o.colors)}</div>`));
    form.appendChild(editor.c.fromHTML(`<div data-ref="extra" class="${cn}__extra"></div>`));
    const { extra } = (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.refs)(form);
    if (editor.o.showBrowserColorPicker && (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.hasBrowserColorPicker)()) {
        extra.appendChild(editor.c.fromHTML(`<div class="${cn}__native">${iconPalette}<input type="color" value="#ffffff"/></div>`));
        editor.e.on(form, 'change', (e) => {
            e.stopPropagation();
            const target = e.target;
            if (!target || !target.tagName || !jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(target, 'input')) {
                return;
            }
            const color = target.value || '';
            if ((0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.isFunction)(callback)) {
                callback(color);
            }
            e.preventDefault();
        });
    }
    editor.e.on(form, 'mousedown touchend', (e) => {
        e.stopPropagation();
        e.preventDefault();
        let target = e.target;
        if ((!target ||
            !target.tagName ||
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(target, 'svg') ||
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(target, 'path')) &&
            target.parentNode) {
            target = jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.closest(target.parentNode, 'span', editor.editor);
        }
        if (!jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(target, 'span') ||
            !target.classList.contains(cn + '__color-item')) {
            return;
        }
        const color = (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.attr)(target, '-color') || '';
        if (callback && (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.isFunction)(callback)) {
            callback(color);
        }
    });
    editor.e.fire('afterGenerateColorPicker', form, extra, callback, valueHex);
    return form;
};


/***/ }),

/***/ 10067:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   k: function() { return /* binding */ FileSelectorWidget; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(53048);
/* harmony import */ var jodit_modules_widget_tabs_tabs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(4909);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */




/**
 * Generate 3 tabs
 * upload - Use Drag and Drop
 * url - By specifying the image url
 * filebrowser - After opening the file browser. In the absence of one of the parameters will be less tabs
 *
 * @param callbacks - Object with keys `url`, `upload` and `filebrowser`, values which are callback
 * functions with different parameters
 */
const FileSelectorWidget = (editor, callbacks, elm, close, isImage = true) => {
    let currentImage;
    const tabs = [];
    if (callbacks.upload &&
        editor.o.uploader &&
        (editor.o.uploader.url || editor.o.uploader.insertImageAsBase64URI)) {
        const dragBox = editor.c.fromHTML('<div class="jodit-drag-and-drop__file-box">' +
            `<strong>${editor.i18n(isImage ? 'Drop image' : 'Drop file')}</strong>` +
            `<span><br>${editor.i18n('or click')}</span>` +
            `<input type="file" accept="${isImage ? 'image/*' : '*'}" tabindex="-1" dir="auto" multiple=""/>` +
            '</div>');
        editor.uploader.bind(dragBox, resp => {
            const handler = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.isFunction)(callbacks.upload)
                ? callbacks.upload
                : editor.o.uploader.defaultHandlerSuccess;
            if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.isFunction)(handler)) {
                handler.call(editor, resp);
            }
            editor.e.fire('closeAllPopups');
        }, error => {
            editor.message.error(error.message);
            editor.e.fire('closeAllPopups');
        });
        tabs.push({
            icon: 'upload',
            name: 'Upload',
            content: dragBox
        });
    }
    if (callbacks.filebrowser) {
        if (editor.o.filebrowser.ajax.url || editor.o.filebrowser.items.url) {
            tabs.push({
                icon: 'folder',
                name: 'Browse',
                content: () => {
                    close && close();
                    if (callbacks.filebrowser) {
                        editor.filebrowser.open(callbacks.filebrowser, isImage);
                    }
                }
            });
        }
    }
    if (callbacks.url) {
        const button = new jodit_core_ui__WEBPACK_IMPORTED_MODULE_2__/* .UIButton */ .lD(editor, {
            type: 'submit',
            variant: 'primary',
            text: 'Insert'
        }), form = new jodit_core_ui__WEBPACK_IMPORTED_MODULE_2__/* .UIForm */ .XV(editor, [
            new jodit_core_ui__WEBPACK_IMPORTED_MODULE_2__/* .UIInput */ .tS(editor, {
                required: true,
                label: 'URL',
                name: 'url',
                type: 'text',
                placeholder: 'https://'
            }),
            new jodit_core_ui__WEBPACK_IMPORTED_MODULE_2__/* .UIInput */ .tS(editor, {
                name: 'text',
                label: 'Alternative text'
            }),
            new jodit_core_ui__WEBPACK_IMPORTED_MODULE_2__/* .UIBlock */ .Yh(editor, [button])
        ]);
        currentImage = null;
        if (elm &&
            !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isText(elm) &&
            !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isComment(elm) &&
            (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(elm, 'img') || (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.$$)('img', elm).length)) {
            currentImage = elm.tagName === 'IMG' ? elm : (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.$$)('img', elm)[0];
            val(form.container, 'input[name=url]', (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.attr)(currentImage, 'src'));
            val(form.container, 'input[name=text]', (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.attr)(currentImage, 'alt'));
            button.state.text = 'Update';
        }
        if (elm && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(elm, 'a')) {
            val(form.container, 'input[name=url]', (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.attr)(elm, 'href'));
            val(form.container, 'input[name=text]', (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.attr)(elm, 'title'));
            button.state.text = 'Update';
        }
        form.onSubmit(data => {
            if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.isFunction)(callbacks.url)) {
                callbacks.url.call(editor, data.url, data.text);
            }
        });
        tabs.push({
            icon: 'link',
            name: 'URL',
            content: form.container
        });
    }
    return (0,jodit_modules_widget_tabs_tabs__WEBPACK_IMPORTED_MODULE_3__/* .TabsWidget */ .Z)(editor, tabs);
};
function val(elm, selector, value) {
    const child = elm.querySelector(selector);
    if (!child) {
        return '';
    }
    if (value) {
        child.value = value;
    }
    return child.value;
}


/***/ }),

/***/ 16116:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Kn: function() { return /* reexport safe */ _color_picker_color_picker__WEBPACK_IMPORTED_MODULE_0__.K; },
/* harmony export */   Zg: function() { return /* reexport safe */ _tabs_tabs__WEBPACK_IMPORTED_MODULE_2__.Z; },
/* harmony export */   kG: function() { return /* reexport safe */ _file_selector_file_selector__WEBPACK_IMPORTED_MODULE_1__.k; }
/* harmony export */ });
/* harmony import */ var _color_picker_color_picker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(19633);
/* harmony import */ var _file_selector_file_selector__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(10067);
/* harmony import */ var _tabs_tabs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4909);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * [[include:modules/widget/README.md]]
 * @packageDocumentation
 * @module modules/widget
 */





/***/ }),

/***/ 4909:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: function() { return /* binding */ TabsWidget; }
/* harmony export */ });
/* harmony import */ var jodit_core_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(77753);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(69052);
/* harmony import */ var jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(26150);
/* harmony import */ var jodit_core_ui__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(53048);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */






/**
 * Build tabs system
 *
 * @param tabs - PlainObject where 'key' will be tab's Title and `value` is tab's content
 * @param state - You can use for this param any HTML element for remembering active tab
 *
 * @example
 * ```javascript
 * const editor = Jodit.make('#editor');
 * const tabs = Jodit.modules.TabsWidget(editor, [
 *  { name: 'Images', content: '<div>Images</div>' },
 *  {
 *    name: 'Title 2',
 *    content: editor.c.fromHTML('<div>Some content</div>')
 *  },
 *  {
 *    name: 'Color Picker',
 *    content: ColorPickerWidget(
 *      editor,
 *      function (color) {
 *        box.style.color = color;
 *      },
 *      box.style.color
 *    )
 *  }
 * ]);
 * ```
 */
const TabsWidget = (jodit, tabs, state) => {
    const box = jodit.c.div('jodit-tabs');
    const tabBox = jodit.c.div('jodit-tabs__wrapper');
    const buttons = jodit.c.div('jodit-tabs__buttons');
    (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_2__/* .attr */ .C)(buttons, {
        role: 'tablist',
        'aria-orientation': 'horizontal'
    });
    const nameToTab = {};
    const buttonList = [];
    let firstTab = '';
    box.appendChild(buttons);
    box.appendChild(tabBox);
    const setActive = (tab) => {
        if (!nameToTab[tab]) {
            return;
        }
        buttonList.forEach(b => {
            b.state.activated = false;
        });
        Object.values(nameToTab).forEach(({ tab }) => tab.classList.remove('jodit-tab_active'));
        nameToTab[tab].button.state.activated = true;
        nameToTab[tab].tab.classList.add('jodit-tab_active');
    };
    tabs.forEach(({ icon, name, content }) => {
        const tab = jodit.c.div('jodit-tab');
        (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_2__/* .attr */ .C)(tab, {
            role: 'tabpanel'
        });
        const button = (0,jodit_core_ui__WEBPACK_IMPORTED_MODULE_3__/* .Button */ .$n)(jodit, icon || name, name);
        button.state.role = 'tab';
        // Stop lose the focus
        jodit.e.on(button.container, 'pointerdown', (e) => e.preventDefault());
        if (!firstTab) {
            firstTab = name;
        }
        buttons.appendChild(button.container);
        buttonList.push(button);
        button.container.classList.add('jodit-tabs__button', 'jodit-tabs__button_columns_' + tabs.length);
        if (!(0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_4__/* .isFunction */ .T)(content)) {
            tab.appendChild(jodit_core_component__WEBPACK_IMPORTED_MODULE_0__/* .Component */ .uA.isInstanceOf(content, jodit_core_ui__WEBPACK_IMPORTED_MODULE_3__/* .UIElement */ .D$)
                ? content.container
                : content);
        }
        else {
            tab.appendChild(jodit.c.div('jodit-tab_empty'));
        }
        tabBox.appendChild(tab);
        button.onAction(() => {
            setActive(name);
            if ((0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_4__/* .isFunction */ .T)(content) && !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isElement(content)) {
                content.call(jodit);
            }
            if (state) {
                state.activeTab = name;
            }
            return false;
        });
        nameToTab[name] = {
            button,
            tab
        };
    });
    Object.values(nameToTab).forEach(({ button }) => {
        button.container.style.width = (100 / tabs.length).toFixed(10) + '%';
    });
    const tab = !state || !state.activeTab || !nameToTab[state.activeTab]
        ? firstTab
        : state.activeTab;
    setActive(tab);
    if (state) {
        let activeTab = state.activeTab;
        Object.defineProperty(state, 'activeTab', {
            configurable: true,
            enumerable: false,
            get() {
                return activeTab;
            },
            set(value) {
                activeTab = value;
                setActive(value);
            }
        });
    }
    return box;
};


/***/ }),

/***/ 55989:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export addNewLine */
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(65147);
/* harmony import */ var jodit_modules__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(37435);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(84018);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */







const ns = 'addnewline';
/**
 * Create helper for adding new paragraph(Jodit.defaultOptions.enter tag) before iframe, table or image
 */
class addNewLine extends jodit_modules__WEBPACK_IMPORTED_MODULE_3__.Plugin {
    constructor() {
        super(...arguments);
        this.__line = this.j.c.fromHTML(`<div role="button" tabindex="-1" title="${this.j.i18n('Break')}" class="jodit-add-new-line"><span>${jodit_modules__WEBPACK_IMPORTED_MODULE_3__.Icon.get('enter')}</span></div>`);
        this.__isMatchedTag = (node) => Boolean(node &&
            this.j.o.addNewLineTagsTriggers.includes(node.nodeName.toLowerCase()));
        this.__isBeforeContent = false;
        this.__lineInFocus = false;
        this.__isShown = false;
        this.__hideForce = () => {
            if (!this.__isShown) {
                return;
            }
            this.__isShown = false;
            this.j.async.clearTimeout(this.__timeout);
            this.__lineInFocus = false;
            jodit_modules__WEBPACK_IMPORTED_MODULE_3__.Dom.safeRemove(this.__line);
            this.__line.style.setProperty('--jd-anl-handle-offset', '0');
        };
        this.__canGetFocus = (elm) => {
            return (elm != null &&
                jodit_modules__WEBPACK_IMPORTED_MODULE_3__.Dom.isBlock(elm) &&
                !/^(img|table|iframe|hr)$/i.test(elm.nodeName));
        };
        this.__onClickLine = (e) => {
            const editor = this.j;
            const p = editor.createInside.element(editor.o.enter);
            if (this.__isBeforeContent &&
                this.__current &&
                this.__current.parentNode) {
                if (this.__current === editor.editor) {
                    jodit_modules__WEBPACK_IMPORTED_MODULE_3__.Dom.prepend(editor.editor, p);
                }
                else {
                    this.__current.parentNode.insertBefore(p, this.__current);
                }
            }
            else {
                editor.editor.appendChild(p);
            }
            editor.s.setCursorIn(p);
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.scrollIntoViewIfNeeded)(p, editor.editor, editor.ed);
            editor.synchronizeValues();
            this.__hideForce();
            e.preventDefault();
        };
    }
    __show() {
        if (this.j.o.readonly || this.j.isLocked) {
            return;
        }
        this.j.async.clearTimeout(this.__timeout);
        if (this.__isShown) {
            return;
        }
        this.__isShown = true;
        this.j.container.appendChild(this.__line);
        this.__line.style.width = this.j.container.clientWidth + 'px';
    }
    onLock(isLocked) {
        if (isLocked && this.__isShown) {
            this.__hideForce();
        }
    }
    __hide() {
        if (!this.__isShown || this.__lineInFocus) {
            return;
        }
        this.__timeout = this.j.async.setTimeout(this.__hideForce, {
            timeout: 500,
            label: 'add-new-line-hide'
        });
    }
    afterInit(editor) {
        if (!editor.o.addNewLine) {
            return;
        }
        editor.e
            .on(this.__line, 'mousemove', (e) => {
            e.stopPropagation();
        })
            .on(this.__line, 'mousedown touchstart', this.__onClickLine)
            .on('change', this.__hideForce)
            .on(this.__line, 'mouseenter', () => {
            this.j.async.clearTimeout(this.__timeout);
            this.__lineInFocus = true;
        })
            .on(this.__line, 'mouseleave', () => {
            this.__lineInFocus = false;
        })
            .on('changePlace', this.__addEventListeners.bind(this));
        this.__addEventListeners();
    }
    __addEventListeners() {
        const editor = this.j;
        editor.e
            .off(editor.editor, '.' + ns)
            .off(editor.container, '.' + ns)
            .on([editor.ow, editor.ew, editor.editor], 'scroll' + '.' + ns, this.__hideForce)
            .on(editor.editor, 'click' + '.' + ns, this.__hide)
            .on(editor.container, 'mouseleave' + '.' + ns, this.__hide)
            .on(editor.editor, 'mousemove' + '.' + ns, this.__onMouseMove);
    }
    onDblClickEditor(e) {
        const editor = this.j;
        if (!editor.o.readonly &&
            editor.o.addNewLineOnDBLClick &&
            e.target === editor.editor &&
            editor.s.isCollapsed()) {
            const editorBound = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.offset)(editor.editor, editor, editor.ed);
            const top = e.pageY - editor.ew.scrollX;
            const p = editor.createInside.element(editor.o.enter);
            if (Math.abs(top - editorBound.top) <
                Math.abs(top - (editorBound.height + editorBound.top)) &&
                editor.editor.firstChild) {
                editor.editor.insertBefore(p, editor.editor.firstChild);
            }
            else {
                editor.editor.appendChild(p);
            }
            editor.s.setCursorIn(p);
            editor.synchronizeValues();
            this.__hideForce();
            e.preventDefault();
        }
    }
    __onMouseMove(e) {
        const editor = this.j;
        let currentElement = editor.ed.elementFromPoint(e.clientX, e.clientY);
        if (!jodit_modules__WEBPACK_IMPORTED_MODULE_3__.Dom.isHTMLElement(currentElement) ||
            !jodit_modules__WEBPACK_IMPORTED_MODULE_3__.Dom.isOrContains(editor.editor, currentElement)) {
            return;
        }
        if (editor.editor !== currentElement &&
            !this.__isMatchedTag(currentElement)) {
            currentElement = jodit_modules__WEBPACK_IMPORTED_MODULE_3__.Dom.closest(currentElement, this.__isMatchedTag, editor.editor);
        }
        if (!currentElement) {
            this.__hide();
            return;
        }
        if (this.__isMatchedTag(currentElement)) {
            const parentBox = jodit_modules__WEBPACK_IMPORTED_MODULE_3__.Dom.up(currentElement, jodit_modules__WEBPACK_IMPORTED_MODULE_3__.Dom.isBlock, editor.editor);
            if (parentBox && parentBox !== editor.editor) {
                currentElement = parentBox;
            }
        }
        const pos = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.position)(currentElement, this.j);
        let top = false;
        let { clientY, clientX } = e;
        if (this.j.iframe) {
            const { top, left } = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.position)(this.j.iframe, this.j, true);
            clientY += top;
            clientX += left;
        }
        const delta = this.j.o.addNewLineDeltaShow;
        if (Math.abs(clientY - pos.top) <= delta) {
            top = pos.top;
            this.__isBeforeContent = true;
        }
        else if (Math.abs(clientY - (pos.top + pos.height)) <= delta) {
            top = pos.top + pos.height;
            this.__isBeforeContent = false;
        }
        const isEditor = editor.editor === currentElement;
        if (top !== false &&
            ((isEditor && !this.__isBeforeContent) ||
                (!isEditor &&
                    !(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.call)(this.__isBeforeContent ? jodit_modules__WEBPACK_IMPORTED_MODULE_3__.Dom.prev : jodit_modules__WEBPACK_IMPORTED_MODULE_3__.Dom.next, currentElement, this.__canGetFocus, editor.editor)))) {
            this.__line.style.top = top + 'px';
            this.__current = currentElement;
            this.__show();
            this.__line.style.setProperty('--jd-anl-handle-offset', clientX - pos.left - 10 + 'px');
        }
        else {
            this.__current = false;
            this.__hide();
        }
    }
    /** @override */
    beforeDestruct() {
        this.j.async.clearTimeout(this.__timeout);
        this.j.e.off(this.__line).off('changePlace', this.__addEventListeners);
        jodit_modules__WEBPACK_IMPORTED_MODULE_3__.Dom.safeRemove(this.__line);
        this.j.e
            .off([this.j.ow, this.j.ew, this.j.editor], '.' + ns)
            .off(this.j.container, '.' + ns);
    }
}
(0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)(':lock')
], addNewLine.prototype, "onLock", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.autobind
], addNewLine.prototype, "__hide", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)(':dblclick')
], addNewLine.prototype, "onDblClickEditor", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.throttle)(ctx => ctx.defaultTimeout)
], addNewLine.prototype, "__onMouseMove", null);
jodit_core_global__WEBPACK_IMPORTED_MODULE_1__/* .pluginSystem */ .fg.add('addNewLine', addNewLine);


/***/ }),

/***/ 84018:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(931);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(36115);
/* harmony import */ var _enter_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(86634);
/* harmony import */ var _enter_svg__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_enter_svg__WEBPACK_IMPORTED_MODULE_2__);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



jodit_config__WEBPACK_IMPORTED_MODULE_1__/* .Config */ .T.prototype.addNewLine = true;
jodit_config__WEBPACK_IMPORTED_MODULE_1__/* .Config */ .T.prototype.addNewLineOnDBLClick = true;
jodit_config__WEBPACK_IMPORTED_MODULE_1__/* .Config */ .T.prototype.addNewLineTagsTriggers = [
    'table',
    'iframe',
    'img',
    'hr',
    'pre',
    'jodit'
];
jodit_config__WEBPACK_IMPORTED_MODULE_1__/* .Config */ .T.prototype.addNewLineDeltaShow = 20;
jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_0__/* .Icon */ .I.set('enter', (_enter_svg__WEBPACK_IMPORTED_MODULE_2___default()));


/***/ }),

/***/ 13917:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export backspace */
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(69052);
/* harmony import */ var jodit_core_plugin__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(71005);
/* harmony import */ var jodit_core_selection_helpers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(46602);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(81982);
/* harmony import */ var _cases_check_not_collapsed__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(90084);
/* harmony import */ var _cases__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(89832);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */









class backspace extends jodit_core_plugin__WEBPACK_IMPORTED_MODULE_3__/* .Plugin */ .k {
    afterInit(jodit) {
        jodit
            .registerCommand('deleteButton', {
            exec: () => this.onDelete(false),
            hotkeys: jodit.o.delete.hotkeys.delete
        }, {
            stopPropagation: false
        })
            .registerCommand('backspaceButton', {
            exec: () => this.onDelete(true),
            hotkeys: jodit.o.delete.hotkeys.backspace
        }, {
            stopPropagation: false
        })
            .registerCommand('deleteWordButton', {
            exec: () => this.onDelete(false, 'word'),
            hotkeys: jodit.o.delete.hotkeys.deleteWord
        })
            .registerCommand('backspaceWordButton', {
            exec: () => this.onDelete(true, 'word'),
            hotkeys: jodit.o.delete.hotkeys.backspaceWord
        })
            .registerCommand('deleteSentenceButton', {
            exec: () => this.onDelete(false, 'sentence'),
            hotkeys: jodit.o.delete.hotkeys.deleteSentence
        })
            .registerCommand('backspaceSentenceButton', {
            exec: () => this.onDelete(true, 'sentence'),
            hotkeys: jodit.o.delete.hotkeys.backspaceSentence
        });
    }
    beforeDestruct(jodit) {
        jodit.e.off('afterCommand.delete');
    }
    /**
     * Listener BackSpace or Delete button
     */
    onDelete(backspace, mode = 'char') {
        const jodit = this.j;
        const sel = jodit.selection;
        if (!sel.isFocused()) {
            sel.focus();
        }
        if ((0,_cases_check_not_collapsed__WEBPACK_IMPORTED_MODULE_7__/* .checkNotCollapsed */ .L)(jodit)) {
            return false;
        }
        const range = sel.range;
        const fakeNode = jodit.createInside.text(jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INVISIBLE_SPACE);
        try {
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.safeInsertNode(range, fakeNode);
            if (!jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isOrContains(jodit.editor, fakeNode)) {
                return;
            }
            if (jodit.e.fire('backSpaceBeforeCases', backspace, fakeNode)) {
                return false;
            }
            (0,jodit_core_selection_helpers__WEBPACK_IMPORTED_MODULE_4__/* .moveNodeInsideStart */ .W8)(jodit, fakeNode, backspace);
            if (_cases__WEBPACK_IMPORTED_MODULE_6__/* .cases */ .C.some((func) => {
                if ((0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_8__/* .isFunction */ .T)(func) &&
                    func(jodit, fakeNode, backspace, mode)) {
                    if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD) {
                        console.info('Remove case:', func.name);
                    }
                    return true;
                }
            })) {
                return false;
            }
        }
        catch (e) {
            if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD) {
                console.error(e);
            }
            throw e;
        }
        finally {
            jodit.e.fire('backSpaceAfterDelete', backspace, fakeNode);
            this.saf