/* ----- decode/653xint16, derived from supercop/crypto_decode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *decode_653xint16_checksums[] = {
  "17a6405c12d612963247bbf6aa8ed3cfe97cb9d2c4cbc5fed58415acee973cc8",
  "95a98a488011bfe4be2945e897c1e74d3ab4caae7a3985c5a91df7a40fa12bb0",
} ;

static void (*crypto_decode)(void *,const unsigned char *);
#define crypto_decode_STRBYTES ntruprime_decode_653xint16_STRBYTES
#define crypto_decode_ITEMS ntruprime_decode_653xint16_ITEMS
#define crypto_decode_ITEMBYTES ntruprime_decode_653xint16_ITEMBYTES

static void *storage_decode_653xint16_x;
static unsigned char *test_decode_653xint16_x;
static void *storage_decode_653xint16_s;
static unsigned char *test_decode_653xint16_s;
static void *storage_decode_653xint16_x2;
static unsigned char *test_decode_653xint16_x2;
static void *storage_decode_653xint16_s2;
static unsigned char *test_decode_653xint16_s2;

#define precomputed_decode_653xint16_NUM 4

static const uint16_t precomputed_decode_653xint16_x[precomputed_decode_653xint16_NUM][crypto_decode_ITEMS] = {
  {59256,39130,17441,36682,25750,1596,8031,53815,37381,12187,30533,20236,8387,35602,42654,38410,18517,16585,61038,55465,47000,43146,6295,12938,35023,43913,56971,33616,37863,50562,63361,33816,44228,58815,54470,32186,2461,1868,17287,47307,45530,37362,15996,34403,7576,22834,54487,11749,40045,28674,17168,16999,17989,21214,25309,12521,34576,28675,52596,34754,5383,24280,27450,19770,64514,6208,11169,33131,64288,4698,25463,54991,15145,60005,41119,33287,58764,5627,33179,47695,20153,25105,53169,7403,18822,11927,4078,49943,50360,38913,10940,43863,63832,13716,19821,16899,31249,29802,56457,12820,28501,36274,12632,43112,28721,17831,6643,50871,1614,56673,28206,53753,44763,36449,52277,57139,56768,26060,59787,11880,47602,46927,37823,34747,18715,5729,23281,24269,3640,32866,25163,60513,41861,24526,63148,11982,5441,14958,16707,3017,53598,17936,56909,58587,2707,5253,35787,13077,53462,2441,3636,14047,497,16037,55811,51248,50596,33475,59421,58137,55926,51923,14966,39240,24177,7924,32448,10178,13393,39045,40455,20075,59481,19761,20191,17220,50079,15499,34179,58419,57147,24686,26043,42030,2577,399,6547,3858,24266,6118,19295,54076,43033,20793,27743,36621,28155,5584,61197,24051,51917,7164,1931,33951,25842,60584,30374,49848,33635,19870,34365,39357,20190,9774,48750,48622,32219,7203,44241,52661,26443,11534,24096,55404,46859,63299,52108,24631,9221,62494,46135,7859,60911,46793,5494,38067,30799,49510,30941,26180,48298,23241,6107,9107,29746,61634,58249,11548,40733,47753,50152,24177,2666,4198,19106,44811,43018,21172,60859,5039,49495,25146,35389,55785,6831,61896,31652,1250,53934,2812,48336,62038,56526,50360,14846,56382,50082,18707,41045,3829,39268,58096,11720,44092,37151,3745,14995,62749,49593,17952,1573,54657,55681,16575,29404,3937,30172,665,36046,44330,18250,38705,8930,51544,13657,29706,13813,27323,38750,30940,4797,57913,33297,49344,57649,4297,34042,29285,40011,26468,29567,28667,37560,29161,33791,43088,21665,40254,36744,46002,16065,45931,46766,42016,37847,4000,18237,62026,37221,17943,55542,12578,51126,41589,756,37488,5429,50597,55898,6428,63924,51,36535,22754,13794,16201,27535,12433,3818,23715,43734,23539,38302,39548,38431,16268,45418,10969,40679,34148,21254,34160,55283,34915,3269,62782,18922,9731,19676,10969,13097,45135,20326,63381,40447,22643,13472,36785,34163,960,64438,36794,3126,45817,46115,9005,49568,59584,22920,34826,9776,47155,62675,48974,45511,52777,38499,51485,13231,22842,62031,14726,49288,29332,35399,58266,16361,41596,14323,26084,9976,49425,65004,4959,2113,28960,3498,51821,35020,28303,51475,7356,60485,5724,22648,36195,52215,23749,10610,48664,21525,12022,29805,7281,8827,45985,49192,37451,59487,10357,21900,12056,63075,11153,28311,49626,35175,9090,63665,11227,60690,6489,52162,12805,29396,38619,55619,65388,41896,7847,38878,33412,57125,36180,13689,26686,29957,52600,62000,60269,18513,29241,20087,64133,23836,43472,47994,23086,2479,53211,4012,55499,7336,637,28379,20439,63545,36224,8197,27790,29552,45593,21307,12523,43641,42532,63589,19598,64642,41063,39751,34676,30211,60037,64869,45380,39426,25497,25885,33319,50150,15953,62938,4773,62311,52174,43029,13976,21136,33124,54769,19079,61014,39177,5439,4228,34605,32905,15215,45252,28204,13103,44003,39147,28057,20420,64662,17994,4188,63829,29797,23714,28587,25043,1981,139,29645,14390,41680,41173,59201,36361,26559,43797,43861,56232,33008,55729,34300,49153,15344,17541,20905,37048,35905,50880,15829,39045,26845,46716,40156,2184,21560,13028,6724,64458,29477,23186,63366,16468,11825,1938,46087,36929,27518,15713,52470,37896,10092,60833,4061,46098,47077,37212,54166,32543,40667,51484,23250,10013,41614,62615,14563,60195,54841,63861,41050,53349,6036,47815,39819,40616,57694,16066,14871,36872,36125,64788,19151,23595,54831,23131,50216,62395,12877,33324,2497,10774,5957,27661,64300,25746,36426,36703,17927,60949,31532,41216,21484,31658,24505,53448,19929},
  {13706,16393,55350,51153,22918,49466,59823,36112,39403,57721,9993,50643,25366,5071,12294,10348,41516,25911,32087,43106,8393,35644,54393,28634,19504,24040,5034,19124,7809,22619,55859,10428,36,4912,61225,15339,21180,54083,30374,3267,54137,31373,46793,64408,57787,47695,25725,50671,44479,25438,57707,59956,51341,10542,33328,17046,12662,58836,19584,25286,23162,27311,41494,53420,59242,53923,16030,22170,37363,16347,9233,3750,3228,2465,59058,28442,28756,28709,40976,30362,14120,19450,57629,22904,38166,50104,49,10086,52487,23154,24170,3430,47214,46238,37675,5616,35952,27002,16567,7490,19563,44743,10942,32882,63601,50513,17551,61171,6326,1553,58154,44644,64133,64335,15759,10170,21704,43024,32616,28985,57088,25646,9258,59732,7482,60805,63465,53348,10085,3381,50800,30856,40703,2335,17964,6819,40115,13997,18735,14451,22454,61848,11451,23914,54706,377,44589,59252,37863,20766,36730,50980,57874,55518,39693,2059,23509,56882,36581,912,21542,45935,55169,43007,60098,39508,29161,46798,56924,25807,29261,40189,64197,29784,9168,63815,13174,42415,33043,51194,30334,32184,14194,31750,20347,42443,29228,45295,41207,6046,23791,33328,15944,16459,34141,49964,17777,41332,42189,25453,41721,20155,5165,13186,57112,9566,63275,64668,52311,20143,60769,58355,6170,18874,64951,48072,55234,16695,41488,61459,41889,13217,38879,63620,38676,52662,14406,31964,53586,42365,9384,23851,61820,33958,54700,23688,15925,56275,46793,14071,46052,16281,22199,64214,7200,26026,52314,46357,43077,15949,20628,62813,64583,21939,32932,26283,53889,30169,57924,49038,18137,37230,473,60067,30200,30376,55731,10153,40179,60368,56306,44203,9955,35255,65504,22445,55728,31003,31124,53220,54974,23577,42609,38872,14627,14380,62004,61877,9540,52414,50517,26334,47416,16156,17980,28100,29524,37165,14,15479,5534,33898,28437,51478,43286,51685,53773,1386,5910,29129,5312,20954,47443,43909,58554,50425,6328,28875,16197,5042,6853,41669,61534,52866,55052,23923,48373,18456,16238,9318,35500,49580,27918,8153,44610,9383,42168,7264,56796,5887,45211,62086,53606,14053,31296,9,48729,15001,34921,57395,43381,34924,51563,26994,42614,60404,38165,7588,20678,3356,46474,58903,21645,58844,10656,64849,65528,47081,43330,10975,30333,50882,24738,40014,22543,2242,31375,12912,53531,53724,11790,19830,54401,27670,25993,61792,32618,17337,3122,24847,24381,31576,6557,33110,57540,37077,43976,42453,25009,363,7541,40470,33206,31603,11145,20870,47775,52854,8035,41340,18645,35862,54610,5280,42083,64654,46091,3479,56457,23951,37616,823,34967,59000,61957,19106,43459,2315,24468,19604,7683,9991,43438,60465,1110,11840,9317,46285,7996,47055,63241,26595,12056,2615,39318,18222,65188,59313,13174,62889,39026,31711,62898,24056,63592,18679,34286,27215,21454,44182,61467,33005,4368,47538,21333,65490,19046,51404,33127,19397,60822,49481,41974,15905,63806,41840,12057,19606,64190,18227,26711,58479,6107,17073,11886,52269,35672,51119,25751,19261,13000,61698,62385,1199,37866,541,21632,40616,4847,18604,11058,36710,4121,56031,50448,41578,15005,12525,64766,6808,4449,21646,57907,11076,49328,1186,27313,52767,27325,4804,55431,39210,63520,63896,6103,59141,16184,53258,43228,24039,34274,38585,27201,56011,61553,48716,679,15879,32169,63593,20014,50405,2012,61389,18850,5640,38184,3722,12930,26135,49213,57071,50892,28336,7533,11143,4472,63279,24245,42786,59630,20038,51500,18010,8386,47704,35460,34323,28796,8651,16770,5562,31549,13348,53308,1673,10572,35816,30559,26873,48380,63877,63725,52863,45243,18439,35259,29084,53559,28315,44938,17034,19918,34224,31924,15723,39636,24285,62563,26091,30194,16753,37764,51827,53086,13021,3731,42788,40764,31842,44692,34101,5477,38107,24261,59540,53268,64674,21143,51934,33407,20995,20339,59754,5265,31717,21045,64469,5650,41724,7038,40046,53423,7804,3093,61561,61482,25634,7162,22481,53326,50140,41162,61088,39880,11834,39301,39065,46877,24610,30819,59139,7627},
  {14073,4277,12076,64503,49087,36876,64498,30798,63330,19910,579,37049,64934,11967,19088,45896,39819,26243,37283,3214,11940,12842,15206,50951,48242,36635,12674,28072,36662,17445,20969,22067,4530,22746,54682,24494,33141,184,49065,39760,23936,36422,20670,61291,42819,34510,53156,8133,23283,26802,61166,39293,37940,13806,57004,26243,45870,7566,57070,7856,52787,38679,63199,28132,36882,62156,38303,28606,39682,15316,27918,63133,29339,19885,53399,14303,46932,22961,13583,27572,36367,41025,30438,878,1071,10536,10693,25835,45401,7077,34667,61106,27364,3897,29303,13044,32346,41369,40501,3330,57712,58061,12888,17989,58957,61588,30541,61626,2581,14768,26207,56580,54319,15246,21540,53547,34699,20426,44211,59684,53509,62192,4993,57746,879,50197,43447,22800,47867,10138,56235,48454,10114,45265,599,59247,616,987,23471,46575,45932,53825,25218,9857,40437,22458,43287,57135,60572,6329,59431,54876,62158,51049,59502,59155,31624,27693,18102,30119,64095,58166,17358,46693,36008,29285,30181,38880,34264,27214,47941,14178,19446,12599,55774,18361,13720,2772,10875,10545,20077,10596,30176,39348,7787,59375,42075,1841,51227,33306,3861,12463,38127,4671,6552,58394,24234,17368,237,35277,38085,14586,51970,18605,28327,55032,53984,15569,20644,51817,50934,19914,51801,10745,62175,9799,51724,10821,28281,11794,47329,41173,45859,39768,7315,33886,7410,54305,1497,45244,50698,27224,7070,28737,385,2000,21536,48066,7900,23087,2855,27981,46888,56130,44541,9745,44310,57759,29183,51855,43881,49595,33009,6231,2053,40616,30511,65116,30385,3380,26145,161,38098,26672,7759,21354,62697,33895,13227,53301,52153,50244,29721,62224,22647,64779,18170,49122,60167,29899,38123,46560,37229,1259,4666,19047,15715,58283,48805,26070,19995,54006,30642,37083,1234,47576,54837,30108,12143,32127,17861,42912,13904,9827,59629,41425,57329,5876,9013,53826,3736,34460,60690,8723,2489,16489,8028,44446,49114,64671,27417,6650,52340,40785,55286,10195,22978,925,31144,16453,34434,30368,54463,21671,59649,46898,17378,9582,64932,57864,57198,53820,16421,44349,47337,21875,25436,4867,6511,55829,26110,36948,16426,6076,35830,51673,62099,12119,23693,7347,34884,6366,35351,46262,58351,29523,17585,39969,34609,12883,35096,53072,61094,32548,39356,7614,2930,54024,20917,32416,43242,53172,60718,3785,9594,55591,19496,63307,45592,58493,57888,58168,19516,48642,51925,44134,32800,39163,52987,13613,21098,2748,59623,39976,23466,60043,11019,58772,7509,20815,40133,6356,63462,64880,12116,18768,21866,18829,13724,54113,44892,23396,13706,60413,31076,46619,41743,62854,38640,1840,24975,51416,19814,61247,26514,18327,2696,29327,40909,3606,36221,2498,53680,41984,28687,15038,42564,29762,33928,8472,20379,9073,20845,1859,63232,7953,10677,56678,40465,27299,45382,11748,756,57583,63422,21049,45347,35805,40249,39159,54280,33898,54915,45030,50526,36884,60701,20234,12769,59282,65044,2774,29726,28461,40809,16340,49093,46226,43459,63513,27573,2143,46361,7445,1940,5932,65462,42323,47940,23091,40863,14597,14384,48795,1139,36430,40833,65076,36279,42469,40554,51651,13619,12165,19515,50493,15346,16115,40865,33987,64171,29020,24977,36435,55193,10631,42902,60518,6955,55832,54057,45918,58152,51560,15528,36160,9550,58188,24039,44238,38226,47170,14459,28081,47684,2478,37584,14856,37677,55801,24641,6328,13115,18440,17407,30576,5201,14972,60786,23168,49525,57794,23497,5067,1832,64242,49085,13349,10740,61120,21562,61736,17997,16054,53633,57962,26500,61846,9217,20366,48073,15876,11611,11266,15391,64921,26777,52947,49302,23096,35563,54128,37050,10122,20375,65333,3332,14922,65091,32916,7992,11488,59204,28809,38359,35852,34229,7190,3395,44491,19974,15032,726,33723,26750,64548,50686,10621,20648,22785,11860,25252,64860,34659,24650,58049,8527,55124,58213,12722,22942,28890,46989,14086,36392,44225,39426,12848,35447,15797,56243,37482,29713,5179,13309,21724,32022,29176,61675,13107,24486,64425,34969},
  {4726,62202,4546,29903,47211,55270,54325,59389,58756,63029,36829,8170,39823,36547,37017,30710,30626,2079,41852,11385,9286,13399,13183,39226,59368,42255,61497,58968,64588,32322,57400,65380,37662,32800,17544,1976,42279,26672,33427,52428,51613,50270,14879,10161,62965,13643,40428,46129,12852,47612,46391,56143,16262,34909,58851,16529,22796,9759,53726,30933,51830,20201,22632,39254,6674,27593,36734,60901,6316,12163,11344,57107,53903,24446,5178,42357,33569,3195,32078,13417,62786,55201,18968,48892,11965,15682,52084,22051,24696,9894,8791,40907,65208,21059,1540,25299,15989,57417,35013,52015,47112,25319,61531,13693,58284,6530,23295,9815,21920,16646,13310,62004,27099,40236,38225,6349,20609,340,32947,34689,29470,31097,59281,26677,13738,42555,52926,42519,22287,47027,56883,57568,45232,18850,32119,30991,41,37662,36775,43632,40570,46917,57663,48048,8437,5073,60814,51583,61999,436,43100,39749,15925,55837,17058,29233,18300,62404,54095,61416,30969,51461,37764,38938,31986,2195,62409,15881,42650,33089,34628,35918,31781,16258,1753,7911,56425,6881,49703,38162,605,62132,41073,37873,3810,28162,44684,57965,11815,9688,48535,36266,54976,34902,64487,26237,5965,59977,22771,43885,858,62834,34377,50657,1871,32560,4626,33803,54756,7468,43762,24073,51068,14737,12988,24389,62211,35844,12476,31595,34066,18496,44817,10577,64739,2561,50580,28746,6022,26032,65085,8779,9717,44304,61244,18048,28025,23586,42552,15388,9599,51550,19819,60340,15303,43031,8645,15768,15832,41862,62847,4444,46775,63355,52253,62880,52230,35259,36178,64798,30168,57410,18603,15542,33635,65140,62694,36068,1890,58596,32878,49810,32949,40467,62201,63728,33174,26505,10299,15877,43563,17337,50051,23359,42425,42469,32801,48754,21117,19071,14814,34493,4329,58918,9072,18920,1657,43504,17471,479,63743,9912,45243,62944,6203,29277,49970,40366,31982,23265,46424,30568,2799,41936,271,42287,38206,14139,62660,60028,6711,16541,39253,35265,32282,48673,37494,4995,12422,57366,5476,629,42401,4689,78,12104,44250,54413,3264,33744,47438,11169,38668,16338,46368,8454,17587,27908,1256,15644,29910,27597,4631,39222,59192,60295,31382,29249,44130,43349,38452,12941,15259,61067,39600,55048,62398,13213,10293,14070,2128,62895,29007,55251,38386,34603,53551,24062,29513,1658,25302,8198,56235,52646,6816,26387,34947,35353,46432,21894,34854,54921,12679,5562,19464,18857,10573,18970,60587,28909,55622,45441,18588,17760,59964,15884,9337,54119,23122,14227,3275,48279,22442,54704,14552,46831,18095,46193,22059,27245,63584,55170,26469,40036,59665,15219,47334,1387,39393,59378,34892,19312,23615,3594,38061,30009,21796,40508,51888,6217,56015,52049,21381,33989,28377,60338,56477,26866,35436,23699,16210,27314,10493,47150,49050,13344,5259,51326,33749,7280,19106,20073,7649,15528,24405,62,12332,39652,49328,34827,25427,40215,30774,63702,54133,38248,8887,5668,3182,29137,27574,47091,39761,27355,23098,30195,22121,2202,17808,19305,12046,3750,9686,14396,11141,12831,20311,9467,7978,49678,23400,46813,4984,24057,38375,15340,8099,40800,55215,17351,37476,15559,53195,6564,29310,2030,15952,60088,65196,25692,36426,20733,44582,16049,22324,2017,50120,49381,43623,62045,24197,64539,33798,62944,4500,16002,12760,59363,42960,3946,4227,47457,59927,5600,24149,58245,4219,33918,47675,49616,29356,28945,4677,5910,40962,47569,51561,9140,46830,18791,4405,7093,28879,13431,45253,18755,37036,16385,21416,50043,49933,4805,441,64024,43350,2760,39936,50061,53797,41795,13956,17014,4987,45201,24103,20579,23734,28999,62105,47129,10606,27851,59816,34357,51947,4317,16491,43201,38066,8149,14228,3789,25762,63105,55327,12911,33769,9229,56336,62497,63558,22058,26786,4820,5518,43908,21354,32692,31142,17192,10265,23120,42484,53258,15881,44293,26149,43532,46381,13444,57480,52752,8385,50255,33148,54269,51106,58713,21504,52873,48409,16679,50938,2071,60600,26096,34627,65137,53824,28169,35937,58424,43338},
} ;

static const unsigned char precomputed_decode_653xint16_s[precomputed_decode_653xint16_NUM][crypto_decode_STRBYTES] = {
  {120,231,218,152,33,68,74,143,150,100,60,6,95,31,55,210,5,146,155,47,69,119,12,79,195,32,18,139,158,166,10,150,85,72,201,64,110,238,169,216,152,183,138,168,151,24,138,50,207,136,137,171,139,222,80,131,231,147,130,197,129,247,24,132,196,172,191,229,198,212,186,125,157,9,76,7,135,67,203,184,218,177,242,145,124,62,99,134,152,29,50,89,215,212,229,45,109,156,2,112,16,67,103,66,69,70,222,82,221,98,233,48,16,135,3,112,116,205,194,135,7,21,216,94,58,107,58,77,2,252,64,24,161,43,107,129,32,251,90,18,119,99,207,214,41,59,101,234,159,160,7,130,140,229,251,21,155,129,79,186,185,78,17,98,177,207,235,28,134,73,151,46,238,15,23,195,184,196,1,152,188,42,87,171,88,249,148,53,109,77,3,66,17,122,106,116,137,220,20,50,85,111,178,141,88,49,104,168,49,112,167,69,243,25,183,198,78,6,97,221,46,110,249,209,219,174,97,142,53,204,51,223,192,221,204,101,139,233,104,46,242,185,79,183,191,147,187,135,27,73,97,22,241,90,205,94,56,14,98,128,75,98,97,236,133,163,206,95,172,246,206,46,65,21,110,58,67,65,201,11,94,209,16,70,77,222,219,228,147,10,133,20,203,139,21,51,214,208,137,9,52,14,223,54,241,1,165,62,3,218,48,200,164,197,195,130,29,232,25,227,118,218,211,202,118,58,72,153,113,94,244,30,192,126,194,39,81,52,133,152,7,158,107,78,89,232,49,77,223,78,68,67,159,195,139,60,131,133,51,228,59,223,110,96,187,101,46,164,17,10,143,1,147,25,18,15,202,94,230,23,95,75,60,211,25,168,57,81,95,108,13,143,251,109,208,21,13,239,243,93,205,202,252,27,139,7,159,132,242,100,168,236,166,118,184,194,99,131,158,77,61,134,189,153,222,78,46,38,110,190,238,189,219,125,35,28,209,172,181,205,75,103,14,45,32,94,108,216,11,183,67,247,140,203,55,96,5,36,30,244,55,180,179,30,239,237,201,182,118,21,179,148,79,120,102,193,221,120,68,102,170,188,201,90,219,23,147,35,50,116,194,240,137,227,28,45,29,159,137,186,232,195,113,94,106,10,102,16,162,74,11,175,10,168,180,82,187,237,175,19,87,193,58,98,61,138,233,217,175,26,200,241,164,123,226,4,174,210,252,10,208,188,86,242,206,220,184,196,254,57,62,220,162,195,19,73,85,160,245,14,100,153,240,226,200,45,60,172,31,145,161,14,147,58,29,245,185,193,32,70,37,6,129,213,129,217,191,64,220,114,97,15,220,117,153,2,206,140,42,173,74,71,49,151,226,34,88,201,89,53,10,116,245,53,187,106,94,151,220,120,189,18,57,226,17,130,192,192,49,225,201,16,250,132,101,114,75,156,100,103,127,115,251,111,184,146,233,113,255,131,80,168,161,84,62,157,136,143,178,179,193,62,107,179,174,182,32,164,215,147,160,15,61,71,74,242,101,145,23,70,246,216,34,49,182,199,117,162,244,2,112,146,53,21,165,197,90,218,28,25,180,249,51,0,183,142,226,88,226,53,73,63,143,107,145,48,234,14,163,92,214,170,243,91,158,149,124,154,31,150,140,63,106,177,217,42,231,158,100,133,6,83,112,133,243,215,99,136,197,12,62,245,234,73,3,38,220,76,217,42,41,51,79,176,102,79,149,247,255,157,115,88,160,52,177,143,115,133,192,3,182,251,186,143,54,12,249,178,35,180,45,35,160,193,192,232,136,89,10,136,48,38,51,184,211,244,78,191,199,177,41,206,99,150,29,201,175,51,58,89,79,242,134,57,136,192,148,114,71,138,154,227,233,63,124,162,243,55,228,101,248,38,17,193,236,253,95,19,65,8,32,113,170,13,109,202,204,136,143,110,19,201,188,28,69,236,92,22,120,88,99,141,247,203,197,92,114,41,24,190,21,84,246,46,109,116,113,28,123,34,161,179,40,192,75,146,95,232,117,40,140,85,24,47,99,246,145,43,151,110,218,193,103,137,130,35,177,248,219,43,18,237,89,25,194,203,5,50,212,114,219,150,67,217,108,255,168,163,167,30,222,151,132,130,37,223,84,141,121,53,62,104,5,117,120,205,48,242,109,235,81,72,57,114,119,78,133,250,28,93,208,169,122,187,46,90,175,9,219,207,172,15,203,216,168,28,125,2,219,110,215,79,57,248,128,141,5,32,142,108,112,115,25,178,59,83,235,48,121,170,36,166,101,248,142,76,130,252,103,160,71,155,116,135,3,118,133,234,101,253,68,177,2,154,153,99,29,101,39,130,230,195,81,62,218,245,165,18,103,243,206,203,21,168,152,54,144,82,100,129,241,213,135,74,86,238,9,153,63,21,132,16,45,135,137,128,111,59,196,176,44,110,47,51,227,171,235,152,153,109,196,79,150,252,74,70,92,16,85,249,101,116,162,92,171,111,211,97,189,7,139,0,205,115,54,56,208,162,213,160,65,231,9,142,191,103,21,171,85,171,168,219,240,128,177,217,252,133,1,192,240,59,133,68,169,81,184,144,65,140,192,198,213,61,133,152,221,104,124,182,220,156,136,8,56,84,228,50,68,26,202,251,37,115,146,90,134,247,84,64,49,46,146,7,7,180,65,144,126,107,97,61,246,204,8,148,108,39,161,237,221,15,18,180,229,183,92,145,150,211,31,127,219,158,28,201,210,90,29,39,142,162,151,244,227,56,35,235,57,214,117,249,90,160,101,208,148,23,199,186,139,155,168,158,94,225,194,62,23,58,8,144,29,141,20,253,207,74,43,92,47,214,91,90,40,196,187,243,77,50,44,130,193,9,22,42,69,23,13,108,44,251,146,100,74,142,95,143,7,70,21,238,44,123,0,161,236,83,170,123,185,95,200,208,217,77},
  {138,53,9,64,54,216,209,199,134,89,58,193,175,233,16,141,235,153,121,225,9,39,211,197,22,99,207,19,6,48,108,40,44,162,55,101,87,125,98,168,201,32,60,139,121,212,218,111,48,76,232,93,170,19,180,74,129,30,91,88,51,218,188,40,36,0,48,19,41,239,235,59,188,82,67,211,166,118,195,12,121,211,141,122,201,182,152,251,187,225,79,186,125,100,239,197,191,173,94,99,107,225,52,234,141,200,46,41,48,130,150,66,118,49,212,229,128,76,198,98,122,90,175,106,22,162,172,208,106,231,163,210,158,62,154,86,243,145,219,63,17,36,166,14,156,12,161,9,178,230,26,111,84,112,37,112,16,160,154,118,40,55,250,75,29,225,120,89,22,149,184,195,49,0,102,39,7,205,114,90,106,94,102,13,110,184,158,180,43,147,240,21,112,140,122,105,183,64,66,29,107,76,199,174,190,42,114,128,113,248,81,197,143,68,243,238,182,24,17,6,42,227,100,174,133,250,79,251,143,61,186,39,200,84,16,168,104,127,57,113,0,223,46,100,42,36,84,233,58,29,133,237,233,247,100,208,101,39,53,13,112,198,136,120,255,158,31,9,44,70,163,26,179,156,173,54,47,73,115,56,182,87,152,241,187,44,106,93,178,213,121,1,45,174,116,231,231,147,30,81,122,143,36,199,18,226,222,216,13,155,11,8,213,91,50,222,229,142,144,3,38,84,111,179,129,215,255,167,194,234,84,154,233,113,206,182,92,222,207,100,77,114,253,156,197,250,88,116,208,35,71,249,118,51,175,165,19,129,250,199,126,118,184,125,114,55,6,124,123,79,203,165,44,114,239,176,247,160,158,23,239,92,48,130,72,62,75,64,93,133,44,195,113,69,116,161,205,164,109,99,249,162,187,78,45,20,130,51,24,223,94,37,43,247,156,252,87,204,175,78,97,237,243,227,26,24,186,73,183,253,200,187,194,215,55,65,16,162,19,240,161,163,161,51,223,151,132,248,20,151,182,205,70,56,220,124,82,209,125,165,168,36,43,93,124,241,166,132,172,213,136,92,53,62,211,219,201,182,247,54,228,179,153,63,183,86,214,250,32,28,170,101,90,204,21,181,69,168,77,62,148,80,93,245,71,252,179,85,164,128,171,102,129,210,217,117,68,226,142,191,217,70,110,145,217,1,163,234,248,117,168,118,179,217,169,39,243,156,208,235,242,219,171,172,227,38,183,137,224,255,173,87,176,217,27,121,148,121,228,207,190,214,25,92,113,166,216,151,35,57,44,56,52,242,181,241,68,37,190,204,85,197,222,102,56,185,28,63,60,70,196,109,84,115,45,145,14,0,119,60,158,21,106,132,21,111,22,201,22,169,229,201,13,210,106,5,22,23,201,113,192,20,218,81,83,185,133,171,186,228,249,196,184,24,203,112,69,63,178,19,197,26,197,162,94,240,130,206,12,215,115,93,245,188,24,72,110,63,102,36,172,138,172,193,14,109,217,31,66,174,167,36,184,164,96,28,220,221,255,22,155,176,134,242,102,209,229,54,64,122,9,0,89,190,153,58,105,136,51,224,117,169,108,136,107,201,114,105,118,166,244,235,21,149,164,29,198,80,28,13,138,181,23,230,141,84,220,229,160,41,81,253,248,255,233,183,66,169,223,42,125,118,194,198,162,96,78,156,15,88,194,8,143,122,112,50,27,209,220,209,14,46,118,77,129,212,22,108,137,101,96,241,106,127,185,67,50,12,15,97,61,95,88,123,157,25,86,129,196,224,213,144,200,171,213,165,177,97,107,1,117,29,22,158,182,129,115,123,137,43,134,81,159,186,118,206,99,31,124,161,213,72,22,140,82,213,160,20,99,164,142,252,11,180,151,13,137,220,143,93,240,146,55,3,151,136,120,230,5,242,162,74,195,169,11,9,148,95,148,76,3,30,7,39,174,169,49,236,86,4,64,46,101,36,205,180,60,31,207,183,9,247,227,103,24,47,55,10,150,153,46,71,164,254,177,231,118,51,169,245,114,152,223,123,178,245,248,93,104,248,247,72,238,133,79,106,206,83,150,172,27,240,237,128,16,17,178,185,85,83,210,255,102,74,204,200,103,129,197,75,150,237,73,193,246,163,33,62,62,249,112,163,25,47,150,76,190,250,51,71,87,104,111,228,219,23,177,66,110,46,45,204,88,139,175,199,151,100,61,75,200,50,2,241,177,243,175,4,234,147,29,2,128,84,168,158,239,18,172,72,50,43,102,143,25,16,223,218,16,197,106,162,157,58,237,48,254,252,152,26,97,17,142,84,51,226,68,43,176,192,162,4,177,106,31,206,189,106,196,18,135,216,42,153,32,248,152,249,215,23,5,231,56,63,10,208,220,168,231,93,226,133,185,150,65,106,203,218,113,240,76,190,167,2,7,62,169,125,105,248,46,78,229,196,220,7,205,239,162,73,8,22,40,149,138,14,130,50,23,102,61,192,239,222,204,198,176,110,109,29,135,43,120,17,47,247,181,94,34,167,238,232,70,78,44,201,90,70,194,32,88,186,132,138,19,134,124,112,203,33,130,65,186,21,61,123,36,52,60,208,137,6,76,41,232,139,95,119,249,104,252,188,133,249,237,248,127,206,187,176,7,72,187,137,156,113,55,209,155,110,138,175,138,66,206,77,176,133,180,124,107,61,212,154,221,94,99,244,235,101,242,117,113,65,132,147,115,202,94,207,221,50,147,14,36,167,60,159,98,124,148,174,53,133,101,21,219,148,197,94,148,232,20,208,162,252,151,82,222,202,127,130,3,82,115,79,106,233,145,20,229,123,53,82,213,251,18,22,252,162,126,27,110,156,175,208,124,30,21,12,121,240,42,240,34,100,250,27,209,87,78,208,220,195,202,160,160,238,200,155,58,46,133,153,153,152,29,183,34,96,99,120,3,231,203,29},
  {249,54,181,16,44,47,247,251,191,191,12,144,242,251,78,120,98,247,198,77,67,2,185,144,166,253,191,46,144,74,72,179,139,155,131,102,163,145,142,12,164,46,42,50,102,59,7,199,114,188,27,143,130,49,168,109,54,143,37,68,233,81,51,86,178,17,218,88,154,213,174,95,117,129,184,0,169,191,80,155,128,93,70,142,190,80,107,239,67,167,206,134,164,207,197,31,243,90,178,104,238,238,125,153,52,148,238,53,172,222,131,102,46,179,142,29,238,222,176,30,51,206,23,151,223,246,228,109,18,144,204,242,159,149,190,111,2,155,212,59,14,109,157,246,155,114,173,77,151,208,223,55,84,183,177,89,15,53,180,107,15,142,65,160,230,118,110,3,47,4,40,41,197,41,235,100,89,177,165,27,107,135,178,238,228,106,57,15,119,114,244,50,90,126,153,161,53,158,2,13,112,225,205,226,88,50,69,70,77,230,148,240,77,119,186,240,21,10,176,57,95,102,4,221,47,212,142,59,36,84,43,209,139,135,202,79,179,172,36,233,5,209,240,242,129,19,146,225,111,3,21,196,183,169,16,89,251,186,154,39,171,219,70,189,130,39,209,176,87,2,111,231,104,2,219,3,175,91,239,181,108,179,65,210,130,98,129,38,245,157,186,87,23,169,47,223,156,236,185,24,39,232,92,214,206,242,105,199,110,232,19,231,136,123,45,108,182,70,167,117,95,250,54,227,206,67,101,182,168,140,101,114,229,117,224,151,216,133,78,106,69,187,98,55,246,75,55,49,222,217,185,71,152,53,212,10,123,42,49,41,109,78,100,41,224,117,180,153,107,30,239,231,91,164,49,7,27,200,26,130,21,15,175,48,239,148,63,18,152,25,26,228,170,94,216,67,237,0,205,137,197,148,250,56,2,203,173,72,167,110,248,214,224,210,209,60,164,80,105,202,246,198,202,77,89,202,249,41,223,242,71,38,12,202,69,42,121,110,18,46,225,184,213,160,35,179,88,155,147,28,94,132,242,28,33,212,217,5,188,176,10,198,88,106,158,27,65,112,129,1,208,7,32,84,194,187,220,30,47,90,39,11,77,109,40,183,66,219,253,173,17,38,22,173,159,225,255,113,143,202,105,171,187,193,241,128,87,24,5,8,168,158,47,119,92,254,177,118,52,13,33,102,161,0,210,148,48,104,79,30,106,83,233,244,103,132,171,51,53,208,185,203,68,196,25,116,16,243,119,88,11,253,250,70,226,191,7,235,203,116,235,148,224,181,109,145,235,4,58,18,103,74,99,61,171,227,165,190,214,101,27,78,246,210,178,119,219,144,210,4,216,185,53,214,156,117,111,47,127,125,197,69,160,167,80,54,99,38,237,232,209,161,241,223,244,22,53,35,66,210,152,14,156,134,18,237,19,34,185,9,105,64,92,31,158,173,218,191,159,252,25,107,250,25,116,204,81,159,246,215,211,39,194,89,157,3,168,121,69,64,130,134,160,118,191,212,167,84,1,233,50,183,226,67,110,37,164,253,8,226,110,223,60,210,37,64,61,173,233,184,115,85,92,99,3,19,111,25,21,218,254,101,84,144,42,64,188,23,246,139,217,201,147,242,87,47,141,92,179,28,68,136,222,24,23,138,182,180,239,227,83,115,177,68,33,156,49,135,83,50,24,137,80,207,166,238,36,127,188,153,190,29,114,11,8,211,181,81,160,126,234,168,180,207,46,237,201,14,122,37,39,217,40,76,75,247,24,178,125,228,32,226,56,227,60,76,2,190,213,202,102,172,32,128,251,152,251,206,45,53,106,82,188,10,231,232,40,156,170,91,139,234,11,43,148,229,85,29,79,81,197,156,212,24,230,247,112,253,84,47,80,73,106,85,141,73,156,53,97,211,92,175,100,91,138,53,253,235,100,121,27,182,15,163,134,245,240,150,48,7,143,97,216,200,102,77,63,239,146,103,151,71,136,10,143,114,205,159,22,14,125,141,194,9,176,209,0,164,15,112,190,58,68,166,66,116,136,132,24,33,155,79,113,35,109,81,67,7,0,247,17,31,181,41,102,221,17,158,163,106,70,177,228,45,244,2,239,224,190,247,57,82,35,177,221,139,57,157,247,152,8,212,106,132,131,214,230,175,94,197,20,144,29,237,10,79,225,49,146,231,20,254,214,10,30,116,45,111,105,159,212,63,197,191,146,180,195,169,25,248,181,107,95,8,25,181,21,29,148,7,44,23,182,255,83,165,68,187,51,90,159,159,5,57,48,56,155,190,115,4,78,142,129,159,52,254,183,141,229,165,106,158,195,201,51,53,133,47,59,76,61,197,242,59,243,62,161,159,195,132,171,250,92,113,145,97,83,142,153,215,135,41,150,167,102,236,43,27,24,218,41,211,94,179,40,227,104,201,168,60,64,141,78,37,76,227,231,93,206,172,82,149,66,184,123,56,177,109,68,186,174,9,208,146,8,58,45,147,249,217,65,96,184,24,59,51,8,72,255,67,112,119,81,20,124,58,114,237,128,90,117,193,194,225,201,91,203,19,40,7,242,250,189,191,37,52,244,41,192,238,58,84,40,241,77,70,182,62,129,209,106,226,132,103,150,241,1,36,142,79,201,187,4,62,91,45,2,44,31,60,153,253,153,104,211,206,150,192,56,90,235,138,112,211,186,144,138,39,151,79,53,255,4,13,74,58,67,254,148,128,56,31,224,44,68,231,137,112,215,149,12,140,181,133,22,28,67,13,203,173,6,78,184,58,214,2,187,131,126,104,36,252,254,197,125,41,168,80,1,89,84,46,164,98,92,253,99,135,74,96,193,226,79,33,84,215,101,227,178,49,158,89,218,112,141,183,6,55,40,142,193,172,2,154,48,50,119,138,181,61,179,219,106,146,17,116,59,20,253,51,220,84,22,125,248,113,235,240,51,51,166,95,169,251,153,136},
  {118,18,250,242,194,17,207,116,107,184,230,215,53,212,253,231,132,229,53,246,221,143,234,31,143,155,195,142,153,144,246,119,162,119,31,8,124,163,121,44,70,36,87,52,127,51,58,153,232,231,15,165,57,240,88,230,76,252,66,126,56,224,100,255,30,147,32,128,136,68,184,7,39,165,48,104,147,130,204,204,157,201,94,196,31,58,177,39,245,245,75,53,236,157,49,180,52,50,252,185,55,181,79,219,134,63,93,136,227,229,145,64,12,89,31,38,222,209,213,120,118,202,233,78,104,88,86,153,18,26,201,107,126,143,229,237,172,24,131,47,80,44,19,223,143,210,126,95,58,20,117,165,33,131,123,12,78,125,105,52,66,245,161,215,24,74,252,190,189,46,66,61,116,203,35,86,120,96,166,38,87,34,203,159,184,254,67,82,4,6,211,98,117,62,73,224,197,136,47,203,8,184,231,98,91,240,125,53,172,227,130,25,255,90,87,38,160,85,6,65,254,51,52,242,219,105,44,157,81,149,205,24,129,80,84,1,179,128,129,135,30,115,121,121,145,231,53,104,170,53,59,166,190,206,23,166,15,87,179,183,51,222,224,224,176,176,162,73,119,125,15,121,41,0,30,147,167,143,112,170,122,158,69,183,63,225,176,187,245,32,209,19,142,237,127,201,47,242,180,1,92,168,69,155,53,62,29,218,162,66,49,114,124,71,196,243,79,211,232,239,249,120,5,201,132,147,26,152,242,124,147,8,201,243,9,62,154,166,65,129,68,135,78,140,37,124,130,63,217,6,231,30,105,220,225,26,39,194,18,149,93,2,180,242,113,160,241,147,226,14,2,110,140,174,109,226,39,46,216,37,151,189,170,141,192,214,86,136,231,251,125,102,77,23,73,234,243,88,109,171,90,3,114,245,73,134,225,197,79,7,48,127,18,18,11,132,228,213,44,29,242,170,9,94,124,199,145,57,188,50,69,95,3,243,4,140,188,48,107,123,18,133,64,72,17,175,81,41,227,252,1,10,148,197,74,112,134,23,176,101,61,254,75,34,245,37,16,173,60,239,128,70,121,109,34,92,56,166,28,60,127,37,94,201,107,77,180,235,199,59,23,168,197,33,152,61,216,61,134,163,127,245,92,17,183,182,123,247,29,204,160,245,6,204,187,137,82,141,30,253,216,117,66,224,171,72,182,60,99,131,116,254,230,244,228,140,98,7,228,228,110,128,146,194,181,128,19,158,249,242,240,248,150,129,137,103,59,40,5,62,43,170,185,67,131,195,63,91,185,165,229,165,33,128,114,190,125,82,127,74,222,57,189,134,233,16,38,230,112,35,232,73,121,6,240,169,63,68,223,1,255,248,184,38,187,176,224,245,59,24,93,114,50,195,174,157,238,124,225,90,88,181,104,119,239,10,208,163,15,1,47,165,62,149,59,55,196,244,124,234,55,26,157,64,85,153,193,137,26,126,33,190,118,146,131,19,134,48,22,224,100,21,117,2,161,165,81,18,78,0,72,47,218,172,141,212,192,12,208,131,78,185,161,43,12,151,210,63,32,181,6,33,179,68,4,109,232,4,28,61,214,116,205,107,23,18,54,153,56,231,135,235,150,122,65,114,98,172,85,169,52,150,141,50,155,59,139,238,176,154,8,215,190,243,157,51,53,40,246,54,80,8,175,245,79,113,211,215,242,149,43,135,47,209,254,93,73,115,122,6,214,98,6,32,171,219,166,205,160,26,19,103,131,136,25,138,96,181,134,85,38,136,137,214,135,49,186,21,8,76,169,73,77,41,26,74,171,236,237,112,70,217,129,177,156,72,96,69,60,234,12,62,121,36,103,211,82,90,147,55,203,12,151,188,170,87,176,213,216,56,239,182,175,70,113,180,43,86,109,106,96,248,130,215,101,103,100,156,17,233,115,59,230,184,107,5,225,153,242,231,76,136,112,75,63,92,10,14,173,148,57,117,36,85,60,158,176,202,73,24,207,218,81,203,133,83,197,132,217,110,178,235,157,220,242,104,108,138,147,92,82,63,178,106,253,40,46,184,154,191,32,52,139,20,126,200,213,131,112,28,162,74,105,78,225,29,168,60,85,95,62,0,44,48,228,154,176,192,11,136,83,99,23,157,54,120,214,248,117,211,104,149,183,34,36,22,110,12,209,113,182,107,243,183,81,155,219,106,58,90,243,117,105,86,154,8,144,69,105,75,14,47,166,14,214,37,60,56,133,43,31,50,87,79,251,36,42,31,14,194,104,91,221,182,120,19,249,93,231,149,236,59,163,31,96,159,175,215,199,67,100,146,199,60,203,207,164,25,126,114,238,7,80,62,184,234,172,254,92,100,74,142,253,80,38,174,177,62,52,87,225,7,200,195,229,192,103,170,93,242,133,94,27,252,6,132,224,245,148,17,130,62,216,49,227,231,208,167,106,15,131,16,97,185,23,234,224,21,85,94,133,227,123,16,126,132,59,186,208,193,172,114,17,113,69,18,22,23,2,160,209,185,105,201,180,35,238,182,103,73,53,17,181,27,207,112,119,52,197,176,67,73,172,144,1,64,168,83,123,195,13,195,197,18,185,1,24,250,86,169,200,10,0,156,141,195,37,210,67,163,132,54,118,66,123,19,145,176,39,94,99,80,182,92,71,113,153,242,25,184,110,41,203,108,168,233,53,134,235,202,221,16,107,64,193,168,178,148,213,31,148,55,205,14,162,100,129,246,31,216,111,50,233,131,13,36,16,220,33,244,70,248,42,86,162,104,212,18,142,21,132,171,106,83,180,127,166,121,40,67,25,40,80,90,244,165,10,208,9,62,5,173,37,102,12,170,45,181,132,52,136,224,16,206,193,32,79,196,124,129,253,211,162,199,89,229,0,84,137,206,25,189,39,65,250,198,23,8,184,236,240,101,67,135,113,254,64,210,9,110,97,140,56,228,74,169},
} ;

static void test_decode_653xint16_impl(long long impl)
{
  unsigned char *x = test_decode_653xint16_x;
  unsigned char *s = test_decode_653xint16_s;
  unsigned char *x2 = test_decode_653xint16_x2;
  unsigned char *s2 = test_decode_653xint16_s2;
  long long xwords = crypto_decode_ITEMS;
  long long xlen;
  long long slen = crypto_decode_STRBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_decode_653xint16_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_decode = ntruprime_dispatch_decode_653xint16(impl);
    printf("decode_653xint16 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_653xint16_implementation(impl),ntruprime_dispatch_decode_653xint16_compiler(impl));
  } else {
    crypto_decode = ntruprime_decode_653xint16;
    printf("decode_653xint16 selected implementation %s compiler %s\n",ntruprime_decode_653xint16_implementation(),ntruprime_decode_653xint16_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_decode_ITEMBYTES;

      output_prepare(x2,x,xlen);
      input_prepare(s2,s,slen);
      secret(s,slen);
      crypto_decode(x,s);
      public(s,slen);
      public(x,xlen);
      endianness(x,xwords,crypto_decode_ITEMBYTES);
      checksum(x,xlen);
      output_compare(x2,x,xlen,"crypto_decode");
      input_compare(s2,s,slen,"crypto_decode");

      double_canary(x2,x,xlen);
      double_canary(s2,s,slen);
      secret(s2,slen);
      crypto_decode(x2,s2);
      public(s2,slen);
      public(x2,xlen);
      endianness(x2,xwords,crypto_decode_ITEMBYTES);
      if (memcmp(x2,x,xlen) != 0) fail("failure: crypto_decode is nondeterministic\n");
    }
    checksum_expected(decode_653xint16_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_decode_653xint16_NUM;++precomp) {
    output_prepare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
    input_prepare(s2,s,crypto_decode_STRBYTES);
    memcpy(s,precomputed_decode_653xint16_s[precomp],crypto_decode_STRBYTES);
    memcpy(s2,precomputed_decode_653xint16_s[precomp],crypto_decode_STRBYTES);
    crypto_decode(x,s);
    if (memcmp(x,precomputed_decode_653xint16_x[precomp],crypto_decode_ITEMS*crypto_decode_ITEMBYTES)) {
      fail("failure: crypto_decode fails precomputed test vectors\n");
      printf("expected x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",((unsigned char *) precomputed_decode_653xint16_x[precomp])[pos]);
      printf("\n");
      printf("received x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",x[pos]);
      printf("\n");
    }
    output_compare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES,"crypto_decode");
    input_compare(s2,s,crypto_decode_STRBYTES,"crypto_decode");
  }
}

void test_decode_653xint16(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"653xint16")) return;
  storage_decode_653xint16_x = callocplus(crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  test_decode_653xint16_x = aligned(storage_decode_653xint16_x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  if (crypto_decode_ITEMS*crypto_decode_ITEMBYTES > maxalloc) maxalloc = crypto_decode_ITEMS*crypto_decode_ITEMBYTES;
  storage_decode_653xint16_s = callocplus(crypto_decode_STRBYTES);
  test_decode_653xint16_s = aligned(storage_decode_653xint16_s,crypto_decode_STRBYTES);
  if (crypto_decode_STRBYTES > maxalloc) maxalloc = crypto_decode_STRBYTES;
  storage_decode_653xint16_x2 = callocplus(maxalloc);
  test_decode_653xint16_x2 = aligned(storage_decode_653xint16_x2,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  storage_decode_653xint16_s2 = callocplus(maxalloc);
  test_decode_653xint16_s2 = aligned(storage_decode_653xint16_s2,crypto_decode_STRBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("decode_653xint16 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_decode_653xint16();++impl)
      forked(test_decode_653xint16_impl,impl);
    ++test_decode_653xint16_x;
    ++test_decode_653xint16_s;
    ++test_decode_653xint16_x2;
    ++test_decode_653xint16_s2;
  }
  free(storage_decode_653xint16_s2);
  free(storage_decode_653xint16_x2);
  free(storage_decode_653xint16_s);
  free(storage_decode_653xint16_x);
}
#undef crypto_decode_STRBYTES
#undef crypto_decode_ITEMS
#undef crypto_decode_ITEMBYTES

