/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BulkWriteResult;
import com.mongodb.BulkWriteUpsert;
import com.mongodb.WriteRequest;
import java.util.Collections;
import java.util.List;
import org.bson.util.Assertions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AcknowledgedBulkWriteResult
extends BulkWriteResult {
    private int insertedCount;
    private int matchedCount;
    private int removedCount;
    private Integer modifiedCount;
    private final List<BulkWriteUpsert> upserts;

    AcknowledgedBulkWriteResult(int insertedCount, int matchedCount, int removedCount, Integer modifiedCount, List<BulkWriteUpsert> upserts) {
        this.insertedCount = insertedCount;
        this.matchedCount = matchedCount;
        this.removedCount = removedCount;
        this.modifiedCount = modifiedCount;
        this.upserts = Collections.unmodifiableList(Assertions.notNull("upserts", upserts));
    }

    AcknowledgedBulkWriteResult(WriteRequest.Type type, int count, List<BulkWriteUpsert> upserts) {
        this(type, count, 0, upserts);
    }

    AcknowledgedBulkWriteResult(WriteRequest.Type type, int count, Integer modifiedCount, List<BulkWriteUpsert> upserts) {
        this(type == WriteRequest.Type.INSERT ? count : 0, type == WriteRequest.Type.UPDATE || type == WriteRequest.Type.REPLACE ? count : 0, type == WriteRequest.Type.REMOVE ? count : 0, modifiedCount, upserts);
    }

    @Override
    public boolean isAcknowledged() {
        return true;
    }

    @Override
    public int getInsertedCount() {
        return this.insertedCount;
    }

    @Override
    public int getMatchedCount() {
        return this.matchedCount;
    }

    @Override
    public int getRemovedCount() {
        return this.removedCount;
    }

    @Override
    public boolean isModifiedCountAvailable() {
        return this.modifiedCount != null;
    }

    @Override
    public int getModifiedCount() {
        if (this.modifiedCount == null) {
            throw new UnsupportedOperationException("The modifiedCount is not available because at least one of the servers that was updated was not able to provide this information (the server is must be at least version 2.6");
        }
        return this.modifiedCount;
    }

    @Override
    public List<BulkWriteUpsert> getUpserts() {
        return this.upserts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AcknowledgedBulkWriteResult that = (AcknowledgedBulkWriteResult)o;
        if (this.insertedCount != that.insertedCount) {
            return false;
        }
        if (this.matchedCount != that.matchedCount) {
            return false;
        }
        if (this.removedCount != that.removedCount) {
            return false;
        }
        if (this.modifiedCount != null ? !this.modifiedCount.equals(that.modifiedCount) : that.modifiedCount != null) {
            return false;
        }
        return this.upserts.equals(that.upserts);
    }

    public int hashCode() {
        int result = this.insertedCount;
        result = 31 * result + this.matchedCount;
        result = 31 * result + this.removedCount;
        result = 31 * result + (this.modifiedCount != null ? this.modifiedCount.hashCode() : 0);
        result = 31 * result + this.upserts.hashCode();
        return result;
    }

    public String toString() {
        return "AcknowledgedBulkWriteResult{insertedCount=" + this.insertedCount + ", matchedCount=" + this.matchedCount + ", removedCount=" + this.removedCount + ", modifiedCount=" + this.modifiedCount + ", upserts=" + this.upserts + '}';
    }
}

