//------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All rights reserved.
//------------------------------------------------------------------------------
namespace System.ServiceModel.Configuration
{
    static class ConfigurationStrings
    {
        internal const string AcknowledgementInterval = "acknowledgementInterval";
        internal const string ActivityTracing = "activityTracing";
        internal const string Add = "add";
        internal const string AdditionalRequestParameters = "additionalRequestParameters";
        internal const string Address = "address";
        internal const string AlgorithmSuite = "algorithmSuite";
        internal const string AllowAnonymousLogons = "allowAnonymousLogons";
        internal const string AllowCookies = "allowCookies";
        internal const string AllowedAudienceUris = "allowedAudienceUris";
        internal const string AllowedAudienceUri = "allowedAudienceUri";
        internal const string AllowedImpersonationLevel = "allowedImpersonationLevel";
        internal const string AllowInsecureTransport = "allowInsecureTransport";
        internal const string AllowNtlm = "allowNtlm";
        internal const string AllowSerializedSigningTokenOnReply = "allowSerializedSigningTokenOnReply";
        internal const string AllowUntrustedRsaIssuers = "allowUntrustedRsaIssuers";
        internal const string AlternativeIssuedTokenParameters = "alternativeIssuedTokenParameters";
        internal const string ApplicationContainerSettings = "applicationContainerSettings";
        internal const string AspNetCompatibilityEnabled = "aspNetCompatibilityEnabled";
        internal const string AsynchronousSendEnabled = "asynchronousSendEnabled";
        internal const string AudienceUriMode = "audienceUriMode";
        internal const string AuditLogLocation = "auditLogLocation";
        internal const string Authentication = "authentication";
        internal const string AuthenticationMode = "authenticationMode";
        internal const string AuthenticationScheme = "authenticationScheme";
        internal const string AuthenticationSchemes = "authenticationSchemes";
        internal const string AuthorizationPolicies = "authorizationPolicies";
        internal const string BaseAddress = "baseAddress";
        internal const string BaseAddresses = "baseAddresses";
        internal const string BaseAddressPrefixFilters = "baseAddressPrefixFilters";
        internal const string Basic128 = "Basic128";
        internal const string Basic192 = "Basic192";
        internal const string Basic256 = "Basic256";
        internal const string Basic128Rsa15 = "Basic128Rsa15";
        internal const string Basic192Rsa15 = "Basic192Rsa15";
        internal const string Basic256Rsa15 = "Basic256Rsa15";
        internal const string Basic128Sha256 = "Basic128Sha256";
        internal const string Basic192Sha256 = "Basic192Sha256";
        internal const string Basic256Sha256 = "Basic256Sha256";
        internal const string Basic128Sha256Rsa15 = "Basic128Sha256Rsa15";
        internal const string Basic192Sha256Rsa15 = "Basic192Sha256Rsa15";
        internal const string Basic256Sha256Rsa15 = "Basic256Sha256Rsa15";
        internal const string BasicHttpBindingCollectionElementName = "basicHttpBinding";
        internal const string BasicHttpsBindingCollectionElementName = "basicHttpsBinding";
        internal const string Behavior = "behavior";
        internal const string BehaviorConfiguration = "behaviorConfiguration";
        internal const string BehaviorExtensions = "behaviorExtensions";
        internal const string BehaviorsSectionName = "behaviors";
        internal const string BinaryMessageEncodingSectionName = "binaryMessageEncoding";
        internal const string Binding = "binding";
        internal const string BindingConfiguration = "bindingConfiguration";
        internal const string BindingElementExtensions = "bindingElementExtensions";
        internal const string BindingExtensions = "bindingExtensions";
        internal const string BindingName = "bindingName";
        internal const string BindingNamespace = "bindingNamespace";
        internal const string BindingsSectionGroupName = "bindings";
        internal const string BypassProxyOnLocal = "bypassProxyOnLocal";
        internal const string CacheCookies = "cacheCookies";
        internal const string CachedLogonTokenLifetime = "cachedLogonTokenLifetime";
        internal const string CacheIssuedTokens = "cacheIssuedTokens";
        internal const string CacheLogonTokens = "cacheLogonTokens";
        internal const string CallbackDebugSectionName = "callbackDebug";
        internal const string CallbackTimeouts = "callbackTimeouts";
        internal const string CanRenewSecurityContextToken = "canRenewSecurityContextToken";
        internal const string Certificate = "certificate";
        internal const string CertificateReference = "certificateReference";
        internal const string CertificateValidationMode = "certificateValidationMode";
        internal const string Channel = "channel";
        internal const string ChannelInitializationTimeout = "channelInitializationTimeout";
        internal const string ChannelPoolSettings = "channelPoolSettings";
        internal const string ClaimType = "claimType";
        internal const string ClaimTypeRequirements = "claimTypeRequirements";
        internal const string Clear = "clear";
        internal const string ClientBaseAddress = "clientBaseAddress";
        internal const string ClientCallbackAddressName = "clientCallbackAddress";
        internal const string ClientCertificate = "clientCertificate";
        internal const string ClientCredentials = "clientCredentials";
        internal const string ClientCredentialType = "clientCredentialType";
        internal const string ClientSectionName = "client";
        internal const string ClientViaSectionName = "clientVia";
        internal const string CloseIdleServicesAtLowMemory = "closeIdleServicesAtLowMemory";
        internal const string CloseTimeout = "closeTimeout";
        internal const string ComContract = "comContract";
        internal const string ComContractName = "name";
        internal const string ComContractNamespace = "namespace";
        internal const string ComContractsSectionName = "comContracts";
        internal const string ComMethod = "exposedMethod";
        internal const string ComMethodCollection = "exposedMethods";
        internal const string CommonBehaviorsSectionName = "commonBehaviors";
        internal const string ComPersistableTypes = "persistableTypes";
        internal const string CompositeDuplexSectionName = "compositeDuplex";
        internal const string CompressionFormat = "compressionFormat";
        internal const string ComSessionRequired = "requiresSession";
        internal const string ComUdt = "userDefinedType";
        internal const string ComUdtCollection = "userDefinedTypes";
        internal const string ConnectionBufferSize = "connectionBufferSize";
        internal const string ConnectionPoolSettings = "connectionPoolSettings";
        internal const string Contract = "contract";
        internal const string Cookie = "Cookie";
        internal const string CookieRenewalThresholdPercentage = "cookieRenewalThresholdPercentage";
        internal const string CreateNotificationOnConnection = "createNotificationOnConnection";
        internal const string Custom = "custom";
        internal const string CustomBindingCollectionElementName = "customBinding";
        internal const string CustomCertificateValidatorType = "customCertificateValidatorType";
        internal const string CustomDeadLetterQueue = "customDeadLetterQueue";
        internal const string CustomUserNamePasswordValidatorType = "customUserNamePasswordValidatorType";
        internal const string DataContractSerializerSectionName = "dataContractSerializer";
        internal const string DeadLetterQueue = "deadLetterQueue";
        internal const string DecompressionEnabled = "decompressionEnabled";
        internal const string Default = "Default";
        internal const string DefaultAlgorithmSuite = "defaultAlgorithmSuite";
        internal const string DefaultCertificate = "defaultCertificate";
        internal const string DefaultCollectionName = ""; // String.Empty
        internal const string DefaultKeyEntropyMode = "defaultKeyEntropyMode";
        internal const string DefaultMessageSecurityVersion = "defaultMessageSecurityVersion";
        internal const string DefaultName = "";
        internal const string DefaultPorts = "defaultPorts";
        internal const string DetectReplays = "detectReplays";
        internal const string DiagnosticSectionName = "diagnostics";
        internal const string DisablePayloadMasking = "disablePayloadMasking";
        internal const string Dns = "dns";
        internal const string Durable = "durable";
        internal const string Enabled = "enabled";
        internal const string EnableUnsecuredResponse = "enableUnsecuredResponse";
        internal const string EncodedValue = "encodedValue";
        internal const string Endpoint = "endpoint";
        internal const string EndpointBehaviors = "endpointBehaviors";
        internal const string EndpointConfiguration = "endpointConfiguration";
        internal const string EndpointExtensions = "endpointExtensions";
        internal const string EndToEndTracing = "endToEndTracing";
        internal const string EstablishSecurityContext = "establishSecurityContext";
        internal const string EtwProviderId = "etwProviderId";
        internal const string ExactlyOnce = "exactlyOnce";
        internal const string ExposedMethod = "exposedMethod";
        internal const string ExtendedProtectionPolicy = "extendedProtectionPolicy";
        internal const string Extension = "extension";
        internal const string Extensions = "extensions";
        internal const string ExternalMetadataLocation = "externalMetadataLocation";
        internal const string Factory = "factory";
        internal const string Filter = "filter";
        internal const string Filters = "filters";
        internal const string FindValue = "findValue";
        internal const string FlowControlEnabled = "flowControlEnabled";
        internal const string GroupName = "groupName";
        internal const string Handler = "handler";
        internal const string Handlers = "handlers";
        internal const string Header = "header";
        internal const string Headers = "headers";
        internal const string Host = "host";
        internal const string HostNameComparisonMode = "hostNameComparisonMode";
        internal const string HttpDigest = "httpDigest";
        internal const string HttpGetEnabled = "httpGetEnabled";
        internal const string HttpGetUrl = "httpGetUrl";
        internal const string HttpsGetEnabled = "httpsGetEnabled";
        internal const string HttpsGetUrl = "httpsGetUrl";
        internal const string HttpHelpPageEnabled = "httpHelpPageEnabled";
        internal const string HttpHelpPageUrl = "httpHelpPageUrl";
        internal const string HttpsHelpPageEnabled = "httpsHelpPageEnabled";
        internal const string HttpsHelpPageUrl = "httpsHelpPageUrl";
        internal const string HttpHelpPageBinding = "httpHelpPageBinding";
        internal const string HttpHelpPageBindingConfiguration = "httpHelpPageBindingConfiguration";
        internal const string HttpsHelpPageBinding = "httpsHelpPageBinding";
        internal const string HttpsHelpPageBindingConfiguration = "httpsHelpPageBindingConfiguration";
        internal const string HttpGetBinding = "httpGetBinding";
        internal const string HttpGetBindingConfiguration = "httpGetBindingConfiguration";
        internal const string HttpsGetBinding = "httpsGetBinding";
        internal const string HttpsGetBindingConfiguration = "httpsGetBindingConfiguration";
        internal const string MexHttpBindingCollectionElementName = "mexHttpBinding";
        internal const string HttpsTransportSectionName = "httpsTransport";
        internal const string HttpTransportSectionName = "httpTransport";
        internal const string MexHttpsBindingCollectionElementName = "mexHttpsBinding";
        internal const string ID = "ID";
        internal const string Identity = "identity";
        internal const string IdentityConfiguration = "identityConfiguration";        
        internal const string IdleTimeout = "idleTimeout";
        internal const string IgnoreExtensionDataObject = "ignoreExtensionDataObject";
        internal const string ImpersonateCallerForAllOperations = "impersonateCallerForAllOperations";
        internal const string ImpersonateOnSerializingReply = "impersonateOnSerializingReply";
        internal const string ImpersonationLevel = "impersonationLevel";
        internal const string InactivityTimeout = "inactivityTimeout";
        internal const string IncludeExceptionDetailInFaults = "includeExceptionDetailInFaults";
        internal const string IncludeTimestamp = "includeTimestamp";
        internal const string IncludeWindowsGroups = "includeWindowsGroups";
        internal const string IsChainIncluded = "isChainIncluded";
        internal const string IsOptional = "isOptional";
        internal const string IssuedCookieLifetime = "issuedCookieLifetime";
        internal const string IssuedKeyType = "issuedKeyType";
        internal const string IssuedToken = "issuedToken";
        internal const string IssuedTokenAuthentication = "issuedTokenAuthentication";
        internal const string IssuedTokenParameters = "issuedTokenParameters";
        internal const string IssuedTokenRenewalThresholdPercentage = "issuedTokenRenewalThresholdPercentage";
        internal const string IssuedTokenType = "issuedTokenType";
        internal const string Issuer = "issuer";
        internal const string IssuerAddress = "issuerAddress";
        internal const string IssuerChannelBehaviors = "issuerChannelBehaviors";
        internal const string IssuerMetadata = "issuerMetadata";
        internal const string IsSystemEndpoint = "isSystemEndpoint";
        internal const string KeepAliveEnabled = "keepAliveEnabled";
        internal const string KeepAliveInterval = "keepAliveInterval";
        internal const string KeyEntropyMode = "keyEntropyMode";
        internal const string KeySize = "keySize";
        internal const string KeyType = "keyType";
        internal const string Kind = "kind";
        internal const string KnownCertificates = "knownCertificates";
        internal const string LeaseTimeout = "leaseTimeout";
        internal const string ListenBacklog = "listenBacklog";
        internal const string ListenIPAddress = "listenIPAddress";
        internal const string ListenUri = "listenUri";
        internal const string ListenUriMode = "listenUriMode";
        internal const string LocalClientSettings = "localClientSettings";
        internal const string LocalIssuer = "localIssuer";
        internal const string LocalIssuerChannelBehaviors = "localIssuerChannelBehaviors";
        internal const string LocalServiceSettings = "localServiceSettings";
        internal const string LogEntireMessage = "logEntireMessage";
        internal const string LogKnownPii = "logKnownPii";
        internal const string LogMalformedMessages = "logMalformedMessages";
        internal const string LogMessagesAtServiceLevel = "logMessagesAtServiceLevel";
        internal const string LogMessagesAtTransportLevel = "logMessagesAtTransportLevel";
        internal const string ManualAddressing = "manualAddressing";
        internal const string MapClientCertificateToWindowsAccount = "mapClientCertificateToWindowsAccount";
        internal const string MaxAcceptedChannels = "maxAcceptedChannels";
        internal const string MaxArrayLength = "maxArrayLength";
        internal const string MaxBatchSize = "maxBatchSize";
        internal const string MaxBufferPoolSize = "maxBufferPoolSize";
        internal const string MaxBufferSize = "maxBufferSize";
        internal const string MaxBytesPerRead = "maxBytesPerRead";
        internal const string MaxCachedCookies = "maxCachedCookies";
        internal const string MaxCachedLogonTokens = "maxCachedLogonTokens";
        internal const string MaxClockSkew = "maxClockSkew";
        internal const string MaxConcurrentCalls = "maxConcurrentCalls";
        internal const string MaxConcurrentInstances = "maxConcurrentInstances";
        internal const string MaxConcurrentSessions = "maxConcurrentSessions";
        internal const string MaxConnections = "maxConnections";
        internal const string MaxCookieCachingTime = "maxCookieCachingTime";
        internal const string MaxDepth = "maxDepth";
        internal const string MaxIssuedTokenCachingTime = "maxIssuedTokenCachingTime";
        internal const string MaxItemsInObjectGraph = "maxItemsInObjectGraph";
        internal const string MaxMessagesToLog = "maxMessagesToLog";
        internal const string MaxNameTableCharCount = "maxNameTableCharCount";
        internal const string MaxOutboundChannelsPerEndpoint = "maxOutboundChannelsPerEndpoint";
        internal const string MaxOutboundConnectionsPerEndpoint = "maxOutboundConnectionsPerEndpoint";
        internal const string MaxOutputDelay = "maxOutputDelay";
        internal const string MaxPendingAccepts = "maxPendingAccepts";
        internal const string MaxPendingChannels = "maxPendingChannels";
        internal const string MaxPendingConnections = "maxPendingConnections";
        internal const string MaxPendingReceives = "maxPendingReceives";
        internal const string MaxPendingSessions = "maxPendingSessions";
        internal const string MaxPoolSize = "maxPoolSize";
        internal const string MaxReadPoolSize = "maxReadPoolSize";
        internal const string MaxReceivedMessageSize = "maxReceivedMessageSize";
        internal const string MaxRetryCount = "maxRetryCount";
        internal const string MaxRetryCycles = "maxRetryCycles";
        internal const string MaxSessionSize = "maxSessionSize";
        internal const string MaxSizeOfMessageToLog = "maxSizeOfMessageToLog";
        internal const string MaxStatefulNegotiations = "maxStatefulNegotiations";
        internal const string MaxStringContentLength = "maxStringContentLength";
        internal const string MaxTransferWindowSize = "maxTransferWindowSize";
        internal const string MaxWritePoolSize = "maxWritePoolSize";
        internal const string MembershipProviderName = "membershipProviderName";
        internal const string Message = "message";
        internal const string MessageAuthenticationAuditLevel = "messageAuthenticationAuditLevel";
        internal const string MessageEncoding = "messageEncoding";
        internal const string MessageFlowTracing = "messageFlowTracing";
        internal const string MessageHandlerFactory = "messageHandlerFactory";
        internal const string MessageLogging = "messageLogging";
        internal const string MessageProtectionOrder = "messageProtectionOrder";
        internal const string MessageSecurityVersion = "messageSecurityVersion";
        internal const string MessageSenderAuthentication = "messageSenderAuthentication";
        internal const string MessageVersion = "messageVersion";
        internal const string Metadata = "metadata";
        internal const string MinFreeMemoryPercentageToActivateService = "minFreeMemoryPercentageToActivateService";
        internal const string Mode = "mode";
        internal const string MsmqAuthenticationMode = "msmqAuthenticationMode";
        internal const string MsmqEncryptionAlgorithm = "msmqEncryptionAlgorithm";
        internal const string MsmqIntegrationBindingCollectionElementName = "msmqIntegrationBinding";
        internal const string MsmqIntegrationSectionName = "msmqIntegration";
        internal const string MsmqProtectionLevel = "msmqProtectionLevel";
        internal const string MsmqSecureHashAlgorithm = "msmqSecureHashAlgorithm";
        internal const string MsmqTransportSectionName = "msmqTransport";
        internal const string MsmqTransportSecurity = "msmqTransportSecurity";
        internal const string MtomMessageEncodingSectionName = "mtomMessageEncoding";
        internal const string MultipleSiteBindingsEnabled = "multipleSiteBindingsEnabled";
        internal const string Name = "name";
        internal const string NamedPipeTransportSectionName = "namedPipeTransport";
        internal const string NegotiateServiceCredential = "negotiateServiceCredential";
        internal const string NegotiationTimeout = "negotiationTimeout";
        internal const string NetMsmqBindingCollectionElementName = "netMsmqBinding";
        internal const string NetNamedPipeBindingCollectionElementName = "netNamedPipeBinding";
        internal const string MexNamedPipeBindingCollectionElementName = "mexNamedPipeBinding";
        internal const string NetPeerTcpBindingCollectionElementName = "netPeerTcpBinding";
        internal const string NetTcpBindingCollectionElementName = "netTcpBinding";
        internal const string NetHttpBindingCollectionElementName = "netHttpBinding";
        internal const string NetHttpsBindingCollectionElementName = "netHttpsBinding";
        internal const string NodeQuota = "nodeQuota";
        internal const string None = "None";
        internal const string OleTransactions = "OleTransactions";
        internal const string OneWaySectionName = "oneWay";
        internal const string MexTcpBindingCollectionElementName = "mexTcpBinding";
        internal const string MexStandardEndpointCollectionElementName = "mexEndpoint";
        internal const string OpenTimeout = "openTimeout";
        internal const string Ordered = "ordered";
        internal const string PackageFullName = "packageFullName";
        internal const string PacketRoutable = "packetRoutable";
        internal const string Peer = "peer";
        internal const string PeerAuthentication = "peerAuthentication";
        internal const string PeerResolver = "resolver";
        internal const string PeerResolverType = "resolverType";
        internal const string PeerTransportCredentialType = "credentialType";
        internal const string PeerTransportSectionName = "peerTransport";
        internal const string PerformanceCounters = "performanceCounters";
        internal const string PipeSettings = "pipeSettings";
        internal const string PnrpPeerResolverSectionName = "pnrpPeerResolver";
        internal const string Policy12 = "Policy12";
        internal const string Policy15 = "Policy15";
        internal const string PolicyImporters = "policyImporters";
        internal const string PolicyType = "policyType";
        internal const string PolicyVersion = "policyVersion";
        internal const string Port = "port";
        internal const string PortSharingEnabled = "portSharingEnabled";
        internal const string Prefix = "prefix";
        internal const string PrincipalPermissionMode = "principalPermissionMode";
        internal const string PrivacyNoticeAt = "privacyNoticeAt";
        internal const string PrivacyNoticeSectionName = "privacyNoticeAt";
        internal const string PrivacyNoticeVersion = "privacyNoticeVersion";
        internal const string PropagateActivity = "propagateActivity";
        internal const string ProtectionLevel = "protectionLevel";
        internal const string ProtectTokens = "protectTokens";
        internal const string ProtocolMappingSectionName = "protocolMapping";        
        internal const string ProxyAddress = "proxyAddress";
        internal const string ProxyAuthenticationScheme = "proxyAuthenticationScheme";
        internal const string ProxyCredentialType = "proxyCredentialType";
        internal const string QueueTransferProtocol = "queueTransferProtocol";
        internal const string ReaderQuotas = "readerQuotas";
        internal const string Realm = "realm";
        internal const string ReceiveContextEnabled = "receiveContextEnabled";
        internal const string ReceiveErrorHandling = "receiveErrorHandling";
        internal const string ReceiveRetryCount = "receiveRetryCount";
        internal const string ReceiveTimeout = "receiveTimeout";
        internal const string ReconnectTransportOnFailure = "reconnectTransportOnFailure";
        internal const string ReferralPolicy = "referralPolicy";
        internal const string ReliableMessagingVersion = "reliableMessagingVersion";
        internal const string RelativeAddress = "relativeAddress";
        internal const string ReliableSession = "reliableSession";
        internal const string ReliableSessionSectionName = "reliableSession";
        internal const string Remove = "remove";
        internal const string ReplayCacheSize = "replayCacheSize";
        internal const string ReplayWindow = "replayWindow";
        internal const string RequestInitializationTimeout = "requestInitializationTimeout";
        internal const string RequireClientCertificate = "requireClientCertificate";
        internal const string RequireDerivedKeys = "requireDerivedKeys";
        internal const string RequireSecurityContextCancellation = "requireSecurityContextCancellation";
        internal const string RequireSignatureConfirmation = "requireSignatureConfirmation";
        internal const string RetryCycleDelay = "retryCycleDelay";
        internal const string RevocationMode = "revocationMode";
        internal const string RoleProviderName = "roleProviderName";
        internal const string Rsa = "rsa";
        internal const string SamlSerializerType = "samlSerializerType";
        internal const string Scheme = "scheme";
        internal const string ScopedCertificates = "scopedCertificates";
        internal const string SectionGroupName = "system.serviceModel";
        internal const string SecureConversationAuthentication = "secureConversationAuthentication";
        internal const string SecureConversationBootstrap = "secureConversationBootstrap";
        internal const string Security = "security";
        internal const string SecurityHeaderLayout = "securityHeaderLayout";
        internal const string SecuritySectionName = "security";
        internal const string SecurityStateEncoderType = "securityStateEncoderType";
        internal const string SendTimeout = "sendTimeout";
        internal const string SerializationFormat = "serializationFormat";
        internal const string Service = "service";
        internal const string ServiceActivations = "serviceActivations";
        internal const string ServiceAuthenticationManagerSectionName = "serviceAuthenticationManager";        
        internal const string ServiceAuthenticationManagerType = "serviceAuthenticationManagerType";        
        internal const string ServiceAuthorizationAuditLevel = "serviceAuthorizationAuditLevel";
        internal const string ServiceAuthorizationManagerType = "serviceAuthorizationManagerType";
        internal const string ServiceAuthorizationSectionName = "serviceAuthorization";
        internal const string ServiceBehaviors = "serviceBehaviors";
        internal const string ServiceCertificate = "serviceCertificate";
        internal const string ServiceCredentials = "serviceCredentials";
        internal const string ServiceDebugSectionName = "serviceDebug";
        internal const string ServiceHostingEnvironmentSectionName = "serviceHostingEnvironment";
        internal const string ServiceMetadataPublishingSectionName = "serviceMetadata";
        internal const string ServicePrincipalName = "servicePrincipalName";
        internal const string ServiceSecurityAuditSectionName = "serviceSecurityAudit";
        internal const string ServicesSectionName = "services";
        internal const string ServiceThrottlingSectionName = "serviceThrottling";
        internal const string ServiceTimeouts = "serviceTimeouts";
        internal const string Session = "Session";
        internal const string SessionIdAttribute = "sessionId";
        internal const string SessionKeyRenewalInterval = "sessionKeyRenewalInterval";
        internal const string SessionKeyRolloverInterval = "sessionKeyRolloverInterval";
        internal const string Soap11 = "Soap11";
        internal const string Soap11WSAddressing10 = "Soap11WSAddressing10";
        internal const string Soap11WSAddressingAugust2004 = "Soap11WSAddressingAugust2004";
        internal const string Soap12 = "Soap12";
        internal const string Soap12WSAddressing10 = "Soap12WSAddressing10";
        internal const string Soap12WSAddressingAugust2004 = "Soap12WSAddressingAugust2004";
        internal const string SslCertificateAuthentication = "sslCertificateAuthentication";
        internal const string SslProtocols = "sslProtocols";
        internal const string SslStreamSecuritySectionName = "sslStreamSecurity";
        internal const string StandardEndpoint = "standardEndpoint";
        internal const string StandardEndpointsSectionName = "standardEndpoints";        
        internal const string StoreLocation = "storeLocation";
        internal const string StoreName = "storeName";
        internal const string SubProtocol = "subProtocol";
        internal const string SupportInteractive = "supportInteractive";
        internal const string SuppressAuditFailure = "suppressAuditFailure";
        internal const string SynchronousReceiveSectionName = "synchronousReceive";
        internal const string DispatcherSynchronizationSectionName = "dispatcherSynchronization";
        internal const string TargetUri = "targetUri";
        internal const string TcpTransportSectionName = "tcpTransport";
        internal const string TeredoEnabled = "teredoEnabled";
        internal const string TextEncoding = "textEncoding";
        internal const string TextMessageEncodingSectionName = "textMessageEncoding";
        internal const string Timeouts = "timeouts";
        internal const string TimeSpanInfinite = "-00:00:00.001";
        internal const string TimeSpanOneTick = "00:00:00.0000001";
        internal const string TimeSpanZero = "00:00:00";
        internal const string TimestampValidityDuration = "timestampValidityDuration";
        internal const string TimeToLive = "timeToLive";
        internal const string TokenRequestParameters = "tokenRequestParameters";
        internal const string TokenType = "tokenType";
        internal const string TransactedBatchingSectionName = "transactedBatching";
        internal const string TransactionFlow = "transactionFlow";
        internal const string TransactionFlowSectionName = "transactionFlow";
        internal const string TransactionProtocol = "transactionProtocol";
        internal const string TransactionTimeout = "transactionTimeout";
        internal const string TransactionAllowWildcardAction = "allowWildcardAction";
        internal const string TransferMode = "transferMode";
        internal const string Transport = "transport";
        internal const string TransportConfigurationType = "transportConfigurationType";
        internal const string TransportUsage = "transportUsage";
        internal const string TripleDes = "TripleDes";
        internal const string TripleDesRsa15 = "TripleDesRsa15";
        internal const string TripleDesSha256 = "TripleDesSha256";
        internal const string TripleDesSha256Rsa15 = "TripleDesSha256Rsa15";
        internal const string TrustedStoreLocation = "trustedStoreLocation";
        internal const string Type = "type";
        internal const string TypeDefID = "typeDefID";
        internal const string TypeLibID = "typeLibID";
        internal const string TypeLibVersion = "typeLibVersion";
        internal const string UdpBindingCollectionElementName = "udpBinding";
        internal const string UdpBindingCollectionElementType = "System.ServiceModel.Configuration.UdpBindingCollectionElement, System.ServiceModel.Channels, Version=4.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35"; 
        internal const string UdpTransportElementType = "System.ServiceModel.Configuration.UdpTransportElement, System.ServiceModel.Channels, Version=4.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35";
        internal const string UdpTransportImporterType = "System.ServiceModel.Channels.UdpTransportImporter, System.ServiceModel.Channels, Version=4.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35";
        internal const string UdpTransportSectionName = "udpTransport";
        internal const string UnrecognizedPolicyAssertionSectionName = "unrecognizedPolicyAssertions";
        internal const string UnsafeConnectionNtlmAuthentication = "unsafeConnectionNtlmAuthentication";
        internal const string Url = "url";
        internal const string UseActiveDirectory = "useActiveDirectory";
        internal const string UseDefaultWebProxy = "useDefaultWebProxy";
        internal const string UseIdentityConfiguration = "useIdentityConfiguration";
        internal const string UseManagedPresentationSectionName = "useManagedPresentation";
        internal const string UseMsmqTracing = "useMsmqTracing";
        internal const string UserNameAuthentication = "userNameAuthentication";
        internal const string UserNamePasswordValidationMode = "userNamePasswordValidationMode";
        internal const string UserPrincipalName = "userPrincipalName";
        internal const string UseRequestHeadersForMetadataAddress = "useRequestHeadersForMetadataAddress";
        internal const string UseSourceJournal = "useSourceJournal";
        internal const string UseStrTransform = "useStrTransform";
        internal const string ValidityDuration = "validityDuration";
        internal const string Value = "value";
        internal const string Version = "version";
        internal const string ViaUri = "viaUri";
        internal const string WebSocketSettingsSectionName = "webSocketSettings";
        internal const string Windows = "windows";
        internal const string WindowsAuthentication = "windowsAuthentication";
        internal const string WindowsStreamSecuritySectionName = "windowsStreamSecurity";
        internal const string WmiProviderEnabled = "wmiProviderEnabled";
        internal const string WriteEncoding = "writeEncoding";
        internal const string WSAtomicTransactionOctober2004 = "WSAtomicTransactionOctober2004";
        internal const string WSAtomicTransaction11 = "WSAtomicTransaction11";        
        internal const string WsdlImporters = "wsdlImporters";
        internal const string WSDualHttpBindingCollectionElementName = "wsDualHttpBinding";
        internal const string WSFederationHttpBindingCollectionElementName = "wsFederationHttpBinding";
        internal const string WS2007FederationHttpBindingCollectionElementName = "ws2007FederationHttpBinding";
        internal const string WS2007HttpBindingCollectionElementName = "ws2007HttpBinding";
        internal const string WSHttpBindingCollectionElementName = "wsHttpBinding";
        internal const string WSReliableMessaging11 = "WSReliableMessaging11";
        internal const string WSReliableMessagingFebruary2005 = "WSReliableMessagingFebruary2005";
        internal const string WSSecurity10WSTrustFebruary2005WSSecureConversationFebruary2005WSSecurityPolicy11BasicSecurityProfile10 = "WSSecurity10WSTrustFebruary2005WSSecureConversationFebruary2005WSSecurityPolicy11BasicSecurityProfile10";
        internal const string WSSecurity11WSTrustFebruary2005WSSecureConversationFebruary2005WSSecurityPolicy11 = "WSSecurity11WSTrustFebruary2005WSSecureConversationFebruary2005WSSecurityPolicy11";
        internal const string WSSecurity11WSTrustFebruary2005WSSecureConversationFebruary2005WSSecurityPolicy11BasicSecurityProfile10 = "WSSecurity11WSTrustFebruary2005WSSecureConversationFebruary2005WSSecurityPolicy11BasicSecurityProfile10";
        internal const string WSSecurity10WSTrust13WSSecureConversation13WSSecurityPolicy12BasicSecurityProfile10 = "WSSecurity10WSTrust13WSSecureConversation13WSSecurityPolicy12BasicSecurityProfile10";
        internal const string WSSecurity11WSTrust13WSSecureConversation13WSSecurityPolicy12 = "WSSecurity11WSTrust13WSSecureConversation13WSSecurityPolicy12";
        internal const string WSSecurity11WSTrust13WSSecureConversation13WSSecurityPolicy12BasicSecurityProfile10 = "WSSecurity11WSTrust13WSSecureConversation13WSSecurityPolicy12BasicSecurityProfile10";
        internal const string X509FindType = "x509FindType";
        internal const string XmlElement = "xmlElement";

        internal static string BehaviorsSectionPath
        {
            get { return ConfigurationHelpers.GetSectionPath(ConfigurationStrings.BehaviorsSectionName); }
        }

        internal static string BindingsSectionGroupPath
        {
            get { return ConfigurationHelpers.GetSectionPath(ConfigurationStrings.BindingsSectionGroupName); }
        }

        internal static string ClientSectionPath
        {
            get { return ConfigurationHelpers.GetSectionPath(ConfigurationStrings.ClientSectionName); }
        }

        internal static string ComContractsSectionPath
        {
            get { return ConfigurationHelpers.GetSectionPath(ConfigurationStrings.ComContractsSectionName); }
        }

        internal static string CommonBehaviorsSectionPath
        {
            get { return ConfigurationHelpers.GetSectionPath(ConfigurationStrings.CommonBehaviorsSectionName); }
        }

        internal static string DiagnosticSectionPath
        {
            get { return ConfigurationHelpers.GetSectionPath(ConfigurationStrings.DiagnosticSectionName); }
        }

        internal static string ExtensionsSectionPath
        {
            get { return ConfigurationHelpers.GetSectionPath(ConfigurationStrings.Extensions); }
        }

        internal static string ProtocolMappingSectionPath
        {
            get { return ConfigurationHelpers.GetSectionPath(ConfigurationStrings.ProtocolMappingSectionName); }
        }

        internal static string ServiceHostingEnvironmentSectionPath
        {
            get { return ConfigurationHelpers.GetSectionPath(ConfigurationStrings.ServiceHostingEnvironmentSectionName); }
        }

        internal static string ServicesSectionPath
        {
            get { return ConfigurationHelpers.GetSectionPath(ConfigurationStrings.ServicesSectionName); }
        }

        internal static string StandardEndpointsSectionPath
        {
            get { return ConfigurationHelpers.GetSectionPath(ConfigurationStrings.StandardEndpointsSectionName); }
        }
    }
}
