// Generated by CoffeeScript 1.12.5
'use strict';
var DEBUG, baseStream, through;

baseStream = require('stream');

through = require('through2');

DEBUG = process.env.NODE_ENV === 'development';


/*
 * Taps into the pipeline and allows user to easily route data through
 * another stream or change content.
 */

module.exports = function(lambda) {
  var modifyFile, utils;
  utils = function(tapStream, file) {
    return {

      /*
       * Routes through another stream. The filter must not be
       * created. This will create the filter as needed.
       *
       * @param filter {stream}
       * @param args {Array} Array containg arguments to apply to filter.
       *
       * @example
       *   t.through coffee, [{bare: true}]
       */
      through: function(filter, args) {
        var stream;
        if (DEBUG) {
          if (!Array.isArray(args)) {
            throw new TypeError("Args must be an array to `apply` to the filter");
          }
        }
        stream = filter.apply(null, args);
        stream.on("error", function(err) {
          return tapStream.emit("error", err);
        });
        stream.write(file);
        return stream;
      }
    };
  };
  modifyFile = function(file, enc, cb) {
    var data, inst, next, obj;
    inst = {
      file: file
    };
    obj = lambda(inst.file, utils(this, inst.file), inst);
    next = (function(_this) {
      return function() {
        _this.push(file);
        return cb();
      };
    })(this);
    if (obj instanceof baseStream && !obj._readableState.ended) {
      obj.on('end', next);
      return obj.on('data', data = function() {
        obj.removeListener('end', next);
        obj.removeListener('data', data);
        return next();
      });
    } else {
      return next();
    }
  };
  return through.obj(modifyFile, function(cb) {
    return cb();
  });
};

//# sourceMappingURL=tap.js.map
