if (typeof T === 'undefined') require('../setup');

T('toFraction', function () {

  function t(expected, n, maxDenominator) {
    T.assertEqual(expected, new Decimal(n).toFraction(maxDenominator).toString());
  }

  function tx(fn, msg) {
    T.assertException(fn, msg);
  }

  Decimal.config({
    precision: 20,
    rounding: 4,
    toExpNeg: -9e15,
    toExpPos: 9e15,
    minE: -9e15,
    maxE: 9e15
  });

  t('1,10', '0.1');
  t('-1,10', '-0.1');
  t('1,100', '0.01');
  t('-1,100', '-0.01');
  t('1,1000', '0.001');
  t('-1,1000', '-0.001');
  t('54301793,100000', '543.017930');
  t('-484693350148251574449,1000000000000', '-484693350.1482515744490');
  t('-200111074540568980159529,25000000000000', '-8004442981.622759206381160');
  t('-5965700213104829,1000000000000000', '-5.965700213104829');
  t('-5124110209739113904928179,100000000000000', '-51241102097.39113904928179');
  t('-1655017182533520595664837541,200000000000000', '-8275085912667.602978324187705');
  t('-5,8', '-0.625');
  t('-42394617,200000000', '-0.211973085');
  t('-147453708173963291829,2500000000000000000', '-58.9814832695853167316');
  t('-2733,100', '-27.33');
  t('0,1', '0.0');
  t('-2599897551866392365731491641,10000000000', '-259989755186639236.5731491641');
  t('-9326331230765073371,5000000000000000', '-1865.2662461530146742');
  t('-2483061,10000', '-248.3061');
  t('-92864854181,10000000', '-9286.4854181');
  t('-758516850228215193,100000000000000000', '-7.5851685022821519300');
  t('-19570408085559589,20000000000', '-978520.404277979450');
  t('-211,100', '-2.11');
  t('-4789334439841,10000000000', '-478.9334439841');
  t('2978320663077,10000000000000', '0.2978320663077');
  t('-1221,25', '-48.84');
  t('12456254053601331,5000000000000', '2491.25081072026620');
  t('31969983,100000', '319.69983');
  t('31852901149,400000000000', '0.0796322528725');
  t('-456674099059,10000000000', '-45.6674099059');
  t('-361907787,5000000', '-72.3815574');
  t('-6521,100', '-65.21');

  t('5,1', '5.1582612935891', '3');
  t('14645,1797', '8.14969395596340', '4682');
  t('350921,81990', '4.28004634702', '82418');
  t('923754598113149102531799372705758450549,100000000', '9237545981131491025317993727057.58450549');
  t('23665467152910525354658972818814752082,49447', '478602688796297558085606261629921.9787246948249979233505266225354557384', '57466');
  t('12401124714135748113774134798397,2', '6200562357067874056887067399198.66971421701', '2');
  t('5747456325233732815460960864983211610837351385715799969377,100000000000000000000000000000', '57474563252337328154609608649.83211610837351385715799969377');
  t('4744,61', '77.7705294446793765233206385561288346447', '86');
  t('230406626515463254737498487452583023685806305331639,100000000000000000000000000', '2304066265154632547374984.87452583023685806305331639');
  t('8452816572418429518944119647,5000', '1690563314483685903788823.9294');
  t('48239499471878294436129777581,10000000000000000', '4823949947187.82944361297775810');
  t('45172634468362586403517152343110493066053,74300', '607976237797612199239800166125309462.530995962577562', '89241');
  t('245629009658126699398365025147112883705717,1250000000000000000000000000000', '196503207726.5013595186920201176903069645736');
  t('19575206081236584421562241755643406299,500000000000000000000000000000000000', '39.150412162473168843124483511286812598');
  t('124335953351113119989680198250484096210027176457861877,20000000000000000000000', '6216797667555655999484009912524.20481050135882289309385');
  t('62359286968916651021817694022163661098254437249041482587,100000000000000000000000000', '623592869689166510218176940221.63661098254437249041482587');
  t('1406253392003122107350210973,50', '28125067840062442147004219.46', '90');
  t('736337826,1', '736337826.0', '1');
  t('2294354321,3019', '759971.62007285863174441704674479534091075', '5946');
  t('342555042697121035185957633789368546657896318423873,50000000000000000000000000', '6851100853942420703719152.67578737093315792636847746');
  t('3511582655801640591,52', '67530435688493088.2885316751682999639624370547426320', '73');
  t('1190687310674838338273481559,50000', '23813746213496766765469.63118');
  t('31747884008318370382077439489,40', '793697100207959259551935987.225181146039', '45');
  t('39451289109544785156061546711681,59993', '657598204949657212609163514.271348320970259397527780637349273932', '61325');
  t('3859539118592118171061,65', '59377524901417202631.7076617756627530296590420377861', '248');
  t('2529860848590369124121129138,36761', '68819152052184900414056.449443703377131320899467509', '59208');
  t('17331073,2', '8665536.3781112033855216846406980971689', '2');
  t('11088761069693879,25000', '443550442787.75516');
  t('37298162459148947522489,474', '78688106453900733169.80801275320205353359142143262532', '517');
  t('12411782390212011049587005051032466579057,100000000000000000000000000000000000000', '124.11782390212011049587005051032466579057');
  t('288377889236302421024476469650301879883847,50000000000000000000000', '5767557784726048420.48952939300603759767694');
  t('64269805556832147,1', '64269805556832146.8921574533060466484388410550211', '2');
  t('1019428223041680221,2', '509714111520840110.44623631764611004359625363775303233110', '2');

  t('-535739501101785482356483511,20000000000000000', '-26786975055.08927411782417555');
  t('-2189002367733133,500000000000000', '-4.378004735466266');
  t('-4135862533810979636019397675000,1', '-4.135862533810979636019397675E+30');
  t('-14984699501047789,1000000000000', '-14984.699501047789');
  t('-2644213426631746862661931503,10000', '-264421342663174686266193.1503');
  t('-2092299259157497414090361017,5', '-418459851831499482818072203.4');
  t('-77,100', '-0.77');
  t('-54276151887,1000000000', '-54.276151887');
  t('-389683579126928886377631531,2500000000000000', '-155873431650.7715545510526124');
  t('46789726161807116524384304297700033991397937633588752307,10000000000000000000000000000000000000', '4678972616180711652.4384304297700033991397937633588752307');
  t('-9196858034762943045297291137,10000', '-919685803476294304529729.1137');
  t('-12757819,25000', '-510.31276');
  t('-2751580109664699528322719473,50', '-55031602193293990566454389.46');
  t('-1397067073903866232334961397,200000000000', '-6985335369519331.161674806985');
  t('-10827300142961420614583582960000000000000000000000000000000000000000000,1', '-1.082730014296142061458358296E+70');
  t('488478745829,50000000', '9769.57491658');
  t('-2319703638146144907642415179,250000000000000000000000000', '-9.278814552584579630569660716');
  t('8199609,1000000', '8.199609');
  t('-1132520281920903148966859641,50000000000', '-22650405638418062.97933719282');
  t('-9435372448691264711,10000000000', '-943537244.8691264711');
  t('-5430432705270926972283794348000000000000000,1', '-5.430432705270926972283794348E+42');
  t('2547106921,10000000', '254.7106921');
  t('-2013361060932518973304030049,250000000000', '-8053444243730075.893216120196');
  t('-299071373209294751127694543,4000', '-74767843302323687781923.63575');
  t('161261,5000', '32.2522');
  t('-2149015945426180798371334522,1', '-2149015945426180798371334522');
  t('-1219052557726696173105236523,1250000000000000', '-975242046181.3569384841892184');
  t('-6635702255618430700913831019,1000000', '-6635702255618430700913.831019');
  t('-4229092410987972953057006873,100', '-42290924109879729530570068.73');
  t('800876757958087347097942687332875742929708200305858327085977609,100000000000000000000000000000000000', '8008767579580873470979426873.32875742929708200305858327085977609');
  t('-2665484396670548074136945193,50', '-53309687933410961482738903.86');

  t('30396,38195', '0.79581097', '74409');
  t('2125057574,3289', '646110.5424140842277760913716223149175043516912866283522989430448583852673477181054', '4314');
  t('18251,16', '1140.688086121119279582816178812726653910', '37');
  t('61348765027081784476232889631422618917241085602257,2', '30674382513540892238116444815711309458620542801128.559859020834676491532682063017825303001913079937413732204504474950978211332225018371420', '2');
  t('238354711696434965227174225040046402291933791409568617910,25981', '9174193129457486826033417691391647830796882006449660.0558100148468970808679278895365813792370050009058167954469', '61710');
  t('7355967799241738309628763754835483150582416687842544374137,8', '919495974905217288703595469354435393822802085980318046767.1338999658963927824509929378965804777221331548975659545056488845295998946309871474144010438', '9');
  t('1125354937387110207464744146511518,247481', '4547237716782743755943866989.8356560705677241346146759866583370949', '863202');
  t('58400904696,8737', '6684320.09797413893379904985072385250774250364224704531308514779353223', '14426');
  t('4765998700799,481932', '9889359.28886025414277', '551989');
  t('84446319074008288318841993796319916,1', '84446319074008288318841993796319916.4290214679797552828327089099139280188', '1');
  t('208579935771852505416338,29', '7192411578339741566080.621098672624218880520368888346887640903578755437931806539999680994582938', '38');
  t('1006862373895650813218257996159822111779222738385202718573234201031,335', '3005559325061644218561964167641260035161858920552843936039505077.70447752609278095294701366298104650604976387611568135143174113323780682', '7063');
  t('12180512204,290477', '41932.7940043445804168810482554121918927813650259', '895566');
  t('972851014381591,18170', '53541607836.080957621939096312239677792878740188648258030024875', '31555');
  t('383576424003665,59', '6501295322096.01707059843465672720153308', '88');
  t('456059695649,731697', '623290.372447884850674344473049816049238992052574671', '770999');
  t('1,2', '0.5716202415873544262986953173753852278285193332218646822626651', '2');
  t('13802410789886736953383903846755867001633124596437299605748175709981308048573814,2523', '5470634478750193005701111314607953627282253109963257869896225013864965536493.782798186996737913044082377221550214034629772236938011947896897722075720890727218714', '2580');
  t('1720546690653497270570006270472130851,1', '1720546690653497270570006270472130851.14006845543964920673232647491053082791301585407937041734157349507526701334664232654756777642845206', '1');
  t('275492732803212658371830121443811803,6273', '43917221872024973437243762385431.5005579559793624838126175850466341579997661657132448932942532299', '11453');
  t('88013352536654826423613115136850148349568967,93', '946380134802740069071108764912367186554505.02139414761736578247940104106009403877307019264568966335689948628094', '100');
  t('0,1', '0.16188799510329961', '2');
  t('31257777609885493076027897164441747647216000811363789460,63', '496155200156912588508379320070503930908190489069266499.364683462978985476107209780379101750930177884309470340386147403736530', '73');

  t('-2991910323532143367251432461,50000000', '-59838206470642867345.02864922');
  t('-972745200863972039012044288500000000000000000000000000000,1', '-9.727452008639720390120442885E+56');
  t('-759,100', '-7.59');
  t('-27827258151452494934863201,100', '-278272581514524949348632.0100');
  t('-284626800809,50000000', '-5692.53601618');
  t('-74421663208247269188483431,80000000000000000', '-930270790.1030908648560428875');
  t('-1082016448333999416859837516000,1', '-1.082016448333999416859837516E+30');
  t('-21,25', '-0.84');
  t('-67246554173689300336047211,8000000', '-8405819271711162542.005901375');
  t('-2196812392790282979771359770000000000000,1', '-2.196812392790282979771359770E+39');
  t('-93367638440645772883402889310000,1', '-9.336763844064577288340288931E+31');
  t('-35989199713272470893896397640000000000,1', '-3.598919971327247089389639764E+37');
  t('-21641213684333939876179569040,1', '-2.164121368433393987617956904E+28');
  t('-91309127692139566014327039220000000000000000000000000000000000000,1', '-9.130912769213956601432703922E+64');
  t('-1991444477322661912100056959,50000000000', '-39828889546453238.24200113918');
  t('-553515865616749148505592781,10000000000000000000000000', '-55.35158656167491485055927810');
  t('-2736653830100392487693621031,500000', '-5473307660200784975387.242062');
  t('-1434910778309587281399577109,5000000000', '-286982155661917456.2799154218');

  t('7325643,10000000', '0.7325643');
  t('8129753468709152191211051855224273832281,100000000000000000000000', '81297534687091521.91211051855224273832281');
  t('26846080372036394639591396,6672793', '4023214922452471497.25630571786057289667012386513324609', '72150416');
  t('151169465630612379481675652813336817561189321,200000000000000000000000000000000000000', '755847.328153061897408378264066684087805946605');
  t('48650152878444478499756261104359,1000000', '48650152878444478499756261.104359');
  t('310291026486294288245548,3136069', '98942665638509321.1423434879780971949357099446690852', '4194429');
  t('281148949800335203180214,28247', '9953232194581201656.11264913171363754779711915', '40003');
  t('8070991737,10', '807099173.7');
  t('2105837647496797835243555428994974365746550495259,2500000000000000000000000', '842335058998719134097422.1715979897462986201981036');
  t('7050549406715449007260719040610995681,100000000000000000000', '70505494067154490.07260719040610995681');
  t('1485521639981158765714509531187624755829128849,100000000000000000000000', '14855216399811587657145.09531187624755829128849');
  t('179195624045698698709602380291841534992963,397', '451374367873296470301265441541162556657.33752912', '654');
  t('60786881043136,81', '750455321520.1975303545477874468301224681956212', '6955');
  t('54350058946186575767248586,111', '489640170686365547452689.9639497075875189553277274425649764720088', '136');
  t('207448313353211937938706154109749,2500000000000000000000000', '82979325.34128477517548246164389960');
  t('18637328030895697373,20000000000', '931866401.54478486865');
  t('77127230808472816894238711,10000000000000000', '7712723080.8472816894238711');
  t('29126173556928305215214880165709856062,7', '4160881936704043602173554309387122294.5709328', '7');
  t('43333053556734019842,614489', '70518843391393.531604308619475952242596538499476346', '675048');
  t('53377793855957,559250504', '95445.231562915140439462747444833608100863907', '1363996915');
  t('347448038601,1158528605', '299.9045833667611513140004251012084', '3206002475');

  t('4723559025392992686163722415183139,100000000000000000000', '47235590253929.92686163722415183139');
  t('178091379773085237300450763077988415217238,1811184275', '98328691470714782625004163686209.3533896422549273776361277', '1811232885');
  t('805514724831305204420874185699445105715750883,100000000000000', '8055147248313052044208741856994.45105715750883');
  t('65819,6849', '9.610016056348', '8529');
  t('319168767950612554460346534967,625000000000000', '510670028720980.0871365544559472');
  t('5710296907,88986', '64170.7336772078034895641687140263', '92775');
  t('556588363946502498333308725135986051213680185539426551525214239244852201,500000000000000000000000000000000000000', '1113176727893004996666617450271972.102427360371078853103050428478489704402');
  t('20826873980146981695459788919411033,31250000', '666459967364703414254713245.421153056');
  t('2499361049528080561202511540068978284974386343138634241,1000000000000000000000000000000000000', '2499361049528080561.202511540068978284974386343138634241');
  t('418298807255269058527019236340986131039447727889611856636829077,50000000000000000000000000000000000', '8365976145105381170540384726.81972262078895455779223713273658154');
  t('6913324275323537689724784638569909,100000000000000', '69133242753235376897.24784638569909');
  t('13962383460375585294405129665013837633,2000', '6981191730187792647202564832506918.8165');

  t('2469,20', '123.45');
  t('2469,20', '123.45', null);
  t('2469,20', '123.45', '2.1e1');
  t('1111,9',  '123.45', new Decimal(10));
  t('2469,20', '123.45', new Decimal('123e399'));
  t('2469,20', '123.45', new Decimal('123'));

  tx(function () {new Decimal('123.45').toFraction('')}, ".toFraction('')");
  tx(function () {new Decimal('123.45').toFraction(' ')}, ".toFraction(' ')");
  tx(function () {new Decimal('123.45').toFraction('\t')}, ".toFraction('\t')");
  tx(function () {new Decimal('123.45').toFraction(NaN)}, ".toFraction(NaN)");
  tx(function () {new Decimal('123.45').toFraction('NaN')}, ".toFraction('NaN')");
  tx(function () {new Decimal('123.45').toFraction('hello')}, ".toFraction('hello')");
  tx(function () {new Decimal('123.45').toFraction([])}, ".toFraction([])");
  tx(function () {new Decimal('123.45').toFraction({})}, ".toFraction({})");
  tx(function () {new Decimal('123.45').toFraction(true)}, ".toFraction(true)");
  tx(function () {new Decimal('123.45').toFraction(false)}, ".toFraction(false)");
  tx(function () {new Decimal('123.45').toFraction(function (){})}, ".toFraction(function (){})");
  tx(function () {new Decimal('123.45').toFraction(new Number)}, ".toFraction(new Number)");
  tx(function () {new Decimal('123.45').toFraction(new String)}, ".toFraction(new String)");
  tx(function () {new Decimal('123.45').toFraction(new Date)},".toFraction(new Date)");
  tx(function () {new Decimal('123.45').toFraction(new RegExp)}, ".toFraction(new RegExp)");

  tx(function () {new Decimal('123.45').toFraction(7.5)}, ".toFraction(7.5)");
  tx(function () {new Decimal('123.45').toFraction(new Decimal('225.435435'))}, ".toFraction(new Decimal('225.435435'))");
  tx(function () {new Decimal('123.45').toFraction(0)}, ".toFraction(0)");
  tx(function () {new Decimal('123.45').toFraction('0.99')}, ".toFraction('0.99')");
  tx(function () {new Decimal('123.45').toFraction(-1)}, ".toFraction(-1)");
  tx(function () {new Decimal('123.45').toFraction(-23)}, ".toFraction(-23)");
  tx(function () {new Decimal('123.45').toFraction(Infinity)}, ".toFraction(Infinity)");
  tx(function () {new Decimal('123.45').toFraction('-Infinity')}, ".toFraction('-Infinity')");
});
