# Observable object #

The Observable object represents a push based collection.

The Observer and Observable interfaces provide a generalized mechanism for push-based notification, also known as the observer design pattern. The Observable object represents the object that sends notifications (the provider); the Observer object represents the class that receives them (the observer).

## `Observable Methods`
- [`amb`](operators/amb.md)
- [`case`](operators/case.md)
- [`catch`](operators/catch.md)
- [`combineLatest`](operators/combinelatest.md)
- [`concat`](operators/concat.md)
- [`create`](operators/create.md)
- [`defer`](operators/defer.md)
- [`empty`](operators/empty.md)
- [`for`](operators/for.md)
- [`forkJoin`](operators/forkjoin.md)
- [`from`](operators/from.md)
- [`fromCallback`](operators/fromcallback.md)
- [`fromEvent`](operators/fromevent.md)
- [`fromEventPattern`](operators/fromeventpattern.md)
- [`fromNodeCallback`](operators/fromnodecallback.md)
- [`fromPromise`](operators/frompromise.md)
- [`generate`](operators/generate.md)
- [`generateWithAbsoluteTime`](operators/generatewithabsolutetime.md)
- [`generateWithRelativeTime`](operators/generatewithrelativetime.md)
- [`if`](operators/if.md)
- [`interval`](operators/interval.md)
- [`just`](operators/return.md)
- [`merge`](operators/merge.md)
- [`mergeDelayError`](operators/mergedelayerror.md)
- [`never`](operators/never.md)
- [`of`](operators/of.md)
- [`ofWithScheduler`](operators/ofwithscheduler.md)
- [`onErrorResumeNext`](operators/onerrorresumenext.md)
- [`pairs`](operators/pairs.md)
- [`range`](operators/range.md)
- [`repeat`](operators/repeat.md)
- [`return`](operators/return.md)
- [`spawn`](operators/spawn.md)
- [`start`](operators/start.md)
- [`startAsync`](operators/startasync.md)
- [`throw`](operators/throw.md)
- [`timer`](operators/timer.md)
- [`toAsync`](operators/toasync.md)
- [`using`](operators/using.md)
- [`when`](operators/when.md)
- [`while`](operators/while.md)
- [`wrap`](operators/wrap.md)
- [`zip`](operators/zip.md)

<!-- div -->

<!-- div -->

## `Observable Instance Methods`
- [`amb`](operators/ambproto.md)
- [`and`](operators/and.md)
- [`asObservable`](operators/asobservable.md)
- [`average`](operators/average.md)
- [`buffer`](operators/buffer.md)
- [`bufferWithCount`](operators/bufferwithcount.md)
- [`bufferWithTime`](operators/bufferwithtime.md)
- [`bufferWithTimeOrCount`](operators/bufferwithtimeorcount.md)
- [`catch`](operators/catchproto.md)
- [`combineLatest`](operators/combinelatestproto.md)
- [`concat`](operators/concatproto.md)
- [`concatAll`](operators/concatall.md)
- [`concatMap`](operators/concatmap.md)
- [`concatMapObserver`](operators/concatmapobserver.md)
- [`connect`](operators/connect.md)
- [`controlled`](operators/controlled.md)
- [`count`](operators/count.md)
- [`debounce`](operators/debounce.md)
- [`defaultIfEmpty`](operators/defaultifempty.md)
- [`delay`](operators/delay.md)
- [`delaySubscription`](operators/delaysubscription.md)
- [`dematerialize`](operators/dematerialize.md)
- [`distinct`](operators/distinct.md)
- [`distinctUntilChanged`](operators/distinctuntilchanged.md)
- [`do`](operators/do.md)
- [`doOnCompleted`](operators/dooncompleted.md)
- [`doOnError`](operators/doonerror.md)
- [`doOnNext`](operators/doonnext.md)
- [`doWhile`](operators/dowhile.md)
- [`elementAt`](operators/elementat.md)
- [`every`](operators/every.md)
- [`expand`](operators/expand.md)
- [`extend`](operators/manyselect.md)
- [`filter`](operators/where.md)
- [`finally`](operators/finally.md)
- [`find`](operators/find.md)
- [`findIndex`](operators/findindex.md)
- [`first`](operators/first.md)
- [`flatMap`](operators/selectmany.md)
- [`flatMapFirst`](operators/flatmapfirst.md)
- [`flatMapLatest`](operators/flatmaplatest.md)
- [`flatMapObserver`](operators/flatmapobserver.md)
- [`flatMapWithMaxConcurrent`](operators/flatmapwithmaxconcurrent.md)
- [`forkJoin`](operators/forkjoinproto.md)
- [`groupBy`](operators/groupby.md)
- [`groupByUntil`](operators/groupbyuntil.md)
- [`groupJoin`](operators/groupjoin.md)
- [`ignoreElements`](operators/ignoreelements.md)
- [`includes`](operators/includes.md)
- [`indexOf`](operators/indexof.md)
- [`isEmpty`](operators/isempty.md)
- [`join`](operators/join.md)
- [`jortSort`](operators/jortsort.md)
- [`jortSortUntil`](operators/jortsortuntil.md)
- [`last`](operators/last.md)
- [`lastIndexOf`](operators/lastindexof.md)
- [`let`](operators/let.md)
- [`manySelect`](operators/manyselect.md)
- [`map`](operators/select.md)
- [`max`](operators/max.md)
- [`maxBy`](operators/maxby.md)
- [`merge`](operators/mergeproto.md)
- [`mergeAll`](operators/mergeall.md)
- [`min`](operators/min.md)
- [`minBy`](operators/minby.md)
- [`multicast`](operators/multicast.md)
- [`observeOn`](operators/observeon.md)
- [`onErrorResumeNext`](operators/onerrorresumenextproto.md)
- [`pairwise`](operators/pairwise.md)
- [`partition`](operators/partition.md)
- [`pausable`](operators/pausable.md)
- [`pausableBuffered`](operators/pausablebuffered.md)
- [`pluck`](operators/pluck.md)
- [`publish`](operators/publish.md)
- [`publishLast`](operators/publishlast.md)
- [`publishValue`](operators/publishvalue.md)
- [`reduce`](operators/reduce.md)
- [`refCount`](operators/refcount.md)
- [`repeat`](operators/repeatproto.md)
- [`repeatWhen`](operators/repeatwhen.md)
- [`replay`](operators/replay.md)
- [`retry`](operators/retry.md)
- [`retryWhen`](operators/retrywhen.md)
- [`sample`](operators/sample.md)
- [`scan`](operators/scan.md)
- [`select`](operators/select.md)
- [`selectConcat`](operators/concatmap.md)
- [`selectConcatObserver`](operators/concatmapobserver.md)
- [`selectMany`](operators/selectmany.md)
- [`selectManyObserver`](operators/flatmapobserver.md)
- [`sequenceEqual`](operators/sequenceequal.md)
- [`share`](operators/share.md)
- [`shareReplay`](operators/sharereplay.md)
- [`shareValue`](operators/sharevalue.md)
- [`single`](operators/single.md)
- [`singleInstance`](operators/singleinstance.md)
- [`skip`](operators/skip.md)
- [`skipLast`](operators/skiplast.md)
- [`skipLastWithTime`](operators/skiplastwithtime.md)
- [`skipUntil`](operators/skipuntil.md)
- [`skipUntilWithTime`](operators/skipuntilwithtime.md)
- [`skipWhile`](operators/skipwhile.md)
- [`slice`](operators/slice.md)
- [`some`](operators/some.md)
- [`startWith`](operators/startwith.md)
- [`subscribe | forEach`](operators/subscribe.md)
- [`subscribeOn`](operators/subscribeon.md)
- [`subscribeOnCompleted`](operators/subscribeoncompleted.md)
- [`subscribeOnError`](operators/subscribeonerror.md)
- [`subscribeOnNext`](operators/subscribeonnext.md)
- [`sum`](operators/sum.md)
- [`switch | switchLatest`](operators/switch.md)
- [`switchFirst`](operators/switchfirst.md)
- [`take`](operators/take.md)
- [`takeLast`](operators/takelast.md)
- [`takeLastBuffer`](operators/takelastbuffer.md)
- [`takeLastBufferWithTime`](operators/takelastbufferwithtime.md)
- [`takeLastWithTime`](operators/takelastwithtime.md)
- [`takeUntil`](operators/takeuntil.md)
- [`takeUntilWithTime`](operators/takeuntilwithtime.md)
- [`takeWhile`](operators/takewhile.md)
- [`tap`](operators/do.md)
- [`tapOnCompleted`](operators/dooncompleted.md)
- [`tapOnError`](operators/doonerror.md)
- [`tapOnNext`](operators/doonnext.md)
- [`throttle`](operators/throttle.md)
- [`timeInterval`](operators/timeinterval.md)
- [`timeout`](operators/timeout.md)
- [`timeoutWithSelector`](operators/timeoutwithselector.md)
- [`timestamp`](operators/timestamp.md)
- [`toArray`](operators/toarray.md)
- [`toMap`](operators/tomap.md)
- [`toPromise`](operators/topromise.md)
- [`toSet`](operators/toset.md)
- [`transduce`](operators/transduce.md)
- [`where`](operators/where.md)
- [`window`](operators/window.md)
- [`windowWithCount`](operators/windowwithcount.md)
- [`windowWithTime`](operators/windowwithtime.md)
- [`windowWithTimeOrCount`](operators/windowwithtimeorcount.md)
- [`withLatestFrom`](operators/withlatestfrom.md)
- [`zip`](operators/zipproto.md)
- [`zipIterable`](operators/zipiterable.md)
