/*---------------------------------------------------------*\
| QMKKeycodes.cpp                                           |
|                                                           |
|   List of QMK keycode values                              |
|                                                           |
|   Adam Honse <calcprogrammer1@gmail.com)      07 Oct 2025 |
|                                                           |
|   This file is part of the OpenRGB project                |
|   SPDX-License-Identifier: GPL-2.0-or-later               |
\*---------------------------------------------------------*/

#include "QMKKeycodes.h"
#include "RGBControllerKeyNames.h"

std::map<qmk_keycode, std::string> qmk_keynames =
{
    { QMK_KC_NO,                KEY_EN_UNUSED               },
    { QMK_KC_TRANSPARENT,       KEY_EN_RIGHT_FUNCTION       },
    { QMK_KC_A,                 KEY_EN_A                    },
    { QMK_KC_B,                 KEY_EN_B                    },
    { QMK_KC_C,                 KEY_EN_C                    },
    { QMK_KC_D,                 KEY_EN_D                    },
    { QMK_KC_E,                 KEY_EN_E                    },
    { QMK_KC_F,                 KEY_EN_F                    },
    { QMK_KC_G,                 KEY_EN_G                    },
    { QMK_KC_H,                 KEY_EN_H                    },
    { QMK_KC_I,                 KEY_EN_I                    },
    { QMK_KC_J,                 KEY_EN_J                    },
    { QMK_KC_K,                 KEY_EN_K                    },
    { QMK_KC_L,                 KEY_EN_L                    },
    { QMK_KC_M,                 KEY_EN_M                    },
    { QMK_KC_N,                 KEY_EN_N                    },
    { QMK_KC_O,                 KEY_EN_O                    },
    { QMK_KC_P,                 KEY_EN_P                    },
    { QMK_KC_Q,                 KEY_EN_Q                    },
    { QMK_KC_R,                 KEY_EN_R                    },
    { QMK_KC_S,                 KEY_EN_S                    },
    { QMK_KC_T,                 KEY_EN_T                    },
    { QMK_KC_U,                 KEY_EN_U                    },
    { QMK_KC_V,                 KEY_EN_V                    },
    { QMK_KC_W,                 KEY_EN_W                    },
    { QMK_KC_X,                 KEY_EN_X                    },
    { QMK_KC_Y,                 KEY_EN_Y                    },
    { QMK_KC_Z,                 KEY_EN_Z                    },
    { QMK_KC_1,                 KEY_EN_1                    },
    { QMK_KC_2,                 KEY_EN_2                    },
    { QMK_KC_3,                 KEY_EN_3                    },
    { QMK_KC_4,                 KEY_EN_4                    },
    { QMK_KC_5,                 KEY_EN_5                    },
    { QMK_KC_6,                 KEY_EN_6                    },
    { QMK_KC_7,                 KEY_EN_7                    },
    { QMK_KC_8,                 KEY_EN_8                    },
    { QMK_KC_9,                 KEY_EN_9                    },
    { QMK_KC_0,                 KEY_EN_0                    },
    { QMK_KC_ENTER,             KEY_EN_ANSI_ENTER           },
    { QMK_KC_ESCAPE,            KEY_EN_ESCAPE               },
    { QMK_KC_BACKSPACE,         KEY_EN_BACKSPACE            },
    { QMK_KC_TAB,               KEY_EN_TAB                  },
    { QMK_KC_SPACE,             KEY_EN_SPACE                },
    { QMK_KC_MINUS,             KEY_EN_MINUS                },
    { QMK_KC_EQUAL,             KEY_EN_EQUALS               },
    { QMK_KC_LEFT_BRACKET,      KEY_EN_LEFT_BRACKET         },
    { QMK_KC_RIGHT_BRACKET,     KEY_EN_RIGHT_BRACKET        },
    { QMK_KC_BACKSLASH,         KEY_EN_ANSI_BACK_SLASH      },
    { QMK_KC_NONUS_HASH,        KEY_EN_POUND                },
    { QMK_KC_SEMICOLON,         KEY_EN_SEMICOLON            },
    { QMK_KC_QUOTE,             KEY_EN_QUOTE                },
    { QMK_KC_GRAVE,             KEY_EN_BACK_TICK            },
    { QMK_KC_COMMA,             KEY_EN_COMMA                },
    { QMK_KC_DOT,               KEY_EN_PERIOD               },
    { QMK_KC_SLASH,             KEY_EN_FORWARD_SLASH        },
    { QMK_KC_CAPS_LOCK,         KEY_EN_CAPS_LOCK            },
    { QMK_KC_F1,                KEY_EN_F1                   },
    { QMK_KC_F2,                KEY_EN_F2                   },
    { QMK_KC_F3,                KEY_EN_F3                   },
    { QMK_KC_F4,                KEY_EN_F4                   },
    { QMK_KC_F5,                KEY_EN_F5                   },
    { QMK_KC_F6,                KEY_EN_F6                   },
    { QMK_KC_F7,                KEY_EN_F7                   },
    { QMK_KC_F8,                KEY_EN_F8                   },
    { QMK_KC_F9,                KEY_EN_F9                   },
    { QMK_KC_F10,               KEY_EN_F10                  },
    { QMK_KC_F11,               KEY_EN_F11                  },
    { QMK_KC_F12,               KEY_EN_F12                  },
    { QMK_KC_PRINT_SCREEN,      KEY_EN_PRINT_SCREEN         },
    { QMK_KC_SCROLL_LOCK,       KEY_EN_SCROLL_LOCK          },
    { QMK_KC_PAUSE,             KEY_EN_PAUSE_BREAK          },
    { QMK_KC_INSERT,            KEY_EN_INSERT               },
    { QMK_KC_HOME,              KEY_EN_HOME                 },
    { QMK_KC_PAGE_UP,           KEY_EN_PAGE_UP              },
    { QMK_KC_DELETE,            KEY_EN_DELETE               },
    { QMK_KC_END,               KEY_EN_END                  },
    { QMK_KC_PAGE_DOWN,         KEY_EN_PAGE_DOWN            },
    { QMK_KC_RIGHT,             KEY_EN_RIGHT_ARROW          },
    { QMK_KC_LEFT,              KEY_EN_LEFT_ARROW           },
    { QMK_KC_DOWN,              KEY_EN_DOWN_ARROW           },
    { QMK_KC_UP,                KEY_EN_UP_ARROW             },
    { QMK_KC_NUM_LOCK,          KEY_EN_NUMPAD_LOCK          },
    { QMK_KC_KP_SLASH,          KEY_EN_NUMPAD_DIVIDE        },
    { QMK_KC_KP_ASTERISK,       KEY_EN_NUMPAD_TIMES         },
    { QMK_KC_KP_MINUS,          KEY_EN_NUMPAD_MINUS         },
    { QMK_KC_KP_PLUS,           KEY_EN_NUMPAD_PLUS          },
    { QMK_KC_KP_ENTER,          KEY_EN_NUMPAD_ENTER         },
    { QMK_KC_KP_1,              KEY_EN_NUMPAD_1             },
    { QMK_KC_KP_2,              KEY_EN_NUMPAD_2             },
    { QMK_KC_KP_3,              KEY_EN_NUMPAD_3             },
    { QMK_KC_KP_4,              KEY_EN_NUMPAD_4             },
    { QMK_KC_KP_5,              KEY_EN_NUMPAD_5             },
    { QMK_KC_KP_6,              KEY_EN_NUMPAD_6             },
    { QMK_KC_KP_7,              KEY_EN_NUMPAD_7             },
    { QMK_KC_KP_8,              KEY_EN_NUMPAD_8             },
    { QMK_KC_KP_9,              KEY_EN_NUMPAD_9             },
    { QMK_KC_KP_0,              KEY_EN_NUMPAD_0             },
    { QMK_KC_KP_DOT,            KEY_EN_NUMPAD_PERIOD        },
    { QMK_KC_NONUS_BACKSLASH,   KEY_EN_ISO_BACK_SLASH       },
    { QMK_KC_APPLICATION,       KEY_EN_MENU                 },
    { QMK_KC_F13,               "Key: F13"                  },
    { QMK_KC_F14,               "Key: F14"                  },
    { QMK_KC_F15,               "Key: F15"                  },
    { QMK_KC_F16,               "Key: F16"                  },
    { QMK_KC_F17,               "Key: F17"                  },
    { QMK_KC_F18,               "Key: F18"                  },
    { QMK_KC_F19,               "Key: F19"                  },
    { QMK_KC_F20,               "Key: F20"                  },
    { QMK_KC_F21,               "Key: F21"                  },
    { QMK_KC_F22,               "Key: F22"                  },
    { QMK_KC_F23,               "Key: F23"                  },
    { QMK_KC_F24,               "Key: F24"                  },
    { QMK_KC_AUDIO_MUTE,        KEY_EN_MEDIA_MUTE           },
    { QMK_KC_AUDIO_VOL_UP,      KEY_EN_MEDIA_VOLUME_UP      },
    { QMK_KC_AUDIO_VOL_DOWN,    KEY_EN_MEDIA_VOLUME_DOWN    },
    { QMK_KC_MEDIA_NEXT_TRACK,  KEY_EN_MEDIA_NEXT           },
    { QMK_KC_MEDIA_PREV_TRACK,  KEY_EN_MEDIA_PREVIOUS       },
    { QMK_KC_MEDIA_STOP,        KEY_EN_MEDIA_STOP           },
    { QMK_KC_MEDIA_PLAY_PAUSE,  KEY_EN_MEDIA_PLAY_PAUSE     },
    { QMK_KC_MEDIA_SELECT,      "Key: Media Select"         },
    { QMK_KC_MEDIA_EJECT,       "Key: Media Eject"          },
    { QMK_KC_BRIGHTNESS_UP,     "Key: Brightness Up"        },
    { QMK_KC_BRIGHTNESS_DOWN,   "Key: Brightness Down"      },
    { 196,                      "Key: Task Manager"         }, /* From OpenRGB QMK          */
    { 202,                      "Key: RGB Brightness Up"    }, /* From OpenRGB QMK          */
    { 203,                      "Key: RGB Brightness Down"  }, /* From OpenRGB QMK          */
    { 216,                      KEY_EN_LEFT_SHIFT           }, /* Space Cadet Left Shift    */
    { 217,                      KEY_EN_RIGHT_SHIFT          }, /* Space Cadet Right Shift   */
    { QMK_KC_LEFT_CTRL,         KEY_EN_LEFT_CONTROL         },
    { QMK_KC_LEFT_SHIFT,        KEY_EN_LEFT_SHIFT           },
    { QMK_KC_LEFT_ALT,          KEY_EN_LEFT_ALT             },
    { QMK_KC_LEFT_GUI,          KEY_EN_LEFT_WINDOWS         },
    { QMK_KC_RIGHT_CTRL,        KEY_EN_RIGHT_CONTROL        },
    { QMK_KC_RIGHT_SHIFT,       KEY_EN_RIGHT_SHIFT          },
    { QMK_KC_RIGHT_ALT,         KEY_EN_RIGHT_ALT            },
    { QMK_KC_RIGHT_GUI,         KEY_EN_RIGHT_WINDOWS        },
};
