// Copyright 2016, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// -----------------------------------------------------------------------------
// This file is auto generated from the
// test/aarch32/config/template-assembler-aarch32.cc.in template file using
// tools/generate_tests.py.
//
// PLEASE DO NOT EDIT.
// -----------------------------------------------------------------------------


#include "test-runner.h"

#include "test-utils.h"
#include "test-utils-aarch32.h"

#include "aarch32/assembler-aarch32.h"
#include "aarch32/macro-assembler-aarch32.h"

#define BUF_SIZE (4096)

namespace vixl {
namespace aarch32 {

// List of instruction mnemonics.
#define FOREACH_INSTRUCTION(M) \
  M(ldrh)                      \
  M(ldrsh)                     \
  M(ldrsb)                     \
  M(strh)


// The following definitions are defined again in each generated test, therefore
// we need to place them in an anonymous namespace. It expresses that they are
// local to this file only, and the compiler is not allowed to share these types
// across test files during template instantiation. Specifically, `Operands` has
// various layouts across generated tests so it absolutely cannot be shared.

#ifdef VIXL_INCLUDE_TARGET_A32
namespace {

// Values to be passed to the assembler to produce the instruction under test.
struct Operands {
  Condition cond;
  Register rd;
  Register rn;
  Sign sign;
  int32_t offset;
  AddrMode addr_mode;
};

// This structure contains all data needed to test one specific
// instruction.
struct TestData {
  // The `operands` field represents what to pass to the assembler to
  // produce the instruction.
  Operands operands;
  // True if we need to generate an IT instruction for this test to be valid.
  bool in_it_block;
  // The condition to give the IT instruction, this will be set to "al" by
  // default.
  Condition it_condition;
  // Description of the operands, used for error reporting.
  const char* operands_description;
  // Unique identifier, used for generating traces.
  const char* identifier;
};

struct TestResult {
  size_t size;
  const byte* encoding;
};

// Each element of this array produce one instruction encoding.
const TestData kTests[] = {{{pl, r13, r0, plus, 0, Offset},
                            false,
                            al,
                            "pl r13 r0 plus 0 Offset",
                            "pl_r13_r0_plus_0_Offset"},
                           {{ge, r5, r3, plus, 0, Offset},
                            false,
                            al,
                            "ge r5 r3 plus 0 Offset",
                            "ge_r5_r3_plus_0_Offset"},
                           {{cc, r0, r4, plus, 0, Offset},
                            false,
                            al,
                            "cc r0 r4 plus 0 Offset",
                            "cc_r0_r4_plus_0_Offset"},
                           {{ge, r0, r0, plus, 0, Offset},
                            false,
                            al,
                            "ge r0 r0 plus 0 Offset",
                            "ge_r0_r0_plus_0_Offset"},
                           {{eq, r12, r3, plus, 0, Offset},
                            false,
                            al,
                            "eq r12 r3 plus 0 Offset",
                            "eq_r12_r3_plus_0_Offset"},
                           {{al, r4, r13, plus, 0, Offset},
                            false,
                            al,
                            "al r4 r13 plus 0 Offset",
                            "al_r4_r13_plus_0_Offset"},
                           {{mi, r8, r2, plus, 0, Offset},
                            false,
                            al,
                            "mi r8 r2 plus 0 Offset",
                            "mi_r8_r2_plus_0_Offset"},
                           {{mi, r6, r9, plus, 0, Offset},
                            false,
                            al,
                            "mi r6 r9 plus 0 Offset",
                            "mi_r6_r9_plus_0_Offset"},
                           {{gt, r13, r11, plus, 0, Offset},
                            false,
                            al,
                            "gt r13 r11 plus 0 Offset",
                            "gt_r13_r11_plus_0_Offset"},
                           {{cs, r0, r7, plus, 0, Offset},
                            false,
                            al,
                            "cs r0 r7 plus 0 Offset",
                            "cs_r0_r7_plus_0_Offset"},
                           {{ge, r7, r11, plus, 0, Offset},
                            false,
                            al,
                            "ge r7 r11 plus 0 Offset",
                            "ge_r7_r11_plus_0_Offset"},
                           {{pl, r11, r12, plus, 0, Offset},
                            false,
                            al,
                            "pl r11 r12 plus 0 Offset",
                            "pl_r11_r12_plus_0_Offset"},
                           {{cs, r2, r12, plus, 0, Offset},
                            false,
                            al,
                            "cs r2 r12 plus 0 Offset",
                            "cs_r2_r12_plus_0_Offset"},
                           {{vc, r2, r14, plus, 0, Offset},
                            false,
                            al,
                            "vc r2 r14 plus 0 Offset",
                            "vc_r2_r14_plus_0_Offset"},
                           {{le, r13, r6, plus, 0, Offset},
                            false,
                            al,
                            "le r13 r6 plus 0 Offset",
                            "le_r13_r6_plus_0_Offset"},
                           {{ls, r1, r2, plus, 0, Offset},
                            false,
                            al,
                            "ls r1 r2 plus 0 Offset",
                            "ls_r1_r2_plus_0_Offset"},
                           {{cc, r1, r6, plus, 0, Offset},
                            false,
                            al,
                            "cc r1 r6 plus 0 Offset",
                            "cc_r1_r6_plus_0_Offset"},
                           {{al, r10, r3, plus, 0, Offset},
                            false,
                            al,
                            "al r10 r3 plus 0 Offset",
                            "al_r10_r3_plus_0_Offset"},
                           {{al, r7, r9, plus, 0, Offset},
                            false,
                            al,
                            "al r7 r9 plus 0 Offset",
                            "al_r7_r9_plus_0_Offset"},
                           {{vs, r5, r3, plus, 0, Offset},
                            false,
                            al,
                            "vs r5 r3 plus 0 Offset",
                            "vs_r5_r3_plus_0_Offset"},
                           {{pl, r4, r4, plus, 0, Offset},
                            false,
                            al,
                            "pl r4 r4 plus 0 Offset",
                            "pl_r4_r4_plus_0_Offset"},
                           {{ne, r11, r9, plus, 0, Offset},
                            false,
                            al,
                            "ne r11 r9 plus 0 Offset",
                            "ne_r11_r9_plus_0_Offset"},
                           {{cc, r7, r14, plus, 0, Offset},
                            false,
                            al,
                            "cc r7 r14 plus 0 Offset",
                            "cc_r7_r14_plus_0_Offset"},
                           {{ne, r9, r3, plus, 0, Offset},
                            false,
                            al,
                            "ne r9 r3 plus 0 Offset",
                            "ne_r9_r3_plus_0_Offset"},
                           {{cc, r6, r14, plus, 0, Offset},
                            false,
                            al,
                            "cc r6 r14 plus 0 Offset",
                            "cc_r6_r14_plus_0_Offset"},
                           {{ne, r14, r14, plus, 0, Offset},
                            false,
                            al,
                            "ne r14 r14 plus 0 Offset",
                            "ne_r14_r14_plus_0_Offset"},
                           {{al, r13, r14, plus, 0, Offset},
                            false,
                            al,
                            "al r13 r14 plus 0 Offset",
                            "al_r13_r14_plus_0_Offset"},
                           {{cc, r3, r1, plus, 0, Offset},
                            false,
                            al,
                            "cc r3 r1 plus 0 Offset",
                            "cc_r3_r1_plus_0_Offset"},
                           {{ge, r1, r2, plus, 0, Offset},
                            false,
                            al,
                            "ge r1 r2 plus 0 Offset",
                            "ge_r1_r2_plus_0_Offset"},
                           {{eq, r3, r4, plus, 0, Offset},
                            false,
                            al,
                            "eq r3 r4 plus 0 Offset",
                            "eq_r3_r4_plus_0_Offset"},
                           {{al, r5, r10, plus, 0, Offset},
                            false,
                            al,
                            "al r5 r10 plus 0 Offset",
                            "al_r5_r10_plus_0_Offset"},
                           {{mi, r1, r3, plus, 0, Offset},
                            false,
                            al,
                            "mi r1 r3 plus 0 Offset",
                            "mi_r1_r3_plus_0_Offset"},
                           {{gt, r1, r4, plus, 0, Offset},
                            false,
                            al,
                            "gt r1 r4 plus 0 Offset",
                            "gt_r1_r4_plus_0_Offset"},
                           {{al, r7, r12, plus, 0, Offset},
                            false,
                            al,
                            "al r7 r12 plus 0 Offset",
                            "al_r7_r12_plus_0_Offset"},
                           {{ge, r14, r2, plus, 0, Offset},
                            false,
                            al,
                            "ge r14 r2 plus 0 Offset",
                            "ge_r14_r2_plus_0_Offset"},
                           {{le, r9, r7, plus, 0, Offset},
                            false,
                            al,
                            "le r9 r7 plus 0 Offset",
                            "le_r9_r7_plus_0_Offset"},
                           {{al, r9, r14, plus, 0, Offset},
                            false,
                            al,
                            "al r9 r14 plus 0 Offset",
                            "al_r9_r14_plus_0_Offset"},
                           {{hi, r10, r12, plus, 0, Offset},
                            false,
                            al,
                            "hi r10 r12 plus 0 Offset",
                            "hi_r10_r12_plus_0_Offset"},
                           {{le, r6, r5, plus, 0, Offset},
                            false,
                            al,
                            "le r6 r5 plus 0 Offset",
                            "le_r6_r5_plus_0_Offset"},
                           {{cs, r14, r12, plus, 0, Offset},
                            false,
                            al,
                            "cs r14 r12 plus 0 Offset",
                            "cs_r14_r12_plus_0_Offset"},
                           {{vc, r6, r9, plus, 0, Offset},
                            false,
                            al,
                            "vc r6 r9 plus 0 Offset",
                            "vc_r6_r9_plus_0_Offset"},
                           {{ne, r3, r9, plus, 0, Offset},
                            false,
                            al,
                            "ne r3 r9 plus 0 Offset",
                            "ne_r3_r9_plus_0_Offset"},
                           {{lt, r2, r9, plus, 0, Offset},
                            false,
                            al,
                            "lt r2 r9 plus 0 Offset",
                            "lt_r2_r9_plus_0_Offset"},
                           {{vc, r5, r11, plus, 0, Offset},
                            false,
                            al,
                            "vc r5 r11 plus 0 Offset",
                            "vc_r5_r11_plus_0_Offset"},
                           {{gt, r5, r1, plus, 0, Offset},
                            false,
                            al,
                            "gt r5 r1 plus 0 Offset",
                            "gt_r5_r1_plus_0_Offset"},
                           {{al, r12, r4, plus, 0, Offset},
                            false,
                            al,
                            "al r12 r4 plus 0 Offset",
                            "al_r12_r4_plus_0_Offset"},
                           {{ls, r11, r10, plus, 0, Offset},
                            false,
                            al,
                            "ls r11 r10 plus 0 Offset",
                            "ls_r11_r10_plus_0_Offset"},
                           {{eq, r14, r7, plus, 0, Offset},
                            false,
                            al,
                            "eq r14 r7 plus 0 Offset",
                            "eq_r14_r7_plus_0_Offset"},
                           {{vc, r7, r0, plus, 0, Offset},
                            false,
                            al,
                            "vc r7 r0 plus 0 Offset",
                            "vc_r7_r0_plus_0_Offset"},
                           {{le, r2, r6, plus, 0, Offset},
                            false,
                            al,
                            "le r2 r6 plus 0 Offset",
                            "le_r2_r6_plus_0_Offset"},
                           {{gt, r2, r6, plus, 0, Offset},
                            false,
                            al,
                            "gt r2 r6 plus 0 Offset",
                            "gt_r2_r6_plus_0_Offset"},
                           {{al, r6, r6, plus, 0, Offset},
                            false,
                            al,
                            "al r6 r6 plus 0 Offset",
                            "al_r6_r6_plus_0_Offset"},
                           {{ls, r10, r8, plus, 0, Offset},
                            false,
                            al,
                            "ls r10 r8 plus 0 Offset",
                            "ls_r10_r8_plus_0_Offset"},
                           {{lt, r5, r8, plus, 0, Offset},
                            false,
                            al,
                            "lt r5 r8 plus 0 Offset",
                            "lt_r5_r8_plus_0_Offset"},
                           {{vs, r13, r14, plus, 0, Offset},
                            false,
                            al,
                            "vs r13 r14 plus 0 Offset",
                            "vs_r13_r14_plus_0_Offset"},
                           {{gt, r9, r7, plus, 0, Offset},
                            false,
                            al,
                            "gt r9 r7 plus 0 Offset",
                            "gt_r9_r7_plus_0_Offset"},
                           {{cc, r8, r9, plus, 0, Offset},
                            false,
                            al,
                            "cc r8 r9 plus 0 Offset",
                            "cc_r8_r9_plus_0_Offset"},
                           {{le, r2, r7, plus, 0, Offset},
                            false,
                            al,
                            "le r2 r7 plus 0 Offset",
                            "le_r2_r7_plus_0_Offset"},
                           {{ge, r0, r1, plus, 0, Offset},
                            false,
                            al,
                            "ge r0 r1 plus 0 Offset",
                            "ge_r0_r1_plus_0_Offset"},
                           {{eq, r10, r14, plus, 0, Offset},
                            false,
                            al,
                            "eq r10 r14 plus 0 Offset",
                            "eq_r10_r14_plus_0_Offset"},
                           {{ls, r3, r3, plus, 0, Offset},
                            false,
                            al,
                            "ls r3 r3 plus 0 Offset",
                            "ls_r3_r3_plus_0_Offset"},
                           {{mi, r11, r6, plus, 0, Offset},
                            false,
                            al,
                            "mi r11 r6 plus 0 Offset",
                            "mi_r11_r6_plus_0_Offset"},
                           {{ne, r14, r12, plus, 0, Offset},
                            false,
                            al,
                            "ne r14 r12 plus 0 Offset",
                            "ne_r14_r12_plus_0_Offset"},
                           {{vs, r1, r12, plus, 0, Offset},
                            false,
                            al,
                            "vs r1 r12 plus 0 Offset",
                            "vs_r1_r12_plus_0_Offset"},
                           {{ls, r0, r0, plus, 0, Offset},
                            false,
                            al,
                            "ls r0 r0 plus 0 Offset",
                            "ls_r0_r0_plus_0_Offset"},
                           {{lt, r12, r14, plus, 0, Offset},
                            false,
                            al,
                            "lt r12 r14 plus 0 Offset",
                            "lt_r12_r14_plus_0_Offset"},
                           {{lt, r13, r9, plus, 0, Offset},
                            false,
                            al,
                            "lt r13 r9 plus 0 Offset",
                            "lt_r13_r9_plus_0_Offset"},
                           {{ge, r13, r9, plus, 0, Offset},
                            false,
                            al,
                            "ge r13 r9 plus 0 Offset",
                            "ge_r13_r9_plus_0_Offset"},
                           {{cs, r11, r0, plus, 0, Offset},
                            false,
                            al,
                            "cs r11 r0 plus 0 Offset",
                            "cs_r11_r0_plus_0_Offset"},
                           {{hi, r13, r11, plus, 0, Offset},
                            false,
                            al,
                            "hi r13 r11 plus 0 Offset",
                            "hi_r13_r11_plus_0_Offset"},
                           {{cs, r13, r9, plus, 0, Offset},
                            false,
                            al,
                            "cs r13 r9 plus 0 Offset",
                            "cs_r13_r9_plus_0_Offset"},
                           {{ne, r10, r10, plus, 0, Offset},
                            false,
                            al,
                            "ne r10 r10 plus 0 Offset",
                            "ne_r10_r10_plus_0_Offset"},
                           {{vc, r13, r9, plus, 0, Offset},
                            false,
                            al,
                            "vc r13 r9 plus 0 Offset",
                            "vc_r13_r9_plus_0_Offset"},
                           {{vc, r9, r3, plus, 0, Offset},
                            false,
                            al,
                            "vc r9 r3 plus 0 Offset",
                            "vc_r9_r3_plus_0_Offset"},
                           {{cc, r10, r4, plus, 0, Offset},
                            false,
                            al,
                            "cc r10 r4 plus 0 Offset",
                            "cc_r10_r4_plus_0_Offset"},
                           {{hi, r6, r6, plus, 0, Offset},
                            false,
                            al,
                            "hi r6 r6 plus 0 Offset",
                            "hi_r6_r6_plus_0_Offset"},
                           {{le, r11, r1, plus, 0, Offset},
                            false,
                            al,
                            "le r11 r1 plus 0 Offset",
                            "le_r11_r1_plus_0_Offset"},
                           {{gt, r3, r5, plus, 0, Offset},
                            false,
                            al,
                            "gt r3 r5 plus 0 Offset",
                            "gt_r3_r5_plus_0_Offset"},
                           {{lt, r0, r10, plus, 0, Offset},
                            false,
                            al,
                            "lt r0 r10 plus 0 Offset",
                            "lt_r0_r10_plus_0_Offset"},
                           {{vs, r6, r0, plus, 0, Offset},
                            false,
                            al,
                            "vs r6 r0 plus 0 Offset",
                            "vs_r6_r0_plus_0_Offset"},
                           {{vs, r8, r9, plus, 0, Offset},
                            false,
                            al,
                            "vs r8 r9 plus 0 Offset",
                            "vs_r8_r9_plus_0_Offset"},
                           {{mi, r9, r7, plus, 0, Offset},
                            false,
                            al,
                            "mi r9 r7 plus 0 Offset",
                            "mi_r9_r7_plus_0_Offset"},
                           {{vs, r12, r11, plus, 0, Offset},
                            false,
                            al,
                            "vs r12 r11 plus 0 Offset",
                            "vs_r12_r11_plus_0_Offset"},
                           {{vc, r11, r7, plus, 0, Offset},
                            false,
                            al,
                            "vc r11 r7 plus 0 Offset",
                            "vc_r11_r7_plus_0_Offset"},
                           {{hi, r11, r5, plus, 0, Offset},
                            false,
                            al,
                            "hi r11 r5 plus 0 Offset",
                            "hi_r11_r5_plus_0_Offset"},
                           {{lt, r0, r11, plus, 0, Offset},
                            false,
                            al,
                            "lt r0 r11 plus 0 Offset",
                            "lt_r0_r11_plus_0_Offset"},
                           {{ne, r11, r1, plus, 0, Offset},
                            false,
                            al,
                            "ne r11 r1 plus 0 Offset",
                            "ne_r11_r1_plus_0_Offset"},
                           {{ls, r5, r13, plus, 0, Offset},
                            false,
                            al,
                            "ls r5 r13 plus 0 Offset",
                            "ls_r5_r13_plus_0_Offset"},
                           {{gt, r13, r3, plus, 0, Offset},
                            false,
                            al,
                            "gt r13 r3 plus 0 Offset",
                            "gt_r13_r3_plus_0_Offset"},
                           {{vs, r12, r12, plus, 0, Offset},
                            false,
                            al,
                            "vs r12 r12 plus 0 Offset",
                            "vs_r12_r12_plus_0_Offset"},
                           {{mi, r12, r7, plus, 0, Offset},
                            false,
                            al,
                            "mi r12 r7 plus 0 Offset",
                            "mi_r12_r7_plus_0_Offset"},
                           {{le, r3, r4, plus, 0, Offset},
                            false,
                            al,
                            "le r3 r4 plus 0 Offset",
                            "le_r3_r4_plus_0_Offset"},
                           {{ne, r11, r10, plus, 0, Offset},
                            false,
                            al,
                            "ne r11 r10 plus 0 Offset",
                            "ne_r11_r10_plus_0_Offset"},
                           {{gt, r6, r13, plus, 0, Offset},
                            false,
                            al,
                            "gt r6 r13 plus 0 Offset",
                            "gt_r6_r13_plus_0_Offset"},
                           {{hi, r4, r8, plus, 0, Offset},
                            false,
                            al,
                            "hi r4 r8 plus 0 Offset",
                            "hi_r4_r8_plus_0_Offset"},
                           {{ge, r14, r5, plus, 0, Offset},
                            false,
                            al,
                            "ge r14 r5 plus 0 Offset",
                            "ge_r14_r5_plus_0_Offset"},
                           {{vc, r9, r6, plus, 0, Offset},
                            false,
                            al,
                            "vc r9 r6 plus 0 Offset",
                            "vc_r9_r6_plus_0_Offset"},
                           {{le, r2, r9, plus, 0, Offset},
                            false,
                            al,
                            "le r2 r9 plus 0 Offset",
                            "le_r2_r9_plus_0_Offset"},
                           {{ne, r10, r4, plus, 0, Offset},
                            false,
                            al,
                            "ne r10 r4 plus 0 Offset",
                            "ne_r10_r4_plus_0_Offset"},
                           {{vs, r10, r14, plus, 0, Offset},
                            false,
                            al,
                            "vs r10 r14 plus 0 Offset",
                            "vs_r10_r14_plus_0_Offset"},
                           {{al, r0, r11, minus, 40, Offset},
                            false,
                            al,
                            "al r0 r11 minus 40 Offset",
                            "al_r0_r11_minus_40_Offset"},
                           {{al, r0, r9, plus, 169, Offset},
                            false,
                            al,
                            "al r0 r9 plus 169 Offset",
                            "al_r0_r9_plus_169_Offset"},
                           {{al, r0, r9, plus, 45, Offset},
                            false,
                            al,
                            "al r0 r9 plus 45 Offset",
                            "al_r0_r9_plus_45_Offset"},
                           {{al, r0, r14, minus, 237, Offset},
                            false,
                            al,
                            "al r0 r14 minus 237 Offset",
                            "al_r0_r14_minus_237_Offset"},
                           {{al, r0, r11, minus, 145, Offset},
                            false,
                            al,
                            "al r0 r11 minus 145 Offset",
                            "al_r0_r11_minus_145_Offset"},
                           {{al, r0, r13, plus, 69, Offset},
                            false,
                            al,
                            "al r0 r13 plus 69 Offset",
                            "al_r0_r13_plus_69_Offset"},
                           {{al, r0, r8, minus, 37, Offset},
                            false,
                            al,
                            "al r0 r8 minus 37 Offset",
                            "al_r0_r8_minus_37_Offset"},
                           {{al, r0, r9, minus, 16, Offset},
                            false,
                            al,
                            "al r0 r9 minus 16 Offset",
                            "al_r0_r9_minus_16_Offset"},
                           {{al, r0, r13, minus, 89, Offset},
                            false,
                            al,
                            "al r0 r13 minus 89 Offset",
                            "al_r0_r13_minus_89_Offset"},
                           {{al, r0, r14, plus, 174, Offset},
                            false,
                            al,
                            "al r0 r14 plus 174 Offset",
                            "al_r0_r14_plus_174_Offset"},
                           {{al, r0, r5, minus, 177, Offset},
                            false,
                            al,
                            "al r0 r5 minus 177 Offset",
                            "al_r0_r5_minus_177_Offset"},
                           {{al, r0, r0, plus, 10, Offset},
                            false,
                            al,
                            "al r0 r0 plus 10 Offset",
                            "al_r0_r0_plus_10_Offset"},
                           {{al, r0, r0, plus, 80, Offset},
                            false,
                            al,
                            "al r0 r0 plus 80 Offset",
                            "al_r0_r0_plus_80_Offset"},
                           {{al, r0, r6, minus, 239, Offset},
                            false,
                            al,
                            "al r0 r6 minus 239 Offset",
                            "al_r0_r6_minus_239_Offset"},
                           {{al, r0, r4, minus, 146, Offset},
                            false,
                            al,
                            "al r0 r4 minus 146 Offset",
                            "al_r0_r4_minus_146_Offset"},
                           {{al, r0, r12, minus, 222, Offset},
                            false,
                            al,
                            "al r0 r12 minus 222 Offset",
                            "al_r0_r12_minus_222_Offset"},
                           {{al, r0, r1, plus, 212, Offset},
                            false,
                            al,
                            "al r0 r1 plus 212 Offset",
                            "al_r0_r1_plus_212_Offset"},
                           {{al, r0, r6, plus, 236, Offset},
                            false,
                            al,
                            "al r0 r6 plus 236 Offset",
                            "al_r0_r6_plus_236_Offset"},
                           {{al, r0, r11, minus, 46, Offset},
                            false,
                            al,
                            "al r0 r11 minus 46 Offset",
                            "al_r0_r11_minus_46_Offset"},
                           {{al, r0, r9, minus, 117, Offset},
                            false,
                            al,
                            "al r0 r9 minus 117 Offset",
                            "al_r0_r9_minus_117_Offset"},
                           {{al, r0, r5, minus, 152, Offset},
                            false,
                            al,
                            "al r0 r5 minus 152 Offset",
                            "al_r0_r5_minus_152_Offset"},
                           {{al, r0, r2, plus, 240, Offset},
                            false,
                            al,
                            "al r0 r2 plus 240 Offset",
                            "al_r0_r2_plus_240_Offset"},
                           {{al, r0, r0, minus, 20, Offset},
                            false,
                            al,
                            "al r0 r0 minus 20 Offset",
                            "al_r0_r0_minus_20_Offset"},
                           {{al, r0, r13, minus, 200, Offset},
                            false,
                            al,
                            "al r0 r13 minus 200 Offset",
                            "al_r0_r13_minus_200_Offset"},
                           {{al, r0, r14, plus, 106, Offset},
                            false,
                            al,
                            "al r0 r14 plus 106 Offset",
                            "al_r0_r14_plus_106_Offset"},
                           {{al, r0, r4, minus, 235, Offset},
                            false,
                            al,
                            "al r0 r4 minus 235 Offset",
                            "al_r0_r4_minus_235_Offset"},
                           {{al, r0, r11, plus, 188, Offset},
                            false,
                            al,
                            "al r0 r11 plus 188 Offset",
                            "al_r0_r11_plus_188_Offset"},
                           {{al, r0, r5, plus, 224, Offset},
                            false,
                            al,
                            "al r0 r5 plus 224 Offset",
                            "al_r0_r5_plus_224_Offset"},
                           {{al, r0, r10, minus, 218, Offset},
                            false,
                            al,
                            "al r0 r10 minus 218 Offset",
                            "al_r0_r10_minus_218_Offset"},
                           {{al, r0, r4, plus, 132, Offset},
                            false,
                            al,
                            "al r0 r4 plus 132 Offset",
                            "al_r0_r4_plus_132_Offset"},
                           {{al, r0, r12, plus, 210, Offset},
                            false,
                            al,
                            "al r0 r12 plus 210 Offset",
                            "al_r0_r12_plus_210_Offset"},
                           {{al, r0, r7, plus, 24, Offset},
                            false,
                            al,
                            "al r0 r7 plus 24 Offset",
                            "al_r0_r7_plus_24_Offset"},
                           {{al, r0, r9, plus, 71, Offset},
                            false,
                            al,
                            "al r0 r9 plus 71 Offset",
                            "al_r0_r9_plus_71_Offset"},
                           {{al, r0, r11, minus, 241, Offset},
                            false,
                            al,
                            "al r0 r11 minus 241 Offset",
                            "al_r0_r11_minus_241_Offset"},
                           {{al, r0, r5, minus, 77, Offset},
                            false,
                            al,
                            "al r0 r5 minus 77 Offset",
                            "al_r0_r5_minus_77_Offset"},
                           {{al, r0, r7, plus, 159, Offset},
                            false,
                            al,
                            "al r0 r7 plus 159 Offset",
                            "al_r0_r7_plus_159_Offset"},
                           {{al, r0, r0, plus, 191, Offset},
                            false,
                            al,
                            "al r0 r0 plus 191 Offset",
                            "al_r0_r0_plus_191_Offset"},
                           {{al, r0, r2, minus, 162, Offset},
                            false,
                            al,
                            "al r0 r2 minus 162 Offset",
                            "al_r0_r2_minus_162_Offset"},
                           {{al, r0, r4, plus, 102, Offset},
                            false,
                            al,
                            "al r0 r4 plus 102 Offset",
                            "al_r0_r4_plus_102_Offset"},
                           {{al, r0, r3, minus, 91, Offset},
                            false,
                            al,
                            "al r0 r3 minus 91 Offset",
                            "al_r0_r3_minus_91_Offset"},
                           {{al, r0, r14, plus, 67, Offset},
                            false,
                            al,
                            "al r0 r14 plus 67 Offset",
                            "al_r0_r14_plus_67_Offset"},
                           {{al, r0, r2, plus, 209, Offset},
                            false,
                            al,
                            "al r0 r2 plus 209 Offset",
                            "al_r0_r2_plus_209_Offset"},
                           {{al, r0, r13, minus, 220, Offset},
                            false,
                            al,
                            "al r0 r13 minus 220 Offset",
                            "al_r0_r13_minus_220_Offset"},
                           {{al, r0, r9, minus, 112, Offset},
                            false,
                            al,
                            "al r0 r9 minus 112 Offset",
                            "al_r0_r9_minus_112_Offset"},
                           {{al, r0, r4, minus, 95, Offset},
                            false,
                            al,
                            "al r0 r4 minus 95 Offset",
                            "al_r0_r4_minus_95_Offset"},
                           {{al, r0, r14, minus, 133, Offset},
                            false,
                            al,
                            "al r0 r14 minus 133 Offset",
                            "al_r0_r14_minus_133_Offset"},
                           {{al, r0, r3, plus, 70, Offset},
                            false,
                            al,
                            "al r0 r3 plus 70 Offset",
                            "al_r0_r3_plus_70_Offset"},
                           {{al, r0, r5, minus, 191, Offset},
                            false,
                            al,
                            "al r0 r5 minus 191 Offset",
                            "al_r0_r5_minus_191_Offset"},
                           {{al, r0, r7, minus, 10, Offset},
                            false,
                            al,
                            "al r0 r7 minus 10 Offset",
                            "al_r0_r7_minus_10_Offset"},
                           {{al, r0, r10, plus, 10, Offset},
                            false,
                            al,
                            "al r0 r10 plus 10 Offset",
                            "al_r0_r10_plus_10_Offset"},
                           {{al, r0, r5, plus, 78, Offset},
                            false,
                            al,
                            "al r0 r5 plus 78 Offset",
                            "al_r0_r5_plus_78_Offset"},
                           {{al, r0, r2, plus, 252, Offset},
                            false,
                            al,
                            "al r0 r2 plus 252 Offset",
                            "al_r0_r2_plus_252_Offset"},
                           {{al, r0, r12, plus, 150, Offset},
                            false,
                            al,
                            "al r0 r12 plus 150 Offset",
                            "al_r0_r12_plus_150_Offset"},
                           {{al, r0, r13, minus, 69, Offset},
                            false,
                            al,
                            "al r0 r13 minus 69 Offset",
                            "al_r0_r13_minus_69_Offset"},
                           {{al, r0, r5, minus, 12, Offset},
                            false,
                            al,
                            "al r0 r5 minus 12 Offset",
                            "al_r0_r5_minus_12_Offset"},
                           {{al, r0, r0, minus, 115, Offset},
                            false,
                            al,
                            "al r0 r0 minus 115 Offset",
                            "al_r0_r0_minus_115_Offset"},
                           {{al, r0, r5, minus, 233, Offset},
                            false,
                            al,
                            "al r0 r5 minus 233 Offset",
                            "al_r0_r5_minus_233_Offset"},
                           {{al, r0, r10, plus, 214, Offset},
                            false,
                            al,
                            "al r0 r10 plus 214 Offset",
                            "al_r0_r10_plus_214_Offset"},
                           {{al, r0, r4, plus, 123, Offset},
                            false,
                            al,
                            "al r0 r4 plus 123 Offset",
                            "al_r0_r4_plus_123_Offset"},
                           {{al, r0, r12, plus, 121, Offset},
                            false,
                            al,
                            "al r0 r12 plus 121 Offset",
                            "al_r0_r12_plus_121_Offset"},
                           {{al, r0, r3, plus, 93, Offset},
                            false,
                            al,
                            "al r0 r3 plus 93 Offset",
                            "al_r0_r3_plus_93_Offset"},
                           {{al, r0, r5, plus, 239, Offset},
                            false,
                            al,
                            "al r0 r5 plus 239 Offset",
                            "al_r0_r5_plus_239_Offset"},
                           {{al, r0, r13, minus, 56, Offset},
                            false,
                            al,
                            "al r0 r13 minus 56 Offset",
                            "al_r0_r13_minus_56_Offset"},
                           {{al, r0, r4, minus, 1, Offset},
                            false,
                            al,
                            "al r0 r4 minus 1 Offset",
                            "al_r0_r4_minus_1_Offset"},
                           {{al, r0, r6, plus, 190, Offset},
                            false,
                            al,
                            "al r0 r6 plus 190 Offset",
                            "al_r0_r6_plus_190_Offset"},
                           {{al, r0, r10, plus, 232, Offset},
                            false,
                            al,
                            "al r0 r10 plus 232 Offset",
                            "al_r0_r10_plus_232_Offset"},
                           {{al, r0, r1, plus, 232, Offset},
                            false,
                            al,
                            "al r0 r1 plus 232 Offset",
                            "al_r0_r1_plus_232_Offset"},
                           {{al, r0, r14, plus, 210, Offset},
                            false,
                            al,
                            "al r0 r14 plus 210 Offset",
                            "al_r0_r14_plus_210_Offset"},
                           {{al, r0, r3, plus, 208, Offset},
                            false,
                            al,
                            "al r0 r3 plus 208 Offset",
                            "al_r0_r3_plus_208_Offset"},
                           {{al, r0, r0, plus, 221, Offset},
                            false,
                            al,
                            "al r0 r0 plus 221 Offset",
                            "al_r0_r0_plus_221_Offset"},
                           {{al, r0, r2, minus, 77, Offset},
                            false,
                            al,
                            "al r0 r2 minus 77 Offset",
                            "al_r0_r2_minus_77_Offset"},
                           {{al, r0, r10, plus, 142, Offset},
                            false,
                            al,
                            "al r0 r10 plus 142 Offset",
                            "al_r0_r10_plus_142_Offset"},
                           {{al, r0, r7, plus, 14, Offset},
                            false,
                            al,
                            "al r0 r7 plus 14 Offset",
                            "al_r0_r7_plus_14_Offset"},
                           {{al, r0, r13, minus, 29, Offset},
                            false,
                            al,
                            "al r0 r13 minus 29 Offset",
                            "al_r0_r13_minus_29_Offset"},
                           {{al, r0, r13, plus, 165, Offset},
                            false,
                            al,
                            "al r0 r13 plus 165 Offset",
                            "al_r0_r13_plus_165_Offset"},
                           {{al, r0, r12, minus, 245, Offset},
                            false,
                            al,
                            "al r0 r12 minus 245 Offset",
                            "al_r0_r12_minus_245_Offset"},
                           {{al, r0, r8, minus, 199, Offset},
                            false,
                            al,
                            "al r0 r8 minus 199 Offset",
                            "al_r0_r8_minus_199_Offset"},
                           {{al, r0, r9, minus, 34, Offset},
                            false,
                            al,
                            "al r0 r9 minus 34 Offset",
                            "al_r0_r9_minus_34_Offset"},
                           {{al, r0, r5, plus, 182, Offset},
                            false,
                            al,
                            "al r0 r5 plus 182 Offset",
                            "al_r0_r5_plus_182_Offset"},
                           {{al, r0, r13, minus, 70, Offset},
                            false,
                            al,
                            "al r0 r13 minus 70 Offset",
                            "al_r0_r13_minus_70_Offset"},
                           {{al, r0, r3, minus, 241, Offset},
                            false,
                            al,
                            "al r0 r3 minus 241 Offset",
                            "al_r0_r3_minus_241_Offset"},
                           {{al, r0, r4, plus, 134, Offset},
                            false,
                            al,
                            "al r0 r4 plus 134 Offset",
                            "al_r0_r4_plus_134_Offset"},
                           {{al, r0, r6, minus, 155, Offset},
                            false,
                            al,
                            "al r0 r6 minus 155 Offset",
                            "al_r0_r6_minus_155_Offset"},
                           {{al, r0, r2, plus, 105, Offset},
                            false,
                            al,
                            "al r0 r2 plus 105 Offset",
                            "al_r0_r2_plus_105_Offset"},
                           {{al, r0, r9, plus, 29, Offset},
                            false,
                            al,
                            "al r0 r9 plus 29 Offset",
                            "al_r0_r9_plus_29_Offset"},
                           {{al, r0, r1, minus, 223, Offset},
                            false,
                            al,
                            "al r0 r1 minus 223 Offset",
                            "al_r0_r1_minus_223_Offset"},
                           {{al, r0, r10, minus, 141, Offset},
                            false,
                            al,
                            "al r0 r10 minus 141 Offset",
                            "al_r0_r10_minus_141_Offset"},
                           {{al, r0, r4, plus, 15, Offset},
                            false,
                            al,
                            "al r0 r4 plus 15 Offset",
                            "al_r0_r4_plus_15_Offset"},
                           {{al, r0, r2, plus, 157, Offset},
                            false,
                            al,
                            "al r0 r2 plus 157 Offset",
                            "al_r0_r2_plus_157_Offset"},
                           {{al, r0, r10, minus, 122, Offset},
                            false,
                            al,
                            "al r0 r10 minus 122 Offset",
                            "al_r0_r10_minus_122_Offset"},
                           {{al, r0, r2, minus, 54, Offset},
                            false,
                            al,
                            "al r0 r2 minus 54 Offset",
                            "al_r0_r2_minus_54_Offset"},
                           {{al, r0, r2, plus, 30, Offset},
                            false,
                            al,
                            "al r0 r2 plus 30 Offset",
                            "al_r0_r2_plus_30_Offset"},
                           {{al, r0, r0, minus, 221, Offset},
                            false,
                            al,
                            "al r0 r0 minus 221 Offset",
                            "al_r0_r0_minus_221_Offset"},
                           {{al, r0, r12, plus, 34, Offset},
                            false,
                            al,
                            "al r0 r12 plus 34 Offset",
                            "al_r0_r12_plus_34_Offset"},
                           {{al, r0, r4, plus, 145, Offset},
                            false,
                            al,
                            "al r0 r4 plus 145 Offset",
                            "al_r0_r4_plus_145_Offset"},
                           {{al, r0, r0, plus, 85, Offset},
                            false,
                            al,
                            "al r0 r0 plus 85 Offset",
                            "al_r0_r0_plus_85_Offset"},
                           {{al, r0, r6, plus, 64, Offset},
                            false,
                            al,
                            "al r0 r6 plus 64 Offset",
                            "al_r0_r6_plus_64_Offset"},
                           {{al, r0, r9, plus, 72, Offset},
                            false,
                            al,
                            "al r0 r9 plus 72 Offset",
                            "al_r0_r9_plus_72_Offset"},
                           {{al, r0, r10, minus, 97, Offset},
                            false,
                            al,
                            "al r0 r10 minus 97 Offset",
                            "al_r0_r10_minus_97_Offset"},
                           {{al, r0, r2, plus, 186, Offset},
                            false,
                            al,
                            "al r0 r2 plus 186 Offset",
                            "al_r0_r2_plus_186_Offset"},
                           {{al, r0, r9, plus, 10, Offset},
                            false,
                            al,
                            "al r0 r9 plus 10 Offset",
                            "al_r0_r9_plus_10_Offset"},
                           {{al, r0, r6, minus, 236, Offset},
                            false,
                            al,
                            "al r0 r6 minus 236 Offset",
                            "al_r0_r6_minus_236_Offset"},
                           {{al, r0, r13, plus, 73, Offset},
                            false,
                            al,
                            "al r0 r13 plus 73 Offset",
                            "al_r0_r13_plus_73_Offset"},
                           {{al, r0, r13, plus, 112, Offset},
                            false,
                            al,
                            "al r0 r13 plus 112 Offset",
                            "al_r0_r13_plus_112_Offset"},
                           {{al, r0, r0, minus, 101, Offset},
                            false,
                            al,
                            "al r0 r0 minus 101 Offset",
                            "al_r0_r0_minus_101_Offset"},
                           {{al, r0, r9, plus, 32, Offset},
                            false,
                            al,
                            "al r0 r9 plus 32 Offset",
                            "al_r0_r9_plus_32_Offset"},
                           {{al, r0, r9, plus, 57, Offset},
                            false,
                            al,
                            "al r0 r9 plus 57 Offset",
                            "al_r0_r9_plus_57_Offset"},
                           {{al, r0, r5, minus, 41, Offset},
                            false,
                            al,
                            "al r0 r5 minus 41 Offset",
                            "al_r0_r5_minus_41_Offset"},
                           {{al, r0, r8, plus, 199, Offset},
                            false,
                            al,
                            "al r0 r8 plus 199 Offset",
                            "al_r0_r8_plus_199_Offset"},
                           {{al, r0, r7, plus, 208, Offset},
                            false,
                            al,
                            "al r0 r7 plus 208 Offset",
                            "al_r0_r7_plus_208_Offset"},
                           {{al, r0, r2, minus, 63, Offset},
                            false,
                            al,
                            "al r0 r2 minus 63 Offset",
                            "al_r0_r2_minus_63_Offset"},
                           {{al, r0, r7, minus, 69, Offset},
                            false,
                            al,
                            "al r0 r7 minus 69 Offset",
                            "al_r0_r7_minus_69_Offset"},
                           {{al, r0, r8, plus, 19, Offset},
                            false,
                            al,
                            "al r0 r8 plus 19 Offset",
                            "al_r0_r8_plus_19_Offset"},
                           {{al, r0, r6, plus, 128, Offset},
                            false,
                            al,
                            "al r0 r6 plus 128 Offset",
                            "al_r0_r6_plus_128_Offset"},
                           {{al, r0, r1, plus, 185, Offset},
                            false,
                            al,
                            "al r0 r1 plus 185 Offset",
                            "al_r0_r1_plus_185_Offset"},
                           {{al, r0, r11, minus, 198, Offset},
                            false,
                            al,
                            "al r0 r11 minus 198 Offset",
                            "al_r0_r11_minus_198_Offset"},
                           {{al, r0, r3, minus, 172, Offset},
                            false,
                            al,
                            "al r0 r3 minus 172 Offset",
                            "al_r0_r3_minus_172_Offset"},
                           {{al, r0, r14, plus, 146, Offset},
                            false,
                            al,
                            "al r0 r14 plus 146 Offset",
                            "al_r0_r14_plus_146_Offset"},
                           {{al, r0, r4, plus, 226, Offset},
                            false,
                            al,
                            "al r0 r4 plus 226 Offset",
                            "al_r0_r4_plus_226_Offset"},
                           {{al, r0, r9, plus, 73, Offset},
                            false,
                            al,
                            "al r0 r9 plus 73 Offset",
                            "al_r0_r9_plus_73_Offset"},
                           {{al, r0, r13, minus, 177, Offset},
                            false,
                            al,
                            "al r0 r13 minus 177 Offset",
                            "al_r0_r13_minus_177_Offset"},
                           {{al, r0, r13, minus, 179, Offset},
                            false,
                            al,
                            "al r0 r13 minus 179 Offset",
                            "al_r0_r13_minus_179_Offset"},
                           {{al, r0, r7, minus, 70, Offset},
                            false,
                            al,
                            "al r0 r7 minus 70 Offset",
                            "al_r0_r7_minus_70_Offset"},
                           {{al, r0, r0, plus, 132, Offset},
                            false,
                            al,
                            "al r0 r0 plus 132 Offset",
                            "al_r0_r0_plus_132_Offset"},
                           {{al, r0, r3, plus, 45, Offset},
                            false,
                            al,
                            "al r0 r3 plus 45 Offset",
                            "al_r0_r3_plus_45_Offset"},
                           {{al, r0, r1, plus, 150, Offset},
                            false,
                            al,
                            "al r0 r1 plus 150 Offset",
                            "al_r0_r1_plus_150_Offset"},
                           {{al, r0, r5, plus, 203, Offset},
                            false,
                            al,
                            "al r0 r5 plus 203 Offset",
                            "al_r0_r5_plus_203_Offset"},
                           {{al, r0, r7, minus, 107, Offset},
                            false,
                            al,
                            "al r0 r7 minus 107 Offset",
                            "al_r0_r7_minus_107_Offset"},
                           {{al, r0, r3, plus, 182, Offset},
                            false,
                            al,
                            "al r0 r3 plus 182 Offset",
                            "al_r0_r3_plus_182_Offset"},
                           {{al, r0, r14, minus, 112, Offset},
                            false,
                            al,
                            "al r0 r14 minus 112 Offset",
                            "al_r0_r14_minus_112_Offset"},
                           {{al, r0, r2, minus, 49, Offset},
                            false,
                            al,
                            "al r0 r2 minus 49 Offset",
                            "al_r0_r2_minus_49_Offset"},
                           {{al, r0, r9, plus, 50, Offset},
                            false,
                            al,
                            "al r0 r9 plus 50 Offset",
                            "al_r0_r9_plus_50_Offset"},
                           {{al, r0, r14, minus, 153, Offset},
                            false,
                            al,
                            "al r0 r14 minus 153 Offset",
                            "al_r0_r14_minus_153_Offset"},
                           {{al, r0, r5, plus, 238, Offset},
                            false,
                            al,
                            "al r0 r5 plus 238 Offset",
                            "al_r0_r5_plus_238_Offset"},
                           {{al, r0, r10, minus, 131, Offset},
                            false,
                            al,
                            "al r0 r10 minus 131 Offset",
                            "al_r0_r10_minus_131_Offset"},
                           {{al, r0, r0, plus, 95, Offset},
                            false,
                            al,
                            "al r0 r0 plus 95 Offset",
                            "al_r0_r0_plus_95_Offset"},
                           {{al, r0, r5, minus, 225, Offset},
                            false,
                            al,
                            "al r0 r5 minus 225 Offset",
                            "al_r0_r5_minus_225_Offset"},
                           {{al, r0, r8, minus, 180, Offset},
                            false,
                            al,
                            "al r0 r8 minus 180 Offset",
                            "al_r0_r8_minus_180_Offset"},
                           {{al, r0, r8, plus, 173, Offset},
                            false,
                            al,
                            "al r0 r8 plus 173 Offset",
                            "al_r0_r8_plus_173_Offset"},
                           {{al, r0, r11, minus, 161, Offset},
                            false,
                            al,
                            "al r0 r11 minus 161 Offset",
                            "al_r0_r11_minus_161_Offset"},
                           {{al, r0, r11, plus, 65, Offset},
                            false,
                            al,
                            "al r0 r11 plus 65 Offset",
                            "al_r0_r11_plus_65_Offset"},
                           {{al, r0, r8, plus, 52, Offset},
                            false,
                            al,
                            "al r0 r8 plus 52 Offset",
                            "al_r0_r8_plus_52_Offset"},
                           {{al, r0, r14, plus, 221, Offset},
                            false,
                            al,
                            "al r0 r14 plus 221 Offset",
                            "al_r0_r14_plus_221_Offset"},
                           {{al, r0, r3, minus, 176, Offset},
                            false,
                            al,
                            "al r0 r3 minus 176 Offset",
                            "al_r0_r3_minus_176_Offset"},
                           {{al, r0, r5, minus, 1, Offset},
                            false,
                            al,
                            "al r0 r5 minus 1 Offset",
                            "al_r0_r5_minus_1_Offset"},
                           {{al, r0, r8, minus, 139, Offset},
                            false,
                            al,
                            "al r0 r8 minus 139 Offset",
                            "al_r0_r8_minus_139_Offset"},
                           {{al, r0, r0, plus, 154, Offset},
                            false,
                            al,
                            "al r0 r0 plus 154 Offset",
                            "al_r0_r0_plus_154_Offset"},
                           {{al, r0, r5, minus, 54, Offset},
                            false,
                            al,
                            "al r0 r5 minus 54 Offset",
                            "al_r0_r5_minus_54_Offset"},
                           {{al, r0, r7, plus, 29, Offset},
                            false,
                            al,
                            "al r0 r7 plus 29 Offset",
                            "al_r0_r7_plus_29_Offset"},
                           {{al, r0, r3, minus, 202, Offset},
                            false,
                            al,
                            "al r0 r3 minus 202 Offset",
                            "al_r0_r3_minus_202_Offset"},
                           {{al, r0, r12, minus, 136, Offset},
                            false,
                            al,
                            "al r0 r12 minus 136 Offset",
                            "al_r0_r12_minus_136_Offset"},
                           {{al, r0, r0, minus, 130, Offset},
                            false,
                            al,
                            "al r0 r0 minus 130 Offset",
                            "al_r0_r0_minus_130_Offset"},
                           {{al, r0, r3, plus, 30, Offset},
                            false,
                            al,
                            "al r0 r3 plus 30 Offset",
                            "al_r0_r3_plus_30_Offset"},
                           {{al, r0, r1, minus, 136, Offset},
                            false,
                            al,
                            "al r0 r1 minus 136 Offset",
                            "al_r0_r1_minus_136_Offset"},
                           {{al, r0, r4, plus, 176, Offset},
                            false,
                            al,
                            "al r0 r4 plus 176 Offset",
                            "al_r0_r4_plus_176_Offset"},
                           {{al, r0, r2, plus, 141, Offset},
                            false,
                            al,
                            "al r0 r2 plus 141 Offset",
                            "al_r0_r2_plus_141_Offset"},
                           {{al, r0, r4, minus, 196, Offset},
                            false,
                            al,
                            "al r0 r4 minus 196 Offset",
                            "al_r0_r4_minus_196_Offset"},
                           {{al, r0, r9, minus, 55, Offset},
                            false,
                            al,
                            "al r0 r9 minus 55 Offset",
                            "al_r0_r9_minus_55_Offset"},
                           {{al, r0, r11, plus, 99, Offset},
                            false,
                            al,
                            "al r0 r11 plus 99 Offset",
                            "al_r0_r11_plus_99_Offset"},
                           {{al, r0, r12, plus, 169, Offset},
                            false,
                            al,
                            "al r0 r12 plus 169 Offset",
                            "al_r0_r12_plus_169_Offset"},
                           {{al, r0, r7, plus, 91, Offset},
                            false,
                            al,
                            "al r0 r7 plus 91 Offset",
                            "al_r0_r7_plus_91_Offset"},
                           {{al, r0, r10, plus, 93, Offset},
                            false,
                            al,
                            "al r0 r10 plus 93 Offset",
                            "al_r0_r10_plus_93_Offset"},
                           {{al, r0, r4, minus, 77, Offset},
                            false,
                            al,
                            "al r0 r4 minus 77 Offset",
                            "al_r0_r4_minus_77_Offset"},
                           {{al, r0, r2, plus, 6, Offset},
                            false,
                            al,
                            "al r0 r2 plus 6 Offset",
                            "al_r0_r2_plus_6_Offset"},
                           {{al, r0, r13, minus, 31, Offset},
                            false,
                            al,
                            "al r0 r13 minus 31 Offset",
                            "al_r0_r13_minus_31_Offset"},
                           {{al, r0, r14, plus, 129, Offset},
                            false,
                            al,
                            "al r0 r14 plus 129 Offset",
                            "al_r0_r14_plus_129_Offset"},
                           {{al, r0, r13, minus, 198, Offset},
                            false,
                            al,
                            "al r0 r13 minus 198 Offset",
                            "al_r0_r13_minus_198_Offset"},
                           {{al, r0, r5, plus, 33, Offset},
                            false,
                            al,
                            "al r0 r5 plus 33 Offset",
                            "al_r0_r5_plus_33_Offset"},
                           {{al, r0, r0, minus, 16, Offset},
                            false,
                            al,
                            "al r0 r0 minus 16 Offset",
                            "al_r0_r0_minus_16_Offset"},
                           {{al, r0, r12, minus, 14, Offset},
                            false,
                            al,
                            "al r0 r12 minus 14 Offset",
                            "al_r0_r12_minus_14_Offset"},
                           {{al, r0, r2, plus, 146, Offset},
                            false,
                            al,
                            "al r0 r2 plus 146 Offset",
                            "al_r0_r2_plus_146_Offset"},
                           {{al, r0, r1, plus, 174, Offset},
                            false,
                            al,
                            "al r0 r1 plus 174 Offset",
                            "al_r0_r1_plus_174_Offset"},
                           {{al, r0, r2, plus, 21, Offset},
                            false,
                            al,
                            "al r0 r2 plus 21 Offset",
                            "al_r0_r2_plus_21_Offset"},
                           {{al, r0, r7, plus, 202, Offset},
                            false,
                            al,
                            "al r0 r7 plus 202 Offset",
                            "al_r0_r7_plus_202_Offset"},
                           {{al, r0, r5, plus, 36, Offset},
                            false,
                            al,
                            "al r0 r5 plus 36 Offset",
                            "al_r0_r5_plus_36_Offset"},
                           {{al, r0, r7, plus, 179, Offset},
                            false,
                            al,
                            "al r0 r7 plus 179 Offset",
                            "al_r0_r7_plus_179_Offset"},
                           {{al, r0, r4, minus, 84, Offset},
                            false,
                            al,
                            "al r0 r4 minus 84 Offset",
                            "al_r0_r4_minus_84_Offset"},
                           {{al, r0, r3, plus, 73, Offset},
                            false,
                            al,
                            "al r0 r3 plus 73 Offset",
                            "al_r0_r3_plus_73_Offset"},
                           {{al, r0, r0, minus, 122, Offset},
                            false,
                            al,
                            "al r0 r0 minus 122 Offset",
                            "al_r0_r0_minus_122_Offset"},
                           {{al, r0, r14, plus, 8, Offset},
                            false,
                            al,
                            "al r0 r14 plus 8 Offset",
                            "al_r0_r14_plus_8_Offset"},
                           {{al, r0, r7, plus, 94, Offset},
                            false,
                            al,
                            "al r0 r7 plus 94 Offset",
                            "al_r0_r7_plus_94_Offset"},
                           {{al, r0, r8, plus, 217, Offset},
                            false,
                            al,
                            "al r0 r8 plus 217 Offset",
                            "al_r0_r8_plus_217_Offset"},
                           {{al, r0, r0, minus, 97, Offset},
                            false,
                            al,
                            "al r0 r0 minus 97 Offset",
                            "al_r0_r0_minus_97_Offset"},
                           {{al, r0, r4, minus, 202, Offset},
                            false,
                            al,
                            "al r0 r4 minus 202 Offset",
                            "al_r0_r4_minus_202_Offset"},
                           {{al, r0, r14, minus, 28, Offset},
                            false,
                            al,
                            "al r0 r14 minus 28 Offset",
                            "al_r0_r14_minus_28_Offset"},
                           {{al, r0, r14, plus, 176, Offset},
                            false,
                            al,
                            "al r0 r14 plus 176 Offset",
                            "al_r0_r14_plus_176_Offset"},
                           {{al, r0, r11, minus, 148, Offset},
                            false,
                            al,
                            "al r0 r11 minus 148 Offset",
                            "al_r0_r11_minus_148_Offset"},
                           {{al, r0, r3, minus, 204, Offset},
                            false,
                            al,
                            "al r0 r3 minus 204 Offset",
                            "al_r0_r3_minus_204_Offset"},
                           {{al, r0, r8, minus, 131, Offset},
                            false,
                            al,
                            "al r0 r8 minus 131 Offset",
                            "al_r0_r8_minus_131_Offset"},
                           {{al, r0, r0, plus, 125, Offset},
                            false,
                            al,
                            "al r0 r0 plus 125 Offset",
                            "al_r0_r0_plus_125_Offset"},
                           {{al, r0, r4, minus, 255, Offset},
                            false,
                            al,
                            "al r0 r4 minus 255 Offset",
                            "al_r0_r4_minus_255_Offset"},
                           {{al, r0, r11, minus, 247, Offset},
                            false,
                            al,
                            "al r0 r11 minus 247 Offset",
                            "al_r0_r11_minus_247_Offset"},
                           {{al, r0, r0, minus, 254, Offset},
                            false,
                            al,
                            "al r0 r0 minus 254 Offset",
                            "al_r0_r0_minus_254_Offset"},
                           {{al, r0, r3, minus, 93, Offset},
                            false,
                            al,
                            "al r0 r3 minus 93 Offset",
                            "al_r0_r3_minus_93_Offset"},
                           {{al, r0, r2, minus, 137, Offset},
                            false,
                            al,
                            "al r0 r2 minus 137 Offset",
                            "al_r0_r2_minus_137_Offset"},
                           {{al, r0, r6, plus, 70, Offset},
                            false,
                            al,
                            "al r0 r6 plus 70 Offset",
                            "al_r0_r6_plus_70_Offset"},
                           {{al, r0, r9, plus, 155, Offset},
                            false,
                            al,
                            "al r0 r9 plus 155 Offset",
                            "al_r0_r9_plus_155_Offset"},
                           {{al, r0, r7, minus, 112, Offset},
                            false,
                            al,
                            "al r0 r7 minus 112 Offset",
                            "al_r0_r7_minus_112_Offset"},
                           {{al, r0, r5, plus, 135, Offset},
                            false,
                            al,
                            "al r0 r5 plus 135 Offset",
                            "al_r0_r5_plus_135_Offset"},
                           {{al, r0, r1, plus, 37, Offset},
                            false,
                            al,
                            "al r0 r1 plus 37 Offset",
                            "al_r0_r1_plus_37_Offset"},
                           {{al, r0, r2, minus, 180, PostIndex},
                            false,
                            al,
                            "al r0 r2 minus 180 PostIndex",
                            "al_r0_r2_minus_180_PostIndex"},
                           {{al, r7, r10, plus, 36, PostIndex},
                            false,
                            al,
                            "al r7 r10 plus 36 PostIndex",
                            "al_r7_r10_plus_36_PostIndex"},
                           {{al, r5, r3, minus, 99, PreIndex},
                            false,
                            al,
                            "al r5 r3 minus 99 PreIndex",
                            "al_r5_r3_minus_99_PreIndex"},
                           {{al, r0, r8, plus, 182, PostIndex},
                            false,
                            al,
                            "al r0 r8 plus 182 PostIndex",
                            "al_r0_r8_plus_182_PostIndex"},
                           {{al, r13, r12, plus, 161, PreIndex},
                            false,
                            al,
                            "al r13 r12 plus 161 PreIndex",
                            "al_r13_r12_plus_161_PreIndex"},
                           {{al, r4, r13, minus, 132, PreIndex},
                            false,
                            al,
                            "al r4 r13 minus 132 PreIndex",
                            "al_r4_r13_minus_132_PreIndex"},
                           {{al, r11, r3, minus, 116, PostIndex},
                            false,
                            al,
                            "al r11 r3 minus 116 PostIndex",
                            "al_r11_r3_minus_116_PostIndex"},
                           {{al, r11, r14, minus, 116, PreIndex},
                            false,
                            al,
                            "al r11 r14 minus 116 PreIndex",
                            "al_r11_r14_minus_116_PreIndex"},
                           {{al, r7, r1, plus, 13, PostIndex},
                            false,
                            al,
                            "al r7 r1 plus 13 PostIndex",
                            "al_r7_r1_plus_13_PostIndex"},
                           {{al, r8, r4, minus, 198, PreIndex},
                            false,
                            al,
                            "al r8 r4 minus 198 PreIndex",
                            "al_r8_r4_minus_198_PreIndex"},
                           {{al, r0, r4, plus, 135, PostIndex},
                            false,
                            al,
                            "al r0 r4 plus 135 PostIndex",
                            "al_r0_r4_plus_135_PostIndex"},
                           {{al, r11, r3, minus, 107, PreIndex},
                            false,
                            al,
                            "al r11 r3 minus 107 PreIndex",
                            "al_r11_r3_minus_107_PreIndex"},
                           {{al, r13, r6, plus, 211, PostIndex},
                            false,
                            al,
                            "al r13 r6 plus 211 PostIndex",
                            "al_r13_r6_plus_211_PostIndex"},
                           {{al, r11, r8, plus, 32, PostIndex},
                            false,
                            al,
                            "al r11 r8 plus 32 PostIndex",
                            "al_r11_r8_plus_32_PostIndex"},
                           {{al, r7, r6, plus, 83, PreIndex},
                            false,
                            al,
                            "al r7 r6 plus 83 PreIndex",
                            "al_r7_r6_plus_83_PreIndex"},
                           {{al, r0, r13, minus, 79, PostIndex},
                            false,
                            al,
                            "al r0 r13 minus 79 PostIndex",
                            "al_r0_r13_minus_79_PostIndex"},
                           {{al, r2, r1, minus, 124, PreIndex},
                            false,
                            al,
                            "al r2 r1 minus 124 PreIndex",
                            "al_r2_r1_minus_124_PreIndex"},
                           {{al, r5, r10, plus, 91, PostIndex},
                            false,
                            al,
                            "al r5 r10 plus 91 PostIndex",
                            "al_r5_r10_plus_91_PostIndex"},
                           {{al, r5, r4, minus, 138, PreIndex},
                            false,
                            al,
                            "al r5 r4 minus 138 PreIndex",
                            "al_r5_r4_minus_138_PreIndex"},
                           {{al, r10, r12, plus, 78, PostIndex},
                            false,
                            al,
                            "al r10 r12 plus 78 PostIndex",
                            "al_r10_r12_plus_78_PostIndex"},
                           {{al, r0, r2, plus, 57, PreIndex},
                            false,
                            al,
                            "al r0 r2 plus 57 PreIndex",
                            "al_r0_r2_plus_57_PreIndex"},
                           {{al, r2, r0, plus, 58, PostIndex},
                            false,
                            al,
                            "al r2 r0 plus 58 PostIndex",
                            "al_r2_r0_plus_58_PostIndex"},
                           {{al, r10, r5, plus, 249, PreIndex},
                            false,
                            al,
                            "al r10 r5 plus 249 PreIndex",
                            "al_r10_r5_plus_249_PreIndex"},
                           {{al, r11, r8, minus, 122, PostIndex},
                            false,
                            al,
                            "al r11 r8 minus 122 PostIndex",
                            "al_r11_r8_minus_122_PostIndex"},
                           {{al, r5, r4, minus, 163, PreIndex},
                            false,
                            al,
                            "al r5 r4 minus 163 PreIndex",
                            "al_r5_r4_minus_163_PreIndex"},
                           {{al, r6, r14, plus, 130, PreIndex},
                            false,
                            al,
                            "al r6 r14 plus 130 PreIndex",
                            "al_r6_r14_plus_130_PreIndex"},
                           {{al, r0, r9, plus, 175, PreIndex},
                            false,
                            al,
                            "al r0 r9 plus 175 PreIndex",
                            "al_r0_r9_plus_175_PreIndex"},
                           {{al, r6, r9, minus, 79, PostIndex},
                            false,
                            al,
                            "al r6 r9 minus 79 PostIndex",
                            "al_r6_r9_minus_79_PostIndex"},
                           {{al, r0, r2, plus, 14, PreIndex},
                            false,
                            al,
                            "al r0 r2 plus 14 PreIndex",
                            "al_r0_r2_plus_14_PreIndex"},
                           {{al, r9, r4, minus, 129, PreIndex},
                            false,
                            al,
                            "al r9 r4 minus 129 PreIndex",
                            "al_r9_r4_minus_129_PreIndex"},
                           {{al, r11, r0, minus, 179, PreIndex},
                            false,
                            al,
                            "al r11 r0 minus 179 PreIndex",
                            "al_r11_r0_minus_179_PreIndex"},
                           {{al, r2, r11, minus, 100, PreIndex},
                            false,
                            al,
                            "al r2 r11 minus 100 PreIndex",
                            "al_r2_r11_minus_100_PreIndex"},
                           {{al, r3, r11, minus, 246, PostIndex},
                            false,
                            al,
                            "al r3 r11 minus 246 PostIndex",
                            "al_r3_r11_minus_246_PostIndex"},
                           {{al, r1, r4, minus, 38, PostIndex},
                            false,
                            al,
                            "al r1 r4 minus 38 PostIndex",
                            "al_r1_r4_minus_38_PostIndex"},
                           {{al, r12, r14, plus, 216, PreIndex},
                            false,
                            al,
                            "al r12 r14 plus 216 PreIndex",
                            "al_r12_r14_plus_216_PreIndex"},
                           {{al, r13, r5, minus, 37, PreIndex},
                            false,
                            al,
                            "al r13 r5 minus 37 PreIndex",
                            "al_r13_r5_minus_37_PreIndex"},
                           {{al, r9, r10, minus, 90, PostIndex},
                            false,
                            al,
                            "al r9 r10 minus 90 PostIndex",
                            "al_r9_r10_minus_90_PostIndex"},
                           {{al, r1, r14, plus, 115, PostIndex},
                            false,
                            al,
                            "al r1 r14 plus 115 PostIndex",
                            "al_r1_r14_plus_115_PostIndex"},
                           {{al, r0, r13, plus, 194, PostIndex},
                            false,
                            al,
                            "al r0 r13 plus 194 PostIndex",
                            "al_r0_r13_plus_194_PostIndex"},
                           {{al, r13, r14, minus, 162, PreIndex},
                            false,
                            al,
                            "al r13 r14 minus 162 PreIndex",
                            "al_r13_r14_minus_162_PreIndex"},
                           {{al, r2, r3, minus, 251, PostIndex},
                            false,
                            al,
                            "al r2 r3 minus 251 PostIndex",
                            "al_r2_r3_minus_251_PostIndex"},
                           {{al, r2, r3, plus, 190, PostIndex},
                            false,
                            al,
                            "al r2 r3 plus 190 PostIndex",
                            "al_r2_r3_plus_190_PostIndex"},
                           {{al, r0, r13, minus, 47, PostIndex},
                            false,
                            al,
                            "al r0 r13 minus 47 PostIndex",
                            "al_r0_r13_minus_47_PostIndex"},
                           {{al, r14, r4, minus, 59, PostIndex},
                            false,
                            al,
                            "al r14 r4 minus 59 PostIndex",
                            "al_r14_r4_minus_59_PostIndex"},
                           {{al, r10, r0, plus, 62, PreIndex},
                            false,
                            al,
                            "al r10 r0 plus 62 PreIndex",
                            "al_r10_r0_plus_62_PreIndex"},
                           {{al, r1, r14, minus, 239, PostIndex},
                            false,
                            al,
                            "al r1 r14 minus 239 PostIndex",
                            "al_r1_r14_minus_239_PostIndex"},
                           {{al, r4, r3, minus, 29, PostIndex},
                            false,
                            al,
                            "al r4 r3 minus 29 PostIndex",
                            "al_r4_r3_minus_29_PostIndex"},
                           {{al, r4, r14, plus, 174, PreIndex},
                            false,
                            al,
                            "al r4 r14 plus 174 PreIndex",
                            "al_r4_r14_plus_174_PreIndex"},
                           {{al, r7, r5, minus, 167, PostIndex},
                            false,
                            al,
                            "al r7 r5 minus 167 PostIndex",
                            "al_r7_r5_minus_167_PostIndex"},
                           {{al, r5, r11, minus, 46, PreIndex},
                            false,
                            al,
                            "al r5 r11 minus 46 PreIndex",
                            "al_r5_r11_minus_46_PreIndex"},
                           {{al, r3, r13, plus, 13, PostIndex},
                            false,
                            al,
                            "al r3 r13 plus 13 PostIndex",
                            "al_r3_r13_plus_13_PostIndex"},
                           {{al, r3, r7, plus, 10, PreIndex},
                            false,
                            al,
                            "al r3 r7 plus 10 PreIndex",
                            "al_r3_r7_plus_10_PreIndex"},
                           {{al, r4, r5, minus, 95, PostIndex},
                            false,
                            al,
                            "al r4 r5 minus 95 PostIndex",
                            "al_r4_r5_minus_95_PostIndex"},
                           {{al, r11, r8, minus, 17, PostIndex},
                            false,
                            al,
                            "al r11 r8 minus 17 PostIndex",
                            "al_r11_r8_minus_17_PostIndex"},
                           {{al, r2, r10, plus, 72, PostIndex},
                            false,
                            al,
                            "al r2 r10 plus 72 PostIndex",
                            "al_r2_r10_plus_72_PostIndex"},
                           {{al, r0, r12, minus, 6, PostIndex},
                            false,
                            al,
                            "al r0 r12 minus 6 PostIndex",
                            "al_r0_r12_minus_6_PostIndex"},
                           {{al, r14, r4, plus, 232, PostIndex},
                            false,
                            al,
                            "al r14 r4 plus 232 PostIndex",
                            "al_r14_r4_plus_232_PostIndex"},
                           {{al, r6, r9, plus, 62, PostIndex},
                            false,
                            al,
                            "al r6 r9 plus 62 PostIndex",
                            "al_r6_r9_plus_62_PostIndex"},
                           {{al, r6, r14, minus, 251, PreIndex},
                            false,
                            al,
                            "al r6 r14 minus 251 PreIndex",
                            "al_r6_r14_minus_251_PreIndex"},
                           {{al, r10, r3, plus, 213, PostIndex},
                            false,
                            al,
                            "al r10 r3 plus 213 PostIndex",
                            "al_r10_r3_plus_213_PostIndex"},
                           {{al, r4, r5, plus, 95, PreIndex},
                            false,
                            al,
                            "al r4 r5 plus 95 PreIndex",
                            "al_r4_r5_plus_95_PreIndex"},
                           {{al, r13, r12, plus, 90, PreIndex},
                            false,
                            al,
                            "al r13 r12 plus 90 PreIndex",
                            "al_r13_r12_plus_90_PreIndex"},
                           {{al, r1, r8, minus, 117, PostIndex},
                            false,
                            al,
                            "al r1 r8 minus 117 PostIndex",
                            "al_r1_r8_minus_117_PostIndex"},
                           {{al, r13, r3, minus, 9, PreIndex},
                            false,
                            al,
                            "al r13 r3 minus 9 PreIndex",
                            "al_r13_r3_minus_9_PreIndex"},
                           {{al, r6, r4, plus, 174, PostIndex},
                            false,
                            al,
                            "al r6 r4 plus 174 PostIndex",
                            "al_r6_r4_plus_174_PostIndex"},
                           {{al, r14, r10, plus, 85, PostIndex},
                            false,
                            al,
                            "al r14 r10 plus 85 PostIndex",
                            "al_r14_r10_plus_85_PostIndex"},
                           {{al, r10, r3, plus, 77, PostIndex},
                            false,
                            al,
                            "al r10 r3 plus 77 PostIndex",
                            "al_r10_r3_plus_77_PostIndex"},
                           {{al, r8, r12, minus, 124, PostIndex},
                            false,
                            al,
                            "al r8 r12 minus 124 PostIndex",
                            "al_r8_r12_minus_124_PostIndex"},
                           {{al, r0, r2, minus, 66, PostIndex},
                            false,
                            al,
                            "al r0 r2 minus 66 PostIndex",
                            "al_r0_r2_minus_66_PostIndex"},
                           {{al, r6, r0, minus, 121, PreIndex},
                            false,
                            al,
                            "al r6 r0 minus 121 PreIndex",
                            "al_r6_r0_minus_121_PreIndex"},
                           {{al, r1, r4, minus, 10, PostIndex},
                            false,
                            al,
                            "al r1 r4 minus 10 PostIndex",
                            "al_r1_r4_minus_10_PostIndex"},
                           {{al, r0, r5, plus, 35, PreIndex},
                            false,
                            al,
                            "al r0 r5 plus 35 PreIndex",
                            "al_r0_r5_plus_35_PreIndex"},
                           {{al, r11, r2, plus, 76, PostIndex},
                            false,
                            al,
                            "al r11 r2 plus 76 PostIndex",
                            "al_r11_r2_plus_76_PostIndex"},
                           {{al, r4, r13, plus, 162, PreIndex},
                            false,
                            al,
                            "al r4 r13 plus 162 PreIndex",
                            "al_r4_r13_plus_162_PreIndex"},
                           {{al, r9, r4, plus, 219, PreIndex},
                            false,
                            al,
                            "al r9 r4 plus 219 PreIndex",
                            "al_r9_r4_plus_219_PreIndex"},
                           {{al, r2, r3, plus, 92, PreIndex},
                            false,
                            al,
                            "al r2 r3 plus 92 PreIndex",
                            "al_r2_r3_plus_92_PreIndex"},
                           {{al, r4, r0, plus, 173, PostIndex},
                            false,
                            al,
                            "al r4 r0 plus 173 PostIndex",
                            "al_r4_r0_plus_173_PostIndex"},
                           {{al, r0, r4, minus, 92, PreIndex},
                            false,
                            al,
                            "al r0 r4 minus 92 PreIndex",
                            "al_r0_r4_minus_92_PreIndex"},
                           {{al, r1, r4, plus, 198, PreIndex},
                            false,
                            al,
                            "al r1 r4 plus 198 PreIndex",
                            "al_r1_r4_plus_198_PreIndex"},
                           {{al, r4, r11, plus, 164, PreIndex},
                            false,
                            al,
                            "al r4 r11 plus 164 PreIndex",
                            "al_r4_r11_plus_164_PreIndex"},
                           {{al, r10, r3, plus, 29, PreIndex},
                            false,
                            al,
                            "al r10 r3 plus 29 PreIndex",
                            "al_r10_r3_plus_29_PreIndex"},
                           {{al, r0, r4, plus, 129, PreIndex},
                            false,
                            al,
                            "al r0 r4 plus 129 PreIndex",
                            "al_r0_r4_plus_129_PreIndex"},
                           {{al, r14, r8, plus, 120, PreIndex},
                            false,
                            al,
                            "al r14 r8 plus 120 PreIndex",
                            "al_r14_r8_plus_120_PreIndex"},
                           {{al, r11, r10, plus, 187, PostIndex},
                            false,
                            al,
                            "al r11 r10 plus 187 PostIndex",
                            "al_r11_r10_plus_187_PostIndex"},
                           {{al, r2, r0, plus, 69, PostIndex},
                            false,
                            al,
                            "al r2 r0 plus 69 PostIndex",
                            "al_r2_r0_plus_69_PostIndex"},
                           {{al, r9, r7, plus, 130, PreIndex},
                            false,
                            al,
                            "al r9 r7 plus 130 PreIndex",
                            "al_r9_r7_plus_130_PreIndex"},
                           {{al, r10, r5, minus, 59, PreIndex},
                            false,
                            al,
                            "al r10 r5 minus 59 PreIndex",
                            "al_r10_r5_minus_59_PreIndex"},
                           {{al, r13, r2, plus, 196, PreIndex},
                            false,
                            al,
                            "al r13 r2 plus 196 PreIndex",
                            "al_r13_r2_plus_196_PreIndex"},
                           {{al, r12, r6, plus, 27, PreIndex},
                            false,
                            al,
                            "al r12 r6 plus 27 PreIndex",
                            "al_r12_r6_plus_27_PreIndex"},
                           {{al, r9, r0, plus, 30, PostIndex},
                            false,
                            al,
                            "al r9 r0 plus 30 PostIndex",
                            "al_r9_r0_plus_30_PostIndex"},
                           {{al, r8, r11, plus, 208, PostIndex},
                            false,
                            al,
                            "al r8 r11 plus 208 PostIndex",
                            "al_r8_r11_plus_208_PostIndex"},
                           {{al, r6, r10, plus, 150, PostIndex},
                            false,
                            al,
                            "al r6 r10 plus 150 PostIndex",
                            "al_r6_r10_plus_150_PostIndex"},
                           {{al, r3, r9, plus, 115, PostIndex},
                            false,
                            al,
                            "al r3 r9 plus 115 PostIndex",
                            "al_r3_r9_plus_115_PostIndex"},
                           {{al, r2, r14, minus, 65, PreIndex},
                            false,
                            al,
                            "al r2 r14 minus 65 PreIndex",
                            "al_r2_r14_minus_65_PreIndex"},
                           {{al, r12, r9, plus, 150, PreIndex},
                            false,
                            al,
                            "al r12 r9 plus 150 PreIndex",
                            "al_r12_r9_plus_150_PreIndex"},
                           {{al, r2, r11, plus, 153, PostIndex},
                            false,
                            al,
                            "al r2 r11 plus 153 PostIndex",
                            "al_r2_r11_plus_153_PostIndex"},
                           {{al, r4, r11, minus, 80, PostIndex},
                            false,
                            al,
                            "al r4 r11 minus 80 PostIndex",
                            "al_r4_r11_minus_80_PostIndex"},
                           {{al, r8, r11, minus, 164, PostIndex},
                            false,
                            al,
                            "al r8 r11 minus 164 PostIndex",
                            "al_r8_r11_minus_164_PostIndex"},
                           {{al, r8, r9, plus, 140, PreIndex},
                            false,
                            al,
                            "al r8 r9 plus 140 PreIndex",
                            "al_r8_r9_plus_140_PreIndex"},
                           {{al, r4, r1, minus, 237, PreIndex},
                            false,
                            al,
                            "al r4 r1 minus 237 PreIndex",
                            "al_r4_r1_minus_237_PreIndex"},
                           {{al, r9, r4, plus, 16, PostIndex},
                            false,
                            al,
                            "al r9 r4 plus 16 PostIndex",
                            "al_r9_r4_plus_16_PostIndex"},
                           {{al, r13, r6, plus, 248, PreIndex},
                            false,
                            al,
                            "al r13 r6 plus 248 PreIndex",
                            "al_r13_r6_plus_248_PreIndex"},
                           {{al, r9, r12, plus, 196, PostIndex},
                            false,
                            al,
                            "al r9 r12 plus 196 PostIndex",
                            "al_r9_r12_plus_196_PostIndex"},
                           {{al, r2, r1, plus, 68, PostIndex},
                            false,
                            al,
                            "al r2 r1 plus 68 PostIndex",
                            "al_r2_r1_plus_68_PostIndex"},
                           {{al, r1, r2, minus, 106, PreIndex},
                            false,
                            al,
                            "al r1 r2 minus 106 PreIndex",
                            "al_r1_r2_minus_106_PreIndex"},
                           {{al, r3, r9, minus, 21, PreIndex},
                            false,
                            al,
                            "al r3 r9 minus 21 PreIndex",
                            "al_r3_r9_minus_21_PreIndex"},
                           {{al, r13, r3, plus, 39, PreIndex},
                            false,
                            al,
                            "al r13 r3 plus 39 PreIndex",
                            "al_r13_r3_plus_39_PreIndex"},
                           {{al, r2, r11, plus, 75, PostIndex},
                            false,
                            al,
                            "al r2 r11 plus 75 PostIndex",
                            "al_r2_r11_plus_75_PostIndex"},
                           {{al, r5, r3, minus, 136, PostIndex},
                            false,
                            al,
                            "al r5 r3 minus 136 PostIndex",
                            "al_r5_r3_minus_136_PostIndex"},
                           {{al, r12, r13, minus, 229, PreIndex},
                            false,
                            al,
                            "al r12 r13 minus 229 PreIndex",
                            "al_r12_r13_minus_229_PreIndex"},
                           {{al, r9, r5, plus, 130, PostIndex},
                            false,
                            al,
                            "al r9 r5 plus 130 PostIndex",
                            "al_r9_r5_plus_130_PostIndex"},
                           {{al, r2, r5, plus, 206, PostIndex},
                            false,
                            al,
                            "al r2 r5 plus 206 PostIndex",
                            "al_r2_r5_plus_206_PostIndex"},
                           {{al, r4, r6, minus, 6, PreIndex},
                            false,
                            al,
                            "al r4 r6 minus 6 PreIndex",
                            "al_r4_r6_minus_6_PreIndex"},
                           {{al, r14, r13, plus, 113, PreIndex},
                            false,
                            al,
                            "al r14 r13 plus 113 PreIndex",
                            "al_r14_r13_plus_113_PreIndex"},
                           {{al, r1, r5, plus, 128, PostIndex},
                            false,
                            al,
                            "al r1 r5 plus 128 PostIndex",
                            "al_r1_r5_plus_128_PostIndex"},
                           {{al, r2, r4, plus, 171, PostIndex},
                            false,
                            al,
                            "al r2 r4 plus 171 PostIndex",
                            "al_r2_r4_plus_171_PostIndex"},
                           {{al, r6, r0, minus, 125, PostIndex},
                            false,
                            al,
                            "al r6 r0 minus 125 PostIndex",
                            "al_r6_r0_minus_125_PostIndex"},
                           {{al, r14, r12, plus, 224, PostIndex},
                            false,
                            al,
                            "al r14 r12 plus 224 PostIndex",
                            "al_r14_r12_plus_224_PostIndex"},
                           {{al, r12, r6, minus, 185, PreIndex},
                            false,
                            al,
                            "al r12 r6 minus 185 PreIndex",
                            "al_r12_r6_minus_185_PreIndex"},
                           {{al, r6, r0, plus, 143, PostIndex},
                            false,
                            al,
                            "al r6 r0 plus 143 PostIndex",
                            "al_r6_r0_plus_143_PostIndex"},
                           {{al, r4, r13, plus, 219, PostIndex},
                            false,
                            al,
                            "al r4 r13 plus 219 PostIndex",
                            "al_r4_r13_plus_219_PostIndex"},
                           {{al, r13, r0, plus, 187, PostIndex},
                            false,
                            al,
                            "al r13 r0 plus 187 PostIndex",
                            "al_r13_r0_plus_187_PostIndex"},
                           {{al, r14, r0, plus, 103, PreIndex},
                            false,
                            al,
                            "al r14 r0 plus 103 PreIndex",
                            "al_r14_r0_plus_103_PreIndex"},
                           {{al, r5, r2, minus, 73, PostIndex},
                            false,
                            al,
                            "al r5 r2 minus 73 PostIndex",
                            "al_r5_r2_minus_73_PostIndex"},
                           {{al, r3, r11, plus, 109, PostIndex},
                            false,
                            al,
                            "al r3 r11 plus 109 PostIndex",
                            "al_r3_r11_plus_109_PostIndex"},
                           {{al, r2, r5, plus, 22, PreIndex},
                            false,
                            al,
                            "al r2 r5 plus 22 PreIndex",
                            "al_r2_r5_plus_22_PreIndex"},
                           {{al, r13, r5, minus, 123, PostIndex},
                            false,
                            al,
                            "al r13 r5 minus 123 PostIndex",
                            "al_r13_r5_minus_123_PostIndex"},
                           {{al, r14, r5, minus, 133, PreIndex},
                            false,
                            al,
                            "al r14 r5 minus 133 PreIndex",
                            "al_r14_r5_minus_133_PreIndex"},
                           {{al, r10, r11, minus, 226, PostIndex},
                            false,
                            al,
                            "al r10 r11 minus 226 PostIndex",
                            "al_r10_r11_minus_226_PostIndex"},
                           {{al, r3, r6, plus, 175, PostIndex},
                            false,
                            al,
                            "al r3 r6 plus 175 PostIndex",
                            "al_r3_r6_plus_175_PostIndex"},
                           {{al, r0, r11, minus, 6, PreIndex},
                            false,
                            al,
                            "al r0 r11 minus 6 PreIndex",
                            "al_r0_r11_minus_6_PreIndex"},
                           {{al, r7, r1, plus, 170, PostIndex},
                            false,
                            al,
                            "al r7 r1 plus 170 PostIndex",
                            "al_r7_r1_plus_170_PostIndex"},
                           {{al, r12, r7, plus, 107, PostIndex},
                            false,
                            al,
                            "al r12 r7 plus 107 PostIndex",
                            "al_r12_r7_plus_107_PostIndex"},
                           {{al, r8, r11, minus, 109, PostIndex},
                            false,
                            al,
                            "al r8 r11 minus 109 PostIndex",
                            "al_r8_r11_minus_109_PostIndex"},
                           {{al, r8, r0, minus, 93, PreIndex},
                            false,
                            al,
                            "al r8 r0 minus 93 PreIndex",
                            "al_r8_r0_minus_93_PreIndex"},
                           {{al, r9, r3, minus, 152, PostIndex},
                            false,
                            al,
                            "al r9 r3 minus 152 PostIndex",
                            "al_r9_r3_minus_152_PostIndex"},
                           {{al, r9, r12, minus, 233, PostIndex},
                            false,
                            al,
                            "al r9 r12 minus 233 PostIndex",
                            "al_r9_r12_minus_233_PostIndex"},
                           {{al, r5, r2, minus, 122, PostIndex},
                            false,
                            al,
                            "al r5 r2 minus 122 PostIndex",
                            "al_r5_r2_minus_122_PostIndex"},
                           {{al, r2, r9, plus, 248, PostIndex},
                            false,
                            al,
                            "al r2 r9 plus 248 PostIndex",
                            "al_r2_r9_plus_248_PostIndex"},
                           {{al, r2, r14, minus, 137, PreIndex},
                            false,
                            al,
                            "al r2 r14 minus 137 PreIndex",
                            "al_r2_r14_minus_137_PreIndex"},
                           {{al, r10, r12, plus, 19, PreIndex},
                            false,
                            al,
                            "al r10 r12 plus 19 PreIndex",
                            "al_r10_r12_plus_19_PreIndex"},
                           {{al, r7, r10, plus, 116, PostIndex},
                            false,
                            al,
                            "al r7 r10 plus 116 PostIndex",
                            "al_r7_r10_plus_116_PostIndex"},
                           {{al, r11, r8, minus, 46, PreIndex},
                            false,
                            al,
                            "al r11 r8 minus 46 PreIndex",
                            "al_r11_r8_minus_46_PreIndex"},
                           {{al, r4, r9, minus, 16, PreIndex},
                            false,
                            al,
                            "al r4 r9 minus 16 PreIndex",
                            "al_r4_r9_minus_16_PreIndex"},
                           {{al, r8, r9, minus, 74, PostIndex},
                            false,
                            al,
                            "al r8 r9 minus 74 PostIndex",
                            "al_r8_r9_minus_74_PostIndex"},
                           {{al, r13, r9, minus, 7, PostIndex},
                            false,
                            al,
                            "al r13 r9 minus 7 PostIndex",
                            "al_r13_r9_minus_7_PostIndex"},
                           {{al, r7, r6, plus, 100, PostIndex},
                            false,
                            al,
                            "al r7 r6 plus 100 PostIndex",
                            "al_r7_r6_plus_100_PostIndex"},
                           {{al, r13, r1, minus, 217, PostIndex},
                            false,
                            al,
                            "al r13 r1 minus 217 PostIndex",
                            "al_r13_r1_minus_217_PostIndex"},
                           {{al, r5, r0, plus, 219, PreIndex},
                            false,
                            al,
                            "al r5 r0 plus 219 PreIndex",
                            "al_r5_r0_plus_219_PreIndex"},
                           {{al, r9, r1, minus, 148, PreIndex},
                            false,
                            al,
                            "al r9 r1 minus 148 PreIndex",
                            "al_r9_r1_minus_148_PreIndex"},
                           {{al, r0, r8, plus, 211, PreIndex},
                            false,
                            al,
                            "al r0 r8 plus 211 PreIndex",
                            "al_r0_r8_plus_211_PreIndex"},
                           {{al, r9, r6, plus, 82, PreIndex},
                            false,
                            al,
                            "al r9 r6 plus 82 PreIndex",
                            "al_r9_r6_plus_82_PreIndex"},
                           {{al, r0, r1, minus, 222, PreIndex},
                            false,
                            al,
                            "al r0 r1 minus 222 PreIndex",
                            "al_r0_r1_minus_222_PreIndex"},
                           {{al, r3, r1, plus, 225, PostIndex},
                            false,
                            al,
                            "al r3 r1 plus 225 PostIndex",
                            "al_r3_r1_plus_225_PostIndex"},
                           {{al, r5, r2, minus, 28, PostIndex},
                            false,
                            al,
                            "al r5 r2 minus 28 PostIndex",
                            "al_r5_r2_minus_28_PostIndex"},
                           {{al, r7, r5, minus, 24, PostIndex},
                            false,
                            al,
                            "al r7 r5 minus 24 PostIndex",
                            "al_r7_r5_minus_24_PostIndex"},
                           {{al, r4, r8, minus, 55, PreIndex},
                            false,
                            al,
                            "al r4 r8 minus 55 PreIndex",
                            "al_r4_r8_minus_55_PreIndex"},
                           {{al, r6, r14, minus, 90, PostIndex},
                            false,
                            al,
                            "al r6 r14 minus 90 PostIndex",
                            "al_r6_r14_minus_90_PostIndex"},
                           {{al, r3, r0, minus, 158, PreIndex},
                            false,
                            al,
                            "al r3 r0 minus 158 PreIndex",
                            "al_r3_r0_minus_158_PreIndex"},
                           {{al, r10, r8, plus, 239, PostIndex},
                            false,
                            al,
                            "al r10 r8 plus 239 PostIndex",
                            "al_r10_r8_plus_239_PostIndex"},
                           {{al, r4, r5, plus, 185, PostIndex},
                            false,
                            al,
                            "al r4 r5 plus 185 PostIndex",
                            "al_r4_r5_plus_185_PostIndex"},
                           {{al, r5, r3, minus, 34, PreIndex},
                            false,
                            al,
                            "al r5 r3 minus 34 PreIndex",
                            "al_r5_r3_minus_34_PreIndex"},
                           {{al, r11, r0, minus, 129, PostIndex},
                            false,
                            al,
                            "al r11 r0 minus 129 PostIndex",
                            "al_r11_r0_minus_129_PostIndex"},
                           {{al, r2, r9, minus, 175, PreIndex},
                            false,
                            al,
                            "al r2 r9 minus 175 PreIndex",
                            "al_r2_r9_minus_175_PreIndex"},
                           {{al, r2, r13, plus, 87, PreIndex},
                            false,
                            al,
                            "al r2 r13 plus 87 PreIndex",
                            "al_r2_r13_plus_87_PreIndex"},
                           {{al, r8, r7, plus, 34, PostIndex},
                            false,
                            al,
                            "al r8 r7 plus 34 PostIndex",
                            "al_r8_r7_plus_34_PostIndex"},
                           {{al, r3, r1, minus, 124, PostIndex},
                            false,
                            al,
                            "al r3 r1 minus 124 PostIndex",
                            "al_r3_r1_minus_124_PostIndex"},
                           {{al, r12, r0, minus, 163, PostIndex},
                            false,
                            al,
                            "al r12 r0 minus 163 PostIndex",
                            "al_r12_r0_minus_163_PostIndex"},
                           {{al, r9, r11, minus, 88, PostIndex},
                            false,
                            al,
                            "al r9 r11 minus 88 PostIndex",
                            "al_r9_r11_minus_88_PostIndex"},
                           {{al, r11, r13, minus, 143, PostIndex},
                            false,
                            al,
                            "al r11 r13 minus 143 PostIndex",
                            "al_r11_r13_minus_143_PostIndex"},
                           {{al, r6, r12, plus, 247, PostIndex},
                            false,
                            al,
                            "al r6 r12 plus 247 PostIndex",
                            "al_r6_r12_plus_247_PostIndex"},
                           {{al, r4, r1, plus, 47, PostIndex},
                            false,
                            al,
                            "al r4 r1 plus 47 PostIndex",
                            "al_r4_r1_plus_47_PostIndex"},
                           {{al, r5, r2, plus, 228, PreIndex},
                            false,
                            al,
                            "al r5 r2 plus 228 PreIndex",
                            "al_r5_r2_plus_228_PreIndex"},
                           {{al, r6, r13, minus, 200, PreIndex},
                            false,
                            al,
                            "al r6 r13 minus 200 PreIndex",
                            "al_r6_r13_minus_200_PreIndex"},
                           {{al, r10, r0, plus, 188, PreIndex},
                            false,
                            al,
                            "al r10 r0 plus 188 PreIndex",
                            "al_r10_r0_plus_188_PreIndex"},
                           {{al, r12, r9, plus, 19, PostIndex},
                            false,
                            al,
                            "al r12 r9 plus 19 PostIndex",
                            "al_r12_r9_plus_19_PostIndex"},
                           {{al, r3, r6, minus, 184, PostIndex},
                            false,
                            al,
                            "al r3 r6 minus 184 PostIndex",
                            "al_r3_r6_minus_184_PostIndex"},
                           {{al, r12, r10, plus, 229, PostIndex},
                            false,
                            al,
                            "al r12 r10 plus 229 PostIndex",
                            "al_r12_r10_plus_229_PostIndex"},
                           {{al, r5, r3, minus, 179, PreIndex},
                            false,
                            al,
                            "al r5 r3 minus 179 PreIndex",
                            "al_r5_r3_minus_179_PreIndex"},
                           {{al, r12, r9, plus, 120, PostIndex},
                            false,
                            al,
                            "al r12 r9 plus 120 PostIndex",
                            "al_r12_r9_plus_120_PostIndex"},
                           {{al, r9, r10, plus, 143, PreIndex},
                            false,
                            al,
                            "al r9 r10 plus 143 PreIndex",
                            "al_r9_r10_plus_143_PreIndex"},
                           {{al, r1, r2, minus, 148, PostIndex},
                            false,
                            al,
                            "al r1 r2 minus 148 PostIndex",
                            "al_r1_r2_minus_148_PostIndex"},
                           {{al, r7, r1, plus, 210, PreIndex},
                            false,
                            al,
                            "al r7 r1 plus 210 PreIndex",
                            "al_r7_r1_plus_210_PreIndex"},
                           {{al, r5, r12, plus, 208, PreIndex},
                            false,
                            al,
                            "al r5 r12 plus 208 PreIndex",
                            "al_r5_r12_plus_208_PreIndex"},
                           {{al, r1, r8, plus, 6, PreIndex},
                            false,
                            al,
                            "al r1 r8 plus 6 PreIndex",
                            "al_r1_r8_plus_6_PreIndex"},
                           {{al, r9, r6, minus, 106, PreIndex},
                            false,
                            al,
                            "al r9 r6 minus 106 PreIndex",
                            "al_r9_r6_minus_106_PreIndex"},
                           {{al, r1, r9, minus, 59, PostIndex},
                            false,
                            al,
                            "al r1 r9 minus 59 PostIndex",
                            "al_r1_r9_minus_59_PostIndex"},
                           {{al, r6, r11, minus, 18, PreIndex},
                            false,
                            al,
                            "al r6 r11 minus 18 PreIndex",
                            "al_r6_r11_minus_18_PreIndex"},
                           {{al, r2, r7, plus, 19, PreIndex},
                            false,
                            al,
                            "al r2 r7 plus 19 PreIndex",
                            "al_r2_r7_plus_19_PreIndex"},
                           {{al, r12, r5, minus, 229, PreIndex},
                            false,
                            al,
                            "al r12 r5 minus 229 PreIndex",
                            "al_r12_r5_minus_229_PreIndex"},
                           {{al, r8, r5, minus, 60, PostIndex},
                            false,
                            al,
                            "al r8 r5 minus 60 PostIndex",
                            "al_r8_r5_minus_60_PostIndex"},
                           {{al, r9, r8, minus, 125, PreIndex},
                            false,
                            al,
                            "al r9 r8 minus 125 PreIndex",
                            "al_r9_r8_minus_125_PreIndex"},
                           {{al, r14, r13, plus, 137, PostIndex},
                            false,
                            al,
                            "al r14 r13 plus 137 PostIndex",
                            "al_r14_r13_plus_137_PostIndex"},
                           {{al, r9, r1, plus, 1, PostIndex},
                            false,
                            al,
                            "al r9 r1 plus 1 PostIndex",
                            "al_r9_r1_plus_1_PostIndex"},
                           {{al, r6, r2, plus, 230, PostIndex},
                            false,
                            al,
                            "al r6 r2 plus 230 PostIndex",
                            "al_r6_r2_plus_230_PostIndex"},
                           {{al, r11, r0, plus, 218, PostIndex},
                            false,
                            al,
                            "al r11 r0 plus 218 PostIndex",
                            "al_r11_r0_plus_218_PostIndex"},
                           {{al, r8, r10, plus, 125, PostIndex},
                            false,
                            al,
                            "al r8 r10 plus 125 PostIndex",
                            "al_r8_r10_plus_125_PostIndex"},
                           {{al, r1, r4, plus, 138, PostIndex},
                            false,
                            al,
                            "al r1 r4 plus 138 PostIndex",
                            "al_r1_r4_plus_138_PostIndex"},
                           {{al, r10, r9, minus, 66, PreIndex},
                            false,
                            al,
                            "al r10 r9 minus 66 PreIndex",
                            "al_r10_r9_minus_66_PreIndex"},
                           {{al, r14, r11, plus, 25, PreIndex},
                            false,
                            al,
                            "al r14 r11 plus 25 PreIndex",
                            "al_r14_r11_plus_25_PreIndex"},
                           {{al, r9, r3, minus, 76, PostIndex},
                            false,
                            al,
                            "al r9 r3 minus 76 PostIndex",
                            "al_r9_r3_minus_76_PostIndex"},
                           {{al, r9, r14, plus, 8, PostIndex},
                            false,
                            al,
                            "al r9 r14 plus 8 PostIndex",
                            "al_r9_r14_plus_8_PostIndex"},
                           {{al, r3, r14, plus, 67, PostIndex},
                            false,
                            al,
                            "al r3 r14 plus 67 PostIndex",
                            "al_r3_r14_plus_67_PostIndex"},
                           {{al, r3, r0, minus, 39, PreIndex},
                            false,
                            al,
                            "al r3 r0 minus 39 PreIndex",
                            "al_r3_r0_minus_39_PreIndex"},
                           {{al, r8, r1, minus, 17, PreIndex},
                            false,
                            al,
                            "al r8 r1 minus 17 PreIndex",
                            "al_r8_r1_minus_17_PreIndex"},
                           {{al, r14, r11, minus, 223, PreIndex},
                            false,
                            al,
                            "al r14 r11 minus 223 PreIndex",
                            "al_r14_r11_minus_223_PreIndex"},
                           {{al, r7, r10, plus, 99, PreIndex},
                            false,
                            al,
                            "al r7 r10 plus 99 PreIndex",
                            "al_r7_r10_plus_99_PreIndex"},
                           {{al, r14, r11, minus, 12, PostIndex},
                            false,
                            al,
                            "al r14 r11 minus 12 PostIndex",
                            "al_r14_r11_minus_12_PostIndex"},
                           {{al, r13, r10, minus, 235, PostIndex},
                            false,
                            al,
                            "al r13 r10 minus 235 PostIndex",
                            "al_r13_r10_minus_235_PostIndex"},
                           {{al, r3, r13, minus, 167, PreIndex},
                            false,
                            al,
                            "al r3 r13 minus 167 PreIndex",
                            "al_r3_r13_minus_167_PreIndex"},
                           {{al, r13, r11, plus, 222, PostIndex},
                            false,
                            al,
                            "al r13 r11 plus 222 PostIndex",
                            "al_r13_r11_plus_222_PostIndex"},
                           {{al, r2, r4, minus, 20, PreIndex},
                            false,
                            al,
                            "al r2 r4 minus 20 PreIndex",
                            "al_r2_r4_minus_20_PreIndex"},
                           {{al, r1, r3, plus, 185, PostIndex},
                            false,
                            al,
                            "al r1 r3 plus 185 PostIndex",
                            "al_r1_r3_plus_185_PostIndex"},
                           {{al, r0, r1, plus, 115, PostIndex},
                            false,
                            al,
                            "al r0 r1 plus 115 PostIndex",
                            "al_r0_r1_plus_115_PostIndex"},
                           {{al, r2, r0, plus, 169, PreIndex},
                            false,
                            al,
                            "al r2 r0 plus 169 PreIndex",
                            "al_r2_r0_plus_169_PreIndex"},
                           {{al, r11, r5, plus, 121, PostIndex},
                            false,
                            al,
                            "al r11 r5 plus 121 PostIndex",
                            "al_r11_r5_plus_121_PostIndex"},
                           {{al, r5, r12, minus, 114, PostIndex},
                            false,
                            al,
                            "al r5 r12 minus 114 PostIndex",
                            "al_r5_r12_minus_114_PostIndex"},
                           {{al, r14, r13, minus, 71, PostIndex},
                            false,
                            al,
                            "al r14 r13 minus 71 PostIndex",
                            "al_r14_r13_minus_71_PostIndex"},
                           {{al, r12, r10, plus, 127, PreIndex},
                            false,
                            al,
                            "al r12 r10 plus 127 PreIndex",
                            "al_r12_r10_plus_127_PreIndex"},
                           {{al, r8, r11, minus, 125, PostIndex},
                            false,
                            al,
                            "al r8 r11 minus 125 PostIndex",
                            "al_r8_r11_minus_125_PostIndex"},
                           {{al, r13, r9, plus, 239, PostIndex},
                            false,
                            al,
                            "al r13 r9 plus 239 PostIndex",
                            "al_r13_r9_plus_239_PostIndex"},
                           {{al, r3, r1, plus, 74, PreIndex},
                            false,
                            al,
                            "al r3 r1 plus 74 PreIndex",
                            "al_r3_r1_plus_74_PreIndex"},
                           {{al, r8, r7, minus, 229, PostIndex},
                            false,
                            al,
                            "al r8 r7 minus 229 PostIndex",
                            "al_r8_r7_minus_229_PostIndex"},
                           {{al, r8, r1, plus, 240, PostIndex},
                            false,
                            al,
                            "al r8 r1 plus 240 PostIndex",
                            "al_r8_r1_plus_240_PostIndex"},
                           {{al, r2, r4, minus, 51, PreIndex},
                            false,
                            al,
                            "al r2 r4 minus 51 PreIndex",
                            "al_r2_r4_minus_51_PreIndex"},
                           {{al, r13, r9, minus, 103, PreIndex},
                            false,
                            al,
                            "al r13 r9 minus 103 PreIndex",
                            "al_r13_r9_minus_103_PreIndex"},
                           {{al, r4, r6, minus, 138, PostIndex},
                            false,
                            al,
                            "al r4 r6 minus 138 PostIndex",
                            "al_r4_r6_minus_138_PostIndex"},
                           {{al, r11, r0, minus, 145, PostIndex},
                            false,
                            al,
                            "al r11 r0 minus 145 PostIndex",
                            "al_r11_r0_minus_145_PostIndex"},
                           {{al, r6, r3, plus, 232, PostIndex},
                            false,
                            al,
                            "al r6 r3 plus 232 PostIndex",
                            "al_r6_r3_plus_232_PostIndex"},
                           {{al, r14, r2, plus, 117, PreIndex},
                            false,
                            al,
                            "al r14 r2 plus 117 PreIndex",
                            "al_r14_r2_plus_117_PreIndex"},
                           {{al, r5, r6, plus, 224, PreIndex},
                            false,
                            al,
                            "al r5 r6 plus 224 PreIndex",
                            "al_r5_r6_plus_224_PreIndex"},
                           {{al, r7, r2, minus, 192, PostIndex},
                            false,
                            al,
                            "al r7 r2 minus 192 PostIndex",
                            "al_r7_r2_minus_192_PostIndex"},
                           {{al, r14, r8, plus, 250, PreIndex},
                            false,
                            al,
                            "al r14 r8 plus 250 PreIndex",
                            "al_r14_r8_plus_250_PreIndex"},
                           {{al, r8, r11, minus, 34, PreIndex},
                            false,
                            al,
                            "al r8 r11 minus 34 PreIndex",
                            "al_r8_r11_minus_34_PreIndex"},
                           {{al, r12, r11, minus, 153, PreIndex},
                            false,
                            al,
                            "al r12 r11 minus 153 PreIndex",
                            "al_r12_r11_minus_153_PreIndex"},
                           {{al, r4, r0, minus, 61, PreIndex},
                            false,
                            al,
                            "al r4 r0 minus 61 PreIndex",
                            "al_r4_r0_minus_61_PreIndex"},
                           {{al, r3, r12, plus, 158, PostIndex},
                            false,
                            al,
                            "al r3 r12 plus 158 PostIndex",
                            "al_r3_r12_plus_158_PostIndex"},
                           {{al, r6, r12, plus, 212, PreIndex},
                            false,
                            al,
                            "al r6 r12 plus 212 PreIndex",
                            "al_r6_r12_plus_212_PreIndex"},
                           {{al, r6, r10, plus, 189, PostIndex},
                            false,
                            al,
                            "al r6 r10 plus 189 PostIndex",
                            "al_r6_r10_plus_189_PostIndex"},
                           {{al, r2, r6, plus, 234, PostIndex},
                            false,
                            al,
                            "al r2 r6 plus 234 PostIndex",
                            "al_r2_r6_plus_234_PostIndex"},
                           {{al, r10, r11, minus, 134, PostIndex},
                            false,
                            al,
                            "al r10 r11 minus 134 PostIndex",
                            "al_r10_r11_minus_134_PostIndex"},
                           {{al, r11, r6, minus, 240, PostIndex},
                            false,
                            al,
                            "al r11 r6 minus 240 PostIndex",
                            "al_r11_r6_minus_240_PostIndex"},
                           {{al, r1, r10, minus, 162, PreIndex},
                            false,
                            al,
                            "al r1 r10 minus 162 PreIndex",
                            "al_r1_r10_minus_162_PreIndex"},
                           {{al, r8, r3, plus, 235, PostIndex},
                            false,
                            al,
                            "al r8 r3 plus 235 PostIndex",
                            "al_r8_r3_plus_235_PostIndex"},
                           {{al, r5, r12, plus, 192, PreIndex},
                            false,
                            al,
                            "al r5 r12 plus 192 PreIndex",
                            "al_r5_r12_plus_192_PreIndex"},
                           {{al, r11, r3, minus, 13, PostIndex},
                            false,
                            al,
                            "al r11 r3 minus 13 PostIndex",
                            "al_r11_r3_minus_13_PostIndex"},
                           {{al, r3, r5, plus, 192, PostIndex},
                            false,
                            al,
                            "al r3 r5 plus 192 PostIndex",
                            "al_r3_r5_plus_192_PostIndex"},
                           {{al, r1, r5, plus, 75, PreIndex},
                            false,
                            al,
                            "al r1 r5 plus 75 PreIndex",
                            "al_r1_r5_plus_75_PreIndex"},
                           {{al, r1, r7, plus, 9, PostIndex},
                            false,
                            al,
                            "al r1 r7 plus 9 PostIndex",
                            "al_r1_r7_plus_9_PostIndex"},
                           {{al, r1, r14, plus, 103, PreIndex},
                            false,
                            al,
                            "al r1 r14 plus 103 PreIndex",
                            "al_r1_r14_plus_103_PreIndex"},
                           {{al, r4, r5, plus, 254, PostIndex},
                            false,
                            al,
                            "al r4 r5 plus 254 PostIndex",
                            "al_r4_r5_plus_254_PostIndex"},
                           {{al, r7, r3, plus, 219, PreIndex},
                            false,
                            al,
                            "al r7 r3 plus 219 PreIndex",
                            "al_r7_r3_plus_219_PreIndex"},
                           {{al, r6, r7, minus, 233, PreIndex},
                            false,
                            al,
                            "al r6 r7 minus 233 PreIndex",
                            "al_r6_r7_minus_233_PreIndex"},
                           {{al, r7, r6, plus, 93, PostIndex},
                            false,
                            al,
                            "al r7 r6 plus 93 PostIndex",
                            "al_r7_r6_plus_93_PostIndex"},
                           {{al, r5, r14, plus, 15, PreIndex},
                            false,
                            al,
                            "al r5 r14 plus 15 PreIndex",
                            "al_r5_r14_plus_15_PreIndex"},
                           {{al, r4, r2, plus, 51, PreIndex},
                            false,
                            al,
                            "al r4 r2 plus 51 PreIndex",
                            "al_r4_r2_plus_51_PreIndex"},
                           {{al, r12, r7, plus, 233, PostIndex},
                            false,
                            al,
                            "al r12 r7 plus 233 PostIndex",
                            "al_r12_r7_plus_233_PostIndex"},
                           {{al, r11, r8, plus, 219, PostIndex},
                            false,
                            al,
                            "al r11 r8 plus 219 PostIndex",
                            "al_r11_r8_plus_219_PostIndex"},
                           {{al, r1, r10, minus, 189, PostIndex},
                            false,
                            al,
                            "al r1 r10 minus 189 PostIndex",
                            "al_r1_r10_minus_189_PostIndex"},
                           {{al, r4, r13, minus, 101, PostIndex},
                            false,
                            al,
                            "al r4 r13 minus 101 PostIndex",
                            "al_r4_r13_minus_101_PostIndex"},
                           {{al, r4, r12, minus, 46, PreIndex},
                            false,
                            al,
                            "al r4 r12 minus 46 PreIndex",
                            "al_r4_r12_minus_46_PreIndex"},
                           {{al, r14, r12, minus, 195, PreIndex},
                            false,
                            al,
                            "al r14 r12 minus 195 PreIndex",
                            "al_r14_r12_minus_195_PreIndex"},
                           {{al, r8, r2, minus, 141, PreIndex},
                            false,
                            al,
                            "al r8 r2 minus 141 PreIndex",
                            "al_r8_r2_minus_141_PreIndex"},
                           {{al, r5, r3, plus, 191, PostIndex},
                            false,
                            al,
                            "al r5 r3 plus 191 PostIndex",
                            "al_r5_r3_plus_191_PostIndex"},
                           {{al, r7, r1, plus, 216, PostIndex},
                            false,
                            al,
                            "al r7 r1 plus 216 PostIndex",
                            "al_r7_r1_plus_216_PostIndex"},
                           {{al, r6, r13, minus, 87, PostIndex},
                            false,
                            al,
                            "al r6 r13 minus 87 PostIndex",
                            "al_r6_r13_minus_87_PostIndex"},
                           {{al, r11, r8, minus, 39, PreIndex},
                            false,
                            al,
                            "al r11 r8 minus 39 PreIndex",
                            "al_r11_r8_minus_39_PreIndex"},
                           {{al, r1, r6, minus, 181, PreIndex},
                            false,
                            al,
                            "al r1 r6 minus 181 PreIndex",
                            "al_r1_r6_minus_181_PreIndex"},
                           {{al, r6, r4, plus, 162, PostIndex},
                            false,
                            al,
                            "al r6 r4 plus 162 PostIndex",
                            "al_r6_r4_plus_162_PostIndex"},
                           {{al, r14, r3, minus, 81, PreIndex},
                            false,
                            al,
                            "al r14 r3 minus 81 PreIndex",
                            "al_r14_r3_minus_81_PreIndex"},
                           {{al, r6, r5, plus, 31, PostIndex},
                            false,
                            al,
                            "al r6 r5 plus 31 PostIndex",
                            "al_r6_r5_plus_31_PostIndex"},
                           {{al, r13, r8, plus, 47, PostIndex},
                            false,
                            al,
                            "al r13 r8 plus 47 PostIndex",
                            "al_r13_r8_plus_47_PostIndex"},
                           {{al, r14, r11, plus, 20, PostIndex},
                            false,
                            al,
                            "al r14 r11 plus 20 PostIndex",
                            "al_r14_r11_plus_20_PostIndex"},
                           {{al, r14, r12, minus, 52, PreIndex},
                            false,
                            al,
                            "al r14 r12 minus 52 PreIndex",
                            "al_r14_r12_minus_52_PreIndex"},
                           {{al, r13, r0, plus, 98, PreIndex},
                            false,
                            al,
                            "al r13 r0 plus 98 PreIndex",
                            "al_r13_r0_plus_98_PreIndex"},
                           {{al, r13, r3, minus, 249, PreIndex},
                            false,
                            al,
                            "al r13 r3 minus 249 PreIndex",
                            "al_r13_r3_minus_249_PreIndex"},
                           {{al, r7, r4, minus, 147, PreIndex},
                            false,
                            al,
                            "al r7 r4 minus 147 PreIndex",
                            "al_r7_r4_minus_147_PreIndex"},
                           {{al, r13, r1, plus, 246, PostIndex},
                            false,
                            al,
                            "al r13 r1 plus 246 PostIndex",
                            "al_r13_r1_plus_246_PostIndex"},
                           {{al, r13, r1, minus, 70, PreIndex},
                            false,
                            al,
                            "al r13 r1 minus 70 PreIndex",
                            "al_r13_r1_minus_70_PreIndex"},
                           {{al, r1, r14, plus, 243, PreIndex},
                            false,
                            al,
                            "al r1 r14 plus 243 PreIndex",
                            "al_r1_r14_plus_243_PreIndex"},
                           {{al, r7, r2, minus, 92, PreIndex},
                            false,
                            al,
                            "al r7 r2 minus 92 PreIndex",
                            "al_r7_r2_minus_92_PreIndex"},
                           {{al, r7, r3, plus, 203, PreIndex},
                            false,
                            al,
                            "al r7 r3 plus 203 PreIndex",
                            "al_r7_r3_plus_203_PreIndex"},
                           {{al, r5, r12, minus, 28, PostIndex},
                            false,
                            al,
                            "al r5 r12 minus 28 PostIndex",
                            "al_r5_r12_minus_28_PostIndex"},
                           {{al, r14, r4, plus, 149, PostIndex},
                            false,
                            al,
                            "al r14 r4 plus 149 PostIndex",
                            "al_r14_r4_plus_149_PostIndex"},
                           {{al, r2, r8, plus, 51, PostIndex},
                            false,
                            al,
                            "al r2 r8 plus 51 PostIndex",
                            "al_r2_r8_plus_51_PostIndex"},
                           {{al, r11, r2, plus, 122, PreIndex},
                            false,
                            al,
                            "al r11 r2 plus 122 PreIndex",
                            "al_r11_r2_plus_122_PreIndex"},
                           {{al, r3, r8, plus, 127, PostIndex},
                            false,
                            al,
                            "al r3 r8 plus 127 PostIndex",
                            "al_r3_r8_plus_127_PostIndex"},
                           {{al, r10, r4, plus, 77, PreIndex},
                            false,
                            al,
                            "al r10 r4 plus 77 PreIndex",
                            "al_r10_r4_plus_77_PreIndex"},
                           {{al, r13, r6, plus, 245, PostIndex},
                            false,
                            al,
                            "al r13 r6 plus 245 PostIndex",
                            "al_r13_r6_plus_245_PostIndex"},
                           {{al, r1, r3, minus, 51, PostIndex},
                            false,
                            al,
                            "al r1 r3 minus 51 PostIndex",
                            "al_r1_r3_minus_51_PostIndex"},
                           {{al, r11, r2, plus, 55, PreIndex},
                            false,
                            al,
                            "al r11 r2 plus 55 PreIndex",
                            "al_r11_r2_plus_55_PreIndex"},
                           {{al, r10, r3, minus, 27, PostIndex},
                            false,
                            al,
                            "al r10 r3 minus 27 PostIndex",
                            "al_r10_r3_minus_27_PostIndex"},
                           {{al, r6, r11, minus, 237, PreIndex},
                            false,
                            al,
                            "al r6 r11 minus 237 PreIndex",
                            "al_r6_r11_minus_237_PreIndex"},
                           {{al, r10, r7, plus, 135, PostIndex},
                            false,
                            al,
                            "al r10 r7 plus 135 PostIndex",
                            "al_r10_r7_plus_135_PostIndex"},
                           {{al, r2, r9, minus, 164, PostIndex},
                            false,
                            al,
                            "al r2 r9 minus 164 PostIndex",
                            "al_r2_r9_minus_164_PostIndex"},
                           {{al, r13, r9, plus, 248, PreIndex},
                            false,
                            al,
                            "al r13 r9 plus 248 PreIndex",
                            "al_r13_r9_plus_248_PreIndex"},
                           {{al, r13, r6, minus, 126, PostIndex},
                            false,
                            al,
                            "al r13 r6 minus 126 PostIndex",
                            "al_r13_r6_minus_126_PostIndex"},
                           {{al, r11, r0, plus, 97, PreIndex},
                            false,
                            al,
                            "al r11 r0 plus 97 PreIndex",
                            "al_r11_r0_plus_97_PreIndex"},
                           {{al, r6, r7, minus, 51, PreIndex},
                            false,
                            al,
                            "al r6 r7 minus 51 PreIndex",
                            "al_r6_r7_minus_51_PreIndex"},
                           {{al, r12, r10, minus, 25, PostIndex},
                            false,
                            al,
                            "al r12 r10 minus 25 PostIndex",
                            "al_r12_r10_minus_25_PostIndex"},
                           {{al, r9, r5, plus, 101, PostIndex},
                            false,
                            al,
                            "al r9 r5 plus 101 PostIndex",
                            "al_r9_r5_plus_101_PostIndex"},
                           {{al, r2, r6, minus, 123, PostIndex},
                            false,
                            al,
                            "al r2 r6 minus 123 PostIndex",
                            "al_r2_r6_minus_123_PostIndex"},
                           {{al, r13, r11, minus, 185, PostIndex},
                            false,
                            al,
                            "al r13 r11 minus 185 PostIndex",
                            "al_r13_r11_minus_185_PostIndex"},
                           {{al, r0, r14, plus, 127, PostIndex},
                            false,
                            al,
                            "al r0 r14 plus 127 PostIndex",
                            "al_r0_r14_plus_127_PostIndex"},
                           {{al, r8, r6, minus, 103, PreIndex},
                            false,
                            al,
                            "al r8 r6 minus 103 PreIndex",
                            "al_r8_r6_minus_103_PreIndex"},
                           {{al, r6, r2, minus, 116, PostIndex},
                            false,
                            al,
                            "al r6 r2 minus 116 PostIndex",
                            "al_r6_r2_minus_116_PostIndex"},
                           {{al, r3, r5, plus, 9, PostIndex},
                            false,
                            al,
                            "al r3 r5 plus 9 PostIndex",
                            "al_r3_r5_plus_9_PostIndex"},
                           {{al, r11, r9, minus, 228, PostIndex},
                            false,
                            al,
                            "al r11 r9 minus 228 PostIndex",
                            "al_r11_r9_minus_228_PostIndex"},
                           {{al, r9, r1, plus, 171, PreIndex},
                            false,
                            al,
                            "al r9 r1 plus 171 PreIndex",
                            "al_r9_r1_plus_171_PreIndex"},
                           {{al, r11, r0, minus, 105, PreIndex},
                            false,
                            al,
                            "al r11 r0 minus 105 PreIndex",
                            "al_r11_r0_minus_105_PreIndex"},
                           {{al, r7, r4, plus, 188, PreIndex},
                            false,
                            al,
                            "al r7 r4 plus 188 PreIndex",
                            "al_r7_r4_plus_188_PreIndex"},
                           {{al, r8, r5, plus, 129, PreIndex},
                            false,
                            al,
                            "al r8 r5 plus 129 PreIndex",
                            "al_r8_r5_plus_129_PreIndex"},
                           {{al, r6, r5, plus, 105, PostIndex},
                            false,
                            al,
                            "al r6 r5 plus 105 PostIndex",
                            "al_r6_r5_plus_105_PostIndex"},
                           {{al, r4, r2, plus, 39, PreIndex},
                            false,
                            al,
                            "al r4 r2 plus 39 PreIndex",
                            "al_r4_r2_plus_39_PreIndex"},
                           {{al, r12, r13, plus, 164, PreIndex},
                            false,
                            al,
                            "al r12 r13 plus 164 PreIndex",
                            "al_r12_r13_plus_164_PreIndex"},
                           {{al, r11, r3, plus, 215, PreIndex},
                            false,
                            al,
                            "al r11 r3 plus 215 PreIndex",
                            "al_r11_r3_plus_215_PreIndex"},
                           {{al, r3, r14, minus, 147, PostIndex},
                            false,
                            al,
                            "al r3 r14 minus 147 PostIndex",
                            "al_r3_r14_minus_147_PostIndex"},
                           {{al, r13, r14, plus, 88, PostIndex},
                            false,
                            al,
                            "al r13 r14 plus 88 PostIndex",
                            "al_r13_r14_plus_88_PostIndex"},
                           {{al, r5, r10, minus, 159, PostIndex},
                            false,
                            al,
                            "al r5 r10 minus 159 PostIndex",
                            "al_r5_r10_minus_159_PostIndex"},
                           {{al, r6, r12, plus, 219, PostIndex},
                            false,
                            al,
                            "al r6 r12 plus 219 PostIndex",
                            "al_r6_r12_plus_219_PostIndex"},
                           {{al, r9, r12, minus, 5, PostIndex},
                            false,
                            al,
                            "al r9 r12 minus 5 PostIndex",
                            "al_r9_r12_minus_5_PostIndex"},
                           {{al, r11, r13, minus, 90, PreIndex},
                            false,
                            al,
                            "al r11 r13 minus 90 PreIndex",
                            "al_r11_r13_minus_90_PreIndex"},
                           {{al, r11, r2, minus, 89, PostIndex},
                            false,
                            al,
                            "al r11 r2 minus 89 PostIndex",
                            "al_r11_r2_minus_89_PostIndex"},
                           {{al, r2, r13, plus, 130, PostIndex},
                            false,
                            al,
                            "al r2 r13 plus 130 PostIndex",
                            "al_r2_r13_plus_130_PostIndex"},
                           {{al, r6, r11, plus, 31, PreIndex},
                            false,
                            al,
                            "al r6 r11 plus 31 PreIndex",
                            "al_r6_r11_plus_31_PreIndex"},
                           {{al, r12, r14, plus, 177, PostIndex},
                            false,
                            al,
                            "al r12 r14 plus 177 PostIndex",
                            "al_r12_r14_plus_177_PostIndex"},
                           {{al, r0, r9, plus, 9, PreIndex},
                            false,
                            al,
                            "al r0 r9 plus 9 PreIndex",
                            "al_r0_r9_plus_9_PreIndex"},
                           {{al, r9, r7, plus, 134, PreIndex},
                            false,
                            al,
                            "al r9 r7 plus 134 PreIndex",
                            "al_r9_r7_plus_134_PreIndex"},
                           {{al, r11, r4, minus, 1, PostIndex},
                            false,
                            al,
                            "al r11 r4 minus 1 PostIndex",
                            "al_r11_r4_minus_1_PostIndex"},
                           {{al, r5, r4, minus, 41, PreIndex},
                            false,
                            al,
                            "al r5 r4 minus 41 PreIndex",
                            "al_r5_r4_minus_41_PreIndex"},
                           {{al, r4, r14, plus, 31, PostIndex},
                            false,
                            al,
                            "al r4 r14 plus 31 PostIndex",
                            "al_r4_r14_plus_31_PostIndex"},
                           {{al, r12, r2, plus, 124, PostIndex},
                            false,
                            al,
                            "al r12 r2 plus 124 PostIndex",
                            "al_r12_r2_plus_124_PostIndex"},
                           {{al, r8, r1, minus, 160, PostIndex},
                            false,
                            al,
                            "al r8 r1 minus 160 PostIndex",
                            "al_r8_r1_minus_160_PostIndex"},
                           {{al, r12, r3, plus, 151, PostIndex},
                            false,
                            al,
                            "al r12 r3 plus 151 PostIndex",
                            "al_r12_r3_plus_151_PostIndex"},
                           {{al, r11, r12, plus, 12, PreIndex},
                            false,
                            al,
                            "al r11 r12 plus 12 PreIndex",
                            "al_r11_r12_plus_12_PreIndex"},
                           {{al, r12, r9, plus, 75, PostIndex},
                            false,
                            al,
                            "al r12 r9 plus 75 PostIndex",
                            "al_r12_r9_plus_75_PostIndex"},
                           {{al, r0, r9, minus, 80, PostIndex},
                            false,
                            al,
                            "al r0 r9 minus 80 PostIndex",
                            "al_r0_r9_minus_80_PostIndex"},
                           {{al, r12, r2, minus, 185, PreIndex},
                            false,
                            al,
                            "al r12 r2 minus 185 PreIndex",
                            "al_r12_r2_minus_185_PreIndex"},
                           {{al, r5, r2, minus, 115, PostIndex},
                            false,
                            al,
                            "al r5 r2 minus 115 PostIndex",
                            "al_r5_r2_minus_115_PostIndex"},
                           {{al, r8, r7, plus, 82, PreIndex},
                            false,
                            al,
                            "al r8 r7 plus 82 PreIndex",
                            "al_r8_r7_plus_82_PreIndex"},
                           {{al, r7, r8, minus, 119, PreIndex},
                            false,
                            al,
                            "al r7 r8 minus 119 PreIndex",
                            "al_r7_r8_minus_119_PreIndex"},
                           {{al, r14, r10, plus, 38, PostIndex},
                            false,
                            al,
                            "al r14 r10 plus 38 PostIndex",
                            "al_r14_r10_plus_38_PostIndex"},
                           {{al, r7, r13, plus, 96, PostIndex},
                            false,
                            al,
                            "al r7 r13 plus 96 PostIndex",
                            "al_r7_r13_plus_96_PostIndex"},
                           {{al, r6, r2, plus, 253, PreIndex},
                            false,
                            al,
                            "al r6 r2 plus 253 PreIndex",
                            "al_r6_r2_plus_253_PreIndex"},
                           {{al, r7, r10, plus, 68, PreIndex},
                            false,
                            al,
                            "al r7 r10 plus 68 PreIndex",
                            "al_r7_r10_plus_68_PreIndex"},
                           {{al, r0, r9, plus, 182, PostIndex},
                            false,
                            al,
                            "al r0 r9 plus 182 PostIndex",
                            "al_r0_r9_plus_182_PostIndex"},
                           {{al, r8, r14, plus, 153, PreIndex},
                            false,
                            al,
                            "al r8 r14 plus 153 PreIndex",
                            "al_r8_r14_plus_153_PreIndex"},
                           {{al, r7, r11, plus, 69, PreIndex},
                            false,
                            al,
                            "al r7 r11 plus 69 PreIndex",
                            "al_r7_r11_plus_69_PreIndex"},
                           {{al, r0, r4, plus, 249, PreIndex},
                            false,
                            al,
                            "al r0 r4 plus 249 PreIndex",
                            "al_r0_r4_plus_249_PreIndex"},
                           {{al, r7, r2, plus, 65, PreIndex},
                            false,
                            al,
                            "al r7 r2 plus 65 PreIndex",
                            "al_r7_r2_plus_65_PreIndex"},
                           {{al, r4, r10, plus, 228, PostIndex},
                            false,
                            al,
                            "al r4 r10 plus 228 PostIndex",
                            "al_r4_r10_plus_228_PostIndex"},
                           {{al, r5, r0, minus, 94, PostIndex},
                            false,
                            al,
                            "al r5 r0 minus 94 PostIndex",
                            "al_r5_r0_minus_94_PostIndex"},
                           {{al, r10, r3, minus, 131, PreIndex},
                            false,
                            al,
                            "al r10 r3 minus 131 PreIndex",
                            "al_r10_r3_minus_131_PreIndex"},
                           {{al, r9, r14, plus, 191, PreIndex},
                            false,
                            al,
                            "al r9 r14 plus 191 PreIndex",
                            "al_r9_r14_plus_191_PreIndex"},
                           {{al, r3, r1, minus, 114, PostIndex},
                            false,
                            al,
                            "al r3 r1 minus 114 PostIndex",
                            "al_r3_r1_minus_114_PostIndex"},
                           {{al, r6, r4, plus, 123, PreIndex},
                            false,
                            al,
                            "al r6 r4 plus 123 PreIndex",
                            "al_r6_r4_plus_123_PreIndex"},
                           {{al, r12, r6, minus, 39, PreIndex},
                            false,
                            al,
                            "al r12 r6 minus 39 PreIndex",
                            "al_r12_r6_minus_39_PreIndex"},
                           {{al, r3, r11, minus, 142, PostIndex},
                            false,
                            al,
                            "al r3 r11 minus 142 PostIndex",
                            "al_r3_r11_minus_142_PostIndex"},
                           {{al, r0, r11, minus, 216, PostIndex},
                            false,
                            al,
                            "al r0 r11 minus 216 PostIndex",
                            "al_r0_r11_minus_216_PostIndex"},
                           {{al, r9, r5, minus, 153, PostIndex},
                            false,
                            al,
                            "al r9 r5 minus 153 PostIndex",
                            "al_r9_r5_minus_153_PostIndex"},
                           {{al, r12, r1, minus, 49, PostIndex},
                            false,
                            al,
                            "al r12 r1 minus 49 PostIndex",
                            "al_r12_r1_minus_49_PostIndex"},
                           {{al, r9, r6, plus, 218, PreIndex},
                            false,
                            al,
                            "al r9 r6 plus 218 PreIndex",
                            "al_r9_r6_plus_218_PreIndex"},
                           {{al, r11, r6, minus, 34, PostIndex},
                            false,
                            al,
                            "al r11 r6 minus 34 PostIndex",
                            "al_r11_r6_minus_34_PostIndex"},
                           {{al, r10, r7, plus, 152, PreIndex},
                            false,
                            al,
                            "al r10 r7 plus 152 PreIndex",
                            "al_r10_r7_plus_152_PreIndex"},
                           {{al, r8, r5, minus, 180, PostIndex},
                            false,
                            al,
                            "al r8 r5 minus 180 PostIndex",
                            "al_r8_r5_minus_180_PostIndex"},
                           {{al, r0, r11, plus, 236, PostIndex},
                            false,
                            al,
                            "al r0 r11 plus 236 PostIndex",
                            "al_r0_r11_plus_236_PostIndex"},
                           {{al, r3, r2, plus, 107, PostIndex},
                            false,
                            al,
                            "al r3 r2 plus 107 PostIndex",
                            "al_r3_r2_plus_107_PostIndex"},
                           {{al, r6, r14, plus, 207, PreIndex},
                            false,
                            al,
                            "al r6 r14 plus 207 PreIndex",
                            "al_r6_r14_plus_207_PreIndex"},
                           {{al, r11, r3, minus, 146, PostIndex},
                            false,
                            al,
                            "al r11 r3 minus 146 PostIndex",
                            "al_r11_r3_minus_146_PostIndex"},
                           {{al, r7, r9, minus, 145, PreIndex},
                            false,
                            al,
                            "al r7 r9 minus 145 PreIndex",
                            "al_r7_r9_minus_145_PreIndex"},
                           {{al, r5, r2, minus, 30, PostIndex},
                            false,
                            al,
                            "al r5 r2 minus 30 PostIndex",
                            "al_r5_r2_minus_30_PostIndex"},
                           {{al, r6, r5, plus, 241, PostIndex},
                            false,
                            al,
                            "al r6 r5 plus 241 PostIndex",
                            "al_r6_r5_plus_241_PostIndex"},
                           {{al, r10, r13, minus, 218, PostIndex},
                            false,
                            al,
                            "al r10 r13 minus 218 PostIndex",
                            "al_r10_r13_minus_218_PostIndex"},
                           {{al, r8, r11, minus, 173, PostIndex},
                            false,
                            al,
                            "al r8 r11 minus 173 PostIndex",
                            "al_r8_r11_minus_173_PostIndex"},
                           {{al, r10, r3, minus, 44, PostIndex},
                            false,
                            al,
                            "al r10 r3 minus 44 PostIndex",
                            "al_r10_r3_minus_44_PostIndex"},
                           {{al, r1, r3, minus, 233, PostIndex},
                            false,
                            al,
                            "al r1 r3 minus 233 PostIndex",
                            "al_r1_r3_minus_233_PostIndex"},
                           {{al, r6, r7, minus, 227, PostIndex},
                            false,
                            al,
                            "al r6 r7 minus 227 PostIndex",
                            "al_r6_r7_minus_227_PostIndex"},
                           {{al, r12, r0, plus, 178, PreIndex},
                            false,
                            al,
                            "al r12 r0 plus 178 PreIndex",
                            "al_r12_r0_plus_178_PreIndex"},
                           {{al, r6, r10, plus, 134, PreIndex},
                            false,
                            al,
                            "al r6 r10 plus 134 PreIndex",
                            "al_r6_r10_plus_134_PreIndex"},
                           {{al, r2, r10, minus, 227, PostIndex},
                            false,
                            al,
                            "al r2 r10 minus 227 PostIndex",
                            "al_r2_r10_minus_227_PostIndex"},
                           {{al, r12, r9, minus, 174, PostIndex},
                            false,
                            al,
                            "al r12 r9 minus 174 PostIndex",
                            "al_r12_r9_minus_174_PostIndex"},
                           {{al, r6, r3, minus, 109, PostIndex},
                            false,
                            al,
                            "al r6 r3 minus 109 PostIndex",
                            "al_r6_r3_minus_109_PostIndex"},
                           {{al, r1, r6, minus, 30, PostIndex},
                            false,
                            al,
                            "al r1 r6 minus 30 PostIndex",
                            "al_r1_r6_minus_30_PostIndex"},
                           {{al, r2, r9, plus, 48, PreIndex},
                            false,
                            al,
                            "al r2 r9 plus 48 PreIndex",
                            "al_r2_r9_plus_48_PreIndex"},
                           {{al, r13, r12, plus, 4, PreIndex},
                            false,
                            al,
                            "al r13 r12 plus 4 PreIndex",
                            "al_r13_r12_plus_4_PreIndex"},
                           {{al, r2, r8, plus, 241, PostIndex},
                            false,
                            al,
                            "al r2 r8 plus 241 PostIndex",
                            "al_r2_r8_plus_241_PostIndex"},
                           {{al, r14, r3, plus, 135, PreIndex},
                            false,
                            al,
                            "al r14 r3 plus 135 PreIndex",
                            "al_r14_r3_plus_135_PreIndex"},
                           {{al, r3, r4, minus, 161, PostIndex},
                            false,
                            al,
                            "al r3 r4 minus 161 PostIndex",
                            "al_r3_r4_minus_161_PostIndex"},
                           {{al, r7, r1, plus, 145, PreIndex},
                            false,
                            al,
                            "al r7 r1 plus 145 PreIndex",
                            "al_r7_r1_plus_145_PreIndex"},
                           {{al, r8, r3, plus, 105, PostIndex},
                            false,
                            al,
                            "al r8 r3 plus 105 PostIndex",
                            "al_r8_r3_plus_105_PostIndex"},
                           {{al, r0, r8, plus, 218, PreIndex},
                            false,
                            al,
                            "al r0 r8 plus 218 PreIndex",
                            "al_r0_r8_plus_218_PreIndex"},
                           {{al, r9, r3, plus, 210, PostIndex},
                            false,
                            al,
                            "al r9 r3 plus 210 PostIndex",
                            "al_r9_r3_plus_210_PostIndex"},
                           {{al, r10, r1, plus, 228, PreIndex},
                            false,
                            al,
                            "al r10 r1 plus 228 PreIndex",
                            "al_r10_r1_plus_228_PreIndex"},
                           {{al, r2, r0, minus, 85, PostIndex},
                            false,
                            al,
                            "al r2 r0 minus 85 PostIndex",
                            "al_r2_r0_minus_85_PostIndex"},
                           {{al, r0, r1, minus, 62, PreIndex},
                            false,
                            al,
                            "al r0 r1 minus 62 PreIndex",
                            "al_r0_r1_minus_62_PreIndex"},
                           {{al, r7, r6, minus, 150, PreIndex},
                            false,
                            al,
                            "al r7 r6 minus 150 PreIndex",
                            "al_r7_r6_minus_150_PreIndex"},
                           {{al, r5, r3, minus, 113, PreIndex},
                            false,
                            al,
                            "al r5 r3 minus 113 PreIndex",
                            "al_r5_r3_minus_113_PreIndex"},
                           {{al, r10, r8, minus, 210, PostIndex},
                            false,
                            al,
                            "al r10 r8 minus 210 PostIndex",
                            "al_r10_r8_minus_210_PostIndex"},
                           {{al, r14, r10, plus, 56, PreIndex},
                            false,
                            al,
                            "al r14 r10 plus 56 PreIndex",
                            "al_r14_r10_plus_56_PreIndex"},
                           {{al, r7, r4, plus, 55, PreIndex},
                            false,
                            al,
                            "al r7 r4 plus 55 PreIndex",
                            "al_r7_r4_plus_55_PreIndex"}};

// These headers each contain an array of `TestResult` with the reference output
// values. The reference arrays are names `kReference{mnemonic}`.
#include "aarch32/traces/assembler-cond-rd-memop-immediate-512-ldrh-a32.h"
#include "aarch32/traces/assembler-cond-rd-memop-immediate-512-ldrsb-a32.h"
#include "aarch32/traces/assembler-cond-rd-memop-immediate-512-ldrsh-a32.h"
#include "aarch32/traces/assembler-cond-rd-memop-immediate-512-strh-a32.h"


// The maximum number of errors to report in detail for each test.
const unsigned kErrorReportLimit = 8;

typedef void (MacroAssembler::*Fn)(Condition cond,
                                   Register rd,
                                   const MemOperand& memop);

void TestHelper(Fn instruction,
                const char* mnemonic,
                const TestResult reference[]) {
  unsigned total_error_count = 0;
  MacroAssembler masm(BUF_SIZE);

  masm.UseA32();

  for (unsigned i = 0; i < ARRAY_SIZE(kTests); i++) {
    // Values to pass to the macro-assembler.
    Condition cond = kTests[i].operands.cond;
    Register rd = kTests[i].operands.rd;
    Register rn = kTests[i].operands.rn;
    Sign sign = kTests[i].operands.sign;
    int32_t offset = kTests[i].operands.offset;
    AddrMode addr_mode = kTests[i].operands.addr_mode;
    MemOperand memop(rn, sign, offset, addr_mode);

    int32_t start = masm.GetCursorOffset();
    {
      // We never generate more that 4 bytes, as IT instructions are only
      // allowed for narrow encodings.
      ExactAssemblyScope scope(&masm, 4, ExactAssemblyScope::kMaximumSize);
      if (kTests[i].in_it_block) {
        masm.it(kTests[i].it_condition);
      }
      (masm.*instruction)(cond, rd, memop);
    }
    int32_t end = masm.GetCursorOffset();

    const byte* result_ptr =
        masm.GetBuffer()->GetOffsetAddress<const byte*>(start);
    VIXL_ASSERT(start < end);
    uint32_t result_size = end - start;

    if (Test::generate_test_trace()) {
      // Print the result bytes.
      printf("const byte kInstruction_%s_%s[] = {\n",
             mnemonic,
             kTests[i].identifier);
      for (uint32_t j = 0; j < result_size; j++) {
        if (j == 0) {
          printf("  0x%02" PRIx8, result_ptr[j]);
        } else {
          printf(", 0x%02" PRIx8, result_ptr[j]);
        }
      }
      // This comment is meant to be used by external tools to validate
      // the encoding. We can parse the comment to figure out what
      // instruction this corresponds to.
      if (kTests[i].in_it_block) {
        printf(" // It %s; %s %s\n};\n",
               kTests[i].it_condition.GetName(),
               mnemonic,
               kTests[i].operands_description);
      } else {
        printf(" // %s %s\n};\n", mnemonic, kTests[i].operands_description);
      }
    } else {
      // Check we've emitted the exact same encoding as present in the
      // trace file. Only print up to `kErrorReportLimit` errors.
      if (((result_size != reference[i].size) ||
           (memcmp(result_ptr, reference[i].encoding, reference[i].size) !=
            0)) &&
          (++total_error_count <= kErrorReportLimit)) {
        printf("Error when testing \"%s\" with operands \"%s\":\n",
               mnemonic,
               kTests[i].operands_description);
        printf("  Expected: ");
        for (uint32_t j = 0; j < reference[i].size; j++) {
          if (j == 0) {
            printf("0x%02" PRIx8, reference[i].encoding[j]);
          } else {
            printf(", 0x%02" PRIx8, reference[i].encoding[j]);
          }
        }
        printf("\n");
        printf("  Found:    ");
        for (uint32_t j = 0; j < result_size; j++) {
          if (j == 0) {
            printf("0x%02" PRIx8, result_ptr[j]);
          } else {
            printf(", 0x%02" PRIx8, result_ptr[j]);
          }
        }
        printf("\n");
      }
    }
  }

  masm.FinalizeCode();

  if (Test::generate_test_trace()) {
    // Finalize the trace file by writing the final `TestResult` array
    // which links all generated instruction encodings.
    printf("const TestResult kReference%s[] = {\n", mnemonic);
    for (unsigned i = 0; i < ARRAY_SIZE(kTests); i++) {
      printf("  {\n");
      printf("    ARRAY_SIZE(kInstruction_%s_%s),\n",
             mnemonic,
             kTests[i].identifier);
      printf("    kInstruction_%s_%s,\n", mnemonic, kTests[i].identifier);
      printf("  },\n");
    }
    printf("};\n");
  } else {
    if (total_error_count > kErrorReportLimit) {
      printf("%u other errors follow.\n",
             total_error_count - kErrorReportLimit);
    }
    // Crash if the test failed.
    VIXL_CHECK(total_error_count == 0);
  }
}

// Instantiate tests for each instruction in the list.
#define TEST(mnemonic)                                                      \
  void Test_##mnemonic() {                                                  \
    TestHelper(&MacroAssembler::mnemonic, #mnemonic, kReference##mnemonic); \
  }                                                                         \
  Test test_##mnemonic(                                                     \
      "AARCH32_ASSEMBLER_COND_RD_MEMOP_IMMEDIATE_512_" #mnemonic "_A32",    \
      &Test_##mnemonic);
FOREACH_INSTRUCTION(TEST)
#undef TEST

}  // namespace
#endif

}  // namespace aarch32
}  // namespace vixl
