/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.appinfo;

import com.netflix.appinfo.AmazonInfoConfig;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.discovery.internal.util.Archaius1Utils;

public class Archaius1AmazonInfoConfig
implements AmazonInfoConfig {
    private final DynamicPropertyFactory configInstance;
    private final String namespace;

    public Archaius1AmazonInfoConfig(String namespace) {
        this.namespace = namespace.endsWith(".") ? namespace : namespace + ".";
        this.configInstance = Archaius1Utils.initConfig("eureka-client");
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public boolean shouldLogAmazonMetadataErrors() {
        return this.configInstance.getBooleanProperty(this.namespace + "logAmazonMetadataErrors", false).get();
    }

    @Override
    public int getReadTimeout() {
        return this.configInstance.getIntProperty(this.namespace + "mt.read_timeout", 5000).get();
    }

    @Override
    public int getConnectTimeout() {
        return this.configInstance.getIntProperty(this.namespace + "mt.connect_timeout", 2000).get();
    }

    @Override
    public int getNumRetries() {
        return this.configInstance.getIntProperty(this.namespace + "mt.num_retries", 3).get();
    }

    @Override
    public boolean shouldFailFastOnFirstLoad() {
        return this.configInstance.getBooleanProperty(this.namespace + "mt.fail_fast_on_first_load", true).get();
    }

    @Override
    public boolean shouldValidateInstanceId() {
        return this.configInstance.getBooleanProperty(this.namespace + "validateInstanceId", true).get();
    }
}

