/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.IOException;
import java.util.Map;
import proguard.io.DataEntry;
import proguard.io.DataEntryReader;
import proguard.io.RenamedDataEntry;

public class RenamedDataEntryReader
implements DataEntryReader {
    private final Map nameMap;
    private final DataEntryReader dataEntryReader;
    private final DataEntryReader missingDataEntryReader;

    public RenamedDataEntryReader(Map map, DataEntryReader dataEntryReader) {
        this(map, dataEntryReader, null);
    }

    public RenamedDataEntryReader(Map map, DataEntryReader dataEntryReader, DataEntryReader dataEntryReader2) {
        this.nameMap = map;
        this.dataEntryReader = dataEntryReader;
        this.missingDataEntryReader = dataEntryReader2;
    }

    @Override
    public void read(DataEntry dataEntry) throws IOException {
        String string;
        String string2 = dataEntry.getName();
        if (dataEntry.isDirectory() && string2.length() > 0) {
            string2 = string2 + '/';
        }
        if ((string = (String)this.nameMap.get(string2)) != null) {
            if (dataEntry.isDirectory() && string.length() > 0) {
                string = string.substring(0, string.length() - 1);
            }
            this.dataEntryReader.read(new RenamedDataEntry(dataEntry, string));
        } else if (this.missingDataEntryReader != null) {
            this.missingDataEntryReader.read(dataEntry);
        }
    }
}

